/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 438 $
 * $Date: 2012-03-16 23:02:51 +0800 (Fri, 16 Mar 2012) $
 */
#include "Registration.hpp"

#include "../reg/Components.hpp"
#include "../../gnome/gnome.hpp"
#include "../meta.hpp"

#include "wx/gbsizer.h"
#include "wx/stattext.h"
#include "wx/textctrl.h"
#include "wx/utils.h"
#include "wx/statbmp.h"

using namespace indii;

#ifdef __WXMAC__
/* modal dialogs shouldn't have close button */
#define INDII_REGISTRATION_STYLE wxCAPTION
#else
#define INDII_REGISTRATION_STYLE wxDEFAULT_DIALOG_STYLE
#endif

Registration::Registration(wxWindow* parent, const Components::Component c) :
    wxDialog(parent, wxID_ANY, _("Register"), wxDefaultPosition, wxDefaultSize, INDII_REGISTRATION_STYLE),
    c(c) {
  /* pre-condition */
  assert (c == Components::APP || c == Components::PLUGIN);
  
  static const int PADDING = 8;
      
  int daysLeft = Components::daysLeft();
  wxString message(_(""));
  message.Append(_("You have "));
  if (daysLeft == 1) {
    message.Append(_("only "));
    message = message << daysLeft;
    message.Append(_(" day"));
  } else if (daysLeft > 0 && daysLeft <= 7) {
    message.Append(_("only "));
    message = message << daysLeft;
    message.Append(_(" days"));
  } else {
    message = message << daysLeft;
    message.Append(_(" days"));
  }
  if (daysLeft == 0) {
    message.Append(_(" left in your trial period. You will need to buy a registration code to continue using " PACKAGE_NAME "."));
  } else {
    message.Append(_(" left in your trial period. After this time you will need to buy a registration code to continue using " PACKAGE_NAME "."));
  }

  wxStaticBitmap* bmpKey = new wxStaticBitmap(this, wxID_ANY, *_img_gnome_emblem_web);
  wxStaticText *lblTitle = NULL, *lblDaysLeft = NULL, *lblDesc = NULL, *lblUrl = NULL;
  if (c == Components::APP) {
    if (Components::isActivated(c)) {
	  	lblTitle = new wxStaticText(this, wxID_ANY, _("Your " PACKAGE_NAME " app is already registered"));  
    } else if (Components::isTrial(c)) {
	  	lblTitle = new wxStaticText(this, wxID_ANY, _("Your " PACKAGE_NAME " app is not yet registered"));
      lblDaysLeft = new wxStaticText(this, wxID_ANY, message);
    } else {
      lblTitle = new wxStaticText(this, wxID_ANY, _("The trial period for your " PACKAGE_NAME " app has expired"));
      lblDesc = new wxStaticText(this, wxID_ANY, _("To continue using " PACKAGE_NAME " you will need to buy a registration code."));
    }
  } else {
  	if (Components::isActivated(Components::PLUGIN)) {
	  	lblTitle = new wxStaticText(this, wxID_ANY, _("Your " PACKAGE_NAME " plugin is already registered"));
  	} else if (Components::isActivated(Components::APP)) {
      lblTitle = new wxStaticText(this, wxID_ANY, _("Your " PACKAGE_NAME " plugin is not yet registered"));
      lblDaysLeft = new wxStaticText(this, wxID_ANY, message);
      lblDesc = new wxStaticText(this, wxID_ANY, _("While you have registered your " PACKAGE_NAME " app, your registration code is not valid for the " PACKAGE_NAME " plugin. You can buy a new registration code for the plugin and enter it here to register."));
    } else if (Components::isTrial(c)) {
	  	lblTitle = new wxStaticText(this, wxID_ANY, _("Your " PACKAGE_NAME " plugin is not yet registered"));
      lblDaysLeft = new wxStaticText(this, wxID_ANY, message);
    } else {
      lblTitle = new wxStaticText(this, wxID_ANY, _("The trial period for your " PACKAGE_NAME " plugin has expired"));
      lblDesc = new wxStaticText(this, wxID_ANY, _("To continue using " PACKAGE_NAME " you will need to buy a registration code."));
    }
  }
  wxButton* butUrl = new wxButton(this, ID_BUT_URL, _("Click here to buy a registration code"));
  lblUrl = new wxStaticText(this, wxID_ANY, _("or visit www.indii.org/software/" PACKAGE_TARNAME "/register, and enter it in the text box below."));

  /* set fonts */
  #ifndef __WXMAC__
  wxFont fntUrl(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT));
  fntUrl.SetUnderlined(true);
  butUrl->SetForegroundColour(*wxBLUE);
  #endif
  #ifndef WX_28
  lblTitle->SetFont(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT).Bold());
  #else
  wxFont fntTitle(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT));
  fntTitle.SetWeight(wxFONTWEIGHT_BOLD);
  lblTitle->SetFont(fntTitle);
  #endif
  if (lblDesc != NULL) lblDesc->SetFont(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT));
  lblUrl->SetFont(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT));
  if (lblDaysLeft != NULL) {
    lblDaysLeft->SetFont(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT));
    if (daysLeft <= 7) {
      lblDaysLeft->SetForegroundColour(*wxRED);
    }
  }

  /* wrapping */
  int width = std::max(lblTitle->GetSize().GetWidth(), butUrl->GetSize().GetWidth());
  if (lblDesc != NULL) lblDesc->Wrap(width);
  lblUrl->Wrap(width);
  if (lblDaysLeft != NULL) lblDaysLeft->Wrap(width);
      
  txtKey = new wxTextCtrl(this, wxID_ANY, wxEmptyString, wxDefaultPosition,
      wxSize(180,-1));

  int row = 0;
  wxGridBagSizer* keySizer = new wxGridBagSizer();
  keySizer->Add(bmpKey, wxGBPosition(0,0), wxDefaultSpan, wxALL|wxALIGN_CENTRE_VERTICAL, PADDING);
  keySizer->Add(txtKey, wxGBPosition(0,1), wxDefaultSpan, wxALL|wxALIGN_CENTRE_VERTICAL, PADDING);

  wxGridBagSizer* sizer = new wxGridBagSizer();
  sizer->Add(lblTitle, wxGBPosition(row++,0), wxDefaultSpan, wxALL|wxEXPAND, PADDING);

  if (lblDaysLeft != NULL) {
    sizer->Add(lblDaysLeft, wxGBPosition(row++,0), wxDefaultSpan, wxALL|wxEXPAND, PADDING);
  }
  if (lblDesc != NULL) {
    sizer->Add(lblDesc, wxGBPosition(row++,0), wxDefaultSpan, wxALL|wxEXPAND, PADDING);
  }
  sizer->Add(butUrl, wxGBPosition(row++,0), wxDefaultSpan, wxALL|wxALIGN_CENTRE_HORIZONTAL, PADDING);
  if (lblUrl != NULL) {
    sizer->Add(lblUrl, wxGBPosition(row++,0), wxDefaultSpan, wxALL|wxALIGN_CENTRE_HORIZONTAL|wxEXPAND, PADDING);
  }
  sizer->Add(keySizer, wxGBPosition(row++,0), wxDefaultSpan, wxALIGN_CENTRE_HORIZONTAL);

  wxStdDialogButtonSizer* buttonSizer = this->CreateStdDialogButtonSizer(0);
  buttonSizer->SetAffirmativeButton(new wxButton(this, wxID_OK, _("Register now")));
  buttonSizer->SetCancelButton(new wxButton(this, wxID_CANCEL, _("Register later")));
      buttonSizer->Realize();
  sizer->Add(buttonSizer, wxGBPosition(row++,0), wxGBSpan(1,2), wxALL|wxEXPAND, PADDING);

  SetSizerAndFit(sizer);
}

void Registration::OnButtonUrl(wxCommandEvent& evt) {
  wxLaunchDefaultBrowser(_("http://www.indii.org/software/" PACKAGE_TARNAME "/register"));
}

void Registration::OnButtonOk(wxCommandEvent& evt) {
  if (Components::activate(c, txtKey->GetValue())) {
    EndModal(wxID_OK);
  }
}

void Registration::OnButtonCancel(wxCommandEvent& evt) {
  EndModal(wxID_CANCEL);
}

void Registration::OnClose(wxCloseEvent& evt) {
  Destroy();
}

BEGIN_EVENT_TABLE(Registration, wxDialog)
EVT_CLOSE(Registration::OnClose)
EVT_BUTTON(ID_BUT_URL, Registration::OnButtonUrl)
EVT_BUTTON(wxID_OK, Registration::OnButtonOk)
EVT_BUTTON(wxID_CANCEL, Registration::OnButtonCancel)
END_EVENT_TABLE()
