/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 363 $
 * $Date: 2012-01-22 18:45:43 +0800 (Sun, 22 Jan 2012) $
 */
#ifndef INDII_GUI_REGISTRATION_HPP
#define INDII_GUI_REGISTRATION_HPP

#include "../reg/Components.hpp"

#include "wx/dialog.h"
#include "wx/textctrl.h"

namespace indii {
/**
 * Photoshop registration dialog.
 */
class Registration : public wxDialog {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   */
  Registration(wxWindow* parent, const indii::Components::Component c);

  /**
   * URL button event.
   */
  void OnButtonUrl(wxCommandEvent& evt);

  /**
   * OK button event.
   */
  void OnButtonOk(wxCommandEvent& evt);

  /**
   * Cancel button event.
   */
  void OnButtonCancel(wxCommandEvent& evt);

  /**
   * Close.
   */
  void OnClose(wxCloseEvent& evt);

private:
  /**
   * Key textbox.
   */
  wxTextCtrl* txtKey;

  /**
   * Component context.
   */
  indii::Components::Component c;

  /*
   * Control ids.
   */
  enum ID {
    ID_BUT_URL = 987
  };

  DECLARE_EVENT_TABLE()

};
}

#endif
