/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 366 $
 * $Date: 2012-01-24 19:19:19 +0800 (Tue, 24 Jan 2012) $
 */
#ifndef INDII_TINT_GUI_TINTWINDOW_HPP
#define INDII_TINT_GUI_TINTWINDOW_HPP

#include "ThumbPane.hpp"
#include "PreProcessPane.hpp"
#include "PostProcessPane.hpp"
#include "TintDocument.hpp"
#include "../model/ClusterModel.hpp"
#include "../../image/ImageResource.hpp"
#include "../../gui/Window.hpp"
#include "../../gui/WindowObserver.hpp"
#include "../../gui/PreviewPane.hpp"
#include "../../gui/ChannelMixerPane.hpp"

#include "wx/frame.h"
#include "wx/aui/aui.h"

namespace indii {
/**
 * Main window.
 */
class TintWindow : public Window {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param mode Mode of operation.
   * @param obs Enclosing application, if not embedded mode.
   */
  TintWindow(wxWindow* parent, const Mode mode = EMBED,
      WindowObserver* obs = NULL);
  
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param res Image resource.
   * @param model Cluster model.
   * @param mode Mode of operation.
   * @param obs Enclosing application, if not embedded mode.
   */
  TintWindow(wxWindow* parent, ImageResource* res, ClusterModel* model,
      const Mode mode = EMBED, WindowObserver* obs = NULL);

  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param path Path of image to open.
   * @param mode Mode of operation.
   * @param obs Enclosing application, if not embedded mode.
   */
  TintWindow(wxWindow* parent, const wxString& path, const Mode = STANDALONE,
      WindowObserver* obs = NULL);

  virtual Document* open(const wxString& file);
  virtual void layoutDefault();
  virtual void setModel(Model* model);
  virtual bool isShown(const unsigned i);
  virtual void show(const unsigned i, const bool show);

protected:
  virtual void initPanes();
  using Window::enable;
  virtual void enable(const bool enable);

private:
  /**
   * Enclosing application.
   */
  WindowObserver* obs;

  /*
   * Panes.
   */
  ThumbPane* thumbPane;
  PreProcessPane* prePane;
  PostProcessPane* postPane;
  ChannelMixerPane* mixerPane;

  /**
   * Ids of messages displayed in the info bar.
   */
  enum {
    /**
     * Instructions on how to use interface.
     */
    MSG_INTERFACE
  };
  
  DECLARE_EVENT_TABLE()
};
}

#endif
