INCLUDE(PackageArchDefineStandardCompileVars)


#
# Helper macros
#


MACRO(PACKAGE_ARCH_SET_LANGUAGE_STRONG_WARNING_FLAGS LANG)

  DUAL_SCOPE_SET(CMAKE_${LANG}_FLAGS
    "${${LANG}_STRONG_COMPILE_WARNING_FLAGS} ${CMAKE_${LANG}_FLAGS}")

  IF(${PROJECT_NAME}_VERBOSE_CONFIGURE)
    MESSAGE(STATUS "Adding strong ${LANG} warning flags \"${${LANG}_STRONG_COMPILE_WARNING_FLAGS}\"")
    PRINT_VAR(CMAKE_${LANG}_FLAGS)
  ENDIF()

ENDMACRO()

FUNCTION(PACKAGE_ARCH_SETUP_STRONG_COMPILE_WARNINGS  ENABLE_SHADOWING_WARNINGS)

  #
  # Setup and general flags
  #

  PACKAGE_ARCH_DEFINE_STANDARD_COMPILE_FLAGS_VARS(${ENABLE_SHADOWING_WARNINGS})

  #
  # C compiler options
  #

  ASSERT_DEFINED(${PROJECT_NAME}_ENABLE_C CMAKE_C_COMPILER_ID)
  IF (${PROJECT_NAME}_ENABLE_C
    AND CMAKE_C_COMPILER_ID STREQUAL "GNU"
    AND ${PROJECT_NAME}_ENABLE_STRONG_C_COMPILE_WARNINGS
    )
    PACKAGE_ARCH_SET_LANGUAGE_STRONG_WARNING_FLAGS(C)
  ENDIF()

  #
  # C++ compiler options
  #

  ASSERT_DEFINED(${PROJECT_NAME}_ENABLE_CXX CMAKE_CXX_COMPILER_ID)
  IF (${PROJECT_NAME}_ENABLE_CXX
    AND CMAKE_CXX_COMPILER_ID STREQUAL "GNU"
    AND ${PROJECT_NAME}_ENABLE_STRONG_CXX_COMPILE_WARNINGS
    )
    PACKAGE_ARCH_SET_LANGUAGE_STRONG_WARNING_FLAGS(CXX)
  ENDIF()

  #
  # Fortran compiler options
  #

  ASSERT_DEFINED(${PROJECT_NAME}_ENABLE_Fortran)
  IF (${PROJECT_NAME}_ENABLE_Fortran AND CMAKE_CXX_COMPILER_ID STREQUAL "GNU")
    # ToDo: Add Fortran warnings?
  ENDIF()
  
ENDFUNCTION()
