/*@HEADER
// ***********************************************************************
//
//       Ifpack: Object-Oriented Algebraic Preconditioner Package
//                 Copyright (2009) Sandia Corporation
//
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// Questions? Contact Michael A. Heroux (maherou@sandia.gov)
//
// ***********************************************************************
//@HEADER
*/

/*
   Note: this module contains functionality for reading/writing 
         Euclid's binary io format, and opening and closing files.
         Additional io can be found in in mat_dh_private, which contains
         private functions for reading/writing various matrix and
         vector formats; functions in that module are called by
         public class methods of the Mat_dh and Vec_dh classes.
*/

#ifndef IO_DH
#define IO_DH

#include "euclid_common.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*--------------------------------------------------------------------------
 * open and close files, with error checking
 *--------------------------------------------------------------------------*/
  extern FILE *openFile_dh (const char *filenameIN, const char *modeIN);
  extern void closeFile_dh (FILE * fpIN);

/*---------------------------------------------------------------------------
 * binary io; these are called by functions in mat_dh_private
 *---------------------------------------------------------------------------*/

  bool isSmallEndian ();

/* seq only ?? */
  extern void io_dh_print_ebin_mat_private (int m, int beg_row,
					    int *rp, int *cval, double *aval,
					    int *n2o, int *o2n,
					    Hash_i_dh hash, char *filename);

/* seq only ?? */
  extern void io_dh_read_ebin_mat_private (int *m, int **rp, int **cval,
					   double **aval, char *filename);

/* seq only */
  extern void io_dh_print_ebin_vec_private (int n, int beg_row, double *vals,
					    int *n2o, int *o2n,
					    Hash_i_dh hash, char *filename);
/* seq only */
  extern void io_dh_read_ebin_vec_private (int *n, double **vals,
					   char *filename);

#ifdef __cplusplus
}
#endif

#endif
