/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.CalloutEmitter;
import com.nwalsh.saxon.FormatCallout;
import com.nwalsh.saxon.FormatGraphicCallout;
import com.nwalsh.saxon.FormatTextCallout;
import com.nwalsh.saxon.FormatUnicodeCallout;
import com.nwalsh.saxon.LineCountEmitter;
import com.nwalsh.saxon.NumberLinesEmitter;
import javax.xml.transform.TransformerException;
import org.w3c.dom.NodeList;

public class Verbatim {
    private static boolean foStylesheet = false;
    private static int modulus = 0;
    private static int width = 0;
    private static int startinglinenumber = 1;
    private static String separator = "";
    private static boolean calloutsSetup = false;
    private static int defaultColumn = 60;
    private static String graphicsPath = null;
    private static String graphicsExt = null;
    private static int graphicsMax = 10;
    private static FormatCallout fCallout = null;

    protected static String getVariable(Context context, String string) {
        Value value = null;
        String string2 = null;
        try {
            value = Extensions.evaluate((Context)context, (String)("$" + string));
            string2 = value.asString();
            return string2;
        }
        catch (TransformerException transformerException) {
            System.out.println("Undefined variable: " + string);
            return "";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Undefined variable: " + string);
            return "";
        }
    }

    private static void setupLineNumbering(Context context) {
        modulus = 5;
        width = 3;
        startinglinenumber = 1;
        separator = " ";
        foStylesheet = false;
        String string = null;
        string = Verbatim.getVariable(context, "linenumbering.everyNth");
        try {
            modulus = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$linenumbering.everyNth is not a number: " + string);
        }
        string = Verbatim.getVariable(context, "linenumbering.width");
        try {
            width = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$linenumbering.width is not a number: " + string);
        }
        string = Verbatim.getVariable(context, "linenumbering.startinglinenumber");
        try {
            startinglinenumber = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$linenumbering.startinglinenumber is not a number: " + string);
        }
        separator = string = Verbatim.getVariable(context, "linenumbering.separator");
        string = Verbatim.getVariable(context, "stylesheet.result.type");
        foStylesheet = string.equals("fo");
    }

    public static NodeSetValue numberLines(Context context, NodeSetValue nodeSetValue) {
        FragmentValue fragmentValue = (FragmentValue)nodeSetValue;
        Verbatim.setupLineNumbering(context);
        try {
            LineCountEmitter lineCountEmitter = new LineCountEmitter();
            fragmentValue.replay((Emitter)lineCountEmitter);
            int n = lineCountEmitter.lineCount();
            int n2 = n < modulus ? 1 : modulus;
            double d = Math.log(n) / Math.log(10.0);
            int n3 = (double)width < d + 1.0 ? (int)Math.floor(d + 1.0) : width;
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            NumberLinesEmitter numberLinesEmitter = new NumberLinesEmitter(controller, namePool, startinglinenumber, n2, n3, separator, foStylesheet);
            fragmentValue.replay((Emitter)numberLinesEmitter);
            return numberLinesEmitter.getResultTreeFragment();
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in numberLines");
            return fragmentValue;
        }
    }

    private static void setupCallouts(Context context) {
        NamePool namePool = context.getController().getNamePool();
        boolean bl = false;
        boolean bl2 = false;
        int n = 49;
        int n2 = 0;
        String string = "";
        defaultColumn = 60;
        graphicsPath = null;
        graphicsExt = null;
        graphicsMax = 0;
        foStylesheet = false;
        calloutsSetup = true;
        Object var7_7 = null;
        String string2 = null;
        string2 = Verbatim.getVariable(context, "stylesheet.result.type");
        foStylesheet = string2.equals("fo");
        string2 = Verbatim.getVariable(context, "callout.defaultcolumn");
        try {
            defaultColumn = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$callout.defaultcolumn is not a number: " + string2);
        }
        string2 = Verbatim.getVariable(context, "callout.graphics");
        bl = !string2.equals("0") && !string2.equals("");
        string2 = Verbatim.getVariable(context, "callout.unicode");
        boolean bl3 = bl2 = !string2.equals("0") && !string2.equals("");
        if (bl) {
            graphicsPath = string2 = Verbatim.getVariable(context, "callout.graphics.path");
            graphicsExt = string2 = Verbatim.getVariable(context, "callout.graphics.extension");
            string2 = Verbatim.getVariable(context, "callout.graphics.number.limit");
            try {
                graphicsMax = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$callout.graphics.number.limit is not a number: " + string2);
                graphicsMax = 0;
            }
            fCallout = new FormatGraphicCallout(namePool, graphicsPath, graphicsExt, graphicsMax, foStylesheet);
        } else if (bl2) {
            string2 = Verbatim.getVariable(context, "callout.unicode.start.character");
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$callout.unicode.start.character is not a number: " + string2);
                n = 48;
            }
            string2 = Verbatim.getVariable(context, "callout.unicode.number.limit");
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$callout.unicode.number.limit is not a number: " + string2);
                n = 0;
            }
            string = Verbatim.getVariable(context, "callout.unicode.font");
            if (string == null) {
                string = "";
            }
            fCallout = new FormatUnicodeCallout(namePool, string, n, n2, foStylesheet);
        } else {
            fCallout = new FormatTextCallout(namePool, foStylesheet);
        }
    }

    public static NodeSetValue insertCallouts(Context context, NodeList nodeList, NodeSetValue nodeSetValue) {
        FragmentValue fragmentValue = (FragmentValue)nodeSetValue;
        Verbatim.setupCallouts(context);
        try {
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            CalloutEmitter calloutEmitter = new CalloutEmitter(controller, namePool, defaultColumn, foStylesheet, fCallout);
            calloutEmitter.setupCallouts(nodeList);
            fragmentValue.replay((Emitter)calloutEmitter);
            return calloutEmitter.getResultTreeFragment();
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in insertCallouts");
            return fragmentValue;
        }
    }
}

