//-*-c++-*-
#ifndef TULIP_SIZESPROXY_H
#define TULIP_SIZESPROXY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "PropertyProxy.h"
#include "TemplateFactory.h"
#include "Sizes.h"

class PropertyContext;
/**
 * \defgroup properties
 */ 
/*@{*/
class TLP_SCOPE SizesProxy:public PropertyProxy<SizeType,SizeType, Sizes> { 

  friend class Sizes;

public :
  SizesProxy (SuperGraph *);
  ~SizesProxy();

  Size getMax(SuperGraph *sg=0);
  Size getMin(SuperGraph *sg=0);
  PProxy* clonePrototype(SuperGraph *, std::string );
  void copy( const node, const node, PProxy * );
  void copy( const edge, const edge, PProxy * );
  void scale( const tlp::Vector<float,3>&, SuperGraph *graph=0 );
  void scale( const tlp::Vector<float,3>&, Iterator<node> *, Iterator<edge> *);
protected:
  void reset_handler();
  void resetMinMax();
  virtual void setNodeValue_handler(const node n, const SizeType::RealType &);
  virtual void setEdgeValue_handler(const edge e, const SizeType::RealType &);
  virtual void setAllNodeValue_handler( const SizeType::RealType &);
  virtual void setAllEdgeValue_handler( const SizeType::RealType &);

private:
  stdext::hash_map<unsigned long,Size> max,min;
  stdext::hash_map<unsigned long,bool> minMaxOk;
  void computeMinMax(SuperGraph * sg=NULL);
};
/*@}*/
#endif

