#include <float.h>
#include "tulip/MetaGraphProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/MetaGraph.h"
#include "tulip/PropertyProxy.h"

using namespace std;

//==============================
MetaGraphProxy::MetaGraphProxy (SuperGraph *graph) : 
  PropertyProxy<MetaGraphType,MetaGraphType>(graph) {
  setAllNodeValue(0);
  setAllEdgeValue(0);
}
//==============================
MetaGraphProxy::~MetaGraphProxy() {
  Iterator<node> *it = superGraph->getNodes();
  while(it->hasNext()) {
    node n = it->next();
    if (getNodeValue(n) != 0)
      getNodeValue(n)->removeObserver(this);
  } delete it;
  if (getNodeDefaultValue() != 0) {
    getNodeDefaultValue()->removeObserver(this);
  }
  notifyDestroy();
}
//==============================
void MetaGraphProxy::setAllNodeValue_handler(const MetaGraphType::RealType &graph) {
  //remove all observed graphs
  Iterator<node> *it = superGraph->getNodes();
  while(it->hasNext()) {
    node n = it->next();
    if (getNodeValue(n) != 0)
      getNodeValue(n)->removeObserver(this);
  } delete it;
  set<node> emptySet;
  referencedGraph.setAll(emptySet);
  if (getNodeDefaultValue() != 0) {
    getNodeDefaultValue()->removeObserver(this);
  }
  if (graph == 0) return;
  graph->addObserver(this);
}
//==============================
void MetaGraphProxy::setNodeValue_handler(const node n, const MetaGraphType::RealType &graph) {
  //  cerr << __PRETTY_FUNCTION__ << endl;
  //gestion désabonnement
  SuperGraph * oldGraph = getNodeValue(n); 
  if (oldGraph != 0) {
    //gestion du désabonnement
    set<node> &refs = referencedGraph.getReference(oldGraph->getId()); //use of reference in order to prevent cloninf of the set (Dangerous)
    refs.erase(n);
    if (refs.empty() && oldGraph != getNodeDefaultValue())
      oldGraph->removeObserver(this);
    if (refs.empty())
      referencedGraph.set(oldGraph->getId(), set<node>());
  }
  if (graph == 0) return;
  //Gestion de l'abonnement
  graph->addObserver(this);
  if ( graph != getNodeDefaultValue() ) {
    set<node> &refs = referencedGraph.getReference(graph->getId()); //use of reference in order to prevent cloninf of the set (Dangerous)
    if (refs.empty()) { //Man
      set<node> newSet;
      newSet.insert(n);
      referencedGraph.set(graph->getId(), newSet);
    }
    else 
      refs.insert(n);
  }
}
//==========================================================
void MetaGraphProxy:: destroy(SuperGraph *graph) {
  //test si c'est la valeur par défaut;
  //  cerr << __PRETTY_FUNCTION__ << endl;
  //sinon
  cerr << "Tulip Warning : A graph pointed by metanode(s) has been deleted, the metanode(s) pointer has been set to zero in order to prevent segmentation fault" << endl;
  if (getNodeDefaultValue() == graph) {
    //we must backup old value
    MutableContainer<SuperGraph *> backup;
    backup.setAll(0);
    Iterator<node> *it = superGraph->getNodes();
    while(it->hasNext()) {
      node n = it->next();
      if (getNodeValue(n) != graph)
	backup.set(n.id, getNodeValue(n));
    } delete it;
    setAllNodeValue(0);
    //restore values
    it = superGraph->getNodes();
    while(it->hasNext()) {
      node n = it->next();
      setNodeValue(n, backup.get(n.id));
    } delete it;
  }
  set<node> refs = referencedGraph.get(graph->getId());
  set<node>::const_iterator it = refs.begin();
  for (; it!=refs.end(); ++it) {
    setNodeValue(*it, 0);
  }
}
//============================================================
PProxy* MetaGraphProxy::clonePrototype(SuperGraph * g, std::string n) {
  if( !g )
    return 0;
  MetaGraphProxy * p = g->getLocalProperty<MetaGraphProxy>( n );
  p->setAllNodeValue( getNodeDefaultValue() );
  p->setAllEdgeValue( getEdgeDefaultValue() );
  return p;
}
//=============================================================
void MetaGraphProxy::copy( const node n0, const node n1, PProxy * p ) {
  if( !p )
    return;
  MetaGraphProxy * tp = dynamic_cast<MetaGraphProxy*>(p);
  assert( tp );
  setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void MetaGraphProxy::copy( const edge e0, const edge e1, PProxy * p ) {
  if( !p ) return;
  MetaGraphProxy * tp = dynamic_cast<MetaGraphProxy*>(p);
  assert( tp );
  setEdgeValue( e0, tp->getEdgeValue(e1) );
}
//=============================================================
