%define name	tulip
%define version	3.1.2
%define tulip_version 3.1
%define release 1
%define serial  1
%define prefix	/usr/local
## expansion @pkgdatadir@ are not working
%define datadir %{prefix}/share
%define pkgdatadir %{prefix}/share/tulip

Summary:	A program that allows visualization of huge graphs
Name:		%{name}
Version:	%{version}
Release:	%{release}
Vendor:		David Auber <david.auber@labri.fr>
URL:		http://www.tulip-software.org
Source:		%{name}-%{version}.tar.bz2
License:	GPL
Group:		Applications/Engineering
BuildRoot:	%{_tmppath}/%{name}-%{version}-root
Requires:	qt4 >= 4.2

%description
Tulip software is a system dedicated to the visualization of huge graphs. It manages graphs with a number of elements(nodes and edges) up to 500.000 on a personal computer(PIII 600, with 256mo). Its graph technology architecture enables to do the following things :

  * 3D visualizations
  * 3D modifications
  * Plug-in support for easy evolution
  * Building of clusters and navigation into it
  * Automatic drawing of graphs
  * Automatic clustering of graphs
  * Automatic selection of elements
  * Automatic metric coloration of graphs

%package -n     lib%{name}
Summary:        A library for handling large graphs
Group:		Applications/Engineering
%description -n lib%{name}

%package -n     lib%{name}-ogl
Summary:        A library for displaying graph in a GL context
Group:		Applications/Engineering
Requires:       lib%{name}
%description -n lib%{name}-ogl

%package -n     lib%{name}-qt4
Summary:        A set of Qt Widgets for tulip/tulip-ogl
Group:          Applications/Engineering
Requires:       lib%{name}, lib%{name}-ogl, qt4 >= 4.2
%description -n lib%{name}-qt4

##############################
%prep
%setup -q
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix}

%build
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"
pushd docs
export DISPLAY=:0.0
make html
popd

%install
make DESTDIR="$RPM_BUILD_ROOT" install

%clean
make clean
rm -rf $RPM_BUILD_ROOT

##############################
%files
%defattr(-,root,root)
%{prefix}/bin/tulip
%{prefix}/bin/tulip_check_pl
#%{prefix}/bin/tlprender
%{prefix}/lib/libtulip-pluginsmanager.la
%{prefix}/lib/libtulip-pluginsmanager.so
%{prefix}/lib/libtulip-pluginsmanager-%{tulip_version}.so*
%{prefix}/lib/tlp/bitmaps/logo32x32.bmp
%{prefix}/lib/tlp/bitmaps/logo.bmp
%{prefix}/lib/tlp/bitmaps/logo32x32.ico
%{prefix}/lib/tlp/bitmaps/headerlogo.bmp
%{prefix}/lib/tlp/bitmaps/welcomelogo.bmp
%{prefix}/lib/tlp/bitmaps/logotulip.jpg
%{prefix}/lib/tlp/bitmaps/logolabri.jpg
%{prefix}/lib/tlp/bitmaps/tex_back.png
%{prefix}/lib/tlp/bitmaps/startup.gif
%{prefix}/lib/tlp/bitmaps/parallel_sliders_texture.png
%{prefix}/lib/tlp/bitmaps/parallel_texture.png
%{prefix}/include
%{prefix}/share/tulip

#%{prefix}/lib/tlp/samples

%files -n lib%{name}
%defattr(-,root,root)
%{prefix}/bin/tulip-config
%{prefix}/lib/libtulip.la
%{prefix}/lib/libtulip.so
%{prefix}/lib/libtulip-%{tulip_version}.so*
%{prefix}/lib/tlp/libAdjacencyMatrixImport-%{version}.*
%{prefix}/lib/tlp/libArityMetric-%{version}.*
%{prefix}/lib/tlp/libAutoSize-%{version}.*
%{prefix}/lib/tlp/libBetweennessCentrality-%{version}.*
%{prefix}/lib/tlp/libBiconnectedComponent-%{version}.*
%{prefix}/lib/tlp/libBubbleTree-%{version}.*
%{prefix}/lib/tlp/libCircular-%{version}.*
%{prefix}/lib/tlp/libClusterMetric-%{version}.*
%{prefix}/lib/tlp/libCompleteGraph-%{version}.*
%{prefix}/lib/tlp/libCompleteTree-%{version}.*
%{prefix}/lib/tlp/libConeTreeExtended-%{version}.*
%{prefix}/lib/tlp/libConnectedComponent-%{version}.*
%{prefix}/lib/tlp/libConnectedComponentPacking-%{version}.*
%{prefix}/lib/tlp/libConvolutionClustering-%{version}.*
%{prefix}/lib/tlp/libDagLevelMetric-%{version}.*
%{prefix}/lib/tlp/libDendrogram-%{version}.*
%{prefix}/lib/tlp/libDepthMetric-%{version}.*
%{prefix}/lib/tlp/libDotImport-%{version}.*
%{prefix}/lib/tlp/libEccentricity-%{version}.*
%{prefix}/lib/tlp/libEmbedder-%{version}.*
%{prefix}/lib/tlp/libEnumColorValuesMapping-%{version}.*
%{prefix}/lib/tlp/libEqualValueClustering-%{version}.*
%{prefix}/lib/tlp/libFileSystem-%{version}.*
%{prefix}/lib/tlp/libFitToLabels-%{version}.*
%{prefix}/lib/tlp/libGemLayout-%{version}.*
%{prefix}/lib/tlp/libGMLExport-%{version}.*
%{prefix}/lib/tlp/libGMLImport-%{version}.*
%{prefix}/lib/tlp/libGrid-%{version}.*
%{prefix}/lib/tlp/libHierarchicalClustering-%{version}.*
%{prefix}/lib/tlp/libHierarchicalGraph-%{version}.*
%{prefix}/lib/tlp/libIdMetric-%{version}.*
%{prefix}/lib/tlp/libImprovedWalker-%{version}.*
%{prefix}/lib/tlp/libInducedSubGraphSelection-%{version}.*
%{prefix}/lib/tlp/libKruskal-%{version}.*
%{prefix}/lib/tlp/libLeafMetric-%{version}.*
%{prefix}/lib/tlp/libLoopSelection-%{version}.*
%{prefix}/lib/tlp/libMetricColorMapping-%{version}.*
%{prefix}/lib/tlp/libMetricSizeMapping-%{version}.*
%{prefix}/lib/tlp/libMixedModel-%{version}.*
%{prefix}/lib/tlp/libMultipleSelection-%{version}.*
%{prefix}/lib/tlp/libNodeMetric-%{version}.*
%{prefix}/lib/tlp/libPathLengthMetric-%{version}.*
%{prefix}/lib/tlp/libPlanarGraph-%{version}.*
%{prefix}/lib/tlp/libQuotientClustering-%{version}.*
%{prefix}/lib/tlp/libRandom-%{version}.*
%{prefix}/lib/tlp/libRandomGraph-%{version}.*
%{prefix}/lib/tlp/libRandomMetric-%{version}.*
%{prefix}/lib/tlp/libRandomSimpleGraph-%{version}.*
%{prefix}/lib/tlp/libRandomTree-%{version}.*
%{prefix}/lib/tlp/libRandomTreeGeneral-%{version}.*
%{prefix}/lib/tlp/libReachableSubGraphSelection-%{version}.*
%{prefix}/lib/tlp/libSmallWorldGraph-%{version}.*
%{prefix}/lib/tlp/libSpanningDagSelection-%{version}.*
%{prefix}/lib/tlp/libSpanningTreeSelection-%{version}.*
%{prefix}/lib/tlp/libSquarifiedTreeMap-%{version}.*
%{prefix}/lib/tlp/libStrahlerMetric-%{version}.*
%{prefix}/lib/tlp/libStrengthClustering-%{version}.*
%{prefix}/lib/tlp/libStrengthMetric-%{version}.*
%{prefix}/lib/tlp/libStrongComponent-%{version}.*
%{prefix}/lib/tlp/libTreeLeaf-%{version}.*
%{prefix}/lib/tlp/libTreeMap-%{version}.*
%{prefix}/lib/tlp/libTreeRadial-%{version}.*
%{prefix}/lib/tlp/libTreeReingoldAndTilforExtended-%{version}.*
%{prefix}/lib/tlp/libTutte-%{version}.*
%{prefix}/lib/tlp/libWebImport-%{version}.*
%{datadir}/aclocal/tulip.m4

%files -n lib%{name}-ogl
%defattr(-,root,root)
%{prefix}/lib/libtulip-ogl.la
%{prefix}/lib/libtulip-ogl.so
%{prefix}/lib/libtulip-ogl-%{tulip_version}.so*
%{prefix}/lib/tlp/glyphs/lib*-%{version}.*
%{prefix}/lib/tlp/libFitToLabels-%{version}.*
%{prefix}/lib/tlp/bitmaps/fontb.ttf
%{prefix}/lib/tlp/bitmaps/font.ttf

%files -n lib%{name}-qt4
%defattr(-,root,root)
%{prefix}/lib/libtulip-qt4.la
%{prefix}/lib/libtulip-qt4.so
%{prefix}/lib/libtulip-qt4-%{tulip_version}.so*
%{prefix}/lib/tlp/libConvolutionClustering-%{version}.*
%{prefix}/lib/tlp/libEnumColorValuesMapping-%{version}.*
%{prefix}/lib/tlp/libFileSystem-%{version}.*
%{prefix}/lib/tlp/libWebImport-%{version}.*
%{prefix}/lib/tlp/designer/lib*.*
%{prefix}/lib/tlp/view/libParallelCoordinates-%{version}.*
%{prefix}/lib/tlp/view/libSpreadSheet-%{version}.*

%changelog
* Wed Jul 23 2003 Bertrand Mathieu <mathieu@labri.fr>
- put "Fonts.bmp" with libtulip-ogl instead of tulip

* Tue Mar 11 2003 Bertrand Mathieu <mathieu@labri.fr>
- removed -j 2 from 'make' parameters: caused an error in libtulip-qt compilation (to be fixed)
- added tulip.m4 and Qt designer's plugin into %files

* Wed Mar  5 2003 Bertrand Mathieu <mathieu@labri.fr>
- added package libtulip-qt

* Wed Oct 30 2002 Bertrand Mathieu <mathieu@.labri.fr>
- multiples packages

* Wed Sep 11 2002 Bertrand Mathieu <mathieu@labri.fr>
- corrected RPM generation

* Fri Jul 26 2002 Bertrand Mathieu <mathieu@labri.fr>
- Initial build.
