// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiosrc_p.h
// 
// Purpose:     
// 
// Created:     18 Jun 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tiosrc_p.h,v 1.3 1997/02/12 23:13:11 jfasch Exp $
// 
// $Log: tiosrc_p.h,v $
// Revision 1.3  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.2  1996/11/26 17:39:56  jfasch
// oops. forgot to init user_.
//
// Revision 1.1  1996/07/08 13:16:36  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tiosrc_p_h
#define hg_dispatch_tiosrc_p_h

#include <hyperg/utils/smartptr.h>

class TIOSourcePassive ;
class TransparentIOPtr ;

class TIOSourcePassiveUser {
public:
   virtual void tioSrcPError (const TIOSourcePassive*) = 0 ;
   virtual void tioSrcPReady (const TIOSourcePassive*, const TransparentIOPtr&) = 0 ;
} ;

class TIOSourcePassive : public RefCounted {
public:
   TIOSourcePassive() : user_(nil) {}
   virtual ~TIOSourcePassive() {}
   
   bool start (TIOSourcePassiveUser*) ;
   void stop (const TIOSourcePassiveUser*) ;

protected:
   virtual bool start_() = 0 ;
   virtual void stop_() = 0 ;

   // these call back the private user
   void ready_(const TransparentIOPtr&) const ;
   void error_() const ;

private:
   TIOSourcePassiveUser* user_ ;
} ;
SmartPtrdeclare (TIOSourcePassivePtr, TIOSourcePassive) ;

#endif
