//<copyright>
// 
// Copyright (c) 1993,94
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        menus.C
//
// Purpose:     implementation of class MenuKit
//
// Created:     12 Jan 93   Michael Pichler
//
// Changed:     24 May 93   Juergen Schipflinger
//
// Changed:     27 May 94   Michael Pichler
//
//
//</file>

#include <hyperg/OS/string.h>
#include "menus.h"


#include <InterViews/action.h>
#include <InterViews/layout.h>
#include <InterViews/telltale.h>
#include <IV-look/kit.h>
#include <IV-look/menu.h>



// menubar
// ... without right margin (would conflict with glue)

Menu* MenuKit::menubar (WidgetKit& kit, const LayoutKit& layout)
{
  kit.begin_style ("MenuBar", "Menu");

  Menu* menubar = new Menu (
    kit.outset_frame (layout.hbox ()),
    kit.style (), 0.0, 0.0, 0.0, 1.0
  );

  kit.end_style ();
  return menubar;
}


// menubarGlue
// glue for use between menu bar items (usually before "Help")

MenuItem* MenuKit::menubarGlue (const LayoutKit& layout)
{
  return new MenuItem (layout.hglue (), new TelltaleState);
  // must generate telltale state (core dump otherwise)
}


// menubarItem
// menubar item

MenuItem* MenuKit::menubarItem (WidgetKit& kit, const char* str, Menu* submenu)
{
  kit.begin_style ("MenuBar", "Menu");

  MenuItem* menuitem = kit.menubar_item (str);
  menuitem->menu (submenu);

  kit.end_style ();
  return menuitem;
}


// menuItem
// menu item with a label (glue at right margin) and an action
// if action is nil, the menu item is disabled
// other telltale state (e.g. of push button) may be used

MenuItem* MenuKit::menuItem (
  WidgetKit& kit, const LayoutKit& layout,
  const char* str, Action* action,
  const char* acc, TelltaleState* tstate
)
{
  kit.begin_style ("MenuItem", "Menu");

  Glyph* body;
  if (acc && *acc)  // accelerator label
  {
    body = layout.hbox (
      kit.label (str),
      layout.hglue (10),
      kit.label (acc)
    );
  }
  else
    body = layout.rmargin (kit.label (str), 0, fil, 0);

  MenuItem* menuitem;
  if (tstate)
    menuitem = new MenuItem (kit.menu_item_look (body, tstate), tstate);
  else
    menuitem = kit.menu_item (body);

  menuitem->action (action);

  kit.end_style ();
  return menuitem;
}


// menuItem
// menu item with pullright submenu

MenuItem* MenuKit::menuItem (WidgetKit& kit, const LayoutKit& layout, const char* str, Menu* submenu)
{
  kit.begin_style ("MenuItem", "Menu");

  MenuItem* menuitem = kit.menu_item (
    layout.hbox (
      kit.label (str),
      layout.hglue (10),
      kit.label ("")
    )
  );
  menuitem->menu (submenu);

  kit.end_style ();
  return menuitem;
}


// checkMenuItem
// check menu item with action
// choose flag tells initial state (chosen or not)
// other telltale state (e.g. of palette button) may be used

MenuItem* MenuKit::checkMenuItem (
  WidgetKit& kit, const LayoutKit& layout,
  const char* str, Action* action, int choose,
  const char* acc, TelltaleState* tstate
)
{
  kit.begin_style ("MenuItem", "ToggleButton");

  Glyph* body;
  if (acc && *acc)  // accelerator label
  {
    body = layout.hbox (
      kit.label (str),
      layout.hglue (10),
      kit.label (acc)
    );
  }
  else
    body = layout.rmargin (kit.label (str), 0, fil, 0);

  MenuItem* menuitem;
  if (tstate)
    menuitem = new MenuItem (kit.check_menu_item_look (body, tstate), tstate);
  else
    menuitem = kit.check_menu_item (body);

  menuitem->action (action);

  if (choose)
    menuitem->state ()->set (TelltaleState::is_chosen, true);

  kit.end_style ();
  return menuitem;
}


// radioMenuItem
// radio menu item (belongs to a telltale group) with action
// choose flag tells initial state (chosen or not)
// other telltale state (e.g. of palette button) may be used

MenuItem* MenuKit::radioMenuItem (
  WidgetKit& kit, const LayoutKit& layout, TelltaleGroup* tg,
  const char* str, Action* action, int choose,
  const char* acc, TelltaleState* tstate)
{
  kit.begin_style ("MenuItem", "RadioButton");

  Glyph* body;


  if (acc && *acc)  // accelerator label
  {
    body = layout.hbox (
      kit.label (str),
      layout.hglue (10),
      kit.label (acc)
    );
  }
  else
    body = layout.rmargin (kit.label (str), 0, fil, 0);

  MenuItem* menuitem;
  if (tstate)
  { menuitem = new MenuItem (kit.radio_menu_item_look (body, tstate), tstate);
    tstate->join (tg);
  }
  else
    menuitem = kit.radio_menu_item (tg, body);

  menuitem->action (action);

  if (choose)
    menuitem->state ()->set (TelltaleState::is_chosen, true);

  kit.end_style ();
  return menuitem;
}


// enable menu item

MenuItem* MenuKit::enable (MenuItem* item)
{
  item->state ()->set (TelltaleState::is_enabled, true);
  return item;  // for convenience
}


// disable menu item

MenuItem* MenuKit::disable (MenuItem* item)
{
  item->state ()->set (TelltaleState::is_enabled, false);
  return item;  // for convenience
}
