//<copyright>
//
// Copyright (c) 1994-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
// Name :       mscrollbar.C
//
// Purpose :    Implementation of class MScrollbar
//
// Created :    10 May 94    Bernhard Marschall
//
// $Id: mscrollbar.C,v 1.1 1996/03/12 16:54:59 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: mscrollbar.C,v $
// Revision 1.1  1996/03/12 16:54:59  bmarsch
// Initial revision
//


#include <InterViews/layout.h>
#include <InterViews/polyglyph.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <IV-look/kit.h>

#include "madjust.h"
#include "mthumb.h"
#include "mslider.h"
#include "mscrollbar.h"

// *************************************************************************

MScrollbar::MScrollbar(DimensionName dim, MAdjustable* madj)
: MonoGlyph()
{
  WidgetKit& kit = *WidgetKit::instance();
  const LayoutKit& layout = *LayoutKit::instance();
  Style* style = kit.style();

  // read resources: sliderSize (height of bar)
  //                 moverSize (length of button)
  Coord ss = 20.0;
  Coord ms = 20.0;
  style->find_attribute("sliderSize", ss);
  style->find_attribute("moverSize", ms);

  Coord xspan;
  Coord yspan;
  Glyph* lmover;
  Glyph* rmover;
  PolyGlyph* box;

  // compose scrollbar: it consists of a left_mover (up_mover),
  // a MSlider and a right_mover (down_mover)
  switch (dim) {

    case Dimension_X:
      xspan = ms;
      yspan = ss;
      lmover = layout.fixed(kit.left_mover(madj), xspan, yspan);
      rmover = layout.fixed(kit.right_mover(madj), xspan, yspan);
      slider_ = new MXSlider(style, madj);
      box = layout.hbox(3);
      break;

    case Dimension_Y:
      xspan = ss;
      yspan = ms;
      lmover = layout.fixed(kit.up_mover(madj), xspan, yspan);
      rmover = layout.fixed(kit.down_mover(madj), xspan, yspan);
      slider_ = new MYSlider(style, madj);
      box = layout.vbox(3);
      break;

    default:
      // invalid
      return;
  }

  // set thumb
  Resource::ref(slider_);
  slider_->normal_thumb(new MThumb(TelltaleState::is_enabled, dim));
  slider_->visible_thumb(new MThumb(TelltaleState::is_visible, dim));

  // combine in box
  box->append(lmover);
  box->append(kit.outset_frame(slider_));
  box->append(rmover);

  if (dim == Dimension_X)
    body(layout.vfixed(box, yspan));
  else
    body(layout.hfixed(box, xspan));
}

// *************************************************************************

MScrollbar::~MScrollbar() 
{
  Resource::unref(slider_);
}

// *************************************************************************

void MScrollbar::redraw_slider()
{
  slider_->redraw_slider();
}
