// This is core/vil/vil_color_table.h
#ifndef vil_color_table_h_
#define vil_color_table_h_
//:
// \file
// \brief Color tables for applying false color to greyscale images.
// \author brooksby@research.ge.com
// \date 08 Nov 2005
// \verbatim
//  Modifications
//   8 Nov 2005 Initial port from TargetJr.
// \endverbatim
//
// \description
//
// This file provides a way to load color tables directly, rather than computing them.
// It was created from the predefined color tables in IDL. It provides a way of adding
// pseudo-color to data for visualization purposes.
//
// These tables are provided courtesy of Research Systems Incorporated (RSI),
// Boulder, CO and are used with permission.  RSI is the developer of IDL.
//
// The number (ie REDx, GREENx, BLUEx) refer to the color table numbers from IDL.
// The IDL descriptions are as follows. I don't claim the names make sense, but
// at least they are unique and give a hint as to how they may display.
//
// - Nr Name
// -  0 Black & White Linear
// -  1 Blue/White Linear
// -  2 Green-Red-Blue-White
// -  3 Red Temperature
// -  4 Blue-Green-Red-Yellow
// -  5 Standard Gamma-II
// -  6 Prism
// -  7 Red-Purple
// -  8 Green/White Linear
// -  9 Green/White Exponential
// - 10 Green-Pink
// - 11 Blue-Red
// - 12 16 Level
// - 13 Rainbow
// - 14 Steps
// - 15 Stern Special
// - 16 Haze
// - 17 Blue-Pastel
// - 18 Red-Pastel
// - 19 Hue Sat Lightness 1
// - 20 Hue Sat Lightness 2
// - 21 Hue Sat Value 1
// - 22 Hue Sat Value 2
// - 23 Purple-Red + Stripes
// - 24 Beach
// - 25 Mac Style
// - 26 Eos A
// - 27 Eos B
// - 28 Hardcandy
// - 29 Nature
// - 30 Ocean
// - 31 Peppermint
// - 32 Plasma
// - 33 Blue-Red 2
// - 34 Rainbow 2
// - 35 Blue Waves
// - 36 Volcano
// - 37 Waves
//
// To understand how these color maps appear, compile and run the example
// program vil_color_tables.cxx.  This executable will produce a color image
// for each of these tables representing a ramp from 0 to 255.

#include <vil/vil_rgb.h>
#include <vxl_config.h> // for vxl_byte

enum color_theme {BWLIN1=0, BWLIN2, GRBW, REDTEMP, BGRY, GAMMA_II, PRISM, RED_PURPLE,
                  GWLIN, GWEXP, GREENPINK, BLUERED, SIXTEENLEVEL, RAINBOW1, STEPS, STERN,
                  HAZE, BLUE_PASTEL, RED_PASTEL, HSL1, HSL2, HSV1, HSV2, PURPLE_RED_STRIPES,
                  BEACH, MAC, EOS_A, EOS_B, HARD_CANDY, NATURE, OCEAN, PEPPERMINT, PLASMA,
                  BLUERED2, RAINBOW2, BLUE_WAVES, VOLCANO1, WAVES1, VOLCANO2, WAVES2 };

int RED0[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
int GREEN0[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
int BLUE0[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
int RED1[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 9, 13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61, 65, 69, 73, 77, 81, 85, 90, 94, 98, 102, 106, 110, 114, 118, 122, 126, 130, 134, 138, 142, 146, 150, 154, 158, 162, 166, 170, 175, 179, 183, 187, 191, 195, 199, 203, 207, 211, 215, 219, 223, 227, 231, 235, 239, 243, 247, 251, 255};
int GREEN1[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 5, 7, 9, 10, 12, 13, 15, 17, 18, 20, 21, 23, 25, 26, 28, 29, 31, 33, 34, 36, 37, 39, 41, 42, 44, 45, 47, 49, 50, 52, 53, 55, 57, 58, 60, 61, 63, 65, 66, 68, 69, 71, 73, 74, 76, 77, 79, 81, 82, 84, 85, 87, 89, 90, 92, 94, 95, 97, 98, 100, 102, 103, 105, 106, 108, 110, 111, 113, 114, 116, 118, 119, 121, 122, 124, 126, 127, 129, 130, 132, 134, 135, 137, 138, 140, 142, 143, 145, 146, 148, 150, 151, 153, 154, 156, 158, 159, 161, 162, 164, 166, 167, 169, 170, 172, 174, 175, 177, 179, 180, 182, 183, 185, 187, 188, 190, 191, 193, 195, 196, 198, 199, 201, 203, 204, 206, 207, 209, 211, 212, 214, 215, 217, 219, 220, 222, 223, 225, 227, 228, 230, 231, 233, 235, 236, 238, 239, 241, 243, 244, 246, 247, 249, 251, 252, 254, 255};
int BLUE1[] = {0, 1, 2, 4, 5, 6, 8, 9, 10, 12, 13, 14, 16, 17, 18, 20, 21, 23, 24, 25, 27, 28, 29, 31, 32, 33, 35, 36, 37, 39, 40, 42, 43, 44, 46, 47, 48, 50, 51, 52, 54, 55, 56, 58, 59, 61, 62, 63, 65, 66, 67, 69, 70, 71, 73, 74, 75, 77, 78, 80, 81, 82, 84, 85, 86, 88, 89, 90, 92, 93, 94, 96, 97, 99, 100, 101, 103, 104, 105, 107, 108, 109, 111, 112, 113, 115, 116, 118, 119, 120, 122, 123, 124, 126, 127, 128, 130, 131, 132, 134, 135, 136, 138, 139, 141, 142, 143, 145, 146, 147, 149, 150, 151, 153, 154, 155, 157, 158, 160, 161, 162, 164, 165, 166, 168, 169, 170, 172, 173, 174, 176, 177, 179, 180, 181, 183, 184, 185, 187, 188, 189, 191, 192, 193, 195, 196, 198, 199, 200, 202, 203, 204, 206, 207, 208, 210, 211, 212, 214, 215, 217, 218, 219, 221, 222, 223, 225, 226, 227, 229, 230, 231, 233, 234, 236, 237, 238, 240, 241, 242, 244, 245, 246, 248, 249, 250, 252, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int RED2[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96, 102, 108, 114, 120, 126, 132, 138, 144, 150, 156, 162, 168, 174, 180, 186, 192, 198, 204, 210, 216, 222, 228, 234, 240, 243, 246, 249, 252, 252, 252, 252, 252, 251, 250, 249, 248, 248, 248, 248, 248, 247, 246, 245, 244, 243, 242, 241, 240, 240, 239, 238, 237, 236, 236, 236, 236, 235, 234, 233, 232, 231, 230, 229, 228, 228, 228, 228, 228, 227, 226, 225, 224, 223, 222, 221, 220, 219, 218, 217, 216, 216, 216, 216, 216, 215, 214, 213, 212, 211, 210, 209, 208, 207, 206, 205, 204, 204, 204, 204, 204, 203, 202, 201, 200, 199, 198, 197, 196, 196, 196, 196, 196, 195, 194, 193, 192, 191, 190, 189, 188, 187, 186, 185, 184, 184, 184, 184, 184, 183, 182, 181, 180, 179, 178, 177, 176, 176, 176, 176, 176, 175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 164, 164, 164, 164, 163, 162, 161, 160, 159, 158, 157, 156, 155, 154, 153, 152, 152, 152, 152, 152, 151, 150, 149, 148, 151, 154, 157, 160, 163, 166, 169, 172, 176, 180, 184, 188, 191, 194, 197, 200, 203, 206, 209, 212, 215, 218, 221, 224, 228, 232, 236, 240, 243, 246, 249, 252, 253, 254, 255};
int GREEN2[] = {0, 36, 72, 75, 79, 82, 86, 90, 93, 97, 100, 104, 108, 117, 126, 135, 144, 153, 162, 171, 180, 189, 198, 207, 216, 225, 234, 243, 252, 249, 246, 243, 240, 234, 228, 222, 216, 210, 204, 198, 192, 186, 180, 174, 168, 162, 156, 150, 144, 138, 132, 126, 120, 114, 108, 102, 96, 90, 84, 78, 72, 66, 60, 54, 48, 42, 36, 30, 24, 18, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 16, 24, 32, 40, 48, 56, 64, 72, 80, 88, 96, 104, 112, 120, 128, 135, 142, 149, 156, 164, 172, 180, 188, 196, 204, 212, 220, 228, 236, 244, 252, 253, 254, 255};
int BLUE2[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 5, 7, 9, 10, 12, 14, 16, 18, 20, 22, 25, 27, 29, 31, 34, 35, 37, 39, 41, 43, 45, 47, 50, 52, 54, 56, 59, 61, 63, 65, 67, 68, 70, 72, 74, 76, 78, 80, 83, 85, 87, 89, 92, 94, 96, 98, 101, 102, 104, 106, 108, 110, 112, 114, 116, 118, 120, 122, 125, 127, 129, 131, 134, 135, 137, 139, 141, 143, 145, 147, 150, 152, 154, 156, 159, 160, 162, 163, 165, 167, 169, 171, 174, 176, 178, 180, 183, 185, 187, 189, 192, 193, 195, 197, 199, 201, 203, 205, 208, 210, 212, 214, 216, 217, 219, 221, 223, 225, 227, 229, 232, 234, 236, 238, 241, 243, 245, 247, 250, 251, 252, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int RED3[] = {0, 1, 2, 4, 5, 7, 8, 10, 11, 13, 14, 15, 17, 18, 20, 21, 23, 24, 26, 27, 28, 30, 31, 33, 34, 36, 37, 39, 40, 42, 43, 44, 46, 47, 49, 50, 52, 53, 55, 56, 57, 59, 60, 62, 63, 65, 66, 68, 69, 70, 72, 73, 75, 76, 78, 79, 81, 82, 84, 85, 86, 88, 89, 91, 92, 94, 95, 97, 98, 99, 101, 102, 104, 105, 107, 108, 110, 111, 113, 114, 115, 117, 118, 120, 121, 123, 124, 126, 127, 128, 130, 131, 133, 134, 136, 137, 139, 140, 141, 143, 144, 146, 147, 149, 150, 152, 153, 155, 156, 157, 159, 160, 162, 163, 165, 166, 168, 169, 170, 172, 173, 175, 176, 178, 179, 181, 182, 184, 185, 186, 188, 189, 191, 192, 194, 195, 197, 198, 199, 201, 202, 204, 205, 207, 208, 210, 211, 212, 214, 215, 217, 218, 220, 221, 223, 224, 226, 227, 228, 230, 231, 233, 234, 236, 237, 239, 240, 241, 243, 244, 246, 247, 249, 250, 252, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN3[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 5, 7, 9, 11, 13, 15, 17, 18, 20, 22, 24, 26, 28, 30, 32, 34, 35, 37, 39, 41, 43, 45, 47, 49, 51, 52, 54, 56, 58, 60, 62, 64, 66, 68, 69, 71, 73, 75, 77, 79, 81, 83, 85, 86, 88, 90, 92, 94, 96, 98, 100, 102, 103, 105, 107, 109, 111, 113, 115, 117, 119, 120, 122, 124, 126, 128, 130, 132, 134, 136, 137, 139, 141, 143, 145, 147, 149, 151, 153, 154, 156, 158, 160, 162, 164, 166, 168, 170, 171, 173, 175, 177, 179, 181, 183, 185, 187, 188, 190, 192, 194, 196, 198, 200, 202, 204, 205, 207, 209, 211, 213, 215, 217, 219, 221, 222, 224, 226, 228, 230, 232, 234, 236, 238, 239, 241, 243, 245, 247, 249, 251, 253, 255};
int BLUE3[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 54, 58, 62, 66, 70, 74, 78, 82, 86, 90, 94, 98, 102, 105, 109, 113, 117, 121, 125, 129, 133, 137, 141, 145, 149, 153, 156, 160, 164, 168, 172, 176, 180, 184, 188, 192, 196, 200, 204, 207, 211, 215, 219, 223, 227, 231, 235, 239, 243, 247, 251, 255};
int RED4[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 15, 22, 30, 37, 45, 52, 60, 67, 75, 82, 90, 97, 105, 112, 120, 125, 130, 135, 140, 145, 150, 155, 160, 165, 170, 175, 180, 185, 190, 195, 200, 200, 201, 201, 202, 202, 203, 203, 204, 204, 205, 205, 206, 206, 207, 207, 208, 208, 209, 209, 210, 210, 211, 211, 212, 212, 213, 213, 214, 214, 215, 215, 216, 216, 217, 217, 218, 218, 219, 219, 220, 220, 221, 221, 222, 222, 223, 223, 224, 224, 225, 225, 226, 226, 227, 227, 228, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 255, 255};
int GREEN4[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 6, 9, 12, 15, 18, 21, 25, 28, 31, 34, 37, 40, 43, 46, 50, 53, 56, 59, 62, 65, 68, 71, 75, 78, 81, 84, 87, 90, 93, 96, 100, 103, 106, 109, 112, 115, 118, 121, 125, 128, 131, 134, 137, 140, 143, 146, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 149, 148, 148, 147, 146, 146, 145, 145, 144, 143, 143, 142, 141, 141, 140, 140, 137, 135, 132, 130, 127, 125, 122, 120, 117, 115, 112, 110, 107, 105, 102, 100, 93, 87, 81, 75, 68, 62, 56, 50, 43, 37, 31, 25, 18, 12, 6, 0, 2, 4, 6, 9, 11, 13, 16, 18, 20, 23, 25, 27, 29, 32, 34, 36, 39, 41, 43, 46, 48, 50, 53, 55, 57, 59, 62, 64, 66, 69, 71, 73, 76, 78, 80, 83, 85, 87, 89, 92, 94, 96, 99, 101, 103, 106, 108, 110, 113, 115, 117, 119, 122, 124, 126, 129, 131, 133, 136, 138, 140, 142, 145, 147, 149, 152, 154, 156, 159, 161, 163, 166, 168, 170, 172, 175, 177, 179, 182, 184, 186, 189, 191, 193, 196, 198, 200, 202, 205, 207, 209, 212, 214, 216, 219, 221, 223, 226, 228, 230, 232, 235, 237, 239, 242, 244, 246, 249, 251, 253, 255};
int BLUE4[] = {0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70, 72, 75, 77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 96, 93, 90, 87, 84, 81, 78, 75, 71, 68, 65, 62, 59, 56, 53, 50, 46, 43, 40, 37, 34, 31, 28, 25, 21, 18, 15, 12, 9, 6, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int RED5[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 9, 14, 19, 23, 28, 33, 38, 42, 47, 52, 57, 61, 66, 71, 76, 81, 81, 81, 81, 81, 81, 81, 81, 80, 80, 80, 80, 80, 80, 80, 79, 84, 89, 94, 99, 104, 109, 114, 119, 124, 129, 134, 139, 144, 149, 154, 159, 164, 169, 174, 180, 185, 190, 196, 201, 206, 212, 217, 222, 228, 233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 240, 232, 225, 217, 209, 202, 194, 186, 179, 171, 163, 168, 173, 178, 183, 188, 193, 198, 203, 209, 214, 219, 224, 229, 234, 239, 244, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN5[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 10, 16, 21, 27, 32, 37, 43, 48, 54, 59, 64, 70, 75, 81, 85, 90, 95, 100, 105, 109, 114, 119, 124, 129, 134, 138, 143, 148, 153, 158, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 169, 175, 181, 187, 193, 199, 205, 212, 218, 224, 230, 236, 242, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int BLUE5[] = {0, 5, 10, 15, 20, 26, 31, 36, 41, 46, 52, 57, 62, 67, 72, 78, 83, 88, 93, 98, 104, 109, 114, 119, 124, 130, 135, 140, 145, 150, 156, 161, 166, 171, 176, 182, 187, 192, 197, 202, 208, 213, 218, 223, 228, 234, 239, 244, 249, 255, 250, 245, 239, 234, 228, 223, 218, 212, 207, 201, 196, 190, 185, 180, 174, 169, 163, 158, 152, 147, 142, 136, 131, 125, 120, 114, 109, 104, 98, 93, 87, 82, 76, 71, 66, 60, 55, 49, 44, 38, 33, 28, 22, 17, 11, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 9, 14, 19, 24, 28, 33, 38, 43, 48, 53, 57, 62, 67, 72, 77, 82, 77, 71, 65, 59, 53, 47, 41, 36, 30, 24, 18, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 6, 9, 12, 16, 19, 22, 25, 29, 32, 35, 38, 41, 45, 48, 51, 54, 58, 61, 64, 67, 71, 74, 77, 80, 83, 87, 90, 93, 96, 100, 103, 106, 109, 112, 116, 119, 122, 125, 129, 132, 135, 138, 142, 145, 148, 151, 154, 158, 161, 164, 167, 171, 174, 177, 180, 183, 187, 190, 193, 196, 200, 203, 206, 209, 213, 216, 219, 222, 225, 229, 232, 235, 238, 242, 245, 248, 251, 255};
int RED6[] = {0, 3, 7, 11, 15, 19, 22, 26, 30, 34, 38, 41, 45, 49, 53, 57, 60, 64, 68, 72, 76, 79, 83, 87, 91, 95, 98, 102, 106, 110, 114, 117, 121, 125, 129, 133, 137, 140, 144, 148, 152, 156, 159, 163, 167, 171, 175, 178, 182, 186, 190, 194, 197, 201, 205, 209, 213, 216, 220, 224, 228, 232, 235, 239, 243, 247, 251, 255, 251, 247, 243, 239, 235, 230, 226, 222, 218, 214, 210, 205, 201, 197, 193, 189, 184, 180, 176, 172, 168, 164, 159, 155, 151, 147, 143, 138, 134, 130, 126, 122, 118, 113, 109, 105, 101, 97, 92, 88, 84, 80, 76, 72, 67, 63, 59, 55, 51, 46, 42, 38, 34, 30, 26, 21, 17, 13, 9, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int GREEN6[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95, 99, 103, 107, 111, 115, 119, 123, 127, 131, 135, 139, 143, 147, 151, 155, 159, 163, 167, 171, 175, 179, 183, 187, 191, 195, 199, 203, 207, 211, 215, 219, 223, 227, 231, 235, 239, 243, 247, 251, 255, 251, 247, 243, 239, 235, 231, 227, 223, 219, 215, 211, 207, 203, 199, 195, 191, 187, 183, 179, 175, 170, 166, 162, 158, 154, 150, 146, 142, 138, 134, 130, 126, 122, 118, 114, 110, 106, 102, 98, 94, 90, 85, 81, 77, 73, 69, 65, 61, 57, 53, 49, 45, 41, 37, 33, 29, 25, 21, 17, 13, 9, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int BLUE6[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 11, 15, 19, 23, 27, 30, 34, 38, 42, 46, 50, 54, 57, 61, 65, 69, 73, 77, 81, 85, 88, 92, 96, 100, 104, 108, 112, 115, 119, 123, 127, 131, 135, 139, 142, 146, 150, 154, 158, 162, 166, 170, 173, 177, 181, 185, 189, 193, 197, 200, 204, 208, 212, 216, 220, 224, 227, 231, 235, 239, 243, 247, 251, 255, 251, 247, 243, 239, 235, 231, 227, 223, 219, 215, 211, 207, 203, 199, 195, 191, 187, 183, 179, 175, 170, 166, 162, 158, 154, 150, 146, 142, 138, 134, 130, 126, 122, 118, 114, 110, 106, 102, 98, 94, 90, 85, 81, 77, 73, 69, 65, 61, 57, 53, 49, 45, 41, 37, 33, 29, 25, 21, 17, 13, 9, 5, 0};
int RED7[] = {0, 0, 3, 6, 10, 13, 17, 20, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 85, 86, 87, 88, 90, 92, 94, 96, 97, 98, 99, 100, 102, 104, 106, 108, 109, 110, 111, 112, 114, 116, 118, 120, 121, 122, 123, 124, 126, 128, 130, 132, 133, 134, 135, 136, 138, 140, 142, 144, 145, 146, 147, 148, 150, 152, 154, 156, 157, 158, 159, 160, 162, 164, 166, 168, 169, 170, 171, 172, 174, 176, 178, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 198, 200, 202, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 222, 224, 226, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 246, 248, 250, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 253, 254};
int GREEN7[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 10, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 18, 19, 20, 20, 20, 20, 20, 21, 22, 23, 24, 24, 24, 24, 24, 25, 26, 27, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 61, 62, 63, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96, 98, 100, 102, 104, 107, 110, 113, 116, 119, 122, 125, 128, 131, 134, 137, 140, 143, 146, 149, 152, 155, 158, 161, 164, 167, 170, 173, 176, 180, 184, 188, 192, 197, 202, 207, 212, 217, 222, 227, 232, 237, 242, 247, 252, 252, 253, 254};
int BLUE7[] = {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15, 17, 17, 18, 18, 19, 20, 22, 23, 25, 25, 26, 26, 27, 28, 29, 30, 32, 32, 33, 33, 34, 35, 36, 37, 39, 39, 40, 40, 41, 42, 43, 44, 46, 46, 47, 48, 49, 50, 51, 52, 54, 54, 53, 53, 52, 54, 56, 58, 60, 60, 61, 62, 63, 64, 65, 66, 68, 69, 70, 71, 73, 74, 75, 76, 77, 78, 79, 80, 82, 82, 83, 83, 84, 85, 86, 87, 89, 90, 91, 92, 94, 95, 96, 97, 98, 99, 100, 101, 103, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 115, 116, 117, 118, 119, 120, 121, 122, 124, 124, 125, 125, 126, 127, 129, 131, 133, 134, 136, 138, 140, 141, 143, 144, 146, 147, 149, 151, 153, 154, 156, 157, 159, 160, 161, 162, 164, 165, 166, 167, 169, 170, 172, 173, 175, 176, 177, 178, 180, 181, 183, 184, 186, 187, 188, 189, 191, 192, 193, 194, 196, 197, 199, 200, 202, 203, 204, 205, 207, 208, 209, 210, 212, 213, 214, 215, 217, 218, 219, 220, 221, 222, 223, 224, 226, 227, 228, 229, 230, 231, 232, 233, 235, 236, 237, 238, 239, 240, 241, 242, 243, 243, 244, 245, 246, 246, 247, 248, 249, 249, 250, 251, 252, 252, 253, 254};
int RED8[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 4, 6, 8, 9, 11, 12, 14, 16, 17, 19, 20, 22, 24, 25, 27, 29, 30, 32, 33, 35, 37, 38, 40, 41, 43, 45, 46, 48, 50, 51, 53, 54, 56, 58, 59, 61, 62, 64, 66, 67, 69, 71, 72, 74, 75, 77, 79, 80, 82, 83, 85, 87, 88, 90, 91, 93, 95, 96, 98, 100, 101, 103, 104, 106, 108, 109, 111, 112, 114, 116, 117, 119, 121, 122, 124, 125, 127, 129, 130, 132, 133, 135, 137, 138, 140, 142, 143, 145, 146, 148, 150, 151, 153, 154, 156, 158, 159, 161, 163, 164, 166, 167, 169, 171, 172, 174, 175, 177, 179, 180, 182, 183, 185, 187, 188, 190, 192, 193, 195, 196, 198, 200, 201, 203, 204, 206, 208, 209, 211, 213, 214, 216, 217, 219, 221, 222, 224, 225, 227, 229, 230, 232, 234, 235, 237, 238, 240, 242, 243, 245, 246, 248, 250, 251, 253, 255};
int GREEN8[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
int BLUE8[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 6, 10, 13, 17, 20, 24, 27, 31, 34, 37, 41, 44, 48, 51, 55, 58, 62, 65, 68, 72, 75, 79, 82, 86, 89, 93, 96, 99, 103, 106, 110, 113, 117, 120, 124, 127, 130, 134, 137, 141, 144, 148, 151, 155, 158, 161, 165, 168, 172, 175, 179, 182, 186, 189, 192, 196, 199, 203, 206, 210, 213, 217, 220, 223, 227, 230, 234, 237, 241, 244, 248, 251, 255};
int RED9[] = {1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 15, 15, 15, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 20, 20, 20, 21, 21, 21, 22, 22, 23, 23, 23, 24, 24, 25, 25, 25, 26, 26, 26, 27, 27, 28, 28, 28, 29, 29, 29, 30, 30, 31, 31, 31, 32, 32, 33, 33, 33, 34, 34, 34, 35, 35, 36, 36, 36, 37, 37, 37, 38, 38, 39, 39, 39, 40, 40, 41, 41, 41, 42, 42, 42, 43, 43, 44, 44, 44, 45, 45, 45, 46, 46, 47, 47, 47, 48, 48, 49, 49, 49, 50, 50, 50, 51, 51, 52, 52, 52, 54, 54, 55, 56, 56, 57, 58, 58, 59, 60, 60, 61, 62, 62, 63, 64, 64, 66, 68, 70, 71, 73, 75, 77, 79, 81, 83, 85, 86, 88, 90, 92, 94, 96, 98, 99, 101, 103, 105, 107, 109, 111, 113, 114, 116, 118, 120, 122, 124, 126, 127, 129, 131, 133, 135, 137, 139, 141, 142, 144, 146, 148, 150, 152, 154, 156, 157, 159, 161, 163, 165, 167, 169, 170, 172, 174, 176, 178, 180, 182, 184, 185, 187, 189, 191, 193, 195, 197, 198, 200, 202, 204, 206, 208, 210, 212, 213, 215, 217, 219, 221, 223, 225, 226, 228, 230, 232, 234, 236, 238, 240, 241, 243, 245, 247, 249, 251, 253, 255};
int GREEN9[] = {0, 0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 19, 20, 20, 21, 22, 22, 23, 24, 24, 25, 26, 26, 27, 28, 28, 29, 30, 30, 31, 32, 32, 33, 34, 34, 35, 36, 36, 37, 38, 38, 39, 40, 40, 41, 42, 42, 43, 44, 44, 45, 46, 46, 47, 48, 48, 49, 50, 50, 51, 52, 52, 53, 54, 54, 55, 56, 56, 57, 58, 58, 59, 60, 60, 61, 62, 62, 63, 64, 64, 65, 66, 66, 67, 68, 68, 69, 70, 70, 71, 72, 72, 73, 74, 74, 75, 76, 76, 77, 78, 78, 79, 80, 80, 81, 82, 82, 83, 84, 84, 85, 86, 87, 88, 90, 91, 92, 94, 95, 96, 98, 99, 100, 102, 103, 104, 106, 107, 108, 110, 111, 112, 114, 115, 116, 118, 119, 120, 122, 123, 124, 126, 127, 128, 130, 131, 132, 134, 135, 136, 138, 139, 140, 142, 143, 145, 146, 147, 149, 150, 151, 153, 154, 155, 157, 158, 159, 161, 162, 163, 165, 166, 167, 169, 170, 171, 173, 174, 175, 177, 178, 179, 181, 182, 183, 185, 186, 187, 189, 190, 191, 193, 194, 195, 197, 198, 200, 201, 202, 204, 205, 206, 208, 209, 210, 212, 213, 214, 216, 217, 218, 220, 221, 222, 224, 225, 226, 228, 229, 230, 232, 233, 234, 236, 237, 238, 240, 241, 242, 244, 245, 246, 248, 249, 250, 252, 253, 255};
int BLUE9[] = {0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27, 28, 28, 28, 28, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 35, 35, 35, 35, 36, 36, 36, 36, 37, 37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 40, 40, 40, 40, 41, 41, 41, 41, 42, 42, 42, 42, 43, 43, 43, 43, 44, 44, 44, 45, 45, 45, 45, 46, 46, 46, 46, 47, 47, 47, 47, 48, 47, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88, 90, 93, 96, 99, 102, 105, 108, 111, 114, 117, 120, 123, 126, 129, 131, 134, 137, 140, 143, 146, 149, 152, 155, 158, 161, 164, 167, 170, 172, 175, 178, 181, 184, 187, 190, 193, 196, 199, 202, 205, 208, 211, 213, 216, 219, 222, 225, 228, 231, 234, 237, 240, 243, 246, 249, 252, 255};
int RED10[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 84, 88, 92, 96, 101, 106, 111, 116, 121, 126, 131, 136, 141, 146, 151, 156, 159, 162, 165, 168, 171, 174, 177, 180, 183, 186, 189, 192, 195, 198, 201, 204, 207, 210, 213, 216, 219, 222, 225, 228, 231, 234, 237, 240, 243, 246, 249, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 253, 254, 255};
int GREEN10[] = {0, 0, 0, 0, 14, 28, 43, 57, 72, 81, 90, 99, 108, 117, 126, 135, 144, 153, 162, 171, 180, 179, 178, 177, 176, 175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 158, 157, 156, 154, 152, 150, 148, 147, 146, 145, 144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 130, 129, 128, 126, 124, 122, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 94, 92, 90, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 66, 64, 62, 60, 59, 58, 57, 56, 54, 52, 50, 48, 47, 46, 45, 44, 42, 40, 38, 36, 34, 32, 30, 28, 26, 24, 22, 20, 19, 18, 17, 16, 14, 12, 10, 8, 6, 4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140, 144, 147, 150, 153, 156, 160, 164, 168, 172, 176, 180, 184, 188, 192, 196, 200, 204, 208, 212, 216, 220, 224, 228, 232, 236, 240, 244, 248, 252, 253, 254, 255};
int BLUE10[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 38, 40, 42, 44, 46, 48, 50, 53, 54, 56, 58, 60, 62, 64, 66, 68, 69, 71, 73, 75, 77, 79, 81, 83, 84, 86, 88, 90, 92, 94, 96, 99, 100, 102, 104, 106, 108, 110, 112, 114, 116, 118, 120, 122, 123, 125, 127, 129, 131, 133, 135, 137, 138, 140, 142, 144, 146, 148, 150, 153, 154, 156, 158, 160, 162, 164, 166, 168, 170, 172, 174, 176, 177, 179, 181, 183, 185, 187, 189, 191, 193, 195, 197, 199, 199, 198, 197, 196, 196, 196, 196, 195, 195, 194, 193, 192, 192, 191, 191, 190, 190, 190, 190, 190, 190, 190, 190, 189, 189, 188, 187, 186, 186, 185, 185, 184, 184, 185, 186, 187, 187, 187, 187, 187, 187, 187, 187, 188, 188, 188, 188, 189, 189, 189, 189, 189, 189, 189, 189, 190, 190, 190, 190, 191, 191, 191, 191, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
int RED11[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 85, 89, 93, 97, 101, 105, 109, 113, 117, 121, 125, 129, 133, 137, 141, 145, 149, 153, 157, 161, 165, 170, 174, 178, 182, 186, 190, 194, 198, 202, 206, 210, 214, 218, 222, 226, 230, 234, 238, 242, 246, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN11[] = {0, 1, 2, 3, 4, 8, 12, 16, 21, 25, 29, 33, 38, 42, 46, 50, 55, 59, 63, 67, 72, 76, 80, 84, 89, 93, 97, 101, 106, 110, 114, 118, 123, 127, 131, 135, 140, 144, 148, 152, 157, 161, 165, 169, 174, 178, 182, 186, 191, 195, 199, 203, 208, 212, 216, 220, 225, 229, 233, 237, 242, 246, 250, 255, 255, 251, 247, 243, 239, 235, 231, 227, 223, 219, 215, 211, 207, 203, 199, 195, 191, 187, 183, 179, 175, 170, 166, 162, 158, 154, 150, 146, 142, 138, 134, 130, 126, 122, 118, 114, 110, 106, 102, 98, 94, 90, 85, 81, 77, 73, 69, 65, 61, 57, 53, 49, 45, 41, 37, 33, 29, 25, 21, 17, 13, 9, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int BLUE11[] = {0, 1, 2, 3, 4, 8, 12, 16, 21, 25, 29, 33, 38, 42, 46, 50, 55, 59, 63, 67, 72, 76, 80, 84, 89, 93, 97, 101, 106, 110, 114, 118, 123, 127, 131, 135, 140, 144, 148, 152, 157, 161, 165, 169, 174, 178, 182, 186, 191, 195, 199, 203, 208, 212, 216, 220, 225, 229, 233, 237, 242, 246, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 247, 243, 239, 235, 231, 227, 223, 218, 214, 210, 206, 202, 198, 194, 190, 186, 181, 177, 173, 169, 165, 161, 157, 153, 149, 144, 140, 136, 132, 128, 124, 120, 116, 112, 107, 103, 99, 95, 91, 87, 83, 79, 75, 70, 66, 62, 58, 54, 50, 46, 42, 38, 33, 29, 25, 21, 17, 13, 9, 5, 0, 0};
int RED12[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 220, 220, 220, 220, 221, 221, 221, 221, 221, 222, 222, 222, 222, 222, 223, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN12[] = {0, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int BLUE12[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int RED13[] = {0, 4, 9, 13, 18, 22, 27, 31, 36, 40, 45, 50, 54, 58, 61, 64, 68, 69, 72, 74, 77, 79, 80, 82, 83, 85, 84, 86, 87, 88, 86, 87, 87, 87, 85, 84, 84, 84, 83, 79, 78, 77, 76, 71, 70, 68, 66, 60, 58, 55, 53, 46, 43, 40, 36, 33, 25, 21, 16, 12, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 21, 25, 29, 33, 42, 46, 51, 55, 63, 67, 72, 76, 80, 89, 93, 97, 101, 110, 114, 119, 123, 131, 135, 140, 144, 153, 157, 161, 165, 169, 178, 182, 187, 191, 199, 203, 208, 212, 221, 225, 229, 233, 242, 246, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN13[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 16, 21, 25, 29, 38, 42, 46, 51, 55, 63, 67, 72, 76, 84, 89, 93, 97, 106, 110, 114, 119, 127, 131, 135, 140, 144, 152, 157, 161, 165, 174, 178, 182, 187, 195, 199, 203, 208, 216, 220, 225, 229, 233, 242, 246, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 242, 238, 233, 229, 221, 216, 212, 208, 199, 195, 191, 187, 178, 174, 170, 165, 161, 153, 148, 144, 140, 131, 127, 123, 119, 110, 106, 102, 97, 89, 85, 80, 76, 72, 63, 59, 55, 51, 42, 38, 34, 29, 21, 17, 12, 8, 0};
int BLUE13[] = {0, 3, 7, 10, 14, 19, 23, 28, 32, 38, 43, 48, 53, 59, 63, 68, 72, 77, 81, 86, 91, 95, 100, 104, 109, 113, 118, 122, 127, 132, 136, 141, 145, 150, 154, 159, 163, 168, 173, 177, 182, 186, 191, 195, 200, 204, 209, 214, 218, 223, 227, 232, 236, 241, 245, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 242, 238, 233, 225, 220, 216, 212, 203, 199, 195, 191, 187, 178, 174, 170, 165, 157, 152, 148, 144, 135, 131, 127, 123, 114, 110, 106, 102, 97, 89, 84, 80, 76, 67, 63, 59, 55, 46, 42, 38, 34, 25, 21, 16, 12, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int RED14[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 15, 23, 31, 39, 47, 55, 63, 70, 78, 86, 94, 102, 110, 118, 126, 134, 142, 151, 159, 168, 176, 184, 193, 201, 210, 218, 226, 235, 243, 252, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 16, 18, 20, 23, 25, 27, 29, 32, 34, 36, 38, 41, 44, 47, 50, 53, 56, 59, 63, 66, 69, 72, 75, 78, 82, 85, 89, 93, 97, 101, 105, 108, 112, 116, 120, 124, 128, 131, 135, 139, 143, 147, 151, 155, 159, 163, 167, 171, 175, 178, 181, 185, 188, 192, 195, 198, 202, 205, 209, 212, 216, 218, 220, 223, 225, 227, 230, 232, 234, 237, 239, 241, 244, 244, 245, 246, 247, 247, 248, 249, 250, 250, 251, 252, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN14[] = {0, 42, 85, 127, 170, 212, 255, 246, 236, 226, 216, 206, 197, 187, 177, 167, 157, 148, 138, 128, 118, 108, 99, 89, 79, 69, 59, 50, 40, 30, 20, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 3, 5, 8, 10, 12, 15, 17, 19, 22, 24, 26, 29, 31, 33, 36, 36, 38, 40, 42, 45, 48, 51, 54, 58, 61, 64, 67, 70, 73, 77, 82, 87, 92, 96, 100, 104, 108, 113, 119, 125, 131, 138, 144, 151, 157, 164, 171, 178, 185, 193, 200, 208, 215, 223, 229, 235, 242, 248, 255};
int BLUE14[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 16, 24, 32, 41, 49, 57, 65, 74, 82, 90, 98, 106, 115, 123, 131, 139, 148, 156, 164, 172, 180, 189, 197, 205, 213, 222, 230, 238, 246, 255, 0, 5, 10, 15, 21, 26, 31, 37, 42, 47, 53, 58, 63, 69, 74, 79, 85, 89, 94, 98, 103, 108, 112, 117, 121, 126, 131, 135, 140, 144, 149, 154, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 5, 7, 9, 12, 14, 17, 20, 23, 27, 30, 34, 39, 44, 49, 55, 60, 65, 71, 76, 82, 89, 97, 104, 112, 120, 128, 136, 145, 153, 162, 171, 180, 189, 198, 207, 217, 224, 232, 239, 247, 255};
int RED15[] = {0, 18, 36, 54, 72, 90, 108, 127, 145, 163, 181, 199, 217, 235, 254, 249, 244, 239, 234, 229, 223, 218, 213, 208, 203, 197, 192, 187, 182, 177, 172, 166, 161, 156, 151, 146, 140, 135, 130, 125, 120, 115, 109, 104, 99, 94, 89, 83, 78, 73, 68, 63, 58, 52, 47, 42, 37, 32, 26, 21, 16, 11, 6, 0, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
int GREEN15[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
int BLUE15[] = {0, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 99, 101, 103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131, 133, 135, 137, 139, 141, 143, 145, 147, 149, 151, 153, 155, 157, 159, 161, 163, 165, 167, 169, 171, 173, 175, 177, 179, 181, 183, 185, 187, 189, 191, 193, 195, 197, 199, 201, 203, 205, 207, 209, 211, 213, 215, 217, 219, 221, 223, 225, 227, 229, 231, 233, 235, 237, 239, 241, 243, 245, 247, 249, 251, 253, 255, 251, 247, 243, 238, 234, 230, 226, 221, 217, 213, 209, 204, 200, 196, 192, 187, 183, 179, 175, 170, 166, 162, 158, 153, 149, 145, 141, 136, 132, 128, 124, 119, 115, 111, 107, 102, 98, 94, 90, 85, 81, 77, 73, 68, 64, 60, 56, 51, 47, 43, 39, 34, 30, 26, 22, 17, 13, 9, 5, 0, 3, 7, 11, 15, 19, 22, 26, 30, 34, 38, 41, 45, 49, 53, 57, 60, 64, 68, 72, 76, 79, 83, 87, 91, 95, 98, 102, 106, 110, 114, 117, 121, 125, 129, 133, 137, 140, 144, 148, 152, 156, 159, 163, 167, 171, 175, 178, 182, 186, 190, 194, 197, 201, 205, 209, 213, 216, 220, 224, 228, 232, 235, 239, 243, 247, 251, 255};
int RED16[] = {167, 167, 255, 254, 249, 247, 245, 243, 242, 240, 238, 236, 234, 232, 230, 228, 226, 224, 222, 220, 218, 216, 214, 212, 210, 208, 206, 204, 202, 200, 198, 196, 194, 192, 190, 188, 186, 184, 182, 180, 178, 176, 174, 172, 170, 168, 166, 164, 162, 160, 158, 156, 154, 152, 150, 148, 146, 144, 142, 141, 139, 137, 135, 133, 131, 129, 127, 125, 123, 121, 119, 117, 115, 113, 111, 109, 107, 105, 103, 101, 99, 97, 95, 93, 91, 89, 87, 85, 83, 81, 79, 77, 75, 73, 71, 69, 67, 65, 63, 61, 59, 57, 55, 53, 51, 49, 47, 45, 43, 41, 40, 38, 36, 34, 32, 30, 28, 26, 24, 22, 20, 18, 16, 14, 12, 13, 8, 6, 4, 4, 6, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 99, 101, 103, 105, 107, 108, 110, 112, 114, 116, 118, 120, 122, 124, 126, 128, 130, 132, 134, 136, 138, 140, 142, 144, 146, 148, 150, 152, 154, 156, 158, 160, 162, 164, 166, 168, 170, 172, 174, 176, 178, 180, 182, 184, 186, 188, 190, 192, 194, 196, 198, 200, 202, 204, 206, 208, 210, 211, 213, 215, 217, 219, 221, 223, 225, 227, 229, 231, 233, 235, 237, 239, 241, 243, 245, 247, 249, 251, 251};
int GREEN16[] = {112, 112, 213, 212, 210, 209, 208, 206, 205, 203, 202, 200, 199, 198, 196, 195, 193, 192, 191, 189, 188, 186, 185, 183, 182, 181, 179, 178, 176, 175, 174, 172, 171, 169, 168, 166, 165, 164, 162, 161, 159, 158, 157, 155, 154, 152, 151, 150, 148, 147, 145, 144, 142, 141, 140, 138, 137, 135, 134, 133, 131, 130, 128, 127, 125, 124, 123, 121, 120, 118, 117, 116, 114, 113, 111, 110, 109, 107, 106, 104, 103, 101, 100, 99, 97, 96, 94, 93, 92, 90, 89, 87, 86, 84, 83, 82, 80, 79, 77, 76, 75, 73, 72, 70, 69, 68, 66, 65, 63, 62, 60, 59, 58, 56, 55, 53, 52, 51, 49, 48, 46, 45, 43, 42, 41, 39, 38, 36, 35, 34, 32, 31, 32, 33, 34, 36, 37, 38, 40, 41, 42, 44, 45, 46, 48, 49, 50, 52, 53, 54, 56, 57, 58, 60, 61, 62, 64, 65, 66, 68, 69, 70, 72, 73, 75, 76, 77, 79, 80, 81, 83, 84, 85, 87, 88, 89, 91, 92, 93, 95, 96, 97, 99, 100, 101, 103, 104, 105, 107, 108, 109, 111, 112, 113, 115, 116, 117, 119, 120, 121, 123, 124, 125, 127, 128, 129, 131, 132, 133, 135, 136, 137, 139, 140, 141, 143, 144, 145, 147, 148, 149, 151, 152, 153, 155, 156, 157, 159, 160, 161, 163, 164, 165, 167, 168, 169, 171, 172, 173, 175, 176, 177, 179, 180, 181, 183, 184, 185, 187, 188, 189, 191, 192, 193, 195, 195};
int BLUE16[] = {255, 255, 254, 251, 250, 249, 248, 247, 246, 245, 244, 243, 242, 241, 240, 239, 238, 237, 236, 235, 234, 233, 232, 231, 230, 229, 228, 227, 226, 225, 224, 223, 222, 221, 220, 219, 218, 217, 216, 215, 214, 213, 212, 211, 210, 209, 208, 207, 206, 205, 204, 203, 202, 201, 200, 199, 198, 197, 196, 195, 194, 193, 192, 191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 181, 180, 179, 178, 177, 176, 175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 158, 157, 156, 155, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 130, 129, 128, 127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 13, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0};
int RED17[] = {33, 33, 32, 31, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 17, 16, 15, 14, 12, 11, 13, 8, 7, 5, 4, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 5, 7, 8, 13, 11, 13, 14, 15, 17, 18, 19, 20, 21, 29, 36, 42, 48, 53, 58, 61, 65, 68, 70, 72, 73, 74, 74, 74, 75, 75, 76, 76, 76, 77, 76, 77, 78, 79, 80, 81, 83, 84, 85, 86, 88, 89, 91, 92, 91, 94, 96, 98, 100, 102, 104, 106, 108, 109, 111, 112, 113, 115, 116, 117, 119, 120, 121, 123, 124, 125, 127, 128, 129, 131, 132, 133, 135, 136, 137, 138, 140, 141, 142, 144, 145, 146, 148, 149, 150, 152, 153, 154, 156, 157, 158, 160, 161, 162, 164, 165, 166, 168, 169, 170, 172, 173, 174, 175, 177, 178, 179, 181, 182, 183, 185, 186, 187, 189, 190, 191, 193, 193};
int GREEN17[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 5, 6, 8, 13, 12, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 42, 44, 46, 49, 51, 53, 56, 58, 60, 63, 65, 68, 71, 73, 76, 78, 81, 84, 87, 89, 92, 95, 98, 101, 104, 107, 110, 113, 116, 119, 122, 125, 128, 131, 134, 138, 141, 144, 148, 151, 154, 158, 161, 165, 168, 172, 175, 179, 182, 186, 190, 193, 197, 201, 205, 209, 212, 216, 220, 224, 228, 232, 234, 235, 236, 238, 239, 240, 241, 243, 244, 245, 246, 247, 249, 249, 246, 244, 241, 237, 232, 227, 223, 218, 214, 209, 205, 201, 196, 192, 188, 184, 180, 175, 171, 167, 163, 160, 156, 152, 148, 144, 141, 137, 133, 130, 126, 123, 119, 116, 116, 115, 113, 112, 110, 109, 104, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 88, 88, 88, 87, 86, 85, 85, 84, 83, 82, 80, 79, 78, 76, 75, 74, 73, 71, 70, 69, 68, 67, 66, 64, 63, 61, 58, 56, 54, 52, 49, 47, 45, 43, 41, 40, 38, 36, 34, 33, 31, 29, 28, 26, 25, 23, 22, 21, 19, 18, 17, 16, 14, 13, 12, 11, 13, 9, 8, 7, 7, 6, 5, 4, 4, 3, 2, 2, 1, 1, 0, 0, 0, 0};
int BLUE17[] = {96, 96, 97, 99, 100, 101, 102, 104, 105, 106, 107, 108, 110, 111, 112, 113, 115, 116, 117, 118, 119, 121, 122, 123, 124, 125, 127, 128, 129, 130, 132, 133, 134, 135, 136, 138, 139, 140, 141, 143, 144, 145, 146, 147, 149, 150, 151, 152, 154, 155, 156, 157, 158, 160, 161, 162, 163, 164, 166, 167, 168, 169, 171, 172, 173, 174, 175, 177, 178, 179, 180, 182, 183, 184, 185, 186, 188, 189, 190, 191, 193, 194, 195, 196, 197, 199, 200, 201, 202, 203, 205, 206, 207, 208, 210, 211, 212, 213, 214, 216, 217, 218, 219, 221, 222, 223, 224, 225, 227, 228, 229, 230, 232, 233, 232, 230, 229, 227, 225, 223, 222, 220, 218, 216, 214, 212, 210, 208, 149, 142, 135, 127, 118, 111, 103, 95, 88, 81, 74, 67, 60, 53, 47, 40, 34, 28, 22, 22, 23, 24, 25, 26, 27, 28, 28, 29, 30, 30, 31, 31, 32, 32, 29, 28, 26, 25, 23, 22, 20, 18, 17, 16, 15, 14, 13, 12, 11, 13, 9, 8, 7, 6, 5, 5, 4, 3, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int RED18[] = {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 251, 249, 247, 245, 243, 241, 239, 237, 235, 233, 231, 229, 227, 225, 223, 221, 219, 217, 216, 214, 212, 210, 208, 206, 204, 202, 200, 198, 196, 194, 192, 190, 188, 186, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 8, 13, 19, 25, 30, 36, 42, 48, 53, 59, 65, 71, 76, 82, 88, 93, 99, 105, 111, 116, 122, 128, 133, 139, 145, 151, 156, 162, 168, 173, 179, 185, 191, 196, 202, 208, 214, 219, 225, 231, 236, 242, 248, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN18[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 146, 152, 157, 163, 169, 174, 180, 186, 192, 197, 203, 209, 214, 220, 226, 232, 237, 243, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 244, 238, 233, 227, 221, 215, 210, 204, 198, 193, 187, 181, 175, 170, 170};
int BLUE18[] = {72, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 91, 93, 95, 97, 99, 101, 103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131, 133, 135, 137, 139, 141, 142, 144, 146, 148, 150, 152, 154, 156, 158, 160, 162, 164, 166, 168, 170, 172, 174, 176, 178, 180, 182, 184, 186, 188, 190, 191, 193, 195, 197, 199, 201, 203, 205, 207, 209, 211, 213, 215, 217, 219, 221, 223, 225, 227, 229, 231, 233, 235, 237, 239, 241, 242, 244, 246, 248, 250, 252, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 249, 243, 237, 232, 226, 220, 214, 209, 203, 197, 192, 186, 180, 174, 169, 163, 157, 152, 146, 140, 134, 129, 123, 117, 112, 106, 100, 94, 89, 83, 77, 71, 66, 60, 54, 49, 43, 37, 31, 26, 20, 14, 9, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int RED19[] = {251, 251, 251, 251, 252, 252, 253, 252, 252, 251, 251, 250, 250, 249, 249, 249, 248, 248, 247, 247, 246, 246, 246, 245, 245, 244, 244, 243, 243, 243, 242, 242, 241, 241, 241, 240, 240, 240, 239, 239, 239, 238, 238, 237, 235, 230, 226, 222, 217, 213, 209, 205, 201, 197, 194, 190, 186, 183, 179, 176, 173, 169, 166, 163, 160, 157, 154, 151, 148, 145, 143, 140, 137, 135, 133, 130, 128, 126, 124, 122, 120, 118, 116, 114, 112, 111, 109, 109, 110, 111, 113, 114, 115, 116, 117, 118, 119, 121, 122, 123, 125, 125, 126, 127, 128, 129, 131, 132, 133, 135, 136, 137, 138, 139, 140, 140, 141, 142, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 171, 172, 174, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 185, 186, 187, 188, 189, 190, 190, 191, 192, 193, 194, 195, 196, 197, 199, 200, 202, 203, 204, 206, 207, 208, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 220, 221, 222, 223, 224, 225, 226, 226, 227, 228, 228, 229, 230, 230, 231, 232, 232, 233, 233, 234, 235, 235, 235, 236, 236, 236, 237, 237, 237, 238, 238, 239, 239, 239, 240, 240, 240, 241, 242, 242, 242, 242, 243, 243, 244, 244, 244, 245, 245, 246, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251};
int GREEN19[] = {0, 0, 0, 1, 1, 2, 2, 4, 5, 7, 8, 7, 9, 13, 8, 15, 17, 18, 20, 21, 23, 24, 26, 27, 28, 30, 31, 33, 34, 35, 37, 38, 40, 41, 42, 44, 45, 46, 48, 49, 50, 52, 53, 55, 56, 57, 59, 60, 61, 63, 64, 65, 66, 68, 69, 70, 72, 73, 74, 76, 77, 78, 79, 81, 82, 83, 84, 85, 86, 87, 88, 90, 91, 92, 93, 95, 96, 97, 98, 99, 101, 102, 103, 104, 105, 107, 108, 110, 114, 118, 122, 125, 129, 132, 136, 139, 143, 146, 149, 152, 156, 158, 161, 164, 167, 170, 173, 175, 178, 181, 184, 186, 188, 191, 193, 195, 197, 199, 201, 203, 205, 207, 209, 211, 213, 215, 216, 218, 220, 221, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 224, 224, 224, 224, 224, 224, 224, 224, 225, 225, 225, 225, 225, 225, 225, 226, 226, 226, 226, 226, 226, 227, 227, 227, 227, 227, 228, 228, 228, 228, 228, 229, 229, 229, 229, 229, 229, 230, 230, 230, 230, 231, 231, 232, 232, 232, 232, 232, 233, 233, 233, 234, 234, 234, 234, 235, 235, 235, 236, 236, 236, 236, 236, 237, 237, 237, 237, 238, 238, 238, 239, 239, 239, 240, 240, 241, 241, 242, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 250};
int BLUE19[] = {3, 3, 9, 15, 22, 28, 34, 41, 48, 55, 62, 66, 73, 81, 84, 94, 100, 106, 112, 118, 124, 130, 135, 141, 147, 152, 157, 162, 168, 173, 178, 183, 187, 192, 197, 201, 206, 210, 215, 219, 223, 227, 231, 235, 237, 237, 236, 236, 236, 235, 235, 235, 235, 234, 234, 234, 233, 233, 233, 232, 232, 232, 232, 231, 231, 231, 230, 230, 230, 230, 230, 229, 229, 229, 229, 228, 228, 228, 228, 228, 227, 227, 227, 227, 227, 226, 226, 226, 226, 226, 225, 225, 225, 225, 225, 225, 225, 224, 224, 224, 224, 224, 224, 224, 224, 224, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 221, 220, 218, 217, 216, 214, 213, 212, 211, 210, 208, 207, 206, 206, 205, 204, 203, 202, 202, 201, 200, 200, 199, 198, 198, 197, 197, 197, 196, 197, 196, 196, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 196, 196, 197, 198, 199, 200, 201, 201, 202, 203, 204, 205, 205, 206, 207, 208, 209, 209, 210, 211, 212, 212, 213, 213, 214, 215, 216, 216, 217, 218, 218, 219, 220, 221, 221, 222, 223, 223, 224, 225, 226, 226, 227, 228, 228, 229, 230, 230, 231, 232, 232, 233, 233, 234, 235, 235, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 243, 243, 244, 244, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 250};
int RED20[] = {253, 253, 251, 250, 250, 249, 249, 248, 248, 247, 247, 246, 246, 246, 245, 245, 244, 244, 244, 243, 243, 242, 242, 242, 241, 241, 240, 240, 240, 239, 239, 239, 238, 238, 238, 237, 237, 236, 236, 236, 235, 235, 235, 235, 234, 233, 233, 232, 232, 231, 231, 230, 229, 229, 228, 227, 226, 226, 225, 224, 223, 223, 222, 221, 220, 219, 218, 217, 216, 215, 214, 213, 212, 211, 210, 208, 207, 206, 205, 204, 202, 200, 199, 198, 196, 195, 194, 192, 192, 191, 191, 190, 189, 188, 187, 185, 185, 184, 183, 183, 182, 181, 180, 179, 178, 177, 176, 175, 174, 173, 172, 172, 171, 170, 169, 168, 167, 166, 165, 165, 164, 163, 162, 161, 160, 159, 158, 157, 156, 155, 154, 153, 152, 151, 149, 148, 147, 146, 145, 144, 143, 142, 140, 139, 138, 138, 137, 136, 135, 134, 132, 131, 130, 129, 128, 127, 126, 125, 124, 122, 121, 120, 119, 118, 118, 116, 114, 113, 112, 111, 111, 109, 108, 109, 111, 114, 115, 117, 118, 120, 123, 125, 127, 129, 131, 134, 137, 139, 141, 144, 147, 150, 152, 155, 158, 161, 164, 167, 171, 174, 177, 181, 184, 188, 192, 195, 199, 203, 207, 211, 216, 220, 224, 228, 233, 237, 238, 239, 239, 240, 240, 240, 241, 241, 241, 242, 242, 243, 243, 243, 244, 244, 245, 245, 245, 246, 246, 247, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 254, 254};
int GREEN20[] = {252, 252, 250, 250, 249, 249, 248, 248, 247, 247, 246, 246, 245, 245, 244, 244, 243, 242, 242, 241, 241, 240, 239, 239, 238, 238, 237, 236, 236, 235, 235, 234, 233, 233, 232, 232, 231, 230, 230, 229, 228, 228, 227, 226, 226, 225, 224, 223, 223, 222, 221, 221, 220, 219, 218, 218, 217, 217, 216, 215, 214, 214, 213, 212, 211, 211, 209, 209, 208, 208, 206, 206, 205, 205, 204, 202, 202, 201, 201, 200, 199, 197, 197, 196, 196, 195, 195, 194, 194, 194, 194, 194, 194, 194, 195, 194, 195, 195, 195, 196, 196, 196, 197, 197, 198, 198, 199, 199, 200, 200, 201, 202, 203, 204, 204, 205, 206, 207, 208, 210, 211, 212, 213, 215, 216, 217, 219, 220, 222, 222, 222, 222, 222, 222, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 224, 224, 224, 224, 224, 224, 224, 224, 224, 225, 225, 225, 225, 225, 225, 225, 226, 226, 226, 226, 226, 227, 227, 227, 227, 227, 227, 228, 228, 228, 228, 229, 229, 229, 229, 229, 230, 230, 230, 230, 231, 231, 231, 231, 232, 232, 232, 232, 233, 233, 233, 234, 234, 234, 234, 235, 235, 235, 236, 236, 236, 237, 237, 237, 238, 238, 235, 231, 227, 223, 218, 214, 210, 205, 201, 196, 191, 187, 182, 177, 172, 167, 162, 157, 151, 146, 140, 135, 129, 123, 117, 111, 106, 99, 93, 85, 78, 74, 67, 61, 54, 47, 40, 33, 27, 27};
int BLUE20[] = {252, 252, 250, 250, 249, 249, 248, 248, 247, 247, 246, 246, 245, 245, 244, 244, 243, 243, 243, 242, 242, 241, 241, 241, 240, 240, 239, 239, 239, 238, 238, 238, 237, 237, 237, 237, 236, 236, 236, 236, 235, 235, 235, 235, 234, 234, 234, 234, 233, 233, 233, 232, 232, 232, 232, 231, 231, 231, 230, 230, 230, 230, 229, 229, 229, 229, 229, 228, 228, 228, 228, 227, 227, 227, 227, 227, 226, 226, 226, 226, 226, 226, 225, 226, 225, 225, 225, 225, 224, 225, 224, 224, 224, 224, 224, 224, 224, 224, 224, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 220, 218, 217, 215, 213, 211, 210, 208, 206, 204, 202, 200, 197, 195, 193, 191, 188, 186, 183, 181, 178, 176, 173, 170, 168, 165, 162, 159, 156, 153, 150, 146, 143, 140, 137, 133, 129, 126, 122, 118, 116, 112, 107, 106, 105, 105, 104, 102, 100, 99, 99, 97, 96, 94, 93, 93, 91, 90, 88, 88, 86, 85, 83, 83, 81, 80, 78, 78, 76, 75, 73, 72, 71, 70, 69, 67, 66, 65, 63, 62, 62, 59, 58, 58, 55, 54, 54, 51, 50, 49, 47, 46, 45, 43, 42, 41, 39, 38, 36, 35, 34, 32, 31, 30, 28, 27, 25, 24, 23, 22, 20, 18, 17, 15, 14, 13, 8, 13, 8, 7, 5, 4, 2, 1, 0, 0};
int RED21[] = {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 247, 242, 237, 233, 228, 223, 219, 214, 210, 205, 201, 196, 192, 188, 184, 179, 175, 171, 167, 163, 159, 155, 151, 147, 144, 140, 136, 133, 129, 125, 122, 118, 115, 112, 108, 105, 102, 99, 95, 92, 89, 86, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 172, 175, 177, 180, 183, 186, 188, 191, 194, 196, 199, 201, 203, 206, 208, 210, 213, 215, 217, 219, 221, 223, 225, 227, 229, 230, 232, 234, 236, 237, 239, 240, 242, 243, 245, 246, 247, 248, 250, 251, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN21[] = {0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 87, 92, 97, 102, 107, 111, 116, 121, 125, 130, 134, 139, 143, 147, 152, 156, 160, 164, 168, 172, 176, 180, 184, 188, 192, 196, 199, 203, 207, 210, 214, 217, 221, 224, 228, 231, 234, 238, 241, 244, 247, 250, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 251, 251, 250, 249, 249, 248, 247, 247, 246, 246, 246, 245, 245, 245, 245, 244, 244, 244, 244, 244, 244, 245, 245, 245, 245, 246, 246, 246, 247, 247, 248, 249, 249, 250, 251, 251, 251};
int BLUE21[] = {3, 3, 13, 17, 23, 30, 37, 44, 50, 57, 63, 70, 76, 82, 89, 95, 101, 107, 114, 120, 126, 132, 138, 144, 149, 155, 161, 167, 172, 178, 184, 189, 195, 200, 205, 211, 216, 221, 227, 232, 237, 242, 247, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 250, 247, 244, 242, 239, 236, 234, 231, 229, 226, 224, 221, 219, 217, 214, 212, 210, 208, 206, 204, 202, 200, 198, 196, 194, 192, 191, 189, 187, 186, 184, 183, 181, 180, 179, 177, 176, 175, 174, 173, 172, 171, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 251};
int RED22[] = {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 251, 249, 248, 247, 246, 244, 243, 241, 240, 238, 237, 235, 233, 231, 230, 228, 226, 224, 222, 220, 218, 216, 213, 211, 209, 207, 204, 202, 199, 197, 194, 192, 189, 187, 184, 181, 178, 175, 172, 170, 168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 158, 157, 156, 155, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 130, 129, 128, 127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 85, 84, 84, 88, 91, 94, 97, 100, 103, 107, 110, 114, 117, 121, 124, 128, 131, 135, 139, 143, 146, 150, 154, 158, 162, 166, 170, 174, 179, 183, 187, 191, 196, 200, 205, 209, 214, 218, 223, 228, 233, 237, 242, 247, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN22[] = {253, 253, 252, 251, 250, 249, 248, 247, 246, 245, 244, 243, 242, 241, 240, 239, 238, 237, 236, 235, 234, 233, 232, 231, 230, 229, 228, 227, 226, 225, 224, 223, 222, 221, 220, 219, 218, 217, 216, 215, 214, 213, 212, 211, 210, 209, 208, 207, 206, 205, 204, 203, 202, 201, 200, 199, 198, 197, 196, 195, 194, 193, 192, 191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 181, 180, 179, 178, 177, 176, 175, 174, 173, 172, 171, 170, 169, 169, 169, 170, 171, 172, 173, 174, 176, 177, 178, 180, 181, 183, 184, 186, 188, 189, 191, 193, 195, 197, 199, 201, 203, 205, 207, 209, 211, 214, 216, 218, 221, 223, 226, 228, 231, 233, 236, 239, 241, 244, 247, 250, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 247, 242, 237, 232, 226, 221, 216, 211, 205, 200, 194, 189, 183, 178, 172, 166, 160, 155, 149, 143, 137, 131, 125, 119, 113, 107, 100, 94, 88, 81, 75, 69, 62, 56, 49, 42, 36, 29, 29};
int BLUE22[] = {253, 253, 252, 251, 250, 249, 248, 248, 247, 247, 246, 246, 245, 245, 244, 244, 244, 244, 243, 243, 243, 243, 243, 243, 243, 243, 244, 244, 244, 244, 245, 245, 246, 246, 247, 247, 248, 249, 250, 250, 251, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 250, 247, 244, 241, 237, 234, 231, 227, 224, 220, 217, 213, 210, 206, 203, 199, 195, 191, 187, 183, 179, 175, 171, 167, 163, 159, 155, 150, 146, 142, 137, 133, 128, 124, 119, 114, 110, 105, 100, 95, 90, 86, 83, 82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 13, 9, 8, 7, 6, 5, 4, 3, 2, 2};
int RED23[] = {0, 0, 127, 191, 188, 186, 184, 182, 179, 177, 140, 138, 170, 168, 165, 163, 161, 158, 156, 154, 121, 119, 147, 145, 142, 140, 138, 135, 133, 131, 103, 101, 124, 122, 119, 117, 115, 112, 110, 108, 84, 82, 101, 99, 96, 94, 92, 89, 87, 85, 66, 64, 78, 76, 73, 71, 69, 66, 64, 62, 47, 46, 55, 52, 50, 48, 46, 43, 41, 39, 29, 27, 32, 29, 27, 25, 23, 20, 18, 16, 11, 9, 9, 6, 4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 12, 18, 24, 30, 36, 42, 48, 54, 48, 53, 72, 78, 85, 91, 97, 103, 109, 115, 97, 102, 133, 139, 145, 151, 157, 163, 170, 176, 145, 150, 194, 200, 206, 212, 218, 224, 230, 236, 194, 199, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255};
int GREEN23[] = {0, 0, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 12, 18, 19, 24, 36, 42, 48, 54, 60, 66, 72, 78, 68, 72, 97, 103, 109, 115, 121, 127, 133, 139, 116, 121, 157, 163, 170, 176, 182, 188, 194, 200, 165, 170, 218, 224, 230, 236, 242, 248, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 248, 242, 235, 229, 223, 216, 210, 163, 158, 191, 184, 178, 172, 165, 159, 153, 146, 112, 107, 127, 121, 115, 110, 104, 98, 92, 86, 64, 60, 69, 63, 57, 52, 46, 40, 34, 28, 18, 13, 11, 5, 0, 0};
int BLUE23[] = {0, 0, 127, 191, 192, 192, 193, 194, 195, 195, 157, 157, 198, 198, 199, 200, 201, 202, 202, 203, 163, 164, 205, 206, 207, 208, 208, 209, 210, 211, 169, 170, 213, 214, 215, 215, 216, 217, 218, 218, 175, 176, 221, 221, 222, 223, 224, 225, 225, 226, 181, 182, 228, 229, 230, 231, 231, 232, 233, 234, 188, 188, 236, 237, 238, 238, 239, 240, 241, 241, 194, 194, 244, 245, 245, 246, 247, 248, 248, 249, 200, 200, 251, 252, 253, 254, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 255, 204, 204, 255, 255, 255, 255, 255, 255, 255, 248, 194, 189, 230, 224, 218, 212, 206, 200, 194, 188, 145, 140, 169, 163, 157, 151, 145, 139, 133, 127, 97, 92, 109, 103, 97, 91, 84, 78, 72, 66, 48, 43, 48, 42, 36, 30, 24, 18, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 7, 10, 12, 15, 17, 16, 18, 25, 28, 30, 33, 35, 38, 40, 43, 36, 38, 51, 48, 46, 44, 41, 39, 37, 34, 25, 24, 27, 25, 23, 20, 18, 16, 13, 11, 7, 5, 4, 2, 0, 0};
int RED24[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 17, 21, 25, 29, 34, 38, 42, 46, 51, 55, 59, 64, 68, 72, 76, 81, 85, 89, 93, 98, 102, 106, 110, 115, 119, 123, 128, 132, 136, 140, 76, 76, 76, 81, 85, 89, 93, 98, 102, 106, 110, 115, 119, 123, 128, 132, 136, 140, 145, 149, 153, 157, 157, 161, 164, 167, 170, 173, 177, 180, 183, 186, 189, 193, 196, 199, 202, 205, 209, 212, 215, 218, 218, 219, 220, 222, 223, 224, 225, 226, 227, 229, 230, 231, 232, 233, 234, 236, 237, 238, 239, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int GREEN24[] = {251, 251, 249, 247, 245, 243, 241, 238, 236, 234, 232, 230, 228, 226, 224, 221, 219, 217, 215, 213, 211, 209, 206, 204, 202, 200, 198, 196, 194, 192, 189, 187, 185, 183, 181, 179, 177, 174, 172, 170, 168, 166, 164, 162, 160, 157, 155, 153, 151, 149, 147, 145, 142, 140, 138, 136, 134, 132, 130, 128, 128, 129, 131, 133, 134, 136, 138, 139, 141, 143, 145, 146, 148, 150, 151, 153, 155, 157, 158, 160, 162, 163, 165, 167, 168, 170, 172, 174, 175, 177, 179, 180, 182, 182, 177, 171, 165, 160, 154, 149, 143, 138, 132, 126, 121, 115, 110, 104, 99, 93, 88, 82, 76, 71, 65, 60, 54, 49, 43, 37, 32, 26, 21, 15, 13, 4, 0, 0, 0, 4, 8, 12, 17, 21, 25, 29, 34, 38, 42, 46, 51, 55, 59, 64, 68, 72, 76, 81, 81, 85, 89, 93, 98, 102, 106, 110, 115, 119, 123, 128, 132, 136, 140, 145, 149, 153, 157, 162, 162, 166, 170, 174, 179, 183, 187, 192, 196, 200, 204, 209, 213, 217, 221, 226, 230, 234, 238, 243, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int BLUE24[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 17, 21, 25, 29, 34, 38, 42, 46, 51, 55, 59, 64, 68, 72, 76, 81, 85, 89, 93, 98, 102, 106, 110, 115, 119, 123, 128, 132, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 76, 76, 76, 72, 68, 64, 60, 56, 52, 48, 44, 40, 36, 32, 28, 23, 19, 15, 11, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 17, 21, 25, 29, 34, 38, 42, 46, 51, 55, 59, 64, 68, 72, 76, 81, 81, 84, 88, 91, 95, 98, 102, 105, 109, 113, 116, 120, 123, 127, 130, 134, 137, 141, 145, 148, 152, 155, 159, 159, 162, 166, 170, 173, 177, 181, 184, 188, 192, 195, 199, 203, 206, 210, 214, 217, 221, 225, 228, 232, 236, 239, 0, 0, 0};
int RED25[] = {124, 124, 120, 115, 111, 106, 102, 97, 93, 88, 84, 79, 75, 70, 66, 61, 57, 52, 48, 43, 39, 34, 30, 25, 21, 16, 12, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 5, 13, 14, 19, 23, 28, 32, 37, 41, 46, 50, 55, 59, 64, 68, 73, 77, 82, 86, 91, 95, 100, 104, 109, 113, 118, 123, 126, 132, 135, 141, 144, 150, 153, 159, 162, 168, 171, 177, 180, 186, 189, 195, 198, 204, 207, 213, 216, 222, 225, 231, 234, 240, 243, 249, 252, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 255, 255};
int GREEN25[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 6, 11, 15, 20, 24, 29, 33, 38, 42, 47, 51, 56, 60, 65, 69, 74, 78, 83, 87, 92, 96, 101, 105, 110, 114, 119, 122, 128, 131, 137, 140, 146, 149, 155, 158, 164, 167, 173, 176, 182, 185, 191, 194, 200, 203, 209, 212, 218, 221, 227, 230, 236, 240, 245, 249, 254, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 252, 247, 243, 238, 234, 229, 225, 220, 216, 211, 207, 202, 198, 193, 189, 184, 180, 175, 171, 166, 162, 157, 153, 148, 144, 139, 135, 131, 126, 122, 117, 113, 108, 104, 99, 95, 90, 86, 81, 77, 72, 68, 63, 59, 54, 50, 45, 41, 36, 32, 27, 23, 18, 14, 9, 5, 5};
int BLUE25[] = {255, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 250, 247, 241, 238, 232, 229, 223, 220, 214, 211, 205, 202, 196, 193, 187, 184, 178, 175, 169, 166, 160, 157, 151, 148, 142, 139, 133, 130, 125, 121, 116, 112, 107, 103, 98, 94, 89, 85, 80, 76, 71, 67, 62, 58, 53, 49, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int RED26[] = {0, 0, 127, 123, 119, 114, 110, 106, 102, 97, 84, 80, 76, 80, 76, 72, 67, 63, 59, 55, 45, 42, 38, 38, 33, 29, 25, 21, 16, 12, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 17, 25, 34, 42, 51, 59, 61, 68, 76, 93, 102, 110, 119, 127, 136, 144, 137, 145, 153, 178, 187, 195, 204, 212, 221, 229, 214, 221, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 253, 251, 249, 248, 246, 244, 242, 217, 215, 213, 236, 234, 232, 230, 229, 227, 225, 201, 200, 198, 218, 217, 215, 213, 211, 210, 208, 186, 184, 182, 201, 199, 198, 196, 194, 192, 191, 170, 169, 167, 184, 182, 180, 179, 177, 175, 174, 155, 153, 151, 167, 165, 163, 161, 160, 158, 156, 139, 138, 136, 149, 148, 146, 144, 143, 141, 139, 124, 122, 120, 132, 130, 130};
int GREEN26[] = {0, 0, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 34, 51, 68, 85, 102, 119, 122, 137, 153, 187, 204, 221, 238, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 250, 246, 242, 238, 233, 229, 225, 198, 195, 191, 208, 204, 199, 195, 191, 187, 182, 160, 156, 152, 165, 161, 157, 153, 148, 144, 140, 122, 118, 114, 125, 123, 121, 119, 116, 114, 112, 99, 97, 95, 104, 102, 99, 97, 95, 93, 91, 80, 78, 76, 82, 80, 78, 76, 74, 72, 70, 61, 59, 57, 61, 59, 57, 55, 53, 50, 48, 42, 40, 38, 40, 38, 36, 33, 31, 29, 27, 22, 21, 19, 19, 16, 14, 12, 13, 8, 6, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int BLUE26[] = {0, 0, 127, 193, 195, 197, 199, 201, 204, 206, 187, 189, 191, 214, 216, 218, 221, 223, 225, 227, 206, 208, 210, 235, 238, 240, 242, 244, 246, 248, 225, 227, 229, 255, 255, 255, 255, 255, 255, 255, 229, 229, 229, 255, 255, 255, 255, 255, 238, 221, 183, 168, 152, 153, 135, 118, 101, 84, 67, 50, 30, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int RED27[] = {255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 18, 27, 36, 45, 49, 57, 72, 81, 91, 100, 109, 118, 127, 136, 131, 139, 163, 173, 182, 191, 200, 209, 218, 227, 213, 221, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 253, 251, 249, 247, 245, 243, 241, 215, 214, 235, 234, 232, 230, 228, 226, 224, 222, 198, 196, 216, 215, 213, 211, 209, 207, 205, 203, 181, 179, 197, 196, 194, 192, 190, 188, 186, 184, 164, 162, 178, 176, 175, 173, 171, 169, 167, 165, 147, 145, 159, 157, 156, 154, 152, 150, 148, 146, 130, 128, 140, 138, 137, 135, 133, 131, 129, 127, 113, 111, 121, 119, 117, 117};
int GREEN27[] = {255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 15, 23, 31, 39, 47, 55, 57, 64, 79, 87, 95, 103, 111, 119, 127, 135, 129, 136, 159, 167, 175, 183, 191, 199, 207, 215, 200, 207, 239, 247, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 250, 246, 242, 238, 233, 229, 225, 198, 195, 212, 208, 204, 199, 195, 191, 187, 182, 160, 156, 169, 165, 161, 157, 153, 148, 144, 140, 122, 118, 127, 125, 123, 121, 119, 116, 114, 112, 99, 97, 106, 104, 102, 99, 97, 95, 93, 91, 80, 78, 84, 82, 80, 78, 76, 74, 72, 70, 61, 59, 63, 61, 59, 57, 55, 53, 50, 48, 42, 40, 42, 40, 38, 36, 33, 31, 29, 27, 22, 21, 21, 19, 16, 14, 12, 13, 8, 6, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int BLUE27[] = {255, 255, 127, 131, 136, 140, 144, 148, 153, 157, 145, 149, 170, 174, 178, 182, 187, 191, 195, 199, 183, 187, 212, 216, 221, 225, 229, 233, 238, 242, 221, 225, 255, 247, 239, 231, 223, 215, 207, 199, 172, 164, 175, 167, 159, 151, 143, 135, 127, 119, 100, 93, 95, 87, 79, 71, 63, 55, 47, 39, 28, 21, 15, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int RED28[] = {4, 4, 5, 7, 9, 11, 12, 14, 15, 16, 17, 17, 18, 18, 18, 17, 16, 15, 14, 13, 11, 13, 8, 5, 3, 1, 0, 3, 5, 7, 13, 12, 13, 15, 17, 18, 19, 19, 19, 19, 19, 18, 16, 14, 12, 9, 5, 2, 2, 6, 11, 17, 23, 29, 36, 42, 49, 56, 64, 71, 78, 85, 93, 100, 106, 113, 119, 125, 130, 135, 139, 143, 146, 149, 150, 151, 152, 151, 150, 148, 145, 142, 138, 133, 127, 121, 114, 107, 99, 90, 82, 73, 63, 54, 44, 35, 25, 16, 6, 1, 13, 18, 25, 32, 38, 44, 48, 52, 55, 56, 57, 57, 56, 53, 50, 45, 39, 33, 25, 16, 6, 3, 15, 27, 40, 53, 67, 81, 96, 111, 126, 141, 156, 170, 185, 199, 212, 225, 237, 248, 252, 242, 234, 227, 222, 217, 214, 212, 212, 213, 216, 220, 225, 232, 240, 249, 251, 239, 226, 213, 198, 183, 167, 150, 133, 116, 98, 81, 64, 47, 30, 14, 1, 15, 29, 42, 54, 64, 73, 81, 87, 91, 94, 95, 95, 92, 88, 82, 75, 66, 55, 42, 28, 13, 3, 21, 40, 60, 81, 103, 125, 147, 170, 193, 216, 239, 249, 228, 207, 187, 168, 151, 134, 119, 106, 95, 85, 77, 71, 67, 65, 66, 68, 72, 79, 87, 98, 110, 124, 140, 158, 177, 197, 219, 241, 245, 221, 196, 171, 145, 120, 95, 70, 46, 23, 1, 19, 39, 57, 74, 89, 102, 112, 121, 127, 127};
int GREEN28[] = {51, 51, 58, 65, 72, 79, 85, 92, 99, 105, 111, 117, 124, 129, 135, 141, 146, 152, 157, 162, 167, 171, 176, 180, 184, 188, 191, 195, 198, 201, 203, 206, 208, 210, 212, 213, 214, 215, 216, 216, 216, 216, 216, 215, 215, 213, 212, 210, 209, 206, 204, 201, 199, 195, 192, 189, 185, 181, 177, 172, 168, 163, 158, 153, 148, 142, 137, 131, 125, 119, 113, 106, 100, 93, 87, 80, 73, 67, 60, 53, 46, 39, 32, 25, 18, 11, 4, 2, 9, 16, 22, 29, 36, 42, 49, 55, 61, 68, 74, 79, 85, 91, 96, 101, 106, 111, 116, 120, 125, 129, 133, 136, 140, 143, 146, 149, 151, 153, 155, 157, 159, 160, 161, 162, 162, 162, 162, 162, 162, 161, 160, 159, 157, 155, 153, 151, 148, 146, 143, 139, 136, 132, 128, 124, 120, 115, 111, 106, 101, 95, 90, 84, 79, 73, 67, 61, 54, 48, 42, 35, 28, 22, 15, 8, 1, 5, 12, 19, 26, 33, 40, 47, 54, 61, 67, 74, 81, 88, 94, 101, 107, 113, 120, 126, 131, 137, 143, 148, 154, 159, 164, 168, 173, 177, 181, 185, 189, 193, 196, 199, 202, 204, 207, 209, 211, 212, 214, 215, 216, 216, 216, 216, 216, 216, 215, 214, 213, 212, 210, 208, 206, 203, 201, 198, 194, 191, 187, 184, 180, 175, 171, 166, 161, 156, 151, 146, 140, 135, 129, 123, 117, 111, 104, 98, 91, 85, 78, 71, 64, 57, 50, 44, 37, 30, 23, 23};
int BLUE28[] = {116, 116, 105, 94, 84, 74, 64, 55, 46, 38, 30, 24, 18, 12, 8, 5, 2, 0, 0, 0, 1, 3, 6, 13, 14, 20, 26, 33, 41, 50, 59, 68, 78, 88, 99, 109, 120, 131, 142, 153, 163, 174, 184, 193, 202, 211, 218, 226, 232, 238, 243, 247, 250, 252, 253, 253, 253, 251, 249, 246, 241, 236, 230, 224, 216, 208, 200, 190, 181, 171, 160, 150, 139, 128, 117, 106, 96, 85, 75, 65, 56, 47, 39, 31, 24, 18, 13, 9, 5, 2, 0, 0, 0, 1, 3, 5, 9, 14, 19, 25, 32, 40, 48, 57, 67, 76, 87, 97, 108, 119, 130, 140, 151, 162, 172, 182, 192, 201, 209, 217, 225, 231, 237, 242, 246, 249, 252, 253, 254, 253, 252, 249, 246, 242, 237, 231, 225, 217, 209, 201, 192, 182, 172, 162, 151, 140, 130, 119, 108, 97, 87, 76, 67, 57, 48, 40, 32, 25, 19, 14, 9, 5, 3, 1, 0, 0, 0, 2, 5, 9, 13, 18, 24, 31, 39, 47, 56, 65, 75, 85, 96, 106, 117, 128, 139, 150, 160, 171, 181, 190, 200, 208, 216, 224, 230, 236, 241, 246, 249, 251, 253, 253, 253, 252, 250, 247, 243, 238, 232, 226, 218, 211, 202, 193, 184, 174, 163, 153, 142, 131, 120, 109, 99, 88, 78, 68, 59, 50, 41, 33, 26, 20, 14, 13, 6, 3, 1, 0, 0, 0, 2, 5, 8, 12, 18, 24, 30, 38, 46, 55, 64, 74, 84, 94, 105, 105};
int RED29[] = {105, 105, 105, 105, 105, 105, 105, 105, 105, 110, 114, 123, 127, 131, 135, 143, 147, 150, 157, 160, 163, 165, 170, 172, 174, 176, 179, 180, 180, 181, 182, 181, 181, 180, 179, 177, 174, 172, 170, 168, 163, 160, 157, 154, 147, 143, 139, 131, 127, 123, 119, 110, 105, 100, 96, 87, 82, 77, 68, 63, 59, 54, 46, 42, 38, 30, 26, 23, 19, 13, 13, 8, 5, 1, 0, 2, 5, 6, 6, 7, 8, 7, 7, 6, 5, 3, 2, 1, 3, 5, 8, 13, 16, 19, 26, 30, 34, 38, 46, 50, 54, 59, 68, 73, 77, 86, 91, 96, 100, 110, 114, 119, 127, 131, 135, 139, 147, 150, 154, 157, 163, 165, 168, 172, 174, 176, 177, 180, 180, 181, 182, 181, 181, 180, 179, 177, 176, 174, 170, 168, 165, 160, 157, 154, 150, 143, 139, 135, 127, 123, 119, 114, 105, 100, 96, 91, 82, 77, 73, 63, 59, 54, 50, 42, 38, 34, 30, 23, 19, 16, 13, 8, 5, 3, 0, 2, 3, 6, 6, 7, 7, 7, 7, 6, 6, 3, 2, 0, 3, 5, 8, 13, 16, 19, 23, 30, 34, 38, 42, 50, 54, 59, 63, 73, 77, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 0, 255, 255};
int GREEN29[] = {246, 246, 246, 246, 246, 246, 246, 246, 246, 251, 253, 244, 239, 235, 231, 224, 222, 219, 216, 214, 214, 213, 214, 215, 216, 218, 223, 226, 229, 237, 241, 246, 251, 248, 243, 237, 225, 218, 212, 205, 192, 186, 179, 173, 160, 154, 148, 137, 132, 127, 122, 113, 109, 105, 102, 96, 94, 92, 89, 88, 88, 88, 88, 89, 90, 93, 95, 97, 99, 104, 107, 110, 113, 120, 124, 127, 134, 138, 141, 145, 152, 155, 158, 164, 166, 169, 171, 175, 176, 178, 179, 180, 180, 180, 180, 179, 178, 176, 173, 171, 169, 166, 161, 158, 154, 148, 144, 140, 136, 128, 124, 120, 112, 108, 104, 100, 92, 88, 85, 81, 74, 71, 68, 62, 60, 57, 55, 51, 50, 48, 46, 45, 44, 44, 43, 43, 43, 44, 44, 45, 46, 47, 48, 49, 51, 53, 54, 55, 57, 59, 60, 61, 63, 64, 64, 65, 66, 67, 67, 67, 67, 67, 67, 66, 66, 65, 64, 62, 61, 60, 58, 56, 55, 53, 50, 48, 46, 43, 41, 39, 37, 34, 32, 30, 28, 25, 23, 22, 19, 17, 16, 15, 12, 11, 13, 8, 7, 6, 6, 4, 4, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255};
int BLUE29[] = {234, 234, 234, 234, 234, 234, 234, 234, 234, 222, 210, 186, 175, 164, 153, 132, 122, 113, 95, 87, 79, 72, 59, 54, 49, 44, 37, 34, 32, 30, 29, 30, 31, 34, 37, 40, 49, 54, 59, 66, 79, 87, 95, 104, 122, 132, 142, 164, 175, 186, 198, 222, 234, 246, 251, 227, 214, 202, 177, 165, 153, 141, 118, 107, 96, 75, 65, 56, 47, 30, 22, 15, 9, 2, 7, 12, 19, 22, 24, 25, 27, 26, 25, 22, 19, 16, 12, 2, 2, 9, 15, 30, 38, 47, 65, 75, 85, 96, 118, 129, 141, 153, 177, 189, 202, 226, 239, 251, 246, 222, 210, 198, 175, 164, 153, 142, 122, 113, 104, 95, 79, 72, 66, 54, 49, 44, 40, 34, 32, 31, 29, 30, 31, 32, 37, 40, 44, 49, 59, 66, 72, 87, 95, 104, 113, 132, 142, 153, 175, 186, 198, 210, 234, 246, 251, 239, 214, 202, 189, 165, 153, 141, 129, 107, 96, 85, 75, 56, 47, 38, 22, 15, 9, 2, 7, 12, 16, 22, 24, 25, 26, 26, 25, 24, 22, 16, 12, 7, 2, 9, 15, 22, 38, 47, 56, 75, 85, 96, 107, 129, 141, 153, 165, 189, 202, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 0, 255, 255};
int RED30[] = {54, 54, 59, 63, 68, 73, 77, 82, 82, 87, 91, 96, 100, 105, 110, 114, 119, 123, 127, 131, 135, 139, 143, 143, 147, 150, 154, 157, 160, 163, 165, 168, 170, 172, 174, 176, 177, 177, 179, 180, 180, 181, 181, 182, 181, 181, 180, 180, 179, 177, 176, 174, 174, 172, 170, 168, 165, 163, 160, 157, 154, 150, 147, 143, 139, 135, 131, 131, 127, 123, 119, 114, 110, 105, 100, 96, 91, 86, 82, 77, 73, 68, 68, 63, 59, 54, 50, 46, 42, 38, 34, 30, 26, 23, 19, 16, 13, 13, 13, 8, 5, 3, 1, 0, 2, 3, 5, 6, 6, 7, 7, 8, 8, 7, 7, 6, 6, 5, 3, 2, 0, 1, 3, 5, 8, 13, 13, 13, 16, 19, 23, 26, 30, 34, 38, 42, 46, 50, 54, 59, 63, 68, 68, 73, 77, 82, 87, 91, 96, 100, 105, 110, 114, 119, 123, 127, 131, 131, 135, 139, 143, 147, 150, 154, 157, 160, 163, 165, 168, 170, 172, 172, 174, 176, 177, 179, 180, 180, 181, 181, 182, 181, 181, 180, 180, 179, 179, 177, 176, 174, 172, 170, 168, 165, 163, 160, 157, 154, 150, 147, 143, 143, 139, 135, 131, 127, 123, 119, 114, 110, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 0, 255, 255};
int GREEN30[] = {67, 67, 67, 67, 67, 67, 67, 66, 66, 66, 65, 64, 64, 63, 62, 61, 60, 59, 57, 56, 55, 54, 53, 53, 52, 51, 49, 48, 47, 47, 46, 45, 44, 44, 44, 43, 43, 43, 43, 43, 44, 44, 45, 46, 47, 48, 50, 51, 53, 55, 57, 60, 60, 62, 65, 68, 71, 74, 78, 81, 85, 88, 92, 96, 100, 104, 108, 108, 112, 116, 120, 124, 128, 132, 136, 140, 144, 148, 151, 154, 158, 161, 161, 164, 166, 169, 171, 173, 175, 176, 178, 179, 180, 180, 180, 180, 180, 180, 179, 179, 178, 176, 175, 173, 171, 169, 166, 164, 161, 158, 155, 152, 152, 148, 145, 141, 138, 134, 131, 127, 124, 120, 117, 113, 110, 107, 104, 104, 101, 99, 97, 95, 93, 91, 90, 89, 88, 88, 88, 88, 88, 89, 89, 91, 92, 94, 96, 99, 102, 105, 109, 113, 117, 122, 127, 132, 137, 137, 142, 148, 154, 160, 166, 173, 179, 186, 192, 199, 205, 212, 218, 218, 225, 231, 237, 243, 248, 254, 251, 246, 241, 237, 233, 229, 226, 223, 223, 220, 218, 216, 215, 214, 213, 213, 214, 214, 216, 217, 219, 222, 224, 224, 228, 231, 235, 239, 244, 248, 253, 251, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 0, 255, 255};
int BLUE30[] = {141, 141, 153, 165, 177, 189, 202, 214, 214, 227, 239, 251, 246, 234, 222, 210, 198, 186, 175, 164, 153, 142, 132, 132, 122, 113, 104, 95, 87, 79, 72, 66, 59, 54, 49, 44, 40, 40, 37, 34, 32, 31, 30, 29, 30, 31, 32, 34, 37, 40, 44, 49, 49, 54, 59, 66, 72, 79, 87, 95, 104, 113, 122, 132, 142, 153, 164, 164, 175, 186, 198, 210, 222, 234, 246, 251, 239, 226, 214, 202, 189, 177, 177, 165, 153, 141, 129, 118, 107, 96, 85, 75, 65, 56, 47, 38, 30, 30, 22, 15, 9, 2, 2, 7, 12, 16, 19, 22, 24, 25, 26, 27, 27, 26, 25, 24, 22, 19, 16, 12, 7, 2, 2, 9, 15, 22, 30, 30, 38, 47, 56, 65, 75, 85, 96, 107, 118, 129, 141, 153, 165, 177, 177, 189, 202, 214, 227, 239, 251, 246, 234, 222, 210, 198, 186, 175, 164, 164, 153, 142, 132, 122, 113, 104, 95, 87, 79, 72, 66, 59, 54, 54, 49, 44, 40, 37, 34, 32, 31, 30, 29, 30, 31, 32, 34, 37, 37, 40, 44, 49, 54, 59, 66, 72, 79, 87, 95, 104, 113, 122, 132, 132, 142, 153, 164, 175, 186, 198, 210, 222, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 0, 255, 255};
int RED31[] = {0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 81, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240, 0, 0, 0, 0, 80, 80, 80, 80, 160, 160, 160, 160, 240, 240, 240, 240};
int GREEN31[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 192, 192, 192, 192, 192, 192, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240};
int BLUE31[] = {80, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 160};
int RED32[] = {2, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 39, 40, 41, 42, 43, 44, 45, 46, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 65, 66, 67, 68, 70, 71, 72, 74, 75, 77, 78, 79, 81, 82, 84, 85, 86, 88, 89, 90, 92, 93, 94, 95, 97, 98, 99, 100, 101, 102, 103, 103, 104, 105, 106, 107, 107, 108, 108, 109, 110, 110, 111, 111, 112, 113, 113, 114, 114, 115, 116, 117, 117, 118, 119, 120, 121, 122, 123, 124, 125, 127, 128, 129, 131, 132, 134, 135, 137, 138, 140, 142, 143, 145, 147, 149, 150, 152, 154, 155, 157, 158, 160, 161, 163, 164, 166, 167, 168, 169, 170, 171, 172, 173, 174, 174, 175, 175, 176, 176, 177, 177, 178, 178, 178, 178, 179, 179, 179, 180, 180, 180, 181, 181, 182, 182, 183, 184, 184, 185, 186, 187, 188, 190, 191, 192, 194, 195, 197, 198, 200, 202, 204, 206, 208, 210, 212, 214, 216, 218, 220, 222, 224, 225, 227, 229, 231, 232, 234, 236, 237, 238, 239, 241, 242, 242, 243, 244, 245, 245, 246, 246, 246, 246, 246, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 248, 248, 248, 249, 250, 251, 251, 252, 254, 255, 254, 252, 251, 249, 247, 247};
int GREEN32[] = {19, 19, 20, 22, 25, 29, 33, 38, 44, 51, 58, 65, 73, 81, 89, 98, 106, 115, 124, 132, 140, 148, 155, 162, 169, 175, 180, 184, 188, 191, 193, 194, 195, 194, 193, 191, 188, 184, 180, 175, 169, 162, 155, 148, 140, 132, 124, 115, 107, 98, 89, 81, 73, 65, 58, 51, 44, 38, 33, 29, 25, 22, 20, 19, 19, 19, 20, 22, 25, 29, 33, 38, 44, 51, 58, 65, 73, 81, 89, 98, 107, 115, 124, 132, 140, 148, 155, 162, 169, 175, 180, 184, 188, 191, 193, 194, 195, 194, 193, 191, 188, 184, 180, 175, 169, 162, 155, 148, 140, 132, 124, 115, 106, 98, 89, 81, 73, 65, 58, 51, 44, 38, 33, 29, 25, 22, 20, 19, 19, 19, 20, 22, 25, 29, 33, 38, 44, 51, 58, 65, 73, 81, 89, 98, 107, 115, 124, 132, 140, 148, 155, 162, 169, 175, 180, 184, 188, 191, 193, 194, 195, 194, 193, 191, 188, 184, 180, 175, 169, 162, 155, 148, 140, 132, 124, 115, 106, 98, 89, 81, 73, 65, 58, 51, 44, 38, 33, 29, 25, 22, 20, 19, 19, 19, 20, 22, 25, 29, 33, 38, 44, 51, 58, 65, 73, 81, 89, 98, 107, 115, 124, 132, 140, 148, 155, 162, 169, 175, 180, 184, 188, 191, 193, 194, 195, 194, 193, 191, 188, 184, 180, 175, 169, 162, 155, 148, 140, 132, 124, 115, 106, 98, 89, 81, 73, 65, 58, 51, 44, 38, 33, 29, 25, 22, 20, 20};
int BLUE32[] = {7, 7, 11, 15, 19, 22, 26, 30, 34, 39, 43, 47, 51, 55, 59, 63, 67, 71, 75, 78, 82, 86, 90, 93, 97, 100, 103, 107, 110, 113, 116, 119, 122, 125, 128, 130, 133, 136, 139, 141, 144, 147, 150, 153, 156, 159, 162, 165, 169, 172, 176, 180, 184, 188, 192, 196, 201, 205, 210, 215, 220, 225, 230, 235, 241, 246, 251, 253, 248, 243, 237, 232, 227, 222, 217, 212, 207, 202, 198, 194, 190, 186, 182, 179, 176, 172, 170, 167, 165, 162, 160, 158, 157, 155, 154, 152, 151, 150, 148, 147, 146, 144, 143, 141, 140, 138, 136, 134, 132, 129, 126, 123, 120, 116, 113, 108, 104, 99, 94, 89, 83, 78, 72, 65, 59, 53, 46, 39, 32, 25, 18, 11, 5, 253, 246, 239, 233, 227, 221, 215, 210, 205, 200, 195, 191, 188, 184, 181, 178, 176, 174, 172, 171, 170, 169, 169, 168, 168, 168, 168, 169, 169, 169, 169, 170, 170, 170, 169, 169, 168, 167, 166, 164, 162, 160, 157, 154, 150, 146, 141, 136, 131, 125, 119, 112, 106, 98, 91, 83, 75, 67, 58, 50, 41, 33, 24, 16, 8, 255, 247, 239, 232, 225, 219, 213, 207, 202, 197, 193, 189, 186, 183, 181, 179, 178, 177, 177, 177, 178, 179, 180, 181, 183, 184, 186, 188, 190, 192, 193, 195, 196, 197, 198, 198, 198, 198, 197, 195, 193, 191, 188, 184, 180, 175, 169, 163, 156, 149, 142, 133, 125, 116, 107, 97, 87, 87};
int RED33[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95, 99, 103, 107, 111, 115, 119, 123, 127, 131, 135, 139, 143, 147, 151, 155, 159, 163, 167, 171, 175, 179, 183, 187, 191, 195, 199, 203, 207, 211, 215, 219, 223, 227, 231, 235, 239, 243, 247, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 246, 241, 237, 233, 228, 224, 219, 215, 211, 206, 202, 197, 193, 189, 184, 180, 175, 171, 167, 162, 158, 153, 149, 145, 140, 136, 131, 131};
int GREEN33[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95, 99, 103, 107, 111, 115, 119, 123, 127, 131, 135, 139, 143, 147, 151, 155, 159, 163, 167, 171, 175, 179, 183, 187, 191, 195, 199, 203, 207, 211, 215, 219, 223, 227, 231, 235, 239, 243, 247, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 247, 243, 239, 235, 231, 227, 223, 219, 215, 211, 207, 203, 199, 195, 191, 187, 183, 179, 175, 171, 167, 163, 159, 155, 151, 147, 143, 139, 135, 131, 127, 123, 119, 115, 111, 107, 103, 99, 95, 91, 87, 83, 79, 75, 71, 67, 63, 59, 55, 51, 47, 43, 39, 35, 31, 27, 23, 19, 15, 11, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int BLUE33[] = {131, 131, 135, 139, 143, 147, 151, 155, 159, 163, 167, 171, 175, 179, 183, 187, 191, 195, 199, 203, 207, 211, 215, 219, 223, 227, 231, 235, 239, 243, 247, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 247, 243, 239, 235, 231, 227, 223, 219, 215, 211, 207, 203, 199, 195, 191, 187, 183, 179, 175, 171, 167, 163, 159, 155, 151, 147, 143, 139, 135, 131, 127, 123, 119, 115, 111, 107, 103, 99, 95, 91, 87, 83, 79, 75, 71, 67, 63, 59, 55, 51, 47, 43, 39, 35, 31, 27, 23, 19, 15, 11, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int RED34[] = {124, 124, 120, 115, 111, 106, 102, 97, 93, 88, 84, 79, 75, 70, 66, 61, 57, 52, 48, 43, 39, 34, 30, 25, 21, 16, 12, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 5, 13, 14, 19, 23, 28, 32, 37, 41, 46, 50, 55, 59, 64, 68, 73, 77, 82, 86, 91, 95, 100, 104, 109, 113, 118, 123, 127, 132, 136, 141, 145, 150, 154, 159, 163, 168, 172, 177, 181, 186, 190, 195, 199, 204, 208, 213, 217, 222, 226, 231, 235, 240, 244, 249, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
int GREEN34[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 6, 11, 15, 20, 24, 29, 33, 38, 42, 47, 51, 56, 60, 65, 69, 74, 78, 83, 87, 92, 96, 101, 105, 110, 114, 119, 123, 128, 132, 137, 141, 146, 150, 155, 159, 164, 168, 173, 177, 182, 186, 191, 195, 200, 204, 209, 213, 218, 222, 227, 231, 236, 241, 245, 250, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 248, 243, 239, 234, 230, 225, 221, 216, 212, 207, 203, 198, 194, 189, 185, 180, 176, 171, 167, 162, 158, 153, 149, 144, 140, 135, 131, 126, 122, 117, 113, 108, 104, 99, 95, 90, 86, 81, 77, 72, 68, 63, 59, 54, 50, 45, 41, 36, 32, 27, 23, 18, 14, 9, 5, 5};
int BLUE34[] = {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 247, 242, 238, 233, 229, 224, 220, 215, 211, 206, 202, 197, 193, 188, 184, 179, 175, 170, 166, 161, 157, 152, 148, 143, 139, 134, 130, 125, 121, 116, 112, 107, 103, 98, 94, 89, 85, 80, 76, 71, 67, 62, 58, 53, 49, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int RED35[] = {82, 82, 77, 73, 68, 63, 59, 54, 50, 46, 42, 38, 34, 30, 26, 23, 19, 16, 13, 13, 8, 5, 3, 1, 0, 2, 3, 5, 6, 6, 7, 7, 8, 7, 7, 6, 6, 5, 3, 2, 0, 1, 3, 5, 8, 13, 13, 16, 19, 23, 26, 30, 34, 38, 42, 46, 50, 54, 59, 63, 68, 73, 77, 82, 87, 91, 96, 100, 105, 110, 114, 119, 123, 127, 131, 135, 139, 143, 147, 150, 154, 157, 160, 163, 165, 168, 170, 172, 174, 176, 177, 179, 180, 180, 181, 181, 182, 181, 181, 180, 180, 179, 177, 176, 174, 172, 170, 168, 165, 163, 160, 157, 154, 150, 147, 143, 139, 135, 131, 127, 123, 119, 114, 110, 105, 100, 96, 91, 86, 82, 77, 73, 68, 63, 59, 54, 50, 46, 42, 38, 34, 30, 26, 23, 19, 16, 13, 13, 8, 5, 3, 1, 0, 2, 3, 5, 6, 6, 7, 7, 8, 7, 7, 6, 6, 5, 3, 2, 0, 1, 3, 5, 8, 13, 13, 16, 19, 23, 26, 30, 34, 38, 42, 46, 50, 54, 59, 63, 68, 73, 77, 82, 87, 91, 96, 100, 105, 110, 114, 119, 123, 127, 131, 135, 139, 143, 147, 150, 154, 157, 160, 163, 165, 168, 170, 172, 174, 176, 177, 179, 180, 180, 181, 181, 182, 181, 181, 180, 180, 179, 177, 176, 174, 172, 170, 168, 165, 163, 160, 157, 154, 150, 147, 143, 139, 135, 131, 127, 123, 119, 114, 110, 105, 100, 96, 96};
int GREEN35[] = {0, 0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 13, 11, 12, 13, 15, 16, 17, 19, 20, 22, 23, 25, 27, 28, 30, 32, 34, 35, 37, 39, 41, 43, 45, 46, 48, 50, 51, 53, 55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 66, 66, 67, 67, 67, 67, 67, 67, 67, 67, 66, 66, 65, 64, 64, 63, 62, 61, 60, 59, 57, 56, 55, 54, 53, 52, 51, 49, 48, 47, 47, 46, 45, 44, 44, 44, 43, 43, 43, 43, 44, 44, 45, 46, 47, 48, 50, 51, 53, 55, 57, 60, 62, 65, 68, 71, 74, 78, 81, 85, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140, 144, 148, 151, 154, 158, 161, 164, 166, 169, 171, 173, 175, 176, 178, 179, 180, 180, 180, 180, 180, 179, 179, 178, 176, 175, 173, 171, 169, 166, 164, 161, 158, 155, 152, 148, 145, 141, 138, 134, 131, 127, 124, 120, 117, 113, 110, 107, 104, 101, 99, 97, 95, 93, 91, 90, 89, 88, 88, 88, 88, 88, 89, 91, 92, 94, 96, 99, 102, 105, 109, 113, 117, 122, 127, 132, 137, 142, 148, 154, 160, 166, 173, 179, 186, 192, 199, 205, 212, 218, 225, 231, 237, 243, 248, 254, 251, 246, 241, 237, 233, 229, 226, 223, 220, 218, 216, 215, 214, 213, 213, 214, 214, 216, 217, 219, 222, 224, 228, 231, 235, 239, 244, 248, 253, 251, 246, 240, 234, 234};
int BLUE35[] = {214, 214, 202, 189, 177, 165, 153, 141, 129, 118, 107, 96, 85, 75, 65, 56, 47, 38, 30, 22, 15, 9, 2, 2, 7, 12, 16, 19, 22, 24, 25, 26, 27, 26, 25, 24, 22, 19, 16, 12, 7, 2, 2, 9, 15, 22, 30, 38, 47, 56, 65, 75, 85, 96, 107, 118, 129, 141, 153, 165, 177, 189, 202, 214, 227, 239, 251, 246, 234, 222, 210, 198, 186, 175, 164, 153, 142, 132, 122, 113, 104, 95, 87, 79, 72, 66, 59, 54, 49, 44, 40, 37, 34, 32, 31, 30, 29, 30, 31, 32, 34, 37, 40, 44, 49, 54, 59, 66, 72, 79, 87, 95, 104, 113, 122, 132, 142, 153, 164, 175, 186, 198, 210, 222, 234, 246, 251, 239, 226, 214, 202, 189, 177, 165, 153, 141, 129, 118, 107, 96, 85, 75, 65, 56, 47, 38, 30, 22, 15, 9, 2, 2, 7, 12, 16, 19, 22, 24, 25, 26, 27, 26, 25, 24, 22, 19, 16, 12, 7, 2, 2, 9, 15, 22, 30, 38, 47, 56, 65, 75, 85, 96, 107, 118, 129, 141, 153, 165, 177, 189, 202, 214, 227, 239, 251, 246, 234, 222, 210, 198, 186, 175, 164, 153, 142, 132, 122, 113, 104, 95, 87, 79, 72, 66, 59, 54, 49, 44, 40, 37, 34, 32, 31, 30, 29, 30, 31, 32, 34, 37, 40, 44, 49, 54, 59, 66, 72, 79, 87, 95, 104, 113, 122, 132, 142, 153, 164, 175, 186, 198, 210, 222, 234, 246, 251, 251};
int RED36[] = {64, 64, 60, 57, 54, 51, 48, 45, 42, 40, 37, 35, 32, 30, 28, 26, 24, 22, 20, 19, 17, 16, 14, 13, 12, 11, 13, 9, 9, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 9, 13, 11, 12, 13, 14, 15, 17, 18, 20, 22, 23, 25, 27, 30, 32, 34, 37, 39, 42, 44, 47, 50, 53, 56, 59, 63, 66, 70, 73, 77, 80, 84, 88, 92, 96, 100, 104, 109, 113, 117, 122, 126, 131, 136, 140, 145, 150, 155, 160, 165, 170, 175, 180, 186, 191, 196, 201, 207, 212, 218, 223, 229, 234, 240, 246, 251, 253, 247, 241, 236, 230, 224, 218, 213, 207, 201, 195, 189, 183, 178, 172, 166, 160, 154, 148, 143, 137, 131, 125, 120, 114, 108, 103, 97, 92, 86, 80, 75, 70, 64, 59, 53, 48, 43, 38, 33, 28, 23, 18, 13, 8, 3, 1, 5, 13, 15, 19, 23, 28, 32, 36, 40, 44, 48, 52, 56, 60, 63, 67, 70, 73, 77, 80, 83, 86, 89, 92, 94, 97, 100, 102, 104, 107, 109, 111, 113, 114, 116, 118, 119, 121, 122, 123, 124, 125, 126, 127, 128, 128, 129, 129, 129, 129, 129, 129, 129, 129, 129, 128, 127, 127, 126, 125, 124, 123, 122, 120, 119, 117, 116, 114, 112, 110, 108, 106, 103, 101, 99, 96, 93, 91, 88, 85, 82, 79, 75, 72, 69, 65, 62, 58, 54, 50, 47, 43, 39, 34, 30, 26, 22, 17, 13, 8, 8};
int GREEN36[] = {35, 35, 40, 44, 49, 54, 58, 63, 67, 72, 76, 80, 84, 89, 93, 96, 100, 104, 108, 111, 115, 118, 121, 124, 127, 130, 133, 135, 137, 140, 142, 144, 145, 147, 148, 150, 151, 152, 152, 153, 153, 153, 153, 153, 153, 153, 152, 151, 150, 149, 148, 146, 145, 143, 141, 139, 137, 134, 132, 129, 126, 123, 120, 117, 113, 110, 106, 103, 99, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 52, 47, 43, 38, 33, 29, 24, 19, 15, 13, 5, 1, 3, 7, 12, 16, 20, 25, 29, 33, 37, 41, 45, 49, 53, 56, 60, 63, 66, 69, 72, 75, 78, 80, 83, 85, 87, 89, 91, 92, 94, 95, 96, 97, 98, 99, 99, 99, 99, 99, 99, 99, 98, 97, 97, 95, 94, 93, 91, 89, 88, 86, 83, 81, 78, 76, 73, 70, 67, 64, 61, 57, 54, 50, 46, 42, 38, 34, 30, 26, 22, 17, 13, 9, 4, 0, 4, 9, 13, 18, 23, 27, 32, 37, 41, 46, 51, 55, 60, 64, 69, 73, 77, 82, 86, 90, 94, 98, 102, 105, 109, 112, 116, 119, 122, 125, 128, 131, 133, 136, 138, 140, 142, 144, 146, 147, 149, 150, 151, 152, 152, 153, 153, 153, 153, 153, 153, 152, 152, 151, 150, 149, 147, 146, 144, 142, 140, 138, 136, 133, 131, 128, 125, 122, 119, 116, 112, 109, 105, 101, 98, 94, 90, 86, 81, 77, 73, 68, 64, 60, 55, 50, 46, 41, 37, 32, 32};
int BLUE36[] = {116, 116, 105, 94, 84, 74, 64, 55, 46, 38, 30, 24, 18, 12, 8, 5, 2, 0, 0, 0, 1, 3, 6, 13, 14, 20, 26, 33, 41, 50, 59, 68, 78, 88, 99, 109, 120, 131, 142, 153, 163, 174, 184, 193, 202, 211, 218, 226, 232, 238, 243, 247, 250, 252, 253, 253, 253, 251, 249, 246, 241, 236, 230, 224, 216, 208, 200, 190, 181, 171, 160, 150, 139, 128, 117, 106, 96, 85, 75, 65, 56, 47, 39, 31, 24, 18, 13, 9, 5, 2, 0, 0, 0, 1, 3, 5, 9, 14, 19, 25, 32, 40, 48, 57, 67, 76, 87, 97, 108, 119, 130, 140, 151, 162, 172, 182, 192, 201, 209, 217, 225, 231, 237, 242, 246, 249, 252, 253, 254, 253, 252, 249, 246, 242, 237, 231, 225, 217, 209, 201, 192, 182, 172, 162, 151, 140, 130, 119, 108, 97, 87, 76, 67, 57, 48, 40, 32, 25, 19, 14, 9, 5, 3, 1, 0, 0, 0, 2, 5, 9, 13, 18, 24, 31, 39, 47, 56, 65, 75, 85, 96, 106, 117, 128, 139, 150, 160, 171, 181, 190, 200, 208, 216, 224, 230, 236, 241, 246, 249, 251, 253, 253, 253, 252, 250, 247, 243, 238, 232, 226, 218, 211, 202, 193, 184, 174, 163, 153, 142, 131, 120, 109, 99, 88, 78, 68, 59, 50, 41, 33, 26, 20, 14, 13, 6, 3, 1, 0, 0, 0, 2, 5, 8, 12, 18, 24, 30, 38, 46, 55, 64, 74, 84, 94, 105, 105};
int RED37[] = {124, 124, 121, 118, 115, 112, 109, 106, 103, 100, 97, 94, 91, 88, 85, 82, 79, 76, 73, 70, 68, 65, 62, 60, 57, 54, 52, 49, 47, 45, 42, 40, 38, 36, 33, 31, 29, 27, 25, 24, 22, 20, 19, 17, 15, 14, 13, 11, 13, 9, 8, 7, 6, 5, 4, 4, 3, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 3, 4, 4, 5, 6, 7, 8, 9, 13, 11, 13, 14, 15, 17, 19, 20, 22, 24, 25, 27, 29, 31, 33, 36, 38, 40, 42, 45, 47, 49, 52, 54, 57, 60, 62, 65, 68, 70, 73, 76, 79, 82, 85, 88, 91, 94, 97, 100, 103, 106, 109, 112, 115, 118, 121, 124, 128, 131, 134, 137, 140, 143, 146, 149, 152, 155, 158, 161, 164, 167, 170, 173, 176, 179, 182, 185, 187, 190, 193, 195, 198, 201, 203, 206, 208, 210, 213, 215, 217, 219, 222, 224, 226, 228, 230, 231, 233, 235, 236, 238, 240, 241, 242, 244, 245, 246, 247, 248, 249, 250, 251, 251, 252, 253, 253, 254, 254, 254, 254, 254, 255, 254, 254, 254, 254, 254, 253, 253, 252, 251, 251, 250, 249, 248, 247, 246, 245, 244, 242, 241, 240, 238, 236, 235, 233, 231, 230, 228, 226, 224, 222, 219, 217, 215, 213, 210, 208, 206, 203, 201, 198, 195, 193, 190, 187, 185, 182, 179, 176, 173, 170, 167, 164, 161, 158, 155, 152, 149, 146, 143, 140, 137, 134, 134};
int GREEN37[] = {121, 121, 141, 155, 160, 155, 141, 121, 97, 72, 52, 38, 34, 38, 52, 72, 96, 121, 141, 155, 160, 155, 141, 121, 97, 72, 52, 38, 34, 38, 52, 72, 96, 121, 141, 155, 160, 155, 141, 121, 97, 72, 52, 38, 34, 38, 52, 72, 96, 121, 141, 155, 160, 155, 141, 121, 97, 72, 52, 38, 34, 38, 52, 72, 96, 121, 141, 155, 160, 155, 141, 121, 97, 72, 52, 38, 34, 38, 52, 72, 96, 121, 141, 155, 160, 155, 141, 121, 97, 72, 52, 38, 34, 38, 52, 72, 96, 121, 141, 155, 160, 155, 141, 121, 97, 72, 52, 38, 34, 38, 52, 72, 96, 121, 141, 155, 160, 155, 141, 121, 96, 72, 52, 38, 34, 38, 52, 72, 97, 121, 141, 155, 160, 155, 141, 121, 96, 72, 52, 38, 34, 38, 52, 72, 97, 121, 141, 155, 160, 155, 141, 121, 96, 72, 52, 38, 34, 38, 52, 72, 97, 121, 141, 155, 160, 155, 141, 121, 96, 72, 52, 38, 34, 38, 52, 72, 97, 121, 141, 155, 160, 155, 141, 121, 96, 72, 52, 38, 34, 38, 52, 72, 97, 121, 141, 155, 160, 155, 141, 121, 96, 72, 52, 38, 34, 38, 52, 72, 97, 121, 141, 155, 160, 155, 141, 121, 96, 72, 52, 38, 34, 38, 52, 72, 97, 121, 141, 155, 160, 155, 141, 121, 96, 72, 52, 38, 34, 38, 52, 72, 97, 121, 141, 155, 160, 155, 141, 121, 96, 72, 52, 38, 34, 38, 52, 52};
int BLUE37[] = {131, 131, 134, 137, 140, 143, 146, 149, 152, 155, 158, 161, 164, 167, 170, 173, 176, 179, 182, 185, 187, 190, 193, 195, 198, 201, 203, 206, 208, 210, 213, 215, 217, 219, 222, 224, 226, 228, 230, 231, 233, 235, 236, 238, 240, 241, 242, 244, 245, 246, 247, 248, 249, 250, 251, 251, 252, 253, 253, 254, 254, 254, 254, 254, 255, 254, 254, 254, 254, 254, 253, 253, 252, 251, 251, 250, 249, 248, 247, 246, 245, 244, 242, 241, 240, 238, 236, 235, 233, 231, 230, 228, 226, 224, 222, 219, 217, 215, 213, 210, 208, 206, 203, 201, 198, 195, 193, 190, 187, 185, 182, 179, 176, 173, 170, 167, 164, 161, 158, 155, 152, 149, 146, 143, 140, 137, 134, 131, 127, 124, 121, 118, 115, 112, 109, 106, 103, 100, 97, 94, 91, 88, 85, 82, 79, 76, 73, 70, 68, 65, 62, 60, 57, 54, 52, 49, 47, 45, 42, 40, 38, 36, 33, 31, 29, 27, 25, 24, 22, 20, 19, 17, 15, 14, 13, 11, 13, 9, 8, 7, 6, 5, 4, 4, 3, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 3, 4, 4, 5, 6, 7, 8, 9, 13, 11, 13, 14, 15, 17, 19, 20, 22, 24, 25, 27, 29, 31, 33, 36, 38, 40, 42, 45, 47, 49, 52, 54, 57, 60, 62, 65, 68, 70, 73, 76, 79, 82, 85, 88, 91, 94, 97, 100, 103, 106, 109, 112, 115, 118, 121, 121};

int* RedArrays[] = {RED0, RED1, RED2, RED3, RED4, RED5, RED6, RED7, RED8, RED9, RED10, RED11, RED12, RED13, RED14, RED15, RED16, RED17, RED18, RED19, RED20, RED21, RED22, RED23, RED24, RED25, RED26, RED27, RED28, RED29, RED30, RED31, RED32, RED33, RED34, RED35, RED36, RED37};
int* GreenArrays[] = {GREEN0, GREEN1, GREEN2, GREEN3, GREEN4, GREEN5, GREEN6, GREEN7, GREEN8, GREEN9, GREEN10, GREEN11, GREEN12, GREEN13, GREEN14, GREEN15, GREEN16, GREEN17, GREEN18, GREEN19, GREEN20, GREEN21, GREEN22, GREEN23, GREEN24, GREEN25, GREEN26, GREEN27, GREEN28, GREEN29, GREEN30, GREEN31, GREEN32, GREEN33, GREEN34, GREEN35, GREEN36, GREEN37};
int* BlueArrays[] = {BLUE0, BLUE1, BLUE2, BLUE3, BLUE4, BLUE5, BLUE6, BLUE7, BLUE8, BLUE9, BLUE10, BLUE11, BLUE12, BLUE13, BLUE14, BLUE15, BLUE16, BLUE17, BLUE18, BLUE19, BLUE20, BLUE21, BLUE22, BLUE23, BLUE24, BLUE25, BLUE26, BLUE27, BLUE28, BLUE29, BLUE30, BLUE31, BLUE32, BLUE33, BLUE34, BLUE35, BLUE36, BLUE37};

inline vil_rgb<vxl_byte> color_value(int theme, int color_index)
{
  int r_val = RedArrays[theme][color_index];
  int g_val = GreenArrays[theme][color_index];
  int b_val = BlueArrays[theme][color_index];
  vil_rgb<vxl_byte> val((vxl_byte)r_val, (vxl_byte)g_val, (vxl_byte)b_val);
  return val;
};

#endif
