/*
 * NodeProximitySensor.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeProximitySensor.h"
#include "Proto.h"
#include "FieldValue.h"
#include "SFVec3f.h"
#include "SFFloat.h"
#include "SFBool.h"
#include "Field.h"
#include "RenderState.h"
#include "Util.h"
#include "Scene.h"


ProtoProximitySensor::ProtoProximitySensor(Scene *scene)
  : Proto(scene, "ProximitySensor")
{
    center.set(
          addExposedField(SFVEC3F, "center", new SFVec3f(0.0f, 0.0f, 0.0f)));
    size.set(
          addExposedField(SFVEC3F, "size", new SFVec3f(0.0f, 0.0f, 0.0f), 
                          new SFFloat(0.0f)));
    enabled.set(
          addExposedField(SFBOOL, "enabled", new SFBool(true)));
    addEventOut(SFBOOL, "isActive");
    addEventOut(SFVEC3F, "position_changed", EOF_RECOMMENDED);
    addEventOut(SFROTATION, "orientation_changed", EOF_RECOMMENDED);
    addEventOut(SFTIME, "enterTime", EOF_RECOMMENDED);
    addEventOut(SFTIME, "exitTime");
}

Node *
ProtoProximitySensor::create(Scene *scene)
{ 
    return new NodeProximitySensor(scene, this); 
}

NodeProximitySensor::NodeProximitySensor(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

void
NodeProximitySensor::drawHandles()
{
    const float	*fsize = size()->getValue();
    const float	*fcenter = center()->getValue();
    RenderState	state;

    glPushMatrix();
    glTranslatef(fcenter[0], fcenter[1], fcenter[2]);
    glScalef(fsize[0] * 0.5f, fsize[1] * 0.5f, fsize[2] * 0.5f);
    glPushAttrib(GL_LIGHTING);
    glDisable(GL_LIGHTING);
    glPushName(0);
    Util::myGlColor3f(1.0f, 1.0f, 1.0f);
    state.startDrawHandles();
    for (int i = 0; i < 8; i++) {
	glLoadName(i);
	state.drawHandle(boxCorners[i]);
    }
    state.endDrawHandles();
    glPopName();
    glPopAttrib();
    glPopMatrix();
}

Vec3f
NodeProximitySensor::getHandle(int handle, int * /* constraint */, int *field)
{
    const float	*fsize = size()->getValue();
//    const float	*fcenter = center()->getValue();
    switch (handle) {
      case TRF: case TLF: case TRB: case TLB:
      case BRF: case BLF: case BRB: case BLB:
	*field = 0;
        return Vec3f(fsize) * Vec3f(boxCorners[handle]) * 0.5f;
      default:
	assert(0);
	return Vec3f(0.0f, 0.0f, 0.0f);
    }
}

void
NodeProximitySensor::setHandle(int handle, const Vec3f &v)
{
    switch (handle) {
      case TRF: case TLF: case TRB: case TLB:
      case BRF: case BLF: case BRB: case BLB:
	_scene->setField(this, size_Index(), 
                         new SFVec3f(v * 2.0f * Vec3f(boxCorners[handle])));
	break;
    }
}


