/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.raw;

import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.graphicsio.raw.RawImageWriterSpi;
import org.freehep.util.images.ImageUtilities;

public class RawImageWriter
extends ImageWriter {
    public RawImageWriter(RawImageWriterSpi rawImageWriterSpi) {
        super(rawImageWriterSpi);
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write rasters");
        }
        Object object = this.getOutput();
        if (object == null) {
            throw new IllegalStateException("output was not set");
        }
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        ImageOutputStream imageOutputStream = (ImageOutputStream)object;
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        RawImageWriteParam rawImageWriteParam = (RawImageWriteParam)imageWriteParam;
        byte[] byArray = ImageUtilities.getBytes(renderedImage, rawImageWriteParam.getBackground(), rawImageWriteParam.getCode(), rawImageWriteParam.getPad());
        imageOutputStream.write(byArray);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new RawImageWriteParam(this.getLocale());
    }
}

