/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Text3D;
import org.jmol.util.Escape;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.TransformManager11;
import org.jmol.viewer.Viewer;

abstract class TransformManager {
    Viewer viewer;
    static final double twoPI = Math.PI * 2;
    static final double degreesPerRadian = 57.29577951308232;
    static final int DEFAULT_NAV_FPS = 10;
    protected int perspectiveModel = 11;
    protected float cameraScaleFactor;
    protected float referencePlaneOffset;
    protected float modelCenterOffset;
    protected float modelRadius;
    protected float modelRadiusPixels;
    protected final Point3f navigationCenter = new Point3f();
    protected final Point3f navigationOffset = new Point3f();
    protected final Point3f navigationShiftXY = new Point3f();
    protected final Matrix4f matrixTemp = new Matrix4f();
    protected final Vector3f vectorTemp = new Vector3f();
    protected boolean haveNotifiedNaN = false;
    static final int DEFAULT_SPIN_Y = 30;
    static final int DEFAULT_SPIN_FPS = 30;
    float spinX;
    float spinY = 30.0f;
    float spinZ;
    float spinFps = 30.0f;
    protected float navX;
    protected float navY;
    protected float navZ;
    protected float navFps = Float.NaN;
    boolean isSpinInternal = false;
    boolean isSpinFixed = false;
    boolean isSpinSelected = false;
    protected final Point3f fixedRotationOffset = new Point3f();
    protected final Point3f fixedRotationCenter = new Point3f();
    protected final Point3f perspectiveOffset = new Point3f();
    protected final Point3f perspectiveShiftXY = new Point3f();
    private final Point3f rotationCenterDefault = new Point3f();
    private float rotationRadiusDefault;
    protected final AxisAngle4f fixedRotationAxis = new AxisAngle4f();
    protected final AxisAngle4f internalRotationAxis = new AxisAngle4f();
    private final Point3f internalRotationCenter = new Point3f(0.0f, 0.0f, 0.0f);
    private float internalRotationAngle = 0.0f;
    protected final Matrix3f matrixRotate = new Matrix3f();
    private final Matrix3f matrixTemp3 = new Matrix3f();
    private final Matrix4f matrixTemp4 = new Matrix4f();
    private final AxisAngle4f axisangleT = new AxisAngle4f();
    private final Vector3f vectorT = new Vector3f();
    private final Vector3f vectorT2 = new Vector3f();
    protected final Point3f pointT = new Point3f();
    private final Point3f pointT2 = new Point3f();
    static final int MAXIMUM_ZOOM_PERCENTAGE = 200000;
    static final int MAXIMUM_ZOOM_PERSPECTIVE_DEPTH = 10000;
    private boolean rotateMolecule;
    Vector3f rotationAxis = new Vector3f();
    float rotationRate = 0.0f;
    final Vector3f arcBall0 = new Vector3f();
    final Vector3f arcBall1 = new Vector3f();
    final Vector3f arcBallAxis = new Vector3f();
    final Matrix3f arcBall0Rotation = new Matrix3f();
    protected final Point3f fixedTranslation = new Point3f();
    float xTranslationFraction = 0.5f;
    float yTranslationFraction = 0.5f;
    protected float prevZoomSetting;
    protected float previousX;
    protected float previousY;
    boolean zoomEnabled = true;
    float zoomPercent = 100.0f;
    float zoomPercentSetting = 100.0f;
    float zoomRatio;
    boolean slabEnabled = false;
    boolean internalSlab = false;
    boolean zShadeEnabled = false;
    int slabPercentSetting;
    int depthPercentSetting;
    int slabValue;
    int depthValue;
    int zSlabValue;
    int zDepthValue;
    Point4f slabPlane = null;
    Point4f depthPlane = null;
    protected boolean perspectiveDepth = true;
    protected boolean scale3D = false;
    protected float cameraDepth = Float.NaN;
    protected float cameraDepthSetting = 3.0f;
    protected float visualRange;
    protected float cameraDistance = 1000.0f;
    int width;
    int height;
    int screenPixelCount;
    float scalePixelsPerAngstrom;
    float scaleDefaultPixelsPerAngstrom;
    float scale3DAngstromsPerInch;
    protected boolean antialias;
    private boolean useZoomLarge;
    int screenWidth;
    int screenHeight;
    protected final Matrix4f matrixTransform = new Matrix4f();
    protected final Point3f point3fScreenTemp = new Point3f();
    protected final Point3i point3iScreenTemp = new Point3i();
    private final Point3f point3fVibrationTemp = new Point3f();
    protected boolean navigating = false;
    protected static final int MODE_STANDARD = 0;
    protected static final int MODE_NAVIGATION = 1;
    protected static final int MODE_PERSPECTIVE_CENTER = 2;
    static final int DEFAULT_PERSPECTIVE_MODEL = 11;
    protected int mode = 0;
    protected int defaultMode = 0;
    protected final Point3f ptTest1 = new Point3f();
    protected final Point3f ptTest2 = new Point3f();
    protected final Point3f ptTest3 = new Point3f();
    protected final AxisAngle4f aaTest1 = new AxisAngle4f();
    protected final Matrix3f matrixTest = new Matrix3f();
    MotionThread motion;
    protected boolean spinOn;
    protected boolean navOn;
    private SpinThread spinThread;
    boolean vibrationOn;
    private float vibrationPeriod;
    public int vibrationPeriodMs;
    private float vibrationAmplitude;
    private float vibrationRadians;
    private float vibrationScale;
    private VibrationThread vibrationThread;
    int stereoMode;
    int[] stereoColors;
    float stereoDegrees = Float.NaN;
    float stereoRadians;
    boolean stereoFrame;
    protected final Matrix3f matrixStereo = new Matrix3f();
    boolean windowCentered;
    Point3f[] frameOffsets;
    final Point3f frameOffset = new Point3f();

    protected abstract void calcCameraFactors();

    protected abstract float getPerspectiveFactor(float var1);

    abstract void adjustTemporaryScreenPoint();

    TransformManager() {
    }

    TransformManager(Viewer viewer) {
        this.viewer = viewer;
    }

    TransformManager(Viewer viewer, int n, int n2) {
        this.setViewer(viewer, n, n2);
    }

    void setViewer(Viewer viewer, int n, int n2) {
        this.viewer = viewer;
        this.setScreenParameters(n, n2, true, false, true, true);
    }

    TransformManager getNavigationManager(Viewer viewer, int n, int n2) {
        TransformManager11 transformManager11 = new TransformManager11();
        transformManager11.setViewer(viewer, n, n2);
        return transformManager11;
    }

    void homePosition() {
        Matrix3f matrix3f;
        this.setSpinOn(false);
        this.setNavOn(false);
        this.navFps = 10.0f;
        this.navZ = 0.0f;
        this.navY = 0.0f;
        this.navX = 0.0f;
        this.rotationCenterDefault.set(this.viewer.getBoundBoxCenter());
        this.setFixedRotationCenter(this.rotationCenterDefault);
        this.rotationRadiusDefault = this.setRotationRadius(0.0f, true);
        this.windowCentered = true;
        this.setRotationCenterAndRadiusXYZ(null, true);
        this.matrixRotate.setIdentity();
        if (this.viewer.getBooleanProperty("autoLoadOrientation") && (matrix3f = (Matrix3f)this.viewer.getModelSetAuxiliaryInfo("defaultOrientationMatrix")) != null) {
            this.matrixRotate.set(matrix3f);
        }
        this.setZoomEnabled(true);
        this.zoomToPercent(100.0f);
        this.zoomPercent = this.zoomPercentSetting;
        this.slabReset();
        this.scaleFitToScreen(true);
        if (this.viewer.isJmolDataFrame()) {
            this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
            this.rotationRadiusDefault = this.viewer.getJmolFrameType(this.viewer.getCurrentModelIndex()).equals("ramachandran") ? 250 : 12;
        } else if (this.viewer.getAxesOrientationRasmol()) {
            this.rotateX((float)Math.PI);
        }
        this.viewer.saveOrientation("default");
        if (this.mode == 1) {
            this.setNavigationMode(true);
        }
    }

    void clear() {
        this.clearVibration();
        this.clearSpin();
        this.stopMotion();
        this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
        this.navigating = false;
        this.slabPlane = null;
        this.depthPlane = null;
        this.resetNavigationPoint(true);
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (stringBuffer != null) {
            stringBuffer.append("  _setPerspectiveState;\n");
            stringBuffer2.append("function _setPerspectiveState() {\n");
        }
        StateManager.appendCmd(stringBuffer2, "set perspectiveModel " + this.perspectiveModel);
        StateManager.appendCmd(stringBuffer2, "set scaleAngstromsPerInch " + this.scale3DAngstromsPerInch);
        StateManager.appendCmd(stringBuffer2, "set perspectiveDepth " + this.perspectiveDepth);
        StateManager.appendCmd(stringBuffer2, "set visualRange " + this.visualRange);
        if (!this.isWindowCentered()) {
            StateManager.appendCmd(stringBuffer2, "set windowCentered false");
        }
        StateManager.appendCmd(stringBuffer2, "set cameraDepth " + this.cameraDepth);
        if (this.mode == 1) {
            StateManager.appendCmd(stringBuffer2, "set navigationMode true");
        }
        StateManager.appendCmd(stringBuffer2, this.viewer.getBoundBoxCommand(false));
        StateManager.appendCmd(stringBuffer2, "center " + Escape.escape(this.fixedRotationCenter));
        stringBuffer2.append(this.viewer.getSavedOrienationText(null));
        StateManager.appendCmd(stringBuffer2, this.getMoveToText(0.0f, false));
        if (this.stereoMode != 0) {
            StateManager.appendCmd(stringBuffer2, "stereo " + (this.stereoColors == null ? JmolConstants.getStereoModeName(this.stereoMode) : Escape.escapeColor(this.stereoColors[0]) + " " + Escape.escapeColor(this.stereoColors[1])) + " " + this.stereoDegrees);
        }
        if (this.mode != 1 && !this.zoomEnabled) {
            StateManager.appendCmd(stringBuffer2, "zoom off");
        }
        stringBuffer2.append("  slab ").append(this.slabPercentSetting).append(";depth ").append(this.depthPercentSetting).append(this.slabEnabled && this.mode != 1 ? ";slab on" : "").append(";\n");
        if (this.zShadeEnabled) {
            stringBuffer2.append("  set zShade;\n");
        }
        if (this.slabPlane != null) {
            stringBuffer2.append("  slab plane ").append(Escape.escape(this.slabPlane)).append(";\n");
        }
        if (this.depthPlane != null) {
            stringBuffer2.append("  depth plane ").append(Escape.escape(this.depthPlane)).append(";\n");
        }
        stringBuffer2.append(this.getSpinState(true)).append("\n");
        if (this.viewer.modelSetHasVibrationVectors() && this.vibrationOn) {
            StateManager.appendCmd(stringBuffer2, "vibration ON");
        }
        if (this.mode == 1) {
            stringBuffer2.append(this.getNavigationState());
            if (this.depthPlane != null || this.slabPlane != null) {
                stringBuffer2.append("  slab on;\n");
            }
        }
        if (stringBuffer != null) {
            stringBuffer2.append("}\n\n");
        }
        return stringBuffer2.toString();
    }

    String getSpinState(boolean bl) {
        String string;
        String string2 = "  set spinX " + (int)this.spinX + "; set spinY " + (int)this.spinY + "; set spinZ " + (int)this.spinZ + "; set spinFps " + (int)this.spinFps + ";";
        if (!Float.isNaN(this.navFps)) {
            string2 = string2 + "  set navX " + (int)this.navX + "; set navY " + (int)this.navY + "; set navZ " + (int)this.navZ + "; set navFps " + (int)this.navFps + ";";
        }
        if (this.navOn) {
            string2 = string2 + " navigation on;";
        }
        if (!this.spinOn) {
            return string2;
        }
        String string3 = string = this.isSpinSelected ? "\n  select " + Escape.escape(this.viewer.getSelectionSet()) + ";\n  rotateSelected" : "\n ";
        if (this.isSpinInternal) {
            Point3f point3f = new Point3f(this.internalRotationCenter);
            point3f.sub(this.rotationAxis);
            string2 = string2 + string + " spin " + this.rotationRate + " " + Escape.escape(this.internalRotationCenter) + " " + Escape.escape(point3f);
        } else {
            string2 = this.isSpinFixed ? string2 + string + " spin axisangle " + Escape.escape(this.rotationAxis) + " " + this.rotationRate : string2 + " spin on";
        }
        return string2 + ";";
    }

    void setRotateMolecule(boolean bl) {
        this.rotateMolecule = bl;
    }

    private void setFixedRotationCenter(Point3f point3f) {
        if (point3f == null) {
            return;
        }
        this.fixedRotationCenter.set(point3f);
    }

    void setRotationPointXY(Point3f point3f) {
        Point3i point3i = this.transformPoint(point3f);
        this.fixedTranslation.set(point3i.x, point3i.y, 0.0f);
    }

    float setRotateInternal(Point3f point3f, Vector3f vector3f, float f) {
        this.internalRotationCenter.set(point3f);
        this.rotationAxis.set(vector3f);
        float f2 = f * ((float)Math.PI / 180);
        this.rotationRate = f;
        this.internalRotationAxis.set(vector3f, f2);
        return f2;
    }

    float setRotateFixed(Point3f point3f, Vector3f vector3f, float f) {
        this.setFixedRotationCenter(point3f);
        this.rotationAxis.set(vector3f);
        float f2 = f * ((float)Math.PI / 180);
        this.rotationRate = f;
        this.fixedRotationAxis.set(vector3f, f2);
        return f2;
    }

    void spinXYBy(int n, int n2, float f) {
        if (n == 0 && n2 == 0) {
            if (this.spinThread != null && this.spinThread.isGesture) {
                this.clearSpin();
            }
            return;
        }
        this.clearSpin();
        Point3f point3f = new Point3f(this.fixedRotationCenter);
        Point3f point3f2 = new Point3f();
        this.transformPoint(point3f, point3f2);
        Point3f point3f3 = new Point3f(-n2, n, 0.0f);
        point3f3.add(point3f2);
        this.unTransformPoint(point3f3, point3f3);
        this.viewer.setInMotion(false);
        this.rotateAboutPointsInternal(point3f3, point3f, 10.0f * f, Float.NaN, false, true, null, true);
    }

    void rotateArcBall(float f, float f2, float f3) {
        float f4;
        float f5 = (this.screenPixelCount >> 2) * this.screenPixelCount;
        f4 = (float)((f4 = f5 - (f -= this.fixedTranslation.x) * f - (f2 -= this.fixedTranslation.y) * f2) < 0.0f ? -1 : 1) * (float)Math.sqrt(Math.abs(f4));
        if (f3 == 0.0f) {
            this.arcBall0Rotation.set(this.matrixRotate);
            this.arcBall0.set(f, -f2, f4);
            if (!Float.isNaN(f4)) {
                this.arcBall0.normalize();
            }
            return;
        }
        if (Float.isNaN(this.arcBall0.z) || Float.isNaN(f4)) {
            return;
        }
        this.arcBall1.set(f, -f2, f4);
        this.arcBall1.normalize();
        this.arcBallAxis.cross(this.arcBall0, this.arcBall1);
        this.axisangleT.set(this.arcBallAxis, f3 * (float)Math.acos(this.arcBall0.dot(this.arcBall1)));
        this.matrixRotate.set(this.arcBall0Rotation);
        this.rotateAxisAngle(this.axisangleT, null);
    }

    void rotateXYBy(float f, float f2, BitSet bitSet) {
        this.rotateXRadians(f2 * ((float)Math.PI / 180), bitSet);
        this.rotateYRadians(f * ((float)Math.PI / 180), bitSet);
    }

    void rotateZBy(int n, int n2, int n3) {
        if (n2 != Integer.MAX_VALUE && n3 != Integer.MAX_VALUE) {
            this.resetXYCenter(n2, n3, null);
        }
        this.rotateZRadians((float)((double)n / 57.29577951308232));
    }

    void rotateFront() {
        this.matrixRotate.setIdentity();
    }

    void rotateX(float f) {
        this.matrixRotate.rotX(f);
    }

    void rotateY(float f) {
        this.matrixRotate.rotY(f);
    }

    void rotateZ(float f) {
        this.matrixRotate.rotZ(f);
    }

    private void applyRotation(Matrix3f matrix3f, boolean bl, BitSet bitSet) {
        if (bitSet == null) {
            this.matrixRotate.mul(matrix3f, this.matrixRotate);
        } else {
            this.viewer.rotateAtoms(matrix3f, this.matrixRotate, this.rotateMolecule, this.internalRotationCenter, bl, bitSet);
        }
    }

    synchronized void rotateXRadians(float f, BitSet bitSet) {
        this.matrixTemp3.rotX(f);
        this.applyRotation(this.matrixTemp3, false, bitSet);
    }

    synchronized void rotateYRadians(float f, BitSet bitSet) {
        this.matrixTemp3.rotY(f);
        this.applyRotation(this.matrixTemp3, false, bitSet);
    }

    synchronized void rotateZRadians(float f) {
        this.matrixTemp3.rotZ(f);
        this.applyRotation(this.matrixTemp3, false, null);
    }

    protected void rotateAxisAngle(Vector3f vector3f, float f) {
        this.axisangleT.set(vector3f, f);
        this.rotateAxisAngle(this.axisangleT, null);
    }

    synchronized void rotateAxisAngle(AxisAngle4f axisAngle4f, BitSet bitSet) {
        this.matrixTemp3.set(axisAngle4f);
        this.applyRotation(this.matrixTemp3, false, bitSet);
    }

    void rotateAxisAngleAtCenter(Point3f point3f, Vector3f vector3f, float f, float f2, boolean bl, BitSet bitSet) {
        if (point3f != null) {
            this.moveRotationCenter(point3f, true);
        }
        this.setSpinOn(false);
        this.setNavOn(false);
        if (Float.isNaN(f) || f == 0.0f) {
            return;
        }
        if (point3f != null) {
            this.setRotationPointXY(point3f);
        }
        float f3 = this.setRotateFixed(point3f, vector3f, f);
        if (bl) {
            this.isSpinInternal = false;
            this.isSpinFixed = true;
            this.isSpinSelected = bitSet != null;
            this.setSpinOn(true, f2, bitSet, false);
            return;
        }
        this.rotateAxisAngleRadiansFixed(f3, bitSet);
    }

    synchronized void rotateAxisAngleRadiansFixed(float f, BitSet bitSet) {
        this.axisangleT.set(this.fixedRotationAxis);
        this.axisangleT.angle = f;
        this.rotateAxisAngle(this.axisangleT, bitSet);
    }

    void rotateAboutPointsInternal(Point3f point3f, Point3f point3f2, float f, float f2, boolean bl, boolean bl2, BitSet bitSet, boolean bl3) {
        boolean bl4;
        this.setSpinOn(false);
        this.setNavOn(false);
        if (Float.isNaN(f) || f == 0.0f) {
            return;
        }
        Vector3f vector3f = new Vector3f(point3f2);
        vector3f.sub(point3f);
        if (bl) {
            vector3f.scale(-1.0f);
        }
        float f3 = this.setRotateInternal(point3f, vector3f, f);
        boolean bl5 = bl4 = bitSet != null;
        if (bl2) {
            this.isSpinInternal = true;
            this.isSpinFixed = false;
            this.isSpinSelected = bl4;
            this.setSpinOn(true, f2, bitSet, bl3);
            return;
        }
        this.rotateAxisAngleRadiansInternal(f3, bitSet);
    }

    synchronized void rotateAxisAngleRadiansInternal(float f, BitSet bitSet) {
        this.internalRotationAngle = f;
        this.vectorT.set(this.internalRotationAxis.x, this.internalRotationAxis.y, this.internalRotationAxis.z);
        this.matrixRotate.transform(this.vectorT, this.vectorT2);
        this.axisangleT.set(this.vectorT2, f);
        this.matrixTemp3.set(this.axisangleT);
        this.applyRotation(this.matrixTemp3, true, bitSet);
        if (bitSet == null) {
            this.getNewFixedRotationCenter();
        }
    }

    void getNewFixedRotationCenter() {
        this.axisangleT.set(this.internalRotationAxis);
        this.axisangleT.angle = -this.internalRotationAngle;
        this.matrixTemp4.set(this.axisangleT);
        this.vectorT.set(this.internalRotationCenter);
        this.pointT2.set(this.fixedRotationCenter);
        this.pointT2.sub(this.vectorT);
        this.matrixTemp4.transform(this.pointT2, this.pointT);
        this.pointT.add(this.vectorT);
        this.setRotationCenterAndRadiusXYZ(this.pointT, false);
    }

    void setTranslationFractions() {
        this.xTranslationFraction = this.fixedTranslation.x / (float)this.width;
        this.yTranslationFraction = this.fixedTranslation.y / (float)this.height;
    }

    public void centerAt(int n, int n2, Point3f point3f) {
        if (point3f == null) {
            this.translateXYBy(n, n2);
            return;
        }
        if (this.windowCentered) {
            this.viewer.setBooleanProperty("windowCentered", false);
        }
        this.fixedTranslation.x = n;
        this.fixedTranslation.y = n2;
        this.setFixedRotationCenter(point3f);
    }

    int percentToPixels(char c, float f) {
        switch (c) {
            case 'x': {
                return (int)(f / 100.0f * (float)this.width);
            }
            case 'y': {
                return (int)(f / 100.0f * (float)this.height);
            }
            case 'z': {
                return (int)(f / 100.0f * (float)this.screenPixelCount);
            }
        }
        return 0;
    }

    int angstromsToPixels(float f) {
        return (int)(this.scalePixelsPerAngstrom * f);
    }

    void translateXYBy(int n, int n2) {
        this.fixedTranslation.x += (float)n;
        this.fixedTranslation.y += (float)n2;
        this.setTranslationFractions();
    }

    void translateToPercent(char c, float f) {
        switch (c) {
            case 'x': {
                this.xTranslationFraction = 0.5f + f / 100.0f;
                this.fixedTranslation.x = (float)this.width * this.xTranslationFraction;
                return;
            }
            case 'y': {
                this.yTranslationFraction = 0.5f + f / 100.0f;
                this.fixedTranslation.y = (float)this.height * this.yTranslationFraction;
                return;
            }
            case 'z': {
                if (this.mode == 1) {
                    this.setNavigationDepthPercent(0.0f, f);
                }
                return;
            }
        }
    }

    float getTranslationXPercent() {
        return (this.fixedTranslation.x - (float)(this.width / 2)) * 100.0f / (float)this.width;
    }

    float getTranslationYPercent() {
        return (this.fixedTranslation.y - (float)(this.height / 2)) * 100.0f / (float)this.height;
    }

    float getTranslationZPercent() {
        return 0.0f;
    }

    String getTranslationScript() {
        String string = "";
        float f = this.getTranslationXPercent();
        if ((double)f != 0.0) {
            string = string + "translate x " + f + ";";
        }
        if ((double)(f = this.getTranslationYPercent()) != 0.0) {
            string = string + "translate y " + f + ";";
        }
        return string;
    }

    String getOrientationText(int n) {
        switch (n) {
            case 4132: {
                return this.getMoveToText(1.0f, false);
            }
            case 1073741991: {
                return this.getRotationQuaternion().toString();
            }
            case 1073742019: {
                StringBuffer stringBuffer = new StringBuffer();
                TransformManager.truncate2(stringBuffer, this.getTranslationXPercent());
                TransformManager.truncate2(stringBuffer, this.getTranslationYPercent());
                return stringBuffer.toString();
            }
        }
        return this.getMoveToText(1.0f, true) + "\n#OR\n" + this.getRotateZyzText(true);
    }

    Hashtable getOrientationInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("moveTo", this.getMoveToText(1.0f, false));
        hashtable.put("center", "center " + this.getCenterText());
        hashtable.put("centerPt", this.fixedRotationCenter);
        AxisAngle4f axisAngle4f = new AxisAngle4f();
        this.getAxisAngle(axisAngle4f);
        hashtable.put("axisAngle", axisAngle4f);
        hashtable.put("quaternion", new Quaternion(axisAngle4f).toPoint4f());
        hashtable.put("rotationMatrix", this.matrixRotate);
        hashtable.put("rotateZYZ", this.getRotateZyzText(false));
        hashtable.put("rotateXYZ", this.getRotateXyzText());
        hashtable.put("transXPercent", new Float(this.getTranslationXPercent()));
        hashtable.put("transYPercent", new Float(this.getTranslationYPercent()));
        hashtable.put("zoom", new Float(this.zoomPercent));
        hashtable.put("modelRadius", new Float(this.modelRadius));
        if (this.mode == 1) {
            hashtable.put("navigationCenter", "navigate center " + Escape.escape(this.navigationCenter));
            hashtable.put("navigationOffsetXPercent", new Float(this.getNavigationOffsetPercent('X')));
            hashtable.put("navigationOffsetYPercent", new Float(this.getNavigationOffsetPercent('Y')));
            hashtable.put("navigationDepthPercent", new Float(this.getNavigationDepthPercent()));
        }
        return hashtable;
    }

    void getAxisAngle(AxisAngle4f axisAngle4f) {
        axisAngle4f.set(this.matrixRotate);
    }

    String getTransformText() {
        return this.matrixRotate.toString();
    }

    Matrix3f getMatrixRotate() {
        return this.matrixRotate;
    }

    void setRotation(Matrix3f matrix3f) {
        if (!Float.isNaN(matrix3f.m00)) {
            this.matrixRotate.set(matrix3f);
        }
    }

    void getRotation(Matrix3f matrix3f) {
        matrix3f.set(this.matrixRotate);
    }

    protected void zoomBy(int n) {
        if (n > 20) {
            n = 20;
        } else if (n < -20) {
            n = -20;
        }
        float f = (float)n * this.zoomPercentSetting / 50.0f;
        if (f == 0.0f) {
            f = n > 0 ? 1 : (f < 0.0f ? -1 : 0);
        }
        this.zoomRatio = (f + this.zoomPercentSetting) / this.zoomPercentSetting;
        this.zoomPercentSetting += f;
    }

    float getZoomPercentFloat() {
        return this.zoomPercent;
    }

    void zoomToPercent(float f) {
        this.zoomPercentSetting = f;
        this.zoomRatio = 0.0f;
    }

    void translateZBy(int n) {
        if (n >= this.screenPixelCount) {
            return;
        }
        float f = this.scalePixelsPerAngstrom / (1.0f - (float)n * 1.0f / (float)this.screenPixelCount);
        if (f >= (float)this.screenPixelCount) {
            return;
        }
        float f2 = f / this.scaleDefaultPixelsPerAngstrom * 100.0f;
        this.zoomRatio = f2 / this.zoomPercentSetting;
        this.zoomPercentSetting = f2;
    }

    void zoomByFactor(float f, int n, int n2) {
        if (f <= 0.0f || !this.zoomEnabled) {
            return;
        }
        this.zoomRatio = f;
        this.zoomPercentSetting *= f;
        this.resetXYCenter(n, n2, null);
    }

    private void resetXYCenter(int n, int n2, Point3f point3f) {
        if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return;
        }
        if (this.windowCentered) {
            this.viewer.setBooleanProperty("windowCentered", false);
        }
        if (point3f == null) {
            this.transformPoint(this.fixedRotationCenter, this.pointT);
            this.pointT.set(n, n2, this.pointT.z);
            this.unTransformPoint(this.pointT, this.pointT);
            this.fixedTranslation.set(n, n2, 0.0f);
            this.setFixedRotationCenter(this.pointT);
        } else {
            this.transformPoint(point3f, this.pointT);
        }
    }

    void zoomByPercent(float f) {
        float f2 = f * this.zoomPercentSetting / 100.0f;
        if (f2 == 0.0f) {
            f2 = f < 0.0f ? -1.0f : 1.0f;
        }
        this.zoomRatio = (f2 + this.zoomPercentSetting) / this.zoomPercentSetting;
        this.zoomPercentSetting += f2;
    }

    void setScaleAngstromsPerInch(float f) {
        boolean bl = this.scale3D = f > 0.0f;
        if (this.scale3D) {
            this.scale3DAngstromsPerInch = f;
        }
        this.perspectiveDepth = !this.scale3D;
    }

    void setSlabEnabled(boolean bl) {
        this.slabEnabled = bl;
        this.viewer.getGlobalSettings().setParameterValue("slabEnabled", bl);
    }

    void setZShadeEnabled(boolean bl) {
        this.zShadeEnabled = bl;
        this.viewer.getGlobalSettings().setParameterValue("zShade", bl);
    }

    void setZoomEnabled(boolean bl) {
        this.zoomEnabled = bl;
        this.viewer.getGlobalSettings().setParameterValue("zoomEnabled", bl);
    }

    void slabReset() {
        this.slabToPercent(100);
        this.depthToPercent(0);
        this.depthPlane = null;
        this.slabPlane = null;
        this.setSlabEnabled(false);
        this.setZShadeEnabled(false);
    }

    int getSlabPercentSetting() {
        return this.slabPercentSetting;
    }

    void slabByPercentagePoints(int n) {
        this.slabPlane = null;
        this.slabPercentSetting += n;
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthByPercentagePoints(int n) {
        this.depthPlane = null;
        this.depthPercentSetting += n;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void slabDepthByPercentagePoints(int n) {
        this.slabPlane = null;
        this.depthPlane = null;
        this.slabPercentSetting += n;
        this.depthPercentSetting += n;
    }

    void slabToPercent(int n) {
        this.slabPercentSetting = n;
        this.slabPlane = null;
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthToPercent(int n) {
        this.depthPercentSetting = n;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void slabInternal(Point4f point4f, boolean bl) {
        if (bl) {
            this.depthPlane = point4f;
            this.depthPercentSetting = 0;
        } else {
            this.slabPlane = point4f;
            this.slabPercentSetting = 100;
        }
    }

    void setSlabDepthInternal(boolean bl) {
        this.finalizeTransformParameters();
        if (bl) {
            this.depthPlane = null;
        } else {
            this.slabPlane = null;
        }
        this.slabInternal(this.getSlabDepthPlane(bl), bl);
    }

    Point4f getSlabDepthPlane(boolean bl) {
        if (bl) {
            if (this.depthPlane != null) {
                return this.depthPlane;
            }
        } else if (this.slabPlane != null) {
            return this.slabPlane;
        }
        Matrix4f matrix4f = this.matrixTransform;
        return new Point4f(-matrix4f.m20, -matrix4f.m21, -matrix4f.m22, -matrix4f.m23 + (float)(bl ? this.depthValue : this.slabValue));
    }

    boolean checkInternalSlab(Point3f point3f) {
        return this.slabPlane != null && point3f.x * this.slabPlane.x + point3f.y * this.slabPlane.y + point3f.z * this.slabPlane.z + this.slabPlane.w > 0.0f || this.depthPlane != null && point3f.x * this.depthPlane.x + point3f.y * this.depthPlane.y + point3f.z * this.depthPlane.z + this.depthPlane.w < 0.0f;
    }

    int getFrontPlane() {
        return (int)this.cameraDistance;
    }

    void setPerspectiveDepth(boolean bl) {
        if (this.perspectiveDepth == bl) {
            return;
        }
        this.perspectiveDepth = bl;
        this.scaleFitToScreen(false);
    }

    boolean getPerspectiveDepth() {
        return this.perspectiveDepth;
    }

    void setCameraDepthPercent(float f) {
        float f2;
        this.resetNavigationPoint(true);
        float f3 = f2 = f < 0.0f ? -f / 100.0f : f;
        if (f2 == 0.0f) {
            return;
        }
        this.cameraDepthSetting = f2;
        this.cameraDepth = Float.NaN;
    }

    void setVisualRange(float f) {
        this.visualRange = f;
    }

    Matrix4f getUnscaledTransformMatrix() {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        this.vectorTemp.set(this.fixedRotationCenter);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        matrix4f.sub(this.matrixTemp);
        this.matrixTemp.set(this.matrixRotate);
        matrix4f.mul(this.matrixTemp, matrix4f);
        return matrix4f;
    }

    void setScreenParameters(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.screenWidth = n;
        this.screenHeight = n2;
        this.useZoomLarge = bl;
        this.antialias = bl2;
        this.width = bl2 ? n * 2 : n;
        this.height = bl2 ? n2 * 2 : n2;
        this.scaleFitToScreen(false, bl, bl3, bl4);
        this.finalizeTransformParameters();
    }

    void setAntialias(boolean bl) {
        boolean bl2 = this.antialias != bl;
        this.antialias = bl;
        this.width = this.antialias ? this.screenWidth * 2 : this.screenWidth;
        int n = this.height = this.antialias ? this.screenHeight * 2 : this.screenHeight;
        if (bl2) {
            this.scaleFitToScreen(false, this.useZoomLarge, false, false);
        }
    }

    float defaultScaleToScreen(float f) {
        return (float)this.screenPixelCount / 2.0f / f;
    }

    void scaleFitToScreen(boolean bl) {
        this.scaleFitToScreen(bl, this.viewer.getZoomLarge(), true, true);
    }

    void scaleFitToScreen(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.width == 0 || this.height == 0) {
            this.screenPixelCount = 1;
        } else {
            this.fixedTranslation.set((float)this.width * (bl ? 0.5f : this.xTranslationFraction), (float)this.height * (bl ? 0.5f : this.yTranslationFraction), 0.0f);
            this.setTranslationFractions();
            if (bl4) {
                this.resetNavigationPoint(bl3);
            }
            int n = this.screenPixelCount = bl2 == this.height > this.width ? this.height : this.width;
        }
        if (this.screenPixelCount > 2) {
            this.screenPixelCount -= 2;
        }
        this.scaleDefaultPixelsPerAngstrom = this.defaultScaleToScreen(this.modelRadius);
    }

    short scaleToScreen(int n, int n2) {
        if (n2 == 0 || n < 2) {
            return 0;
        }
        int n3 = (int)this.scaleToPerspective(n, (float)n2 * this.scalePixelsPerAngstrom / 1000.0f);
        return (short)(n3 > 0 ? n3 : 1);
    }

    float unscaleToScreen(float f, float f2) {
        float f3 = f2 / this.scalePixelsPerAngstrom;
        return this.perspectiveDepth ? f3 / this.getPerspectiveFactor(f) : f3;
    }

    float scaleToPerspective(int n, float f) {
        return this.perspectiveDepth ? f * this.getPerspectiveFactor(n) : f;
    }

    Matrix4f getMatrixtransform() {
        return this.matrixTransform;
    }

    void setNavigationMode(boolean bl) {
        this.mode = bl && this.canNavigate() ? 1 : this.defaultMode;
        this.resetNavigationPoint(true);
    }

    boolean isNavigating() {
        return this.navigating || this.navOn;
    }

    synchronized void finalizeTransformParameters() {
        this.haveNotifiedNaN = false;
        this.fixedRotationOffset.set(this.fixedTranslation);
        this.internalSlab = this.slabEnabled && (this.slabPlane != null || this.depthPlane != null);
        float f = this.getZoomSetting();
        if (this.zoomPercent != f) {
            this.zoomPercent = f;
            if (!this.viewer.getFontCaching()) {
                Text3D.clearFontCache();
            }
        }
        this.calcCameraFactors();
        this.calcTransformMatrix();
        if (this.mode == 1) {
            this.calcNavigationPoint();
        } else {
            this.calcSlabAndDepthValues();
        }
    }

    float getZoomSetting() {
        if (this.zoomPercentSetting < 5.0f) {
            this.zoomPercentSetting = 5.0f;
        }
        if (this.zoomPercentSetting > 200000.0f) {
            this.zoomPercentSetting = 200000.0f;
        }
        return this.zoomEnabled || this.mode == 1 ? this.zoomPercentSetting : 100.0f;
    }

    protected void calcSlabAndDepthValues() {
        this.zSlabValue = this.slabValue = this.zValueFromPercent(this.slabPercentSetting);
        this.zDepthValue = this.depthValue = this.zValueFromPercent(this.depthPercentSetting);
        this.viewer.getGlobalSettings().setParameterValue("_slabPlane", Escape.escape(this.getSlabDepthPlane(false)));
        this.viewer.getGlobalSettings().setParameterValue("_depthPlane", Escape.escape(this.getSlabDepthPlane(true)));
        if (this.slabEnabled) {
            return;
        }
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
    }

    int zValueFromPercent(int n) {
        return (int)((1.0f - (float)n / 50.0f) * this.modelRadiusPixels + this.modelCenterOffset);
    }

    protected synchronized void calcTransformMatrix() {
        this.matrixTransform.setIdentity();
        this.vectorTemp.set(this.fixedRotationCenter);
        this.vectorTemp.sub(this.frameOffset);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        this.matrixTransform.sub(this.matrixTemp);
        this.matrixTemp.set(this.stereoFrame ? this.matrixStereo : this.matrixRotate);
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.matrixTemp.setZero();
        this.matrixTemp.set(this.scalePixelsPerAngstrom);
        this.matrixTemp.m11 = this.matrixTemp.m22 = -this.scalePixelsPerAngstrom;
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.matrixTransform.m23 += this.modelCenterOffset;
    }

    void rotatePoint(Point3f point3f, Point3f point3f2) {
        this.matrixRotate.transform(point3f, point3f2);
        point3f2.y = -point3f2.y;
    }

    void transformPoints(int n, Point3f[] point3fArray, Point3i[] point3iArray) {
        int n2 = n;
        while (--n2 >= 0) {
            point3iArray[n2].set(this.transformPoint(point3fArray[n2]));
        }
    }

    void transformPoint(Point3f point3f, Point3i point3i) {
        point3i.set(this.transformPoint(point3f));
    }

    void transformPointNoClip(Point3f point3f, Point3f point3f2) {
        point3f2.set(this.transformPointNoClip(point3f));
    }

    synchronized Point3i transformPoint(Point3f point3f) {
        if (point3f.z == Float.MAX_VALUE || point3f.z == -3.4028235E38f) {
            return this.transformScreenPoint(point3f);
        }
        this.matrixTransform.transform(point3f, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        if (this.internalSlab && this.checkInternalSlab(point3f)) {
            this.point3iScreenTemp.z = 1;
        }
        return this.point3iScreenTemp;
    }

    private Point3i transformScreenPoint(Point3f point3f) {
        if (point3f.z == -3.4028235E38f) {
            this.point3iScreenTemp.x = (int)(point3f.x / 100.0f * (float)this.screenWidth);
            this.point3iScreenTemp.y = (int)((1.0f - point3f.y / 100.0f) * (float)this.screenHeight);
        } else {
            this.point3iScreenTemp.x = (int)point3f.x;
            this.point3iScreenTemp.y = this.screenHeight - (int)point3f.y;
        }
        if (this.antialias) {
            this.point3iScreenTemp.x <<= 1;
            this.point3iScreenTemp.y <<= 1;
        }
        this.matrixTransform.transform(this.fixedRotationCenter, this.pointT);
        this.point3iScreenTemp.z = (int)this.pointT.z;
        return this.point3iScreenTemp;
    }

    synchronized Point3f transformPointNoClip(Point3f point3f) {
        this.matrixTransform.transform(point3f, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        return this.point3fScreenTemp;
    }

    Point3i transformPoint(Point3f point3f, Vector3f vector3f) {
        this.point3fVibrationTemp.set(point3f);
        if (this.vibrationOn && vector3f != null) {
            this.point3fVibrationTemp.scaleAdd(this.vibrationAmplitude, vector3f, point3f);
        }
        this.matrixTransform.transform(this.point3fVibrationTemp, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        if (this.internalSlab && this.checkInternalSlab(point3f)) {
            this.point3iScreenTemp.z = 1;
        }
        return this.point3iScreenTemp;
    }

    void transformPoint(Point3f point3f, Point3f point3f2) {
        this.matrixTransform.transform(point3f, this.point3fScreenTemp);
        this.adjustTemporaryScreenPoint();
        if (this.internalSlab && this.checkInternalSlab(point3f)) {
            this.point3fScreenTemp.z = 1.0f;
        }
        point3f2.set(this.point3fScreenTemp);
    }

    void transformVector(Vector3f vector3f, Vector3f vector3f2) {
        this.matrixTransform.transform(vector3f, vector3f2);
    }

    void unTransformPoint(Point3f point3f, Point3f point3f2) {
        this.pointT.set(point3f);
        switch (this.mode) {
            case 1: {
                this.pointT.x -= this.navigationOffset.x;
                this.pointT.y -= this.navigationOffset.y;
                break;
            }
            case 2: {
                this.pointT.x -= this.perspectiveOffset.x;
                this.pointT.y -= this.perspectiveOffset.y;
                break;
            }
            case 0: {
                this.pointT.x -= this.fixedRotationOffset.x;
                this.pointT.y -= this.fixedRotationOffset.y;
            }
        }
        if (this.perspectiveDepth) {
            float f = this.getPerspectiveFactor(this.pointT.z);
            this.pointT.x /= f;
            this.pointT.y /= f;
        }
        switch (this.mode) {
            case 1: {
                this.pointT.x += this.navigationShiftXY.x;
                this.pointT.y += this.navigationShiftXY.y;
                break;
            }
            case 2: {
                this.pointT.x += this.perspectiveShiftXY.x;
                this.pointT.y += this.perspectiveShiftXY.y;
            }
        }
        this.matrixUnTransform(this.pointT, point3f2);
    }

    protected void matrixUnTransform(Point3f point3f, Point3f point3f2) {
        this.matrixTemp.invert(this.matrixTransform);
        this.matrixTemp.transform(point3f, point3f2);
    }

    void move(Vector3f vector3f, float f, Vector3f vector3f2, float f2, float f3, int n) {
        int n2 = this.getSlabPercentSetting();
        float f4 = this.getTranslationXPercent();
        float f5 = this.getTranslationYPercent();
        float f6 = this.getTranslationZPercent();
        long l = System.currentTimeMillis();
        int n3 = 1000 / n;
        int n4 = (int)((float)n * f3);
        if (n4 <= 0) {
            n4 = 1;
        }
        float f7 = (float)(Math.PI / 180 / (double)n4);
        float f8 = f7 * vector3f.x;
        float f9 = f7 * vector3f.y;
        float f10 = f7 * vector3f.z;
        if (f3 > 0.0f) {
            this.viewer.setInMotion(true);
        }
        float f11 = this.zoomPercent;
        for (int i = 1; i <= n4; ++i) {
            int n5;
            int n6;
            if (vector3f.x != 0.0f) {
                this.rotateXRadians(f8, null);
            }
            if (vector3f.y != 0.0f) {
                this.rotateYRadians(f9, null);
            }
            if (vector3f.z != 0.0f) {
                this.rotateZRadians(f10);
            }
            if (f != 0.0f) {
                this.zoomToPercent(f11 + f * (float)i / (float)n4);
            }
            if (vector3f2.x != 0.0f) {
                this.translateToPercent('x', f4 + vector3f2.x * (float)i / (float)n4);
            }
            if (vector3f2.y != 0.0f) {
                this.translateToPercent('y', f5 + vector3f2.y * (float)i / (float)n4);
            }
            if (vector3f2.z != 0.0f) {
                this.translateToPercent('z', f6 + vector3f2.z * (float)i / (float)n4);
            }
            if (f2 != 0.0f) {
                this.slabToPercent((int)((float)n2 + f2 * (float)i / (float)n4));
            }
            if ((n6 = (int)(System.currentTimeMillis() - l)) >= (n5 = i * n3)) continue;
            this.viewer.requestRepaintAndWait();
            if (!this.viewer.isScriptExecuting()) break;
            n6 = (int)(System.currentTimeMillis() - l);
            int n7 = n5 - n6;
            if (n7 <= 0) continue;
            try {
                Thread.sleep(n7);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.viewer.setInMotion(false);
    }

    boolean isInPosition(Vector3f vector3f, float f) {
        if (Float.isNaN(f)) {
            return true;
        }
        this.aaTest1.set(vector3f, (float)((double)f / 57.29577951308232));
        this.ptTest1.set(4.321f, 1.23456f, 3.14159f);
        this.getRotation(this.matrixTest);
        this.matrixTest.transform(this.ptTest1, this.ptTest2);
        this.matrixTest.set(this.aaTest1);
        this.matrixTest.transform(this.ptTest1, this.ptTest3);
        return (double)this.ptTest3.distance(this.ptTest2) < 0.1;
    }

    void moveTo(float f, Point3f point3f, Tuple3f tuple3f, float f2, Matrix3f matrix3f, float f3, float f4, float f5, float f6, Point3f point3f2, float f7, float f8, float f9) {
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
            Vector3f vector3f = new Vector3f(tuple3f);
            if (Float.isNaN(f2)) {
                matrix3f.m00 = Float.NaN;
            } else if (f2 < 0.01f && f2 > -0.01f) {
                matrix3f.setIdentity();
            } else {
                if (vector3f.x == 0.0f && vector3f.y == 0.0f && vector3f.z == 0.0f) {
                    return;
                }
                AxisAngle4f axisAngle4f = new AxisAngle4f();
                axisAngle4f.set(vector3f, (float)((double)f2 / 57.29577951308232));
                matrix3f.set(axisAngle4f);
            }
        }
        try {
            int n;
            if (this.motion == null) {
                this.motion = new MotionThread();
            }
            if ((n = this.motion.set(f, point3f, matrix3f, f3, f4, f5, f6, point3f2, f7, f8, f9)) == 0 || this.viewer.waitForMoveTo()) {
                this.motion.startMotion(false);
                this.motion = null;
            } else {
                this.motion.startMotion(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopMotion() {
        this.motion = null;
        this.setSpinOn(false);
    }

    Quaternion getRotationQuaternion() {
        this.axisangleT.set(this.matrixRotate);
        float f = (float)((double)this.axisangleT.angle * 57.29577951308232);
        this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
        return new Quaternion(this.vectorT, f);
    }

    String getRotationText() {
        this.axisangleT.set(this.matrixRotate);
        float f = (float)((double)this.axisangleT.angle * 57.29577951308232);
        StringBuffer stringBuffer = new StringBuffer();
        this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
        if (f < 0.01f) {
            return "{0 0 1 0}";
        }
        this.vectorT.normalize();
        this.vectorT.scale(1000.0f);
        stringBuffer.append("{");
        TransformManager.truncate0(stringBuffer, this.vectorT.x);
        TransformManager.truncate0(stringBuffer, this.vectorT.y);
        TransformManager.truncate0(stringBuffer, this.vectorT.z);
        TransformManager.truncate2(stringBuffer, f);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    String getMoveToText(float f, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("moveto ");
        if (bl) {
            stringBuffer.append("/* time, axisAngle */ ");
        }
        stringBuffer.append(f);
        stringBuffer.append(" ").append(this.getRotationText());
        if (bl) {
            stringBuffer.append(" /* zoom, translation */ ");
        }
        TransformManager.truncate2(stringBuffer, this.zoomPercentSetting);
        TransformManager.truncate2(stringBuffer, this.getTranslationXPercent());
        TransformManager.truncate2(stringBuffer, this.getTranslationYPercent());
        stringBuffer.append(" ");
        if (bl) {
            stringBuffer.append(" /* center, rotationRadius */ ");
        }
        stringBuffer.append(this.getCenterText());
        stringBuffer.append(" ").append(this.modelRadius);
        stringBuffer.append(this.getNavigationText(bl));
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private String getCenterText() {
        return Escape.escape(this.fixedRotationCenter);
    }

    private String getRotateXyzText() {
        float f;
        float f2;
        StringBuffer stringBuffer = new StringBuffer();
        float f3 = this.matrixRotate.m20;
        float f4 = -((float)(Math.asin(f3) * 57.29577951308232));
        if (f3 > 0.999f || f3 < -0.999f) {
            f2 = -((float)(Math.atan2(this.matrixRotate.m12, this.matrixRotate.m11) * 57.29577951308232));
            f = 0.0f;
        } else {
            f2 = (float)(Math.atan2(this.matrixRotate.m21, this.matrixRotate.m22) * 57.29577951308232);
            f = (float)(Math.atan2(this.matrixRotate.m10, this.matrixRotate.m00) * 57.29577951308232);
        }
        stringBuffer.append("reset");
        stringBuffer.append(";center ").append(this.getCenterText());
        if (f2 != 0.0f) {
            stringBuffer.append("; rotate x");
            TransformManager.truncate2(stringBuffer, f2);
        }
        if (f4 != 0.0f) {
            stringBuffer.append("; rotate y");
            TransformManager.truncate2(stringBuffer, f4);
        }
        if (f != 0.0f) {
            stringBuffer.append("; rotate z");
            TransformManager.truncate2(stringBuffer, f);
        }
        stringBuffer.append(";");
        this.addZoomTranslationNavigationText(stringBuffer);
        return stringBuffer.toString();
    }

    private void addZoomTranslationNavigationText(StringBuffer stringBuffer) {
        float f;
        float f2;
        if (this.zoomPercent != 100.0f) {
            stringBuffer.append(" zoom");
            TransformManager.truncate2(stringBuffer, this.zoomPercent);
            stringBuffer.append(";");
        }
        if ((f2 = this.getTranslationXPercent()) != 0.0f) {
            stringBuffer.append(" translate x");
            TransformManager.truncate2(stringBuffer, f2);
            stringBuffer.append(";");
        }
        if ((f = this.getTranslationYPercent()) != 0.0f) {
            stringBuffer.append(" translate y");
            TransformManager.truncate2(stringBuffer, f);
            stringBuffer.append(";");
        }
        if (this.modelRadius != this.rotationRadiusDefault) {
            stringBuffer.append(" set rotationRadius");
            TransformManager.truncate2(stringBuffer, this.modelRadius);
            stringBuffer.append(";");
        }
        if (this.mode == 1) {
            stringBuffer.append("navigate 0 center ").append(Escape.escape(this.navigationCenter));
            stringBuffer.append(";navigate 0 translate");
            TransformManager.truncate2(stringBuffer, this.getNavigationOffsetPercent('X'));
            TransformManager.truncate2(stringBuffer, this.getNavigationOffsetPercent('Y'));
            stringBuffer.append(";navigate 0 depth ");
            TransformManager.truncate2(stringBuffer, this.getNavigationDepthPercent());
            stringBuffer.append(";");
        }
    }

    private String getRotateZyzText(boolean bl) {
        float f;
        float f2;
        StringBuffer stringBuffer = new StringBuffer();
        float f3 = this.matrixRotate.m22;
        float f4 = (float)(Math.acos(f3) * 57.29577951308232);
        if (f3 > 0.999f || f3 < -0.999f) {
            f2 = (float)(Math.atan2(this.matrixRotate.m10, this.matrixRotate.m11) * 57.29577951308232);
            f = 0.0f;
        } else {
            f2 = (float)(Math.atan2(this.matrixRotate.m21, -this.matrixRotate.m20) * 57.29577951308232);
            f = (float)(Math.atan2(this.matrixRotate.m12, this.matrixRotate.m02) * 57.29577951308232);
        }
        if (f2 != 0.0f && f4 != 0.0f && f != 0.0f && bl) {
            stringBuffer.append("#Follows Z-Y-Z convention for Euler angles\n");
        }
        stringBuffer.append("reset");
        stringBuffer.append(";center ").append(this.getCenterText());
        if (f2 != 0.0f) {
            stringBuffer.append("; rotate z");
            TransformManager.truncate2(stringBuffer, f2);
        }
        if (f4 != 0.0f) {
            stringBuffer.append("; rotate y");
            TransformManager.truncate2(stringBuffer, f4);
        }
        if (f != 0.0f) {
            stringBuffer.append("; rotate z");
            TransformManager.truncate2(stringBuffer, f);
        }
        stringBuffer.append(";");
        this.addZoomTranslationNavigationText(stringBuffer);
        return stringBuffer.toString();
    }

    private static void truncate0(StringBuffer stringBuffer, float f) {
        stringBuffer.append(' ');
        stringBuffer.append(Math.round(f));
    }

    private static void truncate2(StringBuffer stringBuffer, float f) {
        stringBuffer.append(' ');
        stringBuffer.append((float)Math.round(f * 100.0f) / 100.0f);
    }

    void setSpinXYZ(float f, float f2, float f3) {
        if (!Float.isNaN(f)) {
            this.spinX = f;
        }
        if (!Float.isNaN(f2)) {
            this.spinY = f2;
        }
        if (!Float.isNaN(f3)) {
            this.spinZ = f3;
        }
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinFps(int n) {
        if (n <= 0) {
            n = 1;
        } else if (n > 50) {
            n = 50;
        }
        this.spinFps = n;
    }

    void setNavXYZ(float f, float f2, float f3) {
        if (!Float.isNaN(f)) {
            this.navX = f;
        }
        if (!Float.isNaN(f2)) {
            this.navY = f2;
        }
        if (!Float.isNaN(f3)) {
            this.navZ = f3;
        }
    }

    protected void setNavFps(int n) {
        if (Float.isNaN(this.navFps)) {
            return;
        }
        if (n <= 0) {
            n = 1;
        } else if (n > 50) {
            n = 50;
        }
        this.navFps = n;
    }

    private void clearSpin() {
        this.setSpinOn(false);
        this.setNavOn(false);
        this.isSpinInternal = false;
        this.isSpinFixed = false;
    }

    boolean getSpinOn() {
        return this.spinOn;
    }

    boolean getNavOn() {
        return this.navOn;
    }

    void setSpinOn(boolean bl) {
        this.setSpinOn(bl, Float.MAX_VALUE, null, false);
    }

    private void setSpinOn(boolean bl, float f, BitSet bitSet, boolean bl2) {
        if (this.navOn && bl) {
            this.setNavOn(false);
        }
        this.spinOn = bl;
        this.viewer.getGlobalSettings().setParameterValue("_spinning", bl);
        if (bl) {
            if (this.spinThread == null) {
                this.spinThread = new SpinThread(f, bitSet, false, bl2);
                this.spinThread.start();
            }
        } else if (this.spinThread != null) {
            this.spinThread.isReset = true;
            this.spinThread.interrupt();
            this.spinThread = null;
        }
    }

    protected void setNavOn(boolean bl) {
        if (Float.isNaN(this.navFps)) {
            return;
        }
        if (bl && this.spinOn) {
            this.setSpinOn(false, 0.0f, null, false);
        }
        this.navOn = bl;
        this.viewer.getGlobalSettings().setParameterValue("_navigating", bl);
        if (bl) {
            if (this.navX == 0.0f && this.navY == 0.0f && this.navZ == 0.0f) {
                this.navZ = 1.0f;
            }
            if (this.navFps == 0.0f) {
                this.navFps = 10.0f;
            }
            if (this.spinThread == null) {
                this.spinThread = new SpinThread(0.0f, null, true, false);
                this.spinThread.start();
            }
        } else if (this.spinThread != null) {
            this.spinThread.interrupt();
            this.spinThread = null;
        }
    }

    void setVibrationScale(float f) {
        this.vibrationScale = f;
    }

    protected void setNavigationOffsetRelative(boolean bl) {
    }

    void setVibrationPeriod(float f) {
        if (Float.isNaN(f)) {
            f = this.vibrationPeriod;
        } else if (f == 0.0f) {
            this.vibrationPeriod = 0.0f;
            this.vibrationPeriodMs = 0;
        } else {
            this.vibrationPeriod = Math.abs(f);
            this.vibrationPeriodMs = (int)(this.vibrationPeriod * 1000.0f);
            if (f > 0.0f) {
                return;
            }
            f = -f;
        }
        this.setVibrationOn(f > 0.0f && this.viewer.modelHasVibrationVectors(this.viewer.getCurrentModelIndex()));
    }

    protected void setVibrationT(float f) {
        this.vibrationRadians = (float)((double)f * (Math.PI * 2));
        if (this.vibrationScale == 0.0f) {
            this.vibrationScale = this.viewer.getVibrationScale();
        }
        this.vibrationAmplitude = (float)Math.cos(this.vibrationRadians) * this.vibrationScale;
    }

    boolean isVibrationOn() {
        return this.vibrationOn;
    }

    private void setVibrationOn(boolean bl) {
        if (!bl) {
            if (this.vibrationThread != null) {
                this.vibrationThread.interrupt();
                this.vibrationThread = null;
            }
            this.vibrationOn = false;
            return;
        }
        if (this.viewer.getModelCount() < 1) {
            this.vibrationOn = false;
            return;
        }
        if (this.vibrationThread == null) {
            this.vibrationThread = new VibrationThread();
            this.vibrationThread.start();
        }
        this.vibrationOn = true;
    }

    private void clearVibration() {
        this.setVibrationOn(false);
        this.vibrationScale = 0.0f;
    }

    void setStereoMode(int[] nArray) {
        this.stereoMode = 5;
        this.stereoColors = nArray;
    }

    void setStereoMode(int n) {
        this.stereoColors = null;
        this.stereoMode = n;
    }

    void setStereoDegrees(float f) {
        this.stereoDegrees = f;
        this.stereoRadians = f * ((float)Math.PI / 180);
    }

    synchronized Matrix3f getStereoRotationMatrix(boolean bl) {
        this.stereoFrame = bl;
        if (!bl) {
            return this.matrixRotate;
        }
        this.matrixTemp3.rotY(-this.stereoRadians);
        this.matrixStereo.mul(this.matrixTemp3, this.matrixRotate);
        return this.matrixStereo;
    }

    boolean isWindowCentered() {
        return this.windowCentered;
    }

    void setWindowCentered(boolean bl) {
        this.windowCentered = bl;
        this.resetNavigationPoint(true);
    }

    Point3f getRotationCenter() {
        return this.fixedRotationCenter;
    }

    float getRotationRadius() {
        return this.modelRadius;
    }

    float setRotationRadius(float f, boolean bl) {
        this.modelRadius = f <= 0.0f ? this.viewer.calcRotationRadius(this.fixedRotationCenter) : f;
        f = this.modelRadius;
        if (bl) {
            this.viewer.setRotationRadius(f, false);
        }
        return f;
    }

    private void setRotationCenterAndRadiusXYZ(Point3f point3f, boolean bl) {
        this.resetNavigationPoint(false);
        if (point3f == null) {
            this.setFixedRotationCenter(this.rotationCenterDefault);
            this.modelRadius = this.rotationRadiusDefault;
            return;
        }
        this.setFixedRotationCenter(point3f);
        if (bl && this.windowCentered) {
            this.modelRadius = this.viewer.calcRotationRadius(this.fixedRotationCenter);
        }
    }

    private void setRotationCenterAndRadiusXYZ(String string, Point3f point3f) {
        this.pointT.set(point3f);
        if (string == "average") {
            this.pointT.add(this.viewer.getAverageAtomPoint());
        } else if (string == "boundbox") {
            this.pointT.add(this.viewer.getBoundBoxCenter());
        } else if (string != "absolute") {
            this.pointT.set(this.rotationCenterDefault);
        }
        this.setRotationCenterAndRadiusXYZ(this.pointT, true);
    }

    void setNewRotationCenter(Point3f point3f, boolean bl) {
        if (point3f == null) {
            point3f = this.rotationCenterDefault;
        }
        if (this.windowCentered) {
            this.translateToPercent('x', 0.0f);
            this.translateToPercent('y', 0.0f);
            this.setRotationCenterAndRadiusXYZ(point3f, true);
            if (bl) {
                this.scaleFitToScreen(true);
            }
        } else {
            this.moveRotationCenter(point3f, true);
        }
    }

    void moveRotationCenter(Point3f point3f, boolean bl) {
        this.setRotationCenterAndRadiusXYZ(point3f, false);
        if (bl) {
            this.setRotationPointXY(this.fixedRotationCenter);
        }
    }

    void setCenter() {
        this.setRotationCenterAndRadiusXYZ(this.fixedRotationCenter, true);
    }

    void setCenterAt(String string, Point3f point3f) {
        this.setRotationCenterAndRadiusXYZ(string, point3f);
        this.scaleFitToScreen(true);
    }

    boolean canNavigate() {
        return false;
    }

    synchronized void navigate(int n, int n2) {
    }

    void navigate(float f, Point3f point3f) {
    }

    void navigate(float f, Vector3f vector3f, float f2) {
    }

    void navigate(float f, Point3f[] point3fArray, float[] fArray, int n, int n2) {
    }

    void navigate(float f, Point3f[][] point3fArray) {
    }

    void navTranslate(float f, Point3f point3f) {
    }

    void navTranslatePercent(float f, float f2, float f3) {
    }

    protected void calcNavigationPoint() {
    }

    protected void resetNavigationPoint(boolean bl) {
    }

    protected String getNavigationState() {
        return "";
    }

    void setNavigationDepthPercent(float f, float f2) {
        this.viewer.getGlobalSettings().setParameterValue("navigationDepth", f2);
    }

    Point3f getNavigationCenter() {
        return null;
    }

    Point3f getNavigationOffset() {
        return null;
    }

    float getNavigationDepthPercent() {
        return Float.NaN;
    }

    float getNavigationOffsetPercent(char c) {
        return 0.0f;
    }

    void setNavigationSlabOffsetPercent(float f) {
        this.viewer.getGlobalSettings().setParameterValue("navigationSlab", f);
    }

    String getNavigationText(boolean bl) {
        return "";
    }

    void setFrameOffset(int n) {
        if (this.frameOffsets == null || n < 0 || n >= this.frameOffsets.length) {
            this.frameOffset.set(0.0f, 0.0f, 0.0f);
        } else {
            this.frameOffset.set(this.frameOffsets[n]);
        }
    }

    void setFrameOffsets(Point3f[] point3fArray) {
        this.frameOffsets = point3fArray;
    }

    void navigateSurface(float f, String string) {
    }

    class VibrationThread
    extends Thread
    implements Runnable {
        VibrationThread() {
            this.setName("VibrationThread");
        }

        public void run() {
            long l;
            long l2 = l = System.currentTimeMillis();
            try {
                do {
                    long l3;
                    int n;
                    int n2;
                    if ((n2 = 33 - (n = (int)((l3 = System.currentTimeMillis()) - l2))) > 0) {
                        Thread.sleep(n2);
                    }
                    l2 = l3 = System.currentTimeMillis();
                    n = (int)(l3 - l);
                    float f = (float)(n % TransformManager.this.vibrationPeriodMs) / (float)TransformManager.this.vibrationPeriodMs;
                    TransformManager.this.setVibrationT(f);
                    TransformManager.this.viewer.refresh(3, "VibrationThread:run()");
                } while (!this.isInterrupted());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class SpinThread
    extends Thread
    implements Runnable {
        float endDegrees;
        float nDegrees;
        BitSet bsAtoms;
        boolean isNav;
        boolean isGesture;
        boolean isReset;

        SpinThread(float f, BitSet bitSet, boolean bl, boolean bl2) {
            this.setName("SpinThread" + new Date());
            this.endDegrees = Math.abs(f);
            this.bsAtoms = bitSet;
            this.isNav = bl;
            this.isGesture = bl2;
        }

        public void run() {
            float f = this.isNav ? TransformManager.this.navFps : TransformManager.this.spinFps;
            TransformManager.this.viewer.getGlobalSettings().setParameterValue(this.isNav ? "_navigating" : "_spinning", true);
            int n = 0;
            long l = System.currentTimeMillis();
            while (!this.isInterrupted()) {
                int n2;
                int n3;
                boolean bl;
                if (this.isNav && f != TransformManager.this.navFps) {
                    f = TransformManager.this.navFps;
                    n = 0;
                    l = System.currentTimeMillis();
                } else if (!this.isNav && f != TransformManager.this.spinFps) {
                    f = TransformManager.this.spinFps;
                    n = 0;
                    l = System.currentTimeMillis();
                }
                if (f == 0.0f || !(!this.isNav ? TransformManager.this.spinOn : TransformManager.this.navOn)) {
                    TransformManager.this.setSpinOn(false);
                    TransformManager.this.setNavOn(false);
                    break;
                }
                boolean bl2 = TransformManager.this.viewer.getNavigateSurface();
                boolean bl3 = this.isNav ? bl2 || TransformManager.this.navX != 0.0f || TransformManager.this.navY != 0.0f || TransformManager.this.navZ != 0.0f : (bl = TransformManager.this.isSpinInternal && TransformManager.this.internalRotationAxis.angle != 0.0f || TransformManager.this.isSpinFixed && TransformManager.this.fixedRotationAxis.angle != 0.0f || !TransformManager.this.isSpinFixed && !TransformManager.this.isSpinInternal && (TransformManager.this.spinX != 0.0f || TransformManager.this.spinY != 0.0f || TransformManager.this.spinZ != 0.0f));
                int n4 = (int)(System.currentTimeMillis() - l);
                if ((n3 = (n2 = (int)((float)(++n * 1000) / f)) - n4) <= 0) continue;
                boolean bl4 = TransformManager.this.viewer.getInMotion();
                if (bl4) {
                    if (this.isGesture) break;
                    n3 += 1000;
                }
                try {
                    if (bl && (TransformManager.this.spinOn || TransformManager.this.navOn) && !bl4) {
                        if (this.isNav) {
                            TransformManager.this.setNavigationOffsetRelative(bl2);
                        } else if (TransformManager.this.isSpinInternal || TransformManager.this.isSpinFixed) {
                            float f2 = (TransformManager.this.isSpinInternal ? TransformManager.this.internalRotationAxis : TransformManager.this.fixedRotationAxis).angle / f;
                            if (TransformManager.this.isSpinInternal) {
                                TransformManager.this.rotateAxisAngleRadiansInternal(f2, this.bsAtoms);
                            } else {
                                TransformManager.this.rotateAxisAngleRadiansFixed(f2, this.bsAtoms);
                            }
                            this.nDegrees = (float)((double)this.nDegrees + Math.abs((double)f2 * 57.29577951308232));
                        } else {
                            if (TransformManager.this.spinX != 0.0f) {
                                TransformManager.this.rotateXRadians(TransformManager.this.spinX * ((float)Math.PI / 180) / f, null);
                            }
                            if (TransformManager.this.spinY != 0.0f) {
                                TransformManager.this.rotateYRadians(TransformManager.this.spinY * ((float)Math.PI / 180) / f, null);
                            }
                            if (TransformManager.this.spinZ != 0.0f) {
                                TransformManager.this.rotateZRadians(TransformManager.this.spinZ * ((float)Math.PI / 180) / f);
                            }
                        }
                        while (!this.isInterrupted() && !TransformManager.this.viewer.getRefreshing()) {
                            Thread.sleep(10L);
                        }
                        TransformManager.this.viewer.refresh(1, "SpinThread:run()");
                        if (!this.isNav && (double)this.nDegrees >= (double)this.endDegrees - 1.0E-5) {
                            TransformManager.this.setSpinOn(false);
                        }
                    }
                    Thread.sleep(n3);
                    if (!this.isReset) continue;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            if (!this.isReset) {
                TransformManager.this.setSpinOn(false);
            }
        }
    }

    class MotionThread
    extends Thread
    implements Runnable {
        private final Vector3f aaStepCenter = new Vector3f();
        private final Vector3f aaStepNavCenter = new Vector3f();
        private final AxisAngle4f aaStep = new AxisAngle4f();
        private final AxisAngle4f aaTotal = new AxisAngle4f();
        private final Matrix3f matrixStart = new Matrix3f();
        private final Matrix3f matrixStartInv = new Matrix3f();
        private final Matrix3f matrixStep = new Matrix3f();
        private final Matrix3f matrixEnd = new Matrix3f();
        private Point3f center;
        private float zoom;
        private float xTrans;
        private float yTrans;
        private Point3f navCenter;
        private float xNav;
        private float yNav;
        private float navDepth;
        private Point3f ptMoveToCenter;
        private float startRotationRadius;
        private float targetPixelScale;
        private int totalSteps;
        private float startPixelScale;
        private float targetRotationRadius;
        private int fps;
        private float rotationRadiusDelta;
        private float pixelScaleDelta;
        private float zoomStart;
        private float zoomDelta;
        private float xTransStart;
        private float xTransDelta;
        private float yTransStart;
        private float yTransDelta;
        private float xNavTransStart;
        private float xNavTransDelta;
        private float yNavTransDelta;
        private float yNavTransStart;
        private float navDepthStart;
        private float navDepthDelta;
        private long targetTime;
        private long frameTimeMillis;
        private int iStep;
        private boolean asThread;

        MotionThread() {
        }

        public void startMotion(boolean bl) {
            this.asThread = bl;
            if (bl) {
                this.start();
            } else {
                this.run();
            }
        }

        public void run() {
            if (this.totalSteps > 0) {
                TransformManager.this.viewer.setInMotion(true);
            }
            try {
                if (this.totalSteps == 0 || this.startMotion()) {
                    this.endMotion();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.totalSteps > 0) {
                TransformManager.this.viewer.setInMotion(false);
            }
            TransformManager.this.motion = null;
        }

        int set(float f, Point3f point3f, Matrix3f matrix3f, float f2, float f3, float f4, float f5, Point3f point3f2, float f6, float f7, float f8) {
            this.center = point3f;
            this.matrixEnd.set(matrix3f);
            this.zoom = f2;
            this.xTrans = f3;
            this.yTrans = f4;
            this.navCenter = point3f2;
            this.xNav = f6;
            this.yNav = f7;
            this.navDepth = f8;
            this.ptMoveToCenter = point3f == null ? TransformManager.this.fixedRotationCenter : point3f;
            this.startRotationRadius = TransformManager.this.modelRadius;
            this.targetRotationRadius = point3f == null || Float.isNaN(f5) ? TransformManager.this.modelRadius : (f5 <= 0.0f ? TransformManager.this.viewer.calcRotationRadius(point3f) : f5);
            this.startPixelScale = TransformManager.this.scaleDefaultPixelsPerAngstrom;
            float f9 = this.targetPixelScale = point3f == null ? this.startPixelScale : TransformManager.this.defaultScaleToScreen(this.targetRotationRadius);
            if (Float.isNaN(f2)) {
                f2 = TransformManager.this.zoomPercent;
            }
            TransformManager.this.getRotation(this.matrixStart);
            this.matrixStartInv.invert(this.matrixStart);
            this.matrixStep.mul(this.matrixEnd, this.matrixStartInv);
            this.aaTotal.set(this.matrixStep);
            this.fps = 30;
            this.totalSteps = (int)(f * (float)this.fps);
            if (this.totalSteps == 0) {
                return 0;
            }
            this.frameTimeMillis = 1000 / this.fps;
            this.targetTime = System.currentTimeMillis();
            this.zoomStart = TransformManager.this.zoomPercent;
            this.zoomDelta = f2 - this.zoomStart;
            this.xTransStart = TransformManager.this.getTranslationXPercent();
            this.xTransDelta = f3 - this.xTransStart;
            this.yTransStart = TransformManager.this.getTranslationYPercent();
            this.yTransDelta = f4 - this.yTransStart;
            this.aaStepCenter.set(this.ptMoveToCenter);
            this.aaStepCenter.sub(TransformManager.this.fixedRotationCenter);
            this.aaStepCenter.scale(1.0f / (float)this.totalSteps);
            this.pixelScaleDelta = this.targetPixelScale - this.startPixelScale;
            this.rotationRadiusDelta = this.targetRotationRadius - this.startRotationRadius;
            if (point3f2 != null && TransformManager.this.mode == 1) {
                this.aaStepNavCenter.set(point3f2);
                this.aaStepNavCenter.sub(TransformManager.this.navigationCenter);
                this.aaStepNavCenter.scale(1.0f / (float)this.totalSteps);
            }
            float f10 = TransformManager.this.getNavigationOffsetPercent('X');
            this.xNavTransDelta = f6 - f10;
            this.yNavTransStart = TransformManager.this.getNavigationOffsetPercent('Y');
            this.yNavTransDelta = f7 - this.yNavTransStart;
            float f11 = TransformManager.this.getNavigationDepthPercent();
            this.navDepthDelta = f8 - f11;
            return this.totalSteps;
        }

        boolean startMotion() {
            while (this.iStep < this.totalSteps) {
                if (!Float.isNaN(this.matrixEnd.m00)) {
                    TransformManager.this.getRotation(this.matrixStart);
                    this.matrixStartInv.invert(this.matrixStart);
                    this.matrixStep.mul(this.matrixEnd, this.matrixStartInv);
                    this.aaTotal.set(this.matrixStep);
                    this.aaStep.set(this.aaTotal);
                    this.aaStep.angle /= (float)(this.totalSteps - this.iStep);
                    if (this.aaStep.angle == 0.0f) {
                        this.matrixStep.setIdentity();
                    } else {
                        this.matrixStep.set(this.aaStep);
                    }
                    this.matrixStep.mul(this.matrixStart);
                }
                float f = (float)this.iStep / ((float)this.totalSteps - 1.0f);
                TransformManager.this.modelRadius = this.startRotationRadius + this.rotationRadiusDelta * f;
                TransformManager.this.scaleDefaultPixelsPerAngstrom = this.startPixelScale + this.pixelScaleDelta * f;
                if (!Float.isNaN(this.xTrans)) {
                    TransformManager.this.zoomToPercent(this.zoomStart + this.zoomDelta * f);
                    TransformManager.this.translateToPercent('x', this.xTransStart + this.xTransDelta * f);
                    TransformManager.this.translateToPercent('y', this.yTransStart + this.yTransDelta * f);
                }
                TransformManager.this.setRotation(this.matrixStep);
                if (this.center != null) {
                    TransformManager.this.fixedRotationCenter.add(this.aaStepCenter);
                }
                if (this.navCenter != null && TransformManager.this.mode == 1) {
                    Point3f point3f = new Point3f(TransformManager.this.navigationCenter);
                    point3f.add(this.aaStepNavCenter);
                    TransformManager.this.navigate(0.0f, point3f);
                    if (!Float.isNaN(this.xNav) && !Float.isNaN(this.yNav)) {
                        TransformManager.this.navTranslatePercent(0.0f, this.xNavTransStart + this.xNavTransDelta * f, this.yNavTransStart + this.yNavTransDelta * f);
                    }
                    if (!Float.isNaN(this.navDepth)) {
                        TransformManager.this.setNavigationDepthPercent(0.0f, this.navDepthStart + this.navDepthDelta * f);
                    }
                }
                this.targetTime += this.frameTimeMillis;
                if (System.currentTimeMillis() < this.targetTime) {
                    TransformManager.this.viewer.requestRepaintAndWait();
                    if (TransformManager.this.motion == null || !this.asThread && !TransformManager.this.viewer.isScriptExecuting()) {
                        return false;
                    }
                    int n = (int)(this.targetTime - System.currentTimeMillis());
                    if (n > 0) {
                        try {
                            Thread.sleep(n);
                        }
                        catch (InterruptedException interruptedException) {
                            return false;
                        }
                    }
                }
                ++this.iStep;
            }
            return true;
        }

        void endMotion() {
            TransformManager.this.setRotationRadius(this.targetRotationRadius, true);
            TransformManager.this.scaleDefaultPixelsPerAngstrom = this.targetPixelScale;
            if (this.center != null) {
                TransformManager.this.moveRotationCenter(this.center, !TransformManager.this.windowCentered);
            }
            if (!Float.isNaN(this.xTrans)) {
                TransformManager.this.zoomToPercent(this.zoom);
                TransformManager.this.translateToPercent('x', this.xTrans);
                TransformManager.this.translateToPercent('y', this.yTrans);
            }
            TransformManager.this.setRotation(this.matrixEnd);
            if (this.navCenter != null && TransformManager.this.mode == 1) {
                TransformManager.this.navigationCenter.set(this.navCenter);
                if (!Float.isNaN(this.xNav) && !Float.isNaN(this.yNav)) {
                    TransformManager.this.navTranslatePercent(0.0f, this.xNav, this.yNav);
                }
                if (!Float.isNaN(this.navDepth)) {
                    TransformManager.this.setNavigationDepthPercent(0.0f, this.navDepth);
                }
            }
        }
    }
}

