/*
 * thaikb.c - Thai keyboard maps
 * Created: 22 Jul 1999 (split from command.c)
 * Author:  Theppitak Karoonboonyanan <thep@links.nectec.or.th>
 */

#include "thaikb.h"

/* TIS 820-2538 Keyboard Layout */
static const char tis_qwerty_map[] = {
   0x000, 0x001, 0x002, 0x003, 0x004, 0x005, 0x006, 0x007,
   0x008, 0x009, 0x00A, 0x00B, 0x00C, 0x00D, 0x00E, 0x00F,
   0x010, 0x011, 0x012, 0x013, 0x014, 0x015, 0x016, 0x017,
   0x018, 0x019, 0x01A, 0x01B, 0x01C, 0x01D, 0x01E, 0x01F,
   0x020, 0x0E5, 0x02E, 0x0F2, 0x0F3, 0x0F4, 0x0EE, 0x0A7,
   0x0F6, 0x0F7, 0x0F5, 0x0F9, 0x0C1, 0x0A2, 0x0E3, 0x0BD,
   0x0A8, 0x0DF, 0x02F, 0x02D, 0x0C0, 0x0B6, 0x0D8, 0x0D6,
   0x0A4, 0x0B5, 0x0AB, 0x0C7, 0x0B2, 0x0AA, 0x0CC, 0x0C6,
   0x0F1, 0x0C4, 0x0DA, 0x0A9, 0x0AF, 0x0AE, 0x0E2, 0x0AC,
   0x0E7, 0x0B3, 0x0EB, 0x0C9, 0x0C8, 0x03F, 0x0EC, 0x0CF,
   0x0AD, 0x0F0, 0x0B1, 0x0A6, 0x0B8, 0x0EA, 0x0CE, 0x022,
   0x029, 0x0ED, 0x028, 0x0BA, 0x0A3, 0x0C5, 0x0D9, 0x0F8,
   0x0EF, 0x0BF, 0x0D4, 0x0E1, 0x0A1, 0x0D3, 0x0B4, 0x0E0,
   0x0E9, 0x0C3, 0x0E8, 0x0D2, 0x0CA, 0x0B7, 0x0D7, 0x0B9,
   0x0C2, 0x0E6, 0x0BE, 0x0CB, 0x0D0, 0x0D5, 0x0CD, 0x0E4,
   0x0BB, 0x0D1, 0x0BC, 0x0B0, 0x0A5, 0x02C, 0x0FB, 0x07F
};

/* Ketmanee Layout (default) */
static const char ketmanee_qwerty_map[] = {
   0x000, 0x001, 0x002, 0x003, 0x004, 0x005, 0x006, 0x007,
   0x008, 0x009, 0x00A, 0x00B, 0x00C, 0x00D, 0x00E, 0x00F,
   0x010, 0x011, 0x012, 0x013, 0x014, 0x015, 0x016, 0x017,
   0x018, 0x019, 0x01A, 0x01B, 0x01C, 0x01D, 0x01E, 0x01F,
   0x020, 0x02B, 0x02E, 0x0F2, 0x0F3, 0x0F4, 0x0DF, 0x0A7,
   0x0F6, 0x0F7, 0x0F5, 0x0F9, 0x0C1, 0x0A2, 0x0E3, 0x0BD,
   0x0A8, 0x0E5, 0x02F, 0x02D, 0x0C0, 0x0B6, 0x0D8, 0x0D6,
   0x0A4, 0x0B5, 0x0AB, 0x0C7, 0x0B2, 0x0AA, 0x0CC, 0x0C6,
   0x0F1, 0x0C4, 0x0DA, 0x0A9, 0x0AF, 0x0AE, 0x0E2, 0x0AC,
   0x0E7, 0x0B3, 0x0EB, 0x0C9, 0x0C8, 0x03F, 0x0EC, 0x0CF,
   0x0AD, 0x0F0, 0x0B1, 0x0A6, 0x0B8, 0x0EA, 0x0CE, 0x022,
   0x029, 0x0ED, 0x028, 0x0BA, 0x0A3, 0x0C5, 0x0D9, 0x0F8,
   0x05F, 0x0BF, 0x0D4, 0x0E1, 0x0A1, 0x0D3, 0x0B4, 0x0E0,
   0x0E9, 0x0C3, 0x0E8, 0x0D2, 0x0CA, 0x0B7, 0x0D7, 0x0B9,
   0x0C2, 0x0E6, 0x0BE, 0x0CB, 0x0D0, 0x0D5, 0x0CD, 0x0E4,
   0x0BB, 0x0D1, 0x0BC, 0x0B0, 0x0A5, 0x02C, 0x025, 0x07F
};

static const char *thai_qwerty_map = ketmanee_qwerty_map;

void thai_set_keyboard(int thai_kbmode)
{
   switch (thai_kbmode) {
      case THAI_KB_TIS820_2538:
         thai_qwerty_map = tis_qwerty_map;  break;
      case THAI_KB_KETMANEE:
      default:
         thai_qwerty_map = ketmanee_qwerty_map;  break;
   }
}

char thai_map_qwerty(char c)
{
   return thai_qwerty_map[c];
}

