/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/test_peer_xif.cc,v 1.26 2009/01/05 18:31:13 jtc Exp $"

#include "test_peer_xif.hh"

bool
XrlTestPeerV0p1Client::send_register(
	const char*	dst_xrl_target_name,
	const string&	coordinator,
	const uint32_t&	genid,
	const RegisterCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/register");
        x->args().add(XrlAtom(coordinator));
        x->args().add(XrlAtom(genid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, coordinator);
    x->args().set_arg(1, genid);

    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_register, cb));
}


/* Unmarshall register */
void
XrlTestPeerV0p1Client::unmarshall_register(
	const XrlError&	e,
	XrlArgs*	a,
	RegisterCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlTestPeerV0p1Client::send_packetisation(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const PacketisationCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/packetisation");
        x->args().add(XrlAtom(protocol));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, protocol);

    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_packetisation, cb));
}


/* Unmarshall packetisation */
void
XrlTestPeerV0p1Client::unmarshall_packetisation(
	const XrlError&	e,
	XrlArgs*	a,
	PacketisationCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlTestPeerV0p1Client::send_use_4byte_asnums(
	const char*	dst_xrl_target_name,
	const bool&	use,
	const Use4ByteAsnumsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/use_4byte_asnums");
        x->args().add(XrlAtom(use));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, use);

    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_use_4byte_asnums, cb));
}


/* Unmarshall use_4byte_asnums */
void
XrlTestPeerV0p1Client::unmarshall_use_4byte_asnums(
	const XrlError&	e,
	XrlArgs*	a,
	Use4ByteAsnumsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlTestPeerV0p1Client::send_connect(
	const char*	dst_xrl_target_name,
	const string&	host,
	const uint32_t&	port,
	const ConnectCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/connect");
        x->args().add(XrlAtom(host));
        x->args().add(XrlAtom(port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, host);
    x->args().set_arg(1, port);

    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_connect, cb));
}


/* Unmarshall connect */
void
XrlTestPeerV0p1Client::unmarshall_connect(
	const XrlError&	e,
	XrlArgs*	a,
	ConnectCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlTestPeerV0p1Client::send_listen(
	const char*	dst_xrl_target_name,
	const string&	address,
	const uint32_t&	port,
	const ListenCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/listen");
        x->args().add(XrlAtom(address));
        x->args().add(XrlAtom(port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, address);
    x->args().set_arg(1, port);

    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_listen, cb));
}


/* Unmarshall listen */
void
XrlTestPeerV0p1Client::unmarshall_listen(
	const XrlError&	e,
	XrlArgs*	a,
	ListenCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlTestPeerV0p1Client::send_bind(
	const char*	dst_xrl_target_name,
	const string&	address,
	const uint32_t&	port,
	const BindCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/bind");
        x->args().add(XrlAtom(address));
        x->args().add(XrlAtom(port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, address);
    x->args().set_arg(1, port);

    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_bind, cb));
}


/* Unmarshall bind */
void
XrlTestPeerV0p1Client::unmarshall_bind(
	const XrlError&	e,
	XrlArgs*	a,
	BindCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlTestPeerV0p1Client::send_send(
	const char*	dst_xrl_target_name,
	const vector<uint8_t>&	data,
	const SendCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/send");
        x->args().add(XrlAtom(data));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, data);

    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_send, cb));
}


/* Unmarshall send */
void
XrlTestPeerV0p1Client::unmarshall_send(
	const XrlError&	e,
	XrlArgs*	a,
	SendCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlTestPeerV0p1Client::send_disconnect(
	const char*	dst_xrl_target_name,
	const DisconnectCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/disconnect");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_disconnect, cb));
}


/* Unmarshall disconnect */
void
XrlTestPeerV0p1Client::unmarshall_disconnect(
	const XrlError&	e,
	XrlArgs*	a,
	DisconnectCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlTestPeerV0p1Client::send_reset(
	const char*	dst_xrl_target_name,
	const ResetCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/reset");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_reset, cb));
}


/* Unmarshall reset */
void
XrlTestPeerV0p1Client::unmarshall_reset(
	const XrlError&	e,
	XrlArgs*	a,
	ResetCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlTestPeerV0p1Client::send_terminate(
	const char*	dst_xrl_target_name,
	const TerminateCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "test_peer/0.1/terminate");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlTestPeerV0p1Client::unmarshall_terminate, cb));
}


/* Unmarshall terminate */
void
XrlTestPeerV0p1Client::unmarshall_terminate(
	const XrlError&	e,
	XrlArgs*	a,
	TerminateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}
