
/**
 * Readtexture does just what the name suggests. This file is mostly
 * a stolen and dumbed down version of the "textiff" demo from the GLUT
 * toolkit. I'll probably change this file to use PNG files when the
 * libpng matures a little more. Or at least gets out of beta. 
 *                               /August
 *
 * (Homage, obviously, to Mark Kilgard, who wrote GLUT.)
 * Original license follows:
 **/

/* Copyright (c) Mark J. Kilgard, 1997. */

/* This program is freely distributable without licensing fees  and is
   provided without guarantee or warrantee expressed or  implied. This
   program is -not- in the public domain. */

#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "xt.h"

texture *readTexture(char *imgname)
{
  GdkPixbuf *img;
  texture *tex;

  img = gdk_pixbuf_new_from_file(imgname);
  if (img == NULL) 
    {
      fprintf(stderr, "Couldn't load texture file %s\n", imgname);
      exit(EXIT_FAILURE);
    }

  tex = (texture *)malloc(sizeof(texture));
  if(!tex)
  {
      g_print("Couldn't allocate memory for texture struct!\n");
      return NULL;
  }

  tex->width  = gdk_pixbuf_get_width(img);
  tex->height = gdk_pixbuf_get_height(img);
  tex->depth  = gdk_pixbuf_get_has_alpha(img)? 4 : 3 ;
  tex->bits = (guint32 *)malloc(tex->depth * tex->width * tex->height);

  memcpy (tex->bits, gdk_pixbuf_get_pixels(img), 
	  tex->depth * tex->width * tex->height);

  gdk_pixbuf_unref(img);

  return tex;
}

