class gui () =
  let box = GPack.vbox ~homogeneous:false () in
  let menubar =
    GMenu.menu_bar ~packing:(box#pack ~expand:false ~fill:true) ()
  in
  let item =
    GMenu.menu_item ~label:(Zog_messages.mnFile) ~packing:menubar#add ()
  in
  let menuFile = GMenu.menu ~packing:item#set_submenu () in
  let itemSave =
    GMenu.menu_item ~label:(Zog_messages.mnSave) ~packing:menuFile#add ()
  in
  let itemQuit =
    GMenu.menu_item ~label:(Zog_messages.mnQuit) ~packing:menuFile#add ()
  in
  let itemEntity =
    GMenu.menu_item ~label:(Zog_messages.mnEntity) ~packing:menubar#add ()
  in
  let menuEntity = GMenu.menu ~packing:itemEntity#set_submenu () in
  let itemAdd_entity =
    GMenu.menu_item ~label:(Zog_messages.mnAdd_entity) ~packing:menuEntity#add
      ()
  in
  let itemUp_entity =
    GMenu.menu_item ~label:(Zog_messages.mnUp_entity) ~packing:menuEntity#add
      ()
  in
  let itemEntity_properties =
    GMenu.menu_item ~label:(Zog_messages.mnEntity_properties)
      ~packing:menuEntity#add ()
  in
  let sep = GMenu.menu_item ~packing:menuEntity#add () in
  let itemRemove_entity =
    GMenu.menu_item ~label:(Zog_messages.mnRemove_entity)
      ~packing:menuEntity#add ()
  in
  let itemHelp =
    GMenu.menu_item ~label:(Zog_messages.mnHelp) ~packing:menubar#add ()
  in
  let menuHelp = GMenu.menu ~packing:itemHelp#set_submenu () in
  let accel_group = GtkData.AccelGroup.create () in
  let _ = menuFile#set_accel_group accel_group in
  let _ =
    itemSave#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE]) GdkKeysyms._S
  in
  let _ =
    itemQuit#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE]) GdkKeysyms._Q
  in
  let _ = menuEntity#set_accel_group accel_group in
  let _ =
    itemAdd_entity#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE]) GdkKeysyms._A
  in
  let _ =
    itemUp_entity#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE]) GdkKeysyms._U
  in
  let _ =
    itemEntity_properties#add_accelerator ~group:accel_group
      ~modi:([`CONTROL]) ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._E
  in
  let _ = menuHelp#set_accel_group accel_group in
  let wscroll_entities =
    GBin.scrolled_window ~hpolicy:`AUTOMATIC ~vpolicy:`AUTOMATIC
      ~placement:`TOP_LEFT ~packing:(box#pack ~expand:true ~fill:true) ()
  in
  let wlist_entities =
    GList.clist ~titles:([Zog_messages.entity; Zog_messages.parameters])
      ~shadow_type:`NONE ~selection_mode:`SINGLE ~titles_show:true
      ~packing:wscroll_entities#add ()
  in
  object
    val box = box
    val menubar = menubar
    val accel_group = accel_group
    val item = item
    val menuFile = menuFile
    val itemSave = itemSave
    val itemQuit = itemQuit
    val itemEntity = itemEntity
    val menuEntity = menuEntity
    val itemAdd_entity = itemAdd_entity
    val itemUp_entity = itemUp_entity
    val itemEntity_properties = itemEntity_properties
    val sep = sep
    val itemRemove_entity = itemRemove_entity
    val itemHelp = itemHelp
    val menuHelp = menuHelp
    val wscroll_entities = wscroll_entities
    val wlist_entities = wlist_entities
    method box = box
    method menubar = menubar
    method accel_group = accel_group
    method item = item
    method menuFile = menuFile
    method itemSave = itemSave
    method itemQuit = itemQuit
    method itemEntity = itemEntity
    method menuEntity = menuEntity
    method itemAdd_entity = itemAdd_entity
    method itemUp_entity = itemUp_entity
    method itemEntity_properties = itemEntity_properties
    method sep = sep
    method itemRemove_entity = itemRemove_entity
    method itemHelp = itemHelp
    method menuHelp = menuHelp
    method wscroll_entities = wscroll_entities
    method wlist_entities = wlist_entities
    method coerce = box#coerce
  end;;
class gui_entity () =
  let box = GPack.vbox ~homogeneous:false () in
  let menubar =
    GMenu.menu_bar ~packing:(box#pack ~expand:false ~fill:true) ()
  in
  let item =
    GMenu.menu_item ~label:(Zog_messages.mnFile) ~packing:menubar#add ()
  in
  let menuFile = GMenu.menu ~packing:item#set_submenu () in
  let itemSave =
    GMenu.menu_item ~label:(Zog_messages.mnSave) ~packing:menuFile#add ()
  in
  let itemEdit =
    GMenu.menu_item ~label:(Zog_messages.mnEdit) ~packing:menubar#add ()
  in
  let menuEdit = GMenu.menu ~packing:itemEdit#set_submenu () in
  let itemCopy =
    GMenu.menu_item ~label:(Zog_messages.mnCopy) ~packing:menuEdit#add ()
  in
  let itemCut =
    GMenu.menu_item ~label:(Zog_messages.mnCut) ~packing:menuEdit#add ()
  in
  let itemPaste =
    GMenu.menu_item ~label:(Zog_messages.mnPaste) ~packing:menuEdit#add ()
  in
  let sep = GMenu.menu_item ~packing:menuEdit#add () in
  let itemUp =
    GMenu.menu_item ~label:(Zog_messages.mnUp) ~packing:menuEdit#add ()
  in
  let itemDelete =
    GMenu.menu_item ~label:(Zog_messages.mnRemove) ~packing:menuEdit#add ()
  in
  let itemTemplates =
    GMenu.menu_item ~label:(Zog_messages.mnTemplates) ~packing:menubar#add ()
  in
  let menuTemplates = GMenu.menu ~packing:itemTemplates#set_submenu () in
  let accel_group = GtkData.AccelGroup.create () in
  let _ = menuFile#set_accel_group accel_group in
  let _ =
    itemSave#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE]) GdkKeysyms._S
  in
  let _ = menuEdit#set_accel_group accel_group in
  let _ =
    itemCopy#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE]) GdkKeysyms._C
  in
  let _ =
    itemCut#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE]) GdkKeysyms._X
  in
  let _ =
    itemPaste#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE]) GdkKeysyms._V
  in
  let _ =
    itemUp#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE]) GdkKeysyms._U
  in
  let _ =
    itemDelete#add_accelerator ~group:accel_group ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._Delete
  in
  let _ = menuTemplates#set_accel_group accel_group in
  let pane =
    GPack.paned `HORIZONTAL ~packing:(box#pack ~expand:true ~fill:true) ()
  in
  let vbox_props1 =
    GPack.vbox ~width:440 ~homogeneous:false ~packing:pane#add1 ()
  in
  let wb_preview =
    GButton.check_button ~active:true ~draw_indicator:true
      ~packing:(vbox_props1#pack ~expand:false ~fill:true) ()
  in
  let wl_preview =
    GMisc.label ~text:(Zog_messages.preview) ~justify:`LEFT ~line_wrap:true
      ~packing:wb_preview#add ()
  in
  let wf_props =
    GBin.frame ~border_width:4 ~label:(Zog_messages.properties)
      ~shadow_type:`IN ~packing:(vbox_props1#pack ~expand:true ~fill:true) ()
  in
  let vbox_props = GPack.vbox ~homogeneous:false ~packing:wf_props#add () in
  let hbox_ = GPack.hbox ~homogeneous:false ~packing:pane#add2 () in
  let wscroll_tree =
    GBin.scrolled_window ~hpolicy:`AUTOMATIC ~vpolicy:`AUTOMATIC
      ~placement:`TOP_LEFT ~packing:(hbox_#pack ~expand:true ~fill:true) ()
  in
  let wtree =
    GTree.tree ~selection_mode:`SINGLE ~view_mode:`LINE ~view_lines:true
      ~packing:wscroll_tree#add_with_viewport ()
  in
  let whdl_palette =
    GBin.handle_box ~border_width:2 ~handle_position:`TOP ~snap_edge:`TOP
      ~shadow_type:`ETCHED_IN ~packing:(hbox_#pack ~expand:false ~fill:true)
      ()
  in
  let wtab_widgets =
    GPack.table ~rows:1 ~columns:1 ~packing:whdl_palette#add ()
  in
  object
    val box = box
    val menubar = menubar
    val accel_group = accel_group
    val item = item
    val menuFile = menuFile
    val itemSave = itemSave
    val itemEdit = itemEdit
    val menuEdit = menuEdit
    val itemCopy = itemCopy
    val itemCut = itemCut
    val itemPaste = itemPaste
    val sep = sep
    val itemUp = itemUp
    val itemDelete = itemDelete
    val itemTemplates = itemTemplates
    val menuTemplates = menuTemplates
    val pane = pane
    val vbox_props1 = vbox_props1
    val wb_preview = wb_preview
    val wl_preview = wl_preview
    val wf_props = wf_props
    val vbox_props = vbox_props
    val hbox_ = hbox_
    val wscroll_tree = wscroll_tree
    val wtree = wtree
    val whdl_palette = whdl_palette
    val wtab_widgets = wtab_widgets
    method box = box
    method menubar = menubar
    method accel_group = accel_group
    method item = item
    method menuFile = menuFile
    method itemSave = itemSave
    method itemEdit = itemEdit
    method menuEdit = menuEdit
    method itemCopy = itemCopy
    method itemCut = itemCut
    method itemPaste = itemPaste
    method sep = sep
    method itemUp = itemUp
    method itemDelete = itemDelete
    method itemTemplates = itemTemplates
    method menuTemplates = menuTemplates
    method pane = pane
    method vbox_props1 = vbox_props1
    method wb_preview = wb_preview
    method wl_preview = wl_preview
    method wf_props = wf_props
    method vbox_props = vbox_props
    method hbox_ = hbox_
    method wscroll_tree = wscroll_tree
    method wtree = wtree
    method whdl_palette = whdl_palette
    method wtab_widgets = wtab_widgets
    method coerce = box#coerce
  end;;
