/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008-2010 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#include <QApplication>
#include <QTextCodec>
#include <QTranslator>
#include <QTime>
#include <QMessageBox>
#include <QImageWriter>

#include "MainWindow.h"
#include "Settings.h"
#include "Version.h"
#include "Font.h"
#include "DataMeteoAbstract.h"


//===========================================================
int main (int argc, char *argv[])
{
    QApplication app(argc, argv);
	qsrand(QTime::currentTime().msec());
	
    QTextCodec::setCodecForTr(QTextCodec::codecForName("utf8"));
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("utf8"));

	//----------------------------------------------------------
    // Find application settings files
    //----------------------------------------------------------
	Settings::initializeSettingsDir();
	Settings::initializeGribFilesDir();
    //printf("settings: %s\n", qPrintable( Settings::getSettingsDir()) );
	//QString path = Util::getSetting("gribFilePath", "").toString();
    //printf("Grib files dir: %s\n", qPrintable(path) );

	Util::setSetting("AppVersion", Version::getCompleteName());

    //----------------------------------------------------------
    // Fonts
    //----------------------------------------------------------
	Font::loadAllFonts();

    //----------------------------------------------------------
/*	double pr, h;
	pr = 200;
	h = DataRecordAbstract::computeGeopotentialAltitude (pr);
	printf ("%g %g\n", pr,h);
	pr = 300;
	h = DataRecordAbstract::computeGeopotentialAltitude (pr);
	printf ("%g %g\n", pr,h);
	pr = 500;
	h = DataRecordAbstract::computeGeopotentialAltitude (pr);
	printf ("%g %g\n", pr,h);*/
	//----------------------------------------------------------
    // Images formats
    //----------------------------------------------------------
/*	QList<QByteArray> list = QImageWriter::supportedImageFormats ();
	for (int i = 0; i < list.size(); ++i) {
		DBGS (list.at(i).data());
	}	*/
	//----------------------------------------------------------
    // Load language
    //----------------------------------------------------------
    QTranslator trZygrib;
    QTranslator trSystem;

    QString lang = Util::getSetting("appLanguage", "").toString();
    if (lang == "") {
		//----------------------------------------------------------
		// first call of zyGrib : choice language
		//----------------------------------------------------------
		DialogChooseLang langChooser ("");
		langChooser.exec ();
        lang = langChooser.getLanguage();
        Util::setSetting("appLanguage", lang);
    }

    //-----------------------------------------------
    // Set language
    //-----------------------------------------------
    if (lang == "fr") {
        QLocale::setDefault(QLocale("fr_FR"));
        trSystem.load( QString("qt_fr"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        trZygrib.load( QString("tr/zyGrib_") + lang);
        app.installTranslator(&trZygrib);
        app.installTranslator(&trSystem);
    }
    else if (lang == "de") {
        QLocale::setDefault(QLocale("de_DE"));
        trSystem.load( QString("qt_de"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        trZygrib.load( QString("tr/zyGrib_") + lang);
        app.installTranslator(&trZygrib);
        app.installTranslator(&trSystem);
    }
    else if (lang == "ru") {
        QLocale::setDefault(QLocale("ru_RU"));
        trSystem.load( QString("qt_ru"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        trZygrib.load( QString("tr/zyGrib_") + lang);
        app.installTranslator(&trZygrib);
        app.installTranslator(&trSystem);
    }
    else if (lang == "pl") {
        QLocale::setDefault(QLocale("pl_PL"));
        trSystem.load( QString("qt_pl"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        trZygrib.load( QString("tr/zyGrib_") + lang);
        app.installTranslator(&trZygrib);
        app.installTranslator(&trSystem);
    }
    else if (lang == "pt") {
        QLocale::setDefault(QLocale("pt_PT"));
        trSystem.load( QString("qt_pt"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        trZygrib.load( QString("tr/zyGrib_") + lang);
        app.installTranslator(&trZygrib);
        app.installTranslator(&trSystem);
    }
    else if (lang == "es") {
        QLocale::setDefault(QLocale("es_ES"));
        trSystem.load( QString("qt_es"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        trZygrib.load( QString("tr/zyGrib_") + lang);
        app.installTranslator(&trZygrib);
        app.installTranslator(&trSystem);
    }
    else if (lang == "it") {
        QLocale::setDefault(QLocale("it_IT"));
        trSystem.load( QString("qt_it"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        trZygrib.load( QString("tr/zyGrib_") + lang);
        app.installTranslator(&trZygrib);
        app.installTranslator(&trSystem);
    }
    else if (lang == "nl") {
        QLocale::setDefault(QLocale("nl_NL"));
        trSystem.load( QString("qt_nl"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        trZygrib.load( QString("tr/zyGrib_") + lang);
        app.installTranslator(&trZygrib);
        app.installTranslator(&trSystem);
    }
    else if (lang == "cz") {
        QLocale::setDefault(QLocale("cz_CZ"));
        trSystem.load( QString("qt_cz"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        trZygrib.load( QString("tr/zyGrib_") + lang);
        app.installTranslator(&trZygrib);
        app.installTranslator(&trSystem);
    }
    else { 	// e=English = default
        QLocale::setDefault(QLocale("en_US"));
    }


    //----------------------------------------------------------
    // Test if grib file exists (command line parameter)
    //----------------------------------------------------------
	QString filename = "";
	if (argc > 1)
	{
		filename = argv[1];
		if(! QFile::exists(filename)) {
			filename = "";
	 	}
	}

    //====================================================
    // Open main window
    //====================================================
    MainWindow win(800, 600, filename);
    win.show();

    //----------------------------------------------------------
    // open grib file (command line parameter)
    //----------------------------------------------------------
    if (filename != "") {
    	// open file, after show(), when real window size is known
		win.openMeteoDataFile(filename, true);
    }

    app.installTranslator(NULL);

    //====================================================

    return app.exec();
}
