#include "FireGLControl.h"
#include <signal.h>
#include "ati.xpm"
#ifdef FGL_TVOUT
#include "ATITVOExtensions.h"
extern "C" { 
    Bool ExtATITVOGetData(ATITVOGetDataPtr pATITVOGetData);
}
#endif // FGL_TVOUT

extern QString InstallPath ;

Sheet::Sheet( QWidget *parent, const char *name, bool is_firegl, bool has_dual, bool has_gamma, WFlags flags ) 
     : QTabDialog( parent, name, flags )
{
  QString Str ;
  bool has_tvout = FALSE;
#ifdef FGL_TVOUT
  ATITVOGetDataRec TVData;
#endif // FGL_TVOUT

#ifdef FGL_TVOUT
  ExtATITVOGetData(&TVData);
  if (TVData.TVConnected)
    has_tvout = FALSE; //FIXME: temporary hack! refer to EPR #154298, we don't need to have the tv-out tab in the panel for now that the DAL integration is not entirely working as expected. Once it is made sure that everything works as expected, change FALSE back to TRUE in this line.
  else
    has_tvout = FALSE;
#endif // FGL_TVOUT

  setGeometry ( QApplication::desktop()->width()/2 - PANEL_WIDTH/2, QApplication::desktop()->height()/2 - PANEL_HEIGHT/2, PANEL_WIDTH, PANEL_HEIGHT ) ;
  setFont (QFont( "Helvetica", 10 ) ) ;

  setApplyButton () ;
  setOkButton () ;
  setCancelButton() ;
  
  // BoardInfo.FamilyName hasn't been updated so it has been removed, however, the old function has been left in BoardInfo.cpp
  Str = tr("ATI Control Panel") ;
  setCaption( Str );

  {
    QPixmap pixmap ( ati ) ;
    setIcon ( pixmap ) ;
  }

  pInfo = new Page ( this, INFO_PAGE, is_firegl ) ;

  if ( has_dual )
      pDual = new Page ( this, DUALSCREEN_PAGE, is_firegl ) ;
  else
      pDual = NULL;
#if 0
  if ( is_firegl )
      pConfig = new Page ( this, CONFIG_PAGE, is_firegl ) ;
  else
      pConfig = NULL;
#endif
  if ( has_gamma )
      pAdjust = new Page ( this, ADJUST_PAGE, is_firegl ) ;
  else
      pAdjust = NULL;

  if ( has_tvout )
      pTVout = new Page ( this, ATITVO_PAGE, is_firegl ) ;
  else
      pTVout = NULL;

  connect( this, SIGNAL( applyButtonPressed() ), SLOT( OnApply() ) );
  connect( this, SIGNAL( cancelButtonPressed() ), SLOT( OnCancel() ) );

  connect( this, SIGNAL( currentChanged( QWidget * ) ), SLOT( OnActivate( QWidget *) ) );

  setMinimumSize ( PANEL_WIDTH, PANEL_HEIGHT ) ;
  setMaximumSize ( PANEL_WIDTH, PANEL_HEIGHT ) ;

  //repaint the page - required to show the window decoration (note: this seems to do setGeometry as well)
  reparent(parentWidget(), flags, pos());  
}

void Sheet::OnApply ( )
{
//  printf ( "OnApply()\n" ) ;
  ApplyOK = APPLY_OK ;
  emit Apply ( &ApplyOK ) ;
  if ( ApplyOK & APPLY_NOT_OK ) return ;
  if ( ApplyOK & APPLY_OK_RESTART )
  {
    QString Str ;

    Str = tr("Your settings have changed.\n\n") ;
    Str += tr("You will need to restart XServer so\n") ;
    Str += tr("that the new settings can take effect.") ;
	  QMessageBox::information(
              0, tr("Settings Change"),

				      Str,
				      QMessageBox::Ok + QMessageBox::Default
                               ) ;
//    QMessageBox mb ( tr("Settings Change"),
//                     Str,
//                     QMessageBox::Information,
//                     QMessageBox::Yes | QMessageBox::Default,
//                     QMessageBox::No | QMessageBox::Escape,
//
//                     0,
//                     this
//                   ) ;
//    mb.setButtonText ( QMessageBox::Yes, tr("Restart Now") ) ;
//
//    mb.setButtonText ( QMessageBox::No, tr("Don't Restart Now") ) ;
//    if ( mb.exec () == QMessageBox::No ) return ;
//    Restart ( ) ;
  }
}

void Sheet::OnCancel ( )
{
//  printf ( "OnCancel()\n" ) ;
  emit Cancel ( ) ;
  qApp->quit();
}

void Sheet::OnActivate ( QWidget *pPage )
{
  if ( pPage == pInfo ) emit Activate ( INFO_PAGE ) ;
  else if ( pPage == pDual ) emit Activate ( DUALSCREEN_PAGE ) ;
  else if ( pPage == pAdjust ) emit Activate ( ADJUST_PAGE ) ;
  else if ( pPage == pTVout ) emit Activate ( ATITVO_PAGE ) ;
}

void Sheet::closeEvent ( QCloseEvent* e )
{

//  printf ( "closeEvent( )\n" ) ;

  OnCancel ();
  e->accept();
}

void Sheet::accept ( )
{
//  printf ( "accept( )\n" ) ;
  if ( ApplyOK & APPLY_NOT_OK ) return ;
  QTabDialog::accept();
  qApp->quit();
}

void Sheet::Restart ( )
{
  char Command[ 1000 ] ;

  signal ( SIGHUP, SIG_IGN ) ;

  sprintf ( Command, "%s/Restart&", InstallPath.data() ) ;
  system ( Command ) ;
  sprintf ( Command, "%s/Shutdown -quiet &", InstallPath.data() ) ;
  system ( Command ) ;
}

// ### EOF ###
