#include <qlabel.h>
#include <qtabdialog.h>
#include <qfile.h>

#include "FireGLControl.h"


#include "watermark.xpm"
#define FGL_LATER
#include "buttons.xpm"
#undef FGL_LATER

#include "ATITVOExtensions.h"

extern "C" { 
    Bool ExtATITVOEnableDisable(int iOn);
    Bool ExtATITVOSetTVStd(int iTVStd);
    Bool ExtATITVOGetData(ATITVOGetDataPtr pATITVOGetData);
    Bool ExtATITVOAdjustSize(ATITVOExtAdjustSizePtr pATITVOExtAdjustSize);
    Bool ExtATITVOAdjustPosition(ATITVOAdjustPositionPtr pATITVOAdjustPosition);
    Bool ExtATITVOAdjustColor(int itvColorAdj);
    Bool ExtATITVOSetData(ATITVOGetDataPtr pATITVOGetData);
}

#define TVO_BORDER_HSIZELOW       -30
#define TVO_BORDER_HSIZEHIGH       30
#define TVO_BORDER_VSIZELOW        -6
#define TVO_BORDER_VSIZEHIGH        6
#define TVO_BORDER_HPOSLOW        -30
#define TVO_BORDER_HPOSHIGH        30
#define TVO_BORDER_VPOSLOW         -6
#define TVO_BORDER_VPOSHIGH         6
#define TVO_BORDER_HSTARTLOW      -30
#define TVO_BORDER_HSTARTHIGH      30
#define TVO_BORDER_COLORLOW         0
#define TVO_BORDER_COLORHIGH      255

#ifdef DEBUG_TVOUT
#define DEB(s)  s
#else
#define DEB(s)
#endif // DEBUG


#define BUTTON_PRESS_ADD_VALUE 2

TVoutAdjustPage::TVoutAdjustPage ( QWidget *parent ) : QWidget ( parent, (const char *)0 )
{
  m_Init = FALSE ;
}


#define POS_ADD 0
#define SIZE_ADD 157
#define START_ADD 295



void TVoutAdjustPage::Init ( )
{
  QPixmap     *pPix ;
  QPixmap      pixmap ( watermark ) ;
  QRadioButton *pNTSC, *pPAL, *pPALM, *pSCARTPAL, *pPALCN, *pPAL60 ;
  QString     Str ;
  QGroupBox   *pTVColorBox, *pTVOnBox;

  DEB(printf("Init\n"));

  ReadCurrentSettings ( ) ;
  setBackgroundPixmap ( pixmap ) ;

  // === On / Off ===
  pTVOnBox = new QGroupBox ( tr("TV On"), this ) ;
  pTVOnBox->setGeometry ( 160, 5, 280, 90 ) ;
  pTVOnBox->setAlignment ( AlignHCenter ) ;
  pTVOnBox->setBackgroundPixmap ( pixmap ) ;
  pTVOnBox->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pTVOn = new QCheckBox ( tr("On"), this ) ;
  pTVOn->setGeometry ( 280, 45, 25, 25 ) ;
  pTVOn->setAutoResize ( TRUE ) ;
  pTVOn->setFocusPolicy ( QWidget::StrongFocus ) ;
  pTVOn->setBackgroundPixmap ( pixmap ) ;
  pTVOn->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  pTVOn->setChecked((bool) m_TVConnect) ;

  pTVOnBox->show ( ) ;
  pTVOn->show ( ) ;
  connect ( pTVOn, SIGNAL(toggled(bool)), SLOT( OnTVOn(bool) ) ) ;

  // === TV Std ==
  pTVSTD = new QButtonGroup ( tr("TV Standard"), this ) ;
  pTVSTD->setGeometry ( 4, 5, 150, 180 ) ;
  pTVSTD->setBackgroundPixmap ( pixmap ) ;
  pTVSTD->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  pNTSC = new QRadioButton ( tr("NTSC"), pTVSTD ) ;
  pNTSC->setGeometry ( 18, 25, 100, 20 ) ;
  pNTSC->setAutoResize ( TRUE ) ;
  pNTSC->setFocusPolicy ( QWidget::StrongFocus ) ;
  pPAL = new QRadioButton ( tr("PAL"), pTVSTD ) ;
  pPAL->setGeometry ( 18, 50, 100, 20 ) ;
  pPAL->setAutoResize ( TRUE ) ;
  pPAL->setFocusPolicy ( QWidget::StrongFocus ) ;
  pPALM = new QRadioButton ( tr("PAL (monocolor)"), pTVSTD ) ;
  pPALM->setGeometry ( 18, 75, 100, 20 ) ;
  pPALM->setAutoResize ( TRUE ) ;
  pPALM->setFocusPolicy ( QWidget::StrongFocus ) ;
  pSCARTPAL = new QRadioButton ( tr("Scart PAL"), pTVSTD ) ;
  pSCARTPAL->setGeometry ( 18, 100, 100, 20 ) ;
  pSCARTPAL->setAutoResize ( TRUE ) ;
  pSCARTPAL->setFocusPolicy ( QWidget::StrongFocus ) ;
  pPALCN = new QRadioButton ( tr("PAL CN"), pTVSTD ) ;
  pPALCN->setGeometry ( 18, 125, 100, 20 ) ;
  pPALCN->setAutoResize ( TRUE ) ;
  pPALCN->setFocusPolicy ( QWidget::StrongFocus ) ;
  pPAL60 = new QRadioButton ( tr("PAL 60"), pTVSTD ) ;
  pPAL60->setGeometry ( 18, 150, 100, 20 ) ;
  pPAL60->setAutoResize ( TRUE ) ;
  pPAL60->setFocusPolicy ( QWidget::StrongFocus ) ;
  pTVSTD->show ( ) ;
  pTVSTD->setButton ( m_TVStd ) ;
  connect ( pTVSTD, SIGNAL(clicked(int)), SLOT( OnTVStd(int) ) ) ;

  // === Color Adj. ===
  pTVColorBox = new QGroupBox ( tr("TV Color"), this ) ;
  pTVColorBox->setGeometry ( 160, 95, 280, 90 ) ;
  pTVColorBox->setAlignment ( AlignHCenter ) ;
  pTVColorBox->setBackgroundPixmap ( pixmap ) ;
  pTVColorBox->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pSliderTVColor = new QSlider ( (int)(0), (int)(0xFF), 30, 100, QSlider::Horizontal, this) ;
  pSliderTVColor->setGeometry ( 175, 130, 190, 25 ) ;
  pSliderTVColor->setTickmarks ( (QSlider::TickSetting)2 ) ; //Below
  pSliderTVColor->setFocusPolicy ( QWidget::StrongFocus ) ;
  pSliderTVColor->setBackgroundPixmap ( pixmap ) ;
  pSliderTVColor->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pTextSliderTVColor = new QLabel ( "  0", this ) ;
  pTextSliderTVColor->setGeometry ( 385, 135, 20, 20 ) ;
  pTextSliderTVColor->setAutoResize ( TRUE ) ;
  pTextSliderTVColor->setBackgroundPixmap ( pixmap ) ;
  pTextSliderTVColor->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  connect ( pSliderTVColor, SIGNAL(valueChanged(int)), SLOT(OnSliderTVColor(int) ) ) ;


  pTVColorBox->show ( ) ;
  pSliderTVColor->show() ;
  pSliderTVColor->setValue ( (int)(m_tvColorAdj) ) ;
  Str.sprintf ( "%3d", m_tvColorAdj ) ;
  pTextSliderTVColor->setText ( Str ) ;
  pTextSliderTVColor->show ( ) ;


  // === Position ===
  pTVPosition = new QButtonGroup ( tr("TV Position"), this ) ;
  pTVPosition->setGeometry ( 4, 188, 142, 155 ) ;
  pTVPosition->setAlignment ( AlignHCenter ) ;
  pTVPosition->setBackgroundPixmap ( pixmap ) ;
  pTVPosition->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  pTVLeft = new QPushButton ( tr("left"), this ) ;
  pTVLeft->setGeometry ( 32, 248, 25, 25 ) ;
  pPix = new QPixmap ( pix_left ) ;
  pTVLeft->setPixmap ( *pPix ) ;
  pTVLeft->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTVRight = new QPushButton ( tr("right"), this ) ;
  pTVRight->setGeometry ( 86, 248, 25, 25 ) ;
  pPix = new QPixmap ( pix_right ) ;
  pTVRight->setPixmap ( *pPix ) ;
  pTVRight->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTextPosH = new QLabel ( "H   0", this ) ;
  pTextPosH->setGeometry ( 24, 320, 20, 20 ) ;
  pTextPosH->setAutoResize ( TRUE ) ;
  pTextPosH->setBackgroundPixmap ( pixmap ) ;
  pTextPosH->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  Str.sprintf ( "H %3d", m_tvHPosAdj ) ;
  pTextPosH->setText ( Str ) ;
  pTextPosH->show ( ) ;

  pTVUp = new QPushButton ( tr("up"), this ) ;
  pTVUp->setGeometry ( 58, 220, 25, 25 ) ;
  pPix = new QPixmap ( pix_up ) ;
  pTVUp->setPixmap ( *pPix ) ;
  pTVUp->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTVDown = new QPushButton ( tr("down"), this ) ;
  pTVDown->setGeometry ( 58, 276, 25, 25 ) ;
  pPix = new QPixmap ( pix_down ) ;
  pTVDown->setPixmap ( *pPix ) ;
  pTVDown->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTextPosV = new QLabel ( "   0", this ) ;
  pTextPosV->setGeometry ( 94, 320, 20, 20 ) ;
  pTextPosV->setAutoResize ( TRUE ) ;
  pTextPosV->setBackgroundPixmap ( pixmap ) ;
  pTextPosV->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  Str.sprintf ( "V %3d", m_tvVPosAdj ) ;
  pTextPosV->setText ( Str ) ;
  pTextPosV->show ( ) ;

  pTVPosition->show() ;
  pTVLeft->show() ;
  connect ( pTVLeft, SIGNAL(clicked()), SLOT( OnTVPosLeft() ) ) ;
  pTVRight->show() ;
  connect ( pTVRight, SIGNAL(clicked()), SLOT( OnTVPosRight() ) ) ;
  pTVUp->show() ;
  connect ( pTVUp, SIGNAL(clicked()), SLOT( OnTVPosUp() ) ) ;
  pTVDown->show() ;
  connect ( pTVDown, SIGNAL(clicked()), SLOT( OnTVPosDown() ) ) ;

  // === Size ===
  pTVSize = new QButtonGroup ( tr("TV Size"), this ) ;
  pTVSize->setGeometry ( 150, 188, 142, 155 ) ;
  pTVSize->setAlignment ( AlignHCenter ) ;
  pTVSize->setBackgroundPixmap ( pixmap ) ;
  pTVSize->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pTVWider = new QPushButton ( tr("wider"), this ) ;
  pTVWider->setGeometry ( (32+SIZE_ADD), 248, 25, 25 ) ;
  pPix = new QPixmap ( pix_wider ) ;
  pTVWider->setPixmap ( *pPix ) ;
  pTVWider->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTVSmaler = new QPushButton ( tr("smaler"), this ) ;
  pTVSmaler->setGeometry ( (86+SIZE_ADD), 248, 25, 25 ) ;
  pPix = new QPixmap ( pix_smaler ) ;
  pTVSmaler->setPixmap ( *pPix ) ;
  pTVSmaler->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTextSizeH = new QLabel ( "H   0", this ) ;
  pTextSizeH->setGeometry ( 170, 320, 20, 20 ) ;
  pTextSizeH->setAutoResize ( TRUE ) ;
  pTextSizeH->setBackgroundPixmap ( pixmap ) ;
  pTextSizeH->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  Str.sprintf ( "H %3d", m_tvHSizeAdj ) ;
  pTextSizeH->setText ( Str ) ;
  pTextSizeH->show ( ) ;

  pTVHigher = new QPushButton ( tr("higher"), this ) ;
  pTVHigher->setGeometry ( (58+SIZE_ADD), 220, 25, 25 ) ;
  pPix = new QPixmap ( pix_higher ) ;
  pTVHigher->setPixmap ( *pPix ) ;
  pTVHigher->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTVLower = new QPushButton ( tr("lower"), this ) ;
  pTVLower->setGeometry ( (58+SIZE_ADD), 276, 25, 25 ) ;
  pPix = new QPixmap ( pix_lower ) ;
  pTVLower->setPixmap ( *pPix ) ;
  pTVLower->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTextSizeV = new QLabel ( "H   0", this ) ;
  pTextSizeV->setGeometry ( 240, 320, 20, 20 ) ;
  pTextSizeV->setAutoResize ( TRUE ) ;
  pTextSizeV->setBackgroundPixmap ( pixmap ) ;
  pTextSizeV->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  Str.sprintf ( "V %3d", m_tvVSizeAdj ) ;
  pTextSizeV->setText ( Str ) ;
  pTextSizeV->show ( ) ;

  pTVSize->show() ;
  pTVWider->show() ;
  connect ( pTVWider, SIGNAL(clicked()), SLOT( OnTVSizeWider() ) ) ;
  pTVSmaler->show() ;
  connect ( pTVSmaler, SIGNAL(clicked()), SLOT( OnTVSizeSmaler() ) ) ;
  pTVHigher->show() ;
  connect ( pTVHigher, SIGNAL(clicked()), SLOT( OnTVSizeHigher() ) ) ;
  pTVLower->show() ;
  connect ( pTVLower, SIGNAL(clicked()), SLOT( OnTVSizeLower() ) ) ;


  // === Start ===

  pTVStart = new QButtonGroup ( tr("TV Start"), this ) ;
  pTVStart->setGeometry ( 296, 188, 143, 155 ) ;
  pTVStart->setAlignment ( AlignHCenter ) ;
  pTVStart->setBackgroundPixmap ( pixmap ) ;
  pTVStart->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pTVStartLeft = new QPushButton ( tr("startleft"), this ) ;
  pTVStartLeft->setGeometry ( (32+START_ADD), 248, 25, 25 ) ;
  pPix = new QPixmap ( pix_left ) ;
  pTVStartLeft->setPixmap ( *pPix ) ;
  pTVStartLeft->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTVStartRight = new QPushButton ( tr("startright"), this ) ;
  pTVStartRight->setGeometry ( (86+START_ADD), 248, 25, 25 ) ;
  pPix = new QPixmap ( pix_right ) ;
  pTVStartRight->setPixmap ( *pPix ) ;
  pTVStartRight->setFocusPolicy ( QWidget::StrongFocus ) ;

  pTextStartH = new QLabel ( "H   0", this ) ;
  pTextStartH->setGeometry ( 316, 320, 20, 20 ) ;
  pTextStartH->setAutoResize ( TRUE ) ;
  pTextStartH->setBackgroundPixmap ( pixmap ) ;
  pTextStartH->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  Str.sprintf ( "H %3d", m_tvHStartAdj ) ;
  pTextStartH->setText ( Str ) ;
  pTextStartH->show ( ) ;

  pTVStart->show() ;
  pTVStartLeft->show() ;
  connect ( pTVStartLeft, SIGNAL(clicked()), SLOT( OnTVStartLeft() ) ) ;
  pTVStartRight->show() ;
  connect ( pTVStartRight, SIGNAL(clicked()), SLOT( OnTVStartRight() ) ) ;

  pTextInfo = new QLabel ( "FireGL          ", this ) ;
  pTextInfo->setGeometry ( 24, 355, 20, 20 ) ;
  pTextInfo->setAutoResize ( TRUE ) ;
  pTextInfo->setBackgroundPixmap ( pixmap ) ;
  pTextInfo->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  Str.sprintf ( "        ") ;
  pTextInfo->setText ( Str ) ;
  pTextInfo->show ( ) ;


}

void TVoutAdjustPage::ReadCurrentSettings ( )
{
  ATITVOGetDataRec TVData;

  DEB(printf("[ReadCurrentSettings] \n"));
  ExtATITVOGetData(&TVData);
  m_TVConnect   = TVData.TVConnected;
  m_TVStd       = TVData.TVStd;      
  m_MVMode      = TVData.MVMode;     
  m_tvHSizeAdj  = TVData.tvHSizeAdj; 
  m_tvVSizeAdj  = TVData.tvVSizeAdj; 
  m_tvHPosAdj   = TVData.tvHPosAdj;  
  m_tvVPosAdj   = TVData.tvVPosAdj;  
  m_tvHStartAdj = TVData.tvHStartAdj;
  m_tvColorAdj  = TVData.tvColorAdj;
  m_CurrentTVConnect   = TVData.TVConnected;
  m_CurrentTVStd       = TVData.TVStd;
  m_CurrentMVMode      = TVData.MVMode;
  m_CurrenttvHSizeAdj  = TVData.tvHSizeAdj;
  m_CurrenttvVSizeAdj  = TVData.tvVSizeAdj;
  m_CurrenttvHPosAdj   = TVData.tvHPosAdj;
  m_CurrenttvVPosAdj   = TVData.tvVPosAdj;
  m_CurrenttvHStartAdj = TVData.tvHStartAdj;
  m_CurrenttvColorAdj  = TVData.tvColorAdj;

  DEB(printf("m_TVConnect   %d \n", m_TVConnect  ));
  DEB(printf("m_TVStd       %d \n", m_TVStd      ));
  DEB(printf("m_MVMode      %d \n", m_MVMode     ));
  DEB(printf("m_tvHSizeAdj  %d \n", m_tvHSizeAdj ));
  DEB(printf("m_tvVSizeAdj  %d \n", m_tvVSizeAdj ));
  DEB(printf("m_tvHPosAdj   %d \n", m_tvHPosAdj  ));
  DEB(printf("m_tvVPosAdj   %d \n", m_tvVPosAdj   ));
  DEB(printf("m_tvHStartAdj %d \n", m_tvHStartAdj ));
  DEB(printf("m_tvColorAdj  %d \n", m_tvColorAdj  ));

}

void TVoutAdjustPage::OnTVStd ( int std )
{
  m_TVOStdChanged = TRUE ;
  m_TVStd = std ;
  DEB(printf("[OnTVStd] m_TVStd %d\n",m_TVStd));
  ExtATITVOSetTVStd(m_TVStd);
}

void TVoutAdjustPage::OnTVOn ( bool on )
{
  m_TVOOnOffChanged = TRUE ;
  m_TVConnect = (int)on ;
  DEB(printf("[OnTVOn] m_TVConnect %d\n",m_TVConnect));
  ExtATITVOEnableDisable(m_TVConnect);
}

void TVoutAdjustPage::OnTVPosLeft (void)
{
  QString Str ;
  ATITVOAdjustPositionRec Pos;

  m_TVOAdjPosChanged = TRUE ;
  m_tvHPosAdj -=BUTTON_PRESS_ADD_VALUE;
  if (m_tvHPosAdj < TVO_BORDER_HPOSLOW) {
    m_tvHPosAdj +=BUTTON_PRESS_ADD_VALUE;
    Str.sprintf ( "Bounds! ") ;
    pTextInfo->setText ( Str ) ;
  } else {
    DEB(printf("[OnTVPosLeft] m_tvHPosAdj %d\n",m_tvHPosAdj));
    Pos.tvHPosAdj =      m_tvHPosAdj;
    Pos.tvVPosAdj =      m_tvVPosAdj;
    Pos.tvHStartAdj =    m_tvHStartAdj;
    Str.sprintf ( "H %3d", m_tvHPosAdj ) ;
    pTextPosH->setText ( Str ) ;
    ExtATITVOAdjustPosition(&Pos);
    Str.sprintf ( "       ") ;
    pTextInfo->setText ( Str ) ;
  }
}

void TVoutAdjustPage::OnTVPosRight (void)
{
  QString Str ;
  ATITVOAdjustPositionRec Pos;

  m_TVOAdjPosChanged = TRUE ;
  m_tvHPosAdj += BUTTON_PRESS_ADD_VALUE;
  if (m_tvHPosAdj > TVO_BORDER_HPOSHIGH) {
    m_tvHPosAdj -=BUTTON_PRESS_ADD_VALUE;
    Str.sprintf ( "Bounds! ") ;
    pTextInfo->setText ( Str ) ;
  } else {
    DEB(printf("[OnTVPosRight] m_tvHPosAdj %d\n",m_tvHPosAdj));
    Pos.tvHPosAdj =      m_tvHPosAdj;
    Pos.tvVPosAdj =      m_tvVPosAdj;
    Pos.tvHStartAdj =    m_tvHStartAdj;
    Str.sprintf ( "H %3d", m_tvHPosAdj ) ;
    pTextPosH->setText ( Str ) ;
    ExtATITVOAdjustPosition(&Pos);
    Str.sprintf ( "       ") ;
    pTextInfo->setText ( Str ) ;
  }
}

void TVoutAdjustPage::OnTVPosUp (void)
{
  QString Str ;
  ATITVOAdjustPositionRec Pos;

  m_TVOAdjPosChanged = TRUE ;
  m_tvVPosAdj -= BUTTON_PRESS_ADD_VALUE;  
  if (m_tvVPosAdj < TVO_BORDER_VPOSLOW) {
    m_tvVPosAdj +=BUTTON_PRESS_ADD_VALUE;
    Str.sprintf ( "Bounds! ") ;
    pTextInfo->setText ( Str ) ;
  } else {
    DEB(printf("[OnTVPosUp] m_tvVPosAdj %d\n",m_tvVPosAdj));
    Pos.tvHPosAdj =      m_tvHPosAdj;
    Pos.tvVPosAdj =      m_tvVPosAdj;
    Pos.tvHStartAdj =    m_tvHStartAdj;
    Str.sprintf ( "V %3d", m_tvVPosAdj ) ;
    pTextPosV->setText ( Str ) ;
    ExtATITVOAdjustPosition(&Pos);
    Str.sprintf ( "       ") ;
    pTextInfo->setText ( Str ) ;
  }
}

void TVoutAdjustPage::OnTVPosDown (void)
{
  QString Str ;
  ATITVOAdjustPositionRec Pos;

  m_TVOAdjPosChanged = TRUE ;
  m_tvVPosAdj += BUTTON_PRESS_ADD_VALUE;  
  if (m_tvVPosAdj > TVO_BORDER_VPOSHIGH) {
    m_tvVPosAdj -=BUTTON_PRESS_ADD_VALUE;
    Str.sprintf ( "Bounds! ") ;
    pTextInfo->setText ( Str ) ;
  } else {
    DEB(printf("[OnTVPosDown] m_tvVPosAdj %d\n",m_tvVPosAdj));
    Pos.tvHPosAdj =      m_tvHPosAdj;
    Pos.tvVPosAdj =      m_tvVPosAdj;
    Pos.tvHStartAdj =    m_tvHStartAdj;
    Str.sprintf ( "V %3d", m_tvVPosAdj ) ;
    pTextPosV->setText ( Str ) ;
    ExtATITVOAdjustPosition(&Pos);
    Str.sprintf ( "       ") ;
    pTextInfo->setText ( Str ) ;
  }
}

void TVoutAdjustPage::OnTVStartLeft (void)
{
  QString Str ;
  ATITVOAdjustPositionRec Pos;

  m_TVOAdjPosChanged = TRUE ;
  m_tvHStartAdj -= BUTTON_PRESS_ADD_VALUE;
  if (m_tvHStartAdj < TVO_BORDER_HSTARTLOW) {
    m_tvHStartAdj +=BUTTON_PRESS_ADD_VALUE;
    Str.sprintf ( "Bounds! ") ;
    pTextInfo->setText ( Str ) ;
  } else {
    DEB(printf("[OnTVStartLeft] m_tvHStartAdj %d\n",m_tvHStartAdj));
    Pos.tvHPosAdj =      m_tvHPosAdj;
    Pos.tvVPosAdj =      m_tvVPosAdj;
    Pos.tvHStartAdj =    m_tvHStartAdj;
    Str.sprintf ( "H %3d", m_tvHStartAdj ) ;
    pTextStartH->setText ( Str ) ;
    ExtATITVOAdjustPosition(&Pos);
    Str.sprintf ( "       ") ;
    pTextInfo->setText ( Str ) ;
  }
}
void TVoutAdjustPage::OnTVStartRight (void)
{
  QString Str ;
  ATITVOAdjustPositionRec Pos;

  m_TVOAdjPosChanged = TRUE ;
  m_tvHStartAdj += BUTTON_PRESS_ADD_VALUE;  
  if (m_tvHStartAdj > TVO_BORDER_HSTARTHIGH) {
    m_tvHStartAdj -=BUTTON_PRESS_ADD_VALUE;
    Str.sprintf ( "Bounds! ") ;
    pTextInfo->setText ( Str ) ;
  } else {
    DEB(printf("[OnTVStartRight] m_tvHStartAdj %d\n",m_tvHStartAdj));
    Pos.tvHPosAdj =      m_tvHPosAdj;
    Pos.tvVPosAdj =      m_tvVPosAdj;
    Pos.tvHStartAdj =    m_tvHStartAdj;
    Str.sprintf ( "H %3d", m_tvHStartAdj ) ;
    pTextStartH->setText ( Str ) ;
    ExtATITVOAdjustPosition(&Pos);
    Str.sprintf ( "       ") ;
    pTextInfo->setText ( Str ) ;
  }
}


void TVoutAdjustPage::OnTVSizeWider(void)
{
  QString Str ;
  ATITVOExtAdjustSizeRec Size;

  m_TVOAdjSizeChanged = TRUE ;
  m_tvHSizeAdj += BUTTON_PRESS_ADD_VALUE;  
  DEB(printf("[OnTVSizeWider] m_tvHSizeAdj %d\n",m_tvHSizeAdj));
  Size.tvHSizeAdj =      m_tvHSizeAdj;
  Size.tvVSizeAdj =      m_tvVSizeAdj;
  Str.sprintf ( "H %3d", m_tvHSizeAdj ) ;
  pTextSizeH->setText ( Str ) ;
  ExtATITVOAdjustSize(&Size);
}

void TVoutAdjustPage::OnTVSizeSmaler(void)
{
  QString Str ;
  ATITVOExtAdjustSizeRec Size;

  m_TVOAdjSizeChanged = TRUE ;
  m_tvHSizeAdj -= BUTTON_PRESS_ADD_VALUE;  
  DEB(printf("[OnTVSizeSmaler] m_tvHSizeAdj %d\n",m_tvHSizeAdj));
  Size.tvHSizeAdj =      m_tvHSizeAdj;
  Size.tvVSizeAdj =      m_tvVSizeAdj;
  Str.sprintf ( "H %3d", m_tvHSizeAdj ) ;
  pTextSizeH->setText ( Str ) ;
  ExtATITVOAdjustSize(&Size);
}

void TVoutAdjustPage::OnTVSizeHigher(void)
{
  QString Str ;
  ATITVOExtAdjustSizeRec Size;

  m_TVOAdjSizeChanged = TRUE ;
  m_tvVSizeAdj += BUTTON_PRESS_ADD_VALUE;  
  DEB(printf("[OnTVSizeHigher] m_tvVSizeAdj %d\n",m_tvVSizeAdj));
  Size.tvHSizeAdj =      m_tvHSizeAdj;
  Size.tvVSizeAdj =      m_tvVSizeAdj;
  Str.sprintf ( "V %3d", m_tvVSizeAdj ) ;
  pTextSizeV->setText ( Str ) ;
  ExtATITVOAdjustSize(&Size);
}

void TVoutAdjustPage::OnTVSizeLower(void)
{
  QString Str ;
  ATITVOExtAdjustSizeRec Size;

  m_TVOAdjSizeChanged = TRUE ;
  m_tvVSizeAdj -= BUTTON_PRESS_ADD_VALUE;  
  DEB(printf("[OnTVSizeLower] m_tvVSizeAdj %d\n",m_tvVSizeAdj));
  Size.tvHSizeAdj =      m_tvHSizeAdj;
  Size.tvVSizeAdj =      m_tvVSizeAdj;
  Str.sprintf ( "V %3d", m_tvVSizeAdj ) ;
  pTextSizeV->setText ( Str ) ;
  ExtATITVOAdjustSize(&Size);
}

void TVoutAdjustPage::OnSliderTVColor ( int Value )
{
    QString Str ;

    if ((Value >= 0) && (Value <= 0xFF)) {
        m_TVOAdjColorChanged = TRUE ;
        m_tvColorAdj = Value;
        DEB(printf("[OnSliderTVColor], m_tvColorAdj %d\n", m_tvColorAdj));
        Str.sprintf ( "%3d", m_tvColorAdj ) ;
        pTextSliderTVColor->setText ( Str ) ;
        ExtATITVOAdjustColor(m_tvColorAdj);
    }
}


void TVoutAdjustPage::OnActivate ( int nPage )
{
  if ( nPage != ATITVO_PAGE ) return ;
  if ( m_Init ) return ;
  Init ( ) ;
  m_Init = TRUE ;
}

void TVoutAdjustPage::OnApply ( int *Accept )
{
  ATITVOGetDataRec TVData;

  if ( !m_Init ) return ;
  TVData.TVConnected =   m_TVConnect;
  TVData.TVStd       =   m_TVStd;
  TVData.MVMode      =   m_MVMode;
  TVData.tvHSizeAdj  =   m_tvHSizeAdj;
  TVData.tvVSizeAdj  =   m_tvVSizeAdj;
  TVData.tvHPosAdj   =   m_tvHPosAdj;
  TVData.tvVPosAdj   =   m_tvVPosAdj;
  TVData.tvHStartAdj =   m_tvHStartAdj;
  TVData.tvColorAdj  =   m_tvColorAdj; 

  m_CurrentTVConnect   = TVData.TVConnected;
  m_CurrentTVStd       = TVData.TVStd;
  m_CurrentMVMode      = TVData.MVMode;
  m_CurrenttvHSizeAdj  = TVData.tvHSizeAdj;
  m_CurrenttvVSizeAdj  = TVData.tvVSizeAdj;
  m_CurrenttvHPosAdj   = TVData.tvHPosAdj;
  m_CurrenttvVPosAdj   = TVData.tvVPosAdj;
  m_CurrenttvHStartAdj = TVData.tvHStartAdj;
  m_CurrenttvColorAdj  = TVData.tvColorAdj;

  m_TVOStdChanged = FALSE;
  m_TVOOnOffChanged = FALSE;
  m_TVOAdjSizeChanged = FALSE ;
  m_TVOAdjPosChanged = FALSE;
  m_TVOAdjColorChanged = FALSE;

  *Accept |= APPLY_OK ;
}

void TVoutAdjustPage::OnCancel ( )
{
    ATITVOExtAdjustSizeRec Size;
    ATITVOAdjustPositionRec Pos;
    QString Str ;

    DEB(printf("[OnCancel] \n"));
    if (m_TVOStdChanged) {
        DEB(printf("[OnCancel] m_TVStd %d back to %d\n", m_TVStd, m_CurrentTVStd));
        m_TVStd = m_CurrentTVStd;
        ExtATITVOSetTVStd(m_TVStd);
        m_TVOStdChanged = FALSE;
    }

    if (m_TVOOnOffChanged) {
        m_TVConnect = m_CurrentTVConnect;
        ExtATITVOEnableDisable(m_TVConnect);
        m_TVOOnOffChanged = FALSE;
    }

    if (m_TVOAdjSizeChanged) {
        m_tvHSizeAdj = m_CurrenttvHSizeAdj;
        m_tvVSizeAdj = m_CurrenttvVSizeAdj;
        Size.tvHSizeAdj = m_tvHSizeAdj;
        Size.tvVSizeAdj = m_tvVSizeAdj;
        ExtATITVOAdjustSize(&Size);
        m_TVOAdjSizeChanged = FALSE;
    }
    if (m_TVOAdjPosChanged) {
        m_tvHPosAdj   = m_CurrenttvHPosAdj;
        m_tvVPosAdj   = m_CurrenttvVPosAdj;
        m_tvHStartAdj = m_CurrenttvHStartAdj;
        Pos.tvHPosAdj = m_tvHPosAdj;
        Pos.tvVPosAdj = m_tvVPosAdj;
        Pos.tvHStartAdj =  m_tvHStartAdj;
        ExtATITVOAdjustPosition(&Pos);
        m_TVOAdjPosChanged = FALSE;
    }
    if (m_TVOAdjColorChanged) {
        m_tvColorAdj = m_CurrenttvColorAdj;
        ExtATITVOAdjustColor(m_tvColorAdj);
        m_TVOAdjColorChanged = FALSE;
    }
    if ( !m_Init ) return ;
}

