/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  AFILE *AFsetWrite (FILE *fp, int Ftype, int Format, int Swapb, double Sfreq,
                     double ScaleF, long int Nchan)

Purpose:
  Set up the parameters in an audio file structure for wrinting

Description:
  This routine checks the input parameters and puts them into a new audio file
  structure.

Parameters:
  <-  AFILE *AFsetWrite
      Audio file pointer for the audio file.  This routine allocates the space
      for this structure.
   -> FILE *fp
      File pointer for the audio file
   -> int Ftype
      File type; FT_NH, FT_AU, FT_WAVE, etc.
   -> int Format
      Data format; FD_MULAW8, FD_ALAW8, FD_UINT8, FD_INT8, FD_INT16,
      FD_FLOAT32, FD_FLOAT64, or FD_TEXT
   -> int Swabp
      Byte swap flag:
      DS_EB     - File data is in big-endian byte order
      DS_EL     - FIle data is in little-endian byte order
      DS_NATIVE - File data is in native byte order
      DS_SWAP   - File data is byte-swapped
   -> double Sfreq
      Sampling rate
   -> double ScaleF
      Scale factor applied to the data
   -> long int Nchan
      Number of interleaved channels

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.27 $  $Date: 1998/06/13 02:05:17 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFsetWrite.c 1.27 1998/06/13 libtsp-v3r0 $";

#include <assert.h>

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFdataio.h>
#include <libtsp/AFheader.h>
#include <libtsp/AFmsg.h>
#define AF_DATA_LENGTHS
#include <libtsp/AFpar.h>


AFILE *
AFsetWrite (fp, Ftype, Format, Swapb, Sfreq, ScaleF, Nchan)

     FILE *fp;
     int Ftype;
     int Format;
     int Swapb;
     double Sfreq;
     double ScaleF;
     long int Nchan;

{
  AFILE *AFp;
  long int Start;
  int ErrCode;
  static const struct AF_info NullInfo = {NULL, 0};

  assert (Ftype > 0 && Ftype < NFT);
  assert (Format > 0 && Format < NFD);
  assert (Nchan > 0L);

/* Warnings */
  if (Sfreq <= 0.0)
    UTwarn ("AFsetWrite - %s", AFM_NPSFreq);

/* Swap code */
  if (AF_DL[Format] <= 1)
    Swapb = DS_NATIVE;
  else
    Swapb = UTswapCode (Swapb);

/* Set the start of data */
  if (FLseekable (fp)) {
    ErrCode = 0;
    Start = AFtell (fp, &ErrCode);
    if (ErrCode)
      return NULL;
  }
  else
    Start = 0L;

/* Set the parameters for file access */
  AFp = (AFILE *) UTmalloc (sizeof (AFILE));
  AFp->fp = fp;
  AFp->Op = FO_WO;
  AFp->Error = 0;
  AFp->Ftype = Ftype;
  AFp->Format = Format;
  AFp->Swapb = Swapb;
  AFp->Sfreq = Sfreq;
  AFp->ScaleF = ScaleF;
  AFp->Nchan = Nchan;
  AFp->Start = Start;
  AFp->Isamp = 0L;
  AFp->Nsamp = 0L;
  AFp->Novld = 0L;
  AFp->Hinfo = NullInfo;

  return AFp;
}
