/*****************************************************************************
 * Copyright (c) 2014-2025 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#include "SurfaceData.h"

#include "tile_element/Slope.h"

using namespace OpenRCT2;

// 0x00981A1E
// Table of pre-calculated surface slopes (32) when raising the land tile for a given selection (5)
// 0x1F = new slope
// 0x20 = base height increases
constexpr uint8_t kTileElementRaiseStyles[9][32] = {
    // MapSelectType::corner0
    { kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::corner1
    { kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::corner2
    { kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::corner3
    { kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::full
    { kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight },
    // MapSelectType::edge0
    { kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::edge1
    { kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::edge2
    { kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp },
    // MapSelectType::edge3
    { kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp },

};

// 0x00981ABE
// Basically the inverse of the table above.
// 0x1F = new slope
// 0x20 = base height increases
constexpr uint8_t kTileElementLowerStyles[9][32] = {
    // MapSelectType::corner0
    { kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      0,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::corner1
    { kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      0,
      kTileSlopeNCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::corner2
    { kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeWCornerUp,
      0,
      kTileSlopeNCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::corner3
    { kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeSCornerUp,
      0,
      kTileSlopeNCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp
          | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeDiagonalFlag | kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::full
    { kTileSlopeRaiseOrLowerBaseHeight,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      0,
      0,
      0,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      0,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      0 },
    // MapSelectType::edge0
    { kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      0,
      kTileSlopeNCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      0,
      kTileSlopeNCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      0,
      kTileSlopeNCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeECornerUp,
      0,
      kTileSlopeNCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      0,
      kTileSlopeNCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp,
      0,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp },
    // MapSelectType::edge1
    { kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      0,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      0,
      0,
      kTileSlopeECornerUp,
      kTileSlopeECornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      0,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      0,
      0,
      kTileSlopeECornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp },
    // MapSelectType::edge2
    { kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      0,
      0,
      0,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      0,
      0,
      0,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeSCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeSCornerUp | kTileSlopeWCornerUp },
    // MapSelectType::edge3
    { kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      0,
      kTileSlopeNCornerUp,
      0,
      kTileSlopeNCornerUp,
      0,
      kTileSlopeNCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      0,
      kTileSlopeNCornerUp,
      0,
      kTileSlopeNCornerUp,
      0,
      kTileSlopeNCornerUp | kTileSlopeECornerUp | kTileSlopeSCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeRaiseOrLowerBaseHeight | kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp,
      kTileSlopeECornerUp | kTileSlopeSCornerUp | kTileSlopeWCornerUp,
      kTileSlopeNCornerUp | kTileSlopeWCornerUp },
};

uint8_t LowerSurfaceCornerFlags(size_t SelectedCorner, size_t CurrentSlope)
{
    return kTileElementLowerStyles[SelectedCorner][CurrentSlope];
}

uint8_t RaiseSurfaceCornerFlags(size_t SelectedCorner, size_t CurrentSlope)
{
    return kTileElementRaiseStyles[SelectedCorner][CurrentSlope];
}
