/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxcoo
 * Create date:	2004-03-06 16:03
 */

#include "blist.h"
#include "binteger.h"
#include "bstring.h"
#include "bdict.h"


int
CBList::parse (const char *buf, unsigned long bufLen)
{
  int result = -1;
  if (buf[0] == 'l')
    {
      unsigned long index = 1;
      for (; index < bufLen;)
	{
	  if (buf[index] == 'i')
	    {
	      CBInteger *bint = new CBInteger;
	      int ret = bint->parse (&buf[index], bufLen - index - 1);
	      if (ret > 0)
		{
		  m_value.push_back (bint);
		  index += ret;
		}
	      else
		{
		  delete bint;
		  break;
		}
	    }
	  else if (isdigit (buf[index]))
	    {
	      CBString *bstr = new CBString;
	      int ret = bstr->parse (&buf[index], bufLen - index - 1);
	      if (ret > 0)
		{
		  m_value.push_back (bstr);
		  index += ret;
		}
	      else
		{
		  delete bstr;
		  break;
		}
	    }
	  else if (buf[index] == 'l')
	    {
	      CBList *blist = new CBList;
	      int ret = blist->parse (&buf[index], bufLen - index - 1);
	      if (ret > 0)
		{
		  m_value.push_back (blist);
		  index += ret;
		}
	      else
		{
		  delete blist;
		  break;
		}
	    }
	  else if (buf[index] == 'd')
	    {
	      CBDict *bdict = new CBDict;
	      int ret = bdict->parse (&buf[index], bufLen - index - 1);
	      if (ret > 0)
		{
		  m_value.push_back (bdict);
		  index += ret;
		}
	      else
		{
		  delete bdict;
		  break;
		}
	    }
	  else if (buf[index] == 'e')
	    {
	      result = index + 1;
	      break;
	    }
	  else
	    {
	      break;
	    }
	}
    }
  if (result == -1)
    {
      clear ();
    }
  return result;
};
