from collections import OrderedDict

from .. import Provider as PersonProvider


class Provider(PersonProvider):
    formats_female = OrderedDict(
        (
            ("{{first_name_female}} {{last_name_female}}", 0.97),
            ("{{prefix_female}} {{first_name_female}} {{last_name_female}}", 0.015),
            ("{{first_name_female}} {{last_name_female}} {{suffix}}", 0.02),
            (
                "{{prefix_female}} {{first_name_female}} {{last_name_female}} {{suffix}}",
                0.005,
            ),
        )
    )

    formats_male = OrderedDict(
        (
            ("{{first_name_male}} {{last_name_male}}", 0.97),
            ("{{prefix_male}} {{first_name_male}} {{last_name_male}}", 0.015),
            ("{{first_name_male}} {{last_name_male}} {{suffix}}", 0.02),
            (
                "{{prefix_male}} {{first_name_male}} {{last_name_male}} {{suffix}}",
                0.005,
            ),
        )
    )

    formats = formats_male.copy()
    formats.update(formats_female)

    # Names from
    # https://sk.wikipedia.org/wiki/Kategória:Krstné_mená

    first_names_male = (
        "Adam",
        "Adolf",
        "Adrián",
        "Alan",
        "Albert",
        "Albín",
        "Aleš",
        "Alex",
        "Alexander",
        "Alexej",
        "Alfonz",
        "Alfréd",
        "Alojz",
        "Ambróz",
        "Andrej",
        "Anton",
        "Ariel",
        "Arnold",
        "Áron",
        "Arpád",
        "Atila",
        "Augustín",
        "Aurel",
        "Bartolomej",
        "Belo",
        "Beňadik",
        "Benedikt",
        "Benjamín",
        "Bernard",
        "Blahoslav",
        "Blažej",
        "Bohdan",
        "Bohumil",
        "Bohumír",
        "Bohuslav",
        "Bohuš",
        "Boleslav",
        "Bonifác",
        "Boris",
        "Branislav",
        "Bruno",
        "Bystrík",
        "Ctibor",
        "Cyprián",
        "Cyril",
        "Dalibor",
        "Daniel",
        "Dávid",
        "Demeter",
        "Denis",
        "Dezider",
        "Dionýz",
        "Dobroslav",
        "Dominik",
        "Drahomír",
        "Drahoslav",
        "Dušan",
        "Eder",
        "Edmund",
        "Eduard",
        "Eliáš",
        "Emanuel",
        "Emil",
        "Erik",
        "Ernest",
        "Ervín",
        "Eugen",
        "Fedor",
        "Félix",
        "Ferdinand",
        "Filip",
        "Florián",
        "František",
        "Frederik",
        "Fridrich",
        "Gabriel",
        "Gašpar",
        "Gejza",
        "Gregor",
        "Gustáv",
        "Henrich",
        "Herbert",
        "Hubert",
        "Hugo",
        "Ignác",
        "Igor",
        "Iľja",
        "Imrich",
        "Ivan",
        "Izidor",
        "Jakub",
        "Ján",
        "Jarolím",
        "Jaromír",
        "Jaroslav",
        "Jerguš",
        "Jonáš",
        "Jozef",
        "Július",
        "Juraj",
        "Kamil",
        "Karol",
        "Kazimír",
        "Klement",
        "Kliment",
        "Koloman",
        "Konštantín",
        "Kornel",
        "Kristián",
        "Krištof",
        "Kvetoslav",
        "Ladislav",
        "Leonard",
        "Leopold",
        "Levoslav",
        "Libor",
        "Ľubomír",
        "Ľubor",
        "Ľuboslav",
        "Ľuboš",
        "Ludolf",
        "Ľudomil",
        "Ľudovít",
        "Lukáš",
        "Marcel",
        "Marek",
        "Marián",
        "Mário",
        "Maroš",
        "Martin",
        "Matej",
        "Matúš",
        "Maximilián",
        "Medard",
        "Melichar",
        "Metod",
        "Michal",
        "Mikuláš",
        "Milan",
        "Miloslav",
        "Miloš",
        "Miroslav",
        "Mojmír",
        "Móric",
        "Nathan",
        "Norbert",
        "Oldrich",
        "Oliver",
        "Ondrej",
        "Oskár",
        "Oto",
        "Pankrác",
        "Patrik",
        "Pavol",
        "Peter",
        "Pravoslav",
        "Prokop",
        "Radomír",
        "Radoslav",
        "Radovan",
        "Radúz",
        "Rastislav",
        "René",
        "Richard",
        "Róbert",
        "Roland",
        "Roman",
        "Rudolf",
        "Samuel",
        "Sebastián",
        "Sergej",
        "Servác",
        "Severín",
        "Silvester",
        "Slavomír",
        "Stanislav",
        "Svätopluk",
        "Svetozár",
        "Šimon",
        "Štefan",
        "Tadeáš",
        "Tarzícius",
        "Teodor",
        "Tibor",
        "Tichomír",
        "Timotej",
        "Tobiáš",
        "Tomáš",
        "Urban",
        "Václav",
        "Valentín",
        "Valér",
        "Vasil",
        "Vavrinec",
        "Vendelín",
        "Viktor",
        "Viliam",
        "Vincent",
        "Vít",
        "Víťazoslav",
        "Vladimír",
        "Vladislav",
        "Vlastimil",
        "Vojtech",
        "Vratislav",
        "Vratko",
        "Zdenko",
        "Zlatko",
        "Zoltán",
        "Zoran",
        "Žigmund",
    )

    # Names from
    # https://sk.wikipedia.org/wiki/Kategória:Ženské_mená

    first_names_female = (
        "Adela",
        "Adriána",
        "Agáta",
        "Agnesa",
        "Aiko",
        "Alana",
        "Albína",
        "Alena",
        "Alexandra",
        "Alexia",
        "Alica",
        "Alojzia",
        "Alžbeta",
        "Amália",
        "Anabela",
        "Andrea",
        "Anežka",
        "Angela",
        "Angelika",
        "Anna",
        "Antónia",
        "Aurélia",
        "Barbara",
        "Barbora",
        "Beáta",
        "Berta",
        "Bianka",
        "Bibiána",
        "Blanka",
        "Blažena",
        "Bohdana",
        "Bohumila",
        "Bohuslava",
        "Božena",
        "Božidara",
        "Branislava",
        "Brigita",
        "Bronislava",
        "Cecília",
        "Dagmara",
        "Dana",
        "Danica",
        "Daniela",
        "Darina",
        "Dáša",
        "Denisa",
        "Diana",
        "Dobromila",
        "Dobroslava",
        "Dominika",
        "Dorota",
        "Drahomíra",
        "Drahoslava",
        "Edita",
        "Ela",
        "Elena",
        "Eleonóra",
        "Elisa",
        "Eliška",
        "Elvíra",
        "Ema",
        "Emília",
        "Enna",
        "Erika",
        "Estera",
        "Etela",
        "Eugénia",
        "Eulália",
        "Eunika",
        "Eva",
        "Filoména",
        "Františka",
        "Frederika",
        "Gabriela",
        "Gertrúda",
        "Gizela",
        "Hana",
        "Hedviga",
        "Helena",
        "Henrieta",
        "Hermína",
        "Hilda",
        "Hortenzia",
        "Ida",
        "Ingrida",
        "Irena",
        "Iris",
        "Irma",
        "Ivana",
        "Iveta",
        "Ivica",
        "Ivona",
        "Izabela",
        "Jana",
        "Jarmila",
        "Jaromíra",
        "Jaroslava",
        "Jolana",
        "Jozefína",
        "Judita",
        "Júlia",
        "Juliana",
        "Justína",
        "Kamila",
        "Karina",
        "Karla",
        "Karolína",
        "Katarína",
        "Klára",
        "Klaudia",
        "Kornélia",
        "Kristína",
        "Kvetoslava",
        "Ladislava",
        "Laura",
        "Lea",
        "Lenka",
        "Leopolda",
        "Lesana",
        "Lesia",
        "Liana",
        "Libuša",
        "Liliana",
        "Linda",
        "Lívia",
        "Lolita",
        "Ľubica",
        "Ľubomíra",
        "Ľuboslava",
        "Lucia",
        "Ľudmila",
        "Ľudomila",
        "Lujza",
        "Luna",
        "Lýdia",
        "Magdaléna",
        "Malvína",
        "Marcela",
        "Margaréta",
        "Margita",
        "Mária",
        "Marianna",
        "Marika",
        "Marína",
        "Marta",
        "Martina",
        "Matilda",
        "Melánia",
        "Michaela",
        "Milada",
        "Milena",
        "Milica",
        "Miloslava",
        "Milota",
        "Miriama",
        "Miroslava",
        "Monika",
        "Nadežda",
        "Natália",
        "Nataša",
        "Nikola",
        "Nina",
        "Nora",
        "Oľga",
        "Olívia",
        "Olympia",
        "Otília",
        "Oxana",
        "Patrícia",
        "Paulína",
        "Perla",
        "Petra",
        "Petrana",
        "Petronela",
        "Radoslava",
        "Radovana",
        "Rebeka",
        "Regína",
        "Renáta",
        "Romana",
        "Rozália",
        "Ružena",
        "Sabína",
        "Sandra",
        "Sára",
        "Saskia",
        "Sidónia",
        "Silvia",
        "Simona",
        "Sláva",
        "Slávka",
        "Slavomíra",
        "Sofia",
        "Soňa",
        "Stanislava",
        "Stela",
        "Svetlana",
        "Šarlota",
        "Štefánia",
        "Tamara",
        "Tatiana",
        "Terézia",
        "Theodora",
        "Timea",
        "Uršuľa",
        "Valentína",
        "Valéria",
        "Vanda",
        "Vanesa",
        "Veronika",
        "Viera",
        "Vieroslava",
        "Viktória",
        "Vilma",
        "Viola",
        "Vladimíra",
        "Vlasta",
        "Xénia",
        "Zara",
        "Zdenka",
        "Zina",
        "Zita",
        "Zlatica",
        "Zoja",
        "Zora",
        "Zuzana",
        "Žaneta",
        "Želmíra",
        "Žofia",
    )

    first_names = first_names_male + first_names_female

    # Last names from
    # https://sk.wikipedia.org/wiki/Kategória:Priezviská_na_Slovensku

    last_names_male = (
        "Abrahám",
        "Adam",
        "Adamec",
        "Achberger",
        "Andráš",
        "Andrašík",
        "Andrášik",
        "Antal",
        "Babjak",
        "Babka",
        "Bača",
        "Bahna",
        "Bahno",
        "Baláž",
        "Bán",
        "Baňa",
        "Baňas",
        "Baňo",
        "Baran",
        "Baranka",
        "Barbora",
        "Barok",
        "Bárta",
        "Bartoš",
        "Bartošík",
        "Bartovič",
        "Baša",
        "Baška",
        "Baško",
        "Bašo",
        "Bednár",
        "Bednárik",
        "Beka",
        "Beňa",
        "Beňo",
        "Beňuš",
        "Beňuška",
        "Bernard",
        "Bernolák",
        "Bezák",
        "Bicek",
        "Bielik",
        "Bilek",
        "Bilka",
        "Bilko",
        "Blaha",
        "Blaho",
        "Blažej",
        "Bobula",
        "Bobuľa",
        "Bondra",
        "Borek",
        "Borík",
        "Bórik",
        "Borik",
        "Boris",
        "Boriš",
        "Borka",
        "Borko",
        "Borovský",
        "Borový",
        "Bosák",
        "Boška",
        "Bošňák",
        "Bôrik",
        "Brezina",
        "Brunovský",
        "Bruška",
        "Bruško",
        "Bukovský",
        "Capek",
        "Capka",
        "Capko",
        "Centek",
        "Cesnak",
        "Cibula",
        "Cibuľa",
        "Cibulka",
        "Cibuľka",
        "Cigán",
        "Cigáň",
        "Cigánik",
        "Cíger",
        "Cyprich",
        "Čapka",
        "Čapko",
        "Čapkovič",
        "Čapla",
        "Čapľa",
        "Čaplovič",
        "Čarnogurský",
        "Čekovský",
        "Černík",
        "Černoch",
        "Červeň",
        "Červený",
        "Česnek",
        "Čiernik",
        "Čierny",
        "Čobrda",
        "Ďaďo",
        "Dán",
        "Daňa",
        "Dancák",
        "Dančák",
        "Dančiak",
        "Danek",
        "Danko",
        "Daňko",
        "Dano",
        "Daňo",
        "Dávid",
        "Deák",
        "Debnár",
        "Dej",
        "Dekýš",
        "Devečka",
        "Dobšinský",
        "Dočolomanský",
        "Doležal",
        "Dora",
        "Dorka",
        "Dorko",
        "Ďorko",
        "Dorot",
        "Dorota",
        "Drajna",
        "Drobný",
        "Droppa",
        "Drotár",
        "Dubnička",
        "Dubovský",
        "Duda",
        "Dudek",
        "Dudik",
        "Dudík",
        "Dudka",
        "Dudko",
        "Dudo",
        "Dudok",
        "Dula",
        "Dulla",
        "Ďurča",
        "Ďurčo",
        "Durdík",
        "Ďurek",
        "Ďurica",
        "Ďuriš",
        "Ďurka",
        "Ďurko",
        "Ďurkovič",
        "Ďurkovský",
        "Ďuro",
        "Ďurovič",
        "Ďurovský",
        "Dusík",
        "Duska",
        "Dusko",
        "Duša",
        "Dušek",
        "Dušička",
        "Duška",
        "Dúška",
        "Duško",
        "Ďuško",
        "Dutka",
        "Ďutka",
        "Dutko",
        "Dvonč",
        "Dvorský",
        "Dzurjanin",
        "Fabian",
        "Fabián",
        "Fabuš",
        "Fajnor",
        "Farkašovský",
        "Fašiang",
        "Fedor",
        "Feldek",
        "Fico",
        "Filc",
        "Filip",
        "Filipek",
        "Filípek",
        "Filipko",
        "Finka",
        "Fogaš",
        "Forgáč",
        "Fraňa",
        "Franek",
        "Franka",
        "Franko",
        "Frano",
        "Fraňo",
        "Frimer",
        "Ftáčnik",
        "Ftorek",
        "Gál",
        "Galik",
        "Galík",
        "Gálik",
        "Gašpar",
        "Gašparovič",
        "Gavalier",
        "Gavenda",
        "Gavorník",
        "Gažo",
        "Gocník",
        "Gregor",
        "Greguš",
        "Grňa",
        "Grznár",
        "Hablák",
        "Habšuda",
        "Hagara",
        "Halák",
        "Haluška",
        "Hanak",
        "Hanák",
        "Haňak",
        "Haňák",
        "Hanek",
        "Hanka",
        "Hanko",
        "Hanus",
        "Hanusek",
        "Hanúsek",
        "Hanuska",
        "Hanúska",
        "Hanuška",
        "Hanzel",
        "Harvan",
        "Harvánek",
        "Haščák",
        "Havran",
        "Havranka",
        "Havranko",
        "Hečko",
        "Heretik",
        "Hilmer",
        "Hladký",
        "Hlaváč",
        "Hlaváčik",
        "Hliník",
        "Hlinka",
        "Hodža",
        "Holčík",
        "Holič",
        "Holiček",
        "Holíček",
        "Holička",
        "Holík",
        "Holub",
        "Holubec",
        "Holubek",
        "Holúbek",
        "Holubka",
        "Holubko",
        "Holúbok",
        "Holuby",
        "Hošták",
        "Hošťák",
        "Hoza",
        "Hraško",
        "Hrdlička",
        "Hrianka",
        "Hric",
        "Hrmo",
        "Hroboň",
        "Hruška",
        "Hrušovský",
        "Huba",
        "Hučko",
        "Hudáček",
        "Hudec",
        "Hupka",
        "Hus",
        "Hús",
        "Husák",
        "Husár",
        "Huska",
        "Húska",
        "Husťák",
        "Hušek",
        "Húšek",
        "Huška",
        "Húška",
        "Hušo",
        "Hušták",
        "Hušťák",
        "Hutta",
        "Chalupka",
        "Chovan",
        "Chovanec",
        "Chrappa",
        "Chudík",
        "Ihnačák",
        "Imrich",
        "Ivaška",
        "Jakub",
        "Jakuba",
        "Jakubček",
        "Jakubčík",
        "Jakubčo",
        "Jakubec",
        "Jakubek",
        "Jakúbek",
        "Jakubík",
        "Jakubka",
        "Jakubko",
        "Jalovec",
        "Ján",
        "Janák",
        "Janča",
        "Janček",
        "Jančo",
        "Janeček",
        "Janečka",
        "Janečko",
        "Janek",
        "Janík",
        "Janka",
        "Janko",
        "Jano",
        "Jáno",
        "Janočko",
        "Janoš",
        "Jánoš",
        "Janošek",
        "Jánošík",
        "Janoška",
        "Jánoška",
        "Janoško",
        "Jánoško",
        "Janošo",
        "Jantošovič",
        "Jedľovský",
        "Jendek",
        "Jonata",
        "Junas",
        "Junás",
        "Junáš",
        "Juráš",
        "Jurča",
        "Jurčina",
        "Jurčo",
        "Jurek",
        "Jurík",
        "Jurina",
        "Jurka",
        "Jurko",
        "Jurkovič",
        "Kaliňák",
        "Kaliský",
        "Kaniak",
        "Kára",
        "Karul",
        "Kavasch",
        "Kazik",
        "Kazík",
        "Kázik",
        "Kello",
        "Kelo",
        "Kendra",
        "Keníž",
        "Ker",
        "Kisel",
        "Kiseľ",
        "Kisela",
        "Kiseľa",
        "Klapač",
        "Klapáč",
        "Klapka",
        "Klapko",
        "Klepáč",
        "Klima",
        "Klimáček",
        "Klimek",
        "Klimko",
        "Klimkovič",
        "Klimo",
        "Kližan",
        "Klokoč",
        "Klopačka",
        "Kniha",
        "Kobielsky",
        "Kobielský",
        "Koc",
        "Kocák",
        "Kocian",
        "Kocka",
        "Kocur",
        "Kocúr",
        "Kocúrik",
        "Koč",
        "Kočiš",
        "Kočka",
        "Kočko",
        "Kolár",
        "Kolesár",
        "Kollár",
        "Kolnik",
        "Kolník",
        "Konopka",
        "Konôpka",
        "Konrád",
        "Kopa",
        "Koppa",
        "Korčák",
        "Korec",
        "Kostka",
        "Kostrec",
        "Kotian",
        "Kotulič",
        "Kouba",
        "Kováč",
        "Kováčik",
        "Kovaľ",
        "Kovalčík",
        "Koza",
        "Kozáček",
        "Kozáčik",
        "Kozák",
        "Kozmon",
        "Kôstka",
        "Krajči",
        "Krajčí",
        "Krajčír",
        "Krajčo",
        "Krajčovič",
        "Krajíček",
        "Král",
        "Kráľ",
        "Králik",
        "Kráľovič",
        "Kramár",
        "Krasnohorský",
        "Krásnohorský",
        "Krištof",
        "Kríž",
        "Križan",
        "Krížik",
        "Kropilák",
        "Kroták",
        "Krupa",
        "Krúpa",
        "Kuba",
        "Kubec",
        "Kubek",
        "Kúbek",
        "Kubiček",
        "Kubíček",
        "Kubička",
        "Kubičko",
        "Kubík",
        "Kubko",
        "Kubo",
        "Kučera",
        "Kuffa",
        "Kuna",
        "Kunda",
        "Kunka",
        "Kupa",
        "Kupka",
        "Kupko",
        "Kuruc",
        "Kus",
        "Kús",
        "Kuska",
        "Kúska",
        "Kúš",
        "Kuša",
        "Kuška",
        "Kušnír",
        "Kušo",
        "Kysel",
        "Kyseľ",
        "Kysela",
        "Kyseľa",
        "Labuda",
        "Laca",
        "Lacka",
        "Lacko",
        "Laco",
        "Lajčák",
        "Lajčiak",
        "Lamač",
        "Lepšík",
        "Lesný",
        "Leto",
        "Lipa",
        "Lipka",
        "Lipko",
        "Lipták",
        "Lisický",
        "Liška",
        "Líška",
        "Litva",
        "Loj",
        "Loja",
        "Lojek",
        "Lojka",
        "Lojko",
        "Lubina",
        "Lukáč",
        "Lukša",
        "Lupták",
        "Ľupták",
        "Mác",
        "Maca",
        "Macek",
        "Macka",
        "Mácka",
        "Macko",
        "Mackovič",
        "Maco",
        "Maček",
        "Máček",
        "Máčik",
        "Mačko",
        "Mačkovič",
        "Mačo",
        "Madar",
        "Maďar",
        "Maďár",
        "Madara",
        "Maďara",
        "Maďarič",
        "Madej",
        "Magál",
        "Mach",
        "Macháček",
        "Machata",
        "Machnáč",
        "Macho",
        "Majdan",
        "Majdán",
        "Majeský",
        "Mak",
        "Mako",
        "Makovec",
        "Makovica",
        "Makovický",
        "Makový",
        "Malachovský",
        "Malina",
        "Malíšek",
        "Mamojka",
        "Marcin",
        "Marcinek",
        "Marcinko",
        "Mareček",
        "Marek",
        "Margita",
        "Marián",
        "Marko",
        "Markoš",
        "Markovič",
        "Markuš",
        "Maroš",
        "Marta",
        "Martáň",
        "Marťan",
        "Martin",
        "Martinák",
        "Martinček",
        "Martinec",
        "Martinek",
        "Martinka",
        "Martinko",
        "Martinkovič",
        "Martinovič",
        "Masár",
        "Masarik",
        "Masarík",
        "Masárik",
        "Masaryk",
        "Maslo",
        "Masný",
        "Matiaško",
        "Mauréry",
        "Mečiar",
        "Medvecký",
        "Medveď",
        "Melichar",
        "Melichár",
        "Melichárek",
        "Melicher",
        "Melicherčík",
        "Melicherík",
        "Menšík",
        "Mihalik",
        "Mihalík",
        "Mihálik",
        "Michalech",
        "Michálech",
        "Michalek",
        "Michálek",
        "Michalica",
        "Michalík",
        "Michálik",
        "Michalka",
        "Michalko",
        "Miklík",
        "Mikloš",
        "Mikloško",
        "Mikulák",
        "Mikulík",
        "Mikuš",
        "Mikúš",
        "Milota",
        "Mináč",
        "Mistrík",
        "Mišík",
        "Mlynár",
        "Mlynárik",
        "Mojžiš",
        "Mokroš",
        "Mora",
        "Moravčík",
        "Moravec",
        "Moric",
        "Móric",
        "Motyčka",
        "Motyka",
        "Mraz",
        "Mráz",
        "Mrazek",
        "Mrázik",
        "Mrázka",
        "Mrazko",
        "Mrázko",
        "Mucha",
        "Murgaš",
        "Murin",
        "Murín",
        "Mydlo",
        "Nálepka",
        "Navara",
        "Nemec",
        "Nitra",
        "Nižnanský",
        "Nižnánsky",
        "Nižňanský",
        "Nota",
        "Novák",
        "Novota",
        "Novotný",
        "Nôta",
        "Obšut",
        "Očenáš",
        "Ondráš",
        "Ondrášek",
        "Ondrašík",
        "Ondrášik",
        "Ondrejka",
        "Ondrejko",
        "Ondrejkovič",
        "Ondrus",
        "Ondrusek",
        "Ondruš",
        "Ondrušek",
        "Ondrúšek",
        "Ondruška",
        "Ondruško",
        "Opluštil",
        "Orlík",
        "Otčenáš",
        "Pajer",
        "Paľa",
        "Palka",
        "Paľka",
        "Pálka",
        "Palko",
        "Paľko",
        "Palkovič",
        "Palla",
        "Pallo",
        "Palo",
        "Paľo",
        "Palov",
        "Paľov",
        "Palovčík",
        "Paľovčík",
        "Palovič",
        "Paluch",
        "Palúch",
        "Paľuch",
        "Paľúch",
        "Pašek",
        "Paška",
        "Paško",
        "Paúk",
        "Pauko",
        "Pauliček",
        "Paulíček",
        "Paulik",
        "Paulík",
        "Paulovič",
        "Pavel",
        "Pavelek",
        "Pavelka",
        "Pavelko",
        "Pavka",
        "Pavko",
        "Pavliček",
        "Pavlíček",
        "Pavličko",
        "Pavlik",
        "Pavlík",
        "Pavlikovský",
        "Pavlo",
        "Pavlov",
        "Pavlovič",
        "Pavol",
        "Pavuk",
        "Pavúk",
        "Pelikán",
        "Peška",
        "Peško",
        "Petrovický",
        "Petruška",
        "Pika",
        "Pišút",
        "Plaucha",
        "Plavec",
        "Plavucha",
        "Plekanec",
        "Plešivec",
        "Plch",
        "Podhradský",
        "Podkonický",
        "Polák",
        "Poliak",
        "Pollák",
        "Porubjak",
        "Pukluš",
        "Pupák",
        "Puška",
        "Puškár",
        "Rak",
        "Rakovan",
        "Repiský",
        "Riha",
        "Richard",
        "Richtár",
        "Riša",
        "Riška",
        "Riško",
        "Rišo",
        "Roháč",
        "Roháček",
        "Roháčik",
        "Rojek",
        "Rojka",
        "Rojko",
        "Róm",
        "Romančík",
        "Rosa",
        "Rosina",
        "Rubík",
        "Rúfus",
        "Rus",
        "Rusko",
        "Rusnak",
        "Rusnák",
        "Rusňak",
        "Rusňák",
        "Ružička",
        "Rybár",
        "Rybárik",
        "Rybníček",
        "Rys",
        "Rýs",
        "Ryš",
        "Ryša",
        "Ryška",
        "Ryško",
        "Salaj",
        "Salajka",
        "Sameľ",
        "Sámel",
        "Sámeľ",
        "Samel",
        "Samson",
        "Samuel",
        "Sanitra",
        "Seč",
        "Sedliak",
        "Sekera",
        "Selecký",
        "Senko",
        "Sidor",
        "Simon",
        "Sklár",
        "Sklenár",
        "Sklenárik",
        "Sklenica",
        "Sklenička",
        "Sklenka",
        "Skokan",
        "Skutecký",
        "Slašťan",
        "Slivka",
        "Slivko",
        "Sloboda",
        "Slobodník",
        "Slota",
        "Slovák",
        "Slovinec",
        "Smrek",
        "Sokol",
        "Solej",
        "Starosta",
        "Stodola",
        "Straka",
        "Strnisko",
        "Strýček",
        "Svrbík",
        "Sýkora",
        "Šalajka",
        "Šarkan",
        "Šebo",
        "Šidlo",
        "Šima",
        "Šimek",
        "Šimík",
        "Šimka",
        "Šimko",
        "Šimo",
        "Šimon",
        "Šimončič",
        "Šimonovič",
        "Škantár",
        "Škoviera",
        "Škriniar",
        "Škultéty",
        "Šlahor",
        "Šlivka",
        "Šmajda",
        "Šoltés",
        "Šoltýs",
        "Špilár",
        "Šťastný",
        "Štefan",
        "Štefánek",
        "Štefánik",
        "Štefanka",
        "Štefanko",
        "Štefanovič",
        "Štefunko",
        "Štrba",
        "Šulc",
        "Šuňavec",
        "Šurka",
        "Šváb",
        "Šváby",
        "Švehla",
        "Talpaš",
        "Ťapák",
        "Tatar",
        "Tatár",
        "Tatarka",
        "Tatárka",
        "Ťažký",
        "Thomka",
        "Timek",
        "Timka",
        "Timko",
        "Tirpák",
        "Toman",
        "Tomaň",
        "Tomana",
        "Tomanek",
        "Tománek",
        "Tomaník",
        "Tomáš",
        "Tomašek",
        "Tomášek",
        "Tomášik",
        "Tomaška",
        "Tomáška",
        "Tomaško",
        "Tomáško",
        "Tomeček",
        "Tomečka",
        "Tomečko",
        "Tomek",
        "Tomka",
        "Tomko",
        "Topoľský",
        "Trlík",
        "Truben",
        "Tupý",
        "Turčok",
        "Uram",
        "Urblík",
        "Vajcik",
        "Vajcík",
        "Vajda",
        "Valach",
        "Valachovič",
        "Valent",
        "Valenta",
        "Valentín",
        "Valíček",
        "Valušek",
        "Valuška",
        "Vanek",
        "Vaska",
        "Váska",
        "Vasko",
        "Vašek",
        "Vaška",
        "Vaško",
        "Vavrinec",
        "Velďák",
        "Vesel",
        "Veterník",
        "Vicen",
        "Vicena",
        "Višňovský",
        "Vlach",
        "Vlachovič",
        "Vlk",
        "Vlna",
        "Vlnka",
        "Vojtek",
        "Vojtka",
        "Vojtko",
        "Vozar",
        "Vozár",
        "Vrabec",
        "Vrablec",
        "Vydarený",
        "Záborský",
        "Zachar",
        "Zachara",
        "Zachariaš",
        "Zachariáš",
        "Zajac",
        "Zigo",
        "Zima",
        "Zimka",
        "Zubek",
        "Zúbek",
        "Zubka",
        "Zubko",
        "Zubrík",
        "Zúbrik",
        "Železník",
        "Žigmund",
        "Žigo",
    )

    # Last names (adjusted manually) from
    # https://sk.wikipedia.org/wiki/Kategória:Priezviská_na_Slovensku

    last_names_female = (
        "Abrahámová",
        "Adamová",
        "Adamecová",
        "Achbergerová",
        "Andrášová",
        "Andrašíková",
        "Andrášiková",
        "Antalová",
        "Babjaková",
        "Bahnová",
        "Balážová",
        "Bánová",
        "Baňasová",
        "Baranová",
        "Baranková",
        "Baroková",
        "Bártová",
        "Bartošová",
        "Bartošíková",
        "Bartovičová",
        "Bašová",
        "Bašková",
        "Bednárová",
        "Bednáriková",
        "Beňová",
        "Beňušová",
        "Beňušková",
        "Bernardová",
        "Bernoláková",
        "Bezáková",
        "Biceková",
        "Bieliková",
        "Bileková",
        "Bilková",
        "Blahová",
        "Blažejová",
        "Bobulová",
        "Bobuľová",
        "Bondrová",
        "Boreková",
        "Boríková",
        "Bóriková",
        "Boriková",
        "Borisová",
        "Borišová",
        "Borková",
        "Bosáková",
        "Bošňáková",
        "Bôriková",
        "Brezinová",
        "Brunovská",
        "Brušková",
        "Bukovská",
        "Capeková",
        "Capková",
        "Centeková",
        "Cesnaková",
        "Cibulová",
        "Cibuľková",
        "Cigánová",
        "Cigáňová",
        "Cigániková",
        "Cígerová",
        "Cyprichová",
        "Čapková",
        "Čapkovičová",
        "Čaplovičová",
        "Čarnogurská",
        "Čekovská",
        "Černíková",
        "Černochová",
        "Červeňová",
        "Česneková",
        "Čierniková",
        "Čiernaová",
        "Čobrdová",
        "Ďaďová",
        "Dánová",
        "Daňová",
        "Dancáková",
        "Dančáková",
        "Dančiaková",
        "Daneková",
        "Danková",
        "Daňková",
        "Danová",
        "Dávidová",
        "Deáková",
        "Debnárová",
        "Dekýšová",
        "Devečková",
        "Dobšinská",
        "Dočolomanská",
        "Doležalová",
        "Dorová",
        "Dorková",
        "Ďorková",
        "Dorotová",
        "Drajnová",
        "Drobná",
        "Droppová",
        "Drotárová",
        "Dubovská",
        "Dudová",
        "Dudeková",
        "Dudíková",
        "Dudková",
        "Dudoková",
        "Dulová",
        "Dullová",
        "Ďurčová",
        "Durdíková",
        "Ďureková",
        "Ďuricová",
        "Ďurišová",
        "Ďurkovičová",
        "Ďurkovská",
        "Ďurová",
        "Ďurovičová",
        "Ďurovskýová",
        "Dusíková",
        "Dusková",
        "Dušová",
        "Dušeková",
        "Dušičková",
        "Dutková",
        "Ďutková",
        "Dvončová",
        "Dvorská",
        "Dzurjaninová",
        "Fabianová",
        "Fabiánová",
        "Fabušová",
        "Fajnorová",
        "Farkašovská",
        "Fašiangová",
        "Fedorová",
        "Feldeková",
        "Ficová",
        "Filcová",
        "Filipová",
        "Filipeková",
        "Filípeková",
        "Filipková",
        "Finková",
        "Fogašová",
        "Forgáčová",
        "Fraňová",
        "Franeková",
        "Franková",
        "Franová",
        "Fraňvá",
        "Frimerová",
        "Ftáčniková",
        "Ftoreková",
        "Gálová",
        "Galiková",
        "Galíková",
        "Gáliková",
        "Gašparová",
        "Gašparovičová",
        "Gavalierová",
        "Gavendová",
        "Gavorníková",
        "Gažová",
        "Gocníková",
        "Gregorová",
        "Gregušová",
        "Grňová",
        "Grznárová",
        "Habláková",
        "Habšudová",
        "Hagarová",
        "Haláková",
        "Halušková",
        "Hanaková",
        "Hanáková",
        "Haňaková",
        "Haňáková",
        "Haneková",
        "Hanková",
        "Hanusová",
        "Hanuseková",
        "Hanúseková",
        "Hanusková",
        "Hanúsková",
        "Hanušková",
        "Hanzelová",
        "Harvanová",
        "Harváneková",
        "Haščáková",
        "Havranová",
        "Havranková",
        "Hečková",
        "Heretiková",
        "Hilmerová",
        "Hladká",
        "Hlaváčová",
        "Hlaváčiková",
        "Hliníková",
        "Hlinková",
        "Hodžová",
        "Holčíková",
        "Holičová",
        "Holičeková",
        "Holíčeková",
        "Holičková",
        "Holíková",
        "Holubová",
        "Holubecová",
        "Holubeková",
        "Holúbeková",
        "Holubková",
        "Hoštáková",
        "Hošťáková",
        "Hozová",
        "Hrašková",
        "Hrdličková",
        "Hrianková",
        "Hricová",
        "Hrmová",
        "Hroboňová",
        "Hrušková",
        "Hrušovská",
        "Hubová",
        "Hučková",
        "Hudáčeková",
        "Hudecová",
        "Hupková",
        "Husová",
        "Húsová",
        "Husáková",
        "Husárová",
        "Húsková",
        "Husťáková",
        "Hušeková",
        "Húšeková",
        "Hušová",
        "Huštáková",
        "Hušťáková",
        "Huttová",
        "Chalupková",
        "Chovanová",
        "Chovanecová",
        "Chrappová",
        "Chudíková",
        "Ihnačáková",
        "Imrichová",
        "Ivašková",
        "Jakubová",
        "Jakubčeková",
        "Jakubčíková",
        "Jakubčová",
        "Jakubecová",
        "Jakubeková",
        "Jakúbeková",
        "Jakubíková",
        "Jakubková",
        "Jalovecová",
        "Jánová",
        "Janáková",
        "Jančová",
        "Jančeková",
        "Janečeková",
        "Janečková",
        "Janeková",
        "Janíková",
        "Janková",
        "Janová",
        "Jánová",
        "Janočková",
        "Janošová",
        "Jánošová",
        "Janošeková",
        "Jánošíková",
        "Janošková",
        "Jánošková",
        "Janošová",
        "Jantošovičová",
        "Jedľovská",
        "Jendeková",
        "Jonatová",
        "Junasová",
        "Junásová",
        "Junášová",
        "Jurášová",
        "Jurčová",
        "Jurčinová",
        "Jureková",
        "Juríková",
        "Jurinová",
        "Jurková",
        "Jurkovičová",
        "Kaliňáková",
        "Kaliská",
        "Kaniaková",
        "Kárová",
        "Karulová",
        "Kavaschová",
        "Kaziková",
        "Kazíková",
        "Káziková",
        "Kellová",
        "Kelová",
        "Kendrová",
        "Kenížová",
        "Kerová",
        "Kiselová",
        "Kiseľová",
        "Klapačová",
        "Klapáčová",
        "Klapková",
        "Klepáčová",
        "Klimová",
        "Klimáčeková",
        "Klimeková",
        "Klimková",
        "Klimkovičová",
        "Kližanová",
        "Klokočová",
        "Klopačková",
        "Knihová",
        "Kobielská",
        "Kocová",
        "Kocáková",
        "Kocianová",
        "Kocková",
        "Kocúrová",
        "Kocúriková",
        "Kočová",
        "Kočišová",
        "Kočková",
        "Kolárová",
        "Kolesárová",
        "Kollárová",
        "Kolniková",
        "Kolníková",
        "Konopková",
        "Konôpková",
        "Konrádová",
        "Kopová",
        "Koppová",
        "Korčáková",
        "Korecová",
        "Kostková",
        "Kostrecová",
        "Kotianová",
        "Kotuličová",
        "Koubová",
        "Kováčová",
        "Kováčiková",
        "Kovaľová",
        "Kovalčíková",
        "Kozová",
        "Kozáčeková",
        "Kozáčiková",
        "Kozáková",
        "Kozmonová",
        "Kôstková",
        "Krajčiová",
        "Krajčíová",
        "Krajčírová",
        "Krajčová",
        "Krajčovičová",
        "Krajíčeková",
        "Králová",
        "Kráľová",
        "Králiková",
        "Kráľovičová",
        "Kramárová",
        "Krasnohorská",
        "Krásnohorská",
        "Krištofová",
        "Krížová",
        "Križanová",
        "Krížiková",
        "Kropiláková",
        "Krotáková",
        "Krupová",
        "Krúpová",
        "Kubová",
        "Kubecová",
        "Kubeková",
        "Kúbeková",
        "Kubičeková",
        "Kubíčeková",
        "Kubičková",
        "Kubíková",
        "Kubková",
        "Kučerová",
        "Kuffová",
        "Kunová",
        "Kundová",
        "Kunková",
        "Kupová",
        "Kupková",
        "Kurucová",
        "Kusová",
        "Kúsová",
        "Kusková",
        "Kúsková",
        "Kúšová",
        "Kušová",
        "Kušková",
        "Kušnírová",
        "Kyselová",
        "Kyseľová",
        "Labudová",
        "Lacová",
        "Lacková",
        "Lajčáková",
        "Lajčiaková",
        "Lamačová",
        "Lepšíková",
        "Lesná",
        "Letová",
        "Lipová",
        "Lipková",
        "Liptáková",
        "Lisická",
        "Lišková",
        "Líšková",
        "Litvová",
        "Lojová",
        "Lojeková",
        "Lojková",
        "Lubinová",
        "Lukáčová",
        "Lukšová",
        "Luptáková",
        "Ľuptáková",
        "Mácová",
        "Macová",
        "Maceková",
        "Macková",
        "Mácková",
        "Mackovičová",
        "Mačeková",
        "Máčeková",
        "Máčiková",
        "Mačková",
        "Mačkovičová",
        "Madarová",
        "Maďarová",
        "Maďárová",
        "Maďaričová",
        "Madejová",
        "Magálová",
        "Machová",
        "Macháčeková",
        "Machatová",
        "Machnáčová",
        "Machová",
        "Majdanová",
        "Majdánová",
        "Majeská",
        "Maková",
        "Makovecová",
        "Makovická",
        "Maková",
        "Malachovská",
        "Malinová",
        "Malíšeková",
        "Mamojková",
        "Marcinová",
        "Marcineková",
        "Marcinková",
        "Marečeková",
        "Mareková",
        "Margitová",
        "Mariánová",
        "Marková",
        "Markošová",
        "Markovičová",
        "Markušová",
        "Marošová",
        "Martová",
        "Martáňová",
        "Marťanová",
        "Martinová",
        "Martináková",
        "Martinčeková",
        "Martinecová",
        "Martineková",
        "Martinková",
        "Martinkovičová",
        "Martinovičová",
        "Masárová",
        "Masariková",
        "Masaríková",
        "Masáriková",
        "Masaryková",
        "Maslová",
        "Masná",
        "Matiašková",
        "Mauréryová",
        "Mečiarová",
        "Medvecká",
        "Medveďová",
        "Melicharová",
        "Melichárová",
        "Melicháreková",
        "Melicherová",
        "Melicherčíková",
        "Melicheríková",
        "Menšíková",
        "Mihaliková",
        "Mihalíková",
        "Miháliková",
        "Michalechová",
        "Michálechová",
        "Michaleková",
        "Micháleková",
        "Michalicová",
        "Michalíková",
        "Micháliková",
        "Michalková",
        "Miklíková",
        "Miklošová",
        "Miklošková",
        "Mikuláková",
        "Mikulíková",
        "Mikušová",
        "Mikúšová",
        "Milotová",
        "Mináčová",
        "Mistríková",
        "Mišíková",
        "Mlynárová",
        "Mlynáriková",
        "Mojžišová",
        "Mokrošová",
        "Morová",
        "Moravčíková",
        "Moravecová",
        "Moricová",
        "Móricová",
        "Motyčková",
        "Motyková",
        "Mrazová",
        "Mrázová",
        "Mrazeková",
        "Mráziková",
        "Mrázková",
        "Mrazková",
        "Muchová",
        "Murgašová",
        "Murinová",
        "Murínová",
        "Mydlová",
        "Nálepková",
        "Navarová",
        "Nemcová",
        "Nitrová",
        "Nižnanská",
        "Nižnánská",
        "Nižňanská",
        "Notová",
        "Nováková",
        "Novotná",
        "Nôtová",
        "Obšutová",
        "Očenášová",
        "Ondrášová",
        "Ondrášeková",
        "Ondrašíková",
        "Ondrášiková",
        "Ondrejková",
        "Ondrejkovičová",
        "Ondruseková",
        "Ondrušová",
        "Ondrušeková",
        "Ondrúšeková",
        "Ondrušková",
        "Opluštilová",
        "Orlíková",
        "Otčenášová",
        "Pajerová",
        "Paľová",
        "Palková",
        "Paľková",
        "Palkovičová",
        "Pallová",
        "Palová",
        "Palovová",
        "Paľovová",
        "Palovčíková",
        "Paľovčíková",
        "Palovičová",
        "Paluchová",
        "Palúchová",
        "Paľuchová",
        "Paľúchová",
        "Pašeková",
        "Pašková",
        "Paúková",
        "Pauková",
        "Pauličeková",
        "Paulíčeková",
        "Pauliková",
        "Paulíková",
        "Paulovičová",
        "Pavelová",
        "Paveleková",
        "Pavelková",
        "Pavková",
        "Pavličeková",
        "Pavlíčeková",
        "Pavliková",
        "Pavlíková",
        "Pavlikovská",
        "Pavlová",
        "Pavlovová",
        "Pavlovičová",
        "Pavolová",
        "Pavúková",
        "Pelikánová",
        "Pešková",
        "Petrovická",
        "Petrušková",
        "Piková",
        "Pišútová",
        "Plauchová",
        "Plavecová",
        "Plavuchová",
        "Plekancová",
        "Plešivcová",
        "Plchová",
        "Podhradská",
        "Podkonická",
        "Poláková",
        "Poliaková",
        "Polláková",
        "Porubjaková",
        "Puklušová",
        "Pupáková",
        "Pušková",
        "Puškárová",
        "Raková",
        "Rakovanová",
        "Repiská",
        "Rihová",
        "Richardová",
        "Richtárová",
        "Rišová",
        "Rišková",
        "Roháčová",
        "Roháčeková",
        "Roháčiková",
        "Rojeková",
        "Rojková",
        "Rómová",
        "Romančíková",
        "Rosová",
        "Rosinová",
        "Rubíková",
        "Rúfusová",
        "Rusová",
        "Rusková",
        "Rusnáková",
        "Rusňáková",
        "Ružičková",
        "Rybárová",
        "Rybáriková",
        "Rybníčeková",
        "Rysová",
        "Rýsová",
        "Ryšová",
        "Ryšková",
        "Salajová",
        "Salajková",
        "Sameľová",
        "Sámelová",
        "Sámeľová",
        "Samelová",
        "Samsonová",
        "Samuelová",
        "Sanitrová",
        "Sečová",
        "Sedliaková",
        "Sekerová",
        "Selecká",
        "Senková",
        "Sidorová",
        "Simonová",
        "Sklárová",
        "Sklenárová",
        "Sklenáriková",
        "Sklenicová",
        "Skleničková",
        "Sklenková",
        "Skokanová",
        "Skutecká",
        "Slašťanová",
        "Slivková",
        "Slobodová",
        "Slobodníková",
        "Slotová",
        "Slováková",
        "Slovinecová",
        "Smreková",
        "Sokolová",
        "Solejová",
        "Starostová",
        "Stodolová",
        "Straková",
        "Strnisková",
        "Strýčeková",
        "Svrbíková",
        "Sýkorová",
        "Šalajková",
        "Šarkanová",
        "Šebová",
        "Šidlová",
        "Šimová",
        "Šimeková",
        "Šimíková",
        "Šimková",
        "Šimonová",
        "Šimončičová",
        "Šimonovičová",
        "Škantárová",
        "Škovierová",
        "Škriniarová",
        "Škultétyová",
        "Šlahorová",
        "Šlivková",
        "Šmajdová",
        "Šoltésová",
        "Šoltýsová",
        "Špilárová",
        "Šťastná",
        "Štefanová",
        "Štefáneková",
        "Štefániková",
        "Štefanková",
        "Štefanovičová",
        "Štefunková",
        "Štrbová",
        "Šulcová",
        "Šuňavcová",
        "Šurková",
        "Švábová",
        "Švehlová",
        "Talpašová",
        "Ťapáková",
        "Tatarová",
        "Tatárová",
        "Tatarková",
        "Ťažká",
        "Timeková",
        "Timková",
        "Tirpáková",
        "Tomanová",
        "Tomaňová",
        "Tománeková",
        "Tomaníková",
        "Tomášová",
        "Tomašeková",
        "Tomášeková",
        "Tomášiková",
        "Tomašková",
        "Tomášková",
        "Tomečeková",
        "Tomečková",
        "Tomeková",
        "Tomková",
        "Topoľská",
        "Trlíková",
        "Trubenová",
        "Tupá",
        "Turčoková",
        "Uramová",
        "Urblíková",
        "Vajciková",
        "Vajcíková",
        "Vajdová",
        "Valachová",
        "Valachovičová",
        "Valentová",
        "Valentínová",
        "Valíčeková",
        "Valušeková",
        "Valušková",
        "Vaneková",
        "Vasková",
        "Vásková",
        "Vašeková",
        "Vašková",
        "Vavrinecová",
        "Velďáková",
        "Veselová",
        "Veterníková",
        "Vicenová",
        "Višňovská",
        "Vlachová",
        "Vlachovičová",
        "Vlková",
        "Vlnová",
        "Vlnková",
        "Vojteková",
        "Vojtková",
        "Vozárová",
        "Vrabcová",
        "Vrablecová",
        "Vydarená",
        "Záborská",
        "Zacharová",
        "Zachariašová",
        "Zachariášová",
        "Zajacová",
        "Zigová",
        "Zimová",
        "Zimková",
        "Zubeková",
        "Zúbeková",
        "Zubková",
        "Zubríková",
        "Zúbriková",
        "Železníková",
        "Žigmundová",
        "Žigová",
    )

    last_names = last_names_male + last_names_female

    # Degrees from
    degrees = ("JUDr.", "Ing.", "Bc.", "Mgr.", "MUDr.", "RNDr.", "Ing. arch.", "MVDr.", "PhDr.")

    prefixes_male = ("pán",) + degrees

    prefixes_female = ("pani", "slečna") + degrees

    suffixes = (
        "CSc.",
        "DiS.",
        "Ph.D.",
        "Th.D.",
        "DSc.",
    )
