# openbao_client

OpenbaoClient - the Ruby gem for the OpenBao API

HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

This SDK is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 1.0.0
- Generator version: 7.7.0
- Build package: org.openapitools.codegen.languages.RubyClientCodegen

## Installation

### Build a gem

To build the Ruby code into a gem:

```shell
gem build openbao_client.gemspec
```

Then either install the gem locally:

```shell
gem install ./openbao_client-1.0.0.gem
```

(for development, run `gem install --dev ./openbao_client-1.0.0.gem` to install the development dependencies)

or publish the gem to a gem hosting service, e.g. [RubyGems](https://rubygems.org/).

Finally add this to the Gemfile:

    gem 'openbao_client', '~> 1.0.0'

### Install from Git

If the Ruby gem is hosted at a git repository: https://github.com/GIT_USER_ID/GIT_REPO_ID, then add the following in the Gemfile:

    gem 'openbao_client', :git => 'https://github.com/GIT_USER_ID/GIT_REPO_ID.git'

### Include the Ruby code directly

Include the Ruby code directly using `-I` as follows:

```shell
ruby -Ilib script.rb
```

## Getting Started

Please follow the [installation](#installation) procedure and then run the following code:

```ruby
# Load the gem
require 'openbao_client'

api_instance = OpenbaoClient::AuthApi.new
role_name = 'role_name_example' # String | Name of the role. Must be less than 4096 bytes.
approle_mount_path = 'approle_mount_path_example' # String | Path that the backend was mounted at

begin
  api_instance.app_role_delete_bind_secret_id(role_name, approle_mount_path)
rescue OpenbaoClient::ApiError => e
  puts "Exception when calling AuthApi->app_role_delete_bind_secret_id: #{e}"
end

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OpenbaoClient::AuthApi* | [**app_role_delete_bind_secret_id**](docs/AuthApi.md#app_role_delete_bind_secret_id) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/bind-secret-id | 
*OpenbaoClient::AuthApi* | [**app_role_delete_bound_cidr_list**](docs/AuthApi.md#app_role_delete_bound_cidr_list) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/bound-cidr-list | 
*OpenbaoClient::AuthApi* | [**app_role_delete_period**](docs/AuthApi.md#app_role_delete_period) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/period | 
*OpenbaoClient::AuthApi* | [**app_role_delete_policies**](docs/AuthApi.md#app_role_delete_policies) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/policies | 
*OpenbaoClient::AuthApi* | [**app_role_delete_role**](docs/AuthApi.md#app_role_delete_role) | **DELETE** /auth/{approle_mount_path}/role/{role_name} | 
*OpenbaoClient::AuthApi* | [**app_role_delete_secret_id_bound_cidrs**](docs/AuthApi.md#app_role_delete_secret_id_bound_cidrs) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/secret-id-bound-cidrs | 
*OpenbaoClient::AuthApi* | [**app_role_delete_secret_id_num_uses**](docs/AuthApi.md#app_role_delete_secret_id_num_uses) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/secret-id-num-uses | 
*OpenbaoClient::AuthApi* | [**app_role_delete_secret_id_ttl**](docs/AuthApi.md#app_role_delete_secret_id_ttl) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/secret-id-ttl | 
*OpenbaoClient::AuthApi* | [**app_role_delete_token_bound_cidrs**](docs/AuthApi.md#app_role_delete_token_bound_cidrs) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/token-bound-cidrs | 
*OpenbaoClient::AuthApi* | [**app_role_delete_token_max_ttl**](docs/AuthApi.md#app_role_delete_token_max_ttl) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/token-max-ttl | 
*OpenbaoClient::AuthApi* | [**app_role_delete_token_num_uses**](docs/AuthApi.md#app_role_delete_token_num_uses) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/token-num-uses | 
*OpenbaoClient::AuthApi* | [**app_role_delete_token_ttl**](docs/AuthApi.md#app_role_delete_token_ttl) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/token-ttl | 
*OpenbaoClient::AuthApi* | [**app_role_destroy_secret_id**](docs/AuthApi.md#app_role_destroy_secret_id) | **POST** /auth/{approle_mount_path}/role/{role_name}/secret-id/destroy | 
*OpenbaoClient::AuthApi* | [**app_role_destroy_secret_id2**](docs/AuthApi.md#app_role_destroy_secret_id2) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/secret-id/destroy | 
*OpenbaoClient::AuthApi* | [**app_role_destroy_secret_id_by_accessor**](docs/AuthApi.md#app_role_destroy_secret_id_by_accessor) | **POST** /auth/{approle_mount_path}/role/{role_name}/secret-id-accessor/destroy | 
*OpenbaoClient::AuthApi* | [**app_role_destroy_secret_id_by_accessor2**](docs/AuthApi.md#app_role_destroy_secret_id_by_accessor2) | **DELETE** /auth/{approle_mount_path}/role/{role_name}/secret-id-accessor/destroy | 
*OpenbaoClient::AuthApi* | [**app_role_list_roles**](docs/AuthApi.md#app_role_list_roles) | **GET** /auth/{approle_mount_path}/role | 
*OpenbaoClient::AuthApi* | [**app_role_list_secret_ids**](docs/AuthApi.md#app_role_list_secret_ids) | **GET** /auth/{approle_mount_path}/role/{role_name}/secret-id | 
*OpenbaoClient::AuthApi* | [**app_role_login**](docs/AuthApi.md#app_role_login) | **POST** /auth/{approle_mount_path}/login | 
*OpenbaoClient::AuthApi* | [**app_role_look_up_secret_id**](docs/AuthApi.md#app_role_look_up_secret_id) | **POST** /auth/{approle_mount_path}/role/{role_name}/secret-id/lookup | 
*OpenbaoClient::AuthApi* | [**app_role_look_up_secret_id_by_accessor**](docs/AuthApi.md#app_role_look_up_secret_id_by_accessor) | **POST** /auth/{approle_mount_path}/role/{role_name}/secret-id-accessor/lookup | 
*OpenbaoClient::AuthApi* | [**app_role_read_bind_secret_id**](docs/AuthApi.md#app_role_read_bind_secret_id) | **GET** /auth/{approle_mount_path}/role/{role_name}/bind-secret-id | 
*OpenbaoClient::AuthApi* | [**app_role_read_bound_cidr_list**](docs/AuthApi.md#app_role_read_bound_cidr_list) | **GET** /auth/{approle_mount_path}/role/{role_name}/bound-cidr-list | 
*OpenbaoClient::AuthApi* | [**app_role_read_local_secret_ids**](docs/AuthApi.md#app_role_read_local_secret_ids) | **GET** /auth/{approle_mount_path}/role/{role_name}/local-secret-ids | 
*OpenbaoClient::AuthApi* | [**app_role_read_period**](docs/AuthApi.md#app_role_read_period) | **GET** /auth/{approle_mount_path}/role/{role_name}/period | 
*OpenbaoClient::AuthApi* | [**app_role_read_policies**](docs/AuthApi.md#app_role_read_policies) | **GET** /auth/{approle_mount_path}/role/{role_name}/policies | 
*OpenbaoClient::AuthApi* | [**app_role_read_role**](docs/AuthApi.md#app_role_read_role) | **GET** /auth/{approle_mount_path}/role/{role_name} | 
*OpenbaoClient::AuthApi* | [**app_role_read_role_id**](docs/AuthApi.md#app_role_read_role_id) | **GET** /auth/{approle_mount_path}/role/{role_name}/role-id | 
*OpenbaoClient::AuthApi* | [**app_role_read_secret_id_bound_cidrs**](docs/AuthApi.md#app_role_read_secret_id_bound_cidrs) | **GET** /auth/{approle_mount_path}/role/{role_name}/secret-id-bound-cidrs | 
*OpenbaoClient::AuthApi* | [**app_role_read_secret_id_num_uses**](docs/AuthApi.md#app_role_read_secret_id_num_uses) | **GET** /auth/{approle_mount_path}/role/{role_name}/secret-id-num-uses | 
*OpenbaoClient::AuthApi* | [**app_role_read_secret_id_ttl**](docs/AuthApi.md#app_role_read_secret_id_ttl) | **GET** /auth/{approle_mount_path}/role/{role_name}/secret-id-ttl | 
*OpenbaoClient::AuthApi* | [**app_role_read_token_bound_cidrs**](docs/AuthApi.md#app_role_read_token_bound_cidrs) | **GET** /auth/{approle_mount_path}/role/{role_name}/token-bound-cidrs | 
*OpenbaoClient::AuthApi* | [**app_role_read_token_max_ttl**](docs/AuthApi.md#app_role_read_token_max_ttl) | **GET** /auth/{approle_mount_path}/role/{role_name}/token-max-ttl | 
*OpenbaoClient::AuthApi* | [**app_role_read_token_num_uses**](docs/AuthApi.md#app_role_read_token_num_uses) | **GET** /auth/{approle_mount_path}/role/{role_name}/token-num-uses | 
*OpenbaoClient::AuthApi* | [**app_role_read_token_ttl**](docs/AuthApi.md#app_role_read_token_ttl) | **GET** /auth/{approle_mount_path}/role/{role_name}/token-ttl | 
*OpenbaoClient::AuthApi* | [**app_role_tidy_secret_id**](docs/AuthApi.md#app_role_tidy_secret_id) | **POST** /auth/{approle_mount_path}/tidy/secret-id | 
*OpenbaoClient::AuthApi* | [**app_role_write_bind_secret_id**](docs/AuthApi.md#app_role_write_bind_secret_id) | **POST** /auth/{approle_mount_path}/role/{role_name}/bind-secret-id | 
*OpenbaoClient::AuthApi* | [**app_role_write_bound_cidr_list**](docs/AuthApi.md#app_role_write_bound_cidr_list) | **POST** /auth/{approle_mount_path}/role/{role_name}/bound-cidr-list | 
*OpenbaoClient::AuthApi* | [**app_role_write_custom_secret_id**](docs/AuthApi.md#app_role_write_custom_secret_id) | **POST** /auth/{approle_mount_path}/role/{role_name}/custom-secret-id | 
*OpenbaoClient::AuthApi* | [**app_role_write_period**](docs/AuthApi.md#app_role_write_period) | **POST** /auth/{approle_mount_path}/role/{role_name}/period | 
*OpenbaoClient::AuthApi* | [**app_role_write_policies**](docs/AuthApi.md#app_role_write_policies) | **POST** /auth/{approle_mount_path}/role/{role_name}/policies | 
*OpenbaoClient::AuthApi* | [**app_role_write_role**](docs/AuthApi.md#app_role_write_role) | **POST** /auth/{approle_mount_path}/role/{role_name} | 
*OpenbaoClient::AuthApi* | [**app_role_write_role_id**](docs/AuthApi.md#app_role_write_role_id) | **POST** /auth/{approle_mount_path}/role/{role_name}/role-id | 
*OpenbaoClient::AuthApi* | [**app_role_write_secret_id**](docs/AuthApi.md#app_role_write_secret_id) | **POST** /auth/{approle_mount_path}/role/{role_name}/secret-id | 
*OpenbaoClient::AuthApi* | [**app_role_write_secret_id_bound_cidrs**](docs/AuthApi.md#app_role_write_secret_id_bound_cidrs) | **POST** /auth/{approle_mount_path}/role/{role_name}/secret-id-bound-cidrs | 
*OpenbaoClient::AuthApi* | [**app_role_write_secret_id_num_uses**](docs/AuthApi.md#app_role_write_secret_id_num_uses) | **POST** /auth/{approle_mount_path}/role/{role_name}/secret-id-num-uses | 
*OpenbaoClient::AuthApi* | [**app_role_write_secret_id_ttl**](docs/AuthApi.md#app_role_write_secret_id_ttl) | **POST** /auth/{approle_mount_path}/role/{role_name}/secret-id-ttl | 
*OpenbaoClient::AuthApi* | [**app_role_write_token_bound_cidrs**](docs/AuthApi.md#app_role_write_token_bound_cidrs) | **POST** /auth/{approle_mount_path}/role/{role_name}/token-bound-cidrs | 
*OpenbaoClient::AuthApi* | [**app_role_write_token_max_ttl**](docs/AuthApi.md#app_role_write_token_max_ttl) | **POST** /auth/{approle_mount_path}/role/{role_name}/token-max-ttl | 
*OpenbaoClient::AuthApi* | [**app_role_write_token_num_uses**](docs/AuthApi.md#app_role_write_token_num_uses) | **POST** /auth/{approle_mount_path}/role/{role_name}/token-num-uses | 
*OpenbaoClient::AuthApi* | [**app_role_write_token_ttl**](docs/AuthApi.md#app_role_write_token_ttl) | **POST** /auth/{approle_mount_path}/role/{role_name}/token-ttl | 
*OpenbaoClient::AuthApi* | [**cert_configure**](docs/AuthApi.md#cert_configure) | **POST** /auth/{cert_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**cert_delete_certificate**](docs/AuthApi.md#cert_delete_certificate) | **DELETE** /auth/{cert_mount_path}/certs/{name} | Manage trusted certificates used for authentication.
*OpenbaoClient::AuthApi* | [**cert_delete_crl**](docs/AuthApi.md#cert_delete_crl) | **DELETE** /auth/{cert_mount_path}/crls/{name} | Manage Certificate Revocation Lists checked during authentication.
*OpenbaoClient::AuthApi* | [**cert_list_certificates**](docs/AuthApi.md#cert_list_certificates) | **GET** /auth/{cert_mount_path}/certs | Manage trusted certificates used for authentication.
*OpenbaoClient::AuthApi* | [**cert_list_crls**](docs/AuthApi.md#cert_list_crls) | **GET** /auth/{cert_mount_path}/crls | 
*OpenbaoClient::AuthApi* | [**cert_login**](docs/AuthApi.md#cert_login) | **POST** /auth/{cert_mount_path}/login | 
*OpenbaoClient::AuthApi* | [**cert_read_certificate**](docs/AuthApi.md#cert_read_certificate) | **GET** /auth/{cert_mount_path}/certs/{name} | Manage trusted certificates used for authentication.
*OpenbaoClient::AuthApi* | [**cert_read_configuration**](docs/AuthApi.md#cert_read_configuration) | **GET** /auth/{cert_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**cert_read_crl**](docs/AuthApi.md#cert_read_crl) | **GET** /auth/{cert_mount_path}/crls/{name} | Manage Certificate Revocation Lists checked during authentication.
*OpenbaoClient::AuthApi* | [**cert_write_certificate**](docs/AuthApi.md#cert_write_certificate) | **POST** /auth/{cert_mount_path}/certs/{name} | Manage trusted certificates used for authentication.
*OpenbaoClient::AuthApi* | [**cert_write_crl**](docs/AuthApi.md#cert_write_crl) | **POST** /auth/{cert_mount_path}/crls/{name} | Manage Certificate Revocation Lists checked during authentication.
*OpenbaoClient::AuthApi* | [**jwt_configure**](docs/AuthApi.md#jwt_configure) | **POST** /auth/{jwt_mount_path}/config | Configure the JWT authentication backend.
*OpenbaoClient::AuthApi* | [**jwt_delete_role**](docs/AuthApi.md#jwt_delete_role) | **DELETE** /auth/{jwt_mount_path}/role/{name} | Delete an existing role.
*OpenbaoClient::AuthApi* | [**jwt_list_roles**](docs/AuthApi.md#jwt_list_roles) | **GET** /auth/{jwt_mount_path}/role | Lists all the roles registered with the backend.
*OpenbaoClient::AuthApi* | [**jwt_login**](docs/AuthApi.md#jwt_login) | **POST** /auth/{jwt_mount_path}/login | Authenticates to OpenBao using a JWT (or OIDC) token.
*OpenbaoClient::AuthApi* | [**jwt_oidc_callback**](docs/AuthApi.md#jwt_oidc_callback) | **GET** /auth/{jwt_mount_path}/oidc/callback | Callback endpoint to complete an OIDC login.
*OpenbaoClient::AuthApi* | [**jwt_oidc_callback_form_post**](docs/AuthApi.md#jwt_oidc_callback_form_post) | **POST** /auth/{jwt_mount_path}/oidc/callback | Callback endpoint to handle form_posts.
*OpenbaoClient::AuthApi* | [**jwt_oidc_request_authorization_url**](docs/AuthApi.md#jwt_oidc_request_authorization_url) | **POST** /auth/{jwt_mount_path}/oidc/auth_url | Request an authorization URL to start an OIDC login flow.
*OpenbaoClient::AuthApi* | [**jwt_read_configuration**](docs/AuthApi.md#jwt_read_configuration) | **GET** /auth/{jwt_mount_path}/config | Read the current JWT authentication backend configuration.
*OpenbaoClient::AuthApi* | [**jwt_read_role**](docs/AuthApi.md#jwt_read_role) | **GET** /auth/{jwt_mount_path}/role/{name} | Read an existing role.
*OpenbaoClient::AuthApi* | [**jwt_write_role**](docs/AuthApi.md#jwt_write_role) | **POST** /auth/{jwt_mount_path}/role/{name} | Register an role with the backend.
*OpenbaoClient::AuthApi* | [**kerberos_configure**](docs/AuthApi.md#kerberos_configure) | **POST** /auth/{kerberos_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**kerberos_configure_ldap**](docs/AuthApi.md#kerberos_configure_ldap) | **POST** /auth/{kerberos_mount_path}/config/ldap | 
*OpenbaoClient::AuthApi* | [**kerberos_delete_group**](docs/AuthApi.md#kerberos_delete_group) | **DELETE** /auth/{kerberos_mount_path}/groups/{name} | 
*OpenbaoClient::AuthApi* | [**kerberos_list_groups**](docs/AuthApi.md#kerberos_list_groups) | **GET** /auth/{kerberos_mount_path}/groups | 
*OpenbaoClient::AuthApi* | [**kerberos_login**](docs/AuthApi.md#kerberos_login) | **POST** /auth/{kerberos_mount_path}/login | 
*OpenbaoClient::AuthApi* | [**kerberos_login2**](docs/AuthApi.md#kerberos_login2) | **GET** /auth/{kerberos_mount_path}/login | 
*OpenbaoClient::AuthApi* | [**kerberos_read_configuration**](docs/AuthApi.md#kerberos_read_configuration) | **GET** /auth/{kerberos_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**kerberos_read_group**](docs/AuthApi.md#kerberos_read_group) | **GET** /auth/{kerberos_mount_path}/groups/{name} | 
*OpenbaoClient::AuthApi* | [**kerberos_read_ldap_configuration**](docs/AuthApi.md#kerberos_read_ldap_configuration) | **GET** /auth/{kerberos_mount_path}/config/ldap | 
*OpenbaoClient::AuthApi* | [**kerberos_write_group**](docs/AuthApi.md#kerberos_write_group) | **POST** /auth/{kerberos_mount_path}/groups/{name} | 
*OpenbaoClient::AuthApi* | [**kubernetes_configure_auth**](docs/AuthApi.md#kubernetes_configure_auth) | **POST** /auth/{kubernetes_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**kubernetes_delete_auth_role**](docs/AuthApi.md#kubernetes_delete_auth_role) | **DELETE** /auth/{kubernetes_mount_path}/role/{name} | Register an role with the backend.
*OpenbaoClient::AuthApi* | [**kubernetes_list_auth_roles**](docs/AuthApi.md#kubernetes_list_auth_roles) | **GET** /auth/{kubernetes_mount_path}/role | Lists all the roles registered with the backend.
*OpenbaoClient::AuthApi* | [**kubernetes_login**](docs/AuthApi.md#kubernetes_login) | **POST** /auth/{kubernetes_mount_path}/login | Authenticates Kubernetes service accounts with OpenBao.
*OpenbaoClient::AuthApi* | [**kubernetes_read_auth_configuration**](docs/AuthApi.md#kubernetes_read_auth_configuration) | **GET** /auth/{kubernetes_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**kubernetes_read_auth_role**](docs/AuthApi.md#kubernetes_read_auth_role) | **GET** /auth/{kubernetes_mount_path}/role/{name} | Register an role with the backend.
*OpenbaoClient::AuthApi* | [**kubernetes_write_auth_role**](docs/AuthApi.md#kubernetes_write_auth_role) | **POST** /auth/{kubernetes_mount_path}/role/{name} | Register an role with the backend.
*OpenbaoClient::AuthApi* | [**ldap_configure_auth**](docs/AuthApi.md#ldap_configure_auth) | **POST** /auth/{ldap_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**ldap_delete_group**](docs/AuthApi.md#ldap_delete_group) | **DELETE** /auth/{ldap_mount_path}/groups/{name} | Manage additional groups for users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**ldap_delete_user**](docs/AuthApi.md#ldap_delete_user) | **DELETE** /auth/{ldap_mount_path}/users/{name} | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**ldap_list_groups**](docs/AuthApi.md#ldap_list_groups) | **GET** /auth/{ldap_mount_path}/groups | Manage additional groups for users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**ldap_list_users**](docs/AuthApi.md#ldap_list_users) | **GET** /auth/{ldap_mount_path}/users | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**ldap_login**](docs/AuthApi.md#ldap_login) | **POST** /auth/{ldap_mount_path}/login/{username} | Log in with a username and password.
*OpenbaoClient::AuthApi* | [**ldap_read_auth_configuration**](docs/AuthApi.md#ldap_read_auth_configuration) | **GET** /auth/{ldap_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**ldap_read_group**](docs/AuthApi.md#ldap_read_group) | **GET** /auth/{ldap_mount_path}/groups/{name} | Manage additional groups for users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**ldap_read_user**](docs/AuthApi.md#ldap_read_user) | **GET** /auth/{ldap_mount_path}/users/{name} | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**ldap_write_group**](docs/AuthApi.md#ldap_write_group) | **POST** /auth/{ldap_mount_path}/groups/{name} | Manage additional groups for users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**ldap_write_user**](docs/AuthApi.md#ldap_write_user) | **POST** /auth/{ldap_mount_path}/users/{name} | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**radius_configure**](docs/AuthApi.md#radius_configure) | **POST** /auth/{radius_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**radius_delete_user**](docs/AuthApi.md#radius_delete_user) | **DELETE** /auth/{radius_mount_path}/users/{name} | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**radius_list_users**](docs/AuthApi.md#radius_list_users) | **GET** /auth/{radius_mount_path}/users | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**radius_login**](docs/AuthApi.md#radius_login) | **POST** /auth/{radius_mount_path}/login | Log in with a username and password.
*OpenbaoClient::AuthApi* | [**radius_login_with_username**](docs/AuthApi.md#radius_login_with_username) | **POST** /auth/{radius_mount_path}/login/{urlusername} | Log in with a username and password.
*OpenbaoClient::AuthApi* | [**radius_read_configuration**](docs/AuthApi.md#radius_read_configuration) | **GET** /auth/{radius_mount_path}/config | 
*OpenbaoClient::AuthApi* | [**radius_read_user**](docs/AuthApi.md#radius_read_user) | **GET** /auth/{radius_mount_path}/users/{name} | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**radius_write_user**](docs/AuthApi.md#radius_write_user) | **POST** /auth/{radius_mount_path}/users/{name} | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**token_create**](docs/AuthApi.md#token_create) | **POST** /auth/token/create | The token create path is used to create new tokens.
*OpenbaoClient::AuthApi* | [**token_create_against_role**](docs/AuthApi.md#token_create_against_role) | **POST** /auth/token/create/{role_name} | This token create path is used to create new tokens adhering to the given role.
*OpenbaoClient::AuthApi* | [**token_create_orphan**](docs/AuthApi.md#token_create_orphan) | **POST** /auth/token/create-orphan | The token create path is used to create new orphan tokens.
*OpenbaoClient::AuthApi* | [**token_delete_role**](docs/AuthApi.md#token_delete_role) | **DELETE** /auth/token/roles/{role_name} | 
*OpenbaoClient::AuthApi* | [**token_list_accessors**](docs/AuthApi.md#token_list_accessors) | **GET** /auth/token/accessors | List token accessors, which can then be be used to iterate and discover their properties or revoke them. Because this can be used to cause a denial of service, this endpoint requires 'sudo' capability in addition to 'list'.
*OpenbaoClient::AuthApi* | [**token_list_roles**](docs/AuthApi.md#token_list_roles) | **GET** /auth/token/roles | This endpoint lists configured roles.
*OpenbaoClient::AuthApi* | [**token_look_up**](docs/AuthApi.md#token_look_up) | **POST** /auth/token/lookup | 
*OpenbaoClient::AuthApi* | [**token_look_up2**](docs/AuthApi.md#token_look_up2) | **GET** /auth/token/lookup | 
*OpenbaoClient::AuthApi* | [**token_look_up_accessor**](docs/AuthApi.md#token_look_up_accessor) | **POST** /auth/token/lookup-accessor | This endpoint will lookup a token associated with the given accessor and its properties. Response will not contain the token ID.
*OpenbaoClient::AuthApi* | [**token_look_up_self**](docs/AuthApi.md#token_look_up_self) | **GET** /auth/token/lookup-self | 
*OpenbaoClient::AuthApi* | [**token_look_up_self2**](docs/AuthApi.md#token_look_up_self2) | **POST** /auth/token/lookup-self | 
*OpenbaoClient::AuthApi* | [**token_read_role**](docs/AuthApi.md#token_read_role) | **GET** /auth/token/roles/{role_name} | 
*OpenbaoClient::AuthApi* | [**token_renew**](docs/AuthApi.md#token_renew) | **POST** /auth/token/renew | This endpoint will renew the given token and prevent expiration.
*OpenbaoClient::AuthApi* | [**token_renew_accessor**](docs/AuthApi.md#token_renew_accessor) | **POST** /auth/token/renew-accessor | This endpoint will renew a token associated with the given accessor and its properties. Response will not contain the token ID.
*OpenbaoClient::AuthApi* | [**token_renew_self**](docs/AuthApi.md#token_renew_self) | **POST** /auth/token/renew-self | This endpoint will renew the token used to call it and prevent expiration.
*OpenbaoClient::AuthApi* | [**token_revoke**](docs/AuthApi.md#token_revoke) | **POST** /auth/token/revoke | This endpoint will delete the given token and all of its child tokens.
*OpenbaoClient::AuthApi* | [**token_revoke_accessor**](docs/AuthApi.md#token_revoke_accessor) | **POST** /auth/token/revoke-accessor | This endpoint will delete the token associated with the accessor and all of its child tokens.
*OpenbaoClient::AuthApi* | [**token_revoke_orphan**](docs/AuthApi.md#token_revoke_orphan) | **POST** /auth/token/revoke-orphan | This endpoint will delete the token and orphan its child tokens.
*OpenbaoClient::AuthApi* | [**token_revoke_self**](docs/AuthApi.md#token_revoke_self) | **POST** /auth/token/revoke-self | This endpoint will delete the token used to call it and all of its child tokens.
*OpenbaoClient::AuthApi* | [**token_tidy**](docs/AuthApi.md#token_tidy) | **POST** /auth/token/tidy | This endpoint performs cleanup tasks that can be run if certain error conditions have occurred.
*OpenbaoClient::AuthApi* | [**token_write_role**](docs/AuthApi.md#token_write_role) | **POST** /auth/token/roles/{role_name} | 
*OpenbaoClient::AuthApi* | [**userpass_delete_user**](docs/AuthApi.md#userpass_delete_user) | **DELETE** /auth/{userpass_mount_path}/users/{username} | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**userpass_list_users**](docs/AuthApi.md#userpass_list_users) | **GET** /auth/{userpass_mount_path}/users | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**userpass_login**](docs/AuthApi.md#userpass_login) | **POST** /auth/{userpass_mount_path}/login/{username} | Log in with a username and password.
*OpenbaoClient::AuthApi* | [**userpass_read_user**](docs/AuthApi.md#userpass_read_user) | **GET** /auth/{userpass_mount_path}/users/{username} | Manage users allowed to authenticate.
*OpenbaoClient::AuthApi* | [**userpass_reset_password**](docs/AuthApi.md#userpass_reset_password) | **POST** /auth/{userpass_mount_path}/users/{username}/password | Reset user's password.
*OpenbaoClient::AuthApi* | [**userpass_update_policies**](docs/AuthApi.md#userpass_update_policies) | **POST** /auth/{userpass_mount_path}/users/{username}/policies | Update the policies associated with the username.
*OpenbaoClient::AuthApi* | [**userpass_write_user**](docs/AuthApi.md#userpass_write_user) | **POST** /auth/{userpass_mount_path}/users/{username} | Manage users allowed to authenticate.
*OpenbaoClient::IdentityApi* | [**alias_create**](docs/IdentityApi.md#alias_create) | **POST** /identity/alias | Create a new alias.
*OpenbaoClient::IdentityApi* | [**alias_delete_by_id**](docs/IdentityApi.md#alias_delete_by_id) | **DELETE** /identity/alias/id/{id} | 
*OpenbaoClient::IdentityApi* | [**alias_list_by_id**](docs/IdentityApi.md#alias_list_by_id) | **GET** /identity/alias/id | List all the alias IDs.
*OpenbaoClient::IdentityApi* | [**alias_read_by_id**](docs/IdentityApi.md#alias_read_by_id) | **GET** /identity/alias/id/{id} | 
*OpenbaoClient::IdentityApi* | [**alias_update_by_id**](docs/IdentityApi.md#alias_update_by_id) | **POST** /identity/alias/id/{id} | 
*OpenbaoClient::IdentityApi* | [**entity_batch_delete**](docs/IdentityApi.md#entity_batch_delete) | **POST** /identity/entity/batch-delete | 
*OpenbaoClient::IdentityApi* | [**entity_create**](docs/IdentityApi.md#entity_create) | **POST** /identity/entity | 
*OpenbaoClient::IdentityApi* | [**entity_create_alias**](docs/IdentityApi.md#entity_create_alias) | **POST** /identity/entity-alias | Create a new alias.
*OpenbaoClient::IdentityApi* | [**entity_delete_alias_by_id**](docs/IdentityApi.md#entity_delete_alias_by_id) | **DELETE** /identity/entity-alias/id/{id} | 
*OpenbaoClient::IdentityApi* | [**entity_delete_by_id**](docs/IdentityApi.md#entity_delete_by_id) | **DELETE** /identity/entity/id/{id} | 
*OpenbaoClient::IdentityApi* | [**entity_delete_by_name**](docs/IdentityApi.md#entity_delete_by_name) | **DELETE** /identity/entity/name/{name} | 
*OpenbaoClient::IdentityApi* | [**entity_list_aliases_by_id**](docs/IdentityApi.md#entity_list_aliases_by_id) | **GET** /identity/entity-alias/id | List all the alias IDs.
*OpenbaoClient::IdentityApi* | [**entity_list_by_id**](docs/IdentityApi.md#entity_list_by_id) | **GET** /identity/entity/id | 
*OpenbaoClient::IdentityApi* | [**entity_list_by_name**](docs/IdentityApi.md#entity_list_by_name) | **GET** /identity/entity/name | 
*OpenbaoClient::IdentityApi* | [**entity_look_up**](docs/IdentityApi.md#entity_look_up) | **POST** /identity/lookup/entity | Query entities based on various properties.
*OpenbaoClient::IdentityApi* | [**entity_merge**](docs/IdentityApi.md#entity_merge) | **POST** /identity/entity/merge | 
*OpenbaoClient::IdentityApi* | [**entity_read_alias_by_id**](docs/IdentityApi.md#entity_read_alias_by_id) | **GET** /identity/entity-alias/id/{id} | 
*OpenbaoClient::IdentityApi* | [**entity_read_by_id**](docs/IdentityApi.md#entity_read_by_id) | **GET** /identity/entity/id/{id} | 
*OpenbaoClient::IdentityApi* | [**entity_read_by_name**](docs/IdentityApi.md#entity_read_by_name) | **GET** /identity/entity/name/{name} | 
*OpenbaoClient::IdentityApi* | [**entity_update_alias_by_id**](docs/IdentityApi.md#entity_update_alias_by_id) | **POST** /identity/entity-alias/id/{id} | 
*OpenbaoClient::IdentityApi* | [**entity_update_by_id**](docs/IdentityApi.md#entity_update_by_id) | **POST** /identity/entity/id/{id} | 
*OpenbaoClient::IdentityApi* | [**entity_update_by_name**](docs/IdentityApi.md#entity_update_by_name) | **POST** /identity/entity/name/{name} | 
*OpenbaoClient::IdentityApi* | [**group_create**](docs/IdentityApi.md#group_create) | **POST** /identity/group | 
*OpenbaoClient::IdentityApi* | [**group_create_alias**](docs/IdentityApi.md#group_create_alias) | **POST** /identity/group-alias | Creates a new group alias, or updates an existing one.
*OpenbaoClient::IdentityApi* | [**group_delete_alias_by_id**](docs/IdentityApi.md#group_delete_alias_by_id) | **DELETE** /identity/group-alias/id/{id} | 
*OpenbaoClient::IdentityApi* | [**group_delete_by_id**](docs/IdentityApi.md#group_delete_by_id) | **DELETE** /identity/group/id/{id} | 
*OpenbaoClient::IdentityApi* | [**group_delete_by_name**](docs/IdentityApi.md#group_delete_by_name) | **DELETE** /identity/group/name/{name} | 
*OpenbaoClient::IdentityApi* | [**group_list_aliases_by_id**](docs/IdentityApi.md#group_list_aliases_by_id) | **GET** /identity/group-alias/id | List all the group alias IDs.
*OpenbaoClient::IdentityApi* | [**group_list_by_id**](docs/IdentityApi.md#group_list_by_id) | **GET** /identity/group/id | List all the group IDs.
*OpenbaoClient::IdentityApi* | [**group_list_by_name**](docs/IdentityApi.md#group_list_by_name) | **GET** /identity/group/name | 
*OpenbaoClient::IdentityApi* | [**group_look_up**](docs/IdentityApi.md#group_look_up) | **POST** /identity/lookup/group | Query groups based on various properties.
*OpenbaoClient::IdentityApi* | [**group_read_alias_by_id**](docs/IdentityApi.md#group_read_alias_by_id) | **GET** /identity/group-alias/id/{id} | 
*OpenbaoClient::IdentityApi* | [**group_read_by_id**](docs/IdentityApi.md#group_read_by_id) | **GET** /identity/group/id/{id} | 
*OpenbaoClient::IdentityApi* | [**group_read_by_name**](docs/IdentityApi.md#group_read_by_name) | **GET** /identity/group/name/{name} | 
*OpenbaoClient::IdentityApi* | [**group_update_alias_by_id**](docs/IdentityApi.md#group_update_alias_by_id) | **POST** /identity/group-alias/id/{id} | 
*OpenbaoClient::IdentityApi* | [**group_update_by_id**](docs/IdentityApi.md#group_update_by_id) | **POST** /identity/group/id/{id} | 
*OpenbaoClient::IdentityApi* | [**group_update_by_name**](docs/IdentityApi.md#group_update_by_name) | **POST** /identity/group/name/{name} | 
*OpenbaoClient::IdentityApi* | [**mfa_admin_destroy_totp_secret**](docs/IdentityApi.md#mfa_admin_destroy_totp_secret) | **POST** /identity/mfa/method/totp/admin-destroy | Destroys a TOTP secret for the given MFA method ID on the given entity
*OpenbaoClient::IdentityApi* | [**mfa_admin_generate_totp_secret**](docs/IdentityApi.md#mfa_admin_generate_totp_secret) | **POST** /identity/mfa/method/totp/admin-generate | Update or create TOTP secret for the given method ID on the given entity.
*OpenbaoClient::IdentityApi* | [**mfa_configure_duo_method**](docs/IdentityApi.md#mfa_configure_duo_method) | **POST** /identity/mfa/method/duo/{method_id} | Update or create a configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_configure_okta_method**](docs/IdentityApi.md#mfa_configure_okta_method) | **POST** /identity/mfa/method/okta/{method_id} | Update or create a configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_configure_ping_id_method**](docs/IdentityApi.md#mfa_configure_ping_id_method) | **POST** /identity/mfa/method/pingid/{method_id} | Update or create a configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_configure_totp_method**](docs/IdentityApi.md#mfa_configure_totp_method) | **POST** /identity/mfa/method/totp/{method_id} | Update or create a configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_delete_duo_method**](docs/IdentityApi.md#mfa_delete_duo_method) | **DELETE** /identity/mfa/method/duo/{method_id} | Delete a configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_delete_login_enforcement**](docs/IdentityApi.md#mfa_delete_login_enforcement) | **DELETE** /identity/mfa/login-enforcement/{name} | Delete a login enforcement
*OpenbaoClient::IdentityApi* | [**mfa_delete_okta_method**](docs/IdentityApi.md#mfa_delete_okta_method) | **DELETE** /identity/mfa/method/okta/{method_id} | Delete a configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_delete_ping_id_method**](docs/IdentityApi.md#mfa_delete_ping_id_method) | **DELETE** /identity/mfa/method/pingid/{method_id} | Delete a configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_delete_totp_method**](docs/IdentityApi.md#mfa_delete_totp_method) | **DELETE** /identity/mfa/method/totp/{method_id} | Delete a configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_generate_totp_secret**](docs/IdentityApi.md#mfa_generate_totp_secret) | **POST** /identity/mfa/method/totp/generate | Update or create TOTP secret for the given method ID on the given entity.
*OpenbaoClient::IdentityApi* | [**mfa_list_duo_methods**](docs/IdentityApi.md#mfa_list_duo_methods) | **GET** /identity/mfa/method/duo | List MFA method configurations for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_list_login_enforcements**](docs/IdentityApi.md#mfa_list_login_enforcements) | **GET** /identity/mfa/login-enforcement | List login enforcements
*OpenbaoClient::IdentityApi* | [**mfa_list_methods**](docs/IdentityApi.md#mfa_list_methods) | **GET** /identity/mfa/method | List MFA method configurations for all MFA methods
*OpenbaoClient::IdentityApi* | [**mfa_list_okta_methods**](docs/IdentityApi.md#mfa_list_okta_methods) | **GET** /identity/mfa/method/okta | List MFA method configurations for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_list_ping_id_methods**](docs/IdentityApi.md#mfa_list_ping_id_methods) | **GET** /identity/mfa/method/pingid | List MFA method configurations for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_list_totp_methods**](docs/IdentityApi.md#mfa_list_totp_methods) | **GET** /identity/mfa/method/totp | List MFA method configurations for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_read_duo_method_configuration**](docs/IdentityApi.md#mfa_read_duo_method_configuration) | **GET** /identity/mfa/method/duo/{method_id} | Read the current configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_read_login_enforcement**](docs/IdentityApi.md#mfa_read_login_enforcement) | **GET** /identity/mfa/login-enforcement/{name} | Read the current login enforcement
*OpenbaoClient::IdentityApi* | [**mfa_read_method_configuration**](docs/IdentityApi.md#mfa_read_method_configuration) | **GET** /identity/mfa/method/{method_id} | Read the current configuration for the given ID regardless of the MFA method type
*OpenbaoClient::IdentityApi* | [**mfa_read_okta_method_configuration**](docs/IdentityApi.md#mfa_read_okta_method_configuration) | **GET** /identity/mfa/method/okta/{method_id} | Read the current configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_read_ping_id_method_configuration**](docs/IdentityApi.md#mfa_read_ping_id_method_configuration) | **GET** /identity/mfa/method/pingid/{method_id} | Read the current configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_read_totp_method_configuration**](docs/IdentityApi.md#mfa_read_totp_method_configuration) | **GET** /identity/mfa/method/totp/{method_id} | Read the current configuration for the given MFA method
*OpenbaoClient::IdentityApi* | [**mfa_write_login_enforcement**](docs/IdentityApi.md#mfa_write_login_enforcement) | **POST** /identity/mfa/login-enforcement/{name} | Create or update a login enforcement
*OpenbaoClient::IdentityApi* | [**oidc_configure**](docs/IdentityApi.md#oidc_configure) | **POST** /identity/oidc/config | 
*OpenbaoClient::IdentityApi* | [**oidc_delete_assignment**](docs/IdentityApi.md#oidc_delete_assignment) | **DELETE** /identity/oidc/assignment/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_delete_client**](docs/IdentityApi.md#oidc_delete_client) | **DELETE** /identity/oidc/client/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_delete_key**](docs/IdentityApi.md#oidc_delete_key) | **DELETE** /identity/oidc/key/{name} | CRUD operations for OIDC keys.
*OpenbaoClient::IdentityApi* | [**oidc_delete_provider**](docs/IdentityApi.md#oidc_delete_provider) | **DELETE** /identity/oidc/provider/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_delete_role**](docs/IdentityApi.md#oidc_delete_role) | **DELETE** /identity/oidc/role/{name} | CRUD operations on OIDC Roles
*OpenbaoClient::IdentityApi* | [**oidc_delete_scope**](docs/IdentityApi.md#oidc_delete_scope) | **DELETE** /identity/oidc/scope/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_generate_token**](docs/IdentityApi.md#oidc_generate_token) | **GET** /identity/oidc/token/{name} | Generate an OIDC token
*OpenbaoClient::IdentityApi* | [**oidc_introspect**](docs/IdentityApi.md#oidc_introspect) | **POST** /identity/oidc/introspect | Verify the authenticity of an OIDC token
*OpenbaoClient::IdentityApi* | [**oidc_list_assignments**](docs/IdentityApi.md#oidc_list_assignments) | **GET** /identity/oidc/assignment | 
*OpenbaoClient::IdentityApi* | [**oidc_list_clients**](docs/IdentityApi.md#oidc_list_clients) | **GET** /identity/oidc/client | 
*OpenbaoClient::IdentityApi* | [**oidc_list_keys**](docs/IdentityApi.md#oidc_list_keys) | **GET** /identity/oidc/key | List OIDC keys
*OpenbaoClient::IdentityApi* | [**oidc_list_providers**](docs/IdentityApi.md#oidc_list_providers) | **GET** /identity/oidc/provider | 
*OpenbaoClient::IdentityApi* | [**oidc_list_roles**](docs/IdentityApi.md#oidc_list_roles) | **GET** /identity/oidc/role | List configured OIDC roles
*OpenbaoClient::IdentityApi* | [**oidc_list_scopes**](docs/IdentityApi.md#oidc_list_scopes) | **GET** /identity/oidc/scope | 
*OpenbaoClient::IdentityApi* | [**oidc_provider_authorize**](docs/IdentityApi.md#oidc_provider_authorize) | **GET** /identity/oidc/provider/{name}/authorize | 
*OpenbaoClient::IdentityApi* | [**oidc_provider_authorize_with_parameters**](docs/IdentityApi.md#oidc_provider_authorize_with_parameters) | **POST** /identity/oidc/provider/{name}/authorize | 
*OpenbaoClient::IdentityApi* | [**oidc_provider_token**](docs/IdentityApi.md#oidc_provider_token) | **POST** /identity/oidc/provider/{name}/token | 
*OpenbaoClient::IdentityApi* | [**oidc_provider_user_info**](docs/IdentityApi.md#oidc_provider_user_info) | **GET** /identity/oidc/provider/{name}/userinfo | 
*OpenbaoClient::IdentityApi* | [**oidc_provider_user_info2**](docs/IdentityApi.md#oidc_provider_user_info2) | **POST** /identity/oidc/provider/{name}/userinfo | 
*OpenbaoClient::IdentityApi* | [**oidc_read_assignment**](docs/IdentityApi.md#oidc_read_assignment) | **GET** /identity/oidc/assignment/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_read_client**](docs/IdentityApi.md#oidc_read_client) | **GET** /identity/oidc/client/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_read_configuration**](docs/IdentityApi.md#oidc_read_configuration) | **GET** /identity/oidc/config | 
*OpenbaoClient::IdentityApi* | [**oidc_read_key**](docs/IdentityApi.md#oidc_read_key) | **GET** /identity/oidc/key/{name} | CRUD operations for OIDC keys.
*OpenbaoClient::IdentityApi* | [**oidc_read_open_id_configuration**](docs/IdentityApi.md#oidc_read_open_id_configuration) | **GET** /identity/oidc/.well-known/openid-configuration | Query OIDC configurations
*OpenbaoClient::IdentityApi* | [**oidc_read_provider**](docs/IdentityApi.md#oidc_read_provider) | **GET** /identity/oidc/provider/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_read_provider_open_id_configuration**](docs/IdentityApi.md#oidc_read_provider_open_id_configuration) | **GET** /identity/oidc/provider/{name}/.well-known/openid-configuration | 
*OpenbaoClient::IdentityApi* | [**oidc_read_provider_public_keys**](docs/IdentityApi.md#oidc_read_provider_public_keys) | **GET** /identity/oidc/provider/{name}/.well-known/keys | 
*OpenbaoClient::IdentityApi* | [**oidc_read_public_keys**](docs/IdentityApi.md#oidc_read_public_keys) | **GET** /identity/oidc/.well-known/keys | Retrieve public keys
*OpenbaoClient::IdentityApi* | [**oidc_read_role**](docs/IdentityApi.md#oidc_read_role) | **GET** /identity/oidc/role/{name} | CRUD operations on OIDC Roles
*OpenbaoClient::IdentityApi* | [**oidc_read_scope**](docs/IdentityApi.md#oidc_read_scope) | **GET** /identity/oidc/scope/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_rotate_key**](docs/IdentityApi.md#oidc_rotate_key) | **POST** /identity/oidc/key/{name}/rotate | Rotate a named OIDC key.
*OpenbaoClient::IdentityApi* | [**oidc_write_assignment**](docs/IdentityApi.md#oidc_write_assignment) | **POST** /identity/oidc/assignment/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_write_client**](docs/IdentityApi.md#oidc_write_client) | **POST** /identity/oidc/client/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_write_key**](docs/IdentityApi.md#oidc_write_key) | **POST** /identity/oidc/key/{name} | CRUD operations for OIDC keys.
*OpenbaoClient::IdentityApi* | [**oidc_write_provider**](docs/IdentityApi.md#oidc_write_provider) | **POST** /identity/oidc/provider/{name} | 
*OpenbaoClient::IdentityApi* | [**oidc_write_role**](docs/IdentityApi.md#oidc_write_role) | **POST** /identity/oidc/role/{name} | CRUD operations on OIDC Roles
*OpenbaoClient::IdentityApi* | [**oidc_write_scope**](docs/IdentityApi.md#oidc_write_scope) | **POST** /identity/oidc/scope/{name} | 
*OpenbaoClient::IdentityApi* | [**persona_create**](docs/IdentityApi.md#persona_create) | **POST** /identity/persona | Create a new alias.
*OpenbaoClient::IdentityApi* | [**persona_delete_by_id**](docs/IdentityApi.md#persona_delete_by_id) | **DELETE** /identity/persona/id/{id} | 
*OpenbaoClient::IdentityApi* | [**persona_list_by_id**](docs/IdentityApi.md#persona_list_by_id) | **GET** /identity/persona/id | List all the alias IDs.
*OpenbaoClient::IdentityApi* | [**persona_read_by_id**](docs/IdentityApi.md#persona_read_by_id) | **GET** /identity/persona/id/{id} | 
*OpenbaoClient::IdentityApi* | [**persona_update_by_id**](docs/IdentityApi.md#persona_update_by_id) | **POST** /identity/persona/id/{id} | 
*OpenbaoClient::SecretsApi* | [**cubbyhole_delete**](docs/SecretsApi.md#cubbyhole_delete) | **DELETE** /cubbyhole/{path} | Deletes the secret at the specified location.
*OpenbaoClient::SecretsApi* | [**cubbyhole_read**](docs/SecretsApi.md#cubbyhole_read) | **GET** /cubbyhole/{path} | Retrieve the secret at the specified location.
*OpenbaoClient::SecretsApi* | [**cubbyhole_write**](docs/SecretsApi.md#cubbyhole_write) | **POST** /cubbyhole/{path} | Store a secret at the specified location.
*OpenbaoClient::SecretsApi* | [**database_configure_connection**](docs/SecretsApi.md#database_configure_connection) | **POST** /{database_mount_path}/config/{name} | 
*OpenbaoClient::SecretsApi* | [**database_delete_connection_configuration**](docs/SecretsApi.md#database_delete_connection_configuration) | **DELETE** /{database_mount_path}/config/{name} | 
*OpenbaoClient::SecretsApi* | [**database_delete_role**](docs/SecretsApi.md#database_delete_role) | **DELETE** /{database_mount_path}/roles/{name} | Manage the roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**database_delete_static_role**](docs/SecretsApi.md#database_delete_static_role) | **DELETE** /{database_mount_path}/static-roles/{name} | Manage the static roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**database_generate_credentials**](docs/SecretsApi.md#database_generate_credentials) | **GET** /{database_mount_path}/creds/{name} | Request database credentials for a certain role.
*OpenbaoClient::SecretsApi* | [**database_list_connections**](docs/SecretsApi.md#database_list_connections) | **GET** /{database_mount_path}/config | Configure connection details to a database plugin.
*OpenbaoClient::SecretsApi* | [**database_list_roles**](docs/SecretsApi.md#database_list_roles) | **GET** /{database_mount_path}/roles | Manage the roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**database_list_static_roles**](docs/SecretsApi.md#database_list_static_roles) | **GET** /{database_mount_path}/static-roles | Manage the static roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**database_read_connection_configuration**](docs/SecretsApi.md#database_read_connection_configuration) | **GET** /{database_mount_path}/config/{name} | 
*OpenbaoClient::SecretsApi* | [**database_read_role**](docs/SecretsApi.md#database_read_role) | **GET** /{database_mount_path}/roles/{name} | Manage the roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**database_read_static_role**](docs/SecretsApi.md#database_read_static_role) | **GET** /{database_mount_path}/static-roles/{name} | Manage the static roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**database_read_static_role_credentials**](docs/SecretsApi.md#database_read_static_role_credentials) | **GET** /{database_mount_path}/static-creds/{name} | Request database credentials for a certain static role. These credentials are rotated periodically.
*OpenbaoClient::SecretsApi* | [**database_reset_connection**](docs/SecretsApi.md#database_reset_connection) | **POST** /{database_mount_path}/reset/{name} | Resets a database plugin.
*OpenbaoClient::SecretsApi* | [**database_rotate_root_credentials**](docs/SecretsApi.md#database_rotate_root_credentials) | **POST** /{database_mount_path}/rotate-root/{name} | 
*OpenbaoClient::SecretsApi* | [**database_rotate_static_role_credentials**](docs/SecretsApi.md#database_rotate_static_role_credentials) | **POST** /{database_mount_path}/rotate-role/{name} | 
*OpenbaoClient::SecretsApi* | [**database_write_role**](docs/SecretsApi.md#database_write_role) | **POST** /{database_mount_path}/roles/{name} | Manage the roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**database_write_static_role**](docs/SecretsApi.md#database_write_static_role) | **POST** /{database_mount_path}/static-roles/{name} | Manage the static roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**kubernetes_check_configuration**](docs/SecretsApi.md#kubernetes_check_configuration) | **GET** /{kubernetes_mount_path}/check | 
*OpenbaoClient::SecretsApi* | [**kubernetes_configure**](docs/SecretsApi.md#kubernetes_configure) | **POST** /{kubernetes_mount_path}/config | 
*OpenbaoClient::SecretsApi* | [**kubernetes_delete_configuration**](docs/SecretsApi.md#kubernetes_delete_configuration) | **DELETE** /{kubernetes_mount_path}/config | 
*OpenbaoClient::SecretsApi* | [**kubernetes_delete_role**](docs/SecretsApi.md#kubernetes_delete_role) | **DELETE** /{kubernetes_mount_path}/roles/{name} | 
*OpenbaoClient::SecretsApi* | [**kubernetes_generate_credentials**](docs/SecretsApi.md#kubernetes_generate_credentials) | **POST** /{kubernetes_mount_path}/creds/{name} | 
*OpenbaoClient::SecretsApi* | [**kubernetes_list_roles**](docs/SecretsApi.md#kubernetes_list_roles) | **GET** /{kubernetes_mount_path}/roles | 
*OpenbaoClient::SecretsApi* | [**kubernetes_read_configuration**](docs/SecretsApi.md#kubernetes_read_configuration) | **GET** /{kubernetes_mount_path}/config | 
*OpenbaoClient::SecretsApi* | [**kubernetes_read_role**](docs/SecretsApi.md#kubernetes_read_role) | **GET** /{kubernetes_mount_path}/roles/{name} | 
*OpenbaoClient::SecretsApi* | [**kubernetes_write_role**](docs/SecretsApi.md#kubernetes_write_role) | **POST** /{kubernetes_mount_path}/roles/{name} | 
*OpenbaoClient::SecretsApi* | [**kv_delete_data_path**](docs/SecretsApi.md#kv_delete_data_path) | **DELETE** /{kv_v2_mount_path}/data/{path} | Write, Patch, Read, and Delete data in the Key-Value Store.
*OpenbaoClient::SecretsApi* | [**kv_delete_metadata_path**](docs/SecretsApi.md#kv_delete_metadata_path) | **DELETE** /{kv_v2_mount_path}/metadata/{path} | Configures settings for the KV store
*OpenbaoClient::SecretsApi* | [**kv_delete_path**](docs/SecretsApi.md#kv_delete_path) | **DELETE** /{kv_v1_mount_path}/{path} | Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
*OpenbaoClient::SecretsApi* | [**kv_read_config**](docs/SecretsApi.md#kv_read_config) | **GET** /{kv_v2_mount_path}/config | Read the backend level settings.
*OpenbaoClient::SecretsApi* | [**kv_read_data_path**](docs/SecretsApi.md#kv_read_data_path) | **GET** /{kv_v2_mount_path}/data/{path} | Write, Patch, Read, and Delete data in the Key-Value Store.
*OpenbaoClient::SecretsApi* | [**kv_read_metadata_path**](docs/SecretsApi.md#kv_read_metadata_path) | **GET** /{kv_v2_mount_path}/metadata/{path} | Configures settings for the KV store
*OpenbaoClient::SecretsApi* | [**kv_read_path**](docs/SecretsApi.md#kv_read_path) | **GET** /{kv_v1_mount_path}/{path} | Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
*OpenbaoClient::SecretsApi* | [**kv_read_subkeys_path**](docs/SecretsApi.md#kv_read_subkeys_path) | **GET** /{kv_v2_mount_path}/subkeys/{path} | Read the structure of a secret entry from the Key-Value store with the values removed.
*OpenbaoClient::SecretsApi* | [**kv_write_config**](docs/SecretsApi.md#kv_write_config) | **POST** /{kv_v2_mount_path}/config | Configure backend level settings that are applied to every key in the key-value store.
*OpenbaoClient::SecretsApi* | [**kv_write_data_path**](docs/SecretsApi.md#kv_write_data_path) | **POST** /{kv_v2_mount_path}/data/{path} | Write, Patch, Read, and Delete data in the Key-Value Store.
*OpenbaoClient::SecretsApi* | [**kv_write_delete_path**](docs/SecretsApi.md#kv_write_delete_path) | **POST** /{kv_v2_mount_path}/delete/{path} | Marks one or more versions as deleted in the KV store.
*OpenbaoClient::SecretsApi* | [**kv_write_destroy_path**](docs/SecretsApi.md#kv_write_destroy_path) | **POST** /{kv_v2_mount_path}/destroy/{path} | Permanently removes one or more versions in the KV store
*OpenbaoClient::SecretsApi* | [**kv_write_metadata_path**](docs/SecretsApi.md#kv_write_metadata_path) | **POST** /{kv_v2_mount_path}/metadata/{path} | Configures settings for the KV store
*OpenbaoClient::SecretsApi* | [**kv_write_path**](docs/SecretsApi.md#kv_write_path) | **POST** /{kv_v1_mount_path}/{path} | Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
*OpenbaoClient::SecretsApi* | [**kv_write_undelete_path**](docs/SecretsApi.md#kv_write_undelete_path) | **POST** /{kv_v2_mount_path}/undelete/{path} | Undeletes one or more versions from the KV store.
*OpenbaoClient::SecretsApi* | [**ldap_configure**](docs/SecretsApi.md#ldap_configure) | **POST** /{ldap_mount_path}/config | 
*OpenbaoClient::SecretsApi* | [**ldap_delete_configuration**](docs/SecretsApi.md#ldap_delete_configuration) | **DELETE** /{ldap_mount_path}/config | 
*OpenbaoClient::SecretsApi* | [**ldap_delete_dynamic_role**](docs/SecretsApi.md#ldap_delete_dynamic_role) | **DELETE** /{ldap_mount_path}/role/{name} | 
*OpenbaoClient::SecretsApi* | [**ldap_delete_static_role**](docs/SecretsApi.md#ldap_delete_static_role) | **DELETE** /{ldap_mount_path}/static-role/{name} | 
*OpenbaoClient::SecretsApi* | [**ldap_library_check_in**](docs/SecretsApi.md#ldap_library_check_in) | **POST** /{ldap_mount_path}/library/{name}/check-in | Check service accounts in to the library.
*OpenbaoClient::SecretsApi* | [**ldap_library_check_out**](docs/SecretsApi.md#ldap_library_check_out) | **POST** /{ldap_mount_path}/library/{name}/check-out | Check a service account out from the library.
*OpenbaoClient::SecretsApi* | [**ldap_library_check_status**](docs/SecretsApi.md#ldap_library_check_status) | **GET** /{ldap_mount_path}/library/{name}/status | Check the status of the service accounts in a library set.
*OpenbaoClient::SecretsApi* | [**ldap_library_configure**](docs/SecretsApi.md#ldap_library_configure) | **POST** /{ldap_mount_path}/library/{name} | Update a library set.
*OpenbaoClient::SecretsApi* | [**ldap_library_delete**](docs/SecretsApi.md#ldap_library_delete) | **DELETE** /{ldap_mount_path}/library/{name} | Delete a library set.
*OpenbaoClient::SecretsApi* | [**ldap_library_force_check_in**](docs/SecretsApi.md#ldap_library_force_check_in) | **POST** /{ldap_mount_path}/library/manage/{name}/check-in | Check service accounts in to the library.
*OpenbaoClient::SecretsApi* | [**ldap_library_list**](docs/SecretsApi.md#ldap_library_list) | **GET** /{ldap_mount_path}/library | 
*OpenbaoClient::SecretsApi* | [**ldap_library_read**](docs/SecretsApi.md#ldap_library_read) | **GET** /{ldap_mount_path}/library/{name} | Read a library set.
*OpenbaoClient::SecretsApi* | [**ldap_list_dynamic_roles**](docs/SecretsApi.md#ldap_list_dynamic_roles) | **GET** /{ldap_mount_path}/role | 
*OpenbaoClient::SecretsApi* | [**ldap_list_static_roles**](docs/SecretsApi.md#ldap_list_static_roles) | **GET** /{ldap_mount_path}/static-role | 
*OpenbaoClient::SecretsApi* | [**ldap_read_configuration**](docs/SecretsApi.md#ldap_read_configuration) | **GET** /{ldap_mount_path}/config | 
*OpenbaoClient::SecretsApi* | [**ldap_read_dynamic_role**](docs/SecretsApi.md#ldap_read_dynamic_role) | **GET** /{ldap_mount_path}/role/{name} | 
*OpenbaoClient::SecretsApi* | [**ldap_read_static_role**](docs/SecretsApi.md#ldap_read_static_role) | **GET** /{ldap_mount_path}/static-role/{name} | 
*OpenbaoClient::SecretsApi* | [**ldap_request_dynamic_role_credentials**](docs/SecretsApi.md#ldap_request_dynamic_role_credentials) | **GET** /{ldap_mount_path}/creds/{name} | 
*OpenbaoClient::SecretsApi* | [**ldap_request_static_role_credentials**](docs/SecretsApi.md#ldap_request_static_role_credentials) | **GET** /{ldap_mount_path}/static-cred/{name} | 
*OpenbaoClient::SecretsApi* | [**ldap_rotate_root_credentials**](docs/SecretsApi.md#ldap_rotate_root_credentials) | **POST** /{ldap_mount_path}/rotate-root | 
*OpenbaoClient::SecretsApi* | [**ldap_rotate_static_role**](docs/SecretsApi.md#ldap_rotate_static_role) | **POST** /{ldap_mount_path}/rotate-role/{name} | 
*OpenbaoClient::SecretsApi* | [**ldap_write_dynamic_role**](docs/SecretsApi.md#ldap_write_dynamic_role) | **POST** /{ldap_mount_path}/role/{name} | 
*OpenbaoClient::SecretsApi* | [**ldap_write_static_role**](docs/SecretsApi.md#ldap_write_static_role) | **POST** /{ldap_mount_path}/static-role/{name} | 
*OpenbaoClient::SecretsApi* | [**pki_configure_acme**](docs/SecretsApi.md#pki_configure_acme) | **POST** /{pki_mount_path}/config/acme | 
*OpenbaoClient::SecretsApi* | [**pki_configure_auto_tidy**](docs/SecretsApi.md#pki_configure_auto_tidy) | **POST** /{pki_mount_path}/config/auto-tidy | 
*OpenbaoClient::SecretsApi* | [**pki_configure_ca**](docs/SecretsApi.md#pki_configure_ca) | **POST** /{pki_mount_path}/config/ca | 
*OpenbaoClient::SecretsApi* | [**pki_configure_cluster**](docs/SecretsApi.md#pki_configure_cluster) | **POST** /{pki_mount_path}/config/cluster | 
*OpenbaoClient::SecretsApi* | [**pki_configure_crl**](docs/SecretsApi.md#pki_configure_crl) | **POST** /{pki_mount_path}/config/crl | 
*OpenbaoClient::SecretsApi* | [**pki_configure_issuers**](docs/SecretsApi.md#pki_configure_issuers) | **POST** /{pki_mount_path}/config/issuers | 
*OpenbaoClient::SecretsApi* | [**pki_configure_keys**](docs/SecretsApi.md#pki_configure_keys) | **POST** /{pki_mount_path}/config/keys | 
*OpenbaoClient::SecretsApi* | [**pki_configure_urls**](docs/SecretsApi.md#pki_configure_urls) | **POST** /{pki_mount_path}/config/urls | 
*OpenbaoClient::SecretsApi* | [**pki_cross_sign_intermediate**](docs/SecretsApi.md#pki_cross_sign_intermediate) | **POST** /{pki_mount_path}/intermediate/cross-sign | 
*OpenbaoClient::SecretsApi* | [**pki_delete_eab_key**](docs/SecretsApi.md#pki_delete_eab_key) | **DELETE** /{pki_mount_path}/eab/{key_id} | 
*OpenbaoClient::SecretsApi* | [**pki_delete_issuer**](docs/SecretsApi.md#pki_delete_issuer) | **DELETE** /{pki_mount_path}/issuer/{issuer_ref} | 
*OpenbaoClient::SecretsApi* | [**pki_delete_key**](docs/SecretsApi.md#pki_delete_key) | **DELETE** /{pki_mount_path}/key/{key_ref} | 
*OpenbaoClient::SecretsApi* | [**pki_delete_role**](docs/SecretsApi.md#pki_delete_role) | **DELETE** /{pki_mount_path}/roles/{name} | 
*OpenbaoClient::SecretsApi* | [**pki_delete_root**](docs/SecretsApi.md#pki_delete_root) | **DELETE** /{pki_mount_path}/root | 
*OpenbaoClient::SecretsApi* | [**pki_generate_eab_key**](docs/SecretsApi.md#pki_generate_eab_key) | **POST** /{pki_mount_path}/acme/new-eab | 
*OpenbaoClient::SecretsApi* | [**pki_generate_eab_key_for_issuer**](docs/SecretsApi.md#pki_generate_eab_key_for_issuer) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/new-eab | 
*OpenbaoClient::SecretsApi* | [**pki_generate_eab_key_for_issuer_and_role**](docs/SecretsApi.md#pki_generate_eab_key_for_issuer_and_role) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/new-eab | 
*OpenbaoClient::SecretsApi* | [**pki_generate_eab_key_for_role**](docs/SecretsApi.md#pki_generate_eab_key_for_role) | **POST** /{pki_mount_path}/roles/{role}/acme/new-eab | 
*OpenbaoClient::SecretsApi* | [**pki_generate_exported_key**](docs/SecretsApi.md#pki_generate_exported_key) | **POST** /{pki_mount_path}/keys/generate/exported | 
*OpenbaoClient::SecretsApi* | [**pki_generate_intermediate**](docs/SecretsApi.md#pki_generate_intermediate) | **POST** /{pki_mount_path}/intermediate/generate/{exported} | 
*OpenbaoClient::SecretsApi* | [**pki_generate_internal_key**](docs/SecretsApi.md#pki_generate_internal_key) | **POST** /{pki_mount_path}/keys/generate/internal | 
*OpenbaoClient::SecretsApi* | [**pki_generate_kms_key**](docs/SecretsApi.md#pki_generate_kms_key) | **POST** /{pki_mount_path}/keys/generate/kms | 
*OpenbaoClient::SecretsApi* | [**pki_generate_root**](docs/SecretsApi.md#pki_generate_root) | **POST** /{pki_mount_path}/root/generate/{exported} | 
*OpenbaoClient::SecretsApi* | [**pki_import_key**](docs/SecretsApi.md#pki_import_key) | **POST** /{pki_mount_path}/keys/import | 
*OpenbaoClient::SecretsApi* | [**pki_issue_with_role**](docs/SecretsApi.md#pki_issue_with_role) | **POST** /{pki_mount_path}/issue/{role} | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_issue_with_role**](docs/SecretsApi.md#pki_issuer_issue_with_role) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/issue/{role} | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_read_crl**](docs/SecretsApi.md#pki_issuer_read_crl) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/crl | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_read_crl_delta**](docs/SecretsApi.md#pki_issuer_read_crl_delta) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/crl/delta | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_read_crl_delta_der**](docs/SecretsApi.md#pki_issuer_read_crl_delta_der) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/crl/delta/der | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_read_crl_delta_pem**](docs/SecretsApi.md#pki_issuer_read_crl_delta_pem) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/crl/delta/pem | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_read_crl_der**](docs/SecretsApi.md#pki_issuer_read_crl_der) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/crl/der | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_read_crl_pem**](docs/SecretsApi.md#pki_issuer_read_crl_pem) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/crl/pem | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_resign_crls**](docs/SecretsApi.md#pki_issuer_resign_crls) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/resign-crls | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_sign_intermediate**](docs/SecretsApi.md#pki_issuer_sign_intermediate) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/sign-intermediate | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_sign_revocation_list**](docs/SecretsApi.md#pki_issuer_sign_revocation_list) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/sign-revocation-list | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_sign_self_issued**](docs/SecretsApi.md#pki_issuer_sign_self_issued) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/sign-self-issued | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_sign_verbatim**](docs/SecretsApi.md#pki_issuer_sign_verbatim) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/sign-verbatim | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_sign_verbatim_with_role**](docs/SecretsApi.md#pki_issuer_sign_verbatim_with_role) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/sign-verbatim/{role} | 
*OpenbaoClient::SecretsApi* | [**pki_issuer_sign_with_role**](docs/SecretsApi.md#pki_issuer_sign_with_role) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/sign/{role} | 
*OpenbaoClient::SecretsApi* | [**pki_issuers_generate_intermediate**](docs/SecretsApi.md#pki_issuers_generate_intermediate) | **POST** /{pki_mount_path}/issuers/generate/intermediate/{exported} | 
*OpenbaoClient::SecretsApi* | [**pki_issuers_generate_root**](docs/SecretsApi.md#pki_issuers_generate_root) | **POST** /{pki_mount_path}/issuers/generate/root/{exported} | 
*OpenbaoClient::SecretsApi* | [**pki_issuers_import_bundle**](docs/SecretsApi.md#pki_issuers_import_bundle) | **POST** /{pki_mount_path}/issuers/import/bundle | 
*OpenbaoClient::SecretsApi* | [**pki_issuers_import_cert**](docs/SecretsApi.md#pki_issuers_import_cert) | **POST** /{pki_mount_path}/issuers/import/cert | 
*OpenbaoClient::SecretsApi* | [**pki_list_certs**](docs/SecretsApi.md#pki_list_certs) | **GET** /{pki_mount_path}/certs | 
*OpenbaoClient::SecretsApi* | [**pki_list_eab_keys**](docs/SecretsApi.md#pki_list_eab_keys) | **GET** /{pki_mount_path}/eab | 
*OpenbaoClient::SecretsApi* | [**pki_list_issuers**](docs/SecretsApi.md#pki_list_issuers) | **GET** /{pki_mount_path}/issuers | 
*OpenbaoClient::SecretsApi* | [**pki_list_keys**](docs/SecretsApi.md#pki_list_keys) | **GET** /{pki_mount_path}/keys | 
*OpenbaoClient::SecretsApi* | [**pki_list_revoked_certs**](docs/SecretsApi.md#pki_list_revoked_certs) | **GET** /{pki_mount_path}/certs/revoked | 
*OpenbaoClient::SecretsApi* | [**pki_list_roles**](docs/SecretsApi.md#pki_list_roles) | **GET** /{pki_mount_path}/roles | 
*OpenbaoClient::SecretsApi* | [**pki_query_ocsp**](docs/SecretsApi.md#pki_query_ocsp) | **POST** /{pki_mount_path}/ocsp | 
*OpenbaoClient::SecretsApi* | [**pki_query_ocsp_with_get_req**](docs/SecretsApi.md#pki_query_ocsp_with_get_req) | **GET** /{pki_mount_path}/ocsp/{req} | 
*OpenbaoClient::SecretsApi* | [**pki_read_acme_configuration**](docs/SecretsApi.md#pki_read_acme_configuration) | **GET** /{pki_mount_path}/config/acme | 
*OpenbaoClient::SecretsApi* | [**pki_read_acme_directory**](docs/SecretsApi.md#pki_read_acme_directory) | **GET** /{pki_mount_path}/acme/directory | 
*OpenbaoClient::SecretsApi* | [**pki_read_acme_new_nonce**](docs/SecretsApi.md#pki_read_acme_new_nonce) | **GET** /{pki_mount_path}/acme/new-nonce | 
*OpenbaoClient::SecretsApi* | [**pki_read_auto_tidy_configuration**](docs/SecretsApi.md#pki_read_auto_tidy_configuration) | **GET** /{pki_mount_path}/config/auto-tidy | 
*OpenbaoClient::SecretsApi* | [**pki_read_ca_chain_pem**](docs/SecretsApi.md#pki_read_ca_chain_pem) | **GET** /{pki_mount_path}/ca_chain | 
*OpenbaoClient::SecretsApi* | [**pki_read_ca_der**](docs/SecretsApi.md#pki_read_ca_der) | **GET** /{pki_mount_path}/ca | 
*OpenbaoClient::SecretsApi* | [**pki_read_ca_pem**](docs/SecretsApi.md#pki_read_ca_pem) | **GET** /{pki_mount_path}/ca/pem | 
*OpenbaoClient::SecretsApi* | [**pki_read_cert**](docs/SecretsApi.md#pki_read_cert) | **GET** /{pki_mount_path}/cert/{serial} | 
*OpenbaoClient::SecretsApi* | [**pki_read_cert_ca_chain**](docs/SecretsApi.md#pki_read_cert_ca_chain) | **GET** /{pki_mount_path}/cert/ca_chain | 
*OpenbaoClient::SecretsApi* | [**pki_read_cert_crl**](docs/SecretsApi.md#pki_read_cert_crl) | **GET** /{pki_mount_path}/cert/crl | 
*OpenbaoClient::SecretsApi* | [**pki_read_cert_delta_crl**](docs/SecretsApi.md#pki_read_cert_delta_crl) | **GET** /{pki_mount_path}/cert/delta-crl | 
*OpenbaoClient::SecretsApi* | [**pki_read_cert_raw_der**](docs/SecretsApi.md#pki_read_cert_raw_der) | **GET** /{pki_mount_path}/cert/{serial}/raw | 
*OpenbaoClient::SecretsApi* | [**pki_read_cert_raw_pem**](docs/SecretsApi.md#pki_read_cert_raw_pem) | **GET** /{pki_mount_path}/cert/{serial}/raw/pem | 
*OpenbaoClient::SecretsApi* | [**pki_read_cluster_configuration**](docs/SecretsApi.md#pki_read_cluster_configuration) | **GET** /{pki_mount_path}/config/cluster | 
*OpenbaoClient::SecretsApi* | [**pki_read_crl_configuration**](docs/SecretsApi.md#pki_read_crl_configuration) | **GET** /{pki_mount_path}/config/crl | 
*OpenbaoClient::SecretsApi* | [**pki_read_crl_delta**](docs/SecretsApi.md#pki_read_crl_delta) | **GET** /{pki_mount_path}/crl/delta | 
*OpenbaoClient::SecretsApi* | [**pki_read_crl_delta_pem**](docs/SecretsApi.md#pki_read_crl_delta_pem) | **GET** /{pki_mount_path}/crl/delta/pem | 
*OpenbaoClient::SecretsApi* | [**pki_read_crl_der**](docs/SecretsApi.md#pki_read_crl_der) | **GET** /{pki_mount_path}/crl | 
*OpenbaoClient::SecretsApi* | [**pki_read_crl_pem**](docs/SecretsApi.md#pki_read_crl_pem) | **GET** /{pki_mount_path}/crl/pem | 
*OpenbaoClient::SecretsApi* | [**pki_read_issuer**](docs/SecretsApi.md#pki_read_issuer) | **GET** /{pki_mount_path}/issuer/{issuer_ref} | 
*OpenbaoClient::SecretsApi* | [**pki_read_issuer_der**](docs/SecretsApi.md#pki_read_issuer_der) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/der | 
*OpenbaoClient::SecretsApi* | [**pki_read_issuer_issuer_ref_acme_directory**](docs/SecretsApi.md#pki_read_issuer_issuer_ref_acme_directory) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/acme/directory | 
*OpenbaoClient::SecretsApi* | [**pki_read_issuer_issuer_ref_acme_new_nonce**](docs/SecretsApi.md#pki_read_issuer_issuer_ref_acme_new_nonce) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/acme/new-nonce | 
*OpenbaoClient::SecretsApi* | [**pki_read_issuer_issuer_ref_roles_role_acme_directory**](docs/SecretsApi.md#pki_read_issuer_issuer_ref_roles_role_acme_directory) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/directory | 
*OpenbaoClient::SecretsApi* | [**pki_read_issuer_issuer_ref_roles_role_acme_new_nonce**](docs/SecretsApi.md#pki_read_issuer_issuer_ref_roles_role_acme_new_nonce) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/new-nonce | 
*OpenbaoClient::SecretsApi* | [**pki_read_issuer_json**](docs/SecretsApi.md#pki_read_issuer_json) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/json | 
*OpenbaoClient::SecretsApi* | [**pki_read_issuer_pem**](docs/SecretsApi.md#pki_read_issuer_pem) | **GET** /{pki_mount_path}/issuer/{issuer_ref}/pem | 
*OpenbaoClient::SecretsApi* | [**pki_read_issuers_configuration**](docs/SecretsApi.md#pki_read_issuers_configuration) | **GET** /{pki_mount_path}/config/issuers | 
*OpenbaoClient::SecretsApi* | [**pki_read_key**](docs/SecretsApi.md#pki_read_key) | **GET** /{pki_mount_path}/key/{key_ref} | 
*OpenbaoClient::SecretsApi* | [**pki_read_keys_configuration**](docs/SecretsApi.md#pki_read_keys_configuration) | **GET** /{pki_mount_path}/config/keys | 
*OpenbaoClient::SecretsApi* | [**pki_read_role**](docs/SecretsApi.md#pki_read_role) | **GET** /{pki_mount_path}/roles/{name} | 
*OpenbaoClient::SecretsApi* | [**pki_read_roles_role_acme_directory**](docs/SecretsApi.md#pki_read_roles_role_acme_directory) | **GET** /{pki_mount_path}/roles/{role}/acme/directory | 
*OpenbaoClient::SecretsApi* | [**pki_read_roles_role_acme_new_nonce**](docs/SecretsApi.md#pki_read_roles_role_acme_new_nonce) | **GET** /{pki_mount_path}/roles/{role}/acme/new-nonce | 
*OpenbaoClient::SecretsApi* | [**pki_read_urls_configuration**](docs/SecretsApi.md#pki_read_urls_configuration) | **GET** /{pki_mount_path}/config/urls | 
*OpenbaoClient::SecretsApi* | [**pki_replace_root**](docs/SecretsApi.md#pki_replace_root) | **POST** /{pki_mount_path}/root/replace | 
*OpenbaoClient::SecretsApi* | [**pki_revoke**](docs/SecretsApi.md#pki_revoke) | **POST** /{pki_mount_path}/revoke | 
*OpenbaoClient::SecretsApi* | [**pki_revoke_issuer**](docs/SecretsApi.md#pki_revoke_issuer) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/revoke | 
*OpenbaoClient::SecretsApi* | [**pki_revoke_with_key**](docs/SecretsApi.md#pki_revoke_with_key) | **POST** /{pki_mount_path}/revoke-with-key | 
*OpenbaoClient::SecretsApi* | [**pki_root_sign_intermediate**](docs/SecretsApi.md#pki_root_sign_intermediate) | **POST** /{pki_mount_path}/root/sign-intermediate | 
*OpenbaoClient::SecretsApi* | [**pki_root_sign_self_issued**](docs/SecretsApi.md#pki_root_sign_self_issued) | **POST** /{pki_mount_path}/root/sign-self-issued | 
*OpenbaoClient::SecretsApi* | [**pki_rotate_crl**](docs/SecretsApi.md#pki_rotate_crl) | **GET** /{pki_mount_path}/crl/rotate | 
*OpenbaoClient::SecretsApi* | [**pki_rotate_delta_crl**](docs/SecretsApi.md#pki_rotate_delta_crl) | **GET** /{pki_mount_path}/crl/rotate-delta | 
*OpenbaoClient::SecretsApi* | [**pki_rotate_root**](docs/SecretsApi.md#pki_rotate_root) | **POST** /{pki_mount_path}/root/rotate/{exported} | 
*OpenbaoClient::SecretsApi* | [**pki_set_signed_intermediate**](docs/SecretsApi.md#pki_set_signed_intermediate) | **POST** /{pki_mount_path}/intermediate/set-signed | 
*OpenbaoClient::SecretsApi* | [**pki_sign_verbatim**](docs/SecretsApi.md#pki_sign_verbatim) | **POST** /{pki_mount_path}/sign-verbatim | 
*OpenbaoClient::SecretsApi* | [**pki_sign_verbatim_with_role**](docs/SecretsApi.md#pki_sign_verbatim_with_role) | **POST** /{pki_mount_path}/sign-verbatim/{role} | 
*OpenbaoClient::SecretsApi* | [**pki_sign_with_role**](docs/SecretsApi.md#pki_sign_with_role) | **POST** /{pki_mount_path}/sign/{role} | 
*OpenbaoClient::SecretsApi* | [**pki_tidy**](docs/SecretsApi.md#pki_tidy) | **POST** /{pki_mount_path}/tidy | 
*OpenbaoClient::SecretsApi* | [**pki_tidy_cancel**](docs/SecretsApi.md#pki_tidy_cancel) | **POST** /{pki_mount_path}/tidy-cancel | 
*OpenbaoClient::SecretsApi* | [**pki_tidy_status**](docs/SecretsApi.md#pki_tidy_status) | **GET** /{pki_mount_path}/tidy-status | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_account_kid**](docs/SecretsApi.md#pki_write_acme_account_kid) | **POST** /{pki_mount_path}/acme/account/{kid} | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_authorization_auth_id**](docs/SecretsApi.md#pki_write_acme_authorization_auth_id) | **POST** /{pki_mount_path}/acme/authorization/{auth_id} | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_challenge_auth_id_challenge_type**](docs/SecretsApi.md#pki_write_acme_challenge_auth_id_challenge_type) | **POST** /{pki_mount_path}/acme/challenge/{auth_id}/{challenge_type} | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_new_account**](docs/SecretsApi.md#pki_write_acme_new_account) | **POST** /{pki_mount_path}/acme/new-account | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_new_order**](docs/SecretsApi.md#pki_write_acme_new_order) | **POST** /{pki_mount_path}/acme/new-order | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_order_order_id**](docs/SecretsApi.md#pki_write_acme_order_order_id) | **POST** /{pki_mount_path}/acme/order/{order_id} | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_order_order_id_cert**](docs/SecretsApi.md#pki_write_acme_order_order_id_cert) | **POST** /{pki_mount_path}/acme/order/{order_id}/cert | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_order_order_id_finalize**](docs/SecretsApi.md#pki_write_acme_order_order_id_finalize) | **POST** /{pki_mount_path}/acme/order/{order_id}/finalize | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_orders**](docs/SecretsApi.md#pki_write_acme_orders) | **POST** /{pki_mount_path}/acme/orders | 
*OpenbaoClient::SecretsApi* | [**pki_write_acme_revoke_cert**](docs/SecretsApi.md#pki_write_acme_revoke_cert) | **POST** /{pki_mount_path}/acme/revoke-cert | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer**](docs/SecretsApi.md#pki_write_issuer) | **POST** /{pki_mount_path}/issuer/{issuer_ref} | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_account_kid**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_account_kid) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/account/{kid} | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_authorization_auth_id**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_authorization_auth_id) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/authorization/{auth_id} | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/challenge/{auth_id}/{challenge_type} | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_new_account**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_new_account) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/new-account | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_new_order**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_new_order) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/new-order | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_order_order_id**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_order_order_id) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/order/{order_id} | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_order_order_id_cert**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_order_order_id_cert) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/order/{order_id}/cert | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_order_order_id_finalize**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_order_order_id_finalize) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/order/{order_id}/finalize | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_orders**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_orders) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/orders | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_acme_revoke_cert**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_acme_revoke_cert) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/acme/revoke-cert | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_account_kid**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_account_kid) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/account/{kid} | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/authorization/{auth_id} | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/challenge/{auth_id}/{challenge_type} | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_new_account**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_new_account) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/new-account | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_new_order**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_new_order) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/new-order | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_order_order_id**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_order_order_id) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/order/{order_id} | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/order/{order_id}/cert | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/order/{order_id}/finalize | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_orders**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_orders) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/orders | 
*OpenbaoClient::SecretsApi* | [**pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert**](docs/SecretsApi.md#pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert) | **POST** /{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/revoke-cert | 
*OpenbaoClient::SecretsApi* | [**pki_write_key**](docs/SecretsApi.md#pki_write_key) | **POST** /{pki_mount_path}/key/{key_ref} | 
*OpenbaoClient::SecretsApi* | [**pki_write_role**](docs/SecretsApi.md#pki_write_role) | **POST** /{pki_mount_path}/roles/{name} | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_account_kid**](docs/SecretsApi.md#pki_write_roles_role_acme_account_kid) | **POST** /{pki_mount_path}/roles/{role}/acme/account/{kid} | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_authorization_auth_id**](docs/SecretsApi.md#pki_write_roles_role_acme_authorization_auth_id) | **POST** /{pki_mount_path}/roles/{role}/acme/authorization/{auth_id} | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_challenge_auth_id_challenge_type**](docs/SecretsApi.md#pki_write_roles_role_acme_challenge_auth_id_challenge_type) | **POST** /{pki_mount_path}/roles/{role}/acme/challenge/{auth_id}/{challenge_type} | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_new_account**](docs/SecretsApi.md#pki_write_roles_role_acme_new_account) | **POST** /{pki_mount_path}/roles/{role}/acme/new-account | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_new_order**](docs/SecretsApi.md#pki_write_roles_role_acme_new_order) | **POST** /{pki_mount_path}/roles/{role}/acme/new-order | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_order_order_id**](docs/SecretsApi.md#pki_write_roles_role_acme_order_order_id) | **POST** /{pki_mount_path}/roles/{role}/acme/order/{order_id} | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_order_order_id_cert**](docs/SecretsApi.md#pki_write_roles_role_acme_order_order_id_cert) | **POST** /{pki_mount_path}/roles/{role}/acme/order/{order_id}/cert | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_order_order_id_finalize**](docs/SecretsApi.md#pki_write_roles_role_acme_order_order_id_finalize) | **POST** /{pki_mount_path}/roles/{role}/acme/order/{order_id}/finalize | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_orders**](docs/SecretsApi.md#pki_write_roles_role_acme_orders) | **POST** /{pki_mount_path}/roles/{role}/acme/orders | 
*OpenbaoClient::SecretsApi* | [**pki_write_roles_role_acme_revoke_cert**](docs/SecretsApi.md#pki_write_roles_role_acme_revoke_cert) | **POST** /{pki_mount_path}/roles/{role}/acme/revoke-cert | 
*OpenbaoClient::SecretsApi* | [**rabbit_mq_configure_connection**](docs/SecretsApi.md#rabbit_mq_configure_connection) | **POST** /{rabbitmq_mount_path}/config/connection | Configure the connection URI, username, and password to talk to RabbitMQ management HTTP API.
*OpenbaoClient::SecretsApi* | [**rabbit_mq_configure_lease**](docs/SecretsApi.md#rabbit_mq_configure_lease) | **POST** /{rabbitmq_mount_path}/config/lease | 
*OpenbaoClient::SecretsApi* | [**rabbit_mq_delete_role**](docs/SecretsApi.md#rabbit_mq_delete_role) | **DELETE** /{rabbitmq_mount_path}/roles/{name} | Manage the roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**rabbit_mq_list_roles**](docs/SecretsApi.md#rabbit_mq_list_roles) | **GET** /{rabbitmq_mount_path}/roles | Manage the roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**rabbit_mq_read_lease_configuration**](docs/SecretsApi.md#rabbit_mq_read_lease_configuration) | **GET** /{rabbitmq_mount_path}/config/lease | 
*OpenbaoClient::SecretsApi* | [**rabbit_mq_read_role**](docs/SecretsApi.md#rabbit_mq_read_role) | **GET** /{rabbitmq_mount_path}/roles/{name} | Manage the roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**rabbit_mq_request_credentials**](docs/SecretsApi.md#rabbit_mq_request_credentials) | **GET** /{rabbitmq_mount_path}/creds/{name} | Request RabbitMQ credentials for a certain role.
*OpenbaoClient::SecretsApi* | [**rabbit_mq_write_role**](docs/SecretsApi.md#rabbit_mq_write_role) | **POST** /{rabbitmq_mount_path}/roles/{name} | Manage the roles that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**ssh_configure_ca**](docs/SecretsApi.md#ssh_configure_ca) | **POST** /{ssh_mount_path}/config/ca | 
*OpenbaoClient::SecretsApi* | [**ssh_configure_zero_address**](docs/SecretsApi.md#ssh_configure_zero_address) | **POST** /{ssh_mount_path}/config/zeroaddress | 
*OpenbaoClient::SecretsApi* | [**ssh_delete_ca_configuration**](docs/SecretsApi.md#ssh_delete_ca_configuration) | **DELETE** /{ssh_mount_path}/config/ca | 
*OpenbaoClient::SecretsApi* | [**ssh_delete_role**](docs/SecretsApi.md#ssh_delete_role) | **DELETE** /{ssh_mount_path}/roles/{role} | Manage the 'roles' that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**ssh_delete_zero_address_configuration**](docs/SecretsApi.md#ssh_delete_zero_address_configuration) | **DELETE** /{ssh_mount_path}/config/zeroaddress | 
*OpenbaoClient::SecretsApi* | [**ssh_generate_credentials**](docs/SecretsApi.md#ssh_generate_credentials) | **POST** /{ssh_mount_path}/creds/{role} | Creates a credential for establishing SSH connection with the remote host.
*OpenbaoClient::SecretsApi* | [**ssh_issue_certificate**](docs/SecretsApi.md#ssh_issue_certificate) | **POST** /{ssh_mount_path}/issue/{role} | 
*OpenbaoClient::SecretsApi* | [**ssh_list_roles**](docs/SecretsApi.md#ssh_list_roles) | **GET** /{ssh_mount_path}/roles | Manage the 'roles' that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**ssh_list_roles_by_ip**](docs/SecretsApi.md#ssh_list_roles_by_ip) | **POST** /{ssh_mount_path}/lookup | List all the roles associated with the given IP address.
*OpenbaoClient::SecretsApi* | [**ssh_read_ca_configuration**](docs/SecretsApi.md#ssh_read_ca_configuration) | **GET** /{ssh_mount_path}/config/ca | 
*OpenbaoClient::SecretsApi* | [**ssh_read_public_key**](docs/SecretsApi.md#ssh_read_public_key) | **GET** /{ssh_mount_path}/public_key | Retrieve the public key.
*OpenbaoClient::SecretsApi* | [**ssh_read_role**](docs/SecretsApi.md#ssh_read_role) | **GET** /{ssh_mount_path}/roles/{role} | Manage the 'roles' that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**ssh_read_zero_address_configuration**](docs/SecretsApi.md#ssh_read_zero_address_configuration) | **GET** /{ssh_mount_path}/config/zeroaddress | 
*OpenbaoClient::SecretsApi* | [**ssh_sign_certificate**](docs/SecretsApi.md#ssh_sign_certificate) | **POST** /{ssh_mount_path}/sign/{role} | Request signing an SSH key using a certain role with the provided details.
*OpenbaoClient::SecretsApi* | [**ssh_tidy_dynamic_host_keys**](docs/SecretsApi.md#ssh_tidy_dynamic_host_keys) | **DELETE** /{ssh_mount_path}/tidy/dynamic-keys | This endpoint removes the stored host keys used for the removed Dynamic Key feature, if present.
*OpenbaoClient::SecretsApi* | [**ssh_verify_otp**](docs/SecretsApi.md#ssh_verify_otp) | **POST** /{ssh_mount_path}/verify | Validate the OTP provided by OpenBao SSH Agent.
*OpenbaoClient::SecretsApi* | [**ssh_write_role**](docs/SecretsApi.md#ssh_write_role) | **POST** /{ssh_mount_path}/roles/{role} | Manage the 'roles' that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**totp_create_key**](docs/SecretsApi.md#totp_create_key) | **POST** /{totp_mount_path}/keys/{name} | 
*OpenbaoClient::SecretsApi* | [**totp_delete_key**](docs/SecretsApi.md#totp_delete_key) | **DELETE** /{totp_mount_path}/keys/{name} | 
*OpenbaoClient::SecretsApi* | [**totp_generate_code**](docs/SecretsApi.md#totp_generate_code) | **GET** /{totp_mount_path}/code/{name} | 
*OpenbaoClient::SecretsApi* | [**totp_list_keys**](docs/SecretsApi.md#totp_list_keys) | **GET** /{totp_mount_path}/keys | Manage the keys that can be created with this backend.
*OpenbaoClient::SecretsApi* | [**totp_read_key**](docs/SecretsApi.md#totp_read_key) | **GET** /{totp_mount_path}/keys/{name} | 
*OpenbaoClient::SecretsApi* | [**totp_validate_code**](docs/SecretsApi.md#totp_validate_code) | **POST** /{totp_mount_path}/code/{name} | 
*OpenbaoClient::SecretsApi* | [**transit_back_up_key**](docs/SecretsApi.md#transit_back_up_key) | **GET** /{transit_mount_path}/backup/{name} | Backup the named key
*OpenbaoClient::SecretsApi* | [**transit_byok_key**](docs/SecretsApi.md#transit_byok_key) | **GET** /{transit_mount_path}/byok-export/{destination}/{source} | Securely export named encryption or signing key
*OpenbaoClient::SecretsApi* | [**transit_byok_key_version**](docs/SecretsApi.md#transit_byok_key_version) | **GET** /{transit_mount_path}/byok-export/{destination}/{source}/{version} | Securely export named encryption or signing key
*OpenbaoClient::SecretsApi* | [**transit_configure_cache**](docs/SecretsApi.md#transit_configure_cache) | **POST** /{transit_mount_path}/cache-config | Configures a new cache of the specified size
*OpenbaoClient::SecretsApi* | [**transit_configure_key**](docs/SecretsApi.md#transit_configure_key) | **POST** /{transit_mount_path}/keys/{name}/config | Configure a named encryption key
*OpenbaoClient::SecretsApi* | [**transit_configure_keys**](docs/SecretsApi.md#transit_configure_keys) | **POST** /{transit_mount_path}/config/keys | 
*OpenbaoClient::SecretsApi* | [**transit_create_key**](docs/SecretsApi.md#transit_create_key) | **POST** /{transit_mount_path}/keys/{name} | 
*OpenbaoClient::SecretsApi* | [**transit_decrypt**](docs/SecretsApi.md#transit_decrypt) | **POST** /{transit_mount_path}/decrypt/{name} | Decrypt a ciphertext value using a named key
*OpenbaoClient::SecretsApi* | [**transit_delete_key**](docs/SecretsApi.md#transit_delete_key) | **DELETE** /{transit_mount_path}/keys/{name} | 
*OpenbaoClient::SecretsApi* | [**transit_encrypt**](docs/SecretsApi.md#transit_encrypt) | **POST** /{transit_mount_path}/encrypt/{name} | Encrypt a plaintext value or a batch of plaintext blocks using a named key
*OpenbaoClient::SecretsApi* | [**transit_export_key**](docs/SecretsApi.md#transit_export_key) | **GET** /{transit_mount_path}/export/{type}/{name} | Export named encryption or signing key
*OpenbaoClient::SecretsApi* | [**transit_export_key_version**](docs/SecretsApi.md#transit_export_key_version) | **GET** /{transit_mount_path}/export/{type}/{name}/{version} | Export named encryption or signing key
*OpenbaoClient::SecretsApi* | [**transit_generate_data_key**](docs/SecretsApi.md#transit_generate_data_key) | **POST** /{transit_mount_path}/datakey/{plaintext}/{name} | Generate a data key
*OpenbaoClient::SecretsApi* | [**transit_generate_hmac**](docs/SecretsApi.md#transit_generate_hmac) | **POST** /{transit_mount_path}/hmac/{name} | Generate an HMAC for input data using the named key
*OpenbaoClient::SecretsApi* | [**transit_generate_hmac_with_algorithm**](docs/SecretsApi.md#transit_generate_hmac_with_algorithm) | **POST** /{transit_mount_path}/hmac/{name}/{urlalgorithm} | Generate an HMAC for input data using the named key
*OpenbaoClient::SecretsApi* | [**transit_generate_random**](docs/SecretsApi.md#transit_generate_random) | **POST** /{transit_mount_path}/random | Generate random bytes
*OpenbaoClient::SecretsApi* | [**transit_generate_random_with_bytes**](docs/SecretsApi.md#transit_generate_random_with_bytes) | **POST** /{transit_mount_path}/random/{urlbytes} | Generate random bytes
*OpenbaoClient::SecretsApi* | [**transit_generate_random_with_source**](docs/SecretsApi.md#transit_generate_random_with_source) | **POST** /{transit_mount_path}/random/{source} | Generate random bytes
*OpenbaoClient::SecretsApi* | [**transit_generate_random_with_source_and_bytes**](docs/SecretsApi.md#transit_generate_random_with_source_and_bytes) | **POST** /{transit_mount_path}/random/{source}/{urlbytes} | Generate random bytes
*OpenbaoClient::SecretsApi* | [**transit_hash**](docs/SecretsApi.md#transit_hash) | **POST** /{transit_mount_path}/hash | Generate a hash sum for input data
*OpenbaoClient::SecretsApi* | [**transit_hash_with_algorithm**](docs/SecretsApi.md#transit_hash_with_algorithm) | **POST** /{transit_mount_path}/hash/{urlalgorithm} | Generate a hash sum for input data
*OpenbaoClient::SecretsApi* | [**transit_import_key**](docs/SecretsApi.md#transit_import_key) | **POST** /{transit_mount_path}/keys/{name}/import | Imports an externally-generated key into a new transit key
*OpenbaoClient::SecretsApi* | [**transit_import_key_version**](docs/SecretsApi.md#transit_import_key_version) | **POST** /{transit_mount_path}/keys/{name}/import_version | Imports an externally-generated key into an existing imported key
*OpenbaoClient::SecretsApi* | [**transit_list_keys**](docs/SecretsApi.md#transit_list_keys) | **GET** /{transit_mount_path}/keys | Managed named encryption keys
*OpenbaoClient::SecretsApi* | [**transit_read_cache_configuration**](docs/SecretsApi.md#transit_read_cache_configuration) | **GET** /{transit_mount_path}/cache-config | Returns the size of the active cache
*OpenbaoClient::SecretsApi* | [**transit_read_key**](docs/SecretsApi.md#transit_read_key) | **GET** /{transit_mount_path}/keys/{name} | 
*OpenbaoClient::SecretsApi* | [**transit_read_keys_configuration**](docs/SecretsApi.md#transit_read_keys_configuration) | **GET** /{transit_mount_path}/config/keys | 
*OpenbaoClient::SecretsApi* | [**transit_read_wrapping_key**](docs/SecretsApi.md#transit_read_wrapping_key) | **GET** /{transit_mount_path}/wrapping_key | Returns the public key to use for wrapping imported keys
*OpenbaoClient::SecretsApi* | [**transit_restore_and_rename_key**](docs/SecretsApi.md#transit_restore_and_rename_key) | **POST** /{transit_mount_path}/restore/{name} | Restore the named key
*OpenbaoClient::SecretsApi* | [**transit_restore_key**](docs/SecretsApi.md#transit_restore_key) | **POST** /{transit_mount_path}/restore | Restore the named key
*OpenbaoClient::SecretsApi* | [**transit_rewrap**](docs/SecretsApi.md#transit_rewrap) | **POST** /{transit_mount_path}/rewrap/{name} | Rewrap ciphertext
*OpenbaoClient::SecretsApi* | [**transit_rotate_key**](docs/SecretsApi.md#transit_rotate_key) | **POST** /{transit_mount_path}/keys/{name}/rotate | Rotate named encryption key
*OpenbaoClient::SecretsApi* | [**transit_sign**](docs/SecretsApi.md#transit_sign) | **POST** /{transit_mount_path}/sign/{name} | Generate a signature for input data using the named key
*OpenbaoClient::SecretsApi* | [**transit_sign_with_algorithm**](docs/SecretsApi.md#transit_sign_with_algorithm) | **POST** /{transit_mount_path}/sign/{name}/{urlalgorithm} | Generate a signature for input data using the named key
*OpenbaoClient::SecretsApi* | [**transit_soft_delete_key**](docs/SecretsApi.md#transit_soft_delete_key) | **DELETE** /{transit_mount_path}/keys/{name}/soft-delete | 
*OpenbaoClient::SecretsApi* | [**transit_soft_delete_restore_key**](docs/SecretsApi.md#transit_soft_delete_restore_key) | **POST** /{transit_mount_path}/keys/{name}/soft-delete-restore | 
*OpenbaoClient::SecretsApi* | [**transit_trim_key**](docs/SecretsApi.md#transit_trim_key) | **POST** /{transit_mount_path}/keys/{name}/trim | Trim key versions of a named key
*OpenbaoClient::SecretsApi* | [**transit_verify**](docs/SecretsApi.md#transit_verify) | **POST** /{transit_mount_path}/verify/{name} | Verify a signature or HMAC for input data created using the named key
*OpenbaoClient::SecretsApi* | [**transit_verify_with_algorithm**](docs/SecretsApi.md#transit_verify_with_algorithm) | **POST** /{transit_mount_path}/verify/{name}/{urlalgorithm} | Verify a signature or HMAC for input data created using the named key
*OpenbaoClient::SystemApi* | [**auditing_calculate_hash**](docs/SystemApi.md#auditing_calculate_hash) | **POST** /sys/audit-hash/{path} | 
*OpenbaoClient::SystemApi* | [**auditing_disable_device**](docs/SystemApi.md#auditing_disable_device) | **DELETE** /sys/audit/{path} | Disable the audit device at the given path.
*OpenbaoClient::SystemApi* | [**auditing_disable_request_header**](docs/SystemApi.md#auditing_disable_request_header) | **DELETE** /sys/config/auditing/request-headers/{header} | Disable auditing of the given request header.
*OpenbaoClient::SystemApi* | [**auditing_enable_device**](docs/SystemApi.md#auditing_enable_device) | **POST** /sys/audit/{path} | Enable a new audit device at the supplied path.
*OpenbaoClient::SystemApi* | [**auditing_enable_request_header**](docs/SystemApi.md#auditing_enable_request_header) | **POST** /sys/config/auditing/request-headers/{header} | Enable auditing of a header.
*OpenbaoClient::SystemApi* | [**auditing_list_enabled_devices**](docs/SystemApi.md#auditing_list_enabled_devices) | **GET** /sys/audit | List the enabled audit devices.
*OpenbaoClient::SystemApi* | [**auditing_list_request_headers**](docs/SystemApi.md#auditing_list_request_headers) | **GET** /sys/config/auditing/request-headers | List the request headers that are configured to be audited.
*OpenbaoClient::SystemApi* | [**auditing_read_request_header_information**](docs/SystemApi.md#auditing_read_request_header_information) | **GET** /sys/config/auditing/request-headers/{header} | List the information for the given request header.
*OpenbaoClient::SystemApi* | [**auth_disable_method**](docs/SystemApi.md#auth_disable_method) | **DELETE** /sys/auth/{path} | Disable the auth method at the given auth path
*OpenbaoClient::SystemApi* | [**auth_enable_method**](docs/SystemApi.md#auth_enable_method) | **POST** /sys/auth/{path} | Enables a new auth method.
*OpenbaoClient::SystemApi* | [**auth_list_enabled_methods**](docs/SystemApi.md#auth_list_enabled_methods) | **GET** /sys/auth | 
*OpenbaoClient::SystemApi* | [**auth_read_configuration**](docs/SystemApi.md#auth_read_configuration) | **GET** /sys/auth/{path} | Read the configuration of the auth engine at the given path.
*OpenbaoClient::SystemApi* | [**auth_read_tuning_information**](docs/SystemApi.md#auth_read_tuning_information) | **GET** /sys/auth/{path}/tune | Reads the given auth path's configuration.
*OpenbaoClient::SystemApi* | [**auth_tune_configuration_parameters**](docs/SystemApi.md#auth_tune_configuration_parameters) | **POST** /sys/auth/{path}/tune | Tune configuration parameters for a given auth path.
*OpenbaoClient::SystemApi* | [**collect_host_information**](docs/SystemApi.md#collect_host_information) | **GET** /sys/host-info | Information about the host instance that this OpenBao server is running on.
*OpenbaoClient::SystemApi* | [**collect_in_flight_request_information**](docs/SystemApi.md#collect_in_flight_request_information) | **GET** /sys/in-flight-req | reports in-flight requests
*OpenbaoClient::SystemApi* | [**cors_configure**](docs/SystemApi.md#cors_configure) | **POST** /sys/config/cors | Configure the CORS settings.
*OpenbaoClient::SystemApi* | [**cors_delete_configuration**](docs/SystemApi.md#cors_delete_configuration) | **DELETE** /sys/config/cors | Remove any CORS settings.
*OpenbaoClient::SystemApi* | [**cors_read_configuration**](docs/SystemApi.md#cors_read_configuration) | **GET** /sys/config/cors | Return the current CORS settings.
*OpenbaoClient::SystemApi* | [**decode**](docs/SystemApi.md#decode) | **POST** /sys/decode-token | Decodes the encoded token with the otp.
*OpenbaoClient::SystemApi* | [**encryption_key_configure_rotation**](docs/SystemApi.md#encryption_key_configure_rotation) | **POST** /sys/rotate/config | 
*OpenbaoClient::SystemApi* | [**encryption_key_read_rotation_configuration**](docs/SystemApi.md#encryption_key_read_rotation_configuration) | **GET** /sys/rotate/config | 
*OpenbaoClient::SystemApi* | [**encryption_key_rotate**](docs/SystemApi.md#encryption_key_rotate) | **POST** /sys/rotate | 
*OpenbaoClient::SystemApi* | [**encryption_key_status**](docs/SystemApi.md#encryption_key_status) | **GET** /sys/key-status | Provides information about the backend encryption key.
*OpenbaoClient::SystemApi* | [**generate_hash**](docs/SystemApi.md#generate_hash) | **POST** /sys/tools/hash | 
*OpenbaoClient::SystemApi* | [**generate_hash_with_algorithm**](docs/SystemApi.md#generate_hash_with_algorithm) | **POST** /sys/tools/hash/{urlalgorithm} | 
*OpenbaoClient::SystemApi* | [**generate_random**](docs/SystemApi.md#generate_random) | **POST** /sys/tools/random | 
*OpenbaoClient::SystemApi* | [**generate_random_with_bytes**](docs/SystemApi.md#generate_random_with_bytes) | **POST** /sys/tools/random/{urlbytes} | 
*OpenbaoClient::SystemApi* | [**generate_random_with_source**](docs/SystemApi.md#generate_random_with_source) | **POST** /sys/tools/random/{source} | 
*OpenbaoClient::SystemApi* | [**generate_random_with_source_and_bytes**](docs/SystemApi.md#generate_random_with_source_and_bytes) | **POST** /sys/tools/random/{source}/{urlbytes} | 
*OpenbaoClient::SystemApi* | [**ha_status**](docs/SystemApi.md#ha_status) | **GET** /sys/ha-status | Check the HA status of an OpenBao cluster
*OpenbaoClient::SystemApi* | [**initialize**](docs/SystemApi.md#initialize) | **POST** /sys/init | Initialize a new OpenBao instance.
*OpenbaoClient::SystemApi* | [**internal_count_entities**](docs/SystemApi.md#internal_count_entities) | **GET** /sys/internal/counters/entities | Backwards compatibility is not guaranteed for this API
*OpenbaoClient::SystemApi* | [**internal_count_requests**](docs/SystemApi.md#internal_count_requests) | **GET** /sys/internal/counters/requests | Backwards compatibility is not guaranteed for this API
*OpenbaoClient::SystemApi* | [**internal_count_tokens**](docs/SystemApi.md#internal_count_tokens) | **GET** /sys/internal/counters/tokens | Backwards compatibility is not guaranteed for this API
*OpenbaoClient::SystemApi* | [**internal_generate_open_api_document**](docs/SystemApi.md#internal_generate_open_api_document) | **GET** /sys/internal/specs/openapi | 
*OpenbaoClient::SystemApi* | [**internal_generate_open_api_document_with_parameters**](docs/SystemApi.md#internal_generate_open_api_document_with_parameters) | **POST** /sys/internal/specs/openapi | 
*OpenbaoClient::SystemApi* | [**internal_inspect_router**](docs/SystemApi.md#internal_inspect_router) | **GET** /sys/internal/inspect/router/{tag} | Expose the route entry and mount entry tables present in the router
*OpenbaoClient::SystemApi* | [**internal_ui_list_enabled_feature_flags**](docs/SystemApi.md#internal_ui_list_enabled_feature_flags) | **GET** /sys/internal/ui/feature-flags | Lists enabled feature flags.
*OpenbaoClient::SystemApi* | [**internal_ui_list_enabled_visible_mounts**](docs/SystemApi.md#internal_ui_list_enabled_visible_mounts) | **GET** /sys/internal/ui/mounts | Lists all enabled and visible auth and secrets mounts.
*OpenbaoClient::SystemApi* | [**internal_ui_list_namespaces**](docs/SystemApi.md#internal_ui_list_namespaces) | **GET** /sys/internal/ui/namespaces | Backwards compatibility is not guaranteed for this API
*OpenbaoClient::SystemApi* | [**internal_ui_read_mount_information**](docs/SystemApi.md#internal_ui_read_mount_information) | **GET** /sys/internal/ui/mounts/{path} | Return information about the given mount.
*OpenbaoClient::SystemApi* | [**internal_ui_read_resultant_acl**](docs/SystemApi.md#internal_ui_read_resultant_acl) | **GET** /sys/internal/ui/resultant-acl | Backwards compatibility is not guaranteed for this API
*OpenbaoClient::SystemApi* | [**leader_status**](docs/SystemApi.md#leader_status) | **GET** /sys/leader | Returns the high availability status and current leader instance of OpenBao.
*OpenbaoClient::SystemApi* | [**leases_count**](docs/SystemApi.md#leases_count) | **GET** /sys/leases/count | 
*OpenbaoClient::SystemApi* | [**leases_force_revoke_lease_with_prefix**](docs/SystemApi.md#leases_force_revoke_lease_with_prefix) | **POST** /sys/leases/revoke-force/{prefix} | Revokes all secrets or tokens generated under a given prefix immediately
*OpenbaoClient::SystemApi* | [**leases_force_revoke_lease_with_prefix2**](docs/SystemApi.md#leases_force_revoke_lease_with_prefix2) | **POST** /sys/revoke-force/{prefix} | Revokes all secrets or tokens generated under a given prefix immediately
*OpenbaoClient::SystemApi* | [**leases_list**](docs/SystemApi.md#leases_list) | **GET** /sys/leases | 
*OpenbaoClient::SystemApi* | [**leases_look_up**](docs/SystemApi.md#leases_look_up) | **GET** /sys/leases/lookup/ | 
*OpenbaoClient::SystemApi* | [**leases_look_up_with_prefix**](docs/SystemApi.md#leases_look_up_with_prefix) | **GET** /sys/leases/lookup/{prefix} | 
*OpenbaoClient::SystemApi* | [**leases_read_lease**](docs/SystemApi.md#leases_read_lease) | **POST** /sys/leases/lookup | 
*OpenbaoClient::SystemApi* | [**leases_renew_lease**](docs/SystemApi.md#leases_renew_lease) | **POST** /sys/leases/renew | Renews a lease, requesting to extend the lease.
*OpenbaoClient::SystemApi* | [**leases_renew_lease2**](docs/SystemApi.md#leases_renew_lease2) | **POST** /sys/renew | Renews a lease, requesting to extend the lease.
*OpenbaoClient::SystemApi* | [**leases_renew_lease_with_id**](docs/SystemApi.md#leases_renew_lease_with_id) | **POST** /sys/leases/renew/{url_lease_id} | Renews a lease, requesting to extend the lease.
*OpenbaoClient::SystemApi* | [**leases_renew_lease_with_id2**](docs/SystemApi.md#leases_renew_lease_with_id2) | **POST** /sys/renew/{url_lease_id} | Renews a lease, requesting to extend the lease.
*OpenbaoClient::SystemApi* | [**leases_revoke_lease**](docs/SystemApi.md#leases_revoke_lease) | **POST** /sys/leases/revoke | Revokes a lease immediately.
*OpenbaoClient::SystemApi* | [**leases_revoke_lease2**](docs/SystemApi.md#leases_revoke_lease2) | **POST** /sys/revoke | Revokes a lease immediately.
*OpenbaoClient::SystemApi* | [**leases_revoke_lease_with_id**](docs/SystemApi.md#leases_revoke_lease_with_id) | **POST** /sys/leases/revoke/{url_lease_id} | Revokes a lease immediately.
*OpenbaoClient::SystemApi* | [**leases_revoke_lease_with_id2**](docs/SystemApi.md#leases_revoke_lease_with_id2) | **POST** /sys/revoke/{url_lease_id} | Revokes a lease immediately.
*OpenbaoClient::SystemApi* | [**leases_revoke_lease_with_prefix**](docs/SystemApi.md#leases_revoke_lease_with_prefix) | **POST** /sys/leases/revoke-prefix/{prefix} | Revokes all secrets (via a lease ID prefix) or tokens (via the tokens' path property) generated under a given prefix immediately.
*OpenbaoClient::SystemApi* | [**leases_revoke_lease_with_prefix2**](docs/SystemApi.md#leases_revoke_lease_with_prefix2) | **POST** /sys/revoke-prefix/{prefix} | Revokes all secrets (via a lease ID prefix) or tokens (via the tokens' path property) generated under a given prefix immediately.
*OpenbaoClient::SystemApi* | [**leases_tidy**](docs/SystemApi.md#leases_tidy) | **POST** /sys/leases/tidy | 
*OpenbaoClient::SystemApi* | [**locked_users_list**](docs/SystemApi.md#locked_users_list) | **GET** /sys/locked-users | Report the locked user count metrics, for this namespace and all child namespaces.
*OpenbaoClient::SystemApi* | [**locked_users_unlock**](docs/SystemApi.md#locked_users_unlock) | **POST** /sys/locked-users/{mount_accessor}/unlock/{alias_identifier} | Unlocks the user with given mount_accessor and alias_identifier
*OpenbaoClient::SystemApi* | [**loggers_read_verbosity_level**](docs/SystemApi.md#loggers_read_verbosity_level) | **GET** /sys/loggers | Read the log level for all existing loggers.
*OpenbaoClient::SystemApi* | [**loggers_read_verbosity_level_for**](docs/SystemApi.md#loggers_read_verbosity_level_for) | **GET** /sys/loggers/{name} | Read the log level for a single logger.
*OpenbaoClient::SystemApi* | [**loggers_revert_verbosity_level**](docs/SystemApi.md#loggers_revert_verbosity_level) | **DELETE** /sys/loggers | Revert the all loggers to use log level provided in config.
*OpenbaoClient::SystemApi* | [**loggers_revert_verbosity_level_for**](docs/SystemApi.md#loggers_revert_verbosity_level_for) | **DELETE** /sys/loggers/{name} | Revert a single logger to use log level provided in config.
*OpenbaoClient::SystemApi* | [**loggers_update_verbosity_level**](docs/SystemApi.md#loggers_update_verbosity_level) | **POST** /sys/loggers | Modify the log level for all existing loggers.
*OpenbaoClient::SystemApi* | [**loggers_update_verbosity_level_for**](docs/SystemApi.md#loggers_update_verbosity_level_for) | **POST** /sys/loggers/{name} | Modify the log level of a single logger.
*OpenbaoClient::SystemApi* | [**metrics**](docs/SystemApi.md#metrics) | **GET** /sys/metrics | 
*OpenbaoClient::SystemApi* | [**mfa_validate**](docs/SystemApi.md#mfa_validate) | **POST** /sys/mfa/validate | Validates the login for the given MFA methods. Upon successful validation, it returns an auth response containing the client token
*OpenbaoClient::SystemApi* | [**monitor**](docs/SystemApi.md#monitor) | **GET** /sys/monitor | 
*OpenbaoClient::SystemApi* | [**mounts_disable_secrets_engine**](docs/SystemApi.md#mounts_disable_secrets_engine) | **DELETE** /sys/mounts/{path} | Disable the mount point specified at the given path.
*OpenbaoClient::SystemApi* | [**mounts_enable_secrets_engine**](docs/SystemApi.md#mounts_enable_secrets_engine) | **POST** /sys/mounts/{path} | Enable a new secrets engine at the given path.
*OpenbaoClient::SystemApi* | [**mounts_list_secrets_engines**](docs/SystemApi.md#mounts_list_secrets_engines) | **GET** /sys/mounts | 
*OpenbaoClient::SystemApi* | [**mounts_read_configuration**](docs/SystemApi.md#mounts_read_configuration) | **GET** /sys/mounts/{path} | Read the configuration of the secret engine at the given path.
*OpenbaoClient::SystemApi* | [**mounts_read_tuning_information**](docs/SystemApi.md#mounts_read_tuning_information) | **GET** /sys/mounts/{path}/tune | 
*OpenbaoClient::SystemApi* | [**mounts_tune_configuration_parameters**](docs/SystemApi.md#mounts_tune_configuration_parameters) | **POST** /sys/mounts/{path}/tune | 
*OpenbaoClient::SystemApi* | [**plugins_catalog_list_plugins**](docs/SystemApi.md#plugins_catalog_list_plugins) | **GET** /sys/plugins/catalog | 
*OpenbaoClient::SystemApi* | [**plugins_catalog_list_plugins_with_type**](docs/SystemApi.md#plugins_catalog_list_plugins_with_type) | **GET** /sys/plugins/catalog/{type} | List the plugins in the catalog.
*OpenbaoClient::SystemApi* | [**plugins_catalog_read_plugin_configuration**](docs/SystemApi.md#plugins_catalog_read_plugin_configuration) | **GET** /sys/plugins/catalog/{name} | Return the configuration data for the plugin with the given name.
*OpenbaoClient::SystemApi* | [**plugins_catalog_read_plugin_configuration_with_type**](docs/SystemApi.md#plugins_catalog_read_plugin_configuration_with_type) | **GET** /sys/plugins/catalog/{type}/{name} | Return the configuration data for the plugin with the given name.
*OpenbaoClient::SystemApi* | [**plugins_catalog_register_plugin**](docs/SystemApi.md#plugins_catalog_register_plugin) | **POST** /sys/plugins/catalog/{name} | Register a new plugin, or updates an existing one with the supplied name.
*OpenbaoClient::SystemApi* | [**plugins_catalog_register_plugin_with_type**](docs/SystemApi.md#plugins_catalog_register_plugin_with_type) | **POST** /sys/plugins/catalog/{type}/{name} | Register a new plugin, or updates an existing one with the supplied name.
*OpenbaoClient::SystemApi* | [**plugins_catalog_remove_plugin**](docs/SystemApi.md#plugins_catalog_remove_plugin) | **DELETE** /sys/plugins/catalog/{name} | Remove the plugin with the given name.
*OpenbaoClient::SystemApi* | [**plugins_catalog_remove_plugin_with_type**](docs/SystemApi.md#plugins_catalog_remove_plugin_with_type) | **DELETE** /sys/plugins/catalog/{type}/{name} | Remove the plugin with the given name.
*OpenbaoClient::SystemApi* | [**plugins_reload_backends**](docs/SystemApi.md#plugins_reload_backends) | **POST** /sys/plugins/reload/backend | Reload mounted plugin backends.
*OpenbaoClient::SystemApi* | [**policies_delete_acl_policy**](docs/SystemApi.md#policies_delete_acl_policy) | **DELETE** /sys/policies/acl/{name} | Delete the ACL policy with the given name.
*OpenbaoClient::SystemApi* | [**policies_delete_acl_policy2**](docs/SystemApi.md#policies_delete_acl_policy2) | **DELETE** /sys/policy/{name} | Delete the policy with the given name.
*OpenbaoClient::SystemApi* | [**policies_delete_password_policy**](docs/SystemApi.md#policies_delete_password_policy) | **DELETE** /sys/policies/password/{name} | Delete a password policy.
*OpenbaoClient::SystemApi* | [**policies_generate_password_from_password_policy**](docs/SystemApi.md#policies_generate_password_from_password_policy) | **GET** /sys/policies/password/{name}/generate | Generate a password from an existing password policy.
*OpenbaoClient::SystemApi* | [**policies_list**](docs/SystemApi.md#policies_list) | **GET** /sys/policy | 
*OpenbaoClient::SystemApi* | [**policies_list_acl_policies**](docs/SystemApi.md#policies_list_acl_policies) | **GET** /sys/policies/acl | 
*OpenbaoClient::SystemApi* | [**policies_list_password_policies**](docs/SystemApi.md#policies_list_password_policies) | **GET** /sys/policies/password | List the existing password policies.
*OpenbaoClient::SystemApi* | [**policies_read_acl_policy**](docs/SystemApi.md#policies_read_acl_policy) | **GET** /sys/policies/acl/{name} | Retrieve information about the named ACL policy.
*OpenbaoClient::SystemApi* | [**policies_read_acl_policy2**](docs/SystemApi.md#policies_read_acl_policy2) | **GET** /sys/policy/{name} | Retrieve the policy body for the named policy.
*OpenbaoClient::SystemApi* | [**policies_read_password_policy**](docs/SystemApi.md#policies_read_password_policy) | **GET** /sys/policies/password/{name} | Retrieve an existing password policy.
*OpenbaoClient::SystemApi* | [**policies_write_acl_policy**](docs/SystemApi.md#policies_write_acl_policy) | **POST** /sys/policies/acl/{name} | Add a new or update an existing ACL policy.
*OpenbaoClient::SystemApi* | [**policies_write_acl_policy2**](docs/SystemApi.md#policies_write_acl_policy2) | **POST** /sys/policy/{name} | Add a new or update an existing policy.
*OpenbaoClient::SystemApi* | [**policies_write_password_policy**](docs/SystemApi.md#policies_write_password_policy) | **POST** /sys/policies/password/{name} | Add a new or update an existing password policy.
*OpenbaoClient::SystemApi* | [**pprof_blocking**](docs/SystemApi.md#pprof_blocking) | **GET** /sys/pprof/block | Returns stack traces that led to blocking on synchronization primitives
*OpenbaoClient::SystemApi* | [**pprof_command_line**](docs/SystemApi.md#pprof_command_line) | **GET** /sys/pprof/cmdline | Returns the running program's command line.
*OpenbaoClient::SystemApi* | [**pprof_cpu_profile**](docs/SystemApi.md#pprof_cpu_profile) | **GET** /sys/pprof/profile | Returns a pprof-formatted cpu profile payload.
*OpenbaoClient::SystemApi* | [**pprof_execution_trace**](docs/SystemApi.md#pprof_execution_trace) | **GET** /sys/pprof/trace | Returns the execution trace in binary form.
*OpenbaoClient::SystemApi* | [**pprof_goroutines**](docs/SystemApi.md#pprof_goroutines) | **GET** /sys/pprof/goroutine | Returns stack traces of all current goroutines.
*OpenbaoClient::SystemApi* | [**pprof_index**](docs/SystemApi.md#pprof_index) | **GET** /sys/pprof | Returns an HTML page listing the available profiles.
*OpenbaoClient::SystemApi* | [**pprof_memory_allocations**](docs/SystemApi.md#pprof_memory_allocations) | **GET** /sys/pprof/allocs | Returns a sampling of all past memory allocations.
*OpenbaoClient::SystemApi* | [**pprof_memory_allocations_live**](docs/SystemApi.md#pprof_memory_allocations_live) | **GET** /sys/pprof/heap | Returns a sampling of memory allocations of live object.
*OpenbaoClient::SystemApi* | [**pprof_mutexes**](docs/SystemApi.md#pprof_mutexes) | **GET** /sys/pprof/mutex | Returns stack traces of holders of contended mutexes
*OpenbaoClient::SystemApi* | [**pprof_symbols**](docs/SystemApi.md#pprof_symbols) | **GET** /sys/pprof/symbol | Returns the program counters listed in the request.
*OpenbaoClient::SystemApi* | [**pprof_thread_creations**](docs/SystemApi.md#pprof_thread_creations) | **GET** /sys/pprof/threadcreate | Returns stack traces that led to the creation of new OS threads
*OpenbaoClient::SystemApi* | [**query_token_accessor_capabilities**](docs/SystemApi.md#query_token_accessor_capabilities) | **POST** /sys/capabilities-accessor | 
*OpenbaoClient::SystemApi* | [**query_token_capabilities**](docs/SystemApi.md#query_token_capabilities) | **POST** /sys/capabilities | 
*OpenbaoClient::SystemApi* | [**query_token_self_capabilities**](docs/SystemApi.md#query_token_self_capabilities) | **POST** /sys/capabilities-self | 
*OpenbaoClient::SystemApi* | [**rate_limit_quotas_configure**](docs/SystemApi.md#rate_limit_quotas_configure) | **POST** /sys/quotas/config | 
*OpenbaoClient::SystemApi* | [**rate_limit_quotas_delete**](docs/SystemApi.md#rate_limit_quotas_delete) | **DELETE** /sys/quotas/rate-limit/{name} | 
*OpenbaoClient::SystemApi* | [**rate_limit_quotas_list**](docs/SystemApi.md#rate_limit_quotas_list) | **GET** /sys/quotas/rate-limit | 
*OpenbaoClient::SystemApi* | [**rate_limit_quotas_read**](docs/SystemApi.md#rate_limit_quotas_read) | **GET** /sys/quotas/rate-limit/{name} | 
*OpenbaoClient::SystemApi* | [**rate_limit_quotas_read_configuration**](docs/SystemApi.md#rate_limit_quotas_read_configuration) | **GET** /sys/quotas/config | 
*OpenbaoClient::SystemApi* | [**rate_limit_quotas_write**](docs/SystemApi.md#rate_limit_quotas_write) | **POST** /sys/quotas/rate-limit/{name} | 
*OpenbaoClient::SystemApi* | [**raw_delete**](docs/SystemApi.md#raw_delete) | **DELETE** /sys/raw | Delete the key with given path.
*OpenbaoClient::SystemApi* | [**raw_delete_path**](docs/SystemApi.md#raw_delete_path) | **DELETE** /sys/raw/{path} | Delete the key with given path.
*OpenbaoClient::SystemApi* | [**raw_read**](docs/SystemApi.md#raw_read) | **GET** /sys/raw | Read the value of the key at the given path.
*OpenbaoClient::SystemApi* | [**raw_read_path**](docs/SystemApi.md#raw_read_path) | **GET** /sys/raw/{path} | Read the value of the key at the given path.
*OpenbaoClient::SystemApi* | [**raw_write**](docs/SystemApi.md#raw_write) | **POST** /sys/raw | Update the value of the key at the given path.
*OpenbaoClient::SystemApi* | [**raw_write_path**](docs/SystemApi.md#raw_write_path) | **POST** /sys/raw/{path} | Update the value of the key at the given path.
*OpenbaoClient::SystemApi* | [**read_health_status**](docs/SystemApi.md#read_health_status) | **GET** /sys/health | Returns the health status of OpenBao.
*OpenbaoClient::SystemApi* | [**read_initialization_status**](docs/SystemApi.md#read_initialization_status) | **GET** /sys/init | Returns the initialization status of OpenBao.
*OpenbaoClient::SystemApi* | [**read_sanitized_configuration_state**](docs/SystemApi.md#read_sanitized_configuration_state) | **GET** /sys/config/state/sanitized | Return a sanitized version of the OpenBao server configuration.
*OpenbaoClient::SystemApi* | [**read_wrapping_properties**](docs/SystemApi.md#read_wrapping_properties) | **POST** /sys/wrapping/lookup | Look up wrapping properties for the given token.
*OpenbaoClient::SystemApi* | [**read_wrapping_properties2**](docs/SystemApi.md#read_wrapping_properties2) | **GET** /sys/wrapping/lookup | Look up wrapping properties for the requester's token.
*OpenbaoClient::SystemApi* | [**rekey_attempt_cancel**](docs/SystemApi.md#rekey_attempt_cancel) | **DELETE** /sys/rekey/init | Cancels any in-progress rekey.
*OpenbaoClient::SystemApi* | [**rekey_attempt_initialize**](docs/SystemApi.md#rekey_attempt_initialize) | **POST** /sys/rekey/init | Initializes a new rekey attempt.
*OpenbaoClient::SystemApi* | [**rekey_attempt_read_progress**](docs/SystemApi.md#rekey_attempt_read_progress) | **GET** /sys/rekey/init | Reads the configuration and progress of the current rekey attempt.
*OpenbaoClient::SystemApi* | [**rekey_attempt_update**](docs/SystemApi.md#rekey_attempt_update) | **POST** /sys/rekey/update | Enter a single unseal key share to progress the rekey of the OpenBao.
*OpenbaoClient::SystemApi* | [**rekey_delete_backup_key**](docs/SystemApi.md#rekey_delete_backup_key) | **DELETE** /sys/rekey/backup | Delete the backup copy of PGP-encrypted unseal keys.
*OpenbaoClient::SystemApi* | [**rekey_delete_backup_recovery_key**](docs/SystemApi.md#rekey_delete_backup_recovery_key) | **DELETE** /sys/rekey/recovery-key-backup | 
*OpenbaoClient::SystemApi* | [**rekey_read_backup_key**](docs/SystemApi.md#rekey_read_backup_key) | **GET** /sys/rekey/backup | Return the backup copy of PGP-encrypted unseal keys.
*OpenbaoClient::SystemApi* | [**rekey_read_backup_recovery_key**](docs/SystemApi.md#rekey_read_backup_recovery_key) | **GET** /sys/rekey/recovery-key-backup | 
*OpenbaoClient::SystemApi* | [**rekey_verification_cancel**](docs/SystemApi.md#rekey_verification_cancel) | **DELETE** /sys/rekey/verify | Cancel any in-progress rekey verification operation.
*OpenbaoClient::SystemApi* | [**rekey_verification_read_progress**](docs/SystemApi.md#rekey_verification_read_progress) | **GET** /sys/rekey/verify | Read the configuration and progress of the current rekey verification attempt.
*OpenbaoClient::SystemApi* | [**rekey_verification_update**](docs/SystemApi.md#rekey_verification_update) | **POST** /sys/rekey/verify | Enter a single new key share to progress the rekey verification operation.
*OpenbaoClient::SystemApi* | [**reload_subsystem**](docs/SystemApi.md#reload_subsystem) | **POST** /sys/config/reload/{subsystem} | Reload the given subsystem
*OpenbaoClient::SystemApi* | [**remount**](docs/SystemApi.md#remount) | **POST** /sys/remount | Initiate a mount migration
*OpenbaoClient::SystemApi* | [**remount_status**](docs/SystemApi.md#remount_status) | **GET** /sys/remount/status/{migration_id} | Check status of a mount migration
*OpenbaoClient::SystemApi* | [**rewrap**](docs/SystemApi.md#rewrap) | **POST** /sys/wrapping/rewrap | 
*OpenbaoClient::SystemApi* | [**root_token_generation_cancel**](docs/SystemApi.md#root_token_generation_cancel) | **DELETE** /sys/generate-root/attempt | Cancels any in-progress root generation attempt.
*OpenbaoClient::SystemApi* | [**root_token_generation_cancel2**](docs/SystemApi.md#root_token_generation_cancel2) | **DELETE** /sys/generate-root | Cancels any in-progress root generation attempt.
*OpenbaoClient::SystemApi* | [**root_token_generation_initialize**](docs/SystemApi.md#root_token_generation_initialize) | **POST** /sys/generate-root/attempt | Initializes a new root generation attempt.
*OpenbaoClient::SystemApi* | [**root_token_generation_initialize2**](docs/SystemApi.md#root_token_generation_initialize2) | **POST** /sys/generate-root | Initializes a new root generation attempt.
*OpenbaoClient::SystemApi* | [**root_token_generation_read_progress**](docs/SystemApi.md#root_token_generation_read_progress) | **GET** /sys/generate-root/attempt | Read the configuration and progress of the current root generation attempt.
*OpenbaoClient::SystemApi* | [**root_token_generation_read_progress2**](docs/SystemApi.md#root_token_generation_read_progress2) | **GET** /sys/generate-root | Read the configuration and progress of the current root generation attempt.
*OpenbaoClient::SystemApi* | [**root_token_generation_update**](docs/SystemApi.md#root_token_generation_update) | **POST** /sys/generate-root/update | Enter a single unseal key share to progress the root generation attempt.
*OpenbaoClient::SystemApi* | [**seal**](docs/SystemApi.md#seal) | **POST** /sys/seal | Seal the OpenBao instance.
*OpenbaoClient::SystemApi* | [**seal_status**](docs/SystemApi.md#seal_status) | **GET** /sys/seal-status | Check the seal status of an OpenBao instance.
*OpenbaoClient::SystemApi* | [**step_down_leader**](docs/SystemApi.md#step_down_leader) | **POST** /sys/step-down | Cause the node to give up active status.
*OpenbaoClient::SystemApi* | [**ui_headers_configure**](docs/SystemApi.md#ui_headers_configure) | **POST** /sys/config/ui/headers/{header} | Configure the values to be returned for the UI header.
*OpenbaoClient::SystemApi* | [**ui_headers_delete_configuration**](docs/SystemApi.md#ui_headers_delete_configuration) | **DELETE** /sys/config/ui/headers/{header} | Remove a UI header.
*OpenbaoClient::SystemApi* | [**ui_headers_list**](docs/SystemApi.md#ui_headers_list) | **GET** /sys/config/ui/headers | Return a list of configured UI headers.
*OpenbaoClient::SystemApi* | [**ui_headers_read_configuration**](docs/SystemApi.md#ui_headers_read_configuration) | **GET** /sys/config/ui/headers/{header} | Return the given UI header's configuration
*OpenbaoClient::SystemApi* | [**unseal**](docs/SystemApi.md#unseal) | **POST** /sys/unseal | Unseal the OpenBao instance.
*OpenbaoClient::SystemApi* | [**unwrap**](docs/SystemApi.md#unwrap) | **POST** /sys/wrapping/unwrap | 
*OpenbaoClient::SystemApi* | [**version_history**](docs/SystemApi.md#version_history) | **GET** /sys/version-history | Returns map of historical version change entries
*OpenbaoClient::SystemApi* | [**wrap**](docs/SystemApi.md#wrap) | **POST** /sys/wrapping/wrap | 


## Documentation for Models

 - [OpenbaoClient::AliasCreateRequest](docs/AliasCreateRequest.md)
 - [OpenbaoClient::AliasUpdateByIdRequest](docs/AliasUpdateByIdRequest.md)
 - [OpenbaoClient::AppRoleDestroySecretIdByAccessorRequest](docs/AppRoleDestroySecretIdByAccessorRequest.md)
 - [OpenbaoClient::AppRoleDestroySecretIdRequest](docs/AppRoleDestroySecretIdRequest.md)
 - [OpenbaoClient::AppRoleListRolesResponse](docs/AppRoleListRolesResponse.md)
 - [OpenbaoClient::AppRoleListSecretIdsResponse](docs/AppRoleListSecretIdsResponse.md)
 - [OpenbaoClient::AppRoleLoginRequest](docs/AppRoleLoginRequest.md)
 - [OpenbaoClient::AppRoleLoginResponse](docs/AppRoleLoginResponse.md)
 - [OpenbaoClient::AppRoleLookUpSecretIdByAccessorRequest](docs/AppRoleLookUpSecretIdByAccessorRequest.md)
 - [OpenbaoClient::AppRoleLookUpSecretIdByAccessorResponse](docs/AppRoleLookUpSecretIdByAccessorResponse.md)
 - [OpenbaoClient::AppRoleLookUpSecretIdRequest](docs/AppRoleLookUpSecretIdRequest.md)
 - [OpenbaoClient::AppRoleLookUpSecretIdResponse](docs/AppRoleLookUpSecretIdResponse.md)
 - [OpenbaoClient::AppRoleReadBindSecretIdResponse](docs/AppRoleReadBindSecretIdResponse.md)
 - [OpenbaoClient::AppRoleReadBoundCidrListResponse](docs/AppRoleReadBoundCidrListResponse.md)
 - [OpenbaoClient::AppRoleReadLocalSecretIdsResponse](docs/AppRoleReadLocalSecretIdsResponse.md)
 - [OpenbaoClient::AppRoleReadPeriodResponse](docs/AppRoleReadPeriodResponse.md)
 - [OpenbaoClient::AppRoleReadPoliciesResponse](docs/AppRoleReadPoliciesResponse.md)
 - [OpenbaoClient::AppRoleReadRoleIdResponse](docs/AppRoleReadRoleIdResponse.md)
 - [OpenbaoClient::AppRoleReadRoleResponse](docs/AppRoleReadRoleResponse.md)
 - [OpenbaoClient::AppRoleReadSecretIdBoundCidrsResponse](docs/AppRoleReadSecretIdBoundCidrsResponse.md)
 - [OpenbaoClient::AppRoleReadSecretIdNumUsesResponse](docs/AppRoleReadSecretIdNumUsesResponse.md)
 - [OpenbaoClient::AppRoleReadSecretIdTtlResponse](docs/AppRoleReadSecretIdTtlResponse.md)
 - [OpenbaoClient::AppRoleReadTokenBoundCidrsResponse](docs/AppRoleReadTokenBoundCidrsResponse.md)
 - [OpenbaoClient::AppRoleReadTokenMaxTtlResponse](docs/AppRoleReadTokenMaxTtlResponse.md)
 - [OpenbaoClient::AppRoleReadTokenNumUsesResponse](docs/AppRoleReadTokenNumUsesResponse.md)
 - [OpenbaoClient::AppRoleReadTokenTtlResponse](docs/AppRoleReadTokenTtlResponse.md)
 - [OpenbaoClient::AppRoleWriteBindSecretIdRequest](docs/AppRoleWriteBindSecretIdRequest.md)
 - [OpenbaoClient::AppRoleWriteBoundCidrListRequest](docs/AppRoleWriteBoundCidrListRequest.md)
 - [OpenbaoClient::AppRoleWriteCustomSecretIdRequest](docs/AppRoleWriteCustomSecretIdRequest.md)
 - [OpenbaoClient::AppRoleWriteCustomSecretIdResponse](docs/AppRoleWriteCustomSecretIdResponse.md)
 - [OpenbaoClient::AppRoleWritePeriodRequest](docs/AppRoleWritePeriodRequest.md)
 - [OpenbaoClient::AppRoleWritePoliciesRequest](docs/AppRoleWritePoliciesRequest.md)
 - [OpenbaoClient::AppRoleWriteRoleIdRequest](docs/AppRoleWriteRoleIdRequest.md)
 - [OpenbaoClient::AppRoleWriteRoleRequest](docs/AppRoleWriteRoleRequest.md)
 - [OpenbaoClient::AppRoleWriteSecretIdBoundCidrsRequest](docs/AppRoleWriteSecretIdBoundCidrsRequest.md)
 - [OpenbaoClient::AppRoleWriteSecretIdNumUsesRequest](docs/AppRoleWriteSecretIdNumUsesRequest.md)
 - [OpenbaoClient::AppRoleWriteSecretIdRequest](docs/AppRoleWriteSecretIdRequest.md)
 - [OpenbaoClient::AppRoleWriteSecretIdResponse](docs/AppRoleWriteSecretIdResponse.md)
 - [OpenbaoClient::AppRoleWriteSecretIdTtlRequest](docs/AppRoleWriteSecretIdTtlRequest.md)
 - [OpenbaoClient::AppRoleWriteTokenBoundCidrsRequest](docs/AppRoleWriteTokenBoundCidrsRequest.md)
 - [OpenbaoClient::AppRoleWriteTokenMaxTtlRequest](docs/AppRoleWriteTokenMaxTtlRequest.md)
 - [OpenbaoClient::AppRoleWriteTokenNumUsesRequest](docs/AppRoleWriteTokenNumUsesRequest.md)
 - [OpenbaoClient::AppRoleWriteTokenTtlRequest](docs/AppRoleWriteTokenTtlRequest.md)
 - [OpenbaoClient::AuditingCalculateHashRequest](docs/AuditingCalculateHashRequest.md)
 - [OpenbaoClient::AuditingCalculateHashResponse](docs/AuditingCalculateHashResponse.md)
 - [OpenbaoClient::AuditingEnableDeviceRequest](docs/AuditingEnableDeviceRequest.md)
 - [OpenbaoClient::AuditingEnableRequestHeaderRequest](docs/AuditingEnableRequestHeaderRequest.md)
 - [OpenbaoClient::AuditingListRequestHeadersResponse](docs/AuditingListRequestHeadersResponse.md)
 - [OpenbaoClient::AuthEnableMethodRequest](docs/AuthEnableMethodRequest.md)
 - [OpenbaoClient::AuthReadConfigurationResponse](docs/AuthReadConfigurationResponse.md)
 - [OpenbaoClient::AuthReadTuningInformationResponse](docs/AuthReadTuningInformationResponse.md)
 - [OpenbaoClient::AuthTuneConfigurationParametersRequest](docs/AuthTuneConfigurationParametersRequest.md)
 - [OpenbaoClient::CertConfigureRequest](docs/CertConfigureRequest.md)
 - [OpenbaoClient::CertLoginRequest](docs/CertLoginRequest.md)
 - [OpenbaoClient::CertWriteCertificateRequest](docs/CertWriteCertificateRequest.md)
 - [OpenbaoClient::CertWriteCrlRequest](docs/CertWriteCrlRequest.md)
 - [OpenbaoClient::CollectHostInformationResponse](docs/CollectHostInformationResponse.md)
 - [OpenbaoClient::CorsConfigureRequest](docs/CorsConfigureRequest.md)
 - [OpenbaoClient::CorsReadConfigurationResponse](docs/CorsReadConfigurationResponse.md)
 - [OpenbaoClient::DatabaseConfigureConnectionRequest](docs/DatabaseConfigureConnectionRequest.md)
 - [OpenbaoClient::DatabaseWriteRoleRequest](docs/DatabaseWriteRoleRequest.md)
 - [OpenbaoClient::DatabaseWriteStaticRoleRequest](docs/DatabaseWriteStaticRoleRequest.md)
 - [OpenbaoClient::DecodeRequest](docs/DecodeRequest.md)
 - [OpenbaoClient::EncryptionKeyConfigureRotationRequest](docs/EncryptionKeyConfigureRotationRequest.md)
 - [OpenbaoClient::EncryptionKeyReadRotationConfigurationResponse](docs/EncryptionKeyReadRotationConfigurationResponse.md)
 - [OpenbaoClient::EntityBatchDeleteRequest](docs/EntityBatchDeleteRequest.md)
 - [OpenbaoClient::EntityCreateAliasRequest](docs/EntityCreateAliasRequest.md)
 - [OpenbaoClient::EntityCreateRequest](docs/EntityCreateRequest.md)
 - [OpenbaoClient::EntityLookUpRequest](docs/EntityLookUpRequest.md)
 - [OpenbaoClient::EntityMergeRequest](docs/EntityMergeRequest.md)
 - [OpenbaoClient::EntityUpdateAliasByIdRequest](docs/EntityUpdateAliasByIdRequest.md)
 - [OpenbaoClient::EntityUpdateByIdRequest](docs/EntityUpdateByIdRequest.md)
 - [OpenbaoClient::EntityUpdateByNameRequest](docs/EntityUpdateByNameRequest.md)
 - [OpenbaoClient::GenerateHashRequest](docs/GenerateHashRequest.md)
 - [OpenbaoClient::GenerateHashResponse](docs/GenerateHashResponse.md)
 - [OpenbaoClient::GenerateHashWithAlgorithmRequest](docs/GenerateHashWithAlgorithmRequest.md)
 - [OpenbaoClient::GenerateHashWithAlgorithmResponse](docs/GenerateHashWithAlgorithmResponse.md)
 - [OpenbaoClient::GenerateRandomRequest](docs/GenerateRandomRequest.md)
 - [OpenbaoClient::GenerateRandomResponse](docs/GenerateRandomResponse.md)
 - [OpenbaoClient::GenerateRandomWithBytesRequest](docs/GenerateRandomWithBytesRequest.md)
 - [OpenbaoClient::GenerateRandomWithBytesResponse](docs/GenerateRandomWithBytesResponse.md)
 - [OpenbaoClient::GenerateRandomWithSourceAndBytesRequest](docs/GenerateRandomWithSourceAndBytesRequest.md)
 - [OpenbaoClient::GenerateRandomWithSourceAndBytesResponse](docs/GenerateRandomWithSourceAndBytesResponse.md)
 - [OpenbaoClient::GenerateRandomWithSourceRequest](docs/GenerateRandomWithSourceRequest.md)
 - [OpenbaoClient::GenerateRandomWithSourceResponse](docs/GenerateRandomWithSourceResponse.md)
 - [OpenbaoClient::GroupCreateAliasRequest](docs/GroupCreateAliasRequest.md)
 - [OpenbaoClient::GroupCreateRequest](docs/GroupCreateRequest.md)
 - [OpenbaoClient::GroupLookUpRequest](docs/GroupLookUpRequest.md)
 - [OpenbaoClient::GroupUpdateAliasByIdRequest](docs/GroupUpdateAliasByIdRequest.md)
 - [OpenbaoClient::GroupUpdateByIdRequest](docs/GroupUpdateByIdRequest.md)
 - [OpenbaoClient::GroupUpdateByNameRequest](docs/GroupUpdateByNameRequest.md)
 - [OpenbaoClient::HaStatusResponse](docs/HaStatusResponse.md)
 - [OpenbaoClient::InitializeRequest](docs/InitializeRequest.md)
 - [OpenbaoClient::InternalCountEntitiesResponse](docs/InternalCountEntitiesResponse.md)
 - [OpenbaoClient::InternalCountTokensResponse](docs/InternalCountTokensResponse.md)
 - [OpenbaoClient::InternalGenerateOpenApiDocumentWithParametersRequest](docs/InternalGenerateOpenApiDocumentWithParametersRequest.md)
 - [OpenbaoClient::InternalUiListEnabledFeatureFlagsResponse](docs/InternalUiListEnabledFeatureFlagsResponse.md)
 - [OpenbaoClient::InternalUiListEnabledVisibleMountsResponse](docs/InternalUiListEnabledVisibleMountsResponse.md)
 - [OpenbaoClient::InternalUiListNamespacesResponse](docs/InternalUiListNamespacesResponse.md)
 - [OpenbaoClient::InternalUiReadMountInformationResponse](docs/InternalUiReadMountInformationResponse.md)
 - [OpenbaoClient::InternalUiReadResultantAclResponse](docs/InternalUiReadResultantAclResponse.md)
 - [OpenbaoClient::JwtConfigureRequest](docs/JwtConfigureRequest.md)
 - [OpenbaoClient::JwtLoginRequest](docs/JwtLoginRequest.md)
 - [OpenbaoClient::JwtOidcCallbackFormPostRequest](docs/JwtOidcCallbackFormPostRequest.md)
 - [OpenbaoClient::JwtOidcRequestAuthorizationUrlRequest](docs/JwtOidcRequestAuthorizationUrlRequest.md)
 - [OpenbaoClient::JwtWriteRoleRequest](docs/JwtWriteRoleRequest.md)
 - [OpenbaoClient::KerberosConfigureLdapRequest](docs/KerberosConfigureLdapRequest.md)
 - [OpenbaoClient::KerberosConfigureRequest](docs/KerberosConfigureRequest.md)
 - [OpenbaoClient::KerberosLoginRequest](docs/KerberosLoginRequest.md)
 - [OpenbaoClient::KerberosWriteGroupRequest](docs/KerberosWriteGroupRequest.md)
 - [OpenbaoClient::KubernetesConfigureAuthRequest](docs/KubernetesConfigureAuthRequest.md)
 - [OpenbaoClient::KubernetesConfigureRequest](docs/KubernetesConfigureRequest.md)
 - [OpenbaoClient::KubernetesGenerateCredentialsRequest](docs/KubernetesGenerateCredentialsRequest.md)
 - [OpenbaoClient::KubernetesLoginRequest](docs/KubernetesLoginRequest.md)
 - [OpenbaoClient::KubernetesWriteAuthRoleRequest](docs/KubernetesWriteAuthRoleRequest.md)
 - [OpenbaoClient::KubernetesWriteRoleRequest](docs/KubernetesWriteRoleRequest.md)
 - [OpenbaoClient::KvWriteConfigRequest](docs/KvWriteConfigRequest.md)
 - [OpenbaoClient::KvWriteDataPathRequest](docs/KvWriteDataPathRequest.md)
 - [OpenbaoClient::KvWriteDeletePathRequest](docs/KvWriteDeletePathRequest.md)
 - [OpenbaoClient::KvWriteDestroyPathRequest](docs/KvWriteDestroyPathRequest.md)
 - [OpenbaoClient::KvWriteMetadataPathRequest](docs/KvWriteMetadataPathRequest.md)
 - [OpenbaoClient::KvWriteUndeletePathRequest](docs/KvWriteUndeletePathRequest.md)
 - [OpenbaoClient::LdapConfigureAuthRequest](docs/LdapConfigureAuthRequest.md)
 - [OpenbaoClient::LdapConfigureRequest](docs/LdapConfigureRequest.md)
 - [OpenbaoClient::LdapLibraryCheckInRequest](docs/LdapLibraryCheckInRequest.md)
 - [OpenbaoClient::LdapLibraryCheckOutRequest](docs/LdapLibraryCheckOutRequest.md)
 - [OpenbaoClient::LdapLibraryConfigureRequest](docs/LdapLibraryConfigureRequest.md)
 - [OpenbaoClient::LdapLibraryForceCheckInRequest](docs/LdapLibraryForceCheckInRequest.md)
 - [OpenbaoClient::LdapLoginRequest](docs/LdapLoginRequest.md)
 - [OpenbaoClient::LdapWriteDynamicRoleRequest](docs/LdapWriteDynamicRoleRequest.md)
 - [OpenbaoClient::LdapWriteGroupRequest](docs/LdapWriteGroupRequest.md)
 - [OpenbaoClient::LdapWriteStaticRoleRequest](docs/LdapWriteStaticRoleRequest.md)
 - [OpenbaoClient::LdapWriteUserRequest](docs/LdapWriteUserRequest.md)
 - [OpenbaoClient::LeaderStatusResponse](docs/LeaderStatusResponse.md)
 - [OpenbaoClient::LeasesCountResponse](docs/LeasesCountResponse.md)
 - [OpenbaoClient::LeasesListResponse](docs/LeasesListResponse.md)
 - [OpenbaoClient::LeasesLookUpResponse](docs/LeasesLookUpResponse.md)
 - [OpenbaoClient::LeasesLookUpWithPrefixResponse](docs/LeasesLookUpWithPrefixResponse.md)
 - [OpenbaoClient::LeasesReadLeaseRequest](docs/LeasesReadLeaseRequest.md)
 - [OpenbaoClient::LeasesReadLeaseResponse](docs/LeasesReadLeaseResponse.md)
 - [OpenbaoClient::LeasesRenewLease2Request](docs/LeasesRenewLease2Request.md)
 - [OpenbaoClient::LeasesRenewLeaseRequest](docs/LeasesRenewLeaseRequest.md)
 - [OpenbaoClient::LeasesRenewLeaseWithId2Request](docs/LeasesRenewLeaseWithId2Request.md)
 - [OpenbaoClient::LeasesRenewLeaseWithIdRequest](docs/LeasesRenewLeaseWithIdRequest.md)
 - [OpenbaoClient::LeasesRevokeLease2Request](docs/LeasesRevokeLease2Request.md)
 - [OpenbaoClient::LeasesRevokeLeaseRequest](docs/LeasesRevokeLeaseRequest.md)
 - [OpenbaoClient::LeasesRevokeLeaseWithId2Request](docs/LeasesRevokeLeaseWithId2Request.md)
 - [OpenbaoClient::LeasesRevokeLeaseWithIdRequest](docs/LeasesRevokeLeaseWithIdRequest.md)
 - [OpenbaoClient::LeasesRevokeLeaseWithPrefix2Request](docs/LeasesRevokeLeaseWithPrefix2Request.md)
 - [OpenbaoClient::LeasesRevokeLeaseWithPrefixRequest](docs/LeasesRevokeLeaseWithPrefixRequest.md)
 - [OpenbaoClient::LoggersUpdateVerbosityLevelForRequest](docs/LoggersUpdateVerbosityLevelForRequest.md)
 - [OpenbaoClient::LoggersUpdateVerbosityLevelRequest](docs/LoggersUpdateVerbosityLevelRequest.md)
 - [OpenbaoClient::MfaAdminDestroyTotpSecretRequest](docs/MfaAdminDestroyTotpSecretRequest.md)
 - [OpenbaoClient::MfaAdminGenerateTotpSecretRequest](docs/MfaAdminGenerateTotpSecretRequest.md)
 - [OpenbaoClient::MfaConfigureDuoMethodRequest](docs/MfaConfigureDuoMethodRequest.md)
 - [OpenbaoClient::MfaConfigureOktaMethodRequest](docs/MfaConfigureOktaMethodRequest.md)
 - [OpenbaoClient::MfaConfigurePingIdMethodRequest](docs/MfaConfigurePingIdMethodRequest.md)
 - [OpenbaoClient::MfaConfigureTotpMethodRequest](docs/MfaConfigureTotpMethodRequest.md)
 - [OpenbaoClient::MfaGenerateTotpSecretRequest](docs/MfaGenerateTotpSecretRequest.md)
 - [OpenbaoClient::MfaValidateRequest](docs/MfaValidateRequest.md)
 - [OpenbaoClient::MfaWriteLoginEnforcementRequest](docs/MfaWriteLoginEnforcementRequest.md)
 - [OpenbaoClient::MountsEnableSecretsEngineRequest](docs/MountsEnableSecretsEngineRequest.md)
 - [OpenbaoClient::MountsReadConfigurationResponse](docs/MountsReadConfigurationResponse.md)
 - [OpenbaoClient::MountsReadTuningInformationResponse](docs/MountsReadTuningInformationResponse.md)
 - [OpenbaoClient::MountsTuneConfigurationParametersRequest](docs/MountsTuneConfigurationParametersRequest.md)
 - [OpenbaoClient::OidcConfigureRequest](docs/OidcConfigureRequest.md)
 - [OpenbaoClient::OidcIntrospectRequest](docs/OidcIntrospectRequest.md)
 - [OpenbaoClient::OidcProviderAuthorizeWithParametersRequest](docs/OidcProviderAuthorizeWithParametersRequest.md)
 - [OpenbaoClient::OidcProviderTokenRequest](docs/OidcProviderTokenRequest.md)
 - [OpenbaoClient::OidcRotateKeyRequest](docs/OidcRotateKeyRequest.md)
 - [OpenbaoClient::OidcWriteAssignmentRequest](docs/OidcWriteAssignmentRequest.md)
 - [OpenbaoClient::OidcWriteClientRequest](docs/OidcWriteClientRequest.md)
 - [OpenbaoClient::OidcWriteKeyRequest](docs/OidcWriteKeyRequest.md)
 - [OpenbaoClient::OidcWriteProviderRequest](docs/OidcWriteProviderRequest.md)
 - [OpenbaoClient::OidcWriteRoleRequest](docs/OidcWriteRoleRequest.md)
 - [OpenbaoClient::OidcWriteScopeRequest](docs/OidcWriteScopeRequest.md)
 - [OpenbaoClient::PersonaCreateRequest](docs/PersonaCreateRequest.md)
 - [OpenbaoClient::PersonaUpdateByIdRequest](docs/PersonaUpdateByIdRequest.md)
 - [OpenbaoClient::PkiConfigureAcmeRequest](docs/PkiConfigureAcmeRequest.md)
 - [OpenbaoClient::PkiConfigureAutoTidyRequest](docs/PkiConfigureAutoTidyRequest.md)
 - [OpenbaoClient::PkiConfigureAutoTidyResponse](docs/PkiConfigureAutoTidyResponse.md)
 - [OpenbaoClient::PkiConfigureCaRequest](docs/PkiConfigureCaRequest.md)
 - [OpenbaoClient::PkiConfigureCaResponse](docs/PkiConfigureCaResponse.md)
 - [OpenbaoClient::PkiConfigureClusterRequest](docs/PkiConfigureClusterRequest.md)
 - [OpenbaoClient::PkiConfigureClusterResponse](docs/PkiConfigureClusterResponse.md)
 - [OpenbaoClient::PkiConfigureCrlRequest](docs/PkiConfigureCrlRequest.md)
 - [OpenbaoClient::PkiConfigureCrlResponse](docs/PkiConfigureCrlResponse.md)
 - [OpenbaoClient::PkiConfigureIssuersRequest](docs/PkiConfigureIssuersRequest.md)
 - [OpenbaoClient::PkiConfigureIssuersResponse](docs/PkiConfigureIssuersResponse.md)
 - [OpenbaoClient::PkiConfigureKeysRequest](docs/PkiConfigureKeysRequest.md)
 - [OpenbaoClient::PkiConfigureKeysResponse](docs/PkiConfigureKeysResponse.md)
 - [OpenbaoClient::PkiConfigureUrlsRequest](docs/PkiConfigureUrlsRequest.md)
 - [OpenbaoClient::PkiConfigureUrlsResponse](docs/PkiConfigureUrlsResponse.md)
 - [OpenbaoClient::PkiCrossSignIntermediateRequest](docs/PkiCrossSignIntermediateRequest.md)
 - [OpenbaoClient::PkiCrossSignIntermediateResponse](docs/PkiCrossSignIntermediateResponse.md)
 - [OpenbaoClient::PkiGenerateEabKeyForIssuerAndRoleResponse](docs/PkiGenerateEabKeyForIssuerAndRoleResponse.md)
 - [OpenbaoClient::PkiGenerateEabKeyForIssuerResponse](docs/PkiGenerateEabKeyForIssuerResponse.md)
 - [OpenbaoClient::PkiGenerateEabKeyForRoleResponse](docs/PkiGenerateEabKeyForRoleResponse.md)
 - [OpenbaoClient::PkiGenerateEabKeyResponse](docs/PkiGenerateEabKeyResponse.md)
 - [OpenbaoClient::PkiGenerateExportedKeyRequest](docs/PkiGenerateExportedKeyRequest.md)
 - [OpenbaoClient::PkiGenerateExportedKeyResponse](docs/PkiGenerateExportedKeyResponse.md)
 - [OpenbaoClient::PkiGenerateIntermediateRequest](docs/PkiGenerateIntermediateRequest.md)
 - [OpenbaoClient::PkiGenerateIntermediateResponse](docs/PkiGenerateIntermediateResponse.md)
 - [OpenbaoClient::PkiGenerateInternalKeyRequest](docs/PkiGenerateInternalKeyRequest.md)
 - [OpenbaoClient::PkiGenerateInternalKeyResponse](docs/PkiGenerateInternalKeyResponse.md)
 - [OpenbaoClient::PkiGenerateKmsKeyRequest](docs/PkiGenerateKmsKeyRequest.md)
 - [OpenbaoClient::PkiGenerateKmsKeyResponse](docs/PkiGenerateKmsKeyResponse.md)
 - [OpenbaoClient::PkiGenerateRootRequest](docs/PkiGenerateRootRequest.md)
 - [OpenbaoClient::PkiGenerateRootResponse](docs/PkiGenerateRootResponse.md)
 - [OpenbaoClient::PkiImportKeyRequest](docs/PkiImportKeyRequest.md)
 - [OpenbaoClient::PkiImportKeyResponse](docs/PkiImportKeyResponse.md)
 - [OpenbaoClient::PkiIssueWithRoleRequest](docs/PkiIssueWithRoleRequest.md)
 - [OpenbaoClient::PkiIssueWithRoleResponse](docs/PkiIssueWithRoleResponse.md)
 - [OpenbaoClient::PkiIssuerIssueWithRoleRequest](docs/PkiIssuerIssueWithRoleRequest.md)
 - [OpenbaoClient::PkiIssuerIssueWithRoleResponse](docs/PkiIssuerIssueWithRoleResponse.md)
 - [OpenbaoClient::PkiIssuerReadCrlDeltaDerResponse](docs/PkiIssuerReadCrlDeltaDerResponse.md)
 - [OpenbaoClient::PkiIssuerReadCrlDeltaPemResponse](docs/PkiIssuerReadCrlDeltaPemResponse.md)
 - [OpenbaoClient::PkiIssuerReadCrlDeltaResponse](docs/PkiIssuerReadCrlDeltaResponse.md)
 - [OpenbaoClient::PkiIssuerReadCrlDerResponse](docs/PkiIssuerReadCrlDerResponse.md)
 - [OpenbaoClient::PkiIssuerReadCrlPemResponse](docs/PkiIssuerReadCrlPemResponse.md)
 - [OpenbaoClient::PkiIssuerReadCrlResponse](docs/PkiIssuerReadCrlResponse.md)
 - [OpenbaoClient::PkiIssuerResignCrlsRequest](docs/PkiIssuerResignCrlsRequest.md)
 - [OpenbaoClient::PkiIssuerResignCrlsResponse](docs/PkiIssuerResignCrlsResponse.md)
 - [OpenbaoClient::PkiIssuerSignIntermediateRequest](docs/PkiIssuerSignIntermediateRequest.md)
 - [OpenbaoClient::PkiIssuerSignIntermediateResponse](docs/PkiIssuerSignIntermediateResponse.md)
 - [OpenbaoClient::PkiIssuerSignRevocationListRequest](docs/PkiIssuerSignRevocationListRequest.md)
 - [OpenbaoClient::PkiIssuerSignRevocationListResponse](docs/PkiIssuerSignRevocationListResponse.md)
 - [OpenbaoClient::PkiIssuerSignSelfIssuedRequest](docs/PkiIssuerSignSelfIssuedRequest.md)
 - [OpenbaoClient::PkiIssuerSignSelfIssuedResponse](docs/PkiIssuerSignSelfIssuedResponse.md)
 - [OpenbaoClient::PkiIssuerSignVerbatimRequest](docs/PkiIssuerSignVerbatimRequest.md)
 - [OpenbaoClient::PkiIssuerSignVerbatimResponse](docs/PkiIssuerSignVerbatimResponse.md)
 - [OpenbaoClient::PkiIssuerSignVerbatimWithRoleRequest](docs/PkiIssuerSignVerbatimWithRoleRequest.md)
 - [OpenbaoClient::PkiIssuerSignVerbatimWithRoleResponse](docs/PkiIssuerSignVerbatimWithRoleResponse.md)
 - [OpenbaoClient::PkiIssuerSignWithRoleRequest](docs/PkiIssuerSignWithRoleRequest.md)
 - [OpenbaoClient::PkiIssuerSignWithRoleResponse](docs/PkiIssuerSignWithRoleResponse.md)
 - [OpenbaoClient::PkiIssuersGenerateIntermediateRequest](docs/PkiIssuersGenerateIntermediateRequest.md)
 - [OpenbaoClient::PkiIssuersGenerateIntermediateResponse](docs/PkiIssuersGenerateIntermediateResponse.md)
 - [OpenbaoClient::PkiIssuersGenerateRootRequest](docs/PkiIssuersGenerateRootRequest.md)
 - [OpenbaoClient::PkiIssuersGenerateRootResponse](docs/PkiIssuersGenerateRootResponse.md)
 - [OpenbaoClient::PkiIssuersImportBundleRequest](docs/PkiIssuersImportBundleRequest.md)
 - [OpenbaoClient::PkiIssuersImportBundleResponse](docs/PkiIssuersImportBundleResponse.md)
 - [OpenbaoClient::PkiIssuersImportCertRequest](docs/PkiIssuersImportCertRequest.md)
 - [OpenbaoClient::PkiIssuersImportCertResponse](docs/PkiIssuersImportCertResponse.md)
 - [OpenbaoClient::PkiListCertsResponse](docs/PkiListCertsResponse.md)
 - [OpenbaoClient::PkiListEabKeysResponse](docs/PkiListEabKeysResponse.md)
 - [OpenbaoClient::PkiListIssuersResponse](docs/PkiListIssuersResponse.md)
 - [OpenbaoClient::PkiListKeysResponse](docs/PkiListKeysResponse.md)
 - [OpenbaoClient::PkiListRevokedCertsResponse](docs/PkiListRevokedCertsResponse.md)
 - [OpenbaoClient::PkiListRolesResponse](docs/PkiListRolesResponse.md)
 - [OpenbaoClient::PkiPatchIssuerResponse](docs/PkiPatchIssuerResponse.md)
 - [OpenbaoClient::PkiPatchRoleResponse](docs/PkiPatchRoleResponse.md)
 - [OpenbaoClient::PkiReadAutoTidyConfigurationResponse](docs/PkiReadAutoTidyConfigurationResponse.md)
 - [OpenbaoClient::PkiReadCaChainPemResponse](docs/PkiReadCaChainPemResponse.md)
 - [OpenbaoClient::PkiReadCaDerResponse](docs/PkiReadCaDerResponse.md)
 - [OpenbaoClient::PkiReadCaPemResponse](docs/PkiReadCaPemResponse.md)
 - [OpenbaoClient::PkiReadCertCaChainResponse](docs/PkiReadCertCaChainResponse.md)
 - [OpenbaoClient::PkiReadCertCrlResponse](docs/PkiReadCertCrlResponse.md)
 - [OpenbaoClient::PkiReadCertDeltaCrlResponse](docs/PkiReadCertDeltaCrlResponse.md)
 - [OpenbaoClient::PkiReadCertRawDerResponse](docs/PkiReadCertRawDerResponse.md)
 - [OpenbaoClient::PkiReadCertRawPemResponse](docs/PkiReadCertRawPemResponse.md)
 - [OpenbaoClient::PkiReadCertResponse](docs/PkiReadCertResponse.md)
 - [OpenbaoClient::PkiReadClusterConfigurationResponse](docs/PkiReadClusterConfigurationResponse.md)
 - [OpenbaoClient::PkiReadCrlConfigurationResponse](docs/PkiReadCrlConfigurationResponse.md)
 - [OpenbaoClient::PkiReadCrlDeltaPemResponse](docs/PkiReadCrlDeltaPemResponse.md)
 - [OpenbaoClient::PkiReadCrlDeltaResponse](docs/PkiReadCrlDeltaResponse.md)
 - [OpenbaoClient::PkiReadCrlDerResponse](docs/PkiReadCrlDerResponse.md)
 - [OpenbaoClient::PkiReadCrlPemResponse](docs/PkiReadCrlPemResponse.md)
 - [OpenbaoClient::PkiReadIssuerDerResponse](docs/PkiReadIssuerDerResponse.md)
 - [OpenbaoClient::PkiReadIssuerJsonResponse](docs/PkiReadIssuerJsonResponse.md)
 - [OpenbaoClient::PkiReadIssuerPemResponse](docs/PkiReadIssuerPemResponse.md)
 - [OpenbaoClient::PkiReadIssuerResponse](docs/PkiReadIssuerResponse.md)
 - [OpenbaoClient::PkiReadIssuersConfigurationResponse](docs/PkiReadIssuersConfigurationResponse.md)
 - [OpenbaoClient::PkiReadKeyResponse](docs/PkiReadKeyResponse.md)
 - [OpenbaoClient::PkiReadKeysConfigurationResponse](docs/PkiReadKeysConfigurationResponse.md)
 - [OpenbaoClient::PkiReadRoleResponse](docs/PkiReadRoleResponse.md)
 - [OpenbaoClient::PkiReadUrlsConfigurationResponse](docs/PkiReadUrlsConfigurationResponse.md)
 - [OpenbaoClient::PkiReplaceRootRequest](docs/PkiReplaceRootRequest.md)
 - [OpenbaoClient::PkiReplaceRootResponse](docs/PkiReplaceRootResponse.md)
 - [OpenbaoClient::PkiRevokeIssuerResponse](docs/PkiRevokeIssuerResponse.md)
 - [OpenbaoClient::PkiRevokeRequest](docs/PkiRevokeRequest.md)
 - [OpenbaoClient::PkiRevokeResponse](docs/PkiRevokeResponse.md)
 - [OpenbaoClient::PkiRevokeWithKeyRequest](docs/PkiRevokeWithKeyRequest.md)
 - [OpenbaoClient::PkiRevokeWithKeyResponse](docs/PkiRevokeWithKeyResponse.md)
 - [OpenbaoClient::PkiRootSignIntermediateRequest](docs/PkiRootSignIntermediateRequest.md)
 - [OpenbaoClient::PkiRootSignIntermediateResponse](docs/PkiRootSignIntermediateResponse.md)
 - [OpenbaoClient::PkiRootSignSelfIssuedRequest](docs/PkiRootSignSelfIssuedRequest.md)
 - [OpenbaoClient::PkiRootSignSelfIssuedResponse](docs/PkiRootSignSelfIssuedResponse.md)
 - [OpenbaoClient::PkiRotateCrlResponse](docs/PkiRotateCrlResponse.md)
 - [OpenbaoClient::PkiRotateDeltaCrlResponse](docs/PkiRotateDeltaCrlResponse.md)
 - [OpenbaoClient::PkiRotateRootRequest](docs/PkiRotateRootRequest.md)
 - [OpenbaoClient::PkiRotateRootResponse](docs/PkiRotateRootResponse.md)
 - [OpenbaoClient::PkiSetSignedIntermediateRequest](docs/PkiSetSignedIntermediateRequest.md)
 - [OpenbaoClient::PkiSetSignedIntermediateResponse](docs/PkiSetSignedIntermediateResponse.md)
 - [OpenbaoClient::PkiSignVerbatimRequest](docs/PkiSignVerbatimRequest.md)
 - [OpenbaoClient::PkiSignVerbatimResponse](docs/PkiSignVerbatimResponse.md)
 - [OpenbaoClient::PkiSignVerbatimWithRoleRequest](docs/PkiSignVerbatimWithRoleRequest.md)
 - [OpenbaoClient::PkiSignVerbatimWithRoleResponse](docs/PkiSignVerbatimWithRoleResponse.md)
 - [OpenbaoClient::PkiSignWithRoleRequest](docs/PkiSignWithRoleRequest.md)
 - [OpenbaoClient::PkiSignWithRoleResponse](docs/PkiSignWithRoleResponse.md)
 - [OpenbaoClient::PkiTidyCancelResponse](docs/PkiTidyCancelResponse.md)
 - [OpenbaoClient::PkiTidyRequest](docs/PkiTidyRequest.md)
 - [OpenbaoClient::PkiTidyStatusResponse](docs/PkiTidyStatusResponse.md)
 - [OpenbaoClient::PkiWriteAcmeAccountKidRequest](docs/PkiWriteAcmeAccountKidRequest.md)
 - [OpenbaoClient::PkiWriteAcmeAuthorizationAuthIdRequest](docs/PkiWriteAcmeAuthorizationAuthIdRequest.md)
 - [OpenbaoClient::PkiWriteAcmeChallengeAuthIdChallengeTypeRequest](docs/PkiWriteAcmeChallengeAuthIdChallengeTypeRequest.md)
 - [OpenbaoClient::PkiWriteAcmeNewAccountRequest](docs/PkiWriteAcmeNewAccountRequest.md)
 - [OpenbaoClient::PkiWriteAcmeNewOrderRequest](docs/PkiWriteAcmeNewOrderRequest.md)
 - [OpenbaoClient::PkiWriteAcmeOrderOrderIdCertRequest](docs/PkiWriteAcmeOrderOrderIdCertRequest.md)
 - [OpenbaoClient::PkiWriteAcmeOrderOrderIdFinalizeRequest](docs/PkiWriteAcmeOrderOrderIdFinalizeRequest.md)
 - [OpenbaoClient::PkiWriteAcmeOrderOrderIdRequest](docs/PkiWriteAcmeOrderOrderIdRequest.md)
 - [OpenbaoClient::PkiWriteAcmeOrdersRequest](docs/PkiWriteAcmeOrdersRequest.md)
 - [OpenbaoClient::PkiWriteAcmeRevokeCertRequest](docs/PkiWriteAcmeRevokeCertRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeAccountKidRequest](docs/PkiWriteIssuerIssuerRefAcmeAccountKidRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeAuthorizationAuthIdRequest](docs/PkiWriteIssuerIssuerRefAcmeAuthorizationAuthIdRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeChallengeAuthIdChallengeTypeRequest](docs/PkiWriteIssuerIssuerRefAcmeChallengeAuthIdChallengeTypeRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeNewAccountRequest](docs/PkiWriteIssuerIssuerRefAcmeNewAccountRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeNewOrderRequest](docs/PkiWriteIssuerIssuerRefAcmeNewOrderRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeOrderOrderIdCertRequest](docs/PkiWriteIssuerIssuerRefAcmeOrderOrderIdCertRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeOrderOrderIdFinalizeRequest](docs/PkiWriteIssuerIssuerRefAcmeOrderOrderIdFinalizeRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeOrderOrderIdRequest](docs/PkiWriteIssuerIssuerRefAcmeOrderOrderIdRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeOrdersRequest](docs/PkiWriteIssuerIssuerRefAcmeOrdersRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefAcmeRevokeCertRequest](docs/PkiWriteIssuerIssuerRefAcmeRevokeCertRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeAccountKidRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeAccountKidRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeAuthorizationAuthIdRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeAuthorizationAuthIdRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeChallengeAuthIdChallengeTypeRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeChallengeAuthIdChallengeTypeRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeNewAccountRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeNewAccountRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeNewOrderRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeNewOrderRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdCertRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdCertRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdFinalizeRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdFinalizeRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeOrdersRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeOrdersRequest.md)
 - [OpenbaoClient::PkiWriteIssuerIssuerRefRolesRoleAcmeRevokeCertRequest](docs/PkiWriteIssuerIssuerRefRolesRoleAcmeRevokeCertRequest.md)
 - [OpenbaoClient::PkiWriteIssuerRequest](docs/PkiWriteIssuerRequest.md)
 - [OpenbaoClient::PkiWriteIssuerResponse](docs/PkiWriteIssuerResponse.md)
 - [OpenbaoClient::PkiWriteKeyRequest](docs/PkiWriteKeyRequest.md)
 - [OpenbaoClient::PkiWriteKeyResponse](docs/PkiWriteKeyResponse.md)
 - [OpenbaoClient::PkiWriteRoleRequest](docs/PkiWriteRoleRequest.md)
 - [OpenbaoClient::PkiWriteRoleResponse](docs/PkiWriteRoleResponse.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeAccountKidRequest](docs/PkiWriteRolesRoleAcmeAccountKidRequest.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeAuthorizationAuthIdRequest](docs/PkiWriteRolesRoleAcmeAuthorizationAuthIdRequest.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeChallengeAuthIdChallengeTypeRequest](docs/PkiWriteRolesRoleAcmeChallengeAuthIdChallengeTypeRequest.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeNewAccountRequest](docs/PkiWriteRolesRoleAcmeNewAccountRequest.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeNewOrderRequest](docs/PkiWriteRolesRoleAcmeNewOrderRequest.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeOrderOrderIdCertRequest](docs/PkiWriteRolesRoleAcmeOrderOrderIdCertRequest.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeOrderOrderIdFinalizeRequest](docs/PkiWriteRolesRoleAcmeOrderOrderIdFinalizeRequest.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeOrderOrderIdRequest](docs/PkiWriteRolesRoleAcmeOrderOrderIdRequest.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeOrdersRequest](docs/PkiWriteRolesRoleAcmeOrdersRequest.md)
 - [OpenbaoClient::PkiWriteRolesRoleAcmeRevokeCertRequest](docs/PkiWriteRolesRoleAcmeRevokeCertRequest.md)
 - [OpenbaoClient::PluginsCatalogListPluginsResponse](docs/PluginsCatalogListPluginsResponse.md)
 - [OpenbaoClient::PluginsCatalogListPluginsWithTypeResponse](docs/PluginsCatalogListPluginsWithTypeResponse.md)
 - [OpenbaoClient::PluginsCatalogReadPluginConfigurationResponse](docs/PluginsCatalogReadPluginConfigurationResponse.md)
 - [OpenbaoClient::PluginsCatalogReadPluginConfigurationWithTypeResponse](docs/PluginsCatalogReadPluginConfigurationWithTypeResponse.md)
 - [OpenbaoClient::PluginsCatalogRegisterPluginRequest](docs/PluginsCatalogRegisterPluginRequest.md)
 - [OpenbaoClient::PluginsCatalogRegisterPluginWithTypeRequest](docs/PluginsCatalogRegisterPluginWithTypeRequest.md)
 - [OpenbaoClient::PluginsReloadBackendsRequest](docs/PluginsReloadBackendsRequest.md)
 - [OpenbaoClient::PluginsReloadBackendsResponse](docs/PluginsReloadBackendsResponse.md)
 - [OpenbaoClient::PoliciesGeneratePasswordFromPasswordPolicyResponse](docs/PoliciesGeneratePasswordFromPasswordPolicyResponse.md)
 - [OpenbaoClient::PoliciesListAclPoliciesResponse](docs/PoliciesListAclPoliciesResponse.md)
 - [OpenbaoClient::PoliciesListPasswordPoliciesResponse](docs/PoliciesListPasswordPoliciesResponse.md)
 - [OpenbaoClient::PoliciesListResponse](docs/PoliciesListResponse.md)
 - [OpenbaoClient::PoliciesReadAclPolicy2Response](docs/PoliciesReadAclPolicy2Response.md)
 - [OpenbaoClient::PoliciesReadAclPolicyResponse](docs/PoliciesReadAclPolicyResponse.md)
 - [OpenbaoClient::PoliciesReadPasswordPolicyResponse](docs/PoliciesReadPasswordPolicyResponse.md)
 - [OpenbaoClient::PoliciesWriteAclPolicy2Request](docs/PoliciesWriteAclPolicy2Request.md)
 - [OpenbaoClient::PoliciesWriteAclPolicyRequest](docs/PoliciesWriteAclPolicyRequest.md)
 - [OpenbaoClient::PoliciesWritePasswordPolicyRequest](docs/PoliciesWritePasswordPolicyRequest.md)
 - [OpenbaoClient::QueryTokenAccessorCapabilitiesRequest](docs/QueryTokenAccessorCapabilitiesRequest.md)
 - [OpenbaoClient::QueryTokenCapabilitiesRequest](docs/QueryTokenCapabilitiesRequest.md)
 - [OpenbaoClient::QueryTokenSelfCapabilitiesRequest](docs/QueryTokenSelfCapabilitiesRequest.md)
 - [OpenbaoClient::RabbitMqConfigureConnectionRequest](docs/RabbitMqConfigureConnectionRequest.md)
 - [OpenbaoClient::RabbitMqConfigureLeaseRequest](docs/RabbitMqConfigureLeaseRequest.md)
 - [OpenbaoClient::RabbitMqWriteRoleRequest](docs/RabbitMqWriteRoleRequest.md)
 - [OpenbaoClient::RadiusConfigureRequest](docs/RadiusConfigureRequest.md)
 - [OpenbaoClient::RadiusLoginRequest](docs/RadiusLoginRequest.md)
 - [OpenbaoClient::RadiusLoginWithUsernameRequest](docs/RadiusLoginWithUsernameRequest.md)
 - [OpenbaoClient::RadiusWriteUserRequest](docs/RadiusWriteUserRequest.md)
 - [OpenbaoClient::RateLimitQuotasConfigureRequest](docs/RateLimitQuotasConfigureRequest.md)
 - [OpenbaoClient::RateLimitQuotasListResponse](docs/RateLimitQuotasListResponse.md)
 - [OpenbaoClient::RateLimitQuotasReadConfigurationResponse](docs/RateLimitQuotasReadConfigurationResponse.md)
 - [OpenbaoClient::RateLimitQuotasReadResponse](docs/RateLimitQuotasReadResponse.md)
 - [OpenbaoClient::RateLimitQuotasWriteRequest](docs/RateLimitQuotasWriteRequest.md)
 - [OpenbaoClient::RawReadPathResponse](docs/RawReadPathResponse.md)
 - [OpenbaoClient::RawReadResponse](docs/RawReadResponse.md)
 - [OpenbaoClient::RawWritePathRequest](docs/RawWritePathRequest.md)
 - [OpenbaoClient::RawWriteRequest](docs/RawWriteRequest.md)
 - [OpenbaoClient::ReadWrappingProperties2Response](docs/ReadWrappingProperties2Response.md)
 - [OpenbaoClient::ReadWrappingPropertiesRequest](docs/ReadWrappingPropertiesRequest.md)
 - [OpenbaoClient::ReadWrappingPropertiesResponse](docs/ReadWrappingPropertiesResponse.md)
 - [OpenbaoClient::RekeyAttemptInitializeRequest](docs/RekeyAttemptInitializeRequest.md)
 - [OpenbaoClient::RekeyAttemptInitializeResponse](docs/RekeyAttemptInitializeResponse.md)
 - [OpenbaoClient::RekeyAttemptReadProgressResponse](docs/RekeyAttemptReadProgressResponse.md)
 - [OpenbaoClient::RekeyAttemptUpdateRequest](docs/RekeyAttemptUpdateRequest.md)
 - [OpenbaoClient::RekeyAttemptUpdateResponse](docs/RekeyAttemptUpdateResponse.md)
 - [OpenbaoClient::RekeyReadBackupKeyResponse](docs/RekeyReadBackupKeyResponse.md)
 - [OpenbaoClient::RekeyReadBackupRecoveryKeyResponse](docs/RekeyReadBackupRecoveryKeyResponse.md)
 - [OpenbaoClient::RekeyVerificationCancelResponse](docs/RekeyVerificationCancelResponse.md)
 - [OpenbaoClient::RekeyVerificationReadProgressResponse](docs/RekeyVerificationReadProgressResponse.md)
 - [OpenbaoClient::RekeyVerificationUpdateRequest](docs/RekeyVerificationUpdateRequest.md)
 - [OpenbaoClient::RekeyVerificationUpdateResponse](docs/RekeyVerificationUpdateResponse.md)
 - [OpenbaoClient::RemountRequest](docs/RemountRequest.md)
 - [OpenbaoClient::RemountResponse](docs/RemountResponse.md)
 - [OpenbaoClient::RemountStatusResponse](docs/RemountStatusResponse.md)
 - [OpenbaoClient::RewrapRequest](docs/RewrapRequest.md)
 - [OpenbaoClient::RootTokenGenerationInitialize2Request](docs/RootTokenGenerationInitialize2Request.md)
 - [OpenbaoClient::RootTokenGenerationInitialize2Response](docs/RootTokenGenerationInitialize2Response.md)
 - [OpenbaoClient::RootTokenGenerationInitializeRequest](docs/RootTokenGenerationInitializeRequest.md)
 - [OpenbaoClient::RootTokenGenerationInitializeResponse](docs/RootTokenGenerationInitializeResponse.md)
 - [OpenbaoClient::RootTokenGenerationReadProgress2Response](docs/RootTokenGenerationReadProgress2Response.md)
 - [OpenbaoClient::RootTokenGenerationReadProgressResponse](docs/RootTokenGenerationReadProgressResponse.md)
 - [OpenbaoClient::RootTokenGenerationUpdateRequest](docs/RootTokenGenerationUpdateRequest.md)
 - [OpenbaoClient::RootTokenGenerationUpdateResponse](docs/RootTokenGenerationUpdateResponse.md)
 - [OpenbaoClient::SealStatusResponse](docs/SealStatusResponse.md)
 - [OpenbaoClient::SshConfigureCaRequest](docs/SshConfigureCaRequest.md)
 - [OpenbaoClient::SshConfigureZeroAddressRequest](docs/SshConfigureZeroAddressRequest.md)
 - [OpenbaoClient::SshGenerateCredentialsRequest](docs/SshGenerateCredentialsRequest.md)
 - [OpenbaoClient::SshIssueCertificateRequest](docs/SshIssueCertificateRequest.md)
 - [OpenbaoClient::SshListRolesByIpRequest](docs/SshListRolesByIpRequest.md)
 - [OpenbaoClient::SshSignCertificateRequest](docs/SshSignCertificateRequest.md)
 - [OpenbaoClient::SshVerifyOtpRequest](docs/SshVerifyOtpRequest.md)
 - [OpenbaoClient::SshWriteRoleRequest](docs/SshWriteRoleRequest.md)
 - [OpenbaoClient::TokenCreateAgainstRoleRequest](docs/TokenCreateAgainstRoleRequest.md)
 - [OpenbaoClient::TokenCreateOrphanRequest](docs/TokenCreateOrphanRequest.md)
 - [OpenbaoClient::TokenCreateRequest](docs/TokenCreateRequest.md)
 - [OpenbaoClient::TokenLookUpAccessorRequest](docs/TokenLookUpAccessorRequest.md)
 - [OpenbaoClient::TokenLookUpRequest](docs/TokenLookUpRequest.md)
 - [OpenbaoClient::TokenLookUpSelf2Request](docs/TokenLookUpSelf2Request.md)
 - [OpenbaoClient::TokenRenewAccessorRequest](docs/TokenRenewAccessorRequest.md)
 - [OpenbaoClient::TokenRenewRequest](docs/TokenRenewRequest.md)
 - [OpenbaoClient::TokenRenewSelfRequest](docs/TokenRenewSelfRequest.md)
 - [OpenbaoClient::TokenRevokeAccessorRequest](docs/TokenRevokeAccessorRequest.md)
 - [OpenbaoClient::TokenRevokeOrphanRequest](docs/TokenRevokeOrphanRequest.md)
 - [OpenbaoClient::TokenRevokeRequest](docs/TokenRevokeRequest.md)
 - [OpenbaoClient::TokenWriteRoleRequest](docs/TokenWriteRoleRequest.md)
 - [OpenbaoClient::TotpCreateKeyRequest](docs/TotpCreateKeyRequest.md)
 - [OpenbaoClient::TotpValidateCodeRequest](docs/TotpValidateCodeRequest.md)
 - [OpenbaoClient::TransitConfigureCacheRequest](docs/TransitConfigureCacheRequest.md)
 - [OpenbaoClient::TransitConfigureKeyRequest](docs/TransitConfigureKeyRequest.md)
 - [OpenbaoClient::TransitConfigureKeysRequest](docs/TransitConfigureKeysRequest.md)
 - [OpenbaoClient::TransitCreateKeyRequest](docs/TransitCreateKeyRequest.md)
 - [OpenbaoClient::TransitDecryptRequest](docs/TransitDecryptRequest.md)
 - [OpenbaoClient::TransitEncryptRequest](docs/TransitEncryptRequest.md)
 - [OpenbaoClient::TransitGenerateDataKeyRequest](docs/TransitGenerateDataKeyRequest.md)
 - [OpenbaoClient::TransitGenerateHmacRequest](docs/TransitGenerateHmacRequest.md)
 - [OpenbaoClient::TransitGenerateHmacWithAlgorithmRequest](docs/TransitGenerateHmacWithAlgorithmRequest.md)
 - [OpenbaoClient::TransitGenerateRandomRequest](docs/TransitGenerateRandomRequest.md)
 - [OpenbaoClient::TransitGenerateRandomWithBytesRequest](docs/TransitGenerateRandomWithBytesRequest.md)
 - [OpenbaoClient::TransitGenerateRandomWithSourceAndBytesRequest](docs/TransitGenerateRandomWithSourceAndBytesRequest.md)
 - [OpenbaoClient::TransitGenerateRandomWithSourceRequest](docs/TransitGenerateRandomWithSourceRequest.md)
 - [OpenbaoClient::TransitHashRequest](docs/TransitHashRequest.md)
 - [OpenbaoClient::TransitHashWithAlgorithmRequest](docs/TransitHashWithAlgorithmRequest.md)
 - [OpenbaoClient::TransitImportKeyRequest](docs/TransitImportKeyRequest.md)
 - [OpenbaoClient::TransitImportKeyVersionRequest](docs/TransitImportKeyVersionRequest.md)
 - [OpenbaoClient::TransitRestoreAndRenameKeyRequest](docs/TransitRestoreAndRenameKeyRequest.md)
 - [OpenbaoClient::TransitRestoreKeyRequest](docs/TransitRestoreKeyRequest.md)
 - [OpenbaoClient::TransitRewrapRequest](docs/TransitRewrapRequest.md)
 - [OpenbaoClient::TransitSignRequest](docs/TransitSignRequest.md)
 - [OpenbaoClient::TransitSignWithAlgorithmRequest](docs/TransitSignWithAlgorithmRequest.md)
 - [OpenbaoClient::TransitTrimKeyRequest](docs/TransitTrimKeyRequest.md)
 - [OpenbaoClient::TransitVerifyRequest](docs/TransitVerifyRequest.md)
 - [OpenbaoClient::TransitVerifyWithAlgorithmRequest](docs/TransitVerifyWithAlgorithmRequest.md)
 - [OpenbaoClient::UiHeadersConfigureRequest](docs/UiHeadersConfigureRequest.md)
 - [OpenbaoClient::UiHeadersListResponse](docs/UiHeadersListResponse.md)
 - [OpenbaoClient::UiHeadersReadConfigurationResponse](docs/UiHeadersReadConfigurationResponse.md)
 - [OpenbaoClient::UnsealRequest](docs/UnsealRequest.md)
 - [OpenbaoClient::UnsealResponse](docs/UnsealResponse.md)
 - [OpenbaoClient::UnwrapRequest](docs/UnwrapRequest.md)
 - [OpenbaoClient::UserpassLoginRequest](docs/UserpassLoginRequest.md)
 - [OpenbaoClient::UserpassResetPasswordRequest](docs/UserpassResetPasswordRequest.md)
 - [OpenbaoClient::UserpassUpdatePoliciesRequest](docs/UserpassUpdatePoliciesRequest.md)
 - [OpenbaoClient::UserpassWriteUserRequest](docs/UserpassWriteUserRequest.md)
 - [OpenbaoClient::VersionHistoryResponse](docs/VersionHistoryResponse.md)


## Documentation for Authorization

Endpoints do not require authorization.

