/* LyrDB.c generated by valac 0.12.0, the Vala compiler
 * generated from LyrDB.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <plugin.h>
#include <config1.h>
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <misc.h>
#include <metadata.h>
#include <gmpc_easy_download.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _GmpcProviderLyrDBProp GmpcProviderLyrDBProp;
#define _meta_data_free0(var) ((var == NULL) ? NULL : (var = (meta_data_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define __g_list_free__meta_data_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__meta_data_free0_ (var), NULL)))

struct _GmpcProviderLyrDBProp {
	mpd_Song* song;
	GmpcProviderLyrDB* this;
	GmpcPluginMetaDataCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GQueue* results;
	GList* list;
};


static gpointer gmpc_provider_lyr_db_parent_class = NULL;
static GmpcPluginMetaDataIfaceIface* gmpc_provider_lyr_db_gmpc_plugin_meta_data_iface_parent_iface = NULL;

#define use_transition_ppldb TRUE
#define some_unique_name_ppldb VERSION
#define log_domain_ppldb "Gmpc.Provider.LyrDB"
enum  {
	GMPC_PROVIDER_LYR_DB_DUMMY_PROPERTY
};
#define GMPC_PROVIDER_LYR_DB_query "http://webservices.lyrdb.com/lookup.php?q=%s|%s&for=match&agent=gmpc-l" \
"yrdb"
#define GMPC_PROVIDER_LYR_DB_download_url "http://webservices.lyrdb.com/getlyr.php?q=%s"
static gint* gmpc_provider_lyr_db_real_get_version (GmpcPluginBase* base, int* result_length1);
static const gchar* gmpc_provider_lyr_db_real_get_name (GmpcPluginBase* base);
static void gmpc_provider_lyr_db_real_set_priority (GmpcPluginMetaDataIface* base, gint priority);
static gint gmpc_provider_lyr_db_real_get_priority (GmpcPluginMetaDataIface* base);
static void gmpc_provider_lyr_db_real_get_metadata (GmpcPluginMetaDataIface* base, const mpd_Song* song, MetaDataType type, GmpcPluginMetaDataCallback callback, void* callback_target);
static void gmpc_provider_lyr_db_get_song_txt (GmpcProviderLyrDB* self, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target);
static gchar* _gmpc_provider_lyr_db__convert_raw_data (GmpcProviderLyrDB* self, const gchar* raw_data);
static void gmpc_provider_lyr_db_handle_lyrics_download (GmpcProviderLyrDB* self, const GEADAsyncHandler* handle, GEADStatus status, void* d);
static void gmpc_provider_lyr_db_prop_free (GmpcProviderLyrDBProp* self);
static void gmpc_provider_lyr_db_download_lyrics (GmpcProviderLyrDB* self, GmpcProviderLyrDBProp* p);
static void _gmpc_provider_lyr_db_handle_lyrics_download_gmpc_async_download_callback_vala (const GEADAsyncHandler* handle, GEADStatus status, void* p, gpointer self);
static void gmpc_provider_lyr_db_parse_data (GmpcProviderLyrDB* self, GmpcProviderLyrDBProp* p, const gchar* raw_data);
static void gmpc_provider_lyr_db_handle_download (GmpcProviderLyrDB* self, const GEADAsyncHandler* handle, GEADStatus status, void* d);
static GmpcProviderLyrDBProp* gmpc_provider_lyr_db_prop_new (void);
static GmpcProviderLyrDBProp* gmpc_provider_lyr_db_prop_new (void);
static void _gmpc_provider_lyr_db_handle_download_gmpc_async_download_callback_vala (const GEADAsyncHandler* handle, GEADStatus status, void* p, gpointer self);
static GObject * gmpc_provider_lyr_db_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_provider_lyr_db_prop_instance_init (GmpcProviderLyrDBProp * self);
static void _meta_data_free0_ (gpointer var);
static void _g_list_free__meta_data_free0_ (GList* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gint GMPC_PROVIDER_LYR_DB_version[3] = {0, 0, 2};

static gint* gmpc_provider_lyr_db_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcProviderLyrDB * self;
	gint* result = NULL;
	gint* _tmp0_;
	self = (GmpcProviderLyrDB*) base;
	_tmp0_ = GMPC_PROVIDER_LYR_DB_version;
	*result_length1 = G_N_ELEMENTS (GMPC_PROVIDER_LYR_DB_version);
	result = _tmp0_;
	return result;
}


static const gchar* gmpc_provider_lyr_db_real_get_name (GmpcPluginBase* base) {
	GmpcProviderLyrDB * self;
	const gchar* result = NULL;
	self = (GmpcProviderLyrDB*) base;
	result = "Lyrics DB Plugin";
	return result;
}


static void gmpc_provider_lyr_db_real_set_priority (GmpcPluginMetaDataIface* base, gint priority) {
	GmpcProviderLyrDB * self;
	const gchar* _tmp0_ = NULL;
	self = (GmpcProviderLyrDB*) base;
	_tmp0_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	cfg_set_single_value_as_int (config, _tmp0_, "priority", priority);
}


static gint gmpc_provider_lyr_db_real_get_priority (GmpcPluginMetaDataIface* base) {
	GmpcProviderLyrDB * self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	self = (GmpcProviderLyrDB*) base;
	_tmp0_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	_tmp1_ = cfg_get_single_value_as_int_with_default (config, _tmp0_, "priority", 60);
	result = _tmp1_;
	return result;
}


static void gmpc_provider_lyr_db_real_get_metadata (GmpcPluginMetaDataIface* base, const mpd_Song* song, MetaDataType type, GmpcPluginMetaDataCallback callback, void* callback_target) {
	GmpcProviderLyrDB * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (GmpcProviderLyrDB*) base;
	g_return_if_fail (song != NULL);
	if (song == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = song->artist == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = song->title == NULL;
	}
	if (_tmp0_) {
		g_log (log_domain_ppldb, G_LOG_LEVEL_DEBUG, "LyrDB.vala:64: Insufficient information. doing nothing");
		callback (NULL, callback_target);
		return;
	}
	switch (type) {
		case META_SONG_TXT:
		{
			gmpc_provider_lyr_db_get_song_txt (self, song, callback, callback_target);
			return;
		}
		default:
		case META_ALBUM_ART:
		case META_ARTIST_ART:
		case META_ALBUM_TXT:
		case META_ARTIST_TXT:
		case META_ARTIST_SIMILAR:
		case META_SONG_SIMILAR:
		case META_GENRE_SIMILAR:
		case META_SONG_GUITAR_TAB:
		case META_QUERY_DATA_TYPES:
		case META_QUERY_NO_CACHE:
		{
			break;
		}
	}
	callback (NULL, callback_target);
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally25;
	__catch25_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally25:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* _gmpc_provider_lyr_db__convert_raw_data (GmpcProviderLyrDB* self, const gchar* raw_data) {
	gchar* result = NULL;
	gchar* data;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (raw_data != NULL, NULL);
	data = NULL;
	_tmp0_ = g_utf8_validate (raw_data, (gssize) (-1), NULL);
	if (!_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		g_log (log_domain_ppldb, G_LOG_LEVEL_WARNING, "LyrDB.vala:103: Input is invalid utf-8, try converting");
		_tmp1_ = g_convert ((const gchar*) raw_data, (gssize) (-1), "UTF-8", "ISO-8859-15", NULL, NULL, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		_g_free0 (data);
		data = _tmp2_;
		goto __finally24;
		__catch24_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_log (log_domain_ppldb, G_LOG_LEVEL_WARNING, "LyrDB.vala:114: Unable to convert input data: %s", e->message);
			_g_error_free0 (e);
		}
		__finally24:
		if (_inner_error_ != NULL) {
			_g_free0 (data);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ((const gchar*) raw_data);
		_g_free0 (data);
		data = _tmp3_;
	}
	if (data != NULL) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp4_ = string_chomp (data);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		_tmp6_ = string_replace (data, "\r\n", "\n");
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp7_);
	}
	result = data;
	return result;
}


static void gmpc_provider_lyr_db_handle_lyrics_download (GmpcProviderLyrDB* self, const GEADAsyncHandler* handle, GEADStatus status, void* d) {
	GmpcProviderLyrDBProp* p;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	p = (GmpcProviderLyrDBProp*) d;
	if (status == GEAD_PROGRESS) {
		return;
	} else {
		if (status == GEAD_DONE) {
			const gchar* _tmp0_ = NULL;
			const gchar* raw_data;
			gchar* _tmp1_ = NULL;
			gchar* data;
			_tmp0_ = gmpc_easy_handler_get_data_as_string (handle);
			raw_data = _tmp0_;
			_tmp1_ = _gmpc_provider_lyr_db__convert_raw_data (self, raw_data);
			data = _tmp1_;
			if (data != NULL) {
				MetaData* _tmp2_ = NULL;
				MetaData* pitem;
				const gchar* _tmp3_ = NULL;
				MetaData* _tmp4_;
				_tmp2_ = meta_data_new ();
				pitem = _tmp2_;
				pitem->type = META_SONG_TXT;
				_tmp3_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
				pitem->plugin_name = _tmp3_;
				pitem->content_type = META_DATA_CONTENT_TEXT;
				meta_data_set_text (pitem, (const gchar*) data);
				_tmp4_ = pitem;
				pitem = NULL;
				p->list = g_list_append (p->list, _tmp4_);
				g_log (log_domain_ppldb, G_LOG_LEVEL_DEBUG, "LyrDB.vala:153: Added item to the list");
				_meta_data_free0 (pitem);
			}
			_g_free0 (data);
		}
	}
	gmpc_provider_lyr_db_download_lyrics (self, p);
}


static void _gmpc_provider_lyr_db_handle_lyrics_download_gmpc_async_download_callback_vala (const GEADAsyncHandler* handle, GEADStatus status, void* p, gpointer self) {
	gmpc_provider_lyr_db_handle_lyrics_download (self, handle, status, p);
}


static void gmpc_provider_lyr_db_download_lyrics (GmpcProviderLyrDB* self, GmpcProviderLyrDBProp* p) {
	g_return_if_fail (self != NULL);
	if (p->results->length > 0) {
		gpointer _tmp0_ = NULL;
		gchar* path;
		_tmp0_ = g_queue_pop_tail (p->results);
		path = (gchar*) _tmp0_;
		g_log (log_domain_ppldb, G_LOG_LEVEL_DEBUG, "LyrDB.vala:165: Added Downloading: '%s'", path);
		gmpc_easy_async_downloader_vala (path, p, _gmpc_provider_lyr_db_handle_lyrics_download_gmpc_async_download_callback_vala, self);
		_g_free0 (path);
	} else {
		GList* _tmp1_;
		_tmp1_ = p->list;
		p->list = NULL;
		p->callback (_tmp1_, p->callback_target);
		gmpc_provider_lyr_db_prop_free (p);
	}
}


static void gmpc_provider_lyr_db_parse_data (GmpcProviderLyrDB* self, GmpcProviderLyrDBProp* p, const gchar* raw_data) {
	gchar* _tmp0_ = NULL;
	gchar* data;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** splitted;
	gint splitted_length1;
	gint _splitted_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (raw_data != NULL);
	_tmp0_ = _gmpc_provider_lyr_db__convert_raw_data (self, raw_data);
	data = _tmp0_;
	if (data == NULL) {
		_g_free0 (data);
		return;
	}
	_tmp2_ = _tmp1_ = g_strsplit ((const gchar*) data, "\n", 0);
	splitted = _tmp2_;
	splitted_length1 = _vala_array_length (_tmp1_);
	_splitted_size_ = _vala_array_length (_tmp1_);
	{
		gchar** entry_collection;
		int entry_collection_length1;
		int entry_it;
		entry_collection = splitted;
		entry_collection_length1 = splitted_length1;
		for (entry_it = 0; entry_it < splitted_length1; entry_it = entry_it + 1) {
			gchar* _tmp3_;
			gchar* entry;
			_tmp3_ = g_strdup (entry_collection[entry_it]);
			entry = _tmp3_;
			{
				gchar** _tmp4_;
				gchar** _tmp5_ = NULL;
				gchar** fields;
				gint fields_length1;
				gint _fields_size_;
				_tmp5_ = _tmp4_ = g_strsplit (entry, "\\", 0);
				fields = _tmp5_;
				fields_length1 = _vala_array_length (_tmp4_);
				_fields_size_ = _vala_array_length (_tmp4_);
				if (fields_length1 == 3) {
					gchar* _tmp6_ = NULL;
					gchar* path;
					gchar* _tmp7_;
					_tmp6_ = g_strdup_printf (GMPC_PROVIDER_LYR_DB_download_url, fields[0]);
					path = _tmp6_;
					_tmp7_ = path;
					path = NULL;
					g_queue_push_head (p->results, _tmp7_);
					_g_free0 (path);
				}
				fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (entry);
			}
		}
	}
	splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
}


static void gmpc_provider_lyr_db_handle_download (GmpcProviderLyrDB* self, const GEADAsyncHandler* handle, GEADStatus status, void* d) {
	GmpcProviderLyrDBProp* p;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	p = (GmpcProviderLyrDBProp*) d;
	if (status == GEAD_DONE) {
		const gchar* _tmp0_ = NULL;
		const gchar* data;
		_tmp0_ = gmpc_easy_handler_get_data_as_string (handle);
		data = _tmp0_;
		if (data != NULL) {
			gmpc_provider_lyr_db_parse_data (self, p, data);
		}
		g_log (log_domain_ppldb, G_LOG_LEVEL_DEBUG, "LyrDB.vala:205: Download done: results: %u ", p->results->length);
		if (p->results->length == 0) {
			p->callback (NULL, p->callback_target);
			gmpc_provider_lyr_db_prop_free (p);
		} else {
			gmpc_provider_lyr_db_download_lyrics (self, p);
		}
	} else {
		if (status == GEAD_PROGRESS) {
		} else {
			p->callback (NULL, p->callback_target);
			gmpc_provider_lyr_db_prop_free (p);
		}
	}
}


/**
 * Get artist art
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void _gmpc_provider_lyr_db_handle_download_gmpc_async_download_callback_vala (const GEADAsyncHandler* handle, GEADStatus status, void* p, gpointer self) {
	gmpc_provider_lyr_db_handle_download (self, handle, status, p);
}


static void gmpc_provider_lyr_db_get_song_txt (GmpcProviderLyrDB* self, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target) {
	GmpcProviderLyrDBProp* _tmp0_ = NULL;
	GmpcProviderLyrDBProp* p;
	GmpcProviderLyrDB* _tmp1_;
	mpd_Song* _tmp2_;
	GmpcPluginMetaDataCallback _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* path;
	g_return_if_fail (self != NULL);
	g_return_if_fail (song != NULL);
	_tmp0_ = gmpc_provider_lyr_db_prop_new ();
	p = _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (p->this);
	p->this = _tmp1_;
	_tmp2_ = _mpd_songDup0 (song);
	_mpd_freeSong0 (p->song);
	p->song = _tmp2_;
	_tmp3_ = callback;
	(p->callback_target_destroy_notify == NULL) ? NULL : (p->callback_target_destroy_notify (p->callback_target), NULL);
	p->callback = NULL;
	p->callback_target = NULL;
	p->callback_target_destroy_notify = NULL;
	p->callback = _tmp3_;
	p->callback_target = callback_target;
	p->callback_target_destroy_notify = NULL;
	_tmp4_ = gmpc_easy_download_uri_escape (song->artist);
	_tmp5_ = _tmp4_;
	_tmp6_ = gmpc_easy_download_uri_escape (song->title);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (GMPC_PROVIDER_LYR_DB_query, _tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	path = _tmp9_;
	g_log (log_domain_ppldb, G_LOG_LEVEL_DEBUG, "LyrDB.vala:243: Query song txt: %s ", path);
	gmpc_easy_async_downloader_vala (path, p, _gmpc_provider_lyr_db_handle_download_gmpc_async_download_callback_vala, self);
	_g_free0 (path);
}


GmpcProviderLyrDB* gmpc_provider_lyr_db_construct (GType object_type) {
	GmpcProviderLyrDB * self = NULL;
	self = (GmpcProviderLyrDB*) gmpc_plugin_base_construct (object_type);
	return self;
}


GmpcProviderLyrDB* gmpc_provider_lyr_db_new (void) {
	return gmpc_provider_lyr_db_construct (GMPC_PROVIDER_TYPE_LYR_DB);
}


static GObject * gmpc_provider_lyr_db_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcProviderLyrDB * self;
	parent_class = G_OBJECT_CLASS (gmpc_provider_lyr_db_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PROVIDER_LYR_DB (obj);
	((GmpcPluginBase*) self)->plugin_type = 8 + 32;
	return obj;
}


static void _meta_data_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (meta_data_free (var), NULL));
}


static void _g_list_free__meta_data_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _meta_data_free0_, NULL);
	g_list_free (self);
}


static GmpcProviderLyrDBProp* gmpc_provider_lyr_db_prop_new (void) {
	GmpcProviderLyrDBProp* self;
	self = g_slice_new0 (GmpcProviderLyrDBProp);
	gmpc_provider_lyr_db_prop_instance_init (self);
	return self;
}


static void gmpc_provider_lyr_db_prop_instance_init (GmpcProviderLyrDBProp * self) {
	GQueue* _tmp0_ = NULL;
	_tmp0_ = g_queue_new ();
	self->results = _tmp0_;
	self->list = NULL;
}


static void gmpc_provider_lyr_db_prop_free (GmpcProviderLyrDBProp* self) {
	_mpd_freeSong0 (self->song);
	_g_object_unref0 (self->this);
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
	_g_queue_free0 (self->results);
	__g_list_free__meta_data_free0_0 (self->list);
	g_slice_free (GmpcProviderLyrDBProp, self);
}


static void gmpc_provider_lyr_db_class_init (GmpcProviderLyrDBClass * klass) {
	gmpc_provider_lyr_db_parent_class = g_type_class_peek_parent (klass);
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_provider_lyr_db_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_provider_lyr_db_real_get_name;
	G_OBJECT_CLASS (klass)->constructor = gmpc_provider_lyr_db_constructor;
}


static void gmpc_provider_lyr_db_gmpc_plugin_meta_data_iface_interface_init (GmpcPluginMetaDataIfaceIface * iface) {
	gmpc_provider_lyr_db_gmpc_plugin_meta_data_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_priority = (void (*)(GmpcPluginMetaDataIface* ,gint)) gmpc_provider_lyr_db_real_set_priority;
	iface->get_priority = (gint (*)(GmpcPluginMetaDataIface*)) gmpc_provider_lyr_db_real_get_priority;
	iface->get_metadata = (void (*)(GmpcPluginMetaDataIface* ,const mpd_Song* ,MetaDataType ,GmpcPluginMetaDataCallback ,void*)) gmpc_provider_lyr_db_real_get_metadata;
}


static void gmpc_provider_lyr_db_instance_init (GmpcProviderLyrDB * self) {
}


GType gmpc_provider_lyr_db_get_type (void) {
	static volatile gsize gmpc_provider_lyr_db_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_provider_lyr_db_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcProviderLyrDBClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_provider_lyr_db_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcProviderLyrDB), 0, (GInstanceInitFunc) gmpc_provider_lyr_db_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_meta_data_iface_info = { (GInterfaceInitFunc) gmpc_provider_lyr_db_gmpc_plugin_meta_data_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gmpc_provider_lyr_db_type_id;
		gmpc_provider_lyr_db_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcProviderLyrDB", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_provider_lyr_db_type_id, GMPC_PLUGIN_TYPE_META_DATA_IFACE, &gmpc_plugin_meta_data_iface_info);
		g_once_init_leave (&gmpc_provider_lyr_db_type_id__volatile, gmpc_provider_lyr_db_type_id);
	}
	return gmpc_provider_lyr_db_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



