// Copyright © 2013, 2014, The Go-LXC Authors. All rights reserved.
// Use of this source code is governed by a LGPLv2.1
// license that can be found in the LICENSE file.

// +build linux,cgo

package lxc

const (
	ErrAddDeviceNodeFailed           = lxcError("adding device to container failed")
	ErrAllocationFailed              = lxcError("allocating memory failed")
	ErrAlreadyDefined                = lxcError("container already defined")
	ErrAlreadyFrozen                 = lxcError("container is already frozen")
	ErrAlreadyRunning                = lxcError("container is already running")
	ErrAttachFailed                  = lxcError("attaching to the container failed")
	ErrAttachInterfaceFailed         = lxcError("attaching specified netdev to the container failed")
	ErrBlkioUsage                    = lxcError("BlkioUsage for the container failed")
	ErrCheckpointFailed              = lxcError("checkpoint failed")
	ErrClearingConfigItemFailed      = lxcError("clearing config item for the container failed")
	ErrClearingCgroupItemFailed      = lxcError("clearing cgroup item for the container failed")
	ErrCloneFailed                   = lxcError("cloning the container failed")
	ErrCloseAllFdsFailed             = lxcError("setting close_all_fds flag for container failed")
	ErrCreateFailed                  = lxcError("creating the container failed")
	ErrCreateSnapshotFailed          = lxcError("snapshotting the container failed")
	ErrDaemonizeFailed               = lxcError("setting daemonize flag for container failed")
	ErrDestroyAllSnapshotsFailed     = lxcError("destroying all snapshots failed")
	ErrDestroyFailed                 = lxcError("destroying the container failed")
	ErrDestroySnapshotFailed         = lxcError("destroying the snapshot failed")
	ErrDestroyWithAllSnapshotsFailed = lxcError("destroying the container with all snapshots failed")
	ErrDetachInterfaceFailed         = lxcError("detaching specified netdev to the container failed")
	ErrExecuteFailed                 = lxcError("executing the command in a temporary container failed")
	ErrFreezeFailed                  = lxcError("freezing the container failed")
	ErrInsufficientNumberOfArguments = lxcError("insufficient number of arguments were supplied")
	ErrInterfaces                    = lxcError("getting interface names for the container failed")
	ErrIPAddresses                   = lxcError("getting IP addresses of the container failed")
	ErrIPAddress                     = lxcError("getting IP address on the interface of the container failed")
	ErrIPv4Addresses                 = lxcError("getting IPv4 addresses of the container failed")
	ErrIPv6Addresses                 = lxcError("getting IPv6 addresses of the container failed")
	ErrKMemLimit                     = lxcError("your kernel does not support cgroup kernel memory controller")
	ErrLoadConfigFailed              = lxcError("loading config file for the container failed")
	ErrMemLimit                      = lxcError("your kernel does not support cgroup memory controller")
	ErrMemorySwapLimit               = lxcError("your kernel does not support cgroup swap controller")
	ErrMethodNotAllowed              = lxcError("the requested method is not currently supported with unprivileged containers")
	ErrNewFailed                     = lxcError("allocating the container failed")
	ErrNoSnapshot                    = lxcError("container has no snapshot")
	ErrNotDefined                    = lxcError("container is not defined")
	ErrNotFrozen                     = lxcError("container is not frozen")
	ErrNotRunning                    = lxcError("container is not running")
	ErrNotSupported                  = lxcError("method is not supported by this LXC version")
	ErrRebootFailed                  = lxcError("rebooting the container failed")
	ErrRemoveDeviceNodeFailed        = lxcError("removing device from container failed")
	ErrRenameFailed                  = lxcError("renaming the container failed")
	ErrRestoreFailed                 = lxcError("restore failed")
	ErrRestoreSnapshotFailed         = lxcError("restoring the container failed")
	ErrSaveConfigFailed              = lxcError("saving config file for the container failed")
	ErrSettingCgroupItemFailed       = lxcError("setting cgroup item for the container failed")
	ErrSettingConfigItemFailed       = lxcError("setting config item for the container failed")
	ErrSettingConfigPathFailed       = lxcError("setting config file for the container failed")
	ErrSettingKMemoryLimitFailed     = lxcError("setting kernel memory limit for the container failed")
	ErrSettingMemoryLimitFailed      = lxcError("setting memory limit for the container failed")
	ErrSettingMemorySwapLimitFailed  = lxcError("setting memory+swap limit for the container failed")
	ErrSettingSoftMemoryLimitFailed  = lxcError("setting soft memory limit for the container failed")
	ErrShutdownFailed                = lxcError("shutting down the container failed")
	ErrSoftMemLimit                  = lxcError("your kernel does not support cgroup memory controller")
	ErrStartFailed                   = lxcError("starting the container failed")
	ErrStopFailed                    = lxcError("stopping the container failed")
	ErrTemplateNotAllowed            = lxcError("unprivileged users only allowed to use \"download\" template")
	ErrUnfreezeFailed                = lxcError("unfreezing the container failed")
	ErrUnknownBackendStore           = lxcError("unknown backend type")
	ErrReleaseFailed                 = lxcError("releasing the container failed")
)

type lxcError string

func (e lxcError) Error() string {
	return string(e)
}
