;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2015-2024 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2015 Andreas Enge <andreas@enge.fr>
;;; Copyright © 2015, 2016 Pjotr Prins <pjotr.guix@thebird.nl>
;;; Copyright © 2016, 2017 Ben Woodcroft <donttrustben@gmail.com>
;;; Copyright © 2016, 2017, 2018, 2020, 2021 Roel Janssen <roel@gnu.org>
;;; Copyright © 2017, 2018, 2019, 2020 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2017 Raoul Bonnal <ilpuccio.febo@gmail.com>
;;; Copyright © 2018 Vijayalakshmi Vedantham <vijimay12@gmail.com>
;;; Copyright © 2018 Sahithi Yarlagadda <sahi@swecha.net>
;;; Copyright © 2018 Sandeep Subramanian <sandeepsubramanian94@gmail.com>
;;; Copyright © 2018 Charlie Ritter <chewzeirta@posteo.net>
;;; Copyright © 2018 Konrad Hinsen <konrad.hinsen@fastmail.net>
;;; Copyright © 2018, 2020-2024 Mădălin Ionel Patrașcu <madalinionel.patrascu@mdc-berlin.de>
;;; Copyright © 2018 Laura Lazzati <laura.lazzati.15@gmail.com>
;;; Copyright © 2018 Leo Famulari <leo@famulari.name>
;;; Copyright © 2018 Marius Bakke <mbakke@fastmail.com>
;;; Copyright © 2018, 2019 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2019 Nicolò Balzarotti <anothersms@gmail.com>
;;; Copyright © 2019, 2020, 2021, 2022 Wiktor Żelazny <wzelazny@vurv.cz>
;;; Copyright © 2019 Arne Babenhauserheide <arne_bab@web.de>
;;; Copyright © 2019, 2020, 2023 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2020 Todor Kondić <tk.code@protonmail.com>
;;; Copyright © 2020 Danjela Lura <danielaluraa@gmail.com>
;;; Copyright © 2020 Naga Malleswari <nagamalli@riseup.net>
;;; Copyright © 2020 Eric Brown <ecbrown@ericcbrown.com>
;;; Copyright © 2020 Peter Lo <peterloleungyau@gmail.com>
;;; Copyright © 2020 Rafael Luque Leiva <rafael.luque@osoco.es>
;;; Copyright © 2020, 2021 Lars-Dominik Braun <ldb@leibniz-psychology.org>
;;; Copyright © 2020 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2020 Antoine Côté <antoine.cote@posteo.net>
;;; Copyright © 2020 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2020 Magali Lemes <magalilemes00@gmail.com>
;;; Copyright © 2020, 2021, 2022, 2023 Simon Tournier <zimon.toutoune@gmail.com>
;;; Copyright © 2020 Aniket Patil <aniket112.patil@gmail.com>
;;; Copyright © 2021 Marcel Schilling <marcel.schilling@uni-luebeck.de>
;;; Copyright © 2021 Guillaume Le Vaillant <glv@posteo.net>
;;; Copyright © 2022-2024 Navid Afkhami <navid.afkhami@mdc-berlin.de>
;;; Copyright © 2022 Greg Hogan <code@greghogan.com>
;;; Copyright © 2024 Marco Baggio <guix@mawumag.com>
;;; Copyright © 2024 Spencer King <spencer.king@geneoscopy.com>
;;; Copyright © 2024 Tor-björn Claesson <tclaesson@gmail.com>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages cran)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
  #:use-module (guix download)
  #:use-module (guix gexp)
  #:use-module (guix git-download)
  #:use-module (guix utils)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system r)
  #:use-module (gnu packages)
  #:use-module (gnu packages algebra)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages base)
  #:use-module (gnu packages bioinformatics)
  #:use-module (gnu packages c)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages crypto)
  #:use-module (gnu packages curl)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages fribidi)
  #:use-module (gnu packages gawk)
  #:use-module (gnu packages gcc)
  #:use-module (gnu packages geo)
  #:use-module (gnu packages ghostscript)
  #:use-module (gnu packages gl)
  #:use-module (gnu packages gnome)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages haskell-xyz)
  #:use-module (gnu packages icu4c)
  #:use-module (gnu packages image)
  #:use-module (gnu packages imagemagick)
  #:use-module (gnu packages java)
  #:use-module (gnu packages javascript)
  #:use-module (gnu packages libevent)
  #:use-module (gnu packages machine-learning)
  #:use-module (gnu packages maths)
  #:use-module (gnu packages mpi)
  #:use-module (gnu packages multiprecision)
  #:use-module (gnu packages networking)
  #:use-module (gnu packages node)
  #:use-module (gnu packages pcre)
  #:use-module (gnu packages pdf)
  #:use-module (gnu packages perl)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages pulseaudio)  ;libsndfile
  #:use-module (gnu packages protobuf)
  #:use-module (gnu packages python)
  #:use-module (gnu packages python-xyz)
  #:use-module (gnu packages rdf)
  #:use-module (gnu packages rust)
  #:use-module (gnu packages ssh)
  #:use-module (gnu packages sqlite)
  #:use-module (gnu packages statistics)
  #:use-module (gnu packages tbb)
  #:use-module (gnu packages tcl)
  #:use-module (gnu packages tex)
  #:use-module (gnu packages textutils)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages uglifyjs)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages video)
  #:use-module (gnu packages web)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xorg))

(define-public r-abbreviate
  (package
    (name "r-abbreviate")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abbreviate" version))
       (sha256
        (base32 "1cvjdbi17qz8gr5898zchm5fyz4n51z66lwps25v8a9mhwab8imi"))))
    (properties `((upstream-name . "abbreviate")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/sigbertklinke/abbreviate")
    (synopsis "Readable string abbreviation")
    (description
     "This package abbreviates strings to a specified minimum number of
characters, such that the strings remain unique (if they originally were).")
    (license license:gpl3)))

(define-public r-aer
  (package
    (name "r-aer")
    (version "1.2-14")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "AER" version))
              (sha256
               (base32
                "06l7h1gdyc007hx5xavkb879mgqnskcq2zrbr0xbm88rv1b63a26"))))
    (properties `((upstream-name . "AER")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-formula
           r-lmtest
           r-sandwich
           r-survival
           r-zoo))
    (native-inputs (list r-foreign))
    (home-page "https://cran.r-project.org/package=AER")
    (synopsis "Applied econometrics with R")
    (description
     "This package provides functions, data sets, examples, demos, and
vignettes for the book Christian Kleiber and Achim Zeileis (2008), Applied
Econometrics with R, Springer-Verlag, New York.  ISBN 978-0-387-77316-2. (See
the vignette \"AER\" for a package overview.)")
    ;; Either version of the GPL
    (license (list license:gpl2 license:gpl3))))

(define-public r-afpt
  (package
    (name "r-afpt")
    (version "1.1.0.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "afpt" version))
              (sha256
               (base32
                "15pa4p78p6r478l05481lzx6z4ahswj728s1sb3xp3pvn6rv4jfj"))))
    (properties `((upstream-name . "afpt")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/MarcoKlH/afpt-r/")
    (synopsis "Tools for modelling of animal flight performance")
    (description
     "This package allows estimation and modelling of flight costs in animal
(vertebrate) flight, implementing the aerodynamic power model.  Flight
performance is estimated based on basic morphological measurements such as
body mass, wingspan and wing area.  @code{Afpt} can be used to make
predictions on how animals should adjust their flight behaviour and wingbeat
kinematics to varying flight conditions.")
    (license license:gpl3+)))

(define-public r-aod
  (package
    (name "r-aod")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aod" version))
       (sha256
        (base32 "0zh8sjzbsq3sjzayv8wa0n1vh654g47xkxklgzxcsy3xpy55w95p"))))
    (properties `((upstream-name . "aod")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=aod")
    (synopsis "Analysis of overdispersed data")
    (description
     "This package provides a set of functions to analyze overdispersed counts
or proportions.  Most of the methods are already available elsewhere but are
scattered in different packages.  The proposed functions should be considered
as complements to more sophisticated methods such as @dfn{generalized
estimating equations} (GEE) or @dfn{generalized linear mixed effect
models} (GLMM).")
    (license license:gpl2+)))

(define-public r-asioheaders
  (package
    (name "r-asioheaders")
    (version "1.22.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AsioHeaders" version))
       (sha256
        (base32 "192qxayrpvi02wrqq2h5cjc92aaxrsgw7z32r8qk5imqg3mc0a8n"))))
    (properties `((upstream-name . "AsioHeaders")))
    (build-system r-build-system)
    (home-page "https://github.com/eddelbuettel/asioheaders")
    (synopsis "Asio C++ header files")
    (description
     "Asio is a cross-platform C++ library for network and low-level I/O
programming that provides developers with a consistent asynchronous model
using a modern C++ approach.  It is also included in Boost but requires
linking when used with Boost.  Standalone it can be used header-only (provided
a recent compiler).  Asio is written and maintained by Christopher
M. Kohlhoff, and released under the Boost Software License', Version 1.0.")
    (license license:boost1.0)))

(define-public r-beepr
  (package
    (name "r-beepr")
    (version "2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "beepr" version))
       (sha256
        (base32 "0xq4qs06f61m1q6gb157n4c3j7pf7wanh27nr2lr228s7k4mw3k2"))))
    (properties `((upstream-name . "beepr")))
    (build-system r-build-system)
    (propagated-inputs (list r-audio))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/rasmusab/beepr")
    (synopsis "Easily play notification sounds on any platform")
    (description
     "The main function of this package is @code{beep()}, with the purpose to
make it easy to play notification sounds on whatever platform you are on.  It
is intended to be useful, for example, if you are running a long analysis in
the background and want to know when it is ready.")
    (license license:gpl3)))

(define-public r-betareg
  (package
    (name "r-betareg")
    (version "3.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "betareg" version))
       (sha256
        (base32 "1izp7nirsziwx8803ckbgwyj4r1vf4ixgx5nlin7d5pkjy13c9mv"))))
    (properties `((upstream-name . "betareg")))
    (build-system r-build-system)
    ;; Vignettes need r-quarto.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-flexmix r-formula r-lmtest r-modeltools
                             r-sandwich))
    (native-inputs (list r-partykit))
    (home-page "https://topmodels.R-Forge.R-project.org/betareg/")
    (synopsis "Beta regression")
    (description
     "This package implements beta regression for modeling beta-distributed
dependent variables on the open unit interval (0, 1), e.g., rates and
proportions, see Cribari-Neto and Zeileis (2010) <doi:10.18637/jss.v034.i02>.
Moreover, extended-support beta regression models can accommodate dependent
variables with boundary observations at 0 and/or 1.  For the classical beta
regression model, alternative specifications are provided: Bias-corrected and
bias-reduced estimation, finite mixture models, and recursive partitioning for
beta regression, see <doi:10.18637/jss.v048.i11>.")
    (license (list license:gpl2 license:gpl3))))

(define-public r-bma
  (package
    (name "r-bma")
    (version "3.18.19")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BMA" version))
       (sha256
        (base32 "0hldrbl7bcf5rchc5vl8v1y679yjbxq8pca79pgc3g607pnddsh9"))))
    (properties `((upstream-name . "BMA")))
    (build-system r-build-system)
    (propagated-inputs (list r-inline r-leaps r-robustbase r-rrcov r-survival))
    (native-inputs (list gfortran r-mass))
    (home-page "https://github.com/hanase/BMA")
    (synopsis "Bayesian model averaging")
    (description
     "This is a package for Bayesian model averaging and variable selection
for linear models, generalized linear models and survival models (cox
regression).")
    (license license:gpl2+)))

(define-public r-box
  (package
    (name "r-box")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "box" version))
       (sha256
        (base32 "00g5ik3f6260m38jl8k4s8nycmy7mzdwr7qslrl66phpg84xzmln"))))
    (properties `((upstream-name . "box")))
    (arguments
     ;; Tests don't work because of this error:
     ;; the ‘box’ package is not supposed to be attached!
     (list #:test-types '(list "vignettes")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://klmr.me/box/")
    (synopsis "Write reusable, composable and modular R code")
    (description
     "This package provides a modern module system for R.  Organize code into
hierarchical, composable, reusable modules, and use it effortlessly across
projects via a flexible, declarative dependency loading syntax.")
    (license license:expat)))

(define-public r-bread
  (package
    (name "r-bread")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bread" version))
       (sha256
        (base32 "0vsxmqpgi2yjcpdpgdz6gzqkpjsq5ax4qkpys60bwmxyp1ahv90r"))))
    (properties `((upstream-name . "bread")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'fix-locations
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((gawk (search-input-file inputs "bin/gawk"))
                   (grep (search-input-file inputs "bin/grep"))
                   (head (search-input-file inputs "bin/head"))
                   (sed  (search-input-file inputs "bin/sed"))
                   (tail (search-input-file inputs "bin/tail"))
                   (wc   (search-input-file inputs "bin/wc")))
               (substitute* "R/helper_functions.R"
                 (("'grep ")
                  (string-append "'" grep " "))
                 (("'sed ")
                  (string-append "'" sed " "))
                 (("'tail ")
                  (string-append "'" tail " "))
                 (("'awk ")
                  (string-append "'" gawk " ")))
               (substitute* "R/bnrow.R"
                 (("'wc ")
                  (string-append "'" wc " ")))
               (substitute* "R/bsep.R"
                 (("'head ")
                  (string-append "'" head " ")))))))))
    (inputs (list coreutils gawk grep sed))
    (propagated-inputs (list r-data-table))
    (home-page "https://github.com/MagicHead99/bread/")
    (synopsis "Analyze big files without loading them in memory")
    (description
     "This package provides a simple set of wrapper functions for
@code{data.table::fread()} that allows subsetting or filtering rows and
selecting columns of table-formatted files too large for the available RAM.")
    (license license:gpl3+)))

(define-public r-brio
  (package
    (name "r-brio")
    (version "1.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "brio" version))
       (sha256
        (base32
         "1f6hh7mck4bb1caivcvr6ms2pyqzzzawqyxjbgi9s0rrx8sj7wm9"))))
    (properties
     ;; We can't add testthat here because of a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))
       (upstream-name . "brio")))
    (build-system r-build-system)
    ;; Tests require r-testthat, which uses r-brio as an input.
    (arguments (list #:tests? #false))
    (home-page "https://github.com/r-lib/brio")
    (synopsis "Basic R input output")
    (description
     "This package provides functions to handle basic input output.  These
functions always read and write UTF-8 (8-bit Unicode Transformation Format)
files and provide more explicit control over line endings.")
    (license license:expat)))

(define-public r-broom-helpers
  (package
    (name "r-broom-helpers")
    (version "1.17.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "broom.helpers" version))
       (sha256
        (base32 "0k97smqgxggdkbgfs2yvvgqw225q9106124kaw499m6cjcldxqyi"))))
    (properties `((upstream-name . "broom.helpers")))
    (build-system r-build-system)
    ;; Tests require gtsummary, which cannot be packaged due to massive
    ;; amounts of minified JavaScript.
    (arguments (list #:test-types '(list "vignettes")))
    (propagated-inputs (list r-broom
                             r-cards
                             r-cli
                             r-dplyr
                             r-labelled
                             r-lifecycle
                             r-purrr
                             r-rlang
                             r-stringr
                             r-tibble
                             r-tidyr))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://larmarange.github.io/broom.helpers/")
    (synopsis "Helpers for Model Coefficients Tibbles")
    (description
     "This package provides suite of functions to work with regression model
@code{broom::tidy()} tibbles.  The suite includes functions to group
regression model terms by variable, insert reference and header rows for
categorical variables, add variable labels, and more.")
    (license license:gpl3+)))

(define-public r-ca
  (package
    (name "r-ca")
    (version "0.71.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ca" version))
              (sha256
               (base32
                "095lk7p2b9835hc3a03c4019wg0baf0dhz6c2vqpaq1m9k4jy304"))))
    (properties `((upstream-name . "ca")))
    (build-system r-build-system)
    (home-page "http://www.carme-n.org/")
    (synopsis "Simple, multiple and joint correspondence analysis")
    (description
     "This is a package for computation and visualization of simple,
multiple and joint correspondence analysis.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-cachem
  (package
    (name "r-cachem")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cachem" version))
       (sha256
        (base32
         "089f963h59z4n0sj3isjq2h7zw2485qw38jv8zdnbn755by3j22m"))))
    (properties `((upstream-name . "cachem")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastmap r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://cachem.r-lib.org/")
    (synopsis "Cache R objects with automatic pruning")
    (description
     "This package provides key-value stores with automatic pruning.  Caches
can limit either their total size or the age of the oldest object (or both),
automatically pruning objects to maintain the constraints.")
    (license license:expat)))

(define-public r-caic4
  (package
    (name "r-caic4")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cAIC4" version))
       (sha256
        (base32 "1qg73g0g029wkzpmp0fgvyfz8p1k3x38yqx0404cpb3dxj4n4hcg"))))
    (properties `((upstream-name . "cAIC4")))
    (build-system r-build-system)
    (propagated-inputs (list r-lme4
                             r-matrix
                             r-mgcv
                             r-mvtnorm
                             r-nlme
                             r-rlrsim))
    (home-page "https://cran.r-project.org/package=cAIC4")
    (synopsis "Conditional AIC for lme4 and nlme")
    (description
     "This package estimates conditional Akaike information in mixed-effect
models.  These models are fitted using @code{(g)lmer()} from lme4,
@code{lme()} from nlme, and @code{gamm()} from mgcv.  The provided functions
facilitate the computation of the conditional Akaike information for model
evaluation.")
    (license license:gpl2+)))

(define-public r-cards
  (package
    (name "r-cards")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cards" version))
       (sha256
        (base32 "1rwa0xh5inyyk1j21d69nasjzyx6rrck9zc194j1xm77zj6z77v7"))))
    (properties `((upstream-name . "cards")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-dplyr
                             r-glue
                             r-rlang
                             r-tidyr
                             r-tidyselect))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/insightsengineering/cards")
    (synopsis "Analysis Results Data")
    (description
     "This package lets you construct @dfn{Clinical Data Interchange Standards
Consortium} (CDISC) compliant Analysis Results Data objects.  These objects
are used and re-used to construct summary tables, visualizations, and written
reports.  The package also exports utilities for working with these objects
and creating new Analysis Results Data objects.")
    (license license:asl2.0)))

(define-public r-castor
  (package
    (name "r-castor")
    (version "1.8.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "castor" version))
              (sha256
               (base32
                "1850i35qsxw7dkkblixnp4h5zhwg0ysx8rzns5h0kr9lwmil6biw"))))
    (properties `((upstream-name . "castor")))
    (build-system r-build-system)
    (propagated-inputs (list r-jsonlite r-matrix r-naturalsort r-rcpp
                             r-rspectra))
    (home-page "https://cran.r-project.org/package=castor")
    (synopsis "Efficient phylogenetics on large trees")
    (description
     "This tool supports analyses on massive phylogenies comprising up to
millions of tips.  Functions include pruning, rerooting, calculation of
most-recent common ancestors, calculating distances from the tree root and
calculating pairwise distances.  In addition, this tool takes care of
calculation of phylogenetic signal and mean trait depth (trait conservatism),
ancestral state reconstruction and hidden character prediction of discrete
characters, simulating and fitting models of trait evolution, fitting and
simulating diversification models, dating trees, comparing trees, and
reading/writing trees in Newick format.")
    (license license:gpl2+)))

(define-public r-chameleon
  (package
    (name "r-chameleon")
    (version "0.2-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "chameleon" version))
       (sha256
        (base32 "0a3azp0zaakpqqx0pp94hkj3vgb2apnf8gb5ga0as4i8lrn9dz8i"))))
    (properties `((upstream-name . "chameleon")))
    (build-system r-build-system)
    (propagated-inputs (list r-clue r-ggplot2 r-umap))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=chameleon")
    (synopsis "Automatic colors for multi-dimensional data")
    (description
     "This package lets you assign distinct colors to arbitrary
multi-dimensional data, considering its structure.")
    (license license:expat)))

(define-public r-changepoint
  (package
    (name "r-changepoint")
    (version "2.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "changepoint" version))
              (sha256
               (base32
                "0bb8pcfwb8vjmg7n7giad1vi1s6ix486lcsb28zvxih7v04v1a0r"))))
    (properties `((upstream-name . "changepoint")))
    (build-system r-build-system)
    (propagated-inputs (list r-zoo))
    (native-inputs (list r-testthat r-vdiffr))
    (home-page "https://github.com/rkillick/changepoint/")
    (synopsis "Methods for changepoint detection")
    (description
     "Changepoint implements various mainstream and specialised changepoint
methods.  These methods are suitable for finding single and multiple
changepoints within data.  Many popular non-parametric and frequentist methods
are included as well.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-celestial
  (package
    (name "r-celestial")
    (version "1.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "celestial" version))
       (sha256
        (base32 "1gls0qvr8mxz79lsmk76v253f747g0cqys8p8wjmpijs8r0pyr4z"))))
    (properties `((upstream-name . "celestial")))
    (build-system r-build-system)
    (propagated-inputs (list r-nistunits r-pracma r-rann))
    (home-page "https://cran.r-project.org/package=celestial")
    (synopsis
     "Collection of common astronomical conversion routines and functions")
    (description
     "This package contains a number of common astronomy conversion routines,
particularly the HMS and degrees schemes, which can be fiddly to convert between
on mass due to the textural nature of the former.  It allows users to coordinate
match datasets quickly.  It also contains functions for various cosmological
calculations.")
    (license license:gpl3)))

(define-public r-cetcolor
  (package
    (name "r-cetcolor")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cetcolor" version))
       (sha256
        (base32 "0kygdcr9ldanr0z4qpygwh0padki7s2ad0j6myky601g4228z79q"))))
    (properties `((upstream-name . "cetcolor")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://github.com/coatless-rpkg/cetcolor")
    (synopsis "CET perceptually uniform color maps")
    (description
     "This package provides a collection of perceptually uniform color maps
made by Peter Kovesi (2015) \"Good Colour Maps: How to Design Them\"
<arXiv:1509.03700> at the Centre for Exploration Targeting (CET).")
    (license license:cc-by-sa4.0)))

;; The package sources include multiple non-minified JavaScript files and the
;; v5.1.0 variant of d3.js.  The d3.js file is not minified.
(define-public r-chromomap
  (package
    (name "r-chromomap")
    (version "4.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "chromoMap" version))
       (sha256
        (base32 "1067h5d6jdbm811n7ayikhqfbcqmxbz5jgp05vf1sbln7qgn9l43"))))
    (properties `((upstream-name . "chromoMap")))
    (build-system r-build-system)
    (propagated-inputs (list r-htmltools r-htmlwidgets))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=chromoMap")
    (synopsis "Interactive genomic visualization of biological data")
    (description
     "This package provides interactive, configurable and graphics
visualization of the chromosome regions of any living organism allowing users
to map chromosome elements (like genes, SNPs etc.) on the chromosome plot.  It
introduces a special plot viz. the \"chromosome heatmap\" that, in addition to
mapping elements, can visualize the data associated with chromosome
elements (like gene expression) in the form of heat colors.  Users can
investigate the detailed information about the mappings (like gene names or
total genes mapped on a location) or can view the magnified single or double
stranded view of the chromosome at a location showing each mapped element in
sequential order.  The package provide multiple features like visualizing
multiple sets, chromosome heat-maps, group annotations, adding hyperlinks, and
labelling.  The plots can be saved as HTML documents that can be customized
and shared easily.  In addition, you can include them in R Markdown or in R
Shiny applications.")
    (license (list license:gpl3
                   license:isc)))) ;for bundled d3js

(define-public r-colorsgen
  (package
    (name "r-colorsgen")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "colorsGen" version))
       (sha256
        (base32 "0w4qkl4fw7pjfcd2z3nhpkxh8kv3bbq19bi2cg0ivfr83kxa44fj"))))
    (properties `((upstream-name . "colorsGen")))
    (build-system r-build-system)
    (propagated-inputs (list r-colorspace))
    (home-page "https://github.com/stla/colorsGen")
    (synopsis "Generation of random colors")
    (description
     "This package lets you generate random colors, possibly with a given hue
or a given luminosity.")
    (license license:cc0)))

(define-public r-consort
  (package
    (name "r-consort")
    (version "1.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "consort" version))
              (sha256
               (base32
                "12gr1diyy2azy1fbh8z129lkm0ahwvm98j5hqxv93yp089a02l8c"))))
    (properties `((upstream-name . "consort")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/adayim/consort/")
    (synopsis "Create Consort Diagrams")
    (description
     "To make it easy to create CONSORT diagrams for the transparent reporting of
participant allocation in randomized, controlled clinical trials.  This is done
by creating a standardized disposition data, and using this data as the source
for the creation a standard CONSORT diagram.  Human effort by supplying text
labels on the node can also be achieved.")
    (license license:expat)))

(define-public r-collapse
  (package
    (name "r-collapse")
    (version "2.0.17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "collapse" version))
       (sha256
        (base32 "1pgvq5h0yi04sb7a44qzn3j6lnzfds7kz9i6hh8mmqfcyljbv240"))))
    (properties `((upstream-name . "collapse")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://sebkrantz.github.io/collapse/")
    (synopsis "Advanced and fast data transformation")
    (description
     "This is a C/C++ based package for advanced data transformation and
statistical computing in R that is extremely fast, class-agnostic, robust and
programmer friendly.  Core functionality includes a rich set of S3 generic
grouped and weighted statistical functions for vectors, matrices and data
frames, which provide efficient low-level vectorizations, @code{OpenMP}
multithreading, and skip missing values by default.  These are integrated with
fast grouping and ordering algorithms (also callable from C), and efficient
data manipulation functions.  The package also provides a flexible and
rigorous approach to time series and panel data in R.  It further includes
fast functions for common statistical procedures, detailed (grouped, weighted)
summary statistics, powerful tools to work with nested data, fast data object
conversions, functions for memory efficient R programming, and helpers to
effectively deal with variable labels, attributes, and missing data.")
    (license (list license:gpl2+))))

(define-public r-collections
  (package
    (name "r-collections")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "collections" version))
       (sha256
        (base32 "003zlp5s2ilq3pq0imlp7p46jkfihwzg1hkkgk7378ikcbwnz17z"))))
    (properties `((upstream-name . "collections")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/randy3k/collections")
    (synopsis "High performance container data types")
    (description
     "This package provides high performance container data types such as
queues, stacks, deques, dicts and ordered dicts.")
    (license license:expat)))

(define-public r-correlation
  (package
    (name "r-correlation")
    (version "0.8.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "correlation" version))
              (sha256
               (base32
                "0sss7xr9k31kyxgbwbg8gk5bqxyvpb29pjvah0kg9i75sqqvnpms"))))
    (properties `((upstream-name . "correlation")))
    (build-system r-build-system)
    (propagated-inputs (list r-bayestestr r-datawizard r-insight r-parameters))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://easystats.github.io/correlation/")
    (synopsis "Methods for correlation analysis")
    (description
     "This is a lightweight package for computing different kinds of
correlations.  These correlations include partial correlations, Bayesian
correlations, multilevel correlations, polychoric correlations, biweight
correlations, distance correlations and more.")
    (license license:gpl3)))

(define-public r-cosinor
  (package
    (name "r-cosinor")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cosinor" version))
       (sha256
        (base32 "0nyvzmqk0rhx10fki29hcrz014bv3r40adqd5d6rbcz66kc4sjy3"))))
    (properties `((upstream-name . "cosinor")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-shiny))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/sachsmc/cosinor")
    (synopsis "Tools for estimating and predicting the Cosinor model")
    (description
     "This package provides a set of simple functions that transforms
longitudinal data to estimate the cosinor linear model as described in
Tong (1976).  Methods are given to summarize the mean, amplitude and
acrophase, to predict the mean annual outcome value, and to test the
coefficients.")
    (license license:expat)))

(define-public r-cosinor2
  (package
    (name "r-cosinor2")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cosinor2" version))
       (sha256
        (base32 "1pp0z86fflqkkllfrzx3vj98kzxjwnawr4a2d8z5q6zhq6v5qrvf"))))
    (properties `((upstream-name . "cosinor2")))
    (build-system r-build-system)
    (propagated-inputs (list r-cosinor
                             r-cowplot
                             r-ggplot2
                             r-hmisc
                             r-magrittr
                             r-matrixstats
                             r-purrr
                             r-scales
                             r-stringr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/amutak/cosinor2")
    (synopsis "Extended tools for Cosinor analysis of rhythms")
    (description
     "This package provides statistical procedures for calculating
population-mean cosinor, non-stationary cosinor, estimation of best-fitting
period, tests of population rhythm differences and more.")
    (license license:gpl3)))

(define-public r-countrycode
  (package
    (name "r-countrycode")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "countrycode" version))
       (sha256
        (base32 "1dix4prcavwbi7l7ifw1frvpmqqdcrvk4c45xl7ckg6068713nzr"))))
    (properties `((upstream-name . "countrycode")))
    (build-system r-build-system)
    (native-inputs (list r-testthat r-tibble r-utf8))
    (home-page "https://vincentarelbundock.github.io/countrycode/")
    (synopsis "Convert country names and country codes")
    (description
     "This package lets you standardize country names, convert them into one
of 40 different coding schemes, convert between coding schemes, and assign
region descriptors.")
    (license license:gpl3)))

(define-public r-cplm
  (package
    (name "r-cplm")
    (version "0.7-12.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cplm" version))
       (sha256
        (base32 "0z99fnmadjpx7d41p575dypy3pgsxxzani9npyishv5719hw35cf"))))
    (properties `((upstream-name . "cplm")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; GET_SLOT is only found in Rdefines.h
         (add-after 'unpack 'compatibility
           (lambda _
             (substitute* "src/common.h"
               (("#include <Rinternals.h>" m)
                (string-append m "\n#include <Rdefines.h>"))))))))
    (propagated-inputs
     (list r-biglm
           r-coda
           r-ggplot2
           r-matrix
           r-minqa
           r-nlme
           r-reshape2
           r-statmod
           r-tweedie))
    (home-page "https://github.com/actuaryzhang/cplm")
    (synopsis "Compound Poisson linear models")
    (description "The Tweedie compound Poisson distribution is a mixture of a
degenerate distribution at the origin and a continuous distribution on the
positive real line.  It has been applied in a wide range of fields in which
continuous data with exact zeros regularly arise.  The cplm package provides
likelihood based and Bayesian procedures for fitting common Tweedie compound
Poisson linear models.  In particular, models with hierarchical structures or
extra zero inflation can be handled.  Further, the package implements the Gini
index based on an ordered version of the Lorenz curve as a robust model
comparison tool involving zero-inflated and highly skewed distributions.")
    (license license:gpl2+)))

(define-public r-cubist
  (package
    (name "r-cubist")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Cubist" version))
       (sha256
        (base32 "140m4if4g4v74dwhzdp4bgdgy4zzcyplxqd311gfg7dn0kqzzmai"))))
    (properties `((upstream-name . "Cubist")))
    (build-system r-build-system)
    (propagated-inputs (list r-lattice r-reshape2))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://topepo.github.io/Cubist/")
    (synopsis "Rule- and instance-based regression modeling")
    (description
     "This is package for regression modeling using rules with added
instance-based corrections.")
    (license license:gpl3)))

(define-public r-curry
  (package
    (name "r-curry")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "curry" version))
       (sha256
        (base32
         "1ps9hvbnb02m0b8hlw4admwbziyjvswj08ldi2dk3ymnrpawcc29"))))
    (properties `((upstream-name . "curry")))
    (build-system r-build-system)
    (home-page "https://github.com/thomasp85/curry")
    (synopsis "Partial function application")
    (description
     "Partial application is the process of reducing the arity of a function
by fixing one or more arguments, thus creating a new function lacking the
fixed arguments.  The @code{curry} package provides three different ways of
performing partial function application by fixing arguments from either end of
the argument list (currying and tail currying) or by fixing multiple named
arguments (partial application).  This package provides this functionality
through the @code{%<%}, @code{%-<%}, and @code{%><%} operators which allows
for a programming style comparable to modern functional languages.  Compared
to other implementations such a @code{purrr::partial()} the operators in
@code{curry} composes functions with named arguments, aiding in autocomplete
etc.")
    (license license:gpl2+)))

(define-public r-cutpointr
  (package
    (name "r-cutpointr")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cutpointr" version))
       (sha256
        (base32 "1qxnh20hs3bh9v04ls7gwwl7lfc6bwl8c88dn8lkcdqyp3nyr01j"))))
    (properties `((upstream-name . "cutpointr")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-foreach
                             r-ggplot2
                             r-gridextra
                             r-purrr
                             r-rcpp
                             r-rlang
                             r-tibble
                             r-tidyr
                             r-tidyselect))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/thie1e/cutpointr")
    (synopsis "Determine optimal cutpoints for binary classification")
    (description
     "This package estimates optimal cutpoints for binary classification metrics.
It also validates performance using bootstrapping.  Some methods for more
robust cutpoint estimation are supported, e.g. a parametric method assuming
normal distributions, bootstrapped cutpoints, and smoothing of the metric
values per cutpoint using Generalized Additive Models.  Various plotting
functions are included.")
    (license license:gpl3)))

(define-public r-datawizard
  (package
    (name "r-datawizard")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "datawizard" version))
       (sha256
        (base32
         "12pybh84r8rjnbbyrsribsp1akhpyq20klqywbs2srxkqf2q2rxz"))))
    (properties `((upstream-name . "datawizard")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-insight))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://easystats.github.io/datawizard/")
    (synopsis "Easy data wrangling")
    (description
     "This package provides a lightweight package to easily manipulate,
clean, transform, and prepare your data for analysis.  It also forms the data
wrangling backend for the packages in the @code{easystats} ecosystem.")
    (license license:gpl3)))

(define-public r-dbscan
  (package
    (name "r-dbscan")
    (version "1.2-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dbscan" version))
       (sha256
        (base32 "0rv2h5i539ivkgwblfapjpfl09hgxvidkk6x1wmgc6hp30nbl2bj"))))
    (properties `((upstream-name . "dbscan")))
    (build-system r-build-system)
    (propagated-inputs (list r-generics r-rcpp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/mhahsler/dbscan")
    (synopsis "Density-based spatial clustering of applications with noise")
    (description
     "This package provides a fast reimplementation of several density-based
algorithms of the DBSCAN family.  It includes the clustering algorithms DBSCAN
(density-based spatial clustering of applications with noise) and
@dfn{hierarchical DBSCAN} (HDBSCAN), the ordering algorithm @dfn{ordering
points to identify the clustering structure} (OPTICS), shared nearest neighbor
clustering, and the outlier detection algorithms @dfn{local outlier
factor} (LOF) and @dfn{global-local outlier score from hierarchies} (GLOSH).
The implementations use the kd-tree data structure for faster k-nearest
neighbor search.  An R interface to fast kNN and fixed-radius NN search is
also provided.")
    (license license:gpl2+)))

(define-public r-diffobj
  (package
    (name "r-diffobj")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "diffobj" version))
       (sha256
        (base32
         "0q6gwd9pqh41f6j5p9jl92aji4p8kx9inffpha93d7jc3ndsfq6q"))))
    (properties `((upstream-name . "diffobj")))
    (build-system r-build-system)
    (propagated-inputs (list r-crayon))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/brodieG/diffobj")
    (synopsis "Diffs for R objects")
    (description
     "Generate a colorized diff of two R objects for an intuitive
visualization of their differences.")
    (license license:gpl2+)))

(define-public r-dint
  (package
    (name "r-dint")
    (version "2.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dint" version))
       (sha256
        (base32 "0qfvxzix6k24xnjxh9nhz9dq3qfwl14mnd7rp03l8yvh6frws8fh"))))
    (properties `((upstream-name . "dint")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/s-fleck/dint")
    (synopsis "Toolkit for year-quarter, year-month and year-isoweek dates")
    (description
     "This package provides S3 classes and methods to create and work with
year-quarter, year-month and year-isoweek vectors.  Basic arithmetic
operations (such as adding and subtracting) are supported, as well as
formatting and converting to and from standard R date types.")
    (license license:expat)))

(define-public r-dirichletreg
  (package
    (name "r-dirichletreg")
    (version "0.7-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DirichletReg" version))
       (sha256
        (base32 "1ql5mwb7zb06y9j6inrlngq7c15as4j17wd8kc71fxs0a2jdj7xi"))))
    (properties `((upstream-name . "DirichletReg")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-maxlik))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=DirichletReg")
    (synopsis "Dirichlet regression")
    (description "This package implements Dirichlet regression models.")
    (license license:gpl2+)))

(define-public r-dirmult
  (package
    (name "r-dirmult")
    (version "0.1.3-5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "dirmult" version))
              (sha256
               (base32
                "05whzhl81nyag7321hw98xa63r440s9bgj1764346yvm9bvzjqi4"))))
    (properties `((upstream-name . "dirmult")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=dirmult")
    (synopsis "Estimation in Dirichlet-Multinomial distribution")
    (description
     "This package estimates the parameters in Dirichlet-Multinomial and
computes log-likelihoods.")
    (license license:gpl2+)))

(define-public r-dixontest
  (package
    (name "r-dixontest")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dixonTest" version))
       (sha256
        (base32 "0gz39s1z987bg56vwrpcs14wzyf7p07s7l7z9napz0i38564wsdq"))))
    (properties `((upstream-name . "dixonTest")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=dixonTest")
    (synopsis "Dixon's ratio test for outlier detection")
    (description
     "For outlier detection in small and normally distributed samples the ratio
test of Dixon (Q-test) can be used.  Density, distribution function, quantile
function and random generation for Dixon's ratio statistics are provided as
wrapper functions.  The core applies McBane's Fortran functions that use
Gaussian quadrature for a numerical solution.")
    (license license:gpl3)))

(define-public r-dmwr2
  (package
    (name "r-dmwr2")
    (version "0.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "DMwR2" version))
              (sha256
               (base32
                "1vzfbz2k05j8r2hpig3d2grb99rnnh2s1sviii3prcyqicxfh0i9"))))
    (properties `((upstream-name . "DMwR2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class
           r-dbi
           r-dplyr
           r-quantmod
           r-readr
           r-rpart
           r-xts
           r-zoo))
    (home-page "https://github.com/ltorgo/DMwR2")
    (synopsis
     "Functions and data for the second edition of \"Data Mining with R\"")
    (description
     "This package provides functions and data accompanying the second
edition of the book \"Data Mining with R, learning with case studies\"
by Luis Torgo, published by CRC Press.")
    (license license:gpl2+)))

(define-public r-earlywarnings
  (package
    (name "r-earlywarnings")
    (version "1.1.29")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "earlywarnings" version))
              (sha256
               (base32
                "1xa9rijqqxa5l253dg8dn1jjhdakf8krl5rflq5v9gybfyrq1885"))))
    (properties `((upstream-name . "earlywarnings")))
    (build-system r-build-system)
    (propagated-inputs (list r-fields
                             r-ggplot2
                             r-kendall
                             r-kernsmooth
                             r-knitr
                             r-lmtest
                             r-moments
                             r-nortest
                             r-quadprog
                             r-som
                             r-spam
                             r-tgp
                             r-tseries))
    (native-inputs (list r-knitr))
    (home-page "https://www.early-warning-signals.org")
    (synopsis "Early warning signals for critical transitions in time series")
    (description
     "This package offers methods for estimating statistical changes in time
series.  These are used for identifying nearby critical transitions.")
    (license license:bsd-2)))

(define-public r-earth
  (package
    (name "r-earth")
    (version "5.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "earth" version))
       (sha256
        (base32 "1g6ywsmdp7qlp0rql6f07j9hih45w9jm7b90sgkjpylqan94zy9s"))))
    (properties `((upstream-name . "earth")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-plotmo))
    (native-inputs (list gfortran))
    (home-page "http://www.milbo.users.sonic.net/earth/")
    (synopsis "Multivariate adaptive regression splines")
    (description
     "This package lets you build regression models using the techniques in
Friedman's papers \"Fast MARS\" and \"Multivariate Adaptive Regression
Splines\" <doi:10.1214/aos/1176347963>. The term \"MARS\" is trademarked and
thus not used in the name of the package.")
    (license license:gpl3)))

(define-public r-embedsom
  (package
    (name "r-embedsom")
    (version "2.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "EmbedSOM" version))
              (sha256
               (base32
                "0k4hja5y7qd0n3gfaxzxrz4wpxc1w9d4d4xbb63rq2nfk3lj7a42"))))
    (properties `((upstream-name . "EmbedSOM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fnn
           r-ggplot2
           r-igraph
           r-matrix
           r-rtsne
           r-umap
           r-uwot))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/exaexa/EmbedSOM")
    (synopsis "Fast embedding guided by self-organizing map")
    (description
     "This package provides a smooth mapping of multidimensional points into
low-dimensional space defined by a self-organizing map.  It is designed to
work with FlowSOM and flow-cytometry use-cases.")
    (license license:gpl3+)))

(define-public r-emdist
  (package
    (name "r-emdist")
    (version "0.3-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emdist" version))
       (sha256
        (base32
         "0jmnz612pjad3p1zk0qiljcbf0zbxfi4zcw2jqwg8ncjsifhr3mp"))))
    (properties `((upstream-name . "emdist")))
    (build-system r-build-system)
    (home-page "https://www.rforge.net/emd")
    (synopsis "Earth mover's distance")
    (description
     "This package provides tools to calculate the Earth Mover's
Distance (EMD).")
    (license license:expat)))

(define-public r-emulator
  (package
    (name "r-emulator")
    (version "1.2-24")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emulator" version))
       (sha256
        (base32 "0sd45wjdb00iyj8n16kqxypisam7ibwvpcaxsi1z56yzlzp93p4i"))))
    (properties `((upstream-name . "emulator")))
    (build-system r-build-system)
    (propagated-inputs (list r-mvtnorm))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/RobinHankin/emulator")
    (synopsis "Bayesian emulation of computer programs")
    (description
     "This package allows one to estimate the output of a computer program, as
a function of the input parameters, without actually running it.  The computer
program is assumed to be a Gaussian process, whose parameters are estimated
using Bayesian techniques that give a PDF of expected program output.  This
PDF is conditional on a training set of runs, each consisting of a point in
parameter space and the model output at that point.  The emphasis is on
complex codes that take weeks or months to run, and that have a large number
of undetermined input parameters; many climate prediction models fall into
this class.  The emulator essentially determines Bayesian posterior estimates
of the PDF of the output of a model, conditioned on results from previous runs
and a user-specified prior linear model.  The package includes functionality
to evaluate quadratic forms efficiently.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-fateid
  (package
    (name "r-fateid")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FateID" version))
       (sha256
        (base32 "0sgvaqhqkmmkcsl53bm1jlfpzrvzfb5cz8k513nizfsi638vydlm"))))
    (properties `((upstream-name . "FateID")))
    (build-system r-build-system)
    (propagated-inputs (list r-locfit
                             r-matrixstats
                             r-pheatmap
                             r-princurve
                             r-randomforest
                             r-rcolorbrewer
                             r-rtsne
                             r-som
                             r-umap))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=FateID")
    (synopsis "Quantification of fate bias in multipotent progenitors")
    (description
     "This package computes cell fate bias for multi-lineage single-cell data.
It also provides visualization tools for analyzing these biases.")
    (license license:gpl3)))

(define-public r-fuzzyjoin
  (package
    (name "r-fuzzyjoin")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fuzzyjoin" version))
       (sha256
        (base32 "0s5rhqz8vih4za3a8k1k7i3gq8hj0w7bqnakw40k6mg87jvyzsj7"))))
    (properties `((upstream-name . "fuzzyjoin")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-geosphere
                             r-purrr
                             r-stringdist
                             r-stringr
                             r-tibble
                             r-tidyr))
    (native-inputs (list r-ggplot2 r-knitr r-testthat))
    (home-page "https://github.com/dgrtwo/fuzzyjoin")
    (synopsis "Join tables together on inexact matching")
    (description
     "Join tables together based not on whether columns match exactly, but
whether they are similar by some comparison.  Implementations include string
distance and regular expression matching.")
    (license license:expat)))

(define-public r-gfonts
  (package
    (name "r-gfonts")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gfonts" version))
              (sha256
               (base32
                "19ja087k767bq71v2w4jcpynd62ysrqmjf6rpfnmmd40aanyxqkj"))))
    (properties `((upstream-name . "gfonts")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-crul
           r-glue
           r-htmltools
           r-jsonlite
           r-shiny))
    (native-inputs (list r-knitr r-testthat r-vcr))
    (home-page "https://dreamrs.github.io/gfonts/")
    (synopsis "Offline Google fonts for Markdown and Shiny")
    (description
     "This package lets you download Google fonts and generate CSS to use in
rmarkdown documents and Shiny applications.  Some popular fonts are included
and ready to use.")
    (license license:gpl3)))

(define-public r-ggalt
  (package
    (name "r-ggalt")
    (version "0.4.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggalt" version))
              (sha256
               (base32
                "0ssa274d41vhd6crzjz7jqzbwgnjimxwxl23p2cx35aqs5wdfjpc"))))
    (properties `((upstream-name . "ggalt")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ash
           r-dplyr
           r-extrafont
           r-ggplot2
           r-gtable
           r-kernsmooth
           r-maps
           r-mass
           r-plotly
           r-proj4
           r-rcolorbrewer
           r-scales
           r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/hrbrmstr/ggalt")
    (synopsis
     "Geometries, coordinate systems, fonts and more for ggplot2")
    (description
     "This package provides a compendium of new geometries, coordinate systems,
statistical transformations, scales and fonts for ggplot2, including splines,
1d and 2d densities, univariate average shifted histograms, a new map
coordinate system based on the PROJ.4-library along with
@code{geom_cartogram()} that mimics the original functionality of
@code{geom_map()}, formatters for \"bytes\", a @code{stat_stepribbon()}
function, increased @code{plotly} compatibility and the @code{StateFace} open
source font ProPublica.  Further new functionality includes lollipop charts,
dumbbell charts, the ability to encircle points and coordinate-system-based
text annotations.")
    (license license:agpl3)))

(define-public r-ggbreak
  (package
    (name "r-ggbreak")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggbreak" version))
       (sha256
        (base32 "14rx16v66xd0fjlywi89dq9dbw41zn7hpq14wgvf0178cxdp2fw4"))))
    (properties `((upstream-name . "ggbreak")))
    (build-system r-build-system)
    (propagated-inputs (list r-aplot r-ggfun r-ggplot2 r-ggplotify r-rlang))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/YuLab-SMU/ggbreak")
    (synopsis "Set axis break for ggplot2")
    (description
     "This package provides an implementation of scale functions for setting
axis breaks of a ggplot.")
    (license license:artistic2.0)))

(define-public r-ggdist
  (package
    (name "r-ggdist")
    (version "3.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggdist" version))
       (sha256
        (base32 "1wc3pqnf2r0324jm0vv1872smriv25h0lx0mni7qp93wrf8k0mpn"))))
    (properties `((upstream-name . "ggdist")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-distributional
                             r-ggplot2
                             r-glue
                             r-gtable
                             r-numderiv
                             r-quadprog
                             r-rcpp
                             r-rlang
                             r-scales
                             r-tibble
                             r-vctrs
                             r-withr))
    (native-inputs (list r-dplyr r-knitr r-testthat r-tidyr r-vdiffr))
    (home-page "https://mjskay.github.io/ggdist/")
    (synopsis "Visualizations of distributions and uncertainty")
    (description
     "This package provides primitives for visualizing distributions using
ggplot2 that are particularly tuned for visualizing uncertainty in either a
frequentist or Bayesian mode.  Both analytical distributions (such as
frequentist confidence distributions or Bayesian priors) and distributions
represented as samples (such as bootstrap distributions or Bayesian posterior
samples) are easily visualized.")
    (license license:gpl3+)))

(define-public r-ggfittext
  (package
    (name "r-ggfittext")
    (version "0.10.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggfittext" version))
              (sha256
               (base32
                "0glc4wh8flryv4mydzgk8a3lj7dzg2ip45gsxr472jgbg56a95mp"))))
    (properties `((upstream-name . "ggfittext")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli r-ggplot2 r-gridtext r-shades r-stringi))
    (native-inputs (list r-knitr r-testthat r-vdiffr))
    (home-page "https://wilkox.org/ggfittext/")
    (synopsis "Ggfittext is a ggplot2 extension for fitting text into boxes")
    (description
     "Ggfittext is a ggplot2 extension for fitting text into boxes.")
    (license license:gpl2)))

(define-public r-ggstats
  (package
    (name "r-ggstats")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggstats" version))
       (sha256
        (base32 "107rv410scf1nk1gaz6gwwbciv7ni6jlid004wxg3r60j8lcak78"))))
    (properties `((upstream-name . "ggstats")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-dplyr
                             r-forcats
                             r-ggplot2
                             r-lifecycle
                             r-patchwork
                             r-purrr
                             r-rlang
                             r-scales
                             r-stringr
                             r-tidyr))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://larmarange.github.io/ggstats/")
    (synopsis "Extension to ggplot2 for plotting stats")
    (description
     "This package provides new statistics, new geometries and new positions
for ggplot2 and a suite of functions to facilitate the creation of statistical
plots.")
    (license license:gpl3+)))

(define-public r-ggstatsplot
  (package
    (name "r-ggstatsplot")
    (version "0.12.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggstatsplot" version))
              (sha256
               (base32
                "1341bcq69qqmzz4biyb7d3wrcs0hxvzv2d8x4s3133ip26my4p8v"))))
    (properties `((upstream-name . "ggstatsplot")))
    (build-system r-build-system)
    (propagated-inputs (list r-correlation
                             r-datawizard
                             r-dplyr
                             r-ggcorrplot
                             r-ggplot2
                             r-ggrepel
                             r-ggside
                             r-ggsignif
                             r-glue
                             r-insight
                             r-paletteer
                             r-parameters
                             r-patchwork
                             r-performance
                             r-purrr
                             r-rlang
                             r-statsexpressions
                             r-tidyr))
    (native-inputs (list r-knitr r-testthat r-vdiffr))
    (home-page "https://indrajeetpatil.github.io/ggstatsplot/")
    (synopsis "Based plots with statistical details")
    (description
     "This package generates graphics with embedded details from statistical tests.
Statistical tests included in the plots themselves.  It provides an easier
syntax to generate information-rich plots for statistical analysis of
continuous or categorical data.  Currently, it supports the most common
types of statistical approaches and tests: parametric, nonparametric,
robust, and Bayesian versions of t-test/ANOVA, correlation analyses,
contingency table analysis, meta-analysis, and regression analyses.")
    (license license:gpl3)))

(define-public r-ggupset
  (package
    (name "r-ggupset")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggupset" version))
       (sha256
        (base32 "0cycnnycn1qazy35s4w746zlfraayf109bq40fglklmick6kfwsz"))))
    (properties `((upstream-name . "ggupset")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-gtable r-rlang r-scales r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/const-ae/ggupset")
    (synopsis "Combination matrix axis for ggplot2 to create UpSet plots")
    (description
     "This package lets you replace the standard x-axis in ggplots with a
combination matrix to visualize complex set overlaps.  UpSet has introduced a
new way to visualize the overlap of sets as an alternative to Venn diagrams.
This package provides a simple way to produce such plots using ggplot2.  In
addition it can convert any categorical axis into a combination matrix axis.")
    (license license:gpl3)))

(define-public r-glmpca
  (package
    (name "r-glmpca")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "glmpca" version))
              (sha256
               (base32
                "02xjf0gg52925hw9nw2j0znfmzfzfwbv0fxjl9d2fy9j63drr2h4"))))
    (properties `((upstream-name . "glmpca")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/willtownes/glmpca")
    (synopsis "Dimension Reduction of Non-Normally Distributed Data")
    (description
     "This package implements a generalized version of principal components
analysis (GLM-PCA) for dimension reduction of non-normally distributed data
such as counts or binary matrices.")
    (license license:lgpl3+)))

(define-public r-googledrive
  (package
    (name "r-googledrive")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googledrive" version))
       (sha256
        (base32
         "10pv70nvsqh1yc12g5fj7avfihjzpj02m8s9f8sb0c1np9s4z2qb"))))
    (properties `((upstream-name . "googledrive")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-gargle
           r-glue
           r-httr
           r-jsonlite
           r-lifecycle
           r-magrittr
           r-pillar
           r-purrr
           r-rlang
           r-tibble
           r-uuid
           r-vctrs
           r-withr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://googledrive.tidyverse.org")
    (synopsis "Interface to Google Drive")
    (description "This package lets you manage Google Drive files from R.")
    (license license:expat)))

(define-public r-googlevis
  (package
    (name "r-googlevis")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googleVis" version))
       (sha256
        (base32 "0swcf2vl3mvp2bsd7nra917pajyh27j2k3vmmrb6n8g55mazyisn"))))
    (properties `((upstream-name . "googleVis")))
    (build-system r-build-system)
    (propagated-inputs (list r-jsonlite))
    (native-inputs (list r-knitr r-rmarkdown))
    (home-page "https://mages.github.io/googleVis/")
    (synopsis "R interface to Google Charts")
    (description
     "The @code{googleVis} package provides an interface between R and the Google
Charts API.  Google Charts offer interactive charts which can be embedded into
web pages.  The functions of the @code{googleVis} package allow the user to
visualise data stored in R data frames with Google Charts without uploading
the data to Google.  The output of a @code{googleVis} function is HTML code
that contains the data and references to JavaScript functions hosted by
Google.  @code{googleVis} makes use of the internal R HTTP server to display
the output locally.")
    (license license:gpl2+)))

(define-public r-gsignal
  (package
    (name "r-gsignal")
    (version "0.3-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gsignal" version))
       (sha256
        (base32 "1chkzv3bx1nas1yc6l5i3hgc8m40n1lm1y3c8577l8sqi89hnhs3"))))
    (properties `((upstream-name . "gsignal")))
    (build-system r-build-system)
    (propagated-inputs (list r-pracma r-rcpp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/gjmvanboxtel/gsignal")
    (synopsis "Signal processing")
    (description
     "This package provides an R implementation of the Octave package
@code{signal}, containing a variety of signal processing tools, such as signal
generation and measurement, correlation and convolution, filtering, filter
design, filter analysis and conversion, power spectrum analysis, system
identification, decimation and sample rate change, and windowing.")
    (license license:gpl3)))

(define-public r-gson
  (package
    (name "r-gson")
    (version "0.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gson" version))
              (sha256
               (base32
                "10d3v543bvsyrwg3dm04xpzxjvmba1d1fhcf2zfb3l36pvjvxp8l"))))
    (properties `((upstream-name . "gson")))
    (build-system r-build-system)
    (propagated-inputs (list r-jsonlite r-rlang r-tidyr))
    (home-page "https://cran.r-project.org/package=gson")
    (synopsis "Base Class and Methods for 'gson' Format")
    (description
     "This package proposes a new file format named @code{gson} for storing
gene set and related information, and provides read, write and other utilities
to process this file format.")
    (license license:artistic2.0)))

(define-public r-guix-install
  (package
    (name "r-guix-install")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "guix.install" version))
       (sha256
        (base32 "0s3wb5781yc43c9zwrn7i87zcbrlx7xr0ms0v9hvgs7qsv02id9j"))))
    (properties `((upstream-name . "guix.install")))
    (build-system r-build-system)
    (propagated-inputs (list r-runit))
    (home-page "https://github.com/BIMSBbioinfo/guix.install")
    (synopsis "Install R packages with GNU Guix")
    (description
     "This R package provides a single procedure @code{guix.install()}, which
allows users to install R packages via Guix right from within their running R
session.  If the requested R package does not exist in Guix at this time, the
package and all its missing dependencies will be imported recursively and the
generated package definitions will be written to @file{~/.Rguix/packages.scm}.
This record of imported packages can be used later to reproduce the
environment, and to add the packages in question to a proper Guix channel (or
Guix itself).  @code{guix.install()} not only supports installing packages
from CRAN, but also from Bioconductor or even arbitrary git or mercurial
repositories, replacing the need for installation via @code{devtools}.")
    (license license:gpl3+)))

(define-public r-gunifrac
  (package
    (name "r-gunifrac")
    (version "1.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "GUniFrac" version))
              (sha256
               (base32
                "1yw0d8hb7s662xy0dny9ygvx9gwh7yj8dxw4897zy7zyjhzim95f"))))
    (properties `((upstream-name . "GUniFrac")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape
           r-dirmult
           r-foreach
           r-ggplot2
           r-ggrepel
           r-inline
           r-mass
           r-matrix
           r-matrixstats
           r-modeest
           r-rcpp
           r-rmutil
           r-statmod
           r-vegan))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=GUniFrac")
    (synopsis
     "Generalized UniFrac distances and methods for microbiome data analysis")
    (description
     "This package provides a suite of methods for powerful and robust
microbiome data analysis, including data normalization, data simulation,
community-level association testing and differential abundance analysis.  It
implements generalized UniFrac distances, @dfn{Geometric Mean of Pairwise
Ratios} (GMPR) normalization, semiparametric data simulator, distance-based
statistical methods, and feature- based statistical methods.  The
distance-based statistical methods include three extensions of PERMANOVA:

@itemize
@item PERMANOVA using the Freedman-Lane permutation scheme,
@item PERMANOVA omnibus test using multiple matrices, and
@item analytical approach to approximating PERMANOVA p-value.
@end itemize

Feature-based statistical methods include linear model-based methods for
differential abundance analysis of zero-inflated high-dimensional
compositional data.")
    (license license:gpl3)))

(define-public r-gwasexacthw
  (package
    (name "r-gwasexacthw")
    (version "1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "GWASExactHW" version))
              (sha256
               (base32
                "1xzcvmbh27ibd7g9zlqyp215q4yfkhdypcvm5gjkvw1qhd3pl4yk"))))
    (properties `((upstream-name . "GWASExactHW")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=GWASExactHW")
    (synopsis
     "Exact Hardy-Weinburg testing for Genome Wide Association Studies")
    (description
     "This package contains a function to do exact Hardy-Weinburg
testing (using Fisher's test) for SNP genotypes as typically obtained in a
@dfn{Genome Wide Association Study} (GWAS).")
    (license license:gpl3)))

(define-public r-gwidgets2
  (package
    (name "r-gwidgets2")
    (version "1.0-9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gWidgets2" version))
              (sha256
               (base32
                "1ifljpdazzmwf3mgkg9g76365n2cmw8dd3da161fpvw84xxyznfl"))))
    (properties `((upstream-name . "gWidgets2")))
    (build-system r-build-system)
    ;; Tests fail with: could not find function "gwindow"
    (arguments (list #:tests? #false))
    (propagated-inputs (list r-digest))
    (home-page "https://github.com/gWidgets3/gWidgets2")
    (synopsis "Rewrite of gWidgets API for simplified GUI construction")
    (description
     "This package provides a re-implementation of the @code{gWidgets} API.
The API is defined in this package.  A second, toolkit-specific package is
required to use it.")
    (license license:gpl3+)))

(define-public r-gwidgets2tcltk
  (package
    (name "r-gwidgets2tcltk")
    (version "1.0-8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gWidgets2tcltk" version))
              (sha256
               (base32
                "02ic4avpa33dnqsnm1mzg7ci1psngk1p169pqf259szf6v39qf8h"))))
    (properties `((upstream-name . "gWidgets2tcltk")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'start-x-server
            (lambda _
              ;; Tests require a running X server.
              (system "Xvfb :1 +extension GLX &")
              (setenv "DISPLAY" ":1"))))))
    (propagated-inputs (list r-digest r-gwidgets2 r-memoise))
    (native-inputs
     (list r-testthat xorg-server-for-tests))
    (home-page "https://github.com/jverzani/gWidgets2tcltk")
    (synopsis "Toolkit implementation of gWidgets2 for tcltk")
    (description "This package is a port of the @code{gWidgets2} API for the
@code{tcltk} package.")
    (license license:gpl2+)))

(define-public r-ids
  (package
    (name "r-ids")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ids" version))
       (sha256
        (base32
         "1s6ga94gds5ydr9f8qbjfgfpg2dvbnkcrlybqlb33hk3c0c2l8dn"))))
    (properties `((upstream-name . "ids")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-openssl r-uuid))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/richfitz/ids")
    (synopsis "Generate random identifiers")
    (description
     "This package lets you generate random or human readable and
pronounceable identifiers.")
    (license license:expat)))

(define-public r-googlesheets4
  (package
    (name "r-googlesheets4")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googlesheets4" version))
       (sha256
        (base32
         "1kzwhs9zrx1i4kqhdqrkzyhnwx25j8j2pcg7ja2dxfalihs67k65"))))
    (properties `((upstream-name . "googlesheets4")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cellranger
           r-cli
           r-curl
           r-gargle
           r-glue
           r-googledrive
           r-httr
           r-ids
           r-lifecycle
           r-magrittr
           r-purrr
           r-rematch2
           r-rlang
           r-tibble
           r-vctrs
           r-withr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/tidyverse/googlesheets4")
    (synopsis "Access Google Sheets using the Sheets API V4")
    (description
     "This package lets you interact with Google Sheets through the
@url{https://developers.google.com/sheets/api,Sheets API v4}.  This package
can read and write both the metadata and the cell data in a Sheet.")
    (license license:expat)))

(define-public r-pma
  (package
    (name "r-pma")
    (version "1.2-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PMA" version))
       (sha256
        (base32 "0mq0mchvl4zlj1sgnq7z5ccm0f4lhxajqvk9w265axs0s49g76ry"))))
    (properties `((upstream-name . "PMA")))
    (build-system r-build-system)
    (home-page "https://github.com/bnaras/PMA")
    (synopsis "Penalized multivariate analysis")
    (description
     "This package performs penalized multivariate analysis: a penalized
matrix decomposition, sparse principal components analysis, and sparse
canonical correlation analysis.")
    (license license:gpl2+)))

(define-public r-pmml
  (package
    (name "r-pmml")
    (version "2.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pmml" version))
       (sha256
        (base32 "1faad5yqyh6dx40056w74vlyw4wxjgh41jv8b2vf2gh26laf22kk"))))
    (properties `((upstream-name . "pmml")))
    (build-system r-build-system)
    (propagated-inputs (list r-stringr r-xml))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://open-source.softwareag.com/r-pmml/")
    (synopsis "Generate PMML for various models")
    (description
     "The Predictive Model Markup Language (PMML) is an XML-based language
which provides a way for applications to define machine learning, statistical
and data mining models and to share models between PMML compliant
applications.  More information about the PMML industry standard and the Data
Mining Group can be found at @url{http://dmg.org/}.  The generated PMML can be
imported into any PMML consuming application, such as Zementis Predictive
Analytics products.")
    (license license:gpl3)))

(define-public r-robslopes
  (package
    (name "r-robslopes")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "robslopes" version))
       (sha256
        (base32 "0hhdpp03ybf71x6wz766glqlq4ywc4v65mj0ca3idv69p488mvb5"))))
    (properties `((upstream-name . "robslopes")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcpparmadillo))
    (home-page "https://cran.r-project.org/package=robslopes")
    (synopsis "Fast algorithms for robust slopes")
    (description
     "This package provides fast algorithms for the Theil-Sen estimator,
Siegel's repeated median slope estimator, and Passing-Bablok regression.  The
implementation is based on algorithms by Dillencourt et al. (1992)
<doi:10.1142/S0218195992000020> and Matousek et al. (1998)
<doi:10.1007/PL00009190>.  The implementations are detailed in
Raymaekers (2023) <doi:10.32614/RJ-2023-012> and Raymaekers J., Dufey
F. (2022) <@code{arXiv:2202.08060>}.  All algorithms run in quasilinear
time.")
    (license license:gpl2+)))

(define-public r-robustrankaggreg
  (package
    (name "r-robustrankaggreg")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RobustRankAggreg" version))
       (sha256
        (base32 "0p2nbgxv2132gcyx7zq2gzl6ipsxndx64i7y8v9nh5awcdy8v44p"))))
    (properties `((upstream-name . "RobustRankAggreg")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=RobustRankAggreg")
    (synopsis "Methods for robust rank aggregation")
    (description
     "This tool provides methods for aggregating ranked lists, especially
lists of genes.  It implements the Robust Rank Aggregation and other simple
algorithms for the task.  RRA method uses a probabilistic model for
aggregation that is robust to noise and also facilitates the calculation of
significance probabilities for all the elements in the final ranking.")
    (license license:gpl2)))

(define-public r-rose
  (package
    (name "r-rose")
    (version "0.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ROSE" version))
       (sha256
        (base32 "0y3v9zkgaxpv4f4zn22ra1gkkqg5hdz8js47ppciqahfydjbfl3p"))))
    (properties `((upstream-name . "ROSE")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=ROSE")
    (synopsis "Random over-sampling examples")
    (description
     "This package provides functions to deal with binary classification
problems in the presence of imbalanced classes.  Synthetic balanced samples
are generated according to ROSE (Menardi and Torelli, 2013).  Functions that
implement more traditional remedies to the class imbalance are also provided,
as well as different metrics to evaluate a learner accuracy.  These are
estimated by holdout, bootstrap or cross-validation methods.")
    (license license:gpl2)))

(define-public r-rotor
  (package
    (name "r-rotor")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rotor" version))
       (sha256
        (base32 "02mzcwd94hykysz3cv0q3dlhbbd4k3rm1di7dcw6m4masgzy05zb"))))
    (properties `((upstream-name . "rotor")))
    (build-system r-build-system)
    (propagated-inputs (list r-dint r-r6))
    (native-inputs (list r-testthat))
    (home-page "https://s-fleck.github.io/rotor/")
    (synopsis "Log rotation and conditional backups")
    (description
     "This package provides tools to conditionally rotate or back-up files
based on their size or the date of the last backup; inspired by the utility
@code{logrotate}'.")
    (license license:expat)))

(define-public r-rpresto
  (package
    (name "r-rpresto")
    (version "1.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RPresto" version))
       (sha256
        (base32 "1q8c3h328iwscnayxj8qc71s2hkqdqwnpf38kn3zz3ks66qzjf8c"))))
    (properties `((upstream-name . "RPresto")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for failing tests, because lubridate needs these
         ;; variables.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs
     (list r-bit64
           r-dbi
           r-dbplyr
           r-dplyr
           r-httr
           r-jsonlite
           r-lifecycle
           r-lubridate
           r-openssl
           r-progress
           r-purrr
           r-rlang
           r-stringi
           r-tibble
           r-vctrs))
    (native-inputs (list r-knitr r-testthat tzdata-for-tests))
    (home-page "https://github.com/prestodb/RPresto")
    (synopsis "DBI connector to Presto")
    (description
     "This package implements a DBI compliant interface to
@url{https://prestodb.io/, Presto}, a distributed SQL query engine for running
interactive analytic queries against data sources of all sizes ranging from
gigabytes to petabytes.")
    (license license:bsd-3)))

(define-public r-rpushbullet
  (package
    (name "r-rpushbullet")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RPushbullet" version))
       (sha256
        (base32 "1mx433hvx660a63s5dzn655zmqv1c1qij0hzddl9z38032brc4ii"))))
    (properties `((upstream-name . "RPushbullet")))
    (build-system r-build-system)
    (propagated-inputs (list r-curl r-jsonlite))
    (home-page "https://cran.r-project.org/package=RPushbullet")
    (synopsis "R interface to the Pushbullet messaging service")
    (description
     "An R interface to the Pushbullet messaging service which provides fast
and efficient notifications (and file transfer) between computers, phones and
tablets.")
    (license license:gpl2+)))

(define-public r-runner
  (package
    (name "r-runner")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "runner" version))
       (sha256
        (base32 "0vhqjnwcx3z3i74p26divx6palx1rwvk4jpqn64jrqlzaw9qich4"))))
    (properties `((upstream-name . "runner")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=runner")
    (synopsis "Running operations for vectors")
    (description
     "This package provides a library for rolling windows operations.
The package enables full control over the window length, window lag, and time
indices.  With a runner one can apply any R function on rolling windows.  The
package eases work with equally and unequally spaced time series.")
    (license license:gpl2+)))

(define-public r-prettydoc
  (package
    (name "r-prettydoc")
    (version "0.4.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "prettydoc" version))
              (sha256
               (base32
                "0aa89jnqhz0l69inrgm1f1riq5bm3ksb8wjl8d4x2f320adsd50h"))
              (snippet
               '(for-each delete-file
                          '("inst/resources/js/auto-render.min.js"
                            "inst/resources/js/katex.min.js")))))
    (properties `((upstream-name . "prettydoc")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/resources/js/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(search-input-file inputs "dist/katex.js")
                         "katex.min.js")
                        (,(search-input-file inputs "dist/contrib/auto-render.js")
                         "auto-render.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #true "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (inputs (list pandoc))
    (propagated-inputs (list r-rmarkdown))
    (native-inputs
     (list esbuild
           r-knitr
           r-rmarkdown
           (let ((version "0.12.0"))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/KaTeX/KaTeX")
                     (commit (string-append "v" version))))
               (file-name (git-file-name "js-katex" version))
               (sha256
                (base32
                 "0pdfw28affnfpqpnf244acf5rkxdy2gk63669myy7ysg4z0i1n8j"))))))
    (home-page "https://github.com/yixuan/prettydoc")
    (synopsis "Create pretty documents from R markdown")
    (description
     "This is a package for creating tiny yet beautiful documents and
vignettes from R Markdown.  The package provides the @code{html_pretty} output
format as an alternative to the @code{html_document} and @code{html_vignette}
engines that convert R Markdown into HTML pages.  Various themes and syntax
highlight styles are supported.")
    (license license:asl2.0)))

(define-public r-profmem
  (package
    (name "r-profmem")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "profmem" version))
       (sha256
        (base32 "0gg6ja0ifwn9jj42rw1gnyil55sl9r2y5rjb6yjcvqwd5arajp3l"))))
    (properties `((upstream-name . "profmem")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'install 'set-HOME
           (lambda _
             ;; Needed for building vignettes
             (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list r-r-rsp r-markdown)) ;for vignettes
    (home-page "https://github.com/HenrikBengtsson/profmem")
    (synopsis "Simple memory profiling for R")
    (description
     "This package provides a simple and light-weight API for memory profiling
of R expressions.  The profiling is built on top of R's built-in memory
profiler @code{utils::Rprofmem()}, which records every memory allocation done
by R (also native code).")
    (license license:lgpl2.1+)))

(define-public r-proj4
  (package
    (name "r-proj4")
    (version "1.0-14")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "proj4" version))
              (sha256
               (base32
                "1dh059lhw32vn0hxlp6sxb6m8hjdgmm01djq6vfncrhkjbd73mfk"))))
    (properties `((upstream-name . "proj4")))
    (build-system r-build-system)
    (inputs (list proj-7 zlib))
    (native-inputs (list pkg-config))
    (home-page "https://www.rforge.net/proj4/")
    (synopsis "Simple interface to the PROJ.4 cartographic projections library")
    (description
     "This package provides a simple interface to lat/long projection and
datum transformation of the PROJ.4 cartographic projections library.  It
allows transformation of geographic coordinates from one projection and/or
datum to another.")
    (license license:gpl2)))

(define-public r-rocit
  (package
    (name "r-rocit")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ROCit" version))
       (sha256
        (base32 "17s7wi248vj6wbcxb6z0fdsw8bijjxva4sldlqcz4m73ccnrdikf"))))
    (properties `((upstream-name . "ROCit")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=ROCit")
    (synopsis "Performance Assessment of Binary Classifier with Visualization")
    (description
     "Sensitivity (or recall or true positive rate), false positive rate,
specificity, precision (or positive predictive value), negative predictive
value, misclassification rate, accuracy, F-score---these are popular metrics
for assessing performance of binary classifiers for certain thresholds.  These
metrics are calculated at certain threshold values.  @dfn{Receiver operating
characteristic} (ROC) curve is a common tool for assessing overall diagnostic
ability of the binary classifier.  Unlike depending on a certain threshold,
area under ROC curve (also known as AUC), is a summary statistic about how
well a binary classifier performs overall for the classification task.  The
ROCit package provides flexibility to easily evaluate threshold-bound
metrics.")
    (license license:gpl3)))

(define-public r-roi-plugin-lpsolve
  (package
    (name "r-roi-plugin-lpsolve")
    (version "1.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ROI.plugin.lpsolve" version))
       (sha256
        (base32 "0xgg1fzq5sba3yvvrci3iw97p31walpnhv4zwnd39gw8v5z6f9dj"))))
    (properties `((upstream-name . "ROI.plugin.lpsolve")))
    (build-system r-build-system)
    (propagated-inputs (list r-lpsolveapi r-roi))
    (home-page "https://roigrp.gitlab.io")
    (synopsis "Plugin of lp_solve for the R optimization infrastructure")
    (description
     "This package enhances the @acronym{ROI, R Optimization Infrastructure} with
the lp_solve solver.")
    (license license:gpl3)))

(define-public r-rorcid
  (package
    (name "r-rorcid")
    (version "0.7.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rorcid" version))
              (sha256
               (base32
                "1d0s5w48ksyj152nc4xq5w0nsimab8jc5fgspdwnbas2g8a52igr"))))
    (properties `((upstream-name . "rorcid")))
    (build-system r-build-system)
    (propagated-inputs (list r-crul
                             r-data-table
                             r-fauxpas
                             r-httr
                             r-jsonlite
                             r-tibble
                             r-xml2))
    (native-inputs (list r-testthat r-vcr))
    (home-page "https://github.com/ropensci/rorcid")
    (synopsis "Interface to the @url{Orcid.org, https://orcid.org} API")
    (description
     "This package provides an API for @url{Orcid.org, https://orcid.org}.
Functions include searching for people, searching by DOI, or searching by
Orcid ID.")
    (license license:expat)))

(define-public r-rrna
  (package
    (name "r-rrna")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RRNA" version))
       (sha256
        (base32 "05ijsnxxylfan4c4hnl20655qjzix2l43i5qmdzm19wqcf4ipylp"))))
    (properties `((upstream-name . "RRNA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=RRNA")
    (synopsis "Secondary structure plotting for RNA")
    (description "This package facilitates RNA secondary structure plotting.")
    (license license:gpl3)))

(define-public r-ruv
  (package
    (name "r-ruv")
    (version "0.9.7.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ruv" version))
              (sha256
               (base32
                "1n4q9mrp9f644spbns6bbnzmlabrg90hwkdfg3hnm3rxp9b4xid0"))))
    (properties `((upstream-name . "ruv")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-gridextra r-scales))
    (home-page "https://cran.r-project.org/web/packages/ruv/index.html")
    (synopsis "Detect and remove unwanted variation using negative controls")
    (description
     "This package implements the RUV (Remove Unwanted Variation) algorithms.
These algorithms attempt to adjust for systematic errors of unknown origin in
high-dimensional data.  The algorithms were originally developed for use with
genomic data, especially microarray data, but may be useful with other types
of high-dimensional data as well.  The algorithms require the user to specify
a set of negative control variables, as described in the references.  The
algorithms included in this package are RUV-2, RUV-4, RUV-inv, RUV-rinv,
RUV-I, and RUV-III, along with various supporting algorithms.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-waldo
  (package
    (name "r-waldo")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "waldo" version))
       (sha256
        (base32
         "1jbn3vfykyv8czwqs6wbb8m172cl2fqgggy86n3h1rrg59rz7hy9"))))
    (properties
     ;; We can't add testthat here because of a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))
       (upstream-name . "waldo")))
    (build-system r-build-system)
    ;; Tests require r-testthat, which depends on this package.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-cli r-diffobj r-glue r-rlang))
    (home-page "https://github.com/r-lib/waldo")
    (synopsis "Find differences between R objects")
    (description
     "Compare complex R objects and reveal the key differences.  This package
was designed particularly for use in testing packages where being able to
quickly isolate key differences makes understanding test failures much
easier.")
    (license license:expat)))

;; We use the git repository, because it contains the JavaScript source code.
;; We have to use this seemingly arbitrary commit after 0.2.5, because the
;; sources for placeholder.js were not included in the latest release.
(define-public r-waiter
  (let ((commit "927501bfa41c37e33d13a90bbc329a2887e0cec0")
        (revision "1"))
    (package
      (name "r-waiter")
      (version (git-version "0.2.5" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/JohnCoene/waiter")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0s5d09srd1d1s35lp2fb93dvyfkjv1rasbl25ps1p137jv7zn079"))
                (modules '((guix build utils)))
                (snippet
                 '(delete-file-recursively "inst/packer"))))
      (properties `((upstream-name . "waiter")))
      (build-system r-build-system)
      (arguments
       (list
        #:modules
        '((guix build r-build-system)
          (guix build minify-build-system)
          (guix build utils))
        #:imported-modules
        `(,@%r-build-system-modules
          (guix build minify-build-system))
        #:phases
        '(modify-phases (@ (guix build r-build-system) %standard-phases)
           (add-after 'unpack 'process-javascript
             (lambda* (#:key inputs #:allow-other-keys)
               (mkdir-p "inst/packer")
               (call-with-output-file "build.js"
                 (lambda (port)
                   (display "\
const esbuild = require('esbuild');
const path = require('path');
const fs = require('fs');

// Define the entries and output directory
const entries = {
  'waiter': './srcjs/exts/waiter/waiter.js',
  'waitress': './srcjs/exts/waitress/waitress.js',
  'hostess': './srcjs/exts/hostess/hostess.js',
  'attendant': './srcjs/exts/attendant/attendant.js',
  'placeholder': './srcjs/exts/placeholder/placeholder.js'
};

// A little plugin to inject the CSS into the generated JavaScript file.
let style = {
  name: 'style',
  setup(build) {
    const cwd = process.cwd();
    const opt = {
      logLevel: 'silent',
      bundle: true,
      write: false,
      minify: true,
      charset: 'utf8'
    };

    build.onResolve({ filter: /\\.css$/, namespace: 'file' }, args => {
      const absPath = path.join(args.resolveDir, args.path);
      const relPath = path.relative(cwd, absPath);
      const resolved = fs.existsSync(absPath) ? relPath : args.path;
      return { path: resolved, namespace: 'style-stub' };
    });

    build.onResolve({ filter: /\\.css$/, namespace: 'style-stub' }, args => {
      return { path: args.path, namespace: 'style-content' };
    });

    build.onResolve({ filter: /^__style_helper__$/, namespace: 'style-stub' }, args => ({
      path: args.path,
      namespace: 'style-helper',
      sideEffects: false,
    }));

    build.onLoad({ filter: /.*/, namespace: 'style-helper' }, async () => ({
      contents: `
        export function injectStyle(text) {
          if (typeof document !== 'undefined') {
            var style = document.createElement('style')
            var node = document.createTextNode(text)
            style.appendChild(node)
            document.head.appendChild(style)
          }
        }
      `,
    }));

    build.onLoad({ filter: /.*/, namespace: 'style-stub' }, async args => ({
      contents: `
        import { injectStyle } from \"__style_helper__\"
        import css from ${JSON.stringify(args.path)}
        injectStyle(css)
      `,
    }));

    build.onLoad({ filter: /.*/, namespace: 'style-content' }, async args => {
      const options = { entryPoints: [args.path], ...opt };
      const { errors, warnings, outputFiles } = await esbuild.build(options);
      return { errors, warnings, contents: outputFiles[0].text, loader: \"text\" };
    });
  },
};

esbuild.build({
  entryPoints: Object.values(entries),
  entryNames: '[name]',
  outdir: './inst/packer',
  bundle: true,
  minify: true,
  format: 'iife',
  globalName: 'waiter',
  external: ['shiny', 'jquery'],
  loader: {
    '.js': 'js',
  },
  plugins: [style]
})
" port)))
               (install-file (search-input-file inputs "/dist/loading-bar.js")
                             "srcjs/exts/hostess")
               (install-file (search-input-file inputs "/dist/loading-bar.css")
                             "srcjs/exts/hostess")
               (substitute* "srcjs/exts/hostess/hostess.js"
                 (("@loadingio/loading-bar/lib/") "./")
                 (("@loadingio/loading-bar/dist/") "./"))
               (setenv "ESBUILD_BINARY_PATH" (search-input-file inputs "/bin/esbuild"))
               (invoke "node" "build.js")

               ;; Almost forgot this one...
               (minify (search-input-file inputs "loadgo-nojquery.js")
                       #:target
                       "inst/assets/garcon/garcon.min.js"))))))
      (propagated-inputs (list r-htmltools r-r6 r-shiny))
      (native-inputs
       (list esbuild-node node-lts r-knitr
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/loadingio/loading-bar")
                     (commit "0.1.0")))
               (file-name (git-file-name "js-loading-bar" "0.1.0"))
               (sha256
                (base32
                 "12z8m362k3gldkjhx3l65zrw7ifqkz21zgv9b2hw6ai5blkd33nv")))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/franverona/loadgo")
                     (commit "2.2.1")))
               (file-name (git-file-name "js-loadgo" "2.2.1"))
               (sha256
                (base32
                 "1n11lhlv5i48xm0x7hj296lv363dbx4cldg12vr07q01pvj5fbdl")))))
      (home-page "https://waiter.john-coene.com/")
      (synopsis "Loading screen for Shiny")
      (description
       "This package provides full screen and partial loading screens for
Shiny with spinners, progress bars, and notifications.")
      (license license:expat))))

(define-public r-wheatmap
  (package
    (name "r-wheatmap")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "wheatmap" version))
              (sha256
               (base32
                "064idlrnb85xxav39gp3n854fic6514khvazrf5d0x48crpzyvdp"))))
    (properties `((upstream-name . "wheatmap")))
    (build-system r-build-system)
    (propagated-inputs (list r-colorspace r-rcolorbrewer))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/zwdzwd/wheatmap")
    (synopsis "Incrementally build complex plots using natural semantics")
    (description
     "This package lets you build complex plots, heatmaps in particular, using
natural semantics.  Bigger plots can be assembled using directives such as
@code{LeftOf}, @code{RightOf}, @code{TopOf}, and @code{Beneath} and more.
Other features include clustering, dendrograms and integration with ggplot2
generated grid objects.  This package is particularly designed for
bioinformaticians to assemble complex plots for publication.")
    (license license:gpl3)))

(define-public r-rticles
  (package
    (name "r-rticles")
    (version "0.27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rticles" version))
       (sha256
        (base32
         "1a5i8vzcf058dqk30yir3ngs02f17s4d0b0px31pxa0d1ak1yfh7"))))
    (properties `((upstream-name . "rticles")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-knitr r-lifecycle r-rmarkdown r-tinytex r-xfun r-yaml))
    (native-inputs (list r-testit r-testthat r-withr))
    (home-page "https://github.com/rstudio/rticles")
    (synopsis "Article formats for R Markdown")
    (description
     "This package provides a suite of custom R Markdown formats and templates
for authoring journal articles and conference submissions.")
    (license license:gpl3)))

(define-public r-rtk
  (package
    (name "r-rtk")
    (version "0.2.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rtk" version))
       (sha256
        (base32 "1xafmp5y5p8fnsh16wj8n08x69v2hawnsvsy7g4dcz1i5xkhyc0m"))))
    (properties `((upstream-name . "rtk")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp zlib))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=rtk")
    (synopsis "Rarefaction tool kit")
    (description "This package lets you rarefy data, calculate diversity and
plot the results.")
    (license license:gpl2+)))

(define-public r-babelwhale
  (package
    (name "r-babelwhale")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "babelwhale" version))
       (sha256
        (base32 "0m5q83ykz5w1fsjsk2vyrnv21cg4n075kbvfvw4k22c61p78shdl"))))
    (properties `((upstream-name . "babelwhale")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-digest
           r-dplyr
           r-dynutils
           r-fs
           r-glue
           r-processx
           r-purrr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/dynverse/babelwhale")
    (synopsis "Talking to Docker and Singularity containers")
    (description
     "This package provides a unified interface to interact with Docker and
Singularity containers.  You can execute a command inside a container, mount a
volume or copy a file.")
    (license license:expat)))

(define-public r-bench
  (package
    (name "r-bench")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bench" version))
       (sha256
        (base32 "05zky7l6103gabv9y0g3qlx8sgkq1sn9yl9jd3x8834cmlh67bmz"))))
    (properties `((upstream-name . "bench")))
    (build-system r-build-system)
    (propagated-inputs (list r-glue r-pillar r-profmem r-rlang r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://bench.r-lib.org/")
    (synopsis "High precision timing of R expressions")
    (description
     "This package provides tools to accurately benchmark and analyze execution
times for R expressions.")
    (license license:expat)))

(define-public r-benchmarkmedata
  (package
    (name "r-benchmarkmedata")
    (version "1.0.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "benchmarkmeData" version))
              (sha256
               (base32
                "1n4vjkagqlm6kw2hilf4gjfcdjad0bcg652j9nl2ygbq3kdnh1vf"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/csgillespie/benchmarkme-data")
    (synopsis "Data set for the @code{benchmarkme} package")
    (description "This package contains the data set for the crowd-sourced
benchmarks from running the @code{benchmarkme} package.")
    (license license:gpl2+)))

(define-public r-benchmarkme
  (package
    (name "r-benchmarkme")
    (version "1.0.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "benchmarkme" version))
              (sha256
               (base32
                "0qaz8wy3n08k9lr8qljk5i8z8db18scbdc8m734aymd307h00w8x"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (propagated-inputs
     (list r-benchmarkmedata
           r-doparallel
           r-dplyr
           r-foreach
           r-httr
           r-matrix
           r-stringr
           r-tibble))
    (home-page "https://csgillespie.github.io/benchmarkme/")
    (synopsis "Crowd-sourced system benchmarks")
    (description "This package provides functionality to benchmark your CPU
and compare against other CPUs.  Also provides functions for obtaining system
specifications, such as RAM, CPU type, and R version.")
    (license license:gpl2+)))

(define-public r-bestnormalize
  (package
    (name "r-bestnormalize")
    (version "1.9.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "bestNormalize" version))
              (sha256
               (base32
                "1lryl23jvf51n7ka58ncwhjglk0zzm18wik962h403j4mph1jjly"))))
    (properties `((upstream-name . "bestNormalize")))
    (build-system r-build-system)
    (propagated-inputs (list r-butcher
                             r-doparallel
                             r-dorng
                             r-dplyr
                             r-foreach
                             r-generics
                             r-lambertw
                             r-nortest
                             r-purrr
                             r-recipes
                             r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://petersonr.github.io/bestNormalize/")
    (synopsis "Normalizing transformation functions")
    (description
     "Estimate a suite of normalizing transformations, including a new
adaptation of a technique based on ranks which can guarantee normally
distributed transformed data if there are no ties: @dfn{ordered quantile
normalization} (ORQ).  ORQ normalization combines a rank-mapping approach with
a shifted logit approximation that allows the transformation to work on data
outside the original domain.  It is also able to handle new data within the
original domain via linear interpolation.  The package is built to estimate
the best normalizing transformation for a vector consistently and accurately.
It implements the Box-Cox transformation, the Yeo-Johnson transformation,
three types of Lambert WxF transformations, and the ordered quantile
normalization transformation.  It estimates the normalization efficacy of
other commonly used transformations, and it allows users to specify custom
transformations or normalization statistics.  Finally, functionality can be
integrated into a machine learning workflow via recipes.")
    (license license:gpl3)))

(define-public r-bezier
  (package
    (name "r-bezier")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "bezier" version))
              (sha256
               (base32
                "1vw5128v8h973xwa1fdm9cw2jvrldj87nd55lddlp3qsz3ag4br6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/bezier/")
    (synopsis "Bezier curve and spline toolkit")
    (description
     "This package is a toolkit for working with Bezier curves and splines.
The package provides functions for point generation, arc length estimation,
degree elevation and curve fitting.")
    (license license:gpl2+)))

(define-public r-biglm
  (package
    (name "r-biglm")
    (version "0.9-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "biglm" version))
       (sha256
        (base32 "0n0dkazq74s3lml0ds9l38kzgapckjrvwyi62qb1y14cqlylhpc0"))))
    (properties `((upstream-name . "biglm")))
    (build-system r-build-system)
    (propagated-inputs (list r-dbi))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=biglm")
    (synopsis "Bounded memory linear and generalized linear models")
    (description "The biglm package lets you create a linear model object that
uses only code{p^2} memory for @code{p} variables.  It can be updated with
more data using @code{update}. This allows linear regression on data sets
larger than memory.")
    ;; Expanded from GPL
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-bipartite
  (package
    (name "r-bipartite")
    (version "2.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bipartite" version))
       (sha256
        (base32 "0wgx695r5knlrzg0wv5h2sivh3xzjsb50lafmb08j1fvg3hnrxl6"))))
    (properties `((upstream-name . "bipartite")))
    (build-system r-build-system)
    (propagated-inputs (list r-fields
                             r-igraph
                             r-mass
                             r-permute
                             r-sna
                             r-vegan))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/biometry/bipartite")
    (synopsis
     "Visualising bipartite networks and calculating ecological indices")
    (description
     "This package provides functions to visualise webs and calculate a series
of indices commonly used to describe pattern in (ecological) webs.  It focuses
on webs consisting of only two levels (bipartite), e.g. pollination webs or
predator-prey-webs.  Visualisation is important to get an idea of what we are
actually looking at, while the indices summarise different aspects of the
web's topology.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-bwstest
  (package
    (name "r-bwstest")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BWStest" version))
       (sha256
        (base32 "1chlszmshda84000jj4q5j2swflj512vfj3h97361aphzhkwri2b"))))
    (properties `((upstream-name . "BWStest")))
    (build-system r-build-system)
    (propagated-inputs (list r-memoise r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/shabbychef/BWStest")
    (synopsis "Baumgartner Weiss Schindler Test of equal distributions")
    (description
     "This package performs the Baumgartner-Weiss-Schindler two-sample test of
equal probability distributions (doi:10.2307/2533862).  It also performs
similar rank-based tests for equal probability distributions due to Neuhauser
(doi:10.1080/10485250108832874) and Murakami
(doi:10.1080/00949655.2010.551516).")
    (license license:lgpl3)))

(define-public r-v8
  (package
    (name "r-v8")
    (version "6.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "V8" version))
       (sha256
        (base32
         "1wvxba4c7p8867irvhhlixr2dh64x2ffspn34x142x14qkljn8kz"))))
    (properties
     `((upstream-name . "V8")
       (updater-extra-inputs . ("libnode"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'find-v8
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "configure"
               (("^PKG_LIBS=.*")
                (string-append "PKG_LIBS="
                               (assoc-ref inputs "libnode")
                               "/lib/libnode.so.127\n")))
             (setenv "INCLUDE_DIR"
                     (string-append
                      (assoc-ref inputs "libnode")
                      "/include/node"))
             (setenv "LIB_DIR"
                     (string-append
                      (assoc-ref inputs "libnode") "/lib")))))))
    (inputs
     (list libnode zlib))
    (propagated-inputs
     (list r-curl r-jsonlite r-rcpp))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://jeroen.cran.dev/V8")
    (synopsis "Embedded JavaScript and WebAssembly engine for R")
    (description
     "This package provides an R interface to V8: Google's JavaScript and
WebAssembly engine.")
    (license license:expat)))

(define-public r-vcr
  (package
    (name "r-vcr")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vcr" version))
       (sha256
        (base32 "0jp6p9k6y2rshxyq5hb3gv3idk2l426cizy1j2aqcz3s503axsxf"))))
    (properties `((upstream-name . "vcr")))
    (build-system r-build-system)
    (propagated-inputs (list r-base64enc
                             r-crul
                             r-httr
                             r-httr2
                             r-r6
                             r-rprojroot
                             r-urltools
                             r-webmockr
                             r-yaml))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/ropensci/vcr/")
    (synopsis "Record HTTP calls to disk")
    (description
     "This package lets you record test suite HTTP requests and replay them
during future runs.  It works by hooking into the @code{webmockr} R package
for matching HTTP requests by various rules, and then caching real HTTP
responses on disk in cassettes.  Subsequent HTTP requests matching any
previous requests in the same cassette use a cached HTTP response.")
    (license license:expat)))

(define-public r-venn
  (package
    (name "r-venn")
    (version "1.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "venn" version))
       (sha256
        (base32 "07bjv0m21gljdr3sj1z9rp6xhgxspah9j1m3a8rskvlwv6dvd1pd"))))
    (properties `((upstream-name . "venn")))
    (build-system r-build-system)
    (propagated-inputs (list r-admisc))
    (home-page "https://github.com/dusadrian/venn")
    (synopsis "Draw Venn diagrams")
    (description
     "This package provides a close to zero dependency package to draw and
display Venn diagrams up to 7 sets, and any Boolean union of set
intersections.")
    (license license:gpl3+)))

(define-public r-rvenn
  (package
    (name "r-rvenn")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RVenn" version))
       (sha256
        (base32
         "016m00xv59lkwm2is32v5nr4lw5a1ymdnz34r3ffflcv9bfrc6n4"))))
    (properties `((upstream-name . "RVenn")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggforce
           r-ggplot2
           r-magrittr
           r-pheatmap
           r-purrr
           r-rlang
           r-vegan))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=RVenn")
    (synopsis "Set operations for many sets")
    (description
     "The base functions for set operations in @code{R} can be used for only two
sets.  This package @code{RVenn} provides functions for dealing with multiple sets.
It uses @code{purr} to find the union, intersection and difference of three or
more sets.  This package also provides functions for pairwise set operations among
several sets.  Further, based on @code{ggplot2} and @code{ggforce}, a Venn diagram
can be drawn for two or three sets.  For bigger data sets, a clustered heatmap
showing the presence or absence of the elements of the sets can be drawn based on
the @code{pheatmap} package.  Finally, enrichment test can be applied to two sets
whether an overlap is statistically significant or not.")
    (license license:gpl3)))

(define-public r-dot
  (package
    (name "r-dot")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DOT" version))
       (sha256
        (base32
         "0qh5n57cp9c2n5yn59q4wggz82943pwfanp3kx869aba2x3sj30i"))))
    (properties `((upstream-name . "DOT")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-v8))
    (home-page "http://haghish.com/dot")
    (synopsis "Render and Export DOT Graphs in R")
    (description
     "This package provides tools to render DOT diagram markup language in R
and also provides the possibility to export the graphs in PostScript and
SVG (Scalable Vector Graphics) formats.  In addition, it supports literate
programming packages such as @code{knitr} and @code{rmarkdown}.")
    (license license:expat)))

(define-public r-carrier
  (package
    (name "r-carrier")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "carrier" version))
       (sha256
        (base32 "155zna5bv6ybb6hr3lsv8dn67lkbbvn3dbihfw2s6ajkzvms9x13"))))
    (properties `((upstream-name . "carrier")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lobstr r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-lib/carrier")
    (synopsis "Isolate functions for remote execution")
    (description
     "Sending functions to remote processes can be wasteful of resources
because they carry their environments with them.  With this package, it is
easy to create functions that are isolated from their environment.  These
isolated functions, also called crates, print to the console with their total
size and can be easily tested locally before being sent to a remote.")
    (license license:gpl3)))

(define-public r-climaemet
  (package
    (name "r-climaemet")
    (version "1.4.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "climaemet" version))
              (sha256
               (base32
                "1h17lf5mkahgx9zqqbnadjc9jr8y0jis7lvla8r6ifr0vpccy7wg"))))
    (properties `((upstream-name . "climaemet")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-dplyr
           r-ggplot2
           r-httr2
           r-jsonlite
           r-rappdirs
           r-readr
           r-rlang
           r-tibble
           r-tidyr
           r-xml2))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://ropenspain.github.io/climaemet/")
    (synopsis "Climate AEMET Tools")
    (description
     "This package provides tools to download the climatic data of the Spanish
Meteorological Agency (AEMET) directly from R using their API and create
scientific graphs (climate charts, trend analysis of climate time series,
temperature and precipitation anomalies maps, warming stripes graphics,
climatograms, etc.).")
    (license license:gpl3)))

(define-public r-climatol
  (package
    (name "r-climatol")
    (version "4.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "climatol" version))
              (sha256
               (base32
                "10znkynipb852y0j4kb16bhm4lcxdn5wy7vfx9ibcdwr06pv6kg7"))))
    (properties `((upstream-name . "climatol")))
    (build-system r-build-system)
    (home-page "http://www.climatol.eu/")
    (synopsis "Climate tools")
    (description
     "This package provides functions for the quality control, homogenization
and missing data infilling of climatological series, and to obtain
climatological summaries and grids from the results.  Also functions to draw
wind-roses and Walter&Lieth climate diagrams are included.")
    (license license:gpl2+)))

(define-public r-clipr
  (package
    (name "r-clipr")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clipr" version))
       (sha256
        (base32
         "1s9vvv3cxnz8w11gsi8z9ddv9jzib5qf5qqxnwqrrv7vj8cr7hij"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/mdlincoln/clipr")
    (synopsis "Read and write from the system clipboard")
    (description
     "This package provides simple utility functions to read from and write to
the system clipboards.")
    (license license:gpl3)))

(define-public r-clock
  (package
    (name "r-clock")
    (version "0.7.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "clock" version))
              (sha256
               (base32
                "1n7hl5mbywfshk8jid5shnsqsn1al0v636wsy14f681zkp1jyba3"))))
    (properties `((upstream-name . "clock")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for tests.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs
     (list r-cli
           r-cpp11
           r-lifecycle
           r-rlang
           r-tzdb
           r-vctrs))
    (native-inputs (list r-knitr r-testthat tzdata-for-tests))
    (home-page "https://clock.r-lib.org")
    (synopsis "Date-Time types and tools")
    (description
     "This package provides a comprehensive library for date-time
manipulations using a new family of orthogonal date-time
classes (durations, time points, zoned-times, and calendars) that
partition responsibilities so that the complexities of time zones are
only considered when they are really needed.  Capabilities include:
date-time parsing, formatting, arithmetic, extraction and updating of
components, and rounding.")
    (license license:expat)))

(define-public r-clvalid
  (package
    (name "r-clvalid")
    (version "0.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "clValid" version))
              (sha256
               (base32
                "18aiyjhnh5mfdxbzns4cy0r8bymfikhwkybpn4g04qhli5ls8z83"))))
    (properties `((upstream-name . "clValid")))
    (build-system r-build-system)
    (propagated-inputs (list r-class r-cluster))
    (home-page "https://cran.r-project.org/package=clValid")
    (synopsis "Validation of clustering results")
    (description
     "Statistical and biological validation of clustering results.  This
package implements Dunn Index, Silhouette, Connectivity, Stability, BHI and
BSI.  Further information can be found in Brock, G et al. (2008) <doi:
10.18637/jss.v025.i04>.")
    (license license:lgpl3)))

(define-public r-dlm
  (package
    (name "r-dlm")
    (version "1.1-6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dlm" version))
       (sha256
        (base32 "0hsz1xavzbylqb33c0qzalcqmq4g4i1c38wd351zjj88dvg73qvk"))))
    (properties `((upstream-name . "dlm")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=dlm")
    (synopsis "Bayesian and Likelihood Analysis of Dynamic Linear Models")
    (description
     "This package provides routines for Maximum likelihood, Kalman filtering
and smoothing, and Bayesian analysis of Normal linear State Space models, also
known as Dynamic Linear Models.")
    (license license:gpl2+)))

(define-public r-zcompositions
  (package
    (name "r-zcompositions")
    (version "1.5.0-4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "zCompositions" version))
              (sha256
               (base32
                "1bvaw6m95hz8hd5p8h1d482b45r3w82dyj3sxlijf12s0qg8w63k"))))
    (properties `((upstream-name . "zCompositions")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-nada r-truncnorm))
    (home-page "https://github.com/Japal/zCompositions")
    (synopsis
     "Treatment of zeros, left-censored and missing values in compositional data")
    (description
     "This is an R package for the imputation of left-censored data
under a compositional approach.  The implemented methods consider
aspects of relevance for a compositional approach such as scale
invariance, subcompositional coherence or preserving the multivariate
relative structure of the data.  Based on solid statistical
frameworks, it comprises the ability to deal with single and varying
censoring thresholds, consistent treatment of closed and non-closed
data, exploratory tools, multiple imputation, @dfn{Markov Chain Monte
Carlo} (MCMC), robust and non-parametric alternatives, and recent
proposals for count data.")
    (license license:gpl2+)))

(define-public r-zoo
  (package
    (name "r-zoo")
    (version "1.8-12")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "zoo" version))
              (sha256
               (base32
                "1f1g7f362sidh99n2pcgnj8iwsn7hnjgpdnkrqml5qzrd0k8dhz6"))))
    (build-system r-build-system)
    (arguments
     (list
      ;; Vignettes require r-tseries, which depends on r-zoo.
      #:test-types '(list "tests")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; These tests require r-tseries, which depends on r-zoo.
             (for-each delete-file
                       '("tests/vignette-zoo-quickref.R"
                         "tests/vignette-zoo.R")))))))
    (propagated-inputs
     (list r-lattice))
    (native-inputs (list r-chron r-mondate r-timedate r-tis))
    (home-page "https://zoo.R-Forge.R-project.org/")
    (synopsis "S3 infrastructure for regular and irregular time series")
    (description "This package contains an S3 class with methods for totally
ordered indexed observations.  It is particularly aimed at irregular time
series of numeric vectors/matrices and factors.")
    (license license:gpl2+)))

(define-public r-fontawesome
  (package
    (name "r-fontawesome")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fontawesome" version))
       (sha256
        (base32 "1jaw3jz9jz8v7msqv76f234vhrkcy21xgva81m0d313hf6ly4gfs"))))
    (properties `((upstream-name . "fontawesome")))
    (build-system r-build-system)
    ;; Some tests require r-dplyr; adding it to the inputs would lead to a
    ;; dependency cycle.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-htmltools r-rlang))
    (home-page "https://github.com/rstudio/fontawesome")
    (synopsis "Easily work with Font Awesome icons")
    (description
     "Easily and flexibly insert Font Awesome icons into R Markdown documents
and Shiny apps.  These icons can be inserted into HTML content through inline
SVG tags or @code{i} tags.  There is also a utility function for exporting
Font Awesome icons as PNG images for those situations where raster graphics
are needed.")
    (license license:expat)))

(define-public r-fingerprint
  (package
    (name "r-fingerprint")
    (version "3.5.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fingerprint" version))
       (sha256
        (base32 "04jcwkydjrs31pia6kq8z2n9s54im950q08hs2ay15xjxxkmb8ic"))))
    (properties `((upstream-name . "fingerprint")))
    (build-system r-build-system)
    (native-inputs (list r-runit))
    (home-page "https://cran.r-project.org/package=fingerprint")
    (synopsis "Functions to Operate on Binary Fingerprint Data")
    (description
     "This package provides functions to manipulate binary fingerprints of
arbitrary length.  A fingerprint is represented by an object of S4 class
@code{fingerprint}.  The bitwise logical functions in R are overridden so that
they can be used directly with @code{fingerprint} objects.  A number of
distance metrics are also available.  Fingerprints can be converted to
Euclidean vectors (i.e., points on the unit hypersphere) and can also be
folded.  Arbitrary fingerprint formats can be handled via line handlers.
Currently handlers are provided for CDK, MOE and BCI fingerprint data.")
    ;; Any version of the GPL
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-fpeek
  (package
    (name "r-fpeek")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fpeek" version))
       (sha256
        (base32 "0kv46g21ndxchg3q8ynq7hjjkh6i2zlc21axn5y1jjzigrw047ii"))))
    (properties `((upstream-name . "fpeek")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/davidgohel/fpeek")
    (synopsis "Check text files content at a glance")
    (description
     "This package provides tools to help working with text files.  It can
return the number of lines; print the first and last lines; convert encoding.
Operations are made without reading the entire file before starting, resulting
in good performances with large files.")
    (license license:expat)))

(define-public r-ggalluvial
  (package
   (name "r-ggalluvial")
   (version "0.12.5")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "ggalluvial" version))
            (sha256
             (base32
              "0wax853pi3ghqv5alfkx9rgfb3sm3sqh3miklwvn22bh1s44q14h"))))
   (properties `((upstream-name . "ggalluvial")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-dplyr
          r-ggplot2
          r-lazyeval
          r-rlang
          r-tidyr
          r-tidyselect))
   (native-inputs
    (list r-knitr r-testthat))
   (home-page "https://corybrunson.github.io/ggalluvial/")
   (synopsis "Alluvial plots for ggplot2")
   (description "This package provides alluvial plots for @code{ggplot2}.
Alluvial plots use variable-width ribbons and stacked bar plots to represent
multi-dimensional or repeated-measures data with categorical or ordinal
variables.")
   (license license:gpl3)))

(define-public r-ggpp
  (package
    (name "r-ggpp")
    (version "0.5.8-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggpp" version))
       (sha256
        (base32
         "1jk3x679rvkj3if14cai99w5sk0nj07rhppwwd7i7a1daal0grh5"))))
    (properties `((upstream-name . "ggpp")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-ggplot2
           r-glue
           r-gridextra
           r-lubridate
           r-magrittr
           r-mass
           r-polynom
           r-rlang
           r-scales
           r-stringr
           r-tibble
           r-vctrs
           r-xts
           r-zoo))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://docs.r4photobiology.info/ggpp/")
    (synopsis "Grammar extensions to ggplot2")
    (description
     "This package contains extensions to ggplot2.

@enumerate
@item Geomas: @code{geom_table}, @code{geom_plot} and @code{geom_grob} add
  insets to plots using native data coordinates, while @code{geom_table_npc},
  @code{geom_plot_npc} and @code{geom_grob_npc} do the same using @code{npc}
  coordinates through new aesthetics @code{npcx} and @code{npcy}.
@item Statistics: select observations based on 2D density.
@item Positions: radial nudging away from a center point and nudging away from
  a line or curve.
@end enumerate
")
    (license license:gpl2+)))

(define-public r-ggprism
  (package
    (name "r-ggprism")
    (version "1.0.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggprism" version))
              (sha256
               (base32
                "0waivf6a6bk52z139xfg0apmcv0mhjqb08yb4dzv8g7g22qfwdbz"))))
    (properties `((upstream-name . "ggprism")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest
           r-ggplot2
           r-glue
           r-gtable
           r-rlang
           r-scales
           r-tibble))
    (native-inputs (list r-knitr))
    (home-page "https://csdaw.github.io/ggprism/")
    (synopsis "ggplot2 extension inspired by GraphPad Prism")
    (description
     "This package provides various themes, palettes, and other functions that are
used to customise ggplots to look like they were made in GraphPad Prism.  The
Prism-look is achieved with @code{theme_prism()} and
@code{scale_fill|colour_prism()}, axes can be changed with custom guides like
@code{guide_prism_minor()}, and significance indicators added with
@code{add_pvalue()}.")
    (license license:gpl3+)))

(define-public r-ggrastr
  (package
    (name "r-ggrastr")
    (version "1.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggrastr" version))
              (sha256
               (base32
                "1l90mlb6bqq98ifmlbs5481vch9inmzdnvnz192adklrr9nl09yb"))))
    (properties `((upstream-name . "ggrastr")))
    (build-system r-build-system)
    (propagated-inputs (list r-cairo r-ggbeeswarm r-ggplot2 r-png r-ragg))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/VPetukhov/ggrastr")
    (synopsis "Rasterize layers for ggplot2")
    (description
     "Rasterize only specific layers of a ggplot2 plot while simultaneously keeping
all labels and text in vector format.  This allows users to keep plots within
the reasonable size limit without losing vector properties of the
scale-sensitive information.")
    (license license:expat)))

(define-public r-ggvenn
  (package
    (name "r-ggvenn")
    (version "0.1.10")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggvenn" version))
              (sha256
               (base32
                "0gl7z8hrn2wmmb59fvfv2hsw40p629aj086dv0kwlv162zqidqfd"))))
    (properties `((upstream-name . "ggvenn")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr r-ggplot2))
    (home-page "https://cran.r-project.org/package=ggvenn")
    (synopsis "Draw Venn diagram with ggplot2")
    (description
     "This package offers an easy to use way to draw a Venn diagram with
@code{ggplot2}.")
    (license license:expat)))

(define-public r-ggvenndiagram
  (package
    (name "r-ggvenndiagram")
    (version "1.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggVennDiagram" version))
       (sha256
        (base32
         "0hzjbpd3f3zn169s5nvnv7b4wlrwdn3r0pk0vgkdnhchl75g0qni"))))
    (properties `((upstream-name . "ggVennDiagram")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-aplot
           r-dplyr
           r-forcats
           r-ggplot2
           r-tibble
           r-venn
           r-yulab-utils))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/gaospecial/ggVennDiagram")
    (synopsis "Implementention of the Venn diagram using ggplot2")
    (description
     "This package implements easy-to-use functions to generate 2-7 sets Venn
plot in publication quality.  @code{ggVennDiagram} plot Venn using
well-defined geometry dataset and @code{ggplot2}.  The shapes of 2-4 sets Venn
use circles and ellipses, while the shapes of 4-7 sets Venn use irregular
polygons (4 has both forms), which are developed and imported from another
package @code{venn}.  We provide internal functions to integrate shape data
with user provided sets data, and calculated the geometry of every
regions/intersections of them, then separately plot Venn in three components:
set edges, set labels, and regions.  From version 1.0, it is possible to
customize these components as you demand in ordinary @code{ggplot2} grammar.")
    (license license:gpl3)))

(define-public r-laf
  (package
    (name "r-laf")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "LaF" version))
       (sha256
        (base32 "1mj010bl4ql0hm33vl0dd08s9dab11y9fa32nsqs6kbb22gjzk6p"))))
    (properties `((upstream-name . "LaF")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat r-yaml))
    (home-page "https://github.com/djvanderlaan/LaF")
    (synopsis "Fast access to large ASCII files")
    (description
     "This package provides methods for fast access to large ASCII files.
Currently the following file formats are supported: comma separated
format (CSV) and fixed width format.  It is assumed that the files are too
large to fit into memory, although the package can also be used to efficiently
access files that do fit into memory.  Methods are provided to access and
process files blockwise.  Furthermore, an opened file can be accessed as one
would an ordinary data.frame.  The @code{LaF} vignette gives an overview of
the functionality provided.")
    (license license:gpl3)))

(define-public r-lbfgsb3c
  (package
    (name "r-lbfgsb3c")
    (version "2024-3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lbfgsb3c" version))
       (sha256
        (base32 "0rgikv5p05rv4r55mihlbk1953jiwd95wp2rn05xqi4ix33y3vxj"))))
    (properties `((upstream-name . "lbfgsb3c")))
    (build-system r-build-system)
    (propagated-inputs (list r-numderiv r-rcpp r-rcpparmadillo))
    (native-inputs (list gfortran r-knitr r-testthat))
    (home-page "https://nlmixr2.github.io/lbfgsb3c/")
    (synopsis "Limited memory BFGS minimizer with bounds on parameters")
    (description
     "This package lets you interface to Nocedal et al. L-BFGS-B.3.0 limited
memory BFGS minimizer with bounds on parameters.  This registers a R
compatible C interface to L-BFGS-B.3.0 that uses the same function types and
optimization as the @code{optim()} function.  This package also adds more
stopping criteria as well as allowing the adjustment of more tolerances.")
    (license license:gpl2)))

(define-public r-lmds
  (package
    (name "r-lmds")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmds" version))
       (sha256
        (base32 "130azb0nc2wwxv0qi8v5s4rd02p9lc92zwn634pv7b8awbw81i65"))))
    (properties `((upstream-name . "lmds")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat r-dynutils r-irlba r-matrix))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/dynverse/lmds")
    (synopsis "Landmark multi-dimensional scaling")
    (description
     "This package provides a fast dimensionality reduction method scalable
to large numbers of samples.  @dfn{Landmark Multi-Dimensional Scaling} (LMDS)
is an extension of classical Torgerson MDS, but rather than calculating a
complete distance matrix between all pairs of samples, only the distances
between a set of landmarks and the samples are calculated.")
    (license license:gpl3)))

(define-public r-lmodel2
  (package
    (name "r-lmodel2")
    (version "1.7-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmodel2" version))
       (sha256
        (base32 "1fiin2nkffbihz1s8ixmw9lgf8mn3j9krr8iiflizk10mdv54hnb"))))
    (properties `((upstream-name . "lmodel2")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=lmodel2")
    (synopsis "Model II regression")
    (description
     "This package computes model II simple linear regression using
@dfn{ordinary least squares} (OLS), @dfn{major axis} (MA), @dfn{standard major
axis} (SMA), and @dfn{ranged major axis} (RMA).")
    (license license:gpl2)))

(define-public r-ggpmisc
  (package
    (name "r-ggpmisc")
    (version "0.6.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggpmisc" version))
              (sha256
               (base32
                "1ipi8dsxql94gk9h020shbvy26arpwjqlmkplyy746vmhkc03ma8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-confintr
           r-dplyr
           r-generics
           r-ggplot2
           r-ggpp
           r-lmodel2
           r-lubridate
           r-mass
           r-multcomp
           r-multcompview
           r-plyr
           r-polynom
           r-quantreg
           r-rlang
           r-scales
           r-splus2r
           r-tibble))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://www.r4photobiology.info/")
    (synopsis "Miscellaneous Extensions to @code{ggplot2}")
    (description "This package provides extensions to @code{ggplot2},
respecting the grammar of its graphics paradigm.")
    (license license:gpl2+)))

(define-public r-ggside
  (package
    (name "r-ggside")
    (version "0.3.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggside" version))
              (sha256
               (base32
                "1r36hsnha9bqzfb3rhpj11zg307wzacnkn4i6hi627xrx4knj5cl"))))
    (properties `((upstream-name . "ggside")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-ggplot2
           r-glue
           r-gtable
           r-rlang
           r-scales
           r-tibble
           r-vctrs))
    (native-inputs
     (list r-dplyr
           r-ggdendro
           r-knitr
           r-testthat
           r-tidyr
           r-vdiffr
           r-viridis))
    (home-page "https://cran.r-project.org/package=ggside")
    (synopsis "Side grammar graphics that extends @code{ggplot2}")
    (description
     "The grammar of graphics as shown in @code{ggplot2} has provided an
expressive API for users to build plots.  This package @{ggside} extends
@code{ggplot2} by allowing users to add graphical information about one of the
main panel's axis using a familiar @code{ggplot2} style API with tidy data.
This package is particularly useful for visualizing metadata on a discrete
axis, or summary graphics on a continuous axis such as a boxplot or a density
distribution.")
    (license license:expat)))

(define-public r-gparotation
  (package
    (name "r-gparotation")
    (version "2024.3-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GPArotation" version))
       (sha256
        (base32 "1njl4qg5jgmx14r41q1kzfmhf4zga3yjkig0h7ar35bq56pmgxl8"))))
    (properties `((upstream-name . "GPArotation")))
    (build-system r-build-system)
    (home-page "https://optimizer.r-forge.r-project.org/GPArotation_www/")
    (synopsis "Gradient projection factor rotation")
    (description
     "This package provides gradient projection algorithms for factor
rotation.  For details see @code{?GPArotation}.")
    (license license:gpl2+)))

(define-public r-gprofiler
  (package
    (name "r-gprofiler")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gProfileR" version))
       (sha256
        (base32
         "1h1v0kgpsn04ald2izznh7fr2riwisj5hcgz4k7h3qc931rf0r4k"))))
    (properties `((upstream-name . "gProfileR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr r-rcurl))
    (home-page "https://cran.r-project.org/web/packages/gProfileR/")
    (synopsis "Interface to the g:Profiler toolkit")
    (description
     "This package provides tools for functional enrichment analysis,
gene identifier conversion and mapping homologous genes across related
organisms via the @code{g:Profiler} toolkit.")
    (license license:gpl2+)))

(define-public r-gprofiler2
  (package
    (name "r-gprofiler2")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gprofiler2" version))
       (sha256
        (base32
         "1klmg0zj5kr663dzgfzpy1yn161znmjcjq8pl3rahjh2lwaahbmh"))))
    (properties `((upstream-name . "gprofiler2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crosstalk
           r-dplyr
           r-ggplot2
           r-gridextra
           r-jsonlite
           r-plotly
           r-rcurl
           r-tidyr
           r-viridislite))
    (native-inputs (list r-knitr r-rmarkdown))
    (home-page "https://cran.r-project.org/web/packages/gprofiler2/")
    (synopsis "Interface to the g:Profiler toolset")
    (description
     "This package provides a toolset for functional enrichment analysis and
visualization, gene/protein/SNP identifier conversion and mapping orthologous
genes across species via @url{https://biit.cs.ut.ee/gprofiler,g:Profiler}.
The main tools are:

@enumerate
@item @code{g:GOSt}, functional enrichment analysis and visualization of gene
  lists;
@item @code{g:Convert}, gene/protein/transcript identifier conversion across
  various namespaces;
@item @code{g:Orth}, orthology search across species;
@item @code{g:SNPense}, mapping SNP rs identifiers to chromosome positions,
  genes and variant effects.
@end enumerate

This package is an R interface corresponding to the 2019 update of
@code{g:Profiler} and provides access to versions @code{e94_eg41_p11} and
higher.")
    (license license:gpl2+)))

(define-public r-oenb
  (package
    (name "r-oenb")
    (version "0.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "oenb" version))
       (sha256
        (base32
         "1jgxw7ycx2lcdzglg9nix8k08fs4r6i5jdsjzrd6w1dg6smsinl5"))))
    (properties `((upstream-name . "oenb")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-xml))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/franzmohr/oenb")
    (synopsis "Tools for the OeNB Data Web Service")
    (description
     "Tools to access data from the data web service of the
@acronym{OeNB, Oesterreichische Nationalbank},
@url{https://www.oenb.at/en/Statistics/User-Defined-Tables/webservice.html}.")
    (license license:gpl2+)))

(define-public r-oompadata
  (package
    (name "r-oompadata")
    (version "3.1.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "oompaData" version))
              (sha256
               (base32
                "0g9d551djqa67y2l9nmajnsgf7kys4jcvgi3yx7az7jgm44j8986"))))
    (properties `((upstream-name . "oompaData")))
    (build-system r-build-system)
    (home-page "https://oompa.r-forge.r-project.org/")
    (synopsis "Data to illustrate OOMPA algorithms")
    (description
     "OOMPA offers R packages for gene expression and proteomics analysis.
OOMPA uses S4 classes to construct object-oriented tools with a consistent
user interface.  All higher level analysis tools in OOMPA are compatible with
the eSet classes defined in BioConductor.  The lower level processing tools
offer an alternative to parts of BioConductor, but can also be used to enhance
existing BioConductor packages.")
    (license license:asl2.0)))

(define-public r-oompabase
  (package
    (name "r-oompabase")
    (version "3.2.9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "oompaBase" version))
              (sha256
               (base32
                "1cmw2s5dznmv675484jgvkzgvi6vhg0zbxsq6zhpqsisf672pjhl"))))
    (properties `((upstream-name . "oompaBase")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster))
    (home-page "https://oompa.r-forge.r-project.org/")
    (synopsis "Class unions, matrix operations, and color schemes for OOMPA")
    (description
     "This package preloads class unions for defining/loading core OOMPA tools.
It also includes vectorized operations for row-by-row means, variances, and
t-tests.  Finally, it provides new colorschemes.")
    (license license:asl2.0)))

(define-public r-orgmassspecr
  (package
    (name "r-orgmassspecr")
    (version "0.5-3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "OrgMassSpecR" version))
              (sha256
               (base32
                "1dx9d8rb1dfqyhyc26zhfnxiv3rz2ikvs2mwqnsrq3lsjs9dvyc8"))))
    (properties `((upstream-name . "OrgMassSpecR")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://OrgMassSpec.github.io/")
    (synopsis "Organic or biological mass spectrometry data analysis")
    (description
     "This package @code{OrgMassSpecR} is an extension of the @code{R}
statistical computing language.  It contains functions to assist with organic
or biological mass spectrometry data analysis.  Mass spectral libraries are
available as companion packages.")
    (license license:bsd-2)))

(define-public r-scales
  (package
    (name "r-scales")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "scales" version))
       (sha256
        (base32 "122qyd88qr8cc8h3k46xpygm00inqpm55zdy0b7535958imhygmk"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for one failing test.
         (add-before 'check 'set-timezone
           ;; This package is picky about timezones.
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC+1")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs
     (list r-cli
           r-farver
           r-glue
           r-labeling
           r-lifecycle
           r-munsell
           r-r6
           r-rcolorbrewer
           r-rlang
           r-viridislite))
    (native-inputs (list r-hms r-stringi r-testthat tzdata-for-tests))
    (home-page "https://github.com/hadley/scales")
    (synopsis "Scale functions for visualization")
    (description
     "This package provides graphical scales that map data to aesthetics, and
provides methods for automatically determining breaks and labels for axes and
legends.")
    (license license:expat)))

(define-public r-skat
  (package
    (name "r-skat")
    (version "2.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SKAT" version))
       (sha256
        (base32 "1x2iyvzc66lmzwjdr8hy5gf3nxc7ik5vhbs40w00d2m7nr3glh8l"))))
    (properties `((upstream-name . "SKAT")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-rspectra r-spatest))
    (home-page "https://cran.r-project.org/package=SKAT")
    (synopsis "SNP-Set (Sequence) kernel association test")
    (description
     "This package provides functions for kernel-regression-based association
tests including Burden test, SKAT and SKAT-O.  These methods aggregate
individual SNP score statistics in a SNP set and efficiently compute SNP-set
level p-values.")
    (license license:gpl2+)))

(define-public r-swagger
  (package
    (name "r-swagger")
    (version "5.17.14.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "swagger" version))
              (sha256
               (base32
                "0ykmz3j1n06w1injcnlkb3xv79vwiyv94j74m950rfrbv97dda58"))))
    (properties `((upstream-name . "swagger")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/rstudio/swagger")
    (synopsis
     "Dynamically generate documentation from a Swagger-compliant API")
    (description
     "This package provides a collection of HTML, JavaScript, and CSS assets
that dynamically generate beautiful documentation from a Swagger compliant
API.")
    (license license:asl2.0)))

(define-public r-pacman
  (package
    (name "r-pacman")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "pacman" version))
              (sha256
               (base32
                "0z7gngd6h83cpjhq1vg75wvzhdjbgjh7gj5d4zvvi9gd2lmagjcy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-remotes))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/trinker/pacman")
    (synopsis "Package Management Tool")
    (description "This package provides tools to more conveniently perform
tasks associated with add-on packages.  @code{pacman} conveniently wraps
library and package related functions and names them in an intuitive and
consistent fashion.  It seeks to combine functionality from lower level
functions which can speed up workflow.")
    (license license:gpl2)))

(define-public r-pagoda2
  (package
    (name "r-pagoda2")
    (version "1.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pagoda2" version))
       (sha256
        (base32 "1kck12ri52nwsrxhjs8ghjji3rv1dxxjy8bxn1kk1hbg30265fsw"))))
    (properties `((upstream-name . "pagoda2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dendsort
           r-drat
           r-fastcluster
           r-igraph
           r-irlba
           r-magrittr
           r-mass
           r-matrix
           r-mgcv
           r-n2r
           r-plyr
           r-r-utils
           r-r6
           r-rcpp
           r-rcpparmadillo
           r-rcppeigen
           r-rcppprogress
           r-rjson
           r-rlang
           r-rmtstat
           r-rook
           r-rtsne
           r-sccore
           r-urltools))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/kharchenkolab/pagoda2")
    (synopsis "Single cell analysis and differential expression")
    (description
     "The package offers functions for analyzing and interactively exploring
large-scale single-cell RNA-seq datasets.  Pagoda2 primarily performs
normalization and differential gene expression analysis, with an interactive
application for exploring single-cell RNA-seq datasets.  It performs basic
tasks such as cell size normalization, gene variance normalization, and can be
used to identify subpopulations and run differential expression within
individual samples.  pagoda2 was written to rapidly process modern large-scale
scRNAseq datasets of approximately 1e6 cells.  The companion web application
allows users to explore which gene expression patterns form the different
subpopulations within your data.  The package also serves as the primary
method for preprocessing data for conos.")
    (license license:gpl3)))

(define-public r-pals
  (package
    (name "r-pals")
    (version "1.9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "pals" version))
              (sha256
               (base32
                "1rnm6yvql39b4gbly90svbb5n9m66gc7f0abrxzkll6vsn71xfar"))))
    (properties `((upstream-name . "pals")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-dichromat r-mapproj r-maps))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://kwstat.github.io/pals/")
    (synopsis "Color palettes, color maps, and tools to evaluate them")
    (description
     "This package provides a comprehensive collection of color
palettes, color maps, and tools to evaluate them.")
    (license license:gpl3)))

(define-public r-papaja
  (package
    (name "r-papaja")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "papaja" version))
       (sha256
        (base32 "0lknj3r4kd8i4jlfi8q7p7fi2s009q8rryf0r44zxfxvr9nkmyxv"))))
    (properties `((upstream-name . "papaja")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; This is needed for vignettes.
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp")))
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; 6 tests fail because of slight format differences.  The values
             ;; are all fine.
             (for-each delete-file
                       '("tests/testthat/test_apa_print_glm.R"
                         "tests/testthat/test_apa_print_model_comp.R")))))))
    (propagated-inputs
     (list r-bookdown
           r-broom
           r-glue
           r-knitr
           r-rmarkdown
           r-rmdfiltr
           r-tinylabels
           r-yaml
           r-zip
           texlive-amsmath
           texlive-apa6
           texlive-booktabs
           texlive-caption
           texlive-csquotes
           texlive-endfloat
           texlive-environ
           texlive-etoolbox
           texlive-fancyhdr
           texlive-framed
           texlive-geometry
           texlive-graphics
           texlive-grfext
           texlive-hyperref
           texlive-lineno
           texlive-multirow
           texlive-threeparttable
           texlive-threeparttablex
           texlive-titlesec
           texlive-tools
           texlive-trimspaces
           texlive-was                  ; upgreek.sty
           texlive-xcolor
           texlive-xpatch
           (texlive-updmap.cfg (list
                                texlive-amsfonts
                                texlive-times
                                texlive-lm))))
    (native-inputs
     (list r-afex
           r-bayesfactor
           r-beeswarm
           r-effectsize
           r-emmeans
           r-multcomp
           r-knitr
           r-r-rsp
           r-testthat
           r-vgam))
    (home-page "https://github.com/crsh/papaja")
    (synopsis
     "Prepare American Psychological Association journal articles with R Markdown")
    (description
     "This package provides tools to create dynamic, submission-ready
manuscripts, which conform to American Psychological Association manuscript
guidelines.  It provides R Markdown document formats for manuscripts (PDF and
Word) and revision letters (PDF).  Helper functions facilitate reporting
statistical analyses or create publication-ready tables and plots.")
    (license license:expat)))

(define-public r-paralleldist
  (package
    (name "r-paralleldist")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parallelDist" version))
       (sha256
        (base32 "01ly4hxwa64a0ya5gla8rvv72s9mcknsfznivjkh937pbjwb7iih"))))
    (properties `((upstream-name . "parallelDist")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcpparmadillo r-rcppparallel))
    (native-inputs (list r-dtw r-ggplot2 r-proxy r-rcppxptrutils r-testthat))
    (home-page "https://github.com/alexeckert/parallelDist")
    (synopsis "Parallel Distance Matrix Computation using multiple threads")
    (description
     "This package provides a fast parallelized alternative to R's native
@code{dist} function to calculate distance matrices for continuous, binary,
and multi-dimensional input matrices, which supports a broad variety of
predefined distance functions from other R packages, as well as user- defined
functions written in C++.  For ease of use, the @code{parDist} function
extends the signature of the @code{dist} function and uses the same parameter
naming conventions as distance methods of existing R packages.")
    (license license:gpl2+)))

(define-public r-paramhelpers
  (package
    (name "r-paramhelpers")
    (version "1.14.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ParamHelpers" version))
              (sha256
               (base32
                "088sl3az4ysq8cyw82brdn9xm5yy7rqskxih462d1m5hi62gyl04"))))
    (properties `((upstream-name . "ParamHelpers")))
    (build-system r-build-system)
    (propagated-inputs (list r-backports r-bbmisc r-checkmate r-fastmatch))
    (native-inputs (list r-testthat))
    (home-page "https://paramhelpers.mlr-org.com")
    (synopsis
     "Helpers for parameters in black-box optimization, tuning, and machine learning")
    (description
     "This is a package for parameter description and operations in
optimization, tuning and machine learning.  Parameters can be described (type,
constraints, defaults, etc.), combined to parameter sets and can in general be
programmed on.  A useful @code{OptPath} object (archive) to log function
evaluations is also provided.")
    (license license:bsd-2)))

(define-public r-parallelmap
  (package
    (name "r-parallelmap")
    (version "1.5.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "parallelMap" version))
              (sha256
               (base32
                "1qg7zpz5sd9jp8wzjqahkhipwj1jn192llwg06q4gv9mlcsac261"))))
    (properties `((upstream-name . "parallelMap")))
    (build-system r-build-system)
    (propagated-inputs (list r-bbmisc r-checkmate))
    (native-inputs (list r-batchjobs r-batchtools r-rpart r-testthat))
    (home-page "https://parallelmap.mlr-org.com")
    (synopsis "Unified interface to parallelization backends")
    (description
     "This package provides a unified parallelization framework for multiple
backends.  This package is designed for internal package and interactive
usage.  The main operation is parallel mapping over lists.  It supports local,
multicore, mpi and BatchJobs mode.  It allows tagging of the parallel
operation with a level name that can be later selected by the user to switch
on parallel execution for exactly this operation.")
    (license license:bsd-2)))

(define-public r-pheatmap
  (package
    (name "r-pheatmap")
    (version "1.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pheatmap" version))
       (sha256
        (base32
         "1hdh74az3vyzz6dqa311rhxdm74n46lyr03p862kn80p0kp9d7ap"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gtable r-rcolorbrewer r-scales))
    (home-page "https://cran.r-project.org/web/packages/pheatmap")
    (synopsis "Pretty heatmaps")
    (description
     "This package provides an implementation of heatmaps that offers more
control over dimensions and appearance.")
    (license license:gpl2+)))

(define-public r-philentropy
  (package
    (name "r-philentropy")
    (version "0.9.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "philentropy" version))
              (sha256
               (base32
                "04rmhfslim3vwxi14qllp9kzjcl7fwyzczar0lb72j5vd07mmns0"))))
    (properties `((upstream-name . "philentropy")))
    (build-system r-build-system)
    (propagated-inputs (list r-kernsmooth r-poorman r-rcpp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/drostlab/philentropy")
    (synopsis
     "Similarity and distance quantification between probability functions")
    (description
     "This package computes optimized distance and similarity measures for
comparing probability functions (Drost (2018) <doi:10.21105/joss.00765>).
These comparisons between probability functions have their foundations in a
broad range of scientific disciplines from mathematics to ecology.  The aim of
this package is to provide a core framework for clustering, classification,
statistical inference, goodness-of-fit, non-parametric statistics, information
theory, and machine learning tasks that are based on comparing univariate or
multivariate probability functions.")
    (license license:gpl2)))

(define-public r-pnwcolors
  (package
    (name "r-pnwcolors")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PNWColors" version))
       (sha256
        (base32
         "1phplnclkficfv8s6wsyrckk4ixzbayiy5iix6dddg40485l9nyj"))))
    (properties `((upstream-name . "PNWColors")))
    (build-system r-build-system)
    (home-page "https://github.com/jakelawlor/PNWColors")
    (synopsis "Color palettes for data visualizations")
    (description
     "This package provides color palettes.  They are checked for colorblind
accessibility from hue, saturation, and lightness value scaling using the
Chroma.js Color Palette Helper.  See @url{https://gka.github.io/palettes}.")
    (license license:cc0)))

(define-public r-plotfunctions
  (package
    (name "r-plotfunctions")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plotfunctions" version))
       (sha256
        (base32 "0asmxw8283fpvl83h478j5nyg59xqifqaa8f2f6l199gvvswhhg2"))))
    (properties `((upstream-name . "plotfunctions")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://jacolienvanrij.com/tutorials.html")
    (synopsis "Various functions to facilitate visualization of data and analysis")
    (description
     "When analyzing data, plots are a helpful tool for visualizing data and
interpreting statistical models.  This package provides a set of simple tools
for building plots incrementally, starting with an empty plot region, and
adding bars, data points, regression lines, error bars, gradient legends,
density distributions in the margins, and even pictures.  The package builds
further on R graphics by simply combining functions and settings in order to
reduce the amount of code to produce for the user.  As a result, the package
does not use formula input or special syntax, but can be used in combination
with default R plot functions.")
    (license license:gpl2+)))

(define-public r-plotmo
  (package
    (name "r-plotmo")
    (version "3.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plotmo" version))
       (sha256
        (base32 "0wl2xlidib4r54nm1q5zndr9iilagpyc3xlxs0cpd487hdh3zcn8"))))
    (properties `((upstream-name . "plotmo")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-plotrix))
    (native-inputs (list r-rpart))
    (home-page "http://www.milbo.users.sonic.net")
    (synopsis
     "Plot a model's residuals, response, and partial dependence plots")
    (description
     "This package lets you plot model surfaces for a wide variety of models
using partial dependence plots and other techniques.  Also plot model
residuals and other information on the model.")
    (license license:gpl3)))

(define-public r-plumber
  (package
    (name "r-plumber")
    (version "1.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "plumber" version))
              (sha256
               (base32
                "1ycq3kjkrlx66h05g5ncvmq2cr051609xs4bzs8n49c70h6p0bpr"))))
    (properties `((upstream-name . "plumber")))
    (build-system r-build-system)
    (propagated-inputs (list r-crayon
                             r-ellipsis
                             r-httpuv
                             r-jsonlite
                             r-lifecycle
                             r-magrittr
                             r-mime
                             r-promises
                             r-r6
                             r-rlang
                             r-sodium
                             r-stringi
                             r-swagger
                             r-webutils))
    (native-inputs (list r-testthat))
    (home-page "https://www.rplumber.io")
    (synopsis "API generator for R")
    (description
     "This package gives you the ability to automatically generate and serve
an HTTP API from R functions using the annotations in the R documentation
around your functions.")
    (license license:expat)))

(define-public r-polychrome
  (package
    (name "r-polychrome")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Polychrome" version))
       (sha256
        (base32 "0hyi02m2jpdhk1ky6ihz6dv5pwqwjwk4csjim2qr8ywx8midmrvg"))))
    (properties `((upstream-name . "Polychrome")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-scatterplot3d))
    (native-inputs
     (list r-knitr))
    (home-page "https://oompa.r-forge.r-project.org/")
    (synopsis "Qualitative palettes with many colors")
    (description
     "This package provides tools for creating, viewing, and assessing
qualitative palettes with many (20-30 or more) colors.  See Coombes and
colleagues (2019) @url{https://doi:10.18637/jss.v090.c01}.")
    (license license:asl2.0)))

(define-public r-polylabelr
  (package
    (name "r-polylabelr")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "polylabelr" version))
              (sha256
               (base32
                "01b2v0l5g8nxwbd6nwqv8ahypgh6gfhd4qabg75brlj7z1iyfzf2"))))
    (properties `((upstream-name . "polylabelr")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jolars/polylabelr")
    (synopsis "Finding pole of inaccessibility (visual center) of a polygon")
    (description
     "This package provides a wrapper around the @code{C++} library @code{
polylabel} from @code{Mapbox}, providing an efficient routine for finding the
approximate pole of inaccessibility of a polygon, which usually serves as an
excellent candidate for labeling of a polygon.")
    (license license:expat)))

(define-public r-poorman
  (package
    (name "r-poorman")
    (version "0.2.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "poorman" version))
              (sha256
               (base32
                "1amlcbgfnm6yh7lmlzhs7aalv4mdm2ir3s2kpx33ppnz7hlii508"))))
    (properties `((upstream-name . "poorman")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://nathaneastwood.github.io/poorman/")
    (synopsis "Dependency-free recreation of dplyr")
    (description
     "This package provides a replication of key functionality from
@code{dplyr} and the wider @code{tidyverse} using only @code{base}.")
    (license license:expat)))

(define-public r-ecdat
  (package
    (name "r-ecdat")
    (version "0.4-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Ecdat" version))
       (sha256
        (base32 "1vyc4ynkd65mng2x8wvzn47crsvaqfz97n89jxn12xv13bpsbs7c"))))
    (properties `((upstream-name . "Ecdat")))
    (build-system r-build-system)
    (propagated-inputs (list r-ecfun))
    (home-page "https://www.r-project.org")
    (synopsis "Data sets for econometrics")
    (description "This package provides data sets for econometrics, including
political science.")
    (license license:gpl2+)))

(define-public r-ecfun
  (package
    (name "r-ecfun")
    (version "0.3-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Ecfun" version))
       (sha256
        (base32 "0651vbb040y17sizh927vq4jfidpxilmwdgkhmr7z8p24yb588rc"))))
    (properties `((upstream-name . "Ecfun")))
    (build-system r-build-system)
    (propagated-inputs (list r-bma
                             r-fda
                             r-jpeg
                             r-mass
                             r-mvtnorm
                             r-readr
                             r-rvest
                             r-rworldmap
                             r-stringi
                             r-tis
                             r-xml2))
    (native-inputs (list r-knitr))
    (home-page "https://www.r-project.org")
    (synopsis "Functions for Ecdat")
    (description
     "This package provides functions and vignettes to update data sets in
Ecdat and to create, manipulate, plot, and analyze those and similar data
sets.")
    (license license:gpl2+)))

(define-public r-ecosolver
  (package
    (name "r-ecosolver")
    (version "0.5.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ECOSolveR" version))
              (sha256
               (base32
                "1izc8dwj438wpkmdmhwnnhkijz5skig4gwxgr6f1bzmj08bfv515"))))
    (properties `((upstream-name . "ECOSolveR")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-matrix r-testthat))
    (home-page "https://bnaras.github.io/ECOSolveR/")
    (synopsis "Embedded conic solver in R")
    (description
     "This package provides an R interface to the @dfn{Embedded COnic
Solver} (ECOS), an efficient and robust C library for convex problems.
Conic and equality constraints can be specified in addition to integer
and boolean variable constraints for mixed-integer problems.  This R
interface is inspired by the Python interface and has similar calling
conventions.")
    (license license:gpl3+)))

(define-public r-ecp
  (package
    (name "r-ecp")
    (version "3.1.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ecp" version))
              (sha256
               (base32
                "1imahvby3nj1b5d1x7hq6gkfg0fyyd27ghls0v35456imy1fmhz5"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (native-inputs (list r-r-rsp))
    (home-page "https://cran.r-project.org/web/packages/ecp/")
    (synopsis "Multiple change-point analysis of multivariate data")
    (description
     "This package implements various procedures for finding multiple
change-points.  Two methods make use of dynamic programming and pruning, with
no distributional assumptions other than the existence of certain absolute
moments in one method.  Hierarchical and exact search methods are included.
All methods return the set of estimated change-points as well as other summary
information.")
    (license license:gpl2+)))

(define-public r-ellipsis
  (package
    (name "r-ellipsis")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ellipsis" version))
       (sha256
        (base32
         "0n0mm9jngklv7j9wa64jdji035z0smmnsp2dfwcz9isrxgjnc0m9"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hadley/ellipsis")
    (synopsis "Tools for working with additional arguments")
    (description
     "In S3 generics, it's useful to take @code{...} so that methods can have
additional arguments.  But this flexibility comes at a cost: misspelled
arguments will be silently ignored.  The @code{ellipsis} package is an
experiment that allows a generic to warn if any arguments passed in @code{...}
are not used.")
    (license license:gpl3)))

(define-public r-ga
  (package
    (name "r-ga")
    (version "3.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GA" version))
       (sha256
        (base32 "1gc1n2xdzrkc9cvrm6a50c9xpwvf0isdgvs1qpm8x1afacw6d7z5"))))
    (properties `((upstream-name . "GA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-crayon
           r-foreach
           r-iterators
           r-rcpp
           r-rcpparmadillo))
    (native-inputs
     (list r-knitr))
    (home-page "https://luca-scr.github.io/GA/")
    (synopsis "Genetic algorithms for stochastic optimisation")
    (description
     "Flexible general-purpose toolbox implementing genetic algorithms (GAs)
for stochastic optimisation.  Binary, real-valued, and permutation
representations are available to optimize a fitness function, i.e., a function
provided by users depending on their objective function.  Several genetic
operators are available and can be combined to explore the best settings for
the current task.  Furthermore, users can define new genetic operators and
easily evaluate their performances.  Local search using general-purpose
optimisation algorithms can be applied stochastically to exploit interesting
regions.  GAs can be run sequentially or in parallel, using an explicit
master-slave parallelisation or a coarse-grain islands approach.")
    (license license:gpl2+)))

(define-public r-greg
  (package
    (name "r-greg")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Greg" version))
       (sha256
        (base32 "13rsah8vf9s8wpkr5hlayyqa8v728cz80bvpg8vmlvnam8isb30s"))))
    (properties `((upstream-name . "Greg")))
    (build-system r-build-system)
    (propagated-inputs (list r-broom
                             r-dplyr
                             r-epi
                             r-forestplot
                             r-glue
                             r-gmisc
                             r-hmisc
                             r-htmltable
                             r-knitr
                             r-nlme
                             r-purrr
                             r-rlang
                             r-rms
                             r-sandwich
                             r-stringr
                             r-tibble
                             r-tidyr
                             r-tidyselect))
    (native-inputs (list r-boot r-knitr r-testthat r-tidyverse))
    (home-page "http://gforge.se")
    (synopsis "Regression helper functions")
    (description
     "This package provides methods for manipulating regression models and for
describing these in a style adapted for medical journals.  It contains
functions for generating an HTML table with crude and adjusted estimates,
plotting hazard ratio, plotting model estimates and confidence intervals using
forest plots, extending this to comparing multiple models in a single forest
plots.  In addition to the descriptive methods, there are functions for the
robust covariance matrix provided by the sandwich package, a function for
adding non-linearities to a model, and a wrapper around the Epi package's
@code{Lexis()} functions for time-splitting a dataset when modeling
non-proportional hazards in Cox regressions.")
    (license license:gpl3+)))

(define-public r-grr
  (package
    (name "r-grr")
    (version "0.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "grr" version))
       (sha256
        (base32
         "0arbcgrvhkwb5xk4nry1ffg2qj0v8ivhjghdr505ib4357g0c9i9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/grr")
    (synopsis "Alternative implementations of base R functions")
    (description
     "This package provides alternative implementations of some base R
functions, including @code{sort}, @code{order}, and @code{match}.  The
functions are simplified but can be faster or have other advantages.")
    (license license:gpl3)))

(define-public r-matrixtests
  (package
    (name "r-matrixtests")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "matrixTests" version))
       (sha256
        (base32 "0d7i00cxzszfdnjm8q5b72ildic8nig6fbw7rba6acdnllpp7sza"))))
    (properties `((upstream-name . "matrixTests")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrixstats))
    (native-inputs
     (list r-car r-cosinor r-cosinor2 r-moments r-nortest r-pmcmrplus))
    (home-page "https://github.com/karoliskoncevicius/matrixTests")
    (synopsis "Statistical hypothesis tests on rows and columns of matrices")
    (description
     "This package offers quick statistical hypothesis testing for matrix
rows/columns.  The main goals are speed through vectorization, detailed and
user-friendly output, and compatibility with tests implemented in R.")
    (license license:gpl2)))

(define-public r-matrix-utils
  (package
    (name "r-matrix-utils")
    (version "0.9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Matrix.utils" version))
       (sha256
        (base32
         "0a5fq1scykqk0kc9j051j6fix6j2dqwz5wbgb0amaxsiywz9vigb"))))
    (properties `((upstream-name . "Matrix.utils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-grr r-matrix))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/cvarrichio/Matrix.utils")
    (synopsis
     "Data.frame-Like Operations on Sparse and Dense Matrix Objects")
    (description
     "This package implements data manipulation methods such as @code{cast},
@code{aggregate}, and @code{merge}/@code{join} for Matrix and Matrix-like
objects.")
    (license license:gpl3)))

(define-public r-mblm
  (package
    (name "r-mblm")
    (version "0.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mblm" version))
       (sha256
        (base32 "1fipb3bryaimr30lcxsxrn0ymv24z39swca7s4z7p9xcfg3ban1b"))))
    (properties `((upstream-name . "mblm")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/mblm/index.html")
    (synopsis "Median-based linear models")
    (description
     "This package provides linear models based on Theil-Sen single median and
Siegel repeated medians.  They are very robust (29 or 50 percent breakdown
point, respectively), and if no outliers are present, the estimators are very
similar to OLS.")
    (license license:gpl2+)))

(define-public r-mboost
  (package
   (name "r-mboost")
   (version "2.9-11")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "mboost" version))
            (sha256
             (base32
              "0n5wpyayhdyd46vl87c9r70m13y48khmlwii58rvi57mgw6aadwz"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-lattice
          r-matrix
          r-nnls
          r-partykit
          r-quadprog
          r-stabs
          r-survival))
   (native-inputs (list r-testthat))
   (home-page "https://github.com/boost-R/mboost")
   (synopsis "Model-based boosting")
   (description
    "This package provides a functional gradient descent algorithm (boosting)
for optimizing general risk functions utilizing component-wise (penalised)
least squares estimates or regression trees as base-learners for fitting
generalized linear, additive and interaction models to potentially
high-dimensional data.")
   (license license:gpl2)))

(define-public r-mc2d
  (package
    (name "r-mc2d")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mc2d" version))
              (sha256
               (base32
                "06kva55vm2cldd95caw5hfx0xjadyhgkqi0y9pyz7hs3zg0zq9xy"))))
    (properties `((upstream-name . "mc2d")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-ggpubr r-mvtnorm))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=mc2d")
    (synopsis "Tools for two-dimensional monte-carlo simulations")
    (description
     "This is a framework for construction and analysis of 2D Monte-Carlo
simulations.  In addition, this package includes various distributions.")
    (license license:gpl2+)))

(define-public r-mclogit
  (package
    (name "r-mclogit")
    (version "0.9.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mclogit" version))
              (sha256
               (base32
                "0sbglgak6jhhpx65jnj59hbpvzs8qjsdjc4w02z0m5j9hrnmzp4s"))))
    (properties `((upstream-name . "mclogit")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-memisc))
    (home-page "https://www.elff.eu/software/mclogit/")
    (synopsis
     "Multinomial logit models, with or without random effects or overdispersion")
    (description
     "This package provides estimators for multinomial logit models in their
conditional logit and baseline logit variants, with or without random effects,
with or without overdispersion.  Random effects models are estimated using the
PQL technique (based on a Laplace approximation) or the MQL technique (based
on a Solomon-Cox approximation).  Estimates should be treated with caution if
the group sizes are small.")
    (license license:gpl2)))

(define-public r-mcmcglmm
  (package
    (name "r-mcmcglmm")
    (version "2.36")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "MCMCglmm" version))
       (sha256
        (base32 "1wca9x5c9x88cryj1pkhl73chmnbc1653j08faz7lp03z2mdkzv6"))))
    (properties `((upstream-name . "MCMCglmm")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape
                             r-coda
                             r-corpcor
                             r-cubature
                             r-matrix
                             r-tensora))
    (home-page "https://github.com/jarrodhadfield/MCMCglmm")
    (synopsis "MCMC generalised linear mixed models")
    (description
     "This package fits multivariate generalized linear mixed models and
related models.  This is done using Markov chain Monte Carlo techniques.")
    (license license:gpl2+)))

(define-public r-mcr
  (package
    (name "r-mcr")
    (version "1.3.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mcr" version))
       (sha256
        (base32 "0gbpnbs8mgqpyiayddcaf1xwh908gk1n375bqpnvfppyj0wz3yr9"))))
    (properties `((upstream-name . "mcr")))
    (build-system r-build-system)
    (propagated-inputs (list r-robslopes))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=mcr")
    (synopsis "Method comparison regression")
    (description
     "Regression methods to quantify the relation between two measurement
methods are provided by this package.  In particular it addresses regression
problems with errors in both variables and without repeated measurements.  It
implements the CLSI recommendations (see J. A. Budd et al. (2018,
@url{https://clsi.org/standards/products/method-evaluation/documents/ep09/})
for analytical method comparison and bias estimation using patient samples.
Furthermore, algorithms for Theil-Sen and equivariant Passing-Bablok
estimators are implemented, see F. Dufey (2020, <doi:10.1515/ijb-2019-0157>)
and J. Raymaekers and F. Dufey (2022, <@code{arXiv:2202:08060>}).  A
comprehensive overview over the implemented methods and references can be
found in the manual pages @code{mcr-package} and @code{mcreg}.")
    (license license:gpl3+)))

(define-public r-shadowtext
  (package
    (name "r-shadowtext")
    (version "0.1.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "shadowtext" version))
              (sha256
               (base32
                "1s3fsh6cmblyhlqrswialc9437as306ki36dyx0dv4001slvxl47"))))
    (properties `((upstream-name . "shadowtext")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-scales))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/GuangchuangYu/shadowtext/")
    (synopsis "Shadow text grob and layer")
    (description "This package implements @code{shadowtextGrob()} for
@code{grid} and @code{geom_shadowtext()} layer for @code{ggplot2}.
These functions draw text grob with background shadow.")
    (license license:artistic2.0)))

(define-public r-sys
  (package
    (name "r-sys")
    (version "3.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sys" version))
       (sha256
        (base32
         "0flihfpfawismsy5piddf2flz1i1fw35k47gxwkbhk87wcr767h5"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jeroen/sys")
    (synopsis "Powerful and reliable tools for running system commands in R")
    (description
     "This package provides drop-in replacements for the base @code{system2()}
function with fine control and consistent behavior across platforms.  It
supports clean interruption, timeout, background tasks, and streaming STDIN /
STDOUT / STDERR over binary or text connections.  The package also provides
functions for evaluating expressions inside a temporary fork.  Such
evaluations have no side effects on the main R process, and support reliable
interrupts and timeouts.  This provides the basis for a sandboxing
mechanism.")
    (license license:expat)))

(define-public r-ashr
  (package
   (name "r-ashr")
   (version "2.2-63")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "ashr" version))
            (sha256
             (base32
              "1japskxfdsg91jwgf5knlwy9iaq4ziqvyvlvjch1y3ygsdz9b8bz"))))
   (properties `((upstream-name . "ashr")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-etrunct
          r-invgamma
          r-matrix
          r-mixsqp
          r-rcpp
          r-squarem
          r-truncnorm))
   (native-inputs
    (list r-knitr r-testthat))
   (home-page "https://github.com/stephens999/ashr")
   (synopsis "Methods for adaptive shrinkage, using empirical bayes")
   (description "This package implements an empirical Bayes approach for
large-scale hypothesis testing and false discovery rate estimation.")
   (license license:gpl3+)))

(define-public r-askpass
  (package
    (name "r-askpass")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "askpass" version))
       (sha256
        (base32
         "1pf7q2p0caxnb22zvg6yj250b817drldk5d7rvr4i9s49jkhc8bc"))))
    (build-system r-build-system)
    (propagated-inputs (list r-sys))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jeroen/askpass")
    (synopsis "Safe password entry for R")
    (description
     "This package provides cross-platform utilities for prompting the user
for credentials or a passphrase, for example to authenticate with a server or
read a protected key.")
    (license license:expat)))

(define-public r-astsa
  (package
    (name "r-astsa")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "astsa" version))
       (sha256
        (base32 "0rnbacq5vbnlzfssj13ixgkg0d1wixh2m3dcsi66c63wx65rm3d3"))))
    (properties `((upstream-name . "astsa")))
    (build-system r-build-system)
    (home-page "https://github.com/nickpoison/astsa/")
    (synopsis "Applied statistical time series analysis")
    (description
     "This package provides data sets and scripts to accompany Time Series
Analysis and Its Applications: With R Examples (4th ed), by R.H. Shumway and
D.S. Stoffer.  Springer Texts in Statistics, 2017,
@url{https://doi.org/10.1007/978-3-319-52452-8}, and Time Series: A Data
Analysis Approach Using R.  Chapman-Hall, 2019,
@url{https://doi.org/10.1201/9780429273285}.")
    (license license:gpl3)))

(define-public r-vegan
  (package
    (name "r-vegan")
    (version "2.6-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vegan" version))
       (sha256
        (base32
         "1hdkp316cx06jccb4f4n8592g82wmrf0k0pcm1nxy38m72xy4v8r"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran r-knitr))
    (propagated-inputs
     (list r-cluster r-lattice r-mass r-mgcv r-permute))
    (home-page "https://cran.r-project.org/web/packages/vegan")
    (synopsis "Functions for community ecology")
    (description
     "The vegan package provides tools for descriptive community ecology.  It
has most basic functions of diversity analysis, community ordination and
dissimilarity analysis.  Most of its multivariate tools can be used for other
data types as well.")
    (license license:gpl2+)))

(define-public r-tglkmeans
  (package
    (name "r-tglkmeans")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tglkmeans" version))
       (sha256
        (base32 "0hdnxgkxpgb8jm9aygv3wlhd42blm5nz906vlpl72blgcyc77hhh"))))
    (properties `((upstream-name . "tglkmeans")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-dofuture
                             r-dorng
                             r-dplyr
                             r-future
                             r-ggplot2
                             r-magrittr
                             r-matrix
                             r-plyr
                             r-purrr
                             r-rcpp
                             r-rcppparallel
                             r-tgstat
                             r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://tanaylab.github.io/tglkmeans/")
    (synopsis "Efficient implementation of K-Means++ algorithm")
    (description
     "This package provides an efficient implementation of the K-Means++
algorithm.  For more information see (1) \"kmeans++ the advantages of the
k-means++ algorithm\" by David Arthur and Sergei Vassilvitskii (2007),
Proceedings of the eighteenth annual ACM-SIAM symposium on Discrete
algorithms, Society for Industrial and Applied Mathematics, Philadelphia, PA,
USA, pp. 1027-1035, and (2) \"The Effectiveness of Lloyd-Type Methods for the
k-Means Problem\" by Rafail Ostrovsky, Yuval Rabani, Leonard J. Schulman and
Chaitanya Swamy <doi:10.1145/2395116.2395117>.")
    (license license:expat)))

(define-public r-tgp
  (package
    (name "r-tgp")
    (version "2.4-23")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "tgp" version))
              (sha256
               (base32
                "074d2c88ydgmggz24hqkxb8sqvbcgf5d32dhcxwa79snv8br5aqd"))))
    (properties `((upstream-name . "tgp")))
    (build-system r-build-system)
    (propagated-inputs (list r-maptree))
    (home-page "https://bobby.gramacy.com/r_packages/tgp/")
    (synopsis "Bayesian treed Gaussian process models")
    (description
     "R-tgb provides Bayesian nonstationary regression and treed Gaussian
processes.  In addition, it provides visualization functions, tree drawing,
sensitivity analysis, multi-resolution models, and sequential experimental
design tools, including ALM, ALC, and expected improvement for optimizing
noisy black-box functions.")
    (license license:lgpl2.0+)))

(define-public r-tgstat
  (package
    (name "r-tgstat")
    (version "2.3.28")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tgstat" version))
       (sha256
        (base32 "0gn7xpbl7y86n19y8jvw00m03p3aff78yv2g62yp96bi7qygaq2a"))))
    (properties `((upstream-name . "tgstat")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=tgstat")
    (synopsis "Amos Tanay's Group High Performance Statistical Utilities")
    (description
     "This package provides a collection of high-performance utilities.
It can be used to compute distances, correlations, autocorrelations,
clustering, and other tasks.  It also contains a graph clustering
algorithm described in MetaCell analysis of single-cell RNA-seq
data using K-nn graph partitions.")
    (license license:gpl2)))

(define-public r-tictoc
  (package
    (name "r-tictoc")
    (version "1.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "tictoc" version))
              (sha256
               (base32
                "0cw8r1gn4p2v1l3d80brk9sfr9nyckyyym5nr9xq3d74l74vgkcg"))))
    (properties `((upstream-name . "tictoc")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jabiru/tictoc")
    (synopsis
     "Time R scripts and implementations of stack and list structures")
    (description
     "The tictoc package provides the timing functions @code{tic} and
@code{toc} that can be nested.  It provides an alternative to
@code{system.time()} with a different syntax similar to that in another
well-known software package.  @code{tic} and @code{toc} are easy to use, and
are especially useful when timing several sections in more than a few lines of
code.")
    (license license:asl2.0)))

(define-public r-tidyft
  (package
    (name "r-tidyft")
    (version "0.9.20")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "tidyft" version))
              (sha256
               (base32
                "144w36q4yrscdvv3jq7h6s6pklm3l4m5rv005hr1akvn9d7klcq9"))))
    (properties `((upstream-name . "tidyft")))
    (build-system r-build-system)
    (propagated-inputs (list r-data-table r-fst r-stringr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/hope-data-science/tidyft")
    (synopsis "Fast and memory efficient data operations in tidy syntax")
    (description "Tidyft is an extension of @code{data.table}.  It uses
modifification by reference whenever possible.  This toolkit is designed for
big data analysis in high-performance desktop or laptop computers.  The syntax
of the package is similar or identical to tidyverse.")
    (license license:expat)))

(define-public r-tidyverse
  (package
    (name "r-tidyverse")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tidyverse" version))
       (sha256
        (base32
         "1r980y6d4a5brvxwdx41qzi8f3fck36c5l89sd3k4csna09jsg1x"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-cli
           r-conflicted
           r-dbplyr
           r-dplyr
           r-dtplyr
           r-forcats
           r-ggplot2
           r-googledrive
           r-googlesheets4
           r-haven
           r-hms
           r-httr
           r-jsonlite
           r-lubridate
           r-magrittr
           r-modelr
           r-pillar
           r-purrr
           r-ragg
           r-readr
           r-readxl
           r-reprex
           r-rlang
           r-rstudioapi
           r-rvest
           r-stringr
           r-tibble
           r-tidyr
           r-xml2))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://tidyverse.tidyverse.org")
    (synopsis "Install and load packages from the \"Tidyverse\"")
    (description
     "The @code{tidyverse} is a set of packages that work in harmony because
they share common data representations and API design.  This package is
designed to make it easy to install and load multiple tidyverse packages in a
single step.")
    (license license:gpl3)))

(define-public r-tis
  (package
    (name "r-tis")
    (version "1.39")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tis" version))
       (sha256
        (base32 "1sq3acz8mybsbxng5fga4ynqvh1ly9hs3ca727jiyx1gam712mis"))))
    (properties `((upstream-name . "tis")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=tis")
    (synopsis "Time indexes and time indexed series")
    (description
     "This package provides functions and S3 classes for time indexes and time
indexed series, which are compatible with FAME frequencies.")
    ;; Unlimited distribution
    (license (license:non-copyleft "file://DESCRIPTION"))))

(define-public r-tkrplot
  (package
    (name "r-tkrplot")
    (version "0.0-27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tkrplot" version))
       (sha256
        (base32 "19bj4wn1fs4wrx5k4gakhpz4q59fgx0584wyaw7hnh0ljj8i34n9"))))
    (properties `((upstream-name . "tkrplot")))
    (build-system r-build-system)
    (inputs (list libx11))
    (home-page "https://cran.r-project.org/package=tkrplot")
    (synopsis "Place R graphics in a Tk widget")
    (description
     "The tkrplot package lets you place R graphics in a @dfn{Tk,
cross-platform graphical user interface toolkit} widget.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-rvest
  (package
    (name "r-rvest")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rvest" version))
       (sha256
        (base32 "19lw0jk8d8x88z247hz761gwbx9f5n3yqnv63mn7pkwl55mpqw3x"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-glue
           r-httr
           r-lifecycle
           r-magrittr
           r-rlang
           r-selectr
           r-tibble
           r-xml2))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/hadley/rvest")
    (synopsis "Simple web scraping for R")
    (description
     "@code{r-rvest} helps you scrape information from web pages.  It is
designed to work with @code{magrittr} to make it easy to express common web
scraping tasks, inspired by libraries like @code{BeautifulSoup}.")
    (license license:gpl3)))

(define-public r-secretbase
  (package
    (name "r-secretbase")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "secretbase" version))
       (sha256
        (base32 "0bmnbjnwwb7s697f9pjy905x8pj6jmsg4rldgmrzpbhazlzwxbn6"))))
    (properties `((upstream-name . "secretbase")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Needed by tests
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (home-page "https://shikokuchuo.net/secretbase/")
    (synopsis "Cryptographic Hash and Extendable-Output Functions")
    (description
     "This package provides implementations of the SHA-3 cryptographic hash
and SHAKE256 extendable-output functions (XOF).")
    (license license:gpl3+)))

(define-public r-selectr
  (package
    (name "r-selectr")
    (version "0.4-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "selectr" version))
       (sha256
        (base32 "09y1n3iy297g49xlpl7xrjpwgnm57pskx5991lyfcpizbz8ax22m"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-r6 r-stringr))
    (native-inputs (list r-testthat))
    (home-page "https://sjp.co.nz/projects/selectr/")
    (synopsis "Translate CSS selectors to XPath expressions")
    (description
     "@code{r-selectr} translates a CSS3 selector into an equivalent XPath
expression.  This allows you to use CSS selectors when working with the XML
package as it can only evaluate XPath expressions.  Also provided are
convenience functions useful for using CSS selectors on XML nodes.  This
package is a port of the Python package @code{cssselect}.")
    (license license:bsd-3)))

(define-public r-redland
  (package
    (name "r-redland")
    (version "1.0.17-18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "redland" version))
       (sha256
        (base32 "183m1bvgj52w74383b5v6rfm7gn4izijixans1zdycqp68ibm6g9"))))
    (properties `((upstream-name . "redland")))
    (build-system r-build-system)
    (inputs (list redland pcre2 zlib))
    (propagated-inputs (list r-roxygen2))
    (native-inputs (list r-knitr pkg-config r-spelling r-stringi r-testthat))
    (home-page "https://cran.r-project.org/package=redland")
    (synopsis "RDF library bindings in R")
    (description
     "This package provides methods to parse, query and serialize information
stored in the @dfn{Resource Description Framework} (RDF).  This package
supports RDF by implementing an R interface to the Redland RDF C library.  In
brief, RDF provides a structured graph consisting of Statements composed of
Subject, Predicate, and Object Nodes.")
    (license license:asl2.0)))

(define-public r-relations
  (package
    (name "r-relations")
    (version "0.6-14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "relations" version))
       (sha256
        (base32 "176qybc6pl2lvrbqyvy6xwxhan5jdsdrpjly25vqf0bjynsv4kq2"))))
    (properties `((upstream-name . "relations")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster r-sets r-slam))
    (home-page "https://cran.r-project.org/package=relations")
    (synopsis "Data structures and algorithms for relations")
    (description
     "This package provides data structures and algorithms for k-ary relations
with arbitrary domains, featuring relational algebra, predicate functions, and
fitters for consensus relations.")
    (license license:gpl2)))

(define-public r-repmis
  (package
    (name "r-repmis")
    (version "0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "repmis" version))
       (sha256
        (base32 "0z5mjbsl24yjbl0aawr35grcal44rf2xbwv1hy7bdkms94ix79b5"))))
    (properties `((upstream-name . "repmis")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'install 'change-home-dir
           (lambda _
             ;; Change from /homeless-shelter to /tmp for write permission.
             (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-data-table
           r-digest
           r-httr
           r-plyr
           r-r-cache))
    (home-page "https://cran.r-project.org/package=repmis")
    (synopsis "Miscellaneous tools for reproducible research")
    (description
     "This package is a collection of tools to load R packages and
automatically generate BibTeX files citing them as well as load and cache
plain-text and Excel formatted data stored on GitHub, and from other
sources.")
    (license license:gpl3+)))

(define-public r-reprex
  (package
    (name "r-reprex")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reprex" version))
       (sha256
        (base32
         "174705043b90phm6aj5yb199pn1clipsnqgvhskhxybypj63cq68"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr
           r-cli
           r-clipr
           r-fs
           r-glue
           r-knitr
           r-lifecycle
           r-rlang
           r-rmarkdown
           r-rstudioapi
           r-withr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/tidyverse/reprex")
    (synopsis "Prepare reproducible R code examples for sharing")
    (description
     "This package provides a convenience wrapper that uses the
@code{rmarkdown} package to render small snippets of code to target formats
that include both code and output.  The goal is to encourage the sharing of
small, reproducible, and runnable examples on code-oriented websites or email.
@code{reprex} also extracts clean, runnable R code from various common formats,
such as copy/paste from an R session.")
    (license license:expat)))

(define-public r-reordercluster
  (package
   (name "r-reordercluster")
   (version "2.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "ReorderCluster" version))
            (sha256
             (base32
              "0zq143xvv2br7016f9b1501ymcpkjqm3al1dn5qfm21axyi2p1iq"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-gplots r-gtools r-rcpp))
   (home-page "https://cran.r-project.org/web/packages/ReorderCluster")
   (synopsis "Reordering the dendrogram according to the class labels")
   (description "This package provides tools for performing the leaf reordering
for the dendrogram that preserves the hierarchical clustering result and at the
same time tries to group instances from the same class together.")
   (license license:gpl3+)))

(define-public r-caliberrfimpute
  (package
    (name "r-caliberrfimpute")
    (version "1.0-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CALIBERrfimpute" version))
       (sha256
        (base32 "1fspn6wgr0kc7j4ixx24c706kzrgjhi1b1w28izpfxm4r89zk08s"))))
    (properties `((upstream-name . "CALIBERrfimpute")))
    (build-system r-build-system)
    (propagated-inputs (list r-mice r-mvtnorm r-randomforest))
    (home-page "https://cran.r-project.org/package=CALIBERrfimpute")
    (synopsis "Multiple imputation using MICE and random forest")
    (description
     "This package provides functions to impute using random forest.
It operates under full conditional specifications (multivariate
imputation by chained equations).")
    (license license:gpl3)))

(define-public r-callr
  (package
    (name "r-callr")
    (version "3.7.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "callr" version))
       (sha256
        (base32
         "1y2ildc0ni01lkcircbr648f5knq6ch6smh5xap2xr39x1ky7g74"))))
    (properties
     ;; Avoid dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-processx r-r6))
    (home-page "https://github.com/r-lib/callr#readme")
    (synopsis "Call R from R")
    (description
     "It is sometimes useful to perform a computation in a separate R process,
without affecting the current R process at all.  This package does exactly
that.")
    (license license:expat)))

(define-public r-deming
  (package
    (name "r-deming")
    (version "1.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "deming" version))
       (sha256
        (base32 "1jipary7wqb9gmj4mfrz4ym5ir44q2rhknxx6ah1f5lpkcsjm6c6"))))
    (properties `((upstream-name . "deming")))
    (build-system r-build-system)
    (propagated-inputs (list r-boot))
    (home-page "https://cran.r-project.org/package=deming")
    (synopsis
     "Deming, Theil-Sen, Passing-Bablock and Total Least Squares regression")
    (description
     "This package implements generalized Deming regression, Theil-Sen
regression and Passing-Bablock regression functions.")
    (license license:lgpl2.0+)))

(define-public r-deoptim
  (package
    (name "r-deoptim")
    (version "2.2-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DEoptim" version))
       (sha256
        (base32 "0k7mvf7j8y1sqv8zpiwkw4xcmgki37drkxjijrsmmhkfybfan7k3"))))
    (properties `((upstream-name . "DEoptim")))
    (build-system r-build-system)
    (propagated-inputs (list r-parallelly))
    (home-page "https://github.com/ArdiaD/DEoptim")
    (synopsis "Global optimization by differential evolution")
    (description
     "This package implements the Differential Evolution algorithm.
This algorithm is used for the global optimization of a real-valued function
of a real-valued parameter vector.  The implementation of
@code{DifferentialEvolution} in DEoptim interfaces with C code for
efficiency.")
    (license license:gpl2+)))

(define-public r-depmixs4
  (package
    (name "r-depmixs4")
    (version "1.5-0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "depmixS4" version))
              (sha256
               (base32
                "1pacvhw5m4fsk3ysbal50fdqbvlaz8ywyqp6bn1wh42wipqbb2i8"))))
    (propagated-inputs
     (list r-mass r-nlme r-nnet r-rsolnp))
    (native-inputs (list r-gamlss))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/depmixS4/")
    (synopsis "Dependent Mixture Models")
    (description "This package fits latent (hidden) Markov models on mixed
categorical and continuous (time series) data, otherwise known as dependent
mixture models.")
    (license license:gpl2+)))

(define-public r-detectseparation
  (package
    (name "r-detectseparation")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "detectseparation" version))
       (sha256
        (base32 "05z3p1z5mhmdj5qdknz1b8f6fwbghzckl88pv79v59cfwpbvgmz8"))))
    (properties `((upstream-name . "detectseparation")))
    (build-system r-build-system)
    (propagated-inputs (list r-lpsolveapi r-pkgload r-roi r-roi-plugin-lpsolve))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/ikosmidis/detectseparation")
    (synopsis
     "Detect and check for separation and infinite maximum likelihood estimates")
    (description
     "This package provides pre-fit and post-fit methods for detecting separation
and infinite maximum likelihood estimates in generalized linear models with
categorical responses.  The pre-fit methods apply on binomial-response generalized
liner models such as logit, probit and cloglog regression, and can be directly
supplied as fitting methods to the @code{glm()} function.  The post-fit methods
apply to models with categorical responses, including binomial-response
generalized linear models and multinomial-response models, such as baseline
category logits and adjacent category logits models; for example, the models
implemented in the brglm2 package.  The post-fit methods successively refit the
model with increasing number of iteratively reweighted least squares iterations,
and monitor the ratio of the estimated standard error for each parameter to what
it has been in the first iteration.")
    (license license:gpl3)))

(define-public r-readxl
  (package
    (name "r-readxl")
    (version "1.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "readxl" version))
       (sha256
        (base32
         "0j2rkb012h0kvcm8n3817lgfir52dvmkwaxn7mij71gbxz6vpzky"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cellranger r-cpp11 r-progress r-tibble))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://readxl.tidyverse.org")
    (synopsis "Read Excel files")
    (description
     "This package lets you import Excel files into R.  It supports
@file{.xls} via the embedded @code{libxls} C library and @file{.xlsx} via
the embedded @code{RapidXML} C++ library.")
    ;; XXX: This package bundles a copy of 'libxsl' which is BSD-2 and
    ;; 'rapidxml' which is Boost.
    (license (list license:gpl3 license:bsd-2 license:boost1.0))))

(define-public r-rearrr
  (package
    (name "r-rearrr")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rearrr" version))
       (sha256
        (base32 "1inx1gikiqxaf6a8g10b02l1qs2y0zxs2yrxn6dyx9n6xlra3rnr"))))
    (properties `((upstream-name . "rearrr")))
    (build-system r-build-system)
    (propagated-inputs (list r-checkmate
                             r-dplyr
                             r-lifecycle
                             r-plyr
                             r-purrr
                             r-r6
                             r-rlang
                             r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/ludvigolsen/rearrr")
    (synopsis "Rearranging data by a set of methods")
    (description
     "This package arranges data by a set of methods.  It uses rearrangers to
reorder data points and mutators to change their values.  From basic utilities,
to centering the greatest value, to swirling in 3-dimensional space, rearrr
enables creativity when plotting and experimenting with data.")
    (license license:expat)))

(define-public r-model4you
  (package
    (name "r-model4you")
    (version "0.9-8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "model4you" version))
              (sha256
               (base32
                "17xa2lvbsbwsyy54nna99xxwjv04p7xgqa61jz1ivggq0fgrd9fg"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-formula
           r-ggplot2
           r-gridextra
           r-partykit
           r-sandwich
           r-survival))
    (native-inputs
     (list r-plyr r-psychotools r-strucchange r-th-data))
    (home-page "https://cran.r-project.org/web/packages/model4you/")
    (synopsis "Stratified and personalised models based on trees and forests")
    (description
     "This package provides procedures for model-based trees for subgroup
analyses in clinical trials and model-based forests for the estimation and
prediction of personalised treatment effects.  Currently partitioning of linear
models, @code{lm()}, generalised linear models, @code{glm()}, and
Weibull models, @code{survreg()}, are supported.  Advanced plotting functionality is
supported for the trees and a test for parameter heterogeneity is provided for
the personalised models.")
    (license license:gpl2+)))

(define-public r-modelenv
  (package
    (name "r-modelenv")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "modelenv" version))
              (sha256
               (base32
                "1h8vksmvdj5nv6cswr0c21fh1jcryw1lvpq9pn0n771pxybhxqbl"))))
    (properties `((upstream-name . "modelenv")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli r-glue r-rlang r-tibble r-vctrs))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/tidymodels/modelenv")
    (synopsis "Tools for registering models for use in tidymodels")
    (description
     "This is a developer-focused, low dependency package in
@code{tidymodels} that provides functions to register how models are
to be used.  Functions to register models are complimented with
accessor functions to retrieve registered model information to aid in
model fitting and error handling.")
    (license license:expat)))

(define-public r-modelr
  (package
    (name "r-modelr")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "modelr" version))
       (sha256
        (base32
         "1lvv6gac3g4x1d58chbvlxlkd77qz21a3rlb64jvzwycx43dbswl"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-magrittr
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect
           r-vctrs))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/tidyverse/modelr")
    (synopsis "Helper functions for modelling in pipelines")
    (description
     "Functions for modelling that help you seamlessly integrate modelling
into a pipeline of data manipulation and visualisation.")
    (license license:gpl3)))

(define-public r-mondate
  (package
    (name "r-mondate")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mondate" version))
       (sha256
        (base32 "1spz3xv450mw0i984hjp6r4lk653nmjawf9cipv9z7isc4zv3ac3"))))
    (properties `((upstream-name . "mondate")))
    (build-system r-build-system)
    (home-page "https://www.r-project.org")
    (synopsis "Keep track of dates in terms of months")
    (description
     "Keep track of dates in terms of fractional calendar months per Damien
Laker \"Time Calculations for Annualizing Returns: the Need for
Standardization\", The Journal of Performance Measurement, 2008.  Model dates
as of close of business.  Perform date arithmetic in units of \"months\" and
\"years\".  Allow \"infinite\" dates to model \"ultimate\" time.")
    (license license:mpl2.0)))

(define-public r-morpho
  (package
    (name "r-morpho")
    (version "2.12")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "Morpho" version))
              (sha256
               (base32
                "1hg1jr0y11v93mqg2kn8n841nbsiffhyyr2kswj7kk664vlpril0"))))
    (properties `((upstream-name . "Morpho")))
    (build-system r-build-system)
    (propagated-inputs (list r-bezier
                             r-colorramps
                             r-doparallel
                             r-foreach
                             r-jsonlite
                             r-mass
                             r-matrix
                             r-rcpp
                             r-rcpparmadillo
                             r-rgl
                             r-rvcg
                             r-sf))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/zarquon42b/Morpho")
    (synopsis
     "Calculations and visualizations related to geometric morphometrics")
    (description
     "This package provides a toolset for Geometric Morphometrics and mesh
processing.  This includes (among other stuff) mesh deformations based on
reference points, permutation tests, detection of outliers, processing of
sliding semi-landmarks and semi-automated surface landmark placement.")
    (license license:gpl2)))

(define-public r-hgnchelper
  (package
    (name "r-hgnchelper")
    (version "0.8.14")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "HGNChelper" version))
              (sha256
               (base32
                "0rhqpzq6z57wzydwcz0ry61al68l3mll79s5hz8by7hy61izj5k5"))))
    (properties `((upstream-name . "HGNChelper")))
    (build-system r-build-system)
    (propagated-inputs (list r-splitstackshape))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/waldronlab/HGNChelper")
    (synopsis
     "Identification and correction of invalid gene symbols for human and mouse")
    (description
     "This package provides a set of R functions for identifying and
correcting HGNC human gene symbols.  In addition, you can identify MGI mouse
gene symbols, which have been converted to date format by Excel, withdrawn, or
aliased.  It also contains functions for reversibly converting between HGNC
symbols and valid R names.")
    (license license:gpl2+)))

(define-public r-hmm
  (package
    (name "r-hmm")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "HMM" version))
              (sha256
               (base32
                "03b548bnwqpnd7zypb4gvy9chyi5li2hp99a9vrh4qszxg2ihas7"))))
    (properties `((upstream-name . "HMM")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/HMM/")
    (synopsis "Hidden Markov Models")
    (description "This package provides an easy to use library to setup, apply
and make inference with discrete time and discrete space hidden Markov
models.")
    (license license:gpl2+)))

(define-public r-hiddenmarkov
  (package
   (name "r-hiddenmarkov")
   (version "1.8-13")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "HiddenMarkov" version))
            (sha256
             (base32
              "05dm3nl0ffsz2ziw3bz5bivyxk7r5bxs8xhky3hz660qaqzd51ki"))))
   (build-system r-build-system)
   (native-inputs
    (list gfortran))
   (home-page "https://cran.r-project.org/web/packages/HiddenMarkov/")
   (synopsis "Hidden markov models for R")
   (description "This package contains functions for the analysis of Discrete
Time Hidden Markov Models, Markov Modulated GLMs and the Markov Modulated
Poisson Process.  It includes functions for simulation, parameter estimation,
and the Viterbi algorithm.  The algorithms are based of those of Walter
Zucchini.")
   (license license:gpl2+)))

(define-public r-hsaur3
  (package
    (name "r-hsaur3")
    (version "1.0-15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "HSAUR3" version))
       (sha256
        (base32 "17yg6ql9c88pg5higmrvhnavx6hcbr4nm5r65d8q3iqfkgnc6ym1"))))
    (properties `((upstream-name . "HSAUR3")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=HSAUR3")
    (synopsis "Handbook of Statistical Analyses Using R (3rd Edition)")
    (description
     "This package provides functions, data sets, analyses and examples from
the third edition of the book A Handbook of Statistical Analyses Using
R (Torsten Hothorn and Brian S. Everitt, Chapman & Hall/CRC, 2014).  The first
chapter of the book, which is entitled An Introduction to R, is completely
included in this package, for all other chapters, a vignette containing all
data analyses is available.  In addition, Sweave source code for slides of
selected chapters is included in this package.")
    (license license:gpl2)))

(define-public r-httptest
  (package
    (name "r-httptest")
    (version "4.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "httptest" version))
       (sha256
        (base32 "0c370jxkd9dzqg5pdf2mcv2kjzr9zp9qai9riivjgygj6jhlcjav"))))
    (properties `((upstream-name . "httptest")))
    (build-system r-build-system)
    (propagated-inputs (list r-curl r-digest r-httr r-jsonlite r-testthat))
    (native-inputs (list r-knitr r-spelling r-testthat))
    (home-page "https://enpiar.com/r/httptest/")
    (synopsis "Test environment for HTTP requests")
    (description
     "Testing and documenting code that communicates with remote servers can
be painful.  Dealing with authentication, server state, and other
complications can make testing seem too costly to bother with.  But it doesn't
need to be that hard.  This package enables one to test all of the logic on
the R sides of the API in your package without requiring access to the remote
service.  Importantly, it provides three contexts that mock the network
connection in different ways, as well as testing functions to assert that HTTP
requests were---or were not---made.  It also allows one to safely record real
API responses to use as test fixtures.  The ability to save responses and load
them offline also enables one to write vignettes and other dynamic documents
that can be distributed without access to a live server.")
    (license license:expat)))

(define-public r-httptest2
  (package
    (name "r-httptest2")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "httptest2" version))
       (sha256
        (base32 "0vj6ynxc2xdq4xhl6df8aa3582s7jf5m71hxqxhjsjfqdzm72dv8"))))
    (properties `((upstream-name . "httptest2")))
    (build-system r-build-system)
    (propagated-inputs (list r-digest r-httr2 r-jsonlite r-rlang r-testthat))
    (native-inputs (list r-knitr r-spelling r-webfakes))
    (home-page "https://enpiar.com/httptest2/")
    (synopsis "Test Helpers for 'httr2'")
    (description
     "Testing and documenting code that communicates with remote servers can
be painful.  This package helps with writing tests for packages that use
@code{httr2}.  It enables testing all of the logic on the R sides of the API
without requiring access to the remote service, and it also allows recording
real API responses to use as test fixtures.  The ability to save responses and
load them offline also enables writing vignettes and other dynamic documents
that can be distributed without access to a live server.")
    (license license:expat)))

(define-public r-httpuv
  (package
    (name "r-httpuv")
    (version "1.6.15")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "httpuv" version))
              (sha256
               (base32
                "1l2y435i3dvq7fnalpvc7h5wh0sc5clygdvcvghz77d34cvfsvay"))
              (modules '((guix build utils)))
              ;; Cannot unbundle http-parser, because it contains local
              ;; modifications.
              (snippet
               '(delete-file-recursively "src/libuv"))))
    (build-system r-build-system)
    (inputs
     (list libuv-for-r-httpuv zlib))
    (propagated-inputs
     (list r-later r-promises r-r6 r-rcpp))
    (native-inputs (list pkg-config r-curl r-testthat))
    (home-page "https://github.com/rstudio/httpuv")
    (synopsis "HTTP and WebSocket server library for R")
    (description
     "The httpuv package provides low-level socket and protocol support for
handling HTTP and WebSocket requests directly from within R.  It is primarily
intended as a building block for other packages, rather than making it
particularly easy to create complete web applications using httpuv alone.")
    ;; This package includes third-party code that was originally released
    ;; under various non-copyleft licenses.  Full licensing information can be
    ;; obtained here: https://github.com/rstudio/httpuv/blob/master/LICENSE
    (license license:gpl3+)))

(define-public r-httr2
  (package
    (name "r-httr2")
    (version "1.0.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "httr2" version))
              (sha256
               (base32
                "1idna48j0z75ybdgb6b22wgfa1c8n8q2lw4ywgg959hviykbc3gh"))))
    (properties `((upstream-name . "httr2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-curl
           r-glue
           r-lifecycle
           r-magrittr
           r-openssl
           r-r6
           r-rappdirs
           r-rlang
           r-vctrs
           r-withr))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://httr2.r-lib.org")
    (synopsis "Perform HTTP requests and process the responses")
    (description
     "This package provides tools for creating and modifying HTTP requests,
then performing them and processing the results.  @code{httr2} is a
re-imagining of @code{httr} that uses a pipe-based interface and solves more
of the problems that API wrapping packages face.")
    (license license:expat)))

(define-public r-jade
  (package
    (name "r-jade")
    (version "2.0-4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "JADE" version))
              (sha256
               (base32
                "0m90rnhr5vkdv1xswr5c0j06ngzvmg73nd0kmg9m9r6a6ddddcyl"))))
    (properties `((upstream-name . "JADE")))
    (build-system r-build-system)
    (propagated-inputs (list r-clue))
    (home-page "https://cran.r-project.org/package=JADE")
    (synopsis "Blind source separation methods")
    (description
     "In this package Cardoso's JADE algorithm as well as his functions for
joint diagonalization are ported to R.  Also several other @dfn{blind source
separation} (BSS) methods, like AMUSE and SOBI, and some criteria for
performance evaluation of BSS algorithms, are given.  The package is described
in Miettinen, Nordhausen and Taskinen (2017) <doi:10.18637/jss.v076.i02>.")
    (license license:gpl2+)))

(define-public r-job
  (package
    (name "r-job")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "job" version))
       (sha256
        (base32 "14i0ljq2wp9k8112fr27sz0bc0zi2a68kls8vw5h3qa5n40v27cc"))))
    (properties `((upstream-name . "job")))
    (build-system r-build-system)
    (propagated-inputs (list r-digest r-rstudioapi))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=job")
    (synopsis "Run code as an RStudio job")
    (description
     "Call @code{job::job({<code here>})} to run R code as an RStudio job and
keep your console free in the meantime.  This allows for a productive workflow
while testing (multiple) long-running chunks of code.  It can also be used to
organize results using the RStudio Jobs GUI or to test code in a clean
environment.  Two RStudio Addins can be used to run selected code as a job.")
    (license license:expat)))

(define-public r-jsonify
  (package
    (name "r-jsonify")
    (version "1.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "jsonify" version))
              (sha256
               (base32
                "0bxgyj5b1hnijq5315g050giixy4k5mjz2zdx8yil0igb5ifji9p"))))
    (properties `((upstream-name . "jsonify")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for tests.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs (list r-rapidjsonr r-rcpp))
    (native-inputs (list r-knitr r-testthat tzdata-for-tests))
    (home-page "https://cran.r-project.org/package=jsonify")
    (synopsis
     "Convert between R objects and JavaScript Object Notation (JSON)")
    (description
     "This package enables conversions between R objects and JavaScript Object
Notation (JSON) using the rapidjsonr library.")
    (license license:expat)))

(define-public r-jsonlite
  (package
    (name "r-jsonlite")
    (version "1.8.9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "jsonlite" version))
              (sha256
               (base32
                "1c4hdsdcn8iphd901nk7lv8g7sxm29vlxmgc3p02hcqnw7h31wc9"))))
    (build-system r-build-system)
    ;; Tests depend on r-testthat, which depends indirectly on r-jsonlite.
    (arguments (list #:tests? #false))
    (native-inputs
     (list r-knitr r-r-rsp))
    (home-page "https://arxiv.org/abs/1403.2805")
    (synopsis "Robust, high performance JSON parser and generator for R")
    (description
     "The jsonlite package provides a fast JSON parser and generator optimized
for statistical data and the web.  It offers flexible, robust, high
performance tools for working with JSON in R and is particularly powerful for
building pipelines and interacting with a web API.  In addition to converting
JSON data from/to R objects, jsonlite contains functions to stream, validate,
and prettify JSON data.  The unit tests included with the package verify that
all edge cases are encoded and decoded consistently for use with dynamic data
in systems and applications.")
    (license license:expat)))

(define-public r-jsonvalidate
  (package
    (name "r-jsonvalidate")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jsonvalidate" version))
       (sha256
        (base32 "0myvm93azl6mj60l8fp91qa3ln3nnwj4p48xli8k215sm6zhhv1b"))))
    (properties `((upstream-name . "jsonvalidate")))
    (build-system r-build-system)
    (propagated-inputs (list r-v8))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/jsonvalidate/")
    (synopsis "Validate JSON schema")
    (description
     "This package uses the node library @code{is-my-json-valid} or @code{ajv}
to validate JSON against a JSON schema.  Drafts 04, 06 and 07 of JSON schema
are supported.")
    (license license:expat)))

(define-public r-servr
  (package
    (name "r-servr")
    (version "0.32")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "servr" version))
              (sha256
               (base32
                "19ixy27b87z99s1crqnmxm7vqzz4zsxpjgpy4101dic7628wlak7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httpuv r-jsonlite r-mime r-xfun))
    (home-page "https://github.com/yihui/servr")
    (synopsis "Simple HTTP server to serve static files or dynamic documents")
    (description
     "Servr provides an HTTP server in R to serve static files, or dynamic
documents that can be converted to HTML files (e.g., R Markdown) under a given
directory.")
    (license license:expat)))

(define-public r-howmany
  (package
    (name "r-howmany")
    (version "0.3-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "howmany" version))
              (sha256
               (base32
                "045ck8qahfg2swbgyf7dpl32ryq1m4sbalhr7m5qdgpm62vz8h7f"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/howmany/")
    (synopsis "Lower bound for the number of correct rejections")
    (description "When testing multiple hypotheses simultaneously, this package
provides functionality to calculate a lower bound for the number of correct
rejections (as a function of the number of rejected hypotheses), which holds
simultaneously -with high probability- for all possible number of rejections.
As a special case, a lower bound for the total number of false null hypotheses
can be inferred.  Dependent test statistics can be handled for multiple tests
of associations.  For independent test statistics, it is sufficient to provide
a list of p-values.")
    (license license:gpl2+)))

(define-public r-htmltools
  (package
    (name "r-htmltools")
    (version "0.5.8.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "htmltools" version))
              (sha256
               (base32
                "0xpi2g87vwanp0kbs22j90pa2bban3nwrdjdb3257hq6xj9j5xpr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc r-digest r-fastmap r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/htmltools")
    (synopsis "R tools for HTML")
    (description
     "This package provides tools for HTML generation and output in R.")
    (license license:expat)))

(define-public r-htmlwidgets
  (package
    (name "r-htmlwidgets")
    (version "1.6.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "htmlwidgets" version))
              (sha256
               (base32
                "1l0f7bz2icixsrgg5fg8k09mv0nq9vn5ch1fywkaqpa8605qzc3w"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools r-jsonlite
           r-knitr r-rmarkdown
           r-yaml))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/ramnathv/htmlwidgets")
    (synopsis "HTML Widgets for R")
    (description
     "HTML widgets is a framework for creating HTML widgets that render in
various contexts including the R console, R Markdown documents, and Shiny web
applications.")
    (license license:expat)))

(define-public r-htmltable
  (package
    (name "r-htmltable")
    (version "2.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "htmlTable" version))
       (sha256
        (base32 "1pgndsyml68d9qd747043m9g0dxhaa10m533dchcsg1izwdx0f9p"))))
    (properties `((upstream-name . "htmlTable")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'replace-bundled-minified-JavaScript
            (lambda* (#:key inputs #:allow-other-keys)
              (minify (assoc-ref inputs "js-jquery")
                      #:target
                      "inst/htmlwidgets/lib/jquery/jquery.min.js"))))))
    (propagated-inputs
     (list r-checkmate
           r-htmltools
           r-htmlwidgets
           r-knitr
           r-magrittr
           r-rstudioapi
           r-stringr))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-3.7.1.js")
           (sha256
            (base32
             "1zicjv44sx6n83vrkd2lwnlbf7qakzh3gcfjw0lhq48b5z55ma3q"))))
       ("r-dplyr" ,r-dplyr)
       ("r-knitr" ,r-knitr)
       ("r-purrr" ,r-purrr)
       ("r-testthat" ,r-testthat)
       ("r-xml" ,r-xml)
       ("r-xml2" ,r-xml2)))
    (home-page "http://gforge.se/packages/")
    (synopsis "Advanced tables for Markdown/HTML")
    (description
     "This package provides functions to build tables with advanced layout
elements such as row spanners, column spanners, table spanners, zebra
striping, and more.  While allowing advanced layout, the underlying
CSS-structure is simple in order to maximize compatibility with word
processors such as LibreOffice.  The package also contains a few text
formatting functions that help outputting text compatible with HTML or
LaTeX.")
    (license license:gpl3+)))

(define-public r-curl
  (package
    (name "r-curl")
    (version "6.0.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "curl" version))
              (sha256
               (base32
                "0qi3skrkdr43siiw28fmwdkjfqy3ynql5r94nlm9fpvlsyz90744"))))
    (properties
     `((upstream-name . "curl")
       (updater-extra-inputs . ("curl"))))
    (build-system r-build-system)
    (inputs
     (list curl zlib))
    (native-inputs
     (list pkg-config r-knitr r-testthat))
    (home-page "https://github.com/jeroenooms/curl")
    (synopsis "HTTP client for R")
    (description
     "The @code{curl()} and @code{curl_download()} functions provide highly
configurable drop-in replacements for base @code{url()} and
@code{download.file()} with better performance, support for encryption, gzip
compression, authentication, and other @code{libcurl} goodies.  The core of
the package implements a framework for performing fully customized requests
where data can be processed either in memory, on disk, or streaming via the
callback or connection interfaces.")
    (license license:expat)))

(define-public r-hwriter
  (package
    (name "r-hwriter")
    (version "1.3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hwriter" version))
       (sha256
        (base32
         "1wxnv8h9cs65m3z01dpnnkgn2cpwfsck70g1jz9nbkr7mdaa4bzd"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/hwriter")
    (synopsis "Output R objects in HTML format")
    (description
     "This package provides easy-to-use and versatile functions to output R
objects in HTML format.")
    (license license:lgpl2.1+)))

(define-public r-rjson
  (package
    (name "r-rjson")
    (version "0.2.23")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rjson" version))
       (sha256
        (base32
         "0j0gbwd4cn1f7fb6ml14jr3m38ny1y62gnh1cxz6bvalr1sla0sm"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rjson")
    (synopsis "JSON library for R")
    (description
     "This package provides functions to convert R objects into JSON objects
and vice-versa.")
    (license license:gpl2+)))

(define-public r-fastdummies
  (package
    (name "r-fastdummies")
    (version "1.7.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "fastDummies" version))
              (sha256
               (base32
                "026xc1wrzgwyhs1h1bdn7yy56mnpr5rr9bkwljpzmhzgcx5lv44m"))))
    (properties `((upstream-name . "fastDummies")))
    (build-system r-build-system)
    (propagated-inputs (list r-data-table r-stringr r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/jacobkap/fastDummies")
    (synopsis "Create dummy columns and rows from categorical variables")
    (description
     "This package creates dummy columns from columns that have categorical
variables (character or factor types).  You can also specify which columns to
make dummies out of, or which columns to ignore.  Also creates dummy rows from
character, factor, and Date columns.  This package provides a significant
speed increase from creating dummy variables through @code{model.matrix()}.")
    (license license:expat)))

(define-public r-fastmap
  (package
    (name "r-fastmap")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastmap" version))
       (sha256
        (base32
         "0ilj7gcbnha6l61sqzk6wrj6l08mxyay49957izha7axj6i09nmi"))))
    (properties `((upstream-name . "fastmap")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://r-lib.github.io/fastmap/")
    (synopsis "Fast implementation of a key-value store")
    (description
     "This package provides a fast implementation of a key-value store.
Environments are commonly used as key-value stores, but every time a new key
is used, it is added to R's global symbol table, causing a small amount of
memory leakage.  This can be problematic in cases where many different keys
are used.  Fastmap avoids this memory leak issue by implementing the map using
data structures in C++.")
    (license license:expat)))

(define-public r-fastglm
  (package
    (name "r-fastglm")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastglm" version))
       (sha256
        (base32 "0283kgk81cxbii7ljmp1rzqg5mzkvf7cj7lflhhhkgj5ljqina2i"))))
    (properties `((upstream-name . "fastglm")))
    (build-system r-build-system)
    (propagated-inputs (list r-bh r-bigmemory r-rcpp r-rcppeigen))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=fastglm")
    (synopsis
     "Fast and stable fitting of generalized linear models using 'RcppEigen'")
    (description
     "This package fits generalized linear models efficiently using @code{RcppEigen}'.
The iteratively reweighted least squares implementation utilizes the
step-halving approach of Marschner to help safeguard against convergence
issues.")
    (license license:gpl2+)))

(define-public r-fastghquad
  (package
    (name "r-fastghquad")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastGHQuad" version))
       (sha256
        (base32
         "1zj7nsbnx4g253m3dpz9vi3zk3jxwrixwjw1ks6n4shpb4dlkp2w"))))
    (properties `((upstream-name . "fastGHQuad")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://github.com/awblocker/fastGHQuad")
    (synopsis "Fast Rcpp implementation of Gauss-Hermite Quadrature")
    (description
     "This package implements numerically-stable Gauss-Hermite quadrature
rules and utility functions for adaptive GH quadrature.")
    (license license:expat)))

(define-public r-rstpm2
  (package
    (name "r-rstpm2")
    (version "1.6.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rstpm2" version))
       (sha256
        (base32
         "05d7f1q6k25m6hiv9mwndfy4m2s1b6z19xjay2070hy22jmg6rya"))))
    (properties `((upstream-name . "rstpm2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bbmle
           r-bh
           r-fastghquad
           r-mgcv
           r-mvtnorm
           r-rcpp
           r-rcpparmadillo
           r-survival))
    (native-inputs
     (list gfortran r-ggplot2 r-testthat))
    (home-page "https://github.com/mclements/rstpm2")
    (synopsis "Link-based survival models")
    (description
     "This package provides R implementations of @dfn{generalized survival
models} (GSMs), smooth @dfn{accelerated failure time} (AFT) models and Markov
multi-state models.")
    ;; One of these licenses
    (license (list license:gpl2 license:gpl3))))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-jquerylib
  (package
    (name "r-jquerylib")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jquerylib" version))
       (sha256
        (base32
         "04a40v4znpj98j7y6009d74a6g9dchj5rr3p08cgz9p3rlfw3g7h"))
       (snippet
        '(for-each delete-file
                   '("inst/lib/1.12.4/jquery-1.12.4.min.js"
                     "inst/lib/2.2.4/jquery-2.2.4.min.js"
                     "inst/lib/3.6.0/jquery-3.6.0.min.js")))))
    (properties `((upstream-name . "jquerylib")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/lib/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `(("1.12.4/jquery-1.12.4.js"
                         "1.12.4/jquery-1.12.4.min.js")
                        ("2.2.4/jquery-2.2.4.js"
                         "2.2.4/jquery-2.2.4.min.js")
                        ("3.6.0/jquery-3.6.0.js"
                         "3.6.0/jquery-3.6.0.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-htmltools))
    (native-inputs
     (list esbuild r-testthat))
    (home-page "https://cran.r-project.org/package=jquerylib")
    (synopsis "Obtain jQuery as an HTML dependency object")
    (description
     "Obtain any major version of jQuery and use it in any webpage generated
by htmltools (e.g. shiny, htmlwidgets, and rmarkdown).  Most R users don't
need to use this package directly, but other R packages (e.g. shiny,
rmarkdown, etc.) depend on this package to avoid bundling redundant copies of
jQuery.")
    (license license:expat)))

(define-public r-jqr
  (package
    (name "r-jqr")
    (version "1.3.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "jqr" version))
              (sha256
               (base32
                "1pcvn2yhgvs3jldy54lrqfnjbj2yss2zylny0gddqvvngzv6cqi2"))))
    (properties
     `((upstream-name . "jqr")
       (updater-extra-inputs . ("jq"))))
    (build-system r-build-system)
    (inputs (list jq))
    (propagated-inputs (list r-lazyeval r-magrittr))
    (native-inputs (list pkg-config r-testthat))
    (home-page "https://docs.ropensci.org/jqr/")
    (synopsis "R client for jq, a JSON Processor")
    (description
     "This package provides an R client for @command{jq}, a JSON processor.
@command{jq} allows the following with JSON data: index into, parse, do
calculations, cut up and filter, change key names and values, perform
conditionals and comparisons, and more.")
    (license license:expat)))

(define-public r-safetensors
  (package
    (name "r-safetensors")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "safetensors" version))
       (sha256
        (base32 "0xvg5y2sd7gzcal0qqgxbx8vcvmy50jm0j2ajr8iw3wyy5qpyvkp"))))
    (properties `((upstream-name . "safetensors")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli r-jsonlite r-r6 r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/mlverse/safetensors")
    (synopsis "Safetensors file format")
    (description
     "This package provides a file format for storing tensors that is
secure (doesn't allow for code execution), fast and simple to implement.
@code{safetensors} also enables cross language and cross frameworks
compatibility making it an ideal format for storing machine learning model
weights.")
    (license license:expat)))

(define-public r-sass
  (package
    (name "r-sass")
    (version "0.4.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sass" version))
       (sha256
        (base32
         "1lnl2xssz33vg7p6a8ij55hg6j1p1d3y2mq22pvf0r3rmnd08cz1"))))
    (properties `((upstream-name . "sass")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; One test fails when the current locale is the C locale.
         (add-before 'check 'set-test-locale
           (lambda _ (setenv "LC_ALL" "en_US.UTF-8"))))))
    (propagated-inputs
     (list r-fs r-htmltools r-r6 r-rappdirs r-rlang))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/rstudio/sass")
    (synopsis "Syntactically Awesome Style Sheets (SASS)")
    (description
     "This package provides an SCSS compiler, powered by the libsass library.
With this, R developers can use variables, inheritance, and functions to
generate dynamic style sheets.  The package uses the Sass CSS extension
language, which is stable, powerful, and CSS compatible.")
    (license license:expat)))

(define-public r-saver
  (package
    (name "r-saver")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "SAVER" version))
              (sha256
               (base32
                "1s1kw8idkaj7j90fw4qn9k0wd4vz0sblsk06ry6lm4afcar0p158"))))
    (properties `((upstream-name . "SAVER")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-doparallel
           r-foreach
           r-glmnet
           r-iterators
           r-matrix))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/mohuangx/SAVER")
    (synopsis
     "Recovery of gene expression profile in noisy and sparse scRNA-seq data")
    (description
     "This package is an implementation of a regularized regression prediction
and empirical Bayes method to recover the true gene expression profile in noisy
and sparse single-cell RNA-seq data.  In @dfn{single-cell RNA sequencing}
(scRNA-seq) studies, only a small fraction of the transcripts present in each
cell are sequenced.  This leads to unreliable quantification of genes with low
or moderate expression, which hinders downstream analysis.  This package
@dfn{single-cell analysis via expression recovery} (SAVER) implements an
expression recovery method for unique molecule index (UMI)-based scRNA-seq
data that borrows information across genes and cells to provide accurate
expression estimates for all genes.")
    (license license:gpl2)))

(define-public r-bsicons
  (package
    (name "r-bsicons")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bsicons" version))
       (sha256
        (base32 "1ifxb6qvm5m824n924pwa3f2ck33mzzbjq77jzdl36ikx4z0x47a"))))
    (properties `((upstream-name . "bsicons")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli r-htmltools r-rlang))
    (native-inputs (list r-bslib r-testthat))
    (home-page "https://github.com/rstudio/bsicons")
    (synopsis "Easily work with Bootstrap icons")
    (description
     "This package lets you easily use Bootstrap icons inside Shiny apps and R
Markdown documents.  More generally, icons can be inserted in any
@code{htmltools} document through inline SVG.")
    (license license:expat)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-bslib
  (package
    (name "r-bslib")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bslib" version))
       (sha256
        (base32
         "00sbskl5f4mif2x54h5z3m2kv8ij2wv84a61n39931hj3gdjs67x"))
       (snippet
        '(for-each delete-file
                   '("inst/components/dist/components.min.js"
                     "inst/components/dist/web-components.min.js"
                     "inst/lib/bs-a11y-p/plugins/js/bootstrap-accessibility.min.js"
                     "inst/lib/bs3/assets/javascripts/bootstrap.min.js"
                     "inst/lib/bs4/dist/js/bootstrap.bundle.min.js"
                     "inst/lib/bs5/dist/js/bootstrap.bundle.min.js")))))
    (properties `((upstream-name . "bslib")))
    (build-system r-build-system)
    (arguments
     (list
      ;; Some tests require shiny, leading to a dependency cycle.
      #:tests? #false
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'process-javascript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "inst/"
                (for-each (match-lambda
                            ((source . target)
                             (minify source #:target target)))
                          `(("components/dist/components.js"
                             . "components/dist/components.min.js")
                            ("components/dist/web-components.js"
                             . "components/dist/web-components.min.js")
                            ("lib/bs-a11y-p/plugins/js/bootstrap-accessibility.js"
                             . "lib/bs-a11y-p/plugins/js/bootstrap-accessibility.min.js")
                            ("lib/bs3/assets/javascripts/bootstrap.js"
                             . "lib/bs3/assets/javascripts/bootstrap.min.js")
                            (,(assoc-ref inputs "js-bootstrap4-bundle")
                             . "lib/bs4/dist/js/bootstrap.bundle.min.js")
                            (,(assoc-ref inputs "js-bootstrap5-bundle")
                             . "lib/bs5/dist/js/bootstrap.bundle.min.js")))))))))
    (propagated-inputs
     (list r-base64enc
           r-cachem
           r-fastmap
           r-htmltools
           r-jquerylib
           r-jsonlite
           r-lifecycle
           r-memoise
           r-mime
           r-rlang
           r-sass))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-bootstrap4-bundle"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/v4.6.0/dist/js/bootstrap.bundle.js")
           (sha256
            (base32
             "04abvgp923w36qfqkkl2syim3bl119nwxbgials90z1jyb8jgss1"))))
       ("js-bootstrap5-bundle"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/v5.3.1/dist/js/bootstrap.bundle.js")
           (sha256
            (base32
             "1bp0a2fin80hwxvd260r1jk57snsgz74vahid64yb2sgj0rlmj8a"))))))
    (home-page "https://rstudio.github.io/bslib/")
    (synopsis "Custom Bootstrap Sass themes for shiny and rmarkdown")
    (description
     "This package simplifies custom CSS styling of both shiny and rmarkdown
via Bootstrap Sass.  It supports both Bootstrap 3 and 4 as well as their
various Bootswatch themes.  An interactive widget is also provided for
previewing themes in real time.")
    (license license:expat)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-shiny
  (package
    (name "r-shiny")
    (version "1.8.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rstudio/shiny")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "06prh7r00dy1i2nlcls9cpfiw86lbyzbgcf9hbj54j6kfv8mh5fw"))
       (snippet
        '(for-each delete-file
                   '("inst/www/shared/bootstrap/js/bootstrap.min.js"
                     "inst/www/shared/bootstrap/accessibility/js/bootstrap-accessibility.min.js" ; TODO
                     "inst/www/shared/datatables/js/jquery.dataTables.min.js"
                     "inst/www/shared/datepicker/js/bootstrap-datepicker.min.js"
                     "inst/www/shared/highlight/highlight.pack.js"
                     "inst/www/shared/ionrangeslider/js/ion.rangeSlider.min.js"
                     "inst/www/shared/jquery.min.js"
                     "inst/www/shared/jqueryui/jquery-ui.min.js"
                     "inst/www/shared/legacy/jquery.min.js"
                     "inst/www/shared/selectize/accessibility/js/selectize-plugin-a11y.min.js"
                     "inst/www/shared/selectize/js/selectize.min.js"
                     "inst/www/shared/shiny.min.js"
                     "inst/www/shared/showdown/compressed/showdown.js"
                     "inst/www/shared/strftime/strftime-min.js")))))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      '(modify-phases (@ (guix build r-build-system) %standard-phases)
         ;; This is needed for some tests.
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp")))
         (add-after 'unpack 'replace-bundled-minified-JavaScript
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((replace-file (lambda (old new)
                                   (format #t "replacing ~a with ~a\n" old new)
                                   (symlink new old))))
               ;; NOTE: Files in ./inst/www/shared/datepicker/js/locales/
               ;; contain just data.  They are not minified code, so we don't
               ;; replace them.
               (with-directory-excursion "inst/www/shared"
                 (replace-file "strftime/strftime-min.js"
                               (search-input-file inputs
                                                  "/share/javascript/strftime.min.js"))
                 (replace-file "highlight/highlight.pack.js"
                               (search-input-file inputs
                                                  "/share/javascript/highlight.min.js"))
                 (replace-file "datatables/js/jquery.dataTables.min.js"
                               (search-input-file inputs
                                                  "/share/javascript/jquery.dataTables.min.js"))
                 (replace-file "selectize/js/selectize.min.js"
                               (search-input-file inputs
                                                  "/share/javascript/selectize.min.js"))
                 (for-each (match-lambda
                             ((source . target)
                              (minify source #:target target)))
                           `(("jqueryui/jquery-ui.js" .
                              "jqueryui/jquery-ui.min.js")
                             ("datepicker/js/bootstrap-datepicker.js" .
                              "datepicker/js/bootstrap-datepicker.min.js")
                             ("ionrangeslider/js/ion.rangeSlider.js" .
                              "ionrangeslider/js/ion.rangeSlider.min.js")
                             ("bootstrap/js/bootstrap.js" .
                              "bootstrap/js/bootstrap.min.js")
                             (,(assoc-ref inputs "js-bootstrap-accessibility") .
                              "bootstrap/accessibility/js/bootstrap-accessibility.min.js")
                             ("shiny.js" .
                              "shiny.min.js")
                             ("jquery.js" .
                              "jquery.min.js")
                             ("legacy/jquery.js" .
                              "legacy/jquery.min.js")
                             ("selectize/accessibility/js/selectize-plugin-a11y.js" .
                              "selectize/accessibility/js/selectize-plugin-a11y.min.js")
                             ("showdown/src/showdown.js" .
                              "showdown/compressed/showdown.js"))))))))))
    (propagated-inputs
     (list r-bslib
           r-cachem
           r-commonmark
           r-crayon
           r-ellipsis
           r-fastmap
           r-fontawesome
           r-glue
           r-htmltools
           r-httpuv
           r-jsonlite
           r-later
           r-lifecycle
           r-mime
           r-promises
           r-r6
           r-rlang
           r-sourcetools
           r-withr
           r-xtable))
    (inputs
     (list js-datatables js-selectize js-strftime js-highlight))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("gfortran" ,gfortran)
       ("js-bootstrap-accessibility"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/paypal/bootstrap-accessibility-plugin/\
v1.0.7/_site/plugins/js/bootstrap-accessibility.js")
           (sha256
            (base32
             "1489wyzwrpf86y7vhc13n4v3mszmsfybhd3f75jkpnbvyp5sncm8"))))
       ("r-future" ,r-future)
       ("r-ggplot2" ,r-ggplot2)
       ("r-testthat" ,r-testthat)))
    (home-page "https://shiny.rstudio.com")
    (synopsis "Easy interactive web applications with R")
    (description
     "Makes it incredibly easy to build interactive web applications
with R.  Automatic \"reactive\" binding between inputs and outputs and
extensive prebuilt widgets make it possible to build beautiful,
responsive, and powerful applications with minimal effort.")
    (license license:artistic2.0)))

(define-public r-shinyauthr
  (package
    (name "r-shinyauthr")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyauthr" version))
       (sha256
        (base32 "0apaqjkxpr96kx9indl0pifk5y75gdx5npfcvxfg5k2crpx9vmxk"))))
    (properties `((upstream-name . "shinyauthr")))
    (build-system r-build-system)
    ;; One of the tests requires r-shinytest, which has a big JavaScript
    ;; problem.
    (arguments (list #:tests? #false))
    (native-inputs (list r-testthat))
    (propagated-inputs (list r-dplyr
                             r-glue
                             r-rlang
                             r-shiny
                             r-shinyjs
                             r-sodium))
    (home-page "https://github.com/paulc91/shinyauthr")
    (synopsis "Shiny authentication modules")
    (description
     "With this package you can add in-app user authentication to Shiny,
allowing you to secure publicly hosted apps and build dynamic user interfaces
from user information.")
    (license license:expat)))

(define-public r-shinydisconnect
  (package
    (name "r-shinydisconnect")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinydisconnect" version))
       (sha256
        (base32 "1yhppfx8jpvz48iwxnimcwqhj02vqjrfmh4z5rdn9d35p51c8zjc"))))
    (properties `((upstream-name . "shinydisconnect")))
    (build-system r-build-system)
    (propagated-inputs (list r-checkmate r-glue r-htmltools r-shiny))
    (home-page "https://github.com/daattali/shinydisconnect")
    (synopsis "Show a nice message when a Shiny app disconnects or errors")
    (description
     "This package provides a Shiny app that can disconnect for a variety of
reasons: an unrecoverable error occurred in the app, the server went down, the
user lost internet connection, or any other reason that might cause the Shiny
app to lose connection to its server.  With shinydisconnect, you can call
@code{disonnectMessage} anywhere in a Shiny app's UI to add a nice message
when this happens.  It works locally (running Shiny apps within RStudio) and
on Shiny servers.")
    (license license:expat)))

(define-public r-shinyhelper
  (package
    (name "r-shinyhelper")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyhelper" version))
       (sha256
        (base32 "1c4hvf19j3yyh8r12nx85ldkxs89g98q74csnqs5ml5l79a65vgp"))))
    (properties `((upstream-name . "shinyhelper")))
    (build-system r-build-system)
    (propagated-inputs (list r-markdown r-shiny))
    (home-page "https://cran.r-project.org/package=shinyhelper")
    (synopsis "Easily add Markdown help files to shiny app elements")
    (description
     "This package creates a lightweight way to add markdown helpfiles to
Shiny apps, using modal dialog boxes, with no need to observe each help button
separately.")
    (license license:gpl3)))

(define-public r-shinymeta
  (package
    (name "r-shinymeta")
    (version "0.2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinymeta" version))
       (sha256
        (base32 "1lizg5sjg0f2axr9vk8z4w43lbyim83gd4dzx91dygknv3kgyp89"))))
    (properties `((upstream-name . "shinymeta")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Needed by styler for writing to caches.
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs (list r-callr
                             r-fastmap
                             r-fs
                             r-htmltools
                             r-rlang
                             r-shiny
                             r-sourcetools
                             r-styler))
    (native-inputs (list r-testthat))
    (home-page "https://rstudio.github.io/shinymeta/")
    (synopsis "Export domain logic from Shiny using meta-programming")
    (description
     "This package provides tools for capturing logic in a Shiny app and
exposing it as code that can be run outside of Shiny (e.g., from an R
console).  It also provides tools for bundling both the code and results to
the end user.")
    (license license:gpl3)))

(define-public r-shiny-router
  (package
    (name "r-shiny-router")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shiny.router" version))
       (sha256
        (base32 "1zg8cdxmw620i1iv7jrghd768gw7iv52hi6lx79xvnfjz8w4si3x"))))
    (properties `((upstream-name . "shiny.router")))
    (build-system r-build-system)
    (propagated-inputs (list r-glue r-htmltools r-rlang r-shiny))
    (native-inputs (list r-testthat))
    (home-page "https://appsilon.github.io/shiny.router/")
    (synopsis "Basic Routing for Shiny Web Applications")
    (description
     "This package provides a simple router for your Shiny apps.  The router
allows you to create dynamic web applications with a real-time User Interface
and easily share url to pages within your Shiny apps.")
    (license license:expat)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-shinytree
  (package
    (name "r-shinytree")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyTree" version))
       (sha256
        (base32
         "0krffsgdv99cvyzdspb9l7cdnq1vibsbmpd4w48r5pi4v8jbvfj6"))
       (snippet
        ;; Delete minified JavaScript
        '(for-each delete-file
                   '("inst/www/jsTree-3.3.7/libs/require.js"
                     "inst/www/jsTree-3.3.7/libs/jquery.js"
                     "inst/www/jsTree-3.3.7/jstree.min.js")))))
    (properties `((upstream-name . "shinyTree")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; This file requires r-shinytest, which has a big JavaScript
             ;; problem.
             (delete-file "tests/testthat/test_tree_interactive.R")))
         (add-after 'unpack 'replace-minified-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/www/jsTree-3.3.7/"
               (symlink (search-input-file inputs
                                           "/share/javascript/require.min.js")
                        "libs/require.js")
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "js-jquery")
                         "libs/jquery.js")
                        ("jstree.js"
                         "jstree.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-htmlwidgets r-jsonlite r-promises r-shiny r-stringr))
    (inputs
     (list js-requirejs))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-3.3.1.js")
           (sha256
            (base32
             "1b8zxrp6xwzpw25apn8j4qws0f6sr7qr7h2va5h1mjyfqvn29anq"))))
       ("r-testthat" ,r-testthat)))
    (home-page "https://cran.r-project.org/web/packages/shinyTree/")
    (synopsis "jsTree bindings for Shiny")
    (description
     "This package exposes R bindings to jsTree, a JavaScript library that
supports interactive trees, to enable rich, editable trees in Shiny.")
    (license license:expat)))

(define-public r-shinyvalidate
  (package
    (name "r-shinyvalidate")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyvalidate" version))
       (sha256
        (base32 "01qlqzp0g6782maj73yygmwlchhv4xcnlc7j0w3lp6dcj7qkzz68"))))
    (properties `((upstream-name . "shinyvalidate")))
    (build-system r-build-system)
    (propagated-inputs (list r-glue r-htmltools r-rlang r-shiny))
    (native-inputs (list r-testthat))
    (home-page "https://rstudio.github.io/shinyvalidate/")
    (synopsis "Input validation for Shiny apps")
    (description
     "This package improves the user experience of Shiny apps by helping to
provide feedback when required inputs are missing, or input values are not
valid.")
    (license license:expat)))

(define-public r-shinydashboard
  (package
    (name "r-shinydashboard")
    (version "0.7.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "shinydashboard" version))
              (sha256
               (base32
                "0hrqkwlpb8rnmp5j74p134g4c4cl16icmwc2ip6k1634fa2y8vm5"))))
    (build-system r-build-system)
    ;; The directory inst/AdminLTE/ contains a minified JavaScript file.
    ;; Regenerate it from the included sources.
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'generate-minified-javascript
           (lambda _
             (with-directory-excursion "inst/AdminLTE"
               (let ((target "app.min.js")
                     (source "app.js"))
                 (format #t "Processing ~a --> ~a~%"
                         source target)
                 (delete-file target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (propagated-inputs
     (list r-htmltools r-promises r-shiny))
    (native-inputs
     (list esbuild))
    (home-page "https://rstudio.github.io/shinydashboard/")
    (synopsis "Create dashboards with shiny")
    (description "This package provides an extension to the Shiny web
application framework for R, making it easy to create attractive dashboards.")
    ;; This package includes software that was released under the Expat
    ;; license, but the whole package is released under GPL version 2 or
    ;; later.
    (license license:gpl2+)))

(define-public r-shinydashboardplus
  (package
    (name "r-shinydashboardplus")
    (version "2.0.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "shinydashboardPlus" version))
              (sha256
               (base32
                "1k53ycfdv5r58rwqsk7mkrrlz72wikhrhzlfrg3dkwbdbzblrhqb"))
              (modules '((guix build utils)))
              (snippet
               `(begin
                  (with-directory-excursion
                      ,(string-append "inst/shinydashboardPlus-" version
                                      "/js/")
                    (for-each delete-file
                              '("app.min.js"
                                "shinydashboardPlus.min.js"
                                "shinydashboardPlus.min.js.map")))
                  (with-directory-excursion "inst/materialDesign-1.0/js"
                    (for-each delete-file
                              '("material.min.js"
                                "ripples.min.js")))))))
    (properties `((upstream-name . "shinydashboardPlus")))
    (build-system r-build-system)
    (arguments
     (list
      ;; The tests launch a shinyApp; they are interactive tests that
      ;; will block forever, so we just don't run them.
      #:tests? #false
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils)
        (ice-9 match))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'process-javascript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion
                  (string-append "inst/shinydashboardPlus-" #$version "/js/")
                (for-each
                 (match-lambda
                   ((source . target)
                    (minify source #:target target)))
                 `(("app.js" . "app.min.js")
                   ("shinydashboardPlus.js" . "shinydashboardPlus.min.js")
                   (,(search-input-file inputs "/dist/js/material.js")
                    . "materialDesign-1.0/js/material.min.js")
                   (,(search-input-file inputs "/dist/js/ripples.js")
                    . "materialDesign-1.0/js/ripples.min.js")))))))))
    (propagated-inputs
     (list r-fresh
           r-htmltools
           r-lifecycle
           r-shiny
           r-shinydashboard
           r-waiter))
    (native-inputs
     (list esbuild r-knitr
           (let ((commit "92a2284b47aed56a9d7ae92cf9b40072d27982b3"))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/DucThanhNguyen/MaterialAdminLTE")
                     (commit commit)))
               (file-name (git-file-name "MaterialAdminLTE"
                                         (git-version "0" "0" commit)))
               (sha256
                (base32
                 "0cn11hxpf25h7xj2lk473z24swgz979dz255zwk2m2fj00iljkn9"))))))
    (home-page "https://github.com/RinteRface/shinydashboardPlus")
    (synopsis "Add more AdminLTE2 components to shinydashboard")
    (description
     "This package extends shinydashboard with AdminLTE2 components.
AdminLTE2 is a Bootstrap 3 dashboard template.  Customize boxes, add timelines
and a lot more.")
    (license license:gpl2+)))

(define-public r-shinyfiles
  (package
    (name "r-shinyfiles")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyFiles" version))
       (sha256
        (base32 "11kjq0vw5c98lzrg80m9w917lkgw5im2h9wgk1b84vlaxrjy2wja"))))
    (properties `((upstream-name . "shinyFiles")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fs r-htmltools r-jsonlite r-shiny r-tibble))
    (home-page "https://github.com/thomasp85/shinyFiles")
    (synopsis "Server-side file system viewer for Shiny")
    (description
     "This package provides functionality for client-side navigation of the
server side file system in shiny apps.  In case the app is running locally
this gives the user direct access to the file system without the need to
\"download\" files to a temporary location.  Both file and folder selection as
well as file saving is available.")
    (license license:gpl2+)))

(define-public r-shinythemes
  (package
    (name "r-shinythemes")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinythemes" version))
       (sha256
        (base32
         "0qr9bfxw8afxns44i2j4msignf6g5qb2nzpay2lpv343rrlqbmip"))))
    (properties `((upstream-name . "shinythemes")))
    (build-system r-build-system)
    (propagated-inputs (list r-shiny))
    (home-page "https://rstudio.github.io/shinythemes/")
    (synopsis "Themes for Shiny")
    (description
     "This package provides themes for use with Shiny.  It includes several
Bootstrap themes, which are packaged for use with Shiny applications.")
    ;; The package is released under version 3 of the GPL, but it includes
    ;; source files that are covered by the Expat license.  It also includes
    ;; fonts under SIL or the ASL.
    (license (list license:gpl3 license:expat
                   license:silofl1.1 license:asl2.0))))

;; The package sources include minified variants of d3.js and non-minified
;; source code of d3-jetpack.
(define-public r-d3r
  (package
    (name "r-d3r")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "d3r" version))
       (sha256
        (base32
         "1dcm53y3jpyswr6y368xhdnn1nkchixf4wkxnsb2mk9lzccb44y4"))
       (snippet
        '(for-each delete-file
                   '("inst/www/d3/v3/dist/d3.min.js"
                     "inst/www/d3/v4/dist/d3.min.js"
                     "inst/www/d3/v5/dist/d3.min.js"
                     "inst/www/d3/v6/dist/d3.min.js"
                     "inst/www/d3/v7/dist/d3.min.js")))))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/www/d3/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "d3.v3.js")
                         "v3/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v4.js")
                         "v4/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v5.js")
                         "v5/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v6.js")
                         "v6/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v7.js")
                         "v7/dist/d3.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-dplyr r-htmltools r-tidyr))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("d3.v3.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v3.js")
           (sha256
            (base32
             "1arr7sr08vy7wh0nvip2mi7dpyjw4576vf3bm45rp4g5lc1k1x41"))))
       ("d3.v4.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v4.js")
           (sha256
            (base32
             "0y7byf6kcinfz9ac59jxc4v6kppdazmnyqfav0dm4h550fzfqqlg"))))
       ("d3.v5.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v5.js")
           (sha256
            (base32
             "177ypw6mjrp2ch9lj6znibwacwrvm4ypjxflsxsnl2sigx5dcwic"))))
       ("d3.v6.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v6.js")
           (sha256
            (base32
             "13hick3glizzm442b9swlwz584rzwwvhpq9qvfbh3m5jay10wxw0"))))
       ("d3.v7.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v7.js")
           (sha256
            (base32
             "1m4i3kqzkz7w06sp9zqcy9f88xpdhi7cqih3phdrf4yjmfk1pfjg"))))
       ("r-testthat" ,r-testthat)))
    (home-page "https://github.com/timelyportfolio/d3r")
    (synopsis "Data visualization utilities for R")
    (description
     "This package provides a suite of functions to help ease the use of the
d3.js visualization library in R.  These helpers include
@code{htmltools::htmlDependency} functions, hierarchy builders, and conversion
tools for @code{partykit}, @code{igraph}, @code{table}, and @code{data.frame}
R objects into the JSON format that the d3.js library expects.")
    (license license:bsd-3)))

;; We use the latest commit here because the last release was in 2016 while
;; the latest commit was in 2018.
(define-public r-sankeyd3
  (let ((commit "fd50a74e29056e0d67d75b4d04de47afb2f932bc")
        (revision "1"))
    (package
      (name "r-sankeyd3")
      (version (git-version "0.3.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fbreitwieser/sankeyD3")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0jrcnfax321pszbpjdifnkbrgbjr43bjzvlzv1p5a8wskksqwiyx"))))
      (build-system r-build-system)
      (propagated-inputs
       (list r-d3r r-htmlwidgets r-shiny r-magrittr))
      (home-page "https://github.com/fbreitwieser/sankeyD3")
      (synopsis "Sankey network graphs from R")
      (description
       "This package provides an R library to generate Sankey network graphs
in R and Shiny via the D3 visualization library.")
      ;; The R code is licensed under GPLv3+.  It includes the non-minified
      ;; JavaScript source code of d3-sankey, which is released under the
      ;; 3-clause BSD license.
      (license (list license:gpl3+ license:bsd-3)))))

(define-public r-webfakes
  (package
    (name "r-webfakes")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "webfakes" version))
       (sha256
        (base32 "0c4ja653fzamafkz7chfv16f1h7iibah683ma8sk2yaayywp7j47"))))
    (properties `((upstream-name . "webfakes")))
    (build-system r-build-system)
    (native-inputs (list r-curl r-testthat))
    (home-page "https://webfakes.r-lib.org/")
    (synopsis "Fake web apps for HTTP testing")
    (description
     "This package lets you create a web app that makes it easier to test web
clients without using the internet.  It includes a web app framework with path
matching, parameters and templates.  It can parse various HTTP request bodies.
It can send JSON data or files from the disk.  It includes a web app that
implements the httpbin.org web service.")
    (license license:expat)))

(define-public r-wesanderson
  (package
    (name "r-wesanderson")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wesanderson" version))
       (sha256
        (base32
         "0kjyz5mrkrirg2glf57b0rhxj2fdp1m6q8zx947y0jg1w425cbn9"))))
    (properties `((upstream-name . "wesanderson")))
    (build-system r-build-system)
    (home-page "https://github.com/karthik/wesanderson")
    (synopsis "Wes Anderson color palette generator")
    (description
     "This package provides color palettes that have been generated mostly
from Wes Anderson movies.")
    (license license:expat)))

(define-public r-gg-gap
  (package
    (name "r-gg-gap")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gg.gap" version))
       (sha256
        (base32
         "0m66050ryn31xmsmmikjsssllasvjdmp9yjbwfdwfpwdv106zn9h"))))
    (properties `((upstream-name . "gg.gap")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cowplot r-ggplot2))
    (home-page "https://github.com/ChrisLou-bioinfo/gg.gap")
    (synopsis "Define segments on the y-axis for ggplot2")
    (description
     "The @code{gg.gap} function enables you to define segments for the y-axis
in a ggplot2 plot.")
    (license license:gpl3)))

(define-public r-mbess
  (package
    (name "r-mbess")
    (version "4.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "MBESS" version))
       (sha256
        (base32 "05ph8dwigwn0c4qg8smqhsjijvsvfawbzvm74mqpasi8qifz8nd3"))))
    (properties `((upstream-name . "MBESS")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-lavaan r-mass r-mnormt r-nlme r-openmx r-sem r-semtools))
    (home-page "https://www3.nd.edu/~kkelley/site/MBESS.html")
    (synopsis "Methods for designing research studies")
    (description
     "This package implements methods that are useful in designing research
studies and analyzing data, with particular emphasis on methods that are
developed for or used within the behavioral, educational, and social
sciences (broadly defined).  That being said, many of the methods implemented
within MBESS are applicable to a wide variety of disciplines.  MBESS has a
suite of functions for a variety of related topics, such as effect sizes,
confidence intervals for effect sizes (including standardized effect sizes and
noncentral effect sizes), sample size planning (from the @dfn{accuracy in
parameter estimation} (AIPE), power analytic, equivalence, and minimum-risk
point estimation perspectives), mediation analysis, various properties of
distributions, and a variety of utility functions.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-homologene
  (package
    (name "r-homologene")
    (version "1.4.68.19.3.27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "homologene" version))
       (sha256
        (base32 "0d7wxisk0vqk1n165v1i19bc02zv78h5r5d3jqai5y6nkmwn01sh"))))
    (properties `((upstream-name . "homologene")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-magrittr r-purrr r-r-utils r-readr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/oganm/homologene")
    (synopsis "Quick access to homologene and gene annotation updates")
    (description
     "This package provides a wrapper for the homologene database by the
National Center for Biotechnology Information (NCBI).  It allows searching for
gene homologs across species.  The package also includes an updated version of
the homologene database where gene identifiers and symbols are replaced with
their latest (at the time of submission) version and functions to fetch latest
annotation data to keep updated.")
    (license license:expat)))

(define-public r-ggtangle
  (package
    (name "r-ggtangle")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggtangle" version))
       (sha256
        (base32 "0drw2m6marf7msnghxpxbi6y3zzns0x8ybr5x34q53q25bbkr4m2"))))
    (properties `((upstream-name . "ggtangle")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggfun
                             r-ggplot2
                             r-ggrepel
                             r-igraph
                             r-rlang
                             r-yulab-utils))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=ggtangle")
    (synopsis "Draw network with data")
    (description
     "This package extends the ggplot2 plotting system to support network
visualization.  Inspired by ggtree, ggtangle is designed to work with network
associated data.")
    (license license:artistic2.0)))

(define-public r-ggtern
  (package
    (name "r-ggtern")
    (version "3.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggtern" version))
       (sha256
        (base32 "0ymly9vdzk7rd4p27m1262bm7fvim989yswgw3mr9y0422dn8awa"))))
    (properties `((upstream-name . "ggtern")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-compositions
           r-ggplot2
           r-gridextra
           r-gtable
           r-hexbin
           r-latex2exp
           r-lattice
           r-mass
           r-plyr
           r-proto
           r-rlang
           r-scales))
    (home-page "http://www.ggtern.com")
    (synopsis "Extension to ggplot2 for ternary diagrams")
    (description
     "This package extends the functionality of ggplot2, providing the
capability to plot ternary diagrams for (a subset of) the ggplot2 geometries.
Additionally, ggtern has implemented several new geometries which are
unavailable to the standard ggplot2 release.")
    (license license:gpl2)))

(define-public r-tablerdash
  (package
    (name "r-tablerdash")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tablerDash" version))
       (sha256
        (base32
         "0cjidfkxwc56xj9rka0ba80hnwvm05wfvpw65wwmr3l56smnfcbz"))
       ;; Delete minified JavaScript
       (snippet
        '(for-each delete-file
                   '("inst/tablerDash-0.1.0/require.min.js"
                     "inst/bootstrap-4.0.0/bootstrap.bundle.min.js")))))
    (properties `((upstream-name . "tablerDash")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst"
               (for-each (match-lambda
                           ((source . target)
                            (minify source #:target target)))
                         `((,(assoc-ref inputs "js-requirejs")
                            . "tablerDash-0.1.0/require.min.js")
                           (,(assoc-ref inputs "js-bootstrap")
                            . "bootstrap-4.0.0/bootstrap.bundle.min.js")))))))))
    (propagated-inputs
     (list r-htmltools r-shiny))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-requirejs"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/requirejs/requirejs/2.3.5/require.js")
           (sha256
            (base32
             "06w32mwqii9cx409ivda88z58qbkcdb4p6hf6jawchsgagaziyds"))))
       ("js-bootstrap"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/\
v4.0.0/dist/js/bootstrap.bundle.js")
           (sha256
            (base32
             "0cvfqffn45vfbj3fk6wmrhkyndhk4id89vgydssbbzxjkfwprfrj"))))))
    (home-page "https://rinterface.github.io/tablerDash/")
    (synopsis "Tabler API for Shiny")
    (description
     "This package provides an R interface to the
@url{https://tabler.io,Tabler} HTML template.  tablerDash is a light Bootstrap
4 dashboard template.  There are different layouts available such as a one
page dashboard or a multi-page template, where the navigation menu is
contained in the navigation bar.")
    (license license:gpl2+)))

(define-public r-spdl
  (package
    (name "r-spdl")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spdl" version))
       (sha256
        (base32 "185qzlwac7acq126xpvcd71nv25zgkrdr8m73gv2sn1zxj78hyid"))))
    (properties `((upstream-name . "spdl")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcppspdlog))
    (home-page "https://github.com/eddelbuettel/spdl")
    (synopsis "Easier use of RcppSpdlog functions via wrapper")
    (description
     "Logging functions in @code{RcppSpdlog} provide access to the logging
functionality from the spdlog C++ library.  This package offers shorter
convenience wrappers for the R functions which match the C++ functions, namely
via, say, @code{spdl::debug()} at the debug level.  The actual formatting is
done by the @code{fmt::format()} function from the fmtlib library (that is
also @code{std::format()} in C++20 or later).")
    (license license:gpl2+)))

(define-public r-spelling
  (package
    (name "r-spelling")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spelling" version))
       (sha256
        (base32
         "1mww2czkfrb1xvjbks7g1xhr8nx1v9mikb2lc3ynn6j2rp9zgwgp"))))
    (properties `((upstream-name . "spelling")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-commonmark r-hunspell r-knitr r-xml2))
    (home-page "https://docs.ropensci.org/spelling/")
    (synopsis "Tools for spell checking in R")
    (description
     "This is an R package for spell checking common document formats
including LaTeX, markdown, manual pages, and DESCRIPTION files.  It includes
utilities to automate checking of documentation and vignettes as a unit test
during @code{R CMD check}.  Both British and American English are supported
out of the box and other languages can be added.  In addition, packages may
define a wordlist to allow custom terminology without having to abuse
punctuation.")
    (license license:expat)))

(define-public r-caper
  (package
    (name "r-caper")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "caper" version))
       (sha256
        (base32 "1f1mw54gv1r40wrrsznhgffdj8ggrwihiwdd8wyqccyvqm49fxjg"))))
    (properties `((upstream-name . "caper")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape r-mass r-mvtnorm))
    (home-page "https://cran.r-project.org/package=caper")
    (synopsis "Comparative analyses of phylogenetics and evolution in R")
    (description
     "This package provides functions for performing phylogenetic comparative
analyses.")
    (license license:gpl2+)))

(define-public r-crosstalk
  (package
    (name "r-crosstalk")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "crosstalk" version))
       (sha256
        (base32
         "1w8lc3hcd1nlw541880vs3agk2i6bilyapnq9lcs3mfn2s2g0338"))
       (snippet
        '(for-each delete-file
                   (list "inst/lib/jquery/jquery.min.js"
                         "inst/lib/ionrangeslider/js/ion.rangeSlider.min.js"
                         "inst/lib/selectize/js/selectize.min.js"
                         "inst/www/js/crosstalk.min.js")))))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'replace-bundled-minified-JavaScript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "inst/"
                (copy-file (search-input-file inputs
                                              "/share/javascript/selectize.min.js")
                           "lib/selectize/js/selectize.min.js")
                (for-each (match-lambda
                            ((source . target)
                             (minify source #:target target)))
                          `(("lib/jquery/jquery.js"
                             . "lib/jquery/jquery.min.js")
                            ("lib/ionrangeslider/js/ion.rangeSlider.js"
                             . "lib/ionrangeslider/js/ion.rangeSlider.min.js")
                            ("www/js/crosstalk.js"
                             . "www/js/crosstalk.min.js")))))))))
    (propagated-inputs
     (list r-htmltools r-jsonlite r-lazyeval r-r6))
    (native-inputs
     (list esbuild js-selectize r-testthat))
    (home-page "https://rstudio.github.io/crosstalk/")
    (synopsis "Inter-widget interactivity for HTML widgets")
    (description
     "This package provides building blocks for allowing HTML widgets to
communicate with each other, with Shiny or without (i.e., static @code{.html}
files).  It currently supports linked brushing and filtering.")
    (license license:expat)))

(define-public r-rook
  (package
    (name "r-rook")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rook" version))
       (sha256
        (base32
         "0qjziszrrwsp1mbykps3yf5r98q83cyd4jzpgi7gvbsd2ssy96n7"))))
    (properties `((upstream-name . "Rook")))
    (build-system r-build-system)
    (propagated-inputs (list r-brew))
    (home-page "https://cran.r-project.org/web/packages/Rook")
    (synopsis "Web server interface for R")
    (description
     "This package contains the Rook specification and convenience software
for building and running Rook applications.  A Rook application is an R
reference class object that implements a @code{call} method or an R closure
that takes exactly one argument, an environment, and returns a list with three
named elements: the @code{status}, the @code{headers}, and the @code{body}.")
    (license license:gpl2)))

(define-public r-miniui
  (package
    (name "r-miniui")
    (version "0.1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "miniUI" version))
       (sha256
        (base32
         "1h5h2sc57h95d6bsgs95l26911g38hvjc1v50bc31xl9689l2as5"))))
    (properties `((upstream-name . "miniUI")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools r-shiny))
    (home-page "https://cran.r-project.org/web/packages/miniUI/")
    (synopsis "Shiny UI widgets for small screens")
    (description
     "This package provides UI widget and layout functions for writing Shiny apps that
work well on small screens.")
    (license license:gpl3)))

(define-public r-minty
  (package
    (name "r-minty")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "minty" version))
       (sha256
        (base32 "0hh7yqg8cff0x7b23ng4944h7rqpm96zb7qrqifkdssxcl1jf8ln"))))
    (properties `((upstream-name . "minty")))
    (build-system r-build-system)
    (propagated-inputs (list r-cpp11 r-tzdb))
    (native-inputs (list r-hms r-testthat tzdata-for-tests))
    (home-page "https://gesistsa.github.io/minty/")
    (synopsis "Minimal type guesser")
    (description
     "This is a port of the type guesser from the @code{readr} package, the
so-called readr first edition parsing engine, now superseded by vroom.")
    (license license:expat)))

(define-public r-mirt
  (package
    (name "r-mirt")
    (version "1.43")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mirt" version))
       (sha256
        (base32 "18lqlpcw16bs9qkxdzgbhp7r1mgihkn5798amall341bpym8y1lc"))))
    (properties `((upstream-name . "mirt")))
    (build-system r-build-system)
    (propagated-inputs (list r-dcurver
                             r-deriv
                             r-gparotation
                             r-gridextra
                             r-lattice
                             r-matrix
                             r-mgcv
                             r-pbapply
                             r-rcpp
                             r-rcpparmadillo
                             r-simdesign
                             r-vegan))
    (native-inputs (list r-knitr))
    (home-page "https://philchalmers.github.io/mirt/")
    (synopsis "Multidimensional item response theory")
    (description
     "This is a package for the analysis of discrete response data using
unidimensional and multidimensional item analysis models under the Item
Response Theory paradigm (Chalmers (2012) <doi:10.18637/jss.v048.i06>).
Exploratory and confirmatory item factor analysis models are estimated with
quadrature (EM) or stochastic (MHRM) methods.  Confirmatory bi-factor and
two-tier models are available for modeling item testlets using dimension
reduction EM algorithms, while multiple group analyses and mixed effects
designs are included for detecting differential item, bundle, and test
functioning, and for modeling item and person covariates.  Finally, latent
class models such as the DINA, DINO, multidimensional latent class, mixture
IRT models, and zero-inflated response models are supported.")
    (license license:gpl3+)))

(define-public r-feather
  (package
    (name "r-feather")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "feather" version))
       (sha256
        (base32
         "1gxd0h2m56sjjlzn4dry6s13nddxc4l5i11gsvavaf2dwbahdzsh"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-hms r-rcpp r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/wesm/feather")
    (synopsis "R Bindings to the Feather API")
    (description "Read and write feather files, a lightweight binary columnar
data store designed for maximum speed.")
    (license license:asl2.0)))

(define-public r-mapdata
  (package
    (name "r-mapdata")
    (version "2.3.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mapdata" version))
              (sha256
               (base32
                "1m2r4c8f7fp900g3sdjbfxxnxjla86hn75jd8hi96ms188p0j8b0"))))
    (properties `((upstream-name . "mapdata")))
    (build-system r-build-system)
    (propagated-inputs (list r-maps))
    (home-page "https://cran.r-project.org/package=mapdata")
    (synopsis "Extra map databases")
    (description
     "This is a supplement to the @code{maps} package providing the larger
and/or higher-resolution databases.")
    (license license:gpl2)))

(define-public r-maps
  (package
    (name "r-maps")
    (version "3.4.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "maps" version))
       (sha256
        (base32
         "1vsbjk4kqjd37j3aqz7nqc9zlzjdpprq1cp80pmdkz7n91y5rqqb"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/maps")
    (synopsis "Draw geographical maps")
    (description "This package provides an R module for display of maps.
Projection code and larger maps are in separate packages (@code{mapproj} and
@code{mapdata}).")
    (license license:gpl2)))

(define-public r-mapproj
  (package
    (name "r-mapproj")
    (version "1.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mapproj" version))
       (sha256
        (base32
         "0z9lhv006pw4mwqlghvgvv66ga958bs6n1k6fmqjdpirr4f20bfv"))))
    (build-system r-build-system)
    (propagated-inputs (list r-maps))
    (home-page "https://cran.r-project.org/web/packages/mapproj")
    (synopsis "Map projection in R")
    (description "This package converts latitude/longitude into projected
coordinates.")
    (license (list license:gpl2          ; The R interface
                   license:lpl1.02))))   ; The C code

(define-public r-rgooglemaps
  (package
    (name "r-rgooglemaps")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RgoogleMaps" version))
       (sha256
        (base32
         "197q5i2sky824dwq0x4hhrpkrsd1b6f9qg06mjlwb89mv4vnrzhl"))))
    (properties `((upstream-name . "RgoogleMaps")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-png))
    (home-page "https://cran.r-project.org/web/packages/RgoogleMaps")
    (synopsis "Use Google Maps in R")
    (description "This package serves two purposes:
@enumerate
@item Provide a comfortable R interface to query the Google server for static
  maps, and
@item Use the map as a background image to overlay plots within R.  This
  requires proper coordinate scaling.
@end enumerate\n")
    (license license:gpl2+)))

(define-public r-gensa
  (package
    (name "r-gensa")
    (version "1.1.14.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "GenSA" version))
              (sha256
               (base32
                "0zrprs5gb0pwl249gnvs675ph5f59z2dhis562xfmjbhsv5m9p9g"))))
    (properties `((upstream-name . "GenSA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=GenSA")
    (synopsis "Generalized simulated annealing")
    (description "This package performs search for the global minimum of a very
complex non-linear objective function with a very large number of optima.")
    (license license:gpl2)))

(define-public r-geojsonr
  (package
    (name "r-geojsonr")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geojsonR" version))
       (sha256
        (base32 "10li5xj0vx6a86nccwql4inwfbjycvaxqfbjdp4h1p5qxyibnls3"))))
    (properties `((upstream-name . "geojsonR")))
    (build-system r-build-system)
    (propagated-inputs (list r-r6 r-rcpp r-rcpparmadillo))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/mlampros/geojsonR")
    (synopsis "GeoJson processing toolkit")
    (description
     "This package includes functions for processing @code{GeoJson} objects
relying on RFC 7946.  The geojson encoding is based on json11, a tiny JSON
library for C++11.  Furthermore, the source code is exported in R through the
Rcpp and @code{RcppArmadillo} packages.")
    (license license:expat)))

(define-public r-geos
  (package
    (name "r-geos")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geos" version))
       (sha256
        (base32 "03cxm9rby7qmk9apqk3sh373rnzqcrj23cn6q153gq93lx372b8n"))))
    (properties `((upstream-name . "geos")))
    (build-system r-build-system)
    (propagated-inputs (list r-libgeos r-wk))
    (native-inputs (list r-testthat))
    (home-page "https://paleolimbot.github.io/geos/")
    (synopsis "Open Source Geometry Engine (GEOS) R API")
    (description
     "This package provides an R API to the Open Source Geometry Engine (GEOS)
library and a vector format with which to efficiently store GEOS geometries.
High-performance functions to extract information from, calculate
relationships between, and transform geometries are provided.  Finally,
facilities to import and export geometry vectors to other spatial formats are
provided.")
    (license license:expat)))

(define-public r-geosphere
  (package
    (name "r-geosphere")
    (version "1.5-20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geosphere" version))
       (sha256
        (base32
         "01cwlrbqi216a19h9721i0vj7vakrybybqkicbg9pwyv6c2hy8cq"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-sp))
    (home-page "https://cran.r-project.org/web/packages/geosphere")
    (synopsis "Spherical trigonometry")
    (description "This package computes spherical trigonometry for geographic
applications.  That is, compute distances and related measures for angular
(longitude/latitude) locations.")
    (license license:gpl3+)))

(define-public r-jpeg
  (package
    (name "r-jpeg")
    (version "0.1-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jpeg" version))
       (sha256
        (base32
         "1jkqj58hj33ar9wyl7c1cnj3h42icq7crmjk93n933q8qc4zdnf8"))))
    (build-system r-build-system)
    (inputs (list libjpeg-turbo))
    (home-page "https://www.rforge.net/jpeg/")
    (synopsis "Read and write JPEG images with R")
    (description "This package provides a way to read, write and display
bitmap images stored in the JPEG format with R.  It can read and write both
files and in-memory raw vectors.")
    (license license:gpl2+)))

(define-public r-ggmap
  (package
    (name "r-ggmap")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggmap" version))
       (sha256
        (base32
         "1x9lqx0mizqiyxzgg8pgkbi8qmbn2a0zsq5r5riknvh6ghskkrhd"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bitops
           r-cli
           r-digest
           r-dplyr
           r-ggplot2
           r-glue
           r-httr
           r-jpeg
           r-magrittr
           r-plyr
           r-png
           r-purrr
           r-rlang
           r-scales
           r-stringr
           r-tibble
           r-tidyr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/dkahle/ggmap")
    (synopsis "Spatial visualization with ggplot2")
    (description "This package provides a collection of functions to visualize
spatial data and models on top of static maps from various online sources (e.g
Google Maps and Stamen Maps).  It includes tools common to those tasks,
including functions for geolocation and routing.")
    (license license:gpl2)))

(define-public r-ggmosaic
  (package
    (name "r-ggmosaic")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggmosaic" version))
       (sha256
        (base32 "1zm1zfbd0qk6icw65m9hz1hgyqj632ibq3qilidvx5jy7jh8nbpy"))))
    (properties `((upstream-name . "ggmosaic")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-ggplot2
                             r-ggrepel
                             r-plotly
                             r-productplots
                             r-purrr
                             r-rlang
                             r-scales
                             r-tidyr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/haleyjeppson/ggmosaic")
    (synopsis "Mosaic plots in the ggplot2 framework")
    (description
     "This package provides mosaic plots for the ggplot2 framework.  Mosaic
plot functionality is provided in a single ggplot2 layer by calling the
@code{geom} @code{mosaic}.")
    (license license:gpl2+)))

(define-public r-haven
  (package
    (name "r-haven")
    (version "2.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "haven" version))
       (sha256
        (base32
         "0dd83v3bfs7and9ydx35m8zw0md3wgchwpnvj6yllixa6yxk25cy"))
       (modules '((guix build utils)))
       (snippet
        ;; unvendor readstat
        '(delete-file-recursively "src/readstat"))))
    (build-system r-build-system)
    (properties
     '((updater-extra-inputs . ("readstat"))))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'unbundle-readstat
           (lambda _
             ;; We’re not building readstat.
             (substitute* "configure"
               (("^PKG_CONFIG_NAME=\"zlib\"")
                "PKG_CONFIG_NAME=\"readstat zlib\"")
               (("^PKG_LIBS=\"-lz\"")
                "PKG_LIBS=\"-lz -lreadstat\"\n")
               (("exit 1") "")))))))  ;don't be so dramatic!
    (inputs
     (list readstat zlib))
    (native-inputs
     (list pkg-config r-knitr r-testthat))
    (propagated-inputs
     (list r-cli
           r-cpp11
           r-forcats
           r-hms
           r-lifecycle
           r-readr
           r-rlang
           r-tibble
           r-tidyselect
           r-vctrs))
    (home-page "https://haven.tidyverse.org")
    (synopsis "Import and export SPSS, Stata and SAS files")
    (description
     "This package lets you import foreign statistical formats into R via the
@url{https://github.com/WizardMac/ReadStat,ReadStat} C library.")
    (license license:expat)))

(define-public r-amap
  (package
    (name "r-amap")
    (version "0.8-20")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "amap" version))
              (sha256
               (base32
                "0w65z1jqg6c9fp6knv9ps5f22f4jk94hbihr6l0hbmijiznbffwq"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "http://mulcyber.toulouse.inra.fr/projects/amap/")
    (synopsis "Another multidimensional analysis package")
    (description "This package provides tools for clustering and principal
component analysis (with robust methods, and parallelized functions).")
    (license license:gpl2+)))

(define-public r-ape
  (package
    (name "r-ape")
    (version "5.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ape" version))
       (sha256
        (base32
         "092dx0x763r6ch6pp4c4fkmnq5alrq0527p72w1wdg71g6cp5ki4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest r-lattice r-nlme r-rcpp))
    (home-page "http://ape-package.ird.fr/")
    (synopsis "Analyses of phylogenetics and evolution")
    (description
     "This package provides functions for reading, writing, plotting, and
manipulating phylogenetic trees, analyses of comparative data in a
phylogenetic framework, ancestral character analyses, analyses of
diversification and macroevolution, computing distances from DNA sequences,
and several other tools.")
    (license license:gpl2+)))

(define-public r-abbyyr
  (package
    (name "r-abbyyr")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abbyyR" version))
       (sha256
        (base32
         "1vldnd3dg89aj6a73nhirirqddbfdrnzhb5m3679i60sark8nk6r"))))
    (properties `((upstream-name . "abbyyR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl
           r-httr
           r-plyr
           r-progress
           r-readr
           r-xml))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/soodoku/abbyyR")
    (synopsis "Access to Abbyy Optical Character Recognition (OCR) API")
    (description
     "This package provides tools to get text from images of text using Abbyy
Cloud Optical Character Recognition (OCR) API.  With abbyyyR, one can easily
OCR images, barcodes, forms, documents with machine readable zones, e.g.
passports and get the results in a variety of formats including plain text and
XML.  To learn more about the Abbyy OCR API, see @url{http://ocrsdk.com/}.")
    (license license:expat)))

(define-public r-colorspace
  (package
    (name "r-colorspace")
    (version "2.1-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "colorspace" version))
       (sha256
        (base32 "02ydb0vncck0l9shfbz07gymdy5l2vinb0miivyb1r6nykjww8g7"))))
    (build-system r-build-system)
    ;; Tests require r-vcd, which depends on this package.
    (arguments (list #:tests? #false))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/colorspace")
    (synopsis "Color space manipulation")
    (description
     "This package carries out a mapping between assorted color spaces
including RGB, HSV, HLS, CIEXYZ, CIELUV, HCL (polar CIELUV), CIELAB and polar
CIELAB.  Qualitative, sequential, and diverging color palettes based on HCL
colors are provided.")
    (license license:bsd-3)))

(define-public r-glue
  (package
    (name "r-glue")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "glue" version))
       (sha256
        (base32
         "183j9gpffmi30lfifl8d9sq1l25f8dgsgqd3blpndf4rm15kcvy8"))))
    (properties
     ;; knitr depends on glue, so we can't add knitr here to build the
     ;; vignettes.  Same with testthat
     '((updater-ignored-native-inputs . ("r-knitr" "r-testthat"))))
    (build-system r-build-system)
    (arguments (list #:tests? #false))
    (home-page "https://github.com/tidyverse/glue")
    (synopsis "Interpreted string literals")
    (description
     "This package provides an implementation of interpreted string literals,
inspired by Python's Literal String Interpolation (PEP-0498) and
Docstrings (PEP-0257) and Julia's Triple-Quoted String Literals.")
    (license license:expat)))

(define-public r-glmnetutils
  (package
    (name "r-glmnetutils")
    (version "1.1.9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "glmnetUtils" version))
              (sha256
               (base32
                "0rh07i9j6bxiqcl84d8jnn7dzqdwfdzak7w8bf4j4521r24mwm01"))))
    (properties `((upstream-name . "glmnetUtils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-glmnet r-matrix))
    (native-inputs (list r-knitr r-mass r-testthat))
    (home-page "https://github.com/hongooi73/glmnetUtils")
    (synopsis
     "Streamline the process of fitting elastic net models with glmnet")
    (description
     "This package provides a collection of tools to streamline the
process of fitting elastic net models with @code{glmnet}.  In addition
to providing a formula interface, it also features a function
@code{cva.glmnet} to do crossvalidation for both α and λ, as well as
some utility functions.")
    (license license:gpl2)))

(define-public r-paletteer
  (package
    (name "r-paletteer")
    (version "1.6.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "paletteer" version))
              (sha256
               (base32
                "1n4jim2fgyff6c5mjridq92jgvr5m2qgwfsgvhyj1pwk1hq21pmm"))))
    (properties `((upstream-name . "paletteer")))
    (build-system r-build-system)
    (propagated-inputs (list r-prismatic r-rematch2 r-rlang r-rstudioapi))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/EmilHvitfeldt/paletteer")
    (synopsis "Comprehensive collection of color palettes")
    (description
     "The choices of color palettes in R can be quite overwhelming with palettes
spread over many packages with many different API's.  This package aims to
collect all color palettes across the R ecosystem under the same package with
a streamlined API.")
    (license license:gpl3)))

(define-public r-palmerpenguins
  (package
    (name "r-palmerpenguins")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "palmerpenguins" version))
       (sha256
        (base32
         "1d1h3bfx750is4qqj4w00rcigk9rrdy69bvd5bgqz5y7ls5x8h1a"))))
    (properties
     `((upstream-name . "palmerpenguins")))
    (build-system r-build-system)
    (home-page "https://allisonhorst.github.io/palmerpenguins/")
    (synopsis "Palmer Archipelago (Antarctica) penguin data")
    (description
     "This package includes size measurements, clutch observations, and blood
isotope ratios for adult foraging Adélie, Chinstrap, and Gentoo penguins
observed on islands in the Palmer Archipelago near Palmer Station, Antarctica.
Data were collected and made available by Dr. Kristen Gorman and the Palmer
Station Long Term Ecological Research (LTER) Program.")
    (license license:cc0)))

(define-public r-party
  (package
    (name "r-party")
    (version "1.3-17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "party" version))
       (sha256
        (base32 "0jvxy9v30aazh9rkvhwz95gaq7s64sasdlsp9ckm1ks3wyqpdq7h"))))
    (properties `((upstream-name . "party")))
    (build-system r-build-system)
    (propagated-inputs (list r-coin
                             r-modeltools
                             r-mvtnorm
                             r-sandwich
                             r-strucchange
                             r-survival
                             r-zoo))
    (native-inputs (list r-mlbench r-vcd))
    (home-page "https://party.r-forge.r-project.org")
    (synopsis "Laboratory for recursive partitioning")
    (description
     "This package provides a computational toolbox for recursive
partitioning.  The core of the package is @code{ctree()}, an implementation of
conditional inference trees which embed tree-structured regression models into
a well defined theory of conditional inference procedures.  This
non-parametric class of regression trees is applicable to all kinds of
regression problems, including nominal, ordinal, numeric, censored as well as
multivariate response variables and arbitrary measurement scales of the
covariates.  Based on conditional inference trees, @code{cforest()} provides
an implementation of Breiman's random forests.  The function @code{mob()}
implements an algorithm for recursive partitioning based on parametric
models (e.g. linear models, GLMs or survival regression) employing parameter
instability tests for split selection.  Extensible functionality for
visualizing tree-structured regression models is available.")
    (license license:gpl2)))

(define-public r-pastecs
  (package
   (name "r-pastecs")
   (version "1.4.2")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "pastecs" version))
            (sha256
             (base32
              "1y3nngdmslbs1rls0n2nbx8jpp9z3nvv11w1z6rff6v0ky05ddj3"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-boot))
   (native-inputs (list r-knitr r-svunit))
   (home-page "https://github.com/phgrosjean/pastecs")
   (synopsis "Analysis of space-time ecological series")
   (description
    "This package provides functions for regulation, decomposition and analysis
of space-time series.  The @code{pastecs} library is a PNEC-Art4 and IFREMER
initiative to bring PASSTEC 2000 functionalities to R.")
   (license license:gpl2+)))

(define-public r-partykit
  (package
   (name "r-partykit")
   (version "1.2-22")
   (source (origin
             (method url-fetch)
             (uri (cran-uri "partykit" version))
             (sha256
              (base32
               "1nqabizmy44c6ip7clg15wljwmd66p7jzzdb3xfsh40bjym1a00g"))))
   (build-system r-build-system)
   ;; Vignettes require r-psychotree, which depends on this package.
   (arguments (list #:test-types '(list "tests")))
   (propagated-inputs
    (list r-formula
          r-inum
          r-libcoin
          r-mvtnorm
          r-rpart
          r-survival))
   (native-inputs (list r-aer r-coin r-mlbench r-party r-pmml r-vcd r-xml))
   (home-page "https://partykit.R-Forge.R-project.org/partykit")
   (synopsis "Toolkit for recursive partytioning")
   (description
    "This package provides a toolkit with infrastructure for representing,
summarizing, and visualizing tree-structured regression and classification
models.")
   (license license:gpl2+)))

(define-public r-plogr
  (package
    (name "r-plogr")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plogr" version))
       (sha256
        (base32
         "0a8dhzlna79ggyhfr0nncgh15a9n6r0dsz664pz0ah323wpblqqf"))))
    (build-system r-build-system)
    (home-page "https://github.com/krlmlr/plogr")
    (synopsis "R bindings for the plog C++ logging library")
    (description
     "This package provides the header files for a stripped-down version of
the plog header-only C++ logging library, and a method to log to R's standard
error stream.")
    (license license:expat)))

(define-public r-pls
  (package
    (name "r-pls")
    (version "2.8-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pls" version))
       (sha256
        (base32 "1krkl11b90w4hbdj168x4x9mvifwmx8ia265gr6gl8c99j6h2ac0"))))
    (build-system r-build-system)
    (native-inputs (list r-runit r-testthat))
    (home-page "https://mevik.net/work/software/pls.html")
    (synopsis "Partial Least Squares and Principal Component Regression")
    (description
     "The pls package implements multivariate regression methods: Partial Least
Squares Regression (@dfn{PLSR}), Principal Component Regression (@dfn{PCR}), and
Canonical Powered Partial Least Squares (@dfn{CPPLS}).  It supports:

@itemize
@item several algorithms: the traditional orthogonal scores (@dfn{NIPALS}) PLS
algorithm, kernel PLS, wide kernel PLS, Simpls, and PCR through @code{svd}
@item multi-response models (or @dfn{PLS2})
@item flexible cross-validation
@item Jackknife variance estimates of regression coefficients
@item extensive and flexible plots: scores, loadings, predictions, coefficients,
(R)MSEP, R², and correlation loadings
@item formula interface, modelled after @code{lm()}, with methods for predict,
print, summary, plot, update, etc.
@item extraction functions for coefficients, scores, and loadings
@item MSEP, RMSEP, and R² estimates
@item multiplicative scatter correction (@dfn{MSC})
@end itemize\n")
    (license license:gpl2)))

(define-public r-ps
  (package
    (name "r-ps")
    (version "1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ps" version))
       (sha256
        (base32 "1087m3a76vldiamj81qqzqk0n23jjw2c42bsyc91sfhpa1zkp832"))))
    (properties
     ;; We can't have r-testthat among the inputs, because that would lead to
     ;; a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    ;; Tests depend on r-testthat, which depends indirectly on r-ps.
    (arguments (list #:tests? #false))
    (home-page "https://ps.r-lib.org")
    (synopsis "List, query, and manipulate system processes")
    (description
     "The ps package implements an API to list, query, and manipulate system
processes.  Most of its code is based on the @code{psutil} Python package.")
    (license license:bsd-3)))

(define-public r-pkgbuild
  (package
    (name "r-pkgbuild")
    (version "1.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pkgbuild" version))
       (sha256
        (base32 "000swh4qfd536d1qpi81xxfk161fl6j159qcbrzw1d5q08ml9pi1"))))
    (properties
     ;; We can't have r-testthat among the inputs, because that would lead to
     ;; a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    ;; Tests require r-testthat, but that package indirectly depends on
    ;; r-pkgbuild.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-callr r-cli r-desc r-processx r-r6))
    (home-page "https://github.com/r-pkgs/pkgbuild")
    (synopsis "Find tools needed to build R packages")
    (description
     "This package provides functions used to build R packages.  It locates
compilers needed to build R packages on various platforms and ensures the PATH
is configured appropriately so R can use them.")
    (license license:gpl3)))

(define-public r-pkgload
  (package
    (name "r-pkgload")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pkgload" version))
       (sha256
        (base32
         "0jbmlvii40q6ymdhislmgby6dpf9585xl9d5cf8g4nn2kig8ir09"))))
    (properties
     ;; Avoid dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    ;; Tests require r-testthat.  Adding it to the inputs would lead to a
    ;; dependency cycle.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-cli
           r-desc
           r-fs
           r-glue
           r-lifecycle
           r-pkgbuild
           r-processx
           r-rlang
           r-rprojroot
           r-withr))
    (home-page "https://github.com/r-lib/pkgload")
    (synopsis "Simulate package installation and attach")
    (description
     "This package simulates the process of installing a package and then
attaching it.  This is a key part of the @code{devtools} package as it allows
you to rapidly iterate while developing a package.")
    (license license:gpl3)))

(define-public r-pki
  (package
    (name "r-pki")
    (version "0.1-14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PKI" version))
       (sha256
        (base32 "0rkr3gf5aqkrxi134kwggsyj151nwcwndy8d8q2vfy5rfwcyh960"))))
    (properties `((upstream-name . "PKI")))
    (build-system r-build-system)
    (inputs (list openssl zlib))
    (propagated-inputs (list r-base64enc))
    (native-inputs (list pkg-config))
    (home-page "http://www.rforge.net/PKI")
    (synopsis "Public Key Infrastructure for R based on the X.509 standard")
    (description
     "This is a package containing Public Key Infrastructure functions such as
verifying certificates, RSA encryption and signing, which can be used to build
PKI infrastructure and perform cryptographic tasks.")
    ;; Either of these licenses.
    (license (list license:gpl2 license:gpl3))))

(define-public r-pvclust
  (package
   (name "r-pvclust")
   (version "2.2-0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "pvclust" version))
            (sha256
             (base32
              "0082icm54k2yq60k06qpr92a626k39j2jr0046lva4ylmhxqb4kq"))))
   (build-system r-build-system)
   (home-page "https://github.com/shimo-lab/pvclust")
   (synopsis
    "Hierarchical clustering with P-values via multiscale bootstrap resampling")
   (description "This package provides an implementation of multiscale bootstrap
resampling for assessing the uncertainty in hierarchical cluster analysis.  It
provides an AU (approximately unbiased) P-value as well as a BP (bootstrap probability)
value for each cluster in a dendrogram.")
    (license license:gpl2+)))

(define-public r-rcpp
  (package
    (name "r-rcpp")
    (version "1.0.13-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rcpp" version))
       (sha256
        (base32 "16ln8fxf4hiyg8ar588jci5i64749lhak14mkxsbb0khs8iwc7qx"))))
    (build-system r-build-system)
    (home-page "https://www.rcpp.org")
    (synopsis "Seamless R and C++ integration")
    (description
     "The Rcpp package provides R functions as well as C++ classes which offer
a seamless integration of R and C++.  Many R data types and objects can be
mapped back and forth to C++ equivalents which facilitates both writing of new
code as well as easier integration of third-party libraries.  Documentation
about Rcpp is provided by several vignettes included in this package, via the
@code{Rcpp Gallery} site at <http://gallery.rcpp.org>, the paper by Eddelbuettel
and Francois (2011, JSS), and the book by Eddelbuettel (2013, Springer); see
@code{citation(\"Rcpp\")} for details on these last two.")
    (license license:gpl2+)))

(define-public r-rcppcctz
  (package
    (name "r-rcppcctz")
    (version "0.2.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppCCTZ" version))
       (sha256
        (base32 "1wmbyaj08fbl4g47aq0mfkkvqwpah3d2j94fzc813dijxlsi847l"))))
    (properties
     `((upstream-name . "RcppCCTZ")
       (updater-extra-native-inputs . ("tzdata-for-tests"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-tinytest tzdata-for-tests))
    (home-page "https://github.com/eddelbuettel/rcppcctz")
    (synopsis "Rcpp bindings for the CCTZ library")
    (description
     "Rcpp access to the CCTZ timezone library is provided.  CCTZ is a C++
library for translating between absolute and civil times using the rules of a
time zone.  The CCTZ source code is included in this package.")
    (license (list license:gpl2+
                   license:asl2.0)))) ;for CCTZ

(define-public r-rcppdate
  (package
    (name "r-rcppdate")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppDate" version))
       (sha256
        (base32 "1cnhvbgqfcjrwm1rx6bhhj4yf4dipcp6g1hjv1qa86pmxzyjp3dn"))))
    (properties `((upstream-name . "RcppDate")))
    (build-system r-build-system)
    (home-page "https://github.com/eddelbuettel/rcppdate")
    (synopsis "date C++ header library for date and time functionality")
    (description
     "This package provides a header-only C++ library is provided with support
for dates, time zones, ISO weeks, Julian dates, and Islamic dates.
@code{date} offers extensive date and time functionality for the C++11, C++14
and C++17 standards.  A slightly modified version has been accepted (along
with @file{tz.h}) as part of C++20.  This package regroups all header files
from the upstream repository so that other R packages can use them in their
C++ code.")
    (license license:gpl2+)))

(define-public r-rcppde
  (package
    (name "r-rcppde")
    (version "0.1.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RcppDE" version))
              (sha256
               (base32
                "1846pl9gxikycdvwfgy1gw41z0fx4ycjp5p4295v8k2pgvlqw8sa"))))
    (properties `((upstream-name . "RcppDE")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo))
    (native-inputs (list r-lattice))
    (home-page "https://cran.r-project.org/package=RcppDE")
    (synopsis "Global optimization by differential evolution in C++")
    (description
     "This package provides an iteration of the @code{DEoptim} function.  It
performs global optimization by differential evolution.")
    (license license:gpl2+)))

(define-public r-rcppdist
  (package
    (name "r-rcppdist")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppDist" version))
       (sha256
        (base32 "02g57xwfipdcljv06krhm02dbqn9kfyj2km6rdg0a7vq9prwdz1x"))))
    (properties `((upstream-name . "RcppDist")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcpparmadillo))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/duckmayr/RcppDist")
    (synopsis "Integration of additional probability distributions")
    (description
     "RcppDist provides a header-only C++ library with functions for
additional statistical distributions that can be called from C++ when writing
code using Rcpp or RcppArmadillo.  Functions are available that return a
@code{NumericVector} as well as doubles, and for multivariate or matrix
distributions, Armadillo vectors and matrices.")
    (license license:gpl2+)))

(define-public r-rcppint64
  (package
    (name "r-rcppint64")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppInt64" version))
       (sha256
        (base32 "1h4lshkn3p3c7swygbpmkg0pa80xcp3f9alck5q4bmml61hicwjk"))))
    (properties `((upstream-name . "RcppInt64")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-tinytest))
    (home-page "https://github.com/eddelbuettel/rcppint64")
    (synopsis
     "Rcpp-based helper functions to pass Int64 values between R and C++")
    (description
     "@code{int64} values can be created and accessed via the @code{bit64}
package and its @code{integer64} class which package the @code{int64}
representation cleverly into a @code{double}.  The @code{nanotime} package
builds on this to support nanosecond-resolution timestamps.  This package
helps conversions between R and C++ via several helper functions provided via
a single header file.  A complete example client package is included as an
illustration.")
    (license license:gpl2+)))

(define-public r-rcppml
  (package
    (name "r-rcppml")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppML" version))
       (sha256
        (base32 "1ih8i7i6m221iw227mnl3rvnaw2l53h8fpnc4f8yn9sm10anap1j"))))
    (properties `((upstream-name . "RcppML")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-rcpp r-rcppeigen))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/zdebruine/RcppML")
    (synopsis "Rcpp machine learning library")
    (description
     "This package provides fast machine learning algorithms including matrix
factorization and divisive clustering for large sparse and dense matrices.")
    (license license:gpl2+)))

(define-public r-rcppspdlog
  (package
    (name "r-rcppspdlog")
    (version "0.0.19")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppSpdlog" version))
       (sha256
        (base32 "0micdp7y170r2k1zh6yh9dj4b6c8jv98c026xmf5mj22m1c4ly2x"))))
    (properties `((upstream-name . "RcppSpdlog")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-simplermarkdown))
    (home-page "https://github.com/eddelbuettel/rcppspdlog")
    (synopsis "R and C++ interfaces to spdlog C++ header library for logging")
    (description
     "The spdlog library is a widely-used and very capable header-only C++
library for logging.  This package includes its headers as an R package to
permit other R packages to deploy it via a simple @code{LinkingTo:
RcppSpdlog}.  As of version 0.0.9, it also provides both simple R logging
functions and compiled functions callable by other packages.")
    (license license:gpl2+)))

(define-public r-rcppthread
  (package
    (name "r-rcppthread")
    (version "2.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppThread" version))
       (sha256
        (base32
         "1s5v4fa59gmjcd0cn7q7zy67ww9zwnly4apbgr87x9qkzgzbmpl8"))))
    (properties `((upstream-name . "RcppThread")))
    (build-system r-build-system)
    ;; For unknown reasons r-r-rsp is not found when building vignettes.
    (arguments (list #:test-types '(list "tests")))
    (native-inputs (list r-r-rsp r-rcpp r-testthat))
    (home-page "https://github.com/tnagler/RcppThread")
    (synopsis "R threading in C++")
    (description
     "This package provides a C++11-style thread class and thread pool that can
safely be interrupted from R.")
    (license license:expat)))

(define-public r-rcppnumerical
  (package
    (name "r-rcppnumerical")
    (version "0.6-0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RcppNumerical" version))
              (sha256
               (base32
                "11nph9fz1bzb0pcvh6xx4cb94090ahwpj21zmbi06m4pibb1a1rg"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcppeigen))
    (native-inputs
     (list r-knitr r-rmarkdown))
    (home-page "https://github.com/yixuan/RcppNumerical")
    (synopsis"Numerical computing libraries integration with @code{Rcpp}")
    (description "This package provides a collection of libraries for numerical
computing (numerical integration, optimization, etc.) and their integration
with @code{Rcpp}.")
    (license license:gpl2+)))

(define-public r-rcppxptrutils
  (package
    (name "r-rcppxptrutils")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppXPtrUtils" version))
       (sha256
        (base32 "0hm57nf4dzgsmg4hjj6wikwjx93fgfwkmybw6ly4b58wi6qwml1l"))))
    (properties `((upstream-name . "RcppXPtrUtils")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/Enchufa2/RcppXPtrUtils")
    (synopsis "XPtr add-ons for Rcpp")
    (description
     "This package provides the means to compile user-supplied C++ functions
with Rcpp and retrieve an @code{XPtr} that can be passed to other C++
components.")
    (license license:expat)))

(define-public r-bb
  (package
    (name "r-bb")
    (version "2019.10-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BB" version))
       (sha256
        (base32 "0kf9sfsm3n036a8a8gjfpc9qdryvadb019kqjh80n1szdv7bdl04"))))
    (properties `((upstream-name . "BB")))
    (build-system r-build-system)
    ;; could not find function "latex"
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-quadprog))
    (native-inputs (list r-numderiv r-setrng))
    (home-page "https://publichealth.jhu.edu/")
    (synopsis "Solving and optimizing large-scale nonlinear systems")
    (description
     "This package implements Barzilai-Borwein spectral methods for solving
nonlinear system of equations, and for optimizing nonlinear objective
functions subject to simple constraints.")
    (license license:gpl3)))

(define-public r-bindr
  (package
    (name "r-bindr")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bindr" version))
       (sha256
        (base32
         "1l05fpk2yql3jka321c0bdgx6mqq9pvfrg2844lbjfpbgjkmqy3w"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/krlmlr/bindr")
    (synopsis "Parametrized active bindings")
    (description
     "This package provides a simple interface for creating active bindings
where the bound function accepts additional arguments.")
    (license license:expat)))

(define-public r-bindrcpp
  (package
    (name "r-bindrcpp")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bindrcpp" version))
       (sha256
        (base32
         "1yn9is89r76ay314s216whr0igych4r78kjz85amhwgfb9wawbb6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bindr r-plogr r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/krlmlr/bindrcpp")
    (synopsis "Rcpp interface to active bindings")
    (description
     "This package provides an easy way to fill an environment with active
bindings that call a C++ function.")
    (license license:expat)))

(define-public r-auc
  (package
    (name "r-auc")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AUC" version))
       (sha256
        (base32
         "07xf47kypqbsg2mixmq6mnh4s89aqan9bgl6kfv6lbx8ajv2asw3"))))
    (properties `((upstream-name . "AUC")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/AUC")
    (synopsis "Compute the area under the curve of selected measures")
    (description
     "This package includes functions to compute the area under the curve of
selected measures: the area under the sensitivity curve (AUSEC), the area
under the specificity curve (AUSPC), the area under the accuracy
curve (AUACC), and the area under the receiver operating characteristic
curve (AUROC).  The curves can also be visualized.  Support for partial areas
is provided.")
    (license license:gpl2+)))

(define-public r-audio
  (package
    (name "r-audio")
    (version "0.1-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "audio" version))
       (sha256
        (base32 "0z719jxmfzmh6c885m1yixjzdsl1wy17s1sw2hp4ppz4bcrzclhh"))))
    (properties `((upstream-name . "audio")))
    (build-system r-build-system)
    (native-inputs (list pkg-config))
    (home-page "http://www.rforge.net/audio/")
    (synopsis "Audio interface for R")
    (description
     "This package provides interfaces to audio devices (mainly sample-based)
from R to allow recording and playback of audio.")
    (license license:expat)))

(define-public r-calibrate
  (package
    (name "r-calibrate")
    (version "1.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "calibrate" version))
       (sha256
        (base32 "19kgrnsyq67iqv1biyssqi30a6v2836ql20nabpy2m692ns0jfvi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/calibrate")
    (synopsis "Calibration of scatterplot and biplot axes")
    (description
     "This is a package for drawing calibrated scales with tick marks
on (non-orthogonal) variable vectors in scatterplots and biplots.")
    (license license:gpl2)))

(define-public r-calibrator
  (package
    (name "r-calibrator")
    (version "1.2-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "calibrator" version))
       (sha256
        (base32 "1m9g1pmnr6d9jkg5ab0l0cbqfj7kmx7sdmcdqdhn9ifyhhn7812y"))))
    (properties `((upstream-name . "calibrator")))
    (build-system r-build-system)
    (propagated-inputs (list r-cubature r-emulator r-mvtnorm))
    (home-page "https://github.com/RobinHankin/calibrator.git")
    (synopsis "Bayesian calibration of complex computer codes")
    (description
     "This package performs Bayesian calibration of computer models as per
Kennedy and O'Hagan 2001.  The package includes routines to find the
hyperparameters and parameters; see the help page for @code{stage1()} for a
worked example using the toy dataset.  A tutorial is provided in the
@file{calex.Rnw} vignette; and a suite of especially simple one dimensional
examples appears in @file{inst/doc/one.dim/}.")
    (license license:gpl2)))

(define-public r-shape
  (package
    (name "r-shape")
    (version "1.4.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shape" version))
       (sha256
        (base32
         "1912znpk85j8c01s4m2f7x8rcqwski8b5n7g70cczmkzk47vvya3"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/shape")
    (synopsis "Functions for plotting graphical shapes")
    (description
     "This package provides functions for plotting graphical shapes such as
ellipses, circles, cylinders, arrows, ...")
    (license license:gpl3+)))

(define-public r-globaloptions
  (package
    (name "r-globaloptions")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GlobalOptions" version))
       (sha256
        (base32 "0gkm77w6db9ajyncy1xdcivplap06a51zi99m009kylccschd2a7"))))
    (properties `((upstream-name . "GlobalOptions")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/jokergoo/GlobalOptions")
    (synopsis "Generate functions to get or set global options")
    (description
     "This package provides more controls on the option values such as
validation and filtering on the values, making options invisible or private.")
    (license license:gpl2+)))

(define-public r-circlize
  (package
    (name "r-circlize")
    (version "0.4.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "circlize" version))
       (sha256
        (base32
         "0rqbcmmp4h1jjl0y59bzn6k8kywjdqwvp0ajkqxd21j9f33k5p0n"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-globaloptions r-shape))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/jokergoo/circlize")
    (synopsis "Circular visualization")
    (description
     "Circular layout is an efficient way to visualise huge amounts of
information.  This package provides an implementation of circular layout
generation in R as well as an enhancement of available software.  Its
flexibility is based on the usage of low-level graphics functions such that
self-defined high-level graphics can be easily implemented by users for
specific purposes.  Together with the seamless connection between the powerful
computational and visual environment in R, it gives users more convenience and
freedom to design figures for better understanding complex patterns behind
multi-dimensional data.")
    (license license:gpl2+)))

(define-public r-rcircos
  (package
    (name "r-rcircos")
    (version "1.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RCircos" version))
              (sha256
               (base32
                "1z0aam60p1b6q7csn50rrwdilm07myr05bw54s9ah8idzyxc7gav"))))
    (properties `((upstream-name . "RCircos")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/RCircos/")
    (synopsis "Circos 2D track plot")
    (description
     "This package provides a simple and flexible way to generate Circos 2D
track plot images.  The types of plots include: heatmap, histogram, lines,
scatterplot, tiles and plot items for further decorations include connector,
link (lines and ribbons), and text (gene) label.  All functions require only R
graphics packages that comes with the base installation.")
    (license license:gpl2+)))

(define-public r-ctrdata
  (package
    (name "r-ctrdata")
    (version "1.19.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ctrdata" version))
              (sha256
               (base32
                "0pjsfnl1v6a6cs6hny092jby750l5br7fdzws9lnly0iky1lf55g"))))
    (properties `((upstream-name . "ctrdata")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Needed for vignettes
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-clipr
           r-countrycode
           r-curl
           r-digest
           r-dplyr
           r-httr
           r-jqr
           r-jsonlite
           r-lubridate
           r-nodbi
           r-readr
           r-stringi
           r-tibble
           r-v8
           r-xml2
           r-zip))
    (native-inputs (list r-r-rsp))
    (home-page "https://cran.r-project.org/package=ctrdata")
    (synopsis "Retrieve and analyze clinical trials in public registers")
    (description
     "This package provides a system for querying, retrieving and analyzing
protocol- and results-related information on clinical trials from three public
registers, the European Union Clinical Trials Register (EUCTR),
ClinicalTrials.gov (CTGOV) and the ISRCTN.  Trial information is downloaded,
converted and stored in a database.  Functions are included to identify
deduplicated records, to easily find and extract variables (fields) of
interest even from complex nesting as used by the registers, and to update
previous queries.  The package can be used for meta-analysis and
trend-analysis of the design and conduct as well as for results of clinical
trials.")
    (license license:expat)))

(define-public r-ctrialsgov
  (package
    (name "r-ctrialsgov")
    (version "0.2.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ctrialsgov" version))
              (sha256
               (base32
                "0hdh1fdfaja8amf7fkvk1c6yif703132bvacq0j9pk5jr97czgpw"))))
    (properties `((upstream-name . "ctrialsgov")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dbi
           r-dplyr
           r-ggplot2
           r-htmlwidgets
           r-lubridate
           r-matrix
           r-plotly
           r-purrr
           r-rlang
           r-stringi
           r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=ctrialsgov")
    (synopsis
     "Query data from U.S. National Library of Medicine's Clinical Trials Database")
    (description
     "This package provides tools to query the U.S. National Library of
Medicine's Clinical Trials database.  Functions are provided for a variety of
techniques for searching the data using range queries, categorical filtering,
and by searching for full-text keywords.  Minimal graphical tools are also
provided for interactively exploring the constructed data.")
    (license license:expat)))

(define-public r-powerlaw
  (package
    (name "r-powerlaw")
    (version "0.80.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "poweRlaw" version))
       (sha256
        (base32 "1jvj2x22h6px1rcxmpz9h3x8r4486sb8zl3hjrsdxqa73ypmcdbi"))))
    (properties `((upstream-name . "poweRlaw")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-pracma))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/csgillespie/poweRlaw")
    (synopsis "Tools for the analysis of heavy tailed distributions")
    (description
     "This package provides an implementation of maximum likelihood estimators
for a variety of heavy tailed distributions, including both the discrete and
continuous power law distributions.  Additionally, a goodness-of-fit based
approach is used to estimate the lower cut-off for the scaling region.")
    ;; Any of these GPL versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-ptw
  (package
    (name "r-ptw")
    (version "1.9-16")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ptw" version))
              (sha256
               (base32
                "0rma3h9ksc5qigdvk5vappb4ipd4rpk64wckzcxvxspakr5w71vy"))))
    (properties `((upstream-name . "ptw")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcppde))
    (home-page "https://github.com/rwehrens/ptw")
    (synopsis "Parametric time warping")
    (description
     "Parametric time warping aligns patterns.  It aims to put corresponding
features at the same locations.  The algorithm searches for an optimal
polynomial describing the warping.  It is possible to align one sample to a
reference, several samples to the same reference, or several samples to
several references.  One can choose between calculating individual warpings,
or one global warping for a set of samples and one reference.  Two
optimization criteria are implemented: @acronym{RMS, Root Mean Square} error
and @acronym{WCC, Weighted Cross Correlation}.  Both warping of peak profiles
and of peak lists are supported.")
    (license license:gpl2+)))

(define-public r-compare
  (package
    (name "r-compare")
    (version "0.2-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "compare" version))
       (sha256
        (base32
         "0k9zms930b5dz9gy8414li21wy0zg9x9vp7301v5cvyfi0g7xzgw"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/compare")
    (synopsis "Comparing objects for differences")
    (description
     "This package provides functions to compare a model object to a
comparison object.  If the objects are not identical, the functions can be
instructed to explore various modifications of the objects (e.g., sorting
rows, dropping names) to see if the modified versions are identical.")
    (license license:gpl2+)))

(define-public r-dendextend
  (package
    (name "r-dendextend")
    (version "1.18.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dendextend" version))
       (sha256
        (base32
         "05x5sn6l45a3wzahbzqbx1qwxx2fqaps8qmd1hhrk4ryly9s51wx"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-magrittr r-viridis))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/web/packages/dendextend")
    (synopsis "Extending 'dendrogram' functionality in R")
    (description
     "This package offers a set of functions for extending @code{dendrogram}
objects in R, letting you visualize and compare trees of hierarchical
clusterings.  You can adjust a tree's graphical parameters (the color, size,
type, etc of its branches, nodes and labels) and visually and statistically
compare different dendrograms to one another.")
    ;; Any of these versions
    (license (list license:gpl2 license:gpl3))))

(define-public r-dendsort
  (package
    (name "r-dendsort")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dendsort" version))
       (sha256
        (base32 "0rs7y471wrhkgibxdmfh5xhp3pa004rrlm2w08b6qli5gq4im5d2"))))
    (properties `((upstream-name . "dendsort")))
    (build-system r-build-system)
    ;; Tests fail with: could not find function "context"
    (arguments (list #:tests? #false))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/evanbiederstedt/dendsort")
    (synopsis "Modular leaf ordering methods for dendrogram nodes")
    (description
     "This package represents an implementation of functions to optimize
ordering of nodes in a dendrogram, without affecting the meaning of the
dendrogram.  A dendrogram can be sorted based on the average distance of
subtrees, or based on the smallest distance value.  These sorting methods
improve readability and interpretability of tree structure, especially for
tasks such as comparison of different distance measures or linkage types and
identification of tight clusters and outliers.  As a result, it also
introduces more meaningful reordering for a coupled heatmap visualization.")
    ;; Any of these versions
    (license (list license:gpl2 license:gpl3))))

(define-public r-getoptlong
  (package
    (name "r-getoptlong")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GetoptLong" version))
       (sha256
        (base32
         "00fpm6nd3kqa2ikasxa62jzywi46fvvmx1mdavcp5yrxxn37j8wc"))))
    (properties `((upstream-name . "GetoptLong")))
    (build-system r-build-system)
    (inputs
     (list perl))
    (propagated-inputs
     (list r-crayon r-globaloptions r-rjson))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/jokergoo/GetoptLong")
    (synopsis "Parsing command-line arguments and variable interpolation")
    (description
     "This is yet another command-line argument parser which wraps the
powerful Perl module @code{Getopt::Long} and with some adaptation for easier
use in R.  It also provides a simple way for variable interpolation in R.")
    (license license:gpl2+)))

(define-public r-fastmatch
  (package
    (name "r-fastmatch")
    (version "1.1-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastmatch" version))
       (sha256
        (base32
         "0symkcmyrqvz6hkawr40ga808rb3w4hy9ssfsi5ri8hykjn4r4cs"))))
    (build-system r-build-system)
    (home-page "https://www.rforge.net/fastmatch")
    (synopsis "Fast match function")
    (description
     "This package provides a fast @code{match} replacement for cases that
require repeated look-ups.  It is slightly faster that R's built-in
@code{match} function on first match against a table, but extremely fast on
any subsequent lookup as it keeps the hash table in memory.")
    (license license:gpl2)))

(define-public r-ff
  (package
    (name "r-ff")
    (version "4.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ff" version))
       (sha256
        (base32
         "13hq86rmcvlz46v9airb8imj183s1z7fyzfcr3s1ma1wm5991v9a"))))
    (build-system r-build-system)
    (propagated-inputs (list r-bit))
    (native-inputs (list r-testthat))
    (home-page "https://ff.r-forge.r-project.org/")
    (synopsis "Memory-efficient storage of large data on disk and access functions")
    (description
     "This package provides data structures that are stored on disk but
behave (almost) as if they were in RAM by transparently mapping only a section
in main memory.")
    ;; error Architecture not supported.
    (supported-systems (delete "aarch64-linux" %supported-systems))
    (license license:gpl2)))

(define-public r-ffbase
  (package
    (name "r-ffbase")
    (version "0.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ffbase" version))
       (sha256
        (base32
         "1dp6lblfq2j7r1b4b8ls47jlx8j27n88d5vp8w116lb8pa01zxmk"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; R 4.3.0 removed the typedef for Sint, which used to be just int.
         (add-after 'unpack 'r-compatibility
           (lambda _
             (substitute* '("src/grouprunningcumsum.c"
                            "src/grouprunningcumsumindex.c")
               (("\\bSint ") "int ")))))))
    (propagated-inputs
     (list r-bit r-fastmatch r-ff))
    (native-inputs (list r-laf r-testthat))
    (home-page "https://github.com/edwindj/ffbase")
    (synopsis "Basic statistical functions for package 'ff'")
    (description
     "This package extends the out of memory vectors of @code{ff} with
statistical functions and other utilities to ease their usage.")
    (license license:gpl3)))

(define-public r-prettyunits
  (package
    (name "r-prettyunits")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prettyunits" version))
       (sha256
        (base32
         "1smcxrfsz6cxym9h8iaiqrrw5bzp2bbpmf05zr8y70jw59zg4ngh"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/gaborcsardi/prettyunits")
    (synopsis "Pretty, human readable formatting of quantities")
    (description
     "This package provides tools for pretty, human readable formatting of
quantities.")
    (license license:expat)))

(define-public r-princurve
  (package
   (name "r-princurve")
   (version "2.1.6")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "princurve" version))
            (sha256
             (base32
              "0wzk329bxljkzz57y220lsfckpsn45w348m6dcxh29zbj0ik65h2"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-rcpp))
   (native-inputs (list r-testthat))
   (home-page "https://github.com/rcannood/princurve")
   (synopsis "Fit a principal curve in arbitrary dimension")
   (description "This package provides procedures for fitting a principal
curve to a data matrix in arbitrary dimensions.")
   (license license:gpl2)))

(define-public r-prismatic
  (package
    (name "r-prismatic")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "prismatic" version))
              (sha256
               (base32
                "0qg2f5d7sz6q0ijrrdmjhp1msx9n77wndphrqqhjkdf9six5pgxs"))))
    (properties `((upstream-name . "prismatic")))
    (build-system r-build-system)
    (propagated-inputs (list r-farver))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/EmilHvitfeldt/prismatic")
    (synopsis "Color manipulation tools")
    (description
     "Manipulate and visualize colors in a intuitive, low-dependency and functional
way.")
    (license license:expat)))

(define-public r-reshape
  (package
    (name "r-reshape")
    (version "0.8.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reshape" version))
       (sha256
        (base32
         "0j203qmc076x5lp6q2xi4dq4xdb73jmsa42rpxp1c37knnrph4br"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr))
    (home-page "http://had.co.nz/reshape")
    (synopsis "Flexibly reshape data")
    (description
     "Flexibly restructure and aggregate data using just two functions:
@code{melt} and @code{cast}.  This package provides them.")
    (license license:expat)))

(define-public r-restrserve
  (package
    (name "r-restrserve")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RestRserve" version))
       (sha256
        (base32 "0d5ppgasaqpgvdi1spxlhp4ywpafbphlhkqfcfvgxrdm6y9igl2c"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-checkmate
           r-digest
           r-jsonlite
           r-mime
           r-r6
           r-rcpp
           r-rserve
           r-uuid))
    (native-inputs
     (list r-knitr))
    (home-page "https://restrserve.org")
    (synopsis "R web API framework")
    (description
     "RestRserve is an R web API framework for building high-performance AND
robust microservices and app backends.  With Rserve backend on UNIX-like
systems it is parallel by design.  It will handle incoming requests in
parallel - each request in a separate fork.")
    (license license:gpl2+)))

(define-public r-progress
  (package
    (name "r-progress")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "progress" version))
       (sha256
        (base32
         "0xljky4ad2jbbcfrcyh48li461pc5b2wk210n4x5rs2di6dhfaza"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon r-hms r-prettyunits r-r6))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/gaborcsardi/progress")
    (synopsis "Terminal progress bars")
    (description
     "This package provides configurable progress bars.  They may include
percentage, elapsed time, and/or the estimated completion time.  They work in
terminals, in Emacs ESS, RStudio, Windows Rgui, and the macOS R.app.  The
package also provides a C++ API, that works with or without Rcpp.")
    (license license:expat)))

(define-public r-ggally
  (package
    (name "r-ggally")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GGally" version))
       (sha256
        (base32
         "1il6yphqxcyj1039imi8pn6ygyni24daz8ljxxp3z9inb5k2dcwb"))))
    (properties `((upstream-name . "GGally")))
    (build-system r-build-system)
    (inputs
     (list openssl))
    (propagated-inputs
     (list r-dplyr
           r-ggplot2
           r-ggstats
           r-gtable
           r-lifecycle
           r-magrittr
           r-plyr
           r-progress
           r-rcolorbrewer
           r-rlang
           r-scales
           r-tidyr))
    (native-inputs (list r-survival r-testthat r-vdiffr))
    (home-page "https://ggobi.github.io/ggally")
    (synopsis "Extension to ggplot2")
    (description
     "The R package ggplot2 is a plotting system based on the grammar of
graphics.  GGally extends ggplot2 by adding several functions to reduce the
complexity of combining geometric objects with transformed data.  Some of
these functions include a pairwise plot matrix, a two group pairwise plot
matrix, a parallel coordinates plot, a survival plot, and several functions to
plot networks.")
    (license license:gpl2+)))

(define-public r-proxy
  (package
    (name "r-proxy")
    (version "0.4-27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "proxy" version))
       (sha256
        (base32
         "0gsng2aggnljl4z82la9hpnd26hngzhj8fizx4wx22npqjj93694"))))
    (build-system r-build-system)
    ;; Some tests need the r-cba package, which depends on r-proxy.
    (arguments (list #:tests? #false))
    (home-page "https://cran.r-project.org/web/packages/proxy")
    (synopsis "Distance and similarity measures")
    (description
     "This package provides an extensible framework for the efficient
calculation of auto- and cross-proximities, along with implementations of the
most popular ones.")
    (license license:gpl2)))

(define-public r-sp
  (package
    (name "r-sp")
    (version "2.1-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sp" version))
       (sha256
        (base32 "02lz8wcx16ay3zdqhdb57847i9qg2wzajrfp1z2xpmyjc7xyg1g1"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/sp")
    (synopsis "Classes and methods for spatial data")
    (description
     "This package provides classes and methods for spatial data; the classes
document where the spatial location information resides, for 2D or 3D data.
Utility functions are provided, e.g. for plotting data as maps, spatial
selection, as well as methods for retrieving coordinates, for subsetting,
print, summary, etc.")
    (license license:gpl2+)))

(define-public r-lambertw
  (package
    (name "r-lambertw")
    (version "0.6.9-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "LambertW" version))
              (sha256
               (base32
                "19j6vjhywyzmrf7rsrx5kf0hg8cpk1gn8al24q813jzp0vsv9ljj"))))
    (properties `((upstream-name . "LambertW")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2
                             r-lamw
                             r-mass
                             r-rcolorbrewer
                             r-rcpp
                             r-reshape2))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=LambertW")
    (synopsis
     "Probabilistic models to analyze and Gaussianize heavy-tailed, skewed data")
    (description
     "Lambert W x F distributions are a generalized framework to analyze skewed,
heavy-tailed data.  It is based on an input/output system, where the output
random variable (RV) Y is a non-linearly transformed version of an input RV X
~ F with similar properties as X, but slightly skewed (heavy-tailed).  The
transformed RV Y has a Lambert W x F distribution.  This package contains
functions to model and analyze skewed, heavy-tailed data the Lambert Way:
simulate random samples, estimate parameters, compute quantiles, and plot/
print results nicely.  The most useful function is @code{Gaussianize}, which
works similarly to @code{scale}, but actually makes the data Gaussian.  A
do-it-yourself toolkit allows users to define their own Lambert W x
@code{MyFavoriteDistribution} and use it in their analysis right away.")
    (license license:gpl2+)))

(define-public r-lamw
  (package
    (name "r-lamw")
    (version "2.2.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "lamW" version))
              (sha256
               (base32
                "1h1plx9d6kzgdv20sx7pjfkz54jw11pkqrspgw4hh1kgk6hpbgsz"))))
    (properties `((upstream-name . "lamW")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcppparallel))
    (home-page "https://github.com/aadler/lamW")
    (synopsis "Lambert-W function")
    (description
     "This package implements both real-valued branches of the Lambert-W
function (Corless et al, 1996) <doi:10.1007/BF02124750> without the need for
installing the entire GSL.")
    (license license:bsd-2)))

(define-public r-laplacesdemon
  (package
    (name "r-laplacesdemon")
    (version "16.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "LaplacesDemon" version))
       (sha256
        (base32 "1dsfp65cg06f25zjzd5ib4qyn1alfhbhpgyvpcw5n6bszn13idap"))))
    (properties `((upstream-name . "LaplacesDemon")))
    (build-system r-build-system)
    (home-page "https://github.com/LaplacesDemonR/LaplacesDemon")
    (synopsis "Complete environment for Bayesian inference")
    (description
     "This package provides a complete environment for Bayesian inference using
a variety of different samplers.")
    (license license:expat)))

(define-public r-rmapshaper
  (package
    (name "r-rmapshaper")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmapshaper" version))
       (sha256
        (base32 "01c1sd02ws3k2dmlj964c4j5jg93x192s3brhmaw4pi4qfjzc21x"))
       (snippet
        '(delete-file "inst/mapshaper/mapshaper-browserify.min.js"))))
    (properties `((upstream-name . "rmapshaper")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils)
        (ice-9 match))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      '(modify-phases (@ (guix build r-build-system) %standard-phases)
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/"
               (for-each (match-lambda
                           ((source . target)
                            (minify source #:target target)))
                         '(("mapshaper/mapshaper-browserify.js"
                            . "mapshaper/mapshaper-browserify.min.js")))))))))
    (propagated-inputs (list r-geojsonsf
                             r-jsonify
                             r-readr
                             r-sf
                             r-sp
                             r-v8))
    (native-inputs (list esbuild r-knitr r-testthat))
    (home-page "https://github.com/ateucher/rmapshaper")
    (synopsis "Client for mapshaper for geospatial operations")
    (description
     "This package lets you edit and simplify @code{geojson}, @code{Spatial},
and @code{sf} objects.  This is a wrapper around the @code{mapshaper}
JavaScript library to perform topologically-aware polygon simplification, as
well as other operations such as clipping, erasing, dissolving, and converting
multi-part to single-part geometries.")
    (license license:expat)))

(define-public r-rmariadb
  (package
    (name "r-rmariadb")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RMariaDB" version))
       (sha256
        (base32 "0b8qqg4pgz5fm21zp3jslrgmx0100rhg27lxpia3yl514pdnyvy6"))))
    (properties
     `((upstream-name . "RMariaDB")
       (updater-extra-inputs . ("mariadb"))))
    (build-system r-build-system)
    (inputs (list `(,mariadb "lib") `(,mariadb "dev") openssl zlib))
    (native-inputs (list r-testthat))
    (propagated-inputs (list r-bit64
                             r-blob
                             r-cpp11
                             r-dbi
                             r-hms
                             r-lubridate
                             r-plogr
                             r-rlang))
    (home-page "https://rmariadb.r-dbi.org")
    (synopsis "Database interface and MariaDB driver")
    (description
     "This package implements a DBI-compliant interface to @code{MariaDB} and
@code{MySQL} databases.")
    (license license:expat)))

(define-public r-rmdfiltr
  (package
    (name "r-rmdfiltr")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmdfiltr" version))
       (sha256
        (base32 "05czq9nvs66zd8wgmy5bvk0k1qfspf3imwxs25gn4d3w188klhnv"))))
    (properties `((upstream-name . "rmdfiltr")))
    (build-system r-build-system)
    (inputs (list pandoc))
    (propagated-inputs (list r-assertthat r-rmarkdown))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/crsh/rmdfiltr")
    (synopsis "Lua filters for R Markdown")
    (description
     "This package provides a collection of Lua filters that extend the
functionality of R Markdown templates (e.g., count words or post-process
citations).")
    (license license:expat)))

(define-public r-rmtstat
  (package
    (name "r-rmtstat")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RMTstat" version))
       (sha256
        (base32
         "1r1a2sdqv64m9cpm2pz6r8abf7l810126ayd8iq3gx86c7bjfj5v"))))
    (properties `((upstream-name . "RMTstat")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/RMTstat")
    (synopsis "Distributions, statistics and tests derived from random matrix theory")
    (description
     "This package provides functions for working with the Tracy-Widom laws
and other distributions related to the eigenvalues of large Wishart
matrices.")
    (license license:bsd-3)))

(define-public r-rmpi
  (package
    (name "r-rmpi")
    (version "0.7-2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "Rmpi" version))
              (sha256
               (base32
                "1fzd9r49jx1xgrn714av7riypafs401mxcggwj2l0wkhi6i3jq50"))))
    (properties
     `((upstream-name . "Rmpi")
       (updater-extra-inputs . ("openmpi"))))
    (build-system r-build-system)
    (arguments
     (list
      #:configure-flags '(list "--configure-args=\"--with-Rmpi-type=OPENMPI\"")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'mpi-setup
            #$%openmpi-setup))))
    (inputs
     (list openmpi))
    (native-inputs
     (list pkg-config))
    (home-page "http://www.stats.uwo.ca/faculty/yu/Rmpi")
    (synopsis "R interface to message-passing interface (MPI)")
    (description
     "This package provides an interface (wrapper) to MPI APIs.  It also
provides an interactive R manager and worker environment.")
    (license license:gpl2+)))

(define-public r-rmumps
  (package
    (name "r-rmumps")
    (version "5.2.1-30")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmumps" version))
       (sha256
        (base32 "0mz6dmb16dd8pflyd29ikj0wjlfbp4ri3xvc3fgmh26v1mvvaic4"))))
    (properties
     `((upstream-name . "rmumps")
       (updater-extra-inputs . ("zlib"))))
    (build-system r-build-system)
    (inputs (list zlib))
    (propagated-inputs (list r-rcpp))
    (native-inputs (list gfortran r-matrix r-slam r-testthat))
    (home-page "https://www.mumps-solver.org/")
    (synopsis "Wrapper for MUMPS library")
    (description
     "Some basic features of @acronym{MUMPS, Multifrontal Massively Parallel
sparse direct Solver} are wrapped in a class whose methods can be used for
sequentially solving a sparse linear system (symmetric or not) with one or
many right hand sides (dense or sparse).  There is a possibility to do
separately symbolic analysis, LU (or LDL^t) factorization and system solving.
Third part ordering libraries are included and can be used: PORD, METIS,
SCOTCH.")
    (license license:gpl2+)))

(define-public r-lmoments
  (package
    (name "r-lmoments")
    (version "1.3-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Lmoments" version))
       (sha256
        (base32
         "0pc63bj9a8hzr5m3yssrc4kin39fffwkl8rggs3sagzr12d4i7bw"))))
    (properties `((upstream-name . "Lmoments")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo))
    (home-page "http://www.tilastotiede.fi/juha_karvanen.html")
    (synopsis "L-moments and quantile mixtures")
    (description
     "This package contains functions to estimate L-moments and trimmed
L-moments from the data.  It also contains functions to estimate the
parameters of the normal polynomial quantile mixture and the Cauchy polynomial
quantile mixture from L-moments and trimmed L-moments.")
    (license license:gpl2)))

(define-public r-distillery
  (package
    (name "r-distillery")
    (version "1.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "distillery" version))
       (sha256
        (base32
         "1ymmxyamkq0zbz2m4gllln1ihks2hcib6gs0mls92as79srz122b"))))
    (build-system r-build-system)
    (home-page "https://ral.ucar.edu/staff/ericg/")
    (synopsis "Functions for confidence intervals and object information")
    (description
     "This package provides some very simple method functions for confidence
interval calculation and to distill pertinent information from a potentially
complex object; primarily used in common with the packages extRemes and
SpatialVx.")
    (license license:gpl2+)))

(define-public r-etrunct
  (package
   (name "r-etrunct")
   (version "0.1")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "etrunct" version))
            (sha256
             (base32
              "0ayazgyqlc8jcqr03cwfmfhm4pck6xri1r6vkgqy4arqkrrnrcqr"))))
   (properties `((upstream-name . "etrunct")))
   (build-system r-build-system)
   (native-inputs (list r-testthat))
   (home-page "https://cran.r-project.org/web/packages/etrunct")
   (synopsis "Computes moments of univariate truncated T distribution")
   (description "This package computes moments of univariate truncated
T distribution.  There is only one exported function, @code{e_trunct},
which should be seen for details.")
   (license license:expat)))

(define-public r-evd
  (package
    (name "r-evd")
    (version "2.3-7.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "evd" version))
       (sha256
        (base32 "0y0vd2q3bjq3kwm5qlya57ijkpdipwfpgv7xs1014gdm6g639l8s"))))
    (properties `((upstream-name . "evd")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=evd")
    (synopsis "Functions for extreme value distributions")
    (description
     "This package extends simulation, distribution, quantile and density
functions to univariate and multivariate parametric extreme value distributions,
and provides fitting functions which calculate maximum likelihood estimates for
univariate and bivariate maxima models, and for univariate and bivariate
threshold models.")
    (license license:gpl3)))

(define-public r-evmix
  (package
    (name "r-evmix")
    (version "2.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "evmix" version))
       (sha256
        (base32 "02rabc9snci00s1x7h0svfr66lmw1wjcdg0149wc52mnccsdaivf"))))
    (properties `((upstream-name . "evmix")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gsl
           r-mass
           r-sparsem))
    (home-page "http://www.math.canterbury.ac.nz/~c.scarrott/evmix.shtml")
    (synopsis
     "Extreme value threshold estimation and uncertainty quantification")
    (description
     "This package provides the usual distribution functions, maximum likelihood
inference and model diagnostics for univariate stationary extreme value mixture
models.  Also, there are provided kernel density estimation including various
boundary corrected kernel density estimation methods and a wide choice of kernels,
with cross-validation likelihood based bandwidth estimator.  Reasonable
consistency with the base functions in the evd package is provided, so that users
can safely interchange most code.")
    (license license:gpl3)))

;; This package contains minified JavaScript: jExcel CE Spreadsheet,
;; version 3.9.1.  It is not clear how to obtain this particular
;; version as there is no tag for 3.9.1.  There only is 3.6.1 and
;; 4.2.0 at https://github.com/jspreadsheet/ce.
(define-public r-excelr
  (package
    (name "r-excelr")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "excelR" version))
       (sha256
        (base32 "1pb4sy54zjv5vrh7gjjv7qlpab74km6mfsmfyl0yhmr0jx01hrw0"))
       (snippet
        '(delete-file "inst/htmlwidgets/lib/jexcel/js/jexcel.min.js"))))
    (properties `((upstream-name . "excelR")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'process-javascript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "inst/htmlwidgets/lib/jexcel/js"
                (minify (search-input-file inputs "/dist/jexcel.js")
                        #:target "jexcel.min.js")))))))
    (propagated-inputs (list r-htmlwidgets r-jsonlite))
    (native-inputs
     (list esbuild
           ;; There is no tag for this particular commit, but comparison of
           ;; the contents of the JavaScript files point to this commit as the
           ;; most likely source.
           (let* ((commit "8af1960f76e6803bebc5750013d2ebe95354e88a")
                  (version (git-version "3.9.1" "0" commit)))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/jspreadsheet/ce")
                     (commit commit)))
               (file-name (git-file-name "jexcel" version))
               (sha256
                (base32
                 "1zk0wc4h0vax7zgimhwqq2icrvjr84agm3qv42l16gim7gq7fqfq"))))
           r-testthat))
    (home-page "https://github.com/Swechhya/excelR")
    (synopsis "Wrapper of the JavaScript library jExcel")
    (description
     "This package provides an R interface to the jExcel library to create
web-based interactive tables and spreadsheets compatible with spreadsheet
software.")
    (license license:expat)))

(define-public r-extremes
  (package
    (name "r-extremes")
    (version "2.1-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "extRemes" version))
       (sha256
        (base32
         "12mphdq9zi0r07x3gpj5dg4687hwnjx42d9a392rjbbsgvv2r96f"))))
    (properties `((upstream-name . "extRemes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-distillery r-lmoments))
    (home-page "https://www.assessment.ucar.edu/toolkit/")
    (synopsis "Extreme value analysis")
    (description
     "ExtRemes is a suite of functions for carrying out analyses on the
extreme values of a process of interest; be they block maxima over long blocks
or excesses over a high threshold.")
    (license license:gpl2+)))

(define-public r-lmtest
  (package
    (name "r-lmtest")
    (version "0.9-40")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmtest" version))
       (sha256
        (base32
         "15yr2kx08wy085bnziqmj1p6hf9mg3qp2a8465jk2df6di6hsh34"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-zoo))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/lmtest")
    (synopsis "Testing linear regression models")
    (description
     "This package provides a collection of tests, data sets, and examples for
diagnostic checking in linear regression models.  Furthermore, some generic
tools for inference in parametric models are provided.")
    ;; Either version is okay
    (license (list license:gpl2 license:gpl3))))

(define-public r-idr
  (package
    (name "r-idr")
    (version "1.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "idr" version))
              (sha256
               (base32
                "1r6icxf0c0y9wvihwmkk5xqscr1qhacqk3w2076kjm2993f10fbb"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/idr/")
    (synopsis "Irreproducible discovery rate")
    (description
     "This is a package for estimating the copula mixture model and plotting
correspondence curves in \"Measuring reproducibility of high-throughput
experiments\" (2011), Annals of Applied Statistics, Vol. 5, No. 3, 1752-1779,
by Li, Brown, Huang, and Bickel")
    (license license:gpl2+)))

(define-public r-imola
  (package
    (name "r-imola")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "imola" version))
       (sha256
        (base32 "087zdzn1vkyvqrdlwnackr6jyacrhg69q4b77s8z477kplickw8x"))))
    (properties `((upstream-name . "imola")))
    (build-system r-build-system)
    (propagated-inputs (list r-glue
                             r-htmltools
                             r-magrittr
                             r-shiny
                             r-stringi
                             r-yaml))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/pedrocoutinhosilva/imola")
    (synopsis "CSS layouts (grid and flexbox) for R/Shiny")
    (description
     "This package allows users to create CSS grid and flexbox layouts for
R/Shiny without needing to write custom CSS.")
    (license license:expat)))

(define-public r-inext
  (package
    (name "r-inext")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "iNEXT" version))
       (sha256
        (base32 "1nf4jhwqx5im966qzq7si78c5q4jgsa73d74ya8q8aj02n49jcyy"))))
    (properties `((upstream-name . "iNEXT")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-rcpp r-reshape2))
    (native-inputs (list r-knitr r-testthat))
    (home-page "http://chao.stat.nthu.edu.tw/wordpress/software_download/")
    (synopsis "Interpolation and extrapolation for species diversity")
    (description
     "This package provides simple functions to compute and plot two types
(sample-size- and coverage-based) rarefaction and extrapolation curves for
species diversity (Hill numbers) based on individual-based abundance data or
sampling-unit- based incidence data; see Chao and others (2014, Ecological
Monographs) for pertinent theory and methodologies, and Hsieh, Ma and Chao
(2016, Methods in Ecology and Evolution) for an introduction of the R
package.")
    (license license:gpl3+)))

(define-public r-inline
  (package
    (name "r-inline")
    (version "0.3.20")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "inline" version))
              (sha256
               (base32
                "0102axl0481z1fnkm9xcjswa9mrjwwi5fkfp8ja6iqighxfszi3j"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/inline")
    (synopsis "Functions to inline C, C++, Fortran function calls from R")
    (description
     "This package provides functionality to dynamically define R functions
and S4 methods with inlined C, C++ or Fortran code supporting @code{.C} and
@code{.Call} calling conventions.")
    ;; Any version of the LGPL.
    (license license:lgpl3+)))

(define-public r-inum
  (package
    (name "r-inum")
    (version "1.0-5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "inum" version))
              (sha256
               (base32
                "1gbbsffbzxjrgi8yw21fl35fsbx7ns8hdrhja50byfqvnghbg5p6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-libcoin))
    (home-page "https://cran.r-project.org/web/packages/inum/")
    (synopsis "Interval and enum-type representation of vectors")
    (description
     "This package provides an enum-type representation of vectors and
representation of intervals, including a method of coercing variables
in data frames.")
    (license license:gpl2)))
(define-public r-invgamma
  (package
   (name "r-invgamma")
   (version "1.1")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "invgamma" version))
            (sha256
             (base32
              "12ga2y4wc9bc5zz6vimvxwgjpsx3ys3209nq63gscbw559ydxa5a"))))
   (properties `((upstream-name . "invgamma")))
   (build-system r-build-system)
   (home-page "https://github.com/dkahle/invgamma")
   (synopsis "Inverse gamma distribution")
   (description "This package provides a light weight implementation of the
standard distribution functions for the inverse gamma distribution, wrapping
those for the gamma distribution in the @code{stats} package.")
   (license license:gpl2)))

(define-public r-bdsmatrix
  (package
    (name "r-bdsmatrix")
    (version "1.3-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bdsmatrix" version))
       (sha256
        (base32
         "08krrd7454ixqv4nq55hgf3djp1pz1vl3ndslsrh2pkdq1d5wl63"))))
    (properties `((upstream-name . "bdsmatrix")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/bdsmatrix/")
    (synopsis "Routines for block diagonal symmetric matrices")
    (description
     "This package provides procedures to work with block diagonal symmetric
matrices, a special case of sparse matrices.")
    (license license:lgpl2.0)))

(define-public r-bbmle
  (package
    (name "r-bbmle")
    (version "1.0.25.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bbmle" version))
       (sha256
        (base32
         "02xnfmjr5ax5pc69jkxmygkwvb68flrf1x8pxfw0hk7y37w0qanr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bdsmatrix
           r-lattice
           r-mass
           r-matrix
           r-mvtnorm
           r-numderiv))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/web/packages/bbmle")
    (synopsis "Tools for General Maximum Likelihood Estimation")
    (description
     "This package provides methods and functions for fitting maximum
likelihood models in R.  This package modifies and extends the @code{mle}
classes in the @code{stats4} package.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-emdbook
  (package
    (name "r-emdbook")
    (version "1.3.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emdbook" version))
       (sha256
        (base32
         "069w10i1590bcyzv4kfsg7wsr1yl9nlsyj6yvys088xll5z4n116"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bbmle r-coda r-lattice r-mass r-plyr))
    (native-inputs (list r-testthat))
    (home-page "https://www.math.mcmaster.ca/bolker/emdbook")
    (synopsis "Support functions and data for \"Ecological Models and Data\"")
    (description
     "This package provides auxiliary functions and data sets for \"Ecological
Models and Data\", a book presenting maximum likelihood estimation and related
topics for ecologists (ISBN 978-0-691-12522-0).")
    ;; Any GPL version
    (license (list license:gpl2 license:gpl3))))

(define-public r-lpsolve
  (package
    (name "r-lpsolve")
    (version "5.6.22")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lpSolve" version))
       (sha256
        (base32
         "0pvl9shp4257f7z0nch4hrg37b9y1jpx11n10h3qjkvnsr3dqr1a"))))
    (properties `((upstream-name . "lpSolve")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/lpSolve")
    (synopsis "R interface to Lp_solve to solve linear/integer programs")
    (description
     "Lp_solve is software for solving linear, integer and mixed integer
programs.  This implementation supplies a \"wrapper\" function in C and some R
functions that solve general linear/integer problems, assignment problems, and
transportation problems.")
    (license license:lgpl2.0)))

(define-public r-lpsolveapi
  (package
    (name "r-lpsolveapi")
    (version "5.5.2.0-17.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lpSolveAPI" version))
       (sha256
        (base32 "1vvhbgd54k0ynzh1zsrcdy8ry6w642vjk9dhlkig7pamf39aj02g"))))
    (properties `((upstream-name . "lpSolveAPI")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=lpSolveAPI")
    (synopsis "Interface to lp_solve")
    (description
     "The lpSolveAPI package provides an R interface to lp_solve, a @acronym{MILP,
Mixed Integer Linear Programming}, solver with support for pure linear, (mixed)
integer/binary, semi-continuous and @acronym{SOS, special ordered sets} models.")
    (license license:lgpl2.0)))

(define-public r-limsolve
  (package
    (name "r-limsolve")
    (version "1.5.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "limSolve" version))
       (sha256
        (base32
         "14jvx0sjjdsm6fxvdck648h12sl4cmy8sgw8jx1744pmpcbm5555"))))
    (properties `((upstream-name . "limSolve")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lpsolve r-mass r-quadprog))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/limSolve")
    (synopsis "Solving linear inverse models")
    (description
     "This package provides functions that:

@enumerate
@item find the minimum/maximum of a linear or quadratic function,
@item sample an underdetermined or overdetermined system,
@item solve a linear system Ax=B for the unknown x.
@end enumerate

It includes banded and tridiagonal linear systems.  The package calls Fortran
functions from LINPACK.")
    ;; Any GPL version.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-litedown
  (package
    (name "r-litedown")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "litedown" version))
       (sha256
        (base32 "1fm0932z35flb7rwx3pydifrfmw62b7hrm6qr7b0wv9gcqvi6pxx"))))
    (properties `((upstream-name . "litedown")))
    (build-system r-build-system)
    ;; Building the vignettes requires internet access.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-commonmark r-xfun))
    (native-inputs (list r-codetools))
    (home-page "https://github.com/yihui/litedown")
    (synopsis "Lightweight version of R Markdown")
    (description
     "Render R Markdown to Markdown (without using @code{knitr}), and Markdown
to lightweight HTML or @code{LaTeX} documents with the @code{commonmark}
package (instead of Pandoc).  Some missing Markdown features in
@code{commonmark} are also supported, such as raw HTML or @code{LaTeX} blocks,
@code{LaTeX} math, superscripts, subscripts, footnotes, element attributes,
and appendices, but not all Pandoc Markdown features are (or will be)
supported.  With additional @code{JavaScript} and CSS, you can also create
HTML slides and articles.  This package can be viewed as a trimmed-down
version of R Markdown and @code{knitr}.  It does not aim at rich Markdown
features or a large variety of output formats (the primary formats are HTML
and @code{LaTeX}).  Book and website projects of multiple input documents are
also supported.")
    (license license:expat)))

(define-public r-littler
  (package
    (name "r-littler")
    (version "0.3.20")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "littler" version))
              (sha256
               (base32
                "0nh6bgnxgryygfzxcwci9gm53adq9r0837apvnpq51w7f6jwq44q"))))
    (properties
     `((upstream-name . "littler")
       (updater-extra-inputs . ("icu4c" "zlib"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-executable
            (lambda _
              (install-file "inst/bin/r"
                            (string-append #$output "/bin")))))))
    (inputs (list icu4c libdeflate zlib))
    (native-inputs
     (list r-simplermarkdown))
    (home-page "https://github.com/eddelbuettel/littler")
    (synopsis "R at the command-line via r")
    (description
     "This package provides a scripting and command-line front-end is provided
by r (aka littler) as a lightweight binary wrapper around the GNU R language
and environment for statistical computing and graphics.  While R can be used
in batch mode, the r binary adds full support for both shebang-style scripting
(i.e. using a hash-mark-exclamation-path expression as the first line in
scripts) as well as command-line use in standard pipelines.  In other words, r
provides the R language without the environment.")
    (license license:gpl2+)))

(define-public r-fitdistrplus
  (package
    (name "r-fitdistrplus")
    (version "1.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fitdistrplus" version))
       (sha256
        (base32
         "0n25b3f92pghkavk4j9l25v1k6wjwkmpyvxslf05ixpzkmd23d38"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; Needs package GeneralizedHyperbolic
             (delete-file "tests/t-fitdist-customoptim.R")
             ;; Needs package rgenoud
             (delete-file "tests/t-fitdistcens.R"))))))
    (propagated-inputs
     (list r-mass r-rlang r-survival))
    (native-inputs
     (list r-actuar r-knitr r-mc2d))
    (home-page "https://riskassessment.r-forge.r-project.org")
    (synopsis "Fitting a parametric distribution from data")
    (description
     "This package extends the @code{fitdistr} function of the MASS package
with several functions to help the fit of a parametric distribution to
non-censored or censored data.  Censored data may contain left-censored,
right-censored and interval-censored values, with several lower and upper
bounds.  In addition to @dfn{maximum likelihood estimation} (MLE), the package
provides moment matching (MME), quantile matching (QME) and maximum
goodness-of-fit estimation (MGE) methods (available only for non-censored
data).  Weighted versions of MLE, MME and QME are available.")
    (license license:gpl2+)))

(define-public r-energy
  (package
    (name "r-energy")
    (version "1.7-12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "energy" version))
       (sha256
        (base32
         "0wkggv423bz9awi3dnxpmf62hdgfn5qgcvw1k4pvcsjczaz288mc"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-gsl r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/energy")
    (synopsis "Multivariate inference via the energy of data")
    (description
     "This package provides e-statistics (energy) tests and statistics for
multivariate and univariate inference, including distance correlation,
one-sample, two-sample, and multi-sample tests for comparing multivariate
distributions, are implemented.  Measuring and testing multivariate
independence based on distance correlation, partial distance correlation,
multivariate goodness-of-fit tests, clustering based on energy distance,
testing for multivariate normality, distance components (disco) for
non-parametric analysis of structured data, and other energy
statistics/methods are implemented.")
    (license license:gpl2+)))

(define-public r-envstats
  (package
    (name "r-envstats")
    (version "3.0.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "EnvStats" version))
              (sha256
               (base32
                "0j6jikxf28ryh6jn7d3lag6sl2jjdzbszd2ll94ia9dk8hyyq4q4"))))
    (properties `((upstream-name . "EnvStats")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-mass r-nortest))
    (home-page "https://github.com/alexkowa/EnvStats")
    (synopsis
     "Package for environmental statistics, including US EPA guidance")
    (description
     "This is a package for graphical and statistical analyses of
environmental data, with a focus on analyzing chemical concentrations and
physical parameters, usually in the context of mandated environmental
monitoring.  It provides major environmental statistical methods found in the
literature and regulatory guidance documents, with extensive help that
explains what these methods do, how to use them, and where to find them in the
literature.  It comes with numerous built-in data sets from regulatory
guidance documents and environmental statistics literature.  It includes
scripts reproducing analyses presented in the book \"EnvStats: An R Package
for Environmental Statistics\" (Millard, 2013, Springer, ISBN
978-1-4614-8455-4,
@url{https://link.springer.com/book/10.1007/978-1-4614-8456-1}).")
    (license license:gpl3+)))

(define-public r-suntools
  (package
    (name "r-suntools")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "suntools" version))
       (sha256
        (base32 "1qlp0q2ckqg5v3yvbr98k3nr9awgg7ks0l1103nqvm1ssadv7ds2"))))
    (properties `((upstream-name . "suntools")))
    (build-system r-build-system)
    (propagated-inputs (list r-sf))
    (native-inputs (list r-testthat tzdata-for-tests))
    (home-page "https://github.com/adokter/suntools/")
    (synopsis
     "Calculate sun position, sunrise, sunset, solar noon and twilight")
    (description
     "This package provides a set of convenient functions for calculating
sun-related information, including the sun's position (elevation and azimuth),
and the times of sunrise, sunset, solar noon, and twilight for any given
geographical location on Earth.  These calculations are based on equations
provided by the National Oceanic & Atmospheric Administration (NOAA) as
described in \"Astronomical Algorithms\" by Jean Meeus (1991).  A resource for
researchers and professionals working in fields such as climatology, biology,
and renewable energy.")
    (license license:gpl3+)))

(define-public r-suppdists
  (package
    (name "r-suppdists")
    (version "1.1-9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SuppDists" version))
       (sha256
        (base32
         "07k8sdw7qmbzflpsr1zrn8bm42qp936sm3bwpi8q7mjb7h8y40k5"))))
    (properties `((upstream-name . "SuppDists")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/SuppDists")
    (synopsis "Supplementary distributions")
    (description
     "This package provides ten distributions supplementing those built into
R.  Inverse Gauss, Kruskal-Wallis, Kendall's Tau, Friedman's chi squared,
Spearman's rho, maximum F ratio, the Pearson product moment correlation
coefficient, Johnson distributions, normal scores and generalized
hypergeometric distributions.  In addition two random number generators of
George Marsaglia are included.")
    (license license:gpl2+)))

(define-public r-kpmt
  (package
    (name "r-kpmt")
    (version "0.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "kpmt" version))
              (sha256
               (base32
                "15d26khc0v3kc1c7l1avqp48pfqmc6xj32029mv7myivr41ashk3"))))
    (properties `((upstream-name . "kpmt")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrixstats))
    (home-page "https://cran.r-project.org/package=kpmt")
    (synopsis "Known population median test")
    (description
     "This package provides functions that implement the known population
median test.")
    (license license:expat)))

(define-public r-ksamples
  (package
    (name "r-ksamples")
    (version "1.2-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kSamples" version))
       (sha256
        (base32
         "13ap5ggid3w3s3k5mzz1ir31j96hjg6msa2s1hcy66zv242wqrid"))))
    (properties `((upstream-name . "kSamples")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-suppdists))
    (home-page "https://cran.r-project.org/web/packages/kSamples")
    (synopsis "K-Sample rank tests and their combinations")
    (description
     "This package provides tools to compares k samples using the
Anderson-Darling test, Kruskal-Wallis type tests with different rank score
criteria, Steel's multiple comparison test, and the Jonckheere-Terpstra (JT)
test.  It computes asymptotic, simulated or (limited) exact P-values, all
valid under randomization, with or without ties, or conditionally under random
sampling from populations, given the observed tie pattern.  Except for Steel's
test and the JT test it also combines these tests across several blocks of
samples.")
    (license license:gpl2+)))

(define-public r-cvst
  (package
    (name "r-cvst")
    (version "0.2-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CVST" version))
       (sha256
        (base32
         "0bgk0d6w3dyhb5s30idnp6jpb3m8wf3b79wqlg127wwm0cird8pg"))))
    (properties `((upstream-name . "CVST")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernlab r-matrix))
    (home-page "https://cran.r-project.org/web/packages/CVST")
    (synopsis "Fast cross-validation via sequential testing")
    (description
     "This package implements the fast cross-validation via sequential
testing (CVST) procedure.  CVST is an improved cross-validation procedure
which uses non-parametric testing coupled with sequential analysis to
determine the best parameter set on linearly increasing subsets of the data.
Additionally to the CVST the package contains an implementation of the
ordinary k-fold cross-validation with a flexible and powerful set of helper
objects and methods to handle the overall model selection process.  The
implementations of the Cochran's Q test with permutations and the sequential
testing framework of Wald are generic and can therefore also be used in other
contexts.")
    (license license:gpl2+)))

(define-public r-cvxr
  (package
    (name "r-cvxr")
    (version "1.0-15")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "CVXR" version))
              (sha256
               (base32
                "13435gwqgdaw7xxxza5k9p10z2wjlw9x5d1znj03h44k6wm1jfy1"))))
    (properties `((upstream-name . "CVXR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bit64
           r-cli
           r-ecosolver
           r-gmp
           r-matrix
           r-osqp
           r-rcpp
           r-rcppeigen
           r-rmpfr
           r-scs))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cvxr.rbind.io")
    (synopsis "Disciplined convex optimization")
    (description
     "This package provides an object-oriented modeling language for
@dfn{disciplined convex programming} (DCP) as described in Fu,
Narasimhan, and Boyd (2020, <doi:10.18637/jss.v094.i14>).  It allows
the user to formulate convex optimization problems in a natural way
following mathematical convention and DCP rules.  The system analyzes
the problem, verifies its convexity, converts it into a canonical
form, and hands it off to an appropriate solver to obtain the
solution.  Interfaces to solvers on CRAN and elsewhere are provided.")
    (license license:asl2.0)))

(define-public r-squarem
  (package
    (name "r-squarem")
    (version "2021.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SQUAREM" version))
       (sha256
        (base32
         "0n1s32l9p4vdm3h5q6g43s0qbpzry08difsh0yay80wrla6f3rb6"))))
    (properties `((upstream-name . "SQUAREM")))
    (build-system r-build-system)
    (native-inputs (list r-setrng))
    (home-page "https://coah.jhu.edu/people/Faculty_personal_Pages/Varadhan.html")
    (synopsis "Squared Extrapolation Methods for Accelerating EM-Like Monotone Algorithms")
    (description
     "This package provides algorithms for accelerating the convergence of
slow, monotone sequences from smooth, contraction mapping such as the EM
algorithm.  It can be used to accelerate any smooth, linearly convergent
acceleration scheme.  A tutorial style introduction to this package is
available in a vignette.")
    (license license:gpl2+)))

(define-public r-progressr
  (package
    (name "r-progressr")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "progressr" version))
       (sha256
        (base32 "1rzn3abiy2zfr86yqaajh53y1a3x79n411gg6xj2jwi80bgh375z"))))
    (properties `((upstream-name . "progressr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest))
    (native-inputs (list r-future))
    (home-page "https://progressr.futureverse.org")
    (synopsis "Inclusive, unifying API for progress updates")
    (description
     "This package provides a minimal, unifying API for scripts and packages
to report progress updates from anywhere including when using parallel
processing.  The package is designed such that the developer can to focus on
what progress should be reported on without having to worry about how to
present it.  The end user has full control of how, where, and when to render
these progress updates.")
    (license license:gpl3+)))

(define-public r-lava
  (package
    (name "r-lava")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lava" version))
       (sha256
        (base32
         "0zz8hzmqd4qa14y52c8gw9hr6gn0d7srffrddxrmhb01rbp9dfcd"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-future-apply
           r-numderiv
           r-progressr
           r-squarem
           r-survival))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/kkholst/lava")
    (synopsis "Latent variable models")
    (description
     "This package provides tools for the estimation and simulation of latent
variable models.")
    (license license:gpl3)))

(define-public r-drat
  (package
    (name "r-drat")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "drat" version))
       (sha256
        (base32 "1di28631gi890krazzvmfcpr2gv6gr83dzkn0rq2n2y0pmnkm2kf"))))
    (properties `((upstream-name . "drat")))
    (build-system r-build-system)
    (native-inputs (list r-simplermarkdown))
    (home-page "https://github.com/eddelbuettel/drat")
    (synopsis "Drat R archive template")
    (description
     "This package helps you with creation and use of R repositories via
helper functions to insert packages into a repository, and to add repository
information to the current R session.  Two primary types of repositories are
supported: gh-pages at GitHub, as well as local repositories on either the
same machine or a local network.  Drat is a recursive acronym: Drat R Archive
Template.")
    (license license:gpl2+)))

(define-public r-drr
  (package
    (name "r-drr")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DRR" version))
       (sha256
        (base32
         "1y70si1gig4l7jx5jiqsqliyywfsvimkx53x3zh1lc3yj2j6bqwk"))))
    (properties `((upstream-name . "DRR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cvst r-kernlab r-matrix))
    (home-page "https://cran.r-project.org/web/packages/DRR")
    (synopsis "Dimensionality reduction via regression")
    (description
     "This package provides an implementation of dimensionality reduction via
regression using Kernel Ridge Regression.")
    (license license:gpl3)))

(define-public r-prodlim
  (package
    (name "r-prodlim")
    (version "2024.06.25")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prodlim" version))
       (sha256
        (base32
         "0r3780j04wy3ihrhvfm3qcwa9xjrxl43bcllzzq7xaki85jiz5j6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table
           r-diagram
           r-kernsmooth
           r-lava
           r-rcpp
           r-survival))
    (home-page "https://cran.r-project.org/web/packages/prodlim")
    (synopsis "Product-limit estimation for censored event history analysis")
    (description
     "This package provides a fast and user-friendly implementation of
nonparametric estimators for censored event history (survival) analysis with
the Kaplan-Meier and Aalen-Johansen methods.")
    (license license:gpl2+)))

(define-public r-dimred
  (package
    (name "r-dimred")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dimRed" version))
       (sha256
        (base32
         "05zlkf6hjdqqr1sgw7ww9f17vjnsiqfaj9kvdvi146phh53v2zls"))))
    (properties `((upstream-name . "dimRed")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-drr r-magrittr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/gdkrmr/dimRed")
    (synopsis "Framework for dimensionality reduction")
    (description
     "This package provides a collection of dimensionality reduction
techniques from R packages and provides a common interface for calling the
methods.")
    (license license:gpl3)))

(define-public r-timechange
  (package
    (name "r-timechange")
    (version "0.3.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "timechange" version))
              (sha256
               (base32
                "1d26mr3avw6bpx786k223bnylzqr7z1h7rrjc38pi5db2iahnp6q"))))
    (properties `((upstream-name . "timechange")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for tests.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs (list r-cpp11))
    (native-inputs (list r-testthat tzdata-for-tests))
    (home-page "https://github.com/vspinu/timechange/")
    (synopsis "Efficient manipulation of Date-Times")
    (description
     "This package provides efficient routines for manipulation of
date-time objects while accounting for time-zones and daylight saving
times.  The package includes utilities for updating of date-time
components (year, month, day etc.), modification of time-zones,
rounding of date-times, period addition and subtraction etc.  Parts of
the CCTZ source code, released under the Apache 2.0 License, are
included in this package.")
    (license license:gpl3)))

(define-public r-timedate
  (package
    (name "r-timedate")
    (version "4041.110")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "timeDate" version))
       (sha256
        (base32
         "1rvi1h7jm02vnsrk9mm0fldymf7zyjkv1id6xvn1iwgb5psz2syf"))))
    (properties `((upstream-name . "timeDate")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'set-TZDIR
           (lambda* (#:key inputs #:allow-other-keys)
             ;; Tests would fail without this.
             (setenv "TZDIR"
                     (search-input-directory inputs "share/zoneinfo")))))))
    (native-inputs (list r-runit tzdata-for-tests))
    (home-page "https://www.rmetrics.org")
    (synopsis "Chronological and calendar objects")
    (description
     "This package provides an environment for teaching \"Financial
Engineering and Computational Finance\" and for managing chronological and
calendar objects.")
    (license license:gpl2+)))

(define-public r-magic
  (package
    (name "r-magic")
    (version "1.6-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "magic" version))
       (sha256
        (base32
         "0xkrrg5qk62pfqx0avijdjaljzslpwd0hv2m52qnqwrbx5xfqyfa"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind))
    (home-page "https://github.com/RobinHankin/magic.git")
    (synopsis "Create and investigate magic squares")
    (description
     "This package provides a collection of efficient, vectorized algorithms
for the creation and investigation of magic squares and hypercubes, including
a variety of functions for the manipulation and analysis of arbitrarily
dimensioned arrays.")
    (license license:gpl2)))

(define-public r-magicaxis
  (package
    (name "r-magicaxis")
    (version "2.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "magicaxis" version))
       (sha256
        (base32 "04wj0g345mlndd1s7v7klxldxlp293xdgjyrnfpzxckg59804j3d"))))
    (properties `((upstream-name . "magicaxis")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-celestial
           r-mapproj
           r-mass
           r-plotrix
           r-rann
           r-sm))
    (home-page "https://cran.r-project.org/package=magicaxis")
    (synopsis "Scientific plotting with minor-tick and log minor-tick support")
    (description
     "This package provides functions to make useful (and pretty) plots for
scientific plotting.  Additional plotting features are added for base plotting,
with particular emphasis on making attractive log axis plots.")
    (license license:gpl3)))

(define-public r-rmysql
  (package
    (name "r-rmysql")
    (version "0.10.29")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RMySQL" version))
       (sha256
        (base32
         "11kbjzr6bff3ns7bh3aic8kw5bqgf1aaz2fw04vv28dwrqzrxs42"))))
    (properties `((upstream-name . "RMySQL")))
    (build-system r-build-system)
    (inputs
     (list `(,mariadb "dev") zlib))
    (propagated-inputs
     (list r-dbi))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-dbi/RMySQL")
    (synopsis "Database interface and MySQL driver for R")
    (description
     "This package provides a DBI interface to MySQL / MariaDB.  The RMySQL
package contains an old implementation based on legacy code from S-PLUS which
is being phased out.  A modern MySQL client based on Rcpp is available from
the RMariaDB package.")
    (license license:gpl2)))

(define-public r-rpanglaodb
  (package
    (name "r-rpanglaodb")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rPanglaoDB" version))
       (sha256
        (base32 "1ykzih3idgp2yhbw4039hhhzv0nmrmn3wx2c4dxmgp5qzhrg42nf"))))
    (properties `((upstream-name . "rPanglaoDB")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-pbapply r-seurat r-xml r-xml2))
    (home-page "https://github.com/dosorio/rPanglaoDB/")
    (synopsis
     "Download and merge Single-Cell RNA-Seq data from the PanglaoDB database")
    (description
     "This R package downloads labeled single-cell RNA-seq data from PanglaoDB.
It merges the data into a Seurat object for streamlined analysis.")
    (license license:gpl3)))

(define-public r-rpmm
  (package
    (name "r-rpmm")
    (version "1.25")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RPMM" version))
              (sha256
               (base32
                "1j48dh434wfhfzka0l21w6f73qlwfm70r9gdddhn504i2d5m4jph"))))
    (properties `((upstream-name . "RPMM")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster))
    (home-page "https://cran.r-project.org/package=RPMM")
    (synopsis "Recursively partitioned mixture model")
    (description
     "This package provides a recursively partitioned mixture model for Beta
and Gaussian mixtures.  This is a model-based clustering algorithm that
returns a hierarchy of classes, similar to hierarchical clustering, but also
similar to finite mixture models.")
    (license license:gpl2+)))

(define-public r-rpostgresql
  (package
    (name "r-rpostgresql")
    (version "0.7-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RPostgreSQL" version))
       (sha256
        (base32
         "073xdjcbpsy9j68migxrp6p51lw6rn3rx1l4z7bygayb4niklngh"))))
    (properties
     '((upstream-name . "RPostgreSQL")
       (updater-extra-inputs . ("postgresql"))))
    (build-system r-build-system)
    (inputs (list postgresql))
    (propagated-inputs (list r-dbi))
    (home-page "https://github.com/tomoakin/RPostgreSQL")
    (synopsis "R interface to the PostgreSQL database system")
    (description
     "This package provides a Database Interface (DBI) compliant driver for R
to access PostgreSQL database systems.")
    ;; The whole package is released under GPL version 2.  It includes code
    ;; under the PostgreSQL license.
    (license license:gpl2)))

(define-public r-rpostgres
  (package
    (name "r-rpostgres")
    (version "1.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RPostgres" version))
       (sha256
        (base32
         "0939ysl9m35aknnh3xk92xxymk1g0xqnjb2khq55m8nq7gcg3l9x"))))
    (properties `((upstream-name . "RPostgres")))
    (build-system r-build-system)
    (inputs (list openssl postgresql))
    (propagated-inputs
     (list r-bit64
           r-blob
           r-cpp11
           r-dbi
           r-hms
           r-lubridate
           r-plogr
           r-withr))
    (native-inputs
     (list pkg-config r-knitr r-testthat))
    (home-page "https://rpostgres.r-dbi.org")
    (synopsis "Rcpp Interface to PostgreSQL")
    (description
     "This package provides a fully @code{DBI}-compliant @code{Rcpp}-backed
interface to @code{PostgreSQL}, a relational database.")
    (license license:gpl3)))

(define-public r-linprog
  (package
    (name "r-linprog")
    (version "0.9-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "linprog" version))
       (sha256
        (base32
         "1d34m2nyk7m6j2dci69bhy5mlw479xax1517j7f14pq7vhpsm9l1"))))
    (build-system r-build-system)
    (propagated-inputs (list r-lpsolve))
    (home-page "https://linprog.r-forge.r-project.org/")
    (synopsis "Linear programming and optimization")
    (description
     "This package can be used to solve Linear Programming / Linear
Optimization problems by using the simplex algorithm.")
    (license license:gpl2+)))

(define-public r-geojsonsf
  (package
    (name "r-geojsonsf")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geojsonsf" version))
       (sha256
        (base32 "1la6zfzv14ascwds0bp67d7x3am0v14mylc4b2lyd0nrf93a2p17"))))
    (properties `((upstream-name . "geojsonsf")))
    (build-system r-build-system)
    (propagated-inputs (list r-geometries r-jsonify r-rapidjsonr r-rcpp
                             r-sfheaders))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/SymbolixAU/geojsonsf")
    (synopsis "GeoJSON to Simple Feature converter")
    (description "This package converts between @code{GeoJSON} and Simple
Feature objects.")
    (license license:expat)))

(define-public r-geometries
  (package
    (name "r-geometries")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geometries" version))
       (sha256
        (base32 "040ljxmzbjdr76p81ygnn5y0gzckz5k2arxkih5m5f3b6g62laf6"))))
    (properties `((upstream-name . "geometries")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr))
    (home-page "https://dcooley.github.io/geometries/")
    (synopsis "Convert between R objects and geometric structures")
    (description
     "Geometry shapes in R are typically represented by matrices (points,
lines), with more complex shapes being lists of matrices (polygons).
Geometries will convert various R objects into these shapes.  Conversion
functions are available at both the R level, and through Rcpp.")
    (license license:expat)))

(define-public r-geometry
  (package
    (name "r-geometry")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geometry" version))
       (sha256
        (base32
         "0qcymxxbs3lqi4w6cl8h3hwrchk3ahxp83kkv86bvrq4cd6mbxxm"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-linprog r-lpsolve r-magic r-rcpp r-rcppprogress))
    (native-inputs (list r-testthat))
    (home-page "https://geometry.r-forge.r-project.org/")
    (synopsis "Mesh generator and surface tessellator")
    (description
     "This package makes the qhull library available in R, in a similar manner
as in Octave.  Qhull computes convex hulls, Delaunay triangulations, halfspace
intersections about a point, Voronoi diagrams, furthest-site Delaunay
triangulations, and furthest-site Voronoi diagrams.  It runs in 2-d, 3-d, 4-d,
and higher dimensions.  It implements the Quickhull algorithm for computing
the convex hull.  Qhull does not support constrained Delaunay triangulations,
or mesh generation of non-convex objects, but the package does include some R
functions that allow for this.  Currently the package only gives access to
Delaunay triangulation and convex hull computation.")
    ;; The Qhull sources are included and are distributed under a custom
    ;; non-copyleft license.  The R sources are released under GPL version 2.
    (license (list license:gpl2
                   (license:non-copyleft "http://www.qhull.org/COPYING.txt")))))

(define-public r-ddalpha
  (package
    (name "r-ddalpha")
    (version "1.3.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ddalpha" version))
       (sha256
        (base32
         "1139a50ili4w04034fmpxsbn2j17nx1ns5f07cijgqpskxjgi41r"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh
           r-class
           r-geometry
           r-mass
           r-rcpp
           r-robustbase
           r-sfsmisc))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/ddalpha")
    (synopsis "Depth-Based classification and calculation of data depth")
    (description
     "This package contains procedures for depth-based supervised learning,
which are entirely non-parametric, in particular the DDalpha-procedure (Lange,
Mosler and Mozharovskyi, 2014).  The training data sample is transformed by a
statistical depth function to a compact low-dimensional space, where the final
classification is done.  It also offers an extension to functional data and
routines for calculating certain notions of statistical depth functions.  50
multivariate and 5 functional classification problems are included.")
    (license license:gpl2)))

(define-public r-gower
  (package
    (name "r-gower")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gower" version))
       (sha256
        (base32
         "1z0mhfp8xp7rk9i820pkvspm6mwih24g6b5rqs63m37sbs79ssi9"))))
    (build-system r-build-system)
    (home-page "https://github.com/markvanderloo/gower")
    (synopsis "Gower's distance")
    (description
     "This package provides tools to compute Gower's distance (or similarity)
coefficient between records, and to compute the top-n matches between records.
Core algorithms are executed in parallel on systems supporting OpenMP.")
    (license license:gpl3)))

(define-public r-rcpproll
  (package
    (name "r-rcpproll")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppRoll" version))
       (sha256
        (base32
         "1prnc3svhc2v1w97vbdzfyxh545zx2h0p9d1q4753f7ynrwdkxfj"))))
    (properties `((upstream-name . "RcppRoll")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/RcppRoll")
    (synopsis "Efficient rolling and windowed operations")
    (description
     "This package provides fast and efficient routines for common rolling /
windowed operations.  Routines for the efficient computation of windowed mean,
median, sum, product, minimum, maximum, standard deviation and variance are
provided.")
    (license license:gpl2+)))

(define-public r-ipred
  (package
    (name "r-ipred")
    (version "0.9-15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ipred" version))
       (sha256
        (base32
         "0jzfq06l2vxyjy46sjgqyk6l4pp06kx3w5j39hzjy9i127hjsxd4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class
           r-mass
           r-nnet
           r-prodlim
           r-rpart
           r-survival))
    (native-inputs (list r-mlbench r-th-data))
    (home-page "https://cran.r-project.org/web/packages/ipred")
    (synopsis "Improved predictors")
    (description
     "This package provides improved predictive models by indirect
classification and bagging for classification, regression and survival
problems as well as resampling based estimators of prediction error.")
    (license license:gpl2+)))

(define-public r-psych
  (package
    (name "r-psych")
    (version "2.4.6.26")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "psych" version))
       (sha256
        (base32
         "1gnjpcpqlviyyj5myhy440fj1zwx14b9jwhp5907yyhhw2ail69d"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gparotation r-lattice r-mnormt r-nlme))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/psych/")
    (synopsis "Procedures for psychological, psychometric, and personality research")
    (description
     "This package provides a general purpose toolbox for personality,
psychometric theory and experimental psychology.  Functions are primarily for
multivariate analysis and scale construction using factor analysis, principal
component analysis, cluster analysis and reliability analysis, although others
provide basic descriptive statistics.  Item Response Theory is done using
factor analysis of tetrachoric and polychoric correlations.  Functions for
analyzing data at multiple levels include within and between group statistics,
including correlations and factor analysis.  Functions for simulating and
testing particular item and test structures are included.  Several functions
serve as a useful front end for structural equation modeling.  Graphical
displays of path diagrams, factor analysis and structural equation models are
created using basic graphics.")
    (license license:gpl2+)))

(define-public r-psychotools
  (package
    (name "r-psychotools")
    (version "0.7-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "psychotools" version))
       (sha256
        (base32 "197hym0fxfsyg6kf0pf9g5wbsa1kkicd4lqrxfy2g3c7aczad9zy"))))
    (properties `((upstream-name . "psychotools")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=psychotools")
    (synopsis "Psychometric modeling infrastructure")
    (description
     "This package provides infrastructure for psychometric modeling such as
data classes (for item response data and paired comparisons), basic model
fitting functions (for Bradley-Terry, Rasch, parametric logistic IRT,
generalized partial credit, rating scale, multinomial processing tree models),
extractor functions for different types of parameters (item, person,
threshold, discrimination, guessing, upper asymptotes), unified inference and
visualizations, and various datasets for illustration.  It is intended as a
common lightweight and efficient toolbox for psychometric modeling and a
common building block for fitting psychometric mixture models in package
@code{psychomix} and trees based on psychometric models in package
@code{psychotree}.")
    (license (list license:gpl2 license:gpl3))))

(define-public r-psychotree
  (package
    (name "r-psychotree")
    (version "0.16-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "psychotree" version))
       (sha256
        (base32 "04ipl6kadfvyl28wx8jbpisb4pcswrwq1qiqm90h47ldbnmha932"))))
    (properties `((upstream-name . "psychotree")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-partykit r-psychotools))
    (home-page "https://cran.r-project.org/package=psychotree")
    (synopsis "Recursive Partitioning Based on Psychometric Models")
    (description
     "Recursive partitioning based on psychometric models, employing the general MOB
algorithm (from package partykit) to obtain Bradley-Terry trees, Rasch trees,
rating scale and partial credit trees, and MPT trees, trees for 1PL, 2PL, 3PL
and 4PL models and generalized partial credit models.")
    (license (list license:gpl2 license:gpl3))))

(define-public r-generics
  (package
    (name "r-generics")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "generics" version))
       (sha256
        (base32
         "0lyhhwik0w7m5h3fbwl2f52gc1v2g6g6h6sc47sa9f58pxin213m"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-lib/generics")
    (synopsis "Common S3 generics not provided by base R methods")
    (description
     "In order to reduce potential package dependencies and conflicts,
generics provides a number of commonly used S3 generics that are not provided
by base R methods related to model fitting.")
    (license license:gpl2)))

(define-public r-broom
  (package
    (name "r-broom")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "broom" version))
       (sha256
        (base32
         "089cl8j7ammwmxc49hv2khfv3vzs6j7m5klsczws74cvlr28py6x"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports
           r-dplyr
           r-generics
           r-glue
           r-lifecycle
           r-purrr
           r-rlang
           r-stringr
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/tidyverse/broom")
    (synopsis "Convert statistical analysis objects into tidy data frames")
    (description
     "This package provides tools to convert statistical analysis objects from
R into tidy data frames, so that they can more easily be combined, reshaped
and otherwise processed with tools like @code{dplyr}, @code{tidyr} and
@code{ggplot2}.  The package provides three S3 generics: @code{tidy}, which
summarizes a model's statistical findings such as coefficients of a
regression; @code{augment}, which adds columns to the original data such as
predictions, residuals and cluster assignments; and @code{glance}, which
provides a one-row summary of model-level statistics.")
    (license license:expat)))

(define-public r-recipes
  (package
    (name "r-recipes")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "recipes" version))
       (sha256
        (base32
         "0v9063w4ahdc0xnwry3knykl4k2656df6jxv5f0p40k8piv8ip65"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-clock
           r-dplyr
           r-generics
           r-glue
           r-gower
           r-hardhat
           r-ipred
           r-lifecycle
           r-lubridate
           r-magrittr
           r-matrix
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect
           r-timedate
           r-vctrs
           r-withr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/topepo/recipes")
    (synopsis "Preprocessing tools to create design matrices")
    (description
     "Recipes is an extensible framework to create and preprocess design
matrices.  Recipes consist of one or more data manipulation and analysis
\"steps\".  Statistical parameters for the steps can be estimated from an
initial data set and then applied to other data sets.  The resulting design
matrices can then be used as inputs into statistical or machine learning
models.")
    (license license:gpl2)))

(define-public r-pdist
  (package
    (name "r-pdist")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pdist" version))
       (sha256
        (base32
         "0bvg8si81hs79v39d7svv4zbv2p0sk2r6m9vamibvkh9qvl4x406"))))
    (build-system r-build-system)
    (home-page "https://github.com/jeffwong/pdist")
    (synopsis "Partitioned distance function")
    (description
     "Pdist computes the euclidean distance between rows of a matrix X and
rows of another matrix Y.  Previously, this could be done by binding the two
matrices together and calling @code{dist}, but this creates unnecessary
computation by computing the distances between a row of X and another row of
X, and likewise for Y.  Pdist strictly computes distances across the two
matrices, not within the same matrix, making computations significantly faster
for certain use cases.")
    (license license:gpl3+)))

(define-public r-ggrepel
  (package
    (name "r-ggrepel")
    (version "0.9.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggrepel" version))
       (sha256
        (base32
         "04kj9qzcws6wfw9pf3s6w4phpqywyv6j617l7907plkpcgd6x2i6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-rcpp r-rlang r-scales r-withr))
    (native-inputs
     (list r-knitr r-testthat)) ; for vignettes
    (home-page "https://github.com/slowkow/ggrepel")
    (synopsis "Repulsive text and label geometries for ggplot2")
    (description
     "This package provides text and label geometries for ggplot2 that help to
avoid overlapping text labels.  Labels repel away from each other and away
from the data points.")
    (license license:gpl3)))

(define-public r-coro
  (package
    (name "r-coro")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "coro" version))
       (sha256
        (base32 "1kvaf5484s6dn6zm4nw0ns6fi09lcqnljb51w4fdgsm80s04k6kc"))))
    (properties `((upstream-name . "coro")))
    (build-system r-build-system)
    (propagated-inputs (list r-rlang))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/r-lib/coro")
    (synopsis "Coroutines for R")
    (description
     "This package provides coroutines for R, a family of functions that can
be suspended and resumed later on.  This includes async functions (which
await) and generators (which yield).  Async functions are based on the
concurrency framework of the @code{promises} package.  Generators are based on
a dependency free iteration protocol defined in @code{coro} and are compatible
with iterators from the @code{reticulate} package.")
    (license license:expat)))

(define-public r-corrplot
  (package
    (name "r-corrplot")
    (version "0.95")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "corrplot" version))
       (sha256
        (base32
         "0xnpi4cqclsikd00mjn0qb611g1a619hfr2d3ch8kra1a1kiz8w4"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/taiyun/corrplot")
    (synopsis "Visualization of a correlation matrix")
    (description
     "This package provides a graphical display of a correlation matrix or
general matrix.  It also contains some algorithms to do matrix reordering.  In
addition, corrplot is good at details, including choosing color, text labels,
color labels, layout, etc.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-stable
  (package
    (name "r-stable")
    (version "1.1.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "stable" version))
              (sha256
               (base32
                "194xsa291v5f0jya1c3aigbclg8cci427ffpb8brxamm6n57hf12"))))
    (properties `((upstream-name . "stable")))
    (build-system r-build-system)
    (propagated-inputs (list r-rmutil))
    (home-page "https://www.commanster.eu/rcode.html")
    (synopsis
     "Probability functions and regression models for stable distributions")
    (description
     "This package provides density, distribution, quantile and hazard
functions of a stable variate, as well as generalized regression models for
the parameters of a stable distribution.")
    (license license:gpl2+)))

(define-public r-stabm
  (package
    (name "r-stabm")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stabm" version))
       (sha256
        (base32 "1vslidq2pzpwhsrsklghaqsdjjf4w4wqs2dng0p68zhrv5vlivhq"))))
    (properties `((upstream-name . "stabm")))
    (build-system r-build-system)
    (propagated-inputs (list r-checkmate r-matrix))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://bommert.github.io/stabm/")
    (synopsis "Stability measures for feature selection")
    (description
     "This package provides an implementation of many measures for the
assessment of the stability of feature selection.  Both simple measures and
measures which take into account the similarities between features are
available.")
    (license license:lgpl3)))

(define-public r-statip
  (package
    (name "r-statip")
    (version "0.2.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "statip" version))
              (sha256
               (base32
                "0kymc3ds1nx0h11ffmm3vmqr1w34gd0k788vf72x2v45h8c1ma2n"))))
    (properties `((upstream-name . "statip")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-clue r-rpart))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/paulponcet/statip")
    (synopsis "Statistical functions for probability distributions and regression")
    (description
     "This package provides a collection of miscellaneous statistical
functions for:
@itemize
@item probability distributions,
@item probability density estimation,
@item most frequent value estimation,
@item other statistical measures of location,
@item construction of histograms,
@item calculation of the Hellinger distance,
@item use of classical kernels, and
@item univariate piecewise-constant regression.
@end itemize")
    (license license:gpl3)))

(define-public r-statsexpressions
  (package
    (name "r-statsexpressions")
    (version "1.6.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "statsExpressions" version))
              (sha256
               (base32
                "0l76jrq8x7b89kbxxgswnz5qcwwnkpc0mdm12pbya0ljdf84j1dr"))))
    (properties `((upstream-name . "statsExpressions")))
    (build-system r-build-system)
    (propagated-inputs (list r-afex
                             r-bayesfactor
                             r-bayestestr
                             r-correlation
                             r-datawizard
                             r-dplyr
                             r-effectsize
                             r-glue
                             r-insight
                             r-magrittr
                             r-parameters
                             r-performance
                             r-pmcmrplus
                             r-purrr
                             r-rlang
                             r-tibble
                             r-tidyr
                             r-withr
                             r-wrs2
                             r-zeallot))
    (native-inputs (list r-knitr r-patrick r-testthat))
    (home-page "https://indrajeetpatil.github.io/statsExpressions/")
    (synopsis "Dataframes and expressions with statistical details")
    (description
     "This package provides tools for creating detailed dataframes for common
statistical approaches and tests.  These include parametric, nonparametric,
robust, and Bayesian t-test, one-way ANOVA, correlation analyses, contingency
table analyses, and meta-analyses.  The functions are pipe-friendly and
provide a consistent syntax to work with tidy data.  These dataframes
additionally contain expressions with statistical details, and can be used in
graphing packages.  This package also forms the statistical processing backend
for ggstatsplot.")
    (license license:gpl3)))

(define-public r-strawr
  (package
    (name "r-strawr")
    (version "0.0.92")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "strawr" version))
              (sha256
               (base32
                "0dy6pagwvmswmrlvb9ndy8lz3krcm8fqik83l0gmv9wjb9vba27s"))))
    (properties `((upstream-name . "strawr")))
    (build-system r-build-system)
    (inputs (list curl zlib))
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/aidenlab/straw/tree/master/R")
    (synopsis "Fast implementation of reading / dumping of .hic files")
    (description
     "This package provides an API for efficient @file{.hic} file data
extraction with programmatic matrix access.  It doesn't store the pointer data
for all the matrices, only the one queried, and currently it only supports
matrices.")
    (license license:expat)))

(define-public r-stringdist
  (package
    (name "r-stringdist")
    (version "0.9.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stringdist" version))
       (sha256
        (base32 "1i365vwjx8kk47wzry8d3zhzrlv51hn76s2ipk9vi121zx939171"))))
    (build-system r-build-system)
    (home-page "https://github.com/markvanderloo/stringdist")
    (synopsis "Approximate string matching and string distance functions")
    (description
     "This package implements an approximate string matching version of R's
native @code{match} function.  It can calculate various string distances based
on edits (Damerau-Levenshtein, Hamming, Levenshtein, optimal string alignment),
qgrams (q- gram, cosine, jaccard distance) or heuristic metrics (Jaro,
Jaro-Winkler).  An implementation of soundex is provided as well.  Distances
can be computed between character vectors while taking proper care of encoding
or between integer vectors representing generic sequences.")
    (license license:gpl3+)))

(define-public r-uchardet
  (package
    (name "r-uchardet")
    (version "1.1.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "uchardet" version))
              (sha256
               (base32
                "0m3xy807smqdxhkhd9cwrcf3ljlyvfmnkd7831qzpgcadam2jcdj"))))
    (properties `((upstream-name . "uchardet")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://artemklevtsov.gitlab.io/uchardet")
    (synopsis "Universal character encoding detector")
    (description
     "This package provides R bindings to the uchardet encoding detector
library from Mozilla.  It takes a sequence of bytes in an unknown character
encoding without any additional information, and attempts to get the encoding
of the text.  All return names of the encodings are iconv-compatible.")
    (license license:gpl2)))

(define-public r-ucminf
  (package
    (name "r-ucminf")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ucminf" version))
       (sha256
        (base32
         "0adxynpi6mn5n37i1260yr6z7dm39dadr4nwrxks2jgsd7knmnsb"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/ucminf/")
    (synopsis "General-purpose unconstrained non-linear optimization")
    (description
     "This package provides an implementation of an algorithm for
general-purpose unconstrained non-linear optimization.  The algorithm is of
quasi-Newton type with BFGS updating of the inverse Hessian and soft line
search with a trust region type monitoring of the input to the line search
algorithm.  The interface of @code{ucminf} is designed for easy interchange
with the package @code{optim}.")
    (license license:gpl2+)))

(define-public r-usedist
  (package
    (name "r-usedist")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "usedist" version))
       (sha256
        (base32 "0ddf1zcalbrn293qmr9kdzz3x16fzc4k1bwb1pjmwnspisqfi8kj"))))
    (properties `((upstream-name . "usedist")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=usedist")
    (synopsis "Distance matrix utilities")
    (description
     "This package provides functions to re-arrange, extract, and work with
distances.")
    (license license:gpl3)))

(define-public r-useful
  (package
   (name "r-useful")
   (version "1.2.6.1")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "useful" version))
            (sha256
             (base32
              "1gb9hqvbm6pr56dfqlsgz26lan7xargfsm8jpdja18mpgli2gyvc"))))
   (properties `((upstream-name . "useful")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-assertthat
          r-dplyr
          r-ggplot2
          r-magrittr
          r-matrix
          r-plyr
          r-purrr
          r-scales))
   (native-inputs (list r-testthat))
   (home-page "https://github.com/jaredlander/useful")
   (synopsis "Collection of handy, useful functions")
   (description "This package provides a set of little functions that have been
found useful to do little odds and ends such as plotting the results of K-means
clustering, substituting special text characters, viewing parts of a
@code{data.frame}, constructing formulas from text and building design and
response matrices.")
   (license license:bsd-3)))

(define-public r-ordinal
  (package
    (name "r-ordinal")
    (version "2023.12-4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ordinal" version))
       (sha256
        (base32
         "1c9qiv0zz77i80gbhljj9hm4lh2zs9chfg834lcgyr6972jcz79c"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-matrix r-nlme r-numderiv r-ucminf))
    (native-inputs (list r-lme4 r-testthat r-xtable))
    (home-page "https://github.com/runehaubo/ordinal")
    (synopsis "Regression models for ordinal data")
    (description
     "This package provides an implementation of cumulative link (mixed)
models also known as ordered regression models, proportional odds models,
proportional hazards models for grouped survival times and ordered models.
Estimation is via maximum likelihood and mixed models are fitted with the
Laplace approximation and adaptive Gauss-Hermite quadrature.")
    (license license:gpl2+)))

(define-public r-jomo
  (package
    (name "r-jomo")
    (version "2.7-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jomo" version))
       (sha256
        (base32
         "1np2sw0kq21kdhkv227pz2rqvpxg06r3mk93ggkrz5nl45ajmyiz"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lme4 r-mass r-ordinal r-survival r-tibble))
    (home-page "https://cran.r-project.org/web/packages/jomo/")
    (synopsis "Multilevel Joint Modelling Multiple Imputation")
    (description
     "Similarly to Schafer's package pan, jomo is a package for multilevel
joint modelling multiple imputation @url{Carpenter and Kenward (2013),
http://doi.org/10.1002/9781119942283}.  Novel aspects of jomo are the
possibility of handling binary and categorical data through latent normal
variables, the option to use cluster-specific covariance matrices and to
impute compatibly with the substantive model.")
    (license license:gpl2)))

(define-public r-pan
  (package
    (name "r-pan")
    (version "1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pan" version))
       (sha256
        (base32 "1skfdh8mg3hs9h651shyn80maas71jlbmvn06izym0rpclnj74fd"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/pan/")
    (synopsis "Multiple imputation for multivariate panel or clustered data")
    (description
     "This package implements multiple imputation for multivariate panel or
clustered data.")
    (license license:gpl3)))

(define-public r-mitml
  (package
    (name "r-mitml")
    (version "0.4-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mitml" version))
       (sha256
        (base32
         "1szfw993ma4qn377bab08bkvm4s0sxs5x2hdcj9kgk47661fqsh5"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-haven r-jomo r-pan))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/mitml/")
    (synopsis "Tools for multiple imputation in multilevel modeling")
    (description
     "This package provides tools for multiple imputation of missing data in
multilevel modeling.  It includes a user-friendly interface to the packages
pan and jomo, and several functions for visualization, data management and the
analysis of multiply imputed data sets.")
    (license license:gpl2+)))

(define-public r-mice
  (package
    (name "r-mice")
    (version "3.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mice" version))
       (sha256
        (base32
         "0h20lirk2257y3i1ww5y2pqp9lc21ilmf8yykmz36h55hm8jiw19"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-cpp11
           r-dplyr
           r-generics
           r-glmnet
           r-lattice
           r-mitml
           r-nnet
           r-rcpp
           r-rlang
           r-rpart
           r-tidyr))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/mice/")
    (synopsis "Multivariate imputation by chained equations")
    (description
     "Multiple imputation using @dfn{Fully Conditional Specification} (FCS)
implemented by the MICE algorithm as described in @url{Van Buuren and
Groothuis-Oudshoorn (2011), http://doi.org/10.18637/jss.v045.i03}.  Each
variable has its own imputation model.  Built-in imputation models are
provided for continuous data (predictive mean matching, normal), binary
data (logistic regression), unordered categorical data (polytomous logistic
regression) and ordered categorical data (proportional odds).  MICE can also
impute continuous two-level data (normal model, pan, second-level variables).
Passive imputation can be used to maintain consistency between variables.
Various diagnostic plots are available to inspect the quality of the
imputations.")
    ;; Any of these two versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-transformr
  (package
    (name "r-transformr")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "transformr" version))
       (sha256
        (base32 "125y99wpgvp92qsg7934nzjqy6irjzaj21c0dcq7apqd2hqamfxw"))))
    (properties `((upstream-name . "transformr")))
    (build-system r-build-system)
    (propagated-inputs (list r-cpp11
                             r-lpsolve
                             r-rlang
                             r-sf
                             r-tweenr
                             r-vctrs))
    (home-page "https://github.com/thomasp85/transformr")
    (synopsis "Polygon and path transformations")
    (description
     "In order to smoothly animate the transformation of polygons and paths,
many aspects needs to be taken into account, such as differing number of
control points, changing center of rotation, etc.  The transformr package
provides an extensive framework for manipulating the shapes of polygons and
paths and can be seen as the spatial brother to the tweenr package.")
    (license license:expat)))

(define-public r-truncnorm
  (package
    (name "r-truncnorm")
    (version "1.0-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "truncnorm" version))
       (sha256
        (base32
         "0267gvcg6mmf28x26z6njw373prwpaq8aqkd6aavyhrjsv2aqmji"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/truncnorm/")
    (synopsis "Truncated normal distribution")
    (description "This package provides functions for the truncated normal
distribution with mean equal to @code{mean} and standard deviation equal to
@code{sd}.  It includes density, distribution, quantile, and expected value
functions, as well as a random generation function.")
    (license license:gpl2)))

(define-public r-truncdist
  (package
    (name "r-truncdist")
    (version "1.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "truncdist" version))
       (sha256
        (base32 "02ihw4ixhadwr3sqm6r264i8vpcaz8pn69vkzabd8fwqvn5vcj5q"))))
    (properties `((upstream-name . "truncdist")))
    (build-system r-build-system)
    (propagated-inputs (list r-evd))
    (home-page "https://cran.r-project.org/package=truncdist")
    (synopsis "Truncated random variables")
    (description
     "This package provides a collection of tools to evaluate probability density
functions, cumulative distribution functions, quantile functions and random
numbers for truncated random variables.  These functions are provided to also
compute the expected value and variance.  @acronym{Q-Q, quantile–quantile} plots
can be produced.  All the probability functions in the stats, stats4 and evd
packages are automatically available for truncation.")
    (license license:gpl2+)))

(define-public r-trycatchlog
  (package
    (name "r-trycatchlog")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tryCatchLog" version))
       (sha256
        (base32 "0k40a48qzwmardjnkf0h5s5zryivzvdanz61kxdqdfqlil19ma0d"))))
    (properties `((upstream-name . "tryCatchLog")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/aryoda/tryCatchLog")
    (synopsis "Advanced tryCatch and try functions")
    (description
     "This package provides advanced @code{tryCatch} and @code{try} functions
for better error handling (logging, stack trace with source code references
and support for post-mortem analysis via dump files).")
    (license license:gpl3)))

(define-public r-rsolnp
  (package
    (name "r-rsolnp")
    (version "1.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rsolnp" version))
       (sha256
        (base32
         "0w7nkj6igr0gi7r7jg950lsx7dj6aipgxi6vbjsf5f5yc9h7fhii"))))
    (properties `((upstream-name . "Rsolnp")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-truncnorm))
    (home-page "https://cran.r-project.org/web/packages/Rsolnp/")
    (synopsis "General non-linear optimization")
    (description "The Rsolnp package implements a general non-linear augmented
Lagrange multiplier method solver, a @dfn{sequential quadratic
programming} (SQP) based solver).")
    ;; Any version of the GPL.
    (license license:gpl2+)))

(define-public r-hardyweinberg
  (package
    (name "r-hardyweinberg")
    (version "1.7.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "HardyWeinberg" version))
       (sha256
        (base32
         "1wddy32zljyya37isqb54sqhpp07s2kizjl36i08pj37bbza7yac"))))
    (properties `((upstream-name . "HardyWeinberg")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mice r-nnet r-rcpp r-rsolnp r-shape))
    (native-inputs (list r-knitr r-rmarkdown))
    (home-page "https://cran.r-project.org/package=HardyWeinberg")
    (synopsis "Statistical tests and graphics for Hardy-Weinberg equilibrium")
    (description
     "This package contains tools for exploring Hardy-Weinberg equilibrium for
diallelic genetic marker data.  All classical tests (chi-square, exact,
likelihood-ratio and permutation tests) for Hardy-Weinberg equilibrium are
included in the package, as well as functions for power computation and for
the simulation of marker data under equilibrium and disequilibrium.  Routines
for dealing with markers on the X-chromosome are included.  Functions for
testing equilibrium in the presence of missing data by using multiple
imputation are also provided.  Implements several graphics for exploring the
equilibrium status of a large set of diallelic markers: ternary plots with
acceptance regions, log-ratio plots and Q-Q plots.")
    (license license:gpl2+)))

(define-public r-sm
  (package
    (name "r-sm")
    (version "2.2-6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sm" version))
       (sha256
        (base32
         "0q8xav1alammiyiw2p8y0qq94ag5rln910jry8q3sb2p38ly79i7"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "http://www.stats.gla.ac.uk/~adrian/sm/")
    (synopsis "Smoothing methods for nonparametric regression and density estimation")
    (description
     "This is software accompanying the book 'Applied Smoothing Techniques for
Data Analysis---The Kernel Approach with S-Plus Illustrations', Oxford
University Press.  It provides smoothing methods for nonparametric regression
and density estimation")
    (license license:gpl2+)))

(define-public r-smoof
  (package
    (name "r-smoof")
    (version "1.6.0.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "smoof" version))
              (sha256
               (base32
                "1cazhnd0m5jjzixaqgqh2h3rsa2sw3k8slj5cmgm8v47aaqn91mg"))))
    (properties `((upstream-name . "smoof")))
    (build-system r-build-system)
    (propagated-inputs (list r-bbmisc
                             r-checkmate
                             r-ggplot2
                             r-paramhelpers
                             r-rcpp
                             r-rcpparmadillo))
    (native-inputs (list r-testthat))
    (home-page "https://jakobbossek.github.io/smoof/")
    (synopsis "Single and multi-objective optimization test functions")
    (description
     "This tool generates high number of both single- and multi-objective test
functions.  These functions are frequently used for the benchmarking of
(numerical) optimization algorithms.  Moreover, it offers a set of convenient
functions to generate, plot and work with objective functions.")
    (license license:bsd-2)))

(define-public r-smurf
  (package
    (name "r-smurf")
    (version "1.1.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "smurf" version))
              (sha256
               (base32
                "1gpzzj67x0i70vw1x4rv56mhk2b74ynvdsy93rzmdk6b2h3dvv46"))))
    (properties `((upstream-name . "smurf")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-catdata
           r-glmnet
           r-mass
           r-matrix
           r-mgcv
           r-rcolorbrewer
           r-rcpp
           r-rcpparmadillo))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://gitlab.com/TReynkens/smurf")
    (synopsis "Sparse multi-type regularized feature modeling")
    (description
     "The @code{smurf} package contains the implementation of the
@dfn{Sparse Multi-type Regularized Feature} (SMuRF) modeling algorithm
to fit @dfn{generalized linear models} (GLMs) with multiple types of
predictors via regularized maximum likelihood.  Next to the fitting
procedure, following functionality is available:

@itemize
@item Selection of the regularization tuning parameter lambda using
  three different approaches: in-sample, out-of-sample or using
  cross-validation.
@item S3 methods to handle the fitted object including visualization
  of the coefficients and a model summary.
@end itemize")
    (license license:gpl2+)))

(define-public r-venndiagram
  (package
    (name "r-venndiagram")
    (version "1.7.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "VennDiagram" version))
              (sha256
               (base32
                "0ilcxcp8qskmb5cp7fyb7i0qizg42lrx0ny8ws3if90kfrglghp7"))))
    (properties `((upstream-name . "VennDiagram")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-futile-logger))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/VennDiagram/")
    (synopsis "Generate High-Resolution Venn and Euler Plots")
    (description
     "This package provides a set of functions to generate high-resolution
Venn and Euler plots.  It includes handling for several special cases,
including two-case scaling, and extensive customization of plot shape and
structure.")
    (license license:gpl2+)))

(define-public r-vioplot
  (package
    (name "r-vioplot")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vioplot" version))
       (sha256
        (base32
         "0r89ac9ilz1jwwfgylzscg3c8is7dsy3c4dcl89ksmqhp3692kmh"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-sm r-zoo))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "http://wsopuppenkiste.wiso.uni-goettingen.de/~dadler")
    (synopsis "Violin plot")
    (description
     "This package provides a violin plot, which is a combination of a box
plot and a kernel density plot.")
    (license license:bsd-3)))

(define-public r-rsofia
  (package
    (name "r-rsofia")
    (version "1.1")
    (source (origin
              (method url-fetch)
              ;; This package has been removed from CRAN, so we can
              ;; only fetch it from the archives.
              (uri (string-append "https://cran.r-project.org/src/"
                                  "contrib/Archive/RSofia/RSofia_"
                                  version ".tar.gz"))
              (sha256
               (base32
                "0q931y9rcf6slb0s2lsxhgqrzy4yqwh8hb1124nxg0bjbxvjbihn"))))
    (properties `((upstream-name . "RSofia")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/src/contrib/Archive/RSofia")
    (synopsis "Port of sofia-ml to R")
    (description "This package is a port of sofia-ml to R.  Sofia-ml is a
suite of fast incremental algorithms for machine learning that can be used for
training models for classification or ranking.")
    (license license:asl2.0)))

(define-public r-xts
  (package
    (name "r-xts")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xts" version))
       (sha256
        (base32
         "0kvz75dygr1riyijxsz8vx86fk6yyghilgc9l74lqx405yrnpaax"))
       (modules '((guix build utils)))
       (snippet
        '(with-directory-excursion "inst/doc"
           ;; These files are generated from Rnw files.
           (for-each delete-file
                     (list "xts-faq.R"
                           "xts-faq.Rnw"
                           "xts-faq.pdf"
                           "xts.R"
                           "xts.Rnw"
                           "xts.pdf"))))))
    (build-system r-build-system)
    (propagated-inputs (list r-zoo))
    (home-page "https://github.com/joshuaulrich/xts")
    (synopsis "Extensible time series")
    (description
     "This package provides for uniform handling of R's different time-based
data classes by extending @code{zoo}, maximizing native format information
preservation and allowing for user-level customization and extension, while
simplifying cross-class interoperability.")
    (license license:gpl2+)))

(define-public r-performanceanalytics
  (package
    (name "r-performanceanalytics")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PerformanceAnalytics" version))
       (sha256
        (base32
         "0ci26hsj4wnw9g0mh4vrn0cg986cpcpx169rvw6v6rbnjxq718bq"))))
    (properties
     `((upstream-name . "PerformanceAnalytics")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Needed for vignettes
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-quadprog r-xts r-zoo))
    (native-inputs (list r-hmisc r-r-rsp))
    (home-page "https://r-forge.r-project.org/projects/returnanalytics/")
    (synopsis "Econometric tools for performance and risk analysis")
    (description "This is a collection of econometric functions for
performance and risk analysis.  This package aims to aid practitioners and
researchers in utilizing the latest research in analysis of non-normal return
streams.  In general, it is most tested on return (rather than price) data on
a regular scale, but most functions will work with irregular return data as
well, and increasing numbers of functions will work with P&L or price data
where possible.")
    ;; Either version may be picked.
    (license (list license:gpl2 license:gpl3))))

(define-public r-laeken
  (package
    (name "r-laeken")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "laeken" version))
       (sha256
        (base32
         "02z8jyya6xv0pyfqaalbry174fw44h13s7p1jk5b4h9a9x4myjb0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-mass))
    (home-page "https://cran.r-project.org/web/packages/laeken/")
    (synopsis "Estimation of indicators on social exclusion and poverty")
    (description "This package provides tools for the estimation of indicators
on social exclusion and poverty, as well as an implementation of Pareto tail
modeling for empirical income distributions.")
    (license license:gpl2+)))

(define-public r-vcd
  (package
    (name "r-vcd")
    (version "1.4-13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vcd" version))
       (sha256
        (base32
         "1k7q3nl437bmg1pylivfykwx4l0k104qkypml5b6xvwkwfn65b4x"))))
    (build-system r-build-system)
    ;; Vignettes require r-coin, which needs r-vcd.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs
     (list r-colorspace r-lmtest r-mass))
    (home-page "https://cran.r-project.org/web/packages/vcd/")
    (synopsis "Visualizing categorical data")
    (description "This package provides visualization techniques, data sets,
summary and inference procedures aimed particularly at categorical data.
Special emphasis is given to highly extensible grid graphics.  The package was
originally inspired by the book \"Visualizing Categorical Data\" by Michael
Friendly and is now the main support package for a new book, \"Discrete Data
Analysis with R\" by Michael Friendly and David Meyer (2015).")
    (license license:gpl2)))

(define-public r-vcfr
  (package
   (name "r-vcfr")
   (version "1.15.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "vcfR" version))
            (sha256
             (base32
              "1yj91cphin232m09wrpj8l27vxblyryh658siakz55hxjs5y85yz"))))
   (build-system r-build-system)
   (native-inputs
    (list r-adegenet r-knitr r-testthat))
   (inputs
    (list zlib))
   (propagated-inputs
    (list r-ape
          r-dplyr
          r-magrittr
          r-memuse
          r-pinfsc50
          r-rcpp
          r-stringr
          r-tibble
          r-vegan
          r-viridislite))
   (home-page "https://github.com/knausb/vcfR")
   (synopsis "Manipulate and visualize VCF data")
   (description "This package facilitates easy manipulation of variant call
format (VCF) data.  Functions are provided to rapidly read from and write to
VCF files.  Once VCF data is read into R, a parser function extracts matrices
of data.  This information can then be used for quality control or other
purposes.  Additional functions provide visualization of genomic data.  Once
processing is complete data may be written to a VCF file.  It also may be
converted into other popular R objects.  This package provides a link between
VCF data and familiar R software.")
   (license license:gpl3)))

(define-public r-rvcg
  (package
    (name "r-rvcg")
    (version "0.24")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "Rvcg" version))
              (sha256
               (base32
                "1wjb74izm3k6jgch0vj5dlr8ghj85z7nldfp6kysqyckrbpjvkgx"))))
    (properties `((upstream-name . "Rvcg")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcpparmadillo r-rcppeigen))
    (home-page "https://github.com/zarquon42b/Rvcg")
    (synopsis "Manipulations of triangular meshes based on the VCGLIB API")
    (description
     "This is a package for operations on triangular meshes based on VCGLIB.
This package integrates nicely with the R-package rgl to render the meshes
processed by Rvcg.  The Visualization and Computer Graphics Library (VCG for
short) is a library for manipulation, processing and displaying with OpenGL of
triangle and tetrahedral meshes.")
    (license license:gpl2+)))

(define-public r-ica
  (package
    (name "r-ica")
    (version "1.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ica" version))
       (sha256
        (base32
         "0rdqd3kz2cv3xvf6yz55bwhsg3k7j90d450i3azs2xkbn4q3aka7"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ica/")
    (synopsis "Independent component analysis")
    (description "This package provides tools for @dfn{Independent Component
Analysis} (ICA) using various algorithms: FastICA,
Information-Maximization (Infomax), and @dfn{Joint Approximate Diagonalization
of Eigenmatrices} (JADE).")
    (license license:gpl2+)))

(define-public r-ips
  (package
    (name "r-ips")
    (version "0.0.12")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ips" version))
              (sha256
               (base32
                "0vnsalm94vzagksqv4ph6x7vdwhd1lq278sak30pr4m9bc9xxchw"))))
    (properties `((upstream-name . "ips")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape r-data-table r-phangorn r-plyr r-xml))
    (home-page "https://cran.r-project.org/package=ips")
    (synopsis "Interfaces to phylogenetic software in R")
    (description
     "This package provides functions that wrap popular phylogenetic software
for sequence alignment, masking of sequence alignments, and estimation of
phylogenies and ancestral character states.")
    (license license:gpl3)))

(define-public r-dtwclust
  (package
    (name "r-dtwclust")
    (version "6.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dtwclust" version))
       (sha256
        (base32 "0by01x4qpf1pin5l61wmm600bmsnlnns9knwb0qmjlj72pmwfkqh"))))
    (properties `((upstream-name . "dtwclust")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-clue
           r-cluster
           r-dplyr
           r-dtw
           r-flexclust
           r-foreach
           r-ggplot2
           r-ggrepel
           r-matrix
           r-proxy
           r-rcpp
           r-rcpparmadillo
           r-rcppparallel
           r-rcppthread
           r-reshape2
           r-rlang
           r-rspectra
           r-shiny
           r-shinyjs))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/asardaes/dtwclust")
    (synopsis
     "Clustering time series with dynamic time warping distance optimization")
    (description
     "This package implements time series clustering along with optimized
techniques related to the dynamic time warping distance and its corresponding
lower bounds.  The implementations of partitional, hierarchical, fuzzy, k-Shape
and TADPole clustering are available.  Functionality can be easily extended with
custom distance measures and centroid definitions.  Implementations of @acronym{
DTW, dynamic time warping} barycenter averaging, a distance based on global
alignment kernels, and the soft-DTW distance and centroid routines are also
provided.  All included distance functions have custom loops optimized for the
calculation of cross-distance matrices, including parallelization support.
Several cluster validity indices are included.")
    (license license:gpl3)))

(define-public r-dtw
  (package
    (name "r-dtw")
    (version "1.23-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dtw" version))
       (sha256
        (base32
         "0vc2is1hf1g0sw92kzl8mddck264qwiqgm5q2wkcwwz65fss7mkf"))))
    (build-system r-build-system)
    (propagated-inputs (list r-proxy))
    (home-page "https://dtw.r-forge.r-project.org/")
    (synopsis "Dynamic Time Warping Algorithms")
    (description "This package provides a comprehensive implementation of
@dfn{dynamic time warping} (DTW) algorithms in R.  DTW computes the
optimal (least cumulative distance) alignment between points of two time
series.  Common DTW variants covered include local (slope) and global (window)
constraints, subsequence matches, arbitrary distance definitions,
normalizations, minimum variance matching, and so on.")
    (license license:gpl2+)))

(define-public r-sdmtools
  (package
    (name "r-sdmtools")
    (version "1.1-221.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SDMTools" version))
       (sha256
        (base32
         "1xvcd97ikqsfdpk2fddy3k0z1ajqga7nv9bgac9c1wnjk1gqrpgh"))))
    (properties `((upstream-name . "SDMTools")))
    (build-system r-build-system)
    (propagated-inputs (list r-r-utils))
    (home-page "https://www.rforge.net/SDMTools/")
    (synopsis "Species distribution modelling tools")
    (description "This package provides a set of tools for post processing
the outcomes of species distribution modeling exercises.  It includes novel
methods for comparing models and tracking changes in distributions through
time.  It further includes methods for visualizing outcomes, selecting
thresholds, calculating measures of accuracy and landscape fragmentation
statistics, etc.")
    (license license:gpl3+)))

(define-public r-scatterplot3d
  (package
    (name "r-scatterplot3d")
    (version "0.3-44")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "scatterplot3d" version))
       (sha256
        (base32
         "1hkfislhzx05y5qqa7pvrils3qf9rhxbf37lkpsjbn9yihs0i70w"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/scatterplot3d/")
    (synopsis "3D scatter plot")
    (description "This package provides an implementation of scatter plots for
plotting.  a three dimensional point cloud.")
    (license license:gpl2)))

(define-public r-ggridges
  (package
    (name "r-ggridges")
    (version "0.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggridges" version))
       (sha256
        (base32
         "0dafd10ny6l2rlr1y453rhjiy17a33k15f82nk31238mk8qamk7g"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-scales r-withr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/clauswilke/ggridges")
    (synopsis "Ridgeline plots in ggplot2")
    (description
     "Ridgeline plots provide a convenient way of visualizing changes in
distributions over time or space.  This package enables the creation of such
plots in @code{ggplot2}.")
    (license license:gpl2)))

(define-public r-ggjoy
  (package
    (name "r-ggjoy")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggjoy" version))
       (sha256
        (base32
         "012md2m0jqfcccb933j423m3ck31v3p0pd41gjxpyg9082y7ixyj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-ggridges))
    (home-page "https://github.com/clauswilke/ggjoy")
    (synopsis "Joyplots in ggplot2")
    (description "Joyplots provide a convenient way of visualizing changes in
distributions over time or space.  This package enables the creation of such
plots in @code{ggplot2}.")
    (license license:gpl2)))

(define-public r-gss
  (package
    (name "r-gss")
    (version "2.2-8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gss" version))
              (sha256
               (base32
                "0kkfwzkdabn109lnnlbjjc21q69z5wy65j89003mmzxlvbi2q6xk"))))
    (properties `((upstream-name . "gss")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=gss")
    (synopsis "General smoothing splines")
    (description
     "This package provides a comprehensive collection for structural
multivariate function estimation using smoothing splines.")
    (license license:gpl2+)))

(define-public r-cli
  (package
    (name "r-cli")
    (version "3.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cli" version))
       (sha256
        (base32
         "0ha8mijnzlz1cxsjk502j2gzspd8fnk3j79bvnqm871225ghi5a2"))))
    (properties
     ;; We can't have r-testthat among the inputs, because that would lead to
     ;; a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    (arguments
     (list
      ;; Tests require r-testthat, but that package needs r-cli.
      #:tests? #false
      #:phases
      '(modify-phases %standard-phases
         ;; Do not embed the PID of the build process.
         (add-after 'unpack 'build-reproducibly
           (lambda _
             (setenv "GUIX_BUILD" "yes")
             (substitute* '("R/onload.R" "R/app.R")
               (("\\<- Sys\\.getpid\\(\\)")
                (lambda _
                  (string-append
                   "<- if (Sys.getenv(\"GUIX_BUILD\") == \"\") { Sys.getpid() } else { 12345 }")))))))))
    (home-page "https://github.com/r-lib/cli#readme")
    (synopsis "Helpers for developing command line interfaces")
    (description "This package provides a suite of tools designed to build
attractive command line interfaces (CLIs).  It includes tools for drawing
rules, boxes, trees, and Unicode symbols with ASCII alternatives.")
    (license license:expat)))

(define-public r-argparser
  (package
    (name "r-argparser")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "argparser" version))
       (sha256
        (base32
         "0j9hnbyzbyzclgm4qwyqqkrqcrblxfm190489sgcvr5i7vg2smr8"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/djhshih/argparser")
    (synopsis "Command-line argument parser")
    (description
     "This package provides a cross-platform command-line argument parser
written purely in R with no external dependencies.  It is useful with the
Rscript front-end and facilitates turning an R script into an executable
script.")
    (license license:gpl3+)))

(define-public r-aricode
  (package
    (name "r-aricode")
    (version "1.0.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "aricode" version))
              (sha256
               (base32
                "02nrw66jfpzf6dy0zy21sbdjxjc8c11iv9fkjqj5akzb7wskk9qh"))))
    (properties `((upstream-name . "aricode")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jchiquet/aricode")
    (synopsis "Efficient computations of standard clustering comparison measures")
    (description
     "This package implements an efficient O(n) algorithm based on
bucket-sorting for fast computation of standard clustering comparison
measures.  Available measures include @dfn{adjusted Rand index} (ARI),
@dfn{normalized information distance} (NID), @dfn{normalized mutual
information} (NMI), @dfn{adjusted mutual information} (AMI), @dfn{normalized
variation information} (NVI) and entropy.")
    (license license:gpl3+)))

(define-public r-attempt
  (package
    (name "r-attempt")
    (version "0.3.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "attempt" version))
              (sha256
               (base32
                "1ylgg7jcp8wqmxgf1mydnvh26k0mr8jyjla4hw06730r40yrs58m"))))
    (properties `((upstream-name . "attempt")))
    (build-system r-build-system)
    (propagated-inputs (list r-rlang))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/ColinFay/attempt")
    (synopsis "Tools for defensive programming")
    (description
     "This package provides tools for defensive programming.  It is inspired
by @code{purrr} mappers and based on @code{rlang}.  Attempt extends and
facilitates defensive programming by providing a consistent grammar, and a set
of functions for common tests and conditions.  Attempt only depends on
@code{rlang}, and focuses on speed, so it can be integrated with other
functions and used in the data analysis.")
    (license license:expat)))

(define-public r-debugme
  (package
    (name "r-debugme")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "debugme" version))
       (sha256
        (base32
         "16ghf60rj0l8ypm0hxjp23zxdi2ndq8ii74cilq61m107fnha9mj"))))
    (build-system r-build-system)
    (propagated-inputs (list r-crayon))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-lib/debugme#readme")
    (synopsis "Debug R packages")
    (description
     "This package allows the user to specify debug messages as special string
constants, and control debugging of packages via environment variables.")
    (license license:expat)))

(define-public r-processx
  (package
    (name "r-processx")
    (version "3.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "processx" version))
       (sha256
        (base32 "02z7n59pglz6jw1vyyl0mkc7mz2c7y8yzsnhq5yz62digwnnf9v6"))))
    (properties
     ;; We can't have testthat among the inputs, because that would lead to a
     ;; dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    ;; Tests require r-testthat, which indirectly depends on this package.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-ps r-r6))
    (home-page "https://github.com/r-lib/processx3")
    (synopsis "Execute and control system processes")
    (description
     "This package provides portable tools to run system processes in the
background.  It can check if a background process is running; wait on a
background process to finish; get the exit status of finished processes; kill
background processes and their children; restart processes.  It can read the
standard output and error of the processes, using non-blocking connections.
@code{processx} can poll a process for standard output or error, with a
timeout.  It can also poll several processes at once.")
    (license license:expat)))

(define-public r-timeseries
  (package
    (name "r-timeseries")
    (version "4041.111")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "timeSeries" version))
              (sha256
               (base32
                "0hwazbv91lcxcddas7hwyc86rzl5fbyw6mrpksbyb6025ivj8g85"))))
    (properties `((upstream-name . "timeSeries")))
    (build-system r-build-system)
    ;; Vignettes require a large number of other packages.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-timedate))
    (native-inputs (list r-runit))
    (home-page
     "https://r-forge.r-project.org/scm/viewvc.php/pkg/timeSeries/?root=rmetrics")
    (synopsis "Metrics for financial time series objects")
    (description
     "This package implements S4 classes and various tools for financial time
series.  Basic functions such as scaling and sorting, subsetting, mathematical
operations and statistical functions are provided.")
    (license license:gpl2+)))

(define-public r-tsp
  (package
    (name "r-tsp")
    (version "1.2-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TSP" version))
       (sha256
        (base32
         "1263ay3dar2mzm89nf31gl7n8d983qjiy4qwz7sgv8vwkbz0pg9h"))))
    (properties `((upstream-name . "TSP")))
    (build-system r-build-system)
    (propagated-inputs (list r-foreach))
    (native-inputs (list r-maps r-testthat))
    (home-page "https://cran.r-project.org/web/packages/TSP/")
    (synopsis "Traveling salesperson problem (TSP)")
    (description "This package provides basic infrastructure and some
algorithms for the @dfn{traveling salesperson problem}(TSP) (also known as the
traveling salesman problem).")
    (license license:gpl3)))

(define-public r-qap
  (package
    (name "r-qap")
    (version "0.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qap" version))
       (sha256
        (base32
         "19adb1bw46pcnmmhqz2jklr0vmma3llxajqp0j9mqfksmsisv927"))))
    (build-system r-build-system)
    (native-inputs (list gfortran r-testthat))
    (home-page "https://cran.r-project.org/web/packages/qap/")
    (synopsis "Heuristics for the quadratic assignment problem (QAP)")
    (description "This package implements heuristics for the @dfn{quadratic
assignment problem} (QAP).  Currently only a simulated annealing heuristic is
available.")
    (license license:gpl3)))

(define-public r-gclus
  (package
    (name "r-gclus")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gclus" version))
       (sha256
        (base32
         "1cz0g0i972955hhaji30rx8448x7f3as7z1sww9i5h86ybgirilw"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster))
    (home-page "https://cran.r-project.org/web/packages/gclus/")
    (synopsis "Clustering graphics")
    (description "This package orders panels in scatterplot matrices and
parallel coordinate displays by some merit index.  It contains various indices
of merit, ordering functions, and enhanced versions of @code{pairs} and
@code{parcoord} which color panels according to their merit level.")
    (license license:gpl2+)))

(define-public r-webchem
  (package
    (name "r-webchem")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "webchem" version))
       (sha256
        (base32 "06b9i9jipg564zyw4gkgiidz7501rlp40hxm4z3k5mzy148lr5vq"))))
    (properties `((upstream-name . "webchem")))
    (build-system r-build-system)
    (propagated-inputs (list r-base64enc
                             r-data-tree
                             r-dplyr
                             r-httr
                             r-jsonlite
                             r-purrr
                             r-rlang
                             r-rvest
                             r-stringr
                             r-tibble
                             r-xml2))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/webchem/")
    (synopsis "Chemical information from the web")
    (description
     "This package interacts with a suite of web services for chemical
information.  Sources include: Alan Wood's Compendium of Pesticide Common
Names, Chemical Identifier Resolver, ChEBI, Chemical Translation Service,
ChemSpider, ETOX, Flavornet, NIST Chemistry WebBook, OPSIN, PubChem, SRS,
Wikidata.")
    (license license:expat)))

(define-public r-webshot
  (package
    (name "r-webshot")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "webshot" version))
       (sha256
        (base32
         "04xrrf72323sgzsdkbl05p2fdsi486i9avrrxvw0l3n8r8y92xfn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr r-jsonlite r-magrittr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/wch/webshot/")
    (synopsis "Take screenshots of web pages")
    (description
     "Webshot makes it easy to take screenshots of web pages from within R.
It can also run Shiny applications locally and take screenshots of the
application; and it can render and screenshot static as well as interactive R
Markdown documents.")
    (license license:gpl2)))

(define-public r-seriation
  (package
    (name "r-seriation")
    (version "1.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "seriation" version))
       (sha256
        (base32
         "1a69sxzy6m5kykdr6gcmjqdh50ld0mbl94hi2gb9jcggp3g0d1yz"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ca
           r-cluster
           r-colorspace
           r-foreach
           r-gclus
           r-mass
           r-qap
           r-registry
           r-tsp
           r-vegan))
    (native-inputs (list gfortran r-dendextend r-testthat))
    (home-page "https://s2.smu.edu/IDA/seriation/")
    (synopsis "Infrastructure for ordering objects using seriation")
    (description
     "This package provides infrastructure for seriation with an
implementation of several seriation/sequencing techniques to reorder matrices,
dissimilarity matrices, and dendrograms.  It also provides (optimally)
reordered heatmaps, color images and clustering visualizations like
dissimilarity plots, and visual assessment of cluster tendency plots (VAT and
iVAT).")
    (license license:gpl3)))

(define-public r-xfun
  (package
    (name "r-xfun")
    (version "0.49")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xfun" version))
       (sha256
        (base32 "0xdkn58bj8f0gx10wwl5ak8plk5d4jvv1sh12swahjyabj4h48fd"))))
    (build-system r-build-system)
    (properties
     ;; knitr itself depends on xfun
     '((updater-ignored-native-inputs . ("r-knitr" "r-litedown"))))
    (arguments
     (list
      ;; Do not build vignettes, because they require r-litedown, which
      ;; depends on r-xfun.
      #:test-types '(list "tests")
      #:phases
      '(modify-phases %standard-phases
         ;; Needed for tests
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs (list r-codetools r-testit))
    (home-page "https://github.com/yihui/xfun")
    (synopsis "Miscellaneous functions")
    (description
     "This package provides miscellaneous functions commonly used in other
packages maintained by Yihui Xie.")
    (license license:expat)))

(define-public r-utf8
  (package
    (name "r-utf8")
    (version "1.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "utf8" version))
       (sha256
        (base32
         "0zbv2s5dkzxim3ydyk12479m28f68mak9m50v396in4wpm5q53s1"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-rmarkdown r-testthat)) ; for vignettes
    (home-page "https://github.com/patperry/r-utf8")
    (synopsis "Unicode text processing")
    (description
     "This package provides tools to process and print UTF-8 encoded
international text (Unicode).  Input, validate, normalize, encode, format, and
display.")
    (license license:asl2.0)))

(define-public r-zeallot
  (package
    (name "r-zeallot")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "zeallot" version))
       (sha256
        (base32
         "1sd1igcfnv27pa3bqxlbyxchi562h7grnjg1l7wxx3bwr49i57s3"))))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/nteetor/zeallot")
    (synopsis "Multiple, unpacking, and destructuring assignment")
    (description
     "This package provides a @code{%<-%} operator to perform multiple,
unpacking, and destructuring assignment in R.  The operator unpacks the
right-hand side of an assignment into multiple values and assigns these values
to variables on the left-hand side of the assignment.")
    (license license:expat)))

(define-public r-zlog
  (package
    (name "r-zlog")
    (version "1.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "zlog" version))
              (sha256
               (base32
                "0fi9aqrmikdg5ibwhn82kslj4lxih03vm27jmi14m73h09yy4in5"))))
    (properties `((upstream-name . "zlog")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=zlog")
    (synopsis "Transformation for laboratory easurements")
    (description
     "The @code{zlog} package offers functions to transform laboratory
measurements into standardised z or @math{z(log)-values}.  Therefore the lower
and upper reference limits are needed.  If these are not known they could be
estimated from a given sample.")
    (license license:gpl3+)))

(define-public r-vctrs
  (package
    (name "r-vctrs")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vctrs" version))
       (sha256
        (base32
         "00p4r1z4xc05m25y0qa7svr67lbypcfqyp2b0ja9asgx90i7s5j3"))))
    (properties
     ;; We can't have r-knitr among the inputs here, because r-vctrs ends up
     ;; being an eventual input to r-knitr.
     '((updater-ignored-native-inputs . ("r-knitr" "r-testthat"))))
    (build-system r-build-system)
    ;; Some tests require tibble, which depends on this package.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-cli r-glue r-lifecycle r-rlang))
    (home-page "https://github.com/r-lib/vctrs")
    (synopsis "Vector helpers")
    (description
     "There are three main goals to the @code{vctrs} package:

@enumerate
@item To propose @code{vec_size()} and @code{vec_type()} as alternatives to
  @code{length()} and @code{class()}.  These definitions are paired with a
  framework for type-coercion and size-recycling.
@item To define type- and size-stability as desirable function properties, use
  them to analyse existing base function, and to propose better alternatives.
  This work has been particularly motivated by thinking about the ideal
  properties of @code{c()}, @code{ifelse()}, and @code{rbind()}.
@item To provide a new @code{vctr} base class that makes it easy to create new
  S3 vectors.  @code{vctrs} provides methods for many base generics in terms of
  a few new @code{vctrs} generics, making implementation considerably simpler
  and more robust.
@end enumerate\n")
    (license license:gpl3)))

(define-public r-pillar
  (package
    (name "r-pillar")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pillar" version))
       (sha256
        (base32
         "1k3sp37dpn46d2xbq621alpvzgnm06x5qb87nk169y47q23b8gpj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-fansi
           r-glue
           r-lifecycle
           r-rlang
           r-utf8
           r-vctrs))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/r-lib/pillar")
    (synopsis "Coloured formatting for columns")
    (description
     "This package provides a @code{pillar} generic designed for formatting
columns of data using the full range of colours provided by modern
terminals.")
    (license license:gpl3)))

(define-public r-pinfsc50
  (package
   (name "r-pinfsc50")
   (version "1.3.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "pinfsc50" version))
            (sha256
             (base32
              "1gs9x328qqvqwx3k4z9jgzq5zb6g8kdz4430n96v7zb78p7jf5lp"))))
   (build-system r-build-system)
   (home-page "https://cran.r-project.org/web/packages/pinfsc50/")
   (synopsis "Genomic data for the plant pathogen Phytophthora infestans")
   (description "This package contains genomic data for the plant pathogen
Phytophthora infestans.  It includes a variant file, a sequence file and an
annotation file.  This package is intended to be used as example data for
packages that work with genomic data.")
   (license license:gpl2+)))

(define-public r-piton
  (package
    (name "r-piton")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "piton" version))
       (sha256
        (base32 "1krf6zi238m275nxjlpyayv8y2drbgs2kg19dpkqm0lmlz5y5ar8"))))
    (properties `((upstream-name . "piton")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/Ironholds/piton")
    (synopsis "Parsing expression grammars in Rcpp")
    (description
     "This package provides a wrapper around the Parsing Expression Grammar
Template Library, a C++11 library for generating parsing expression grammars,
that makes it accessible within Rcpp.  With this, developers can implement
their own grammars and easily expose them in R packages.")
    (license license:expat)))

(define-public r-uuid
  (package
    (name "r-uuid")
    (version "1.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "uuid" version))
       (sha256
        (base32
         "15jbzj0i4qphakbi8s9yk55lm8z9s2vhgp5bj77sfvkx7mrlj3pr"))))
    (build-system r-build-system)
    (home-page "https://www.rforge.net/uuid")
    (synopsis "Tools for generating and handling of UUIDs")
    (description
     "This package provides tools for generating and handling of
@dfn{Universally Unique Identifiers} (UUIDs).")
    (license license:expat)))

(define-public r-tinylabels
  (package
    (name "r-tinylabels")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tinylabels" version))
       (sha256
        (base32 "01pvnirma3wzfqnnz8zvyqajjyysjm3sd6813bgdhz199lcg7hhz"))))
    (properties `((upstream-name . "tinylabels")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/mariusbarth/tinylabels")
    (synopsis "Lightweight variable labels")
    (description
     "This package lets you assign, extract, or remove variable labels from R
vectors.")
    (license license:expat)))

(define-public r-tinytex
  (package
    (name "r-tinytex")
    (version "0.54")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tinytex" version))
       (sha256
        (base32
         "1ypzj2zbjvqrpirv3lwzxgvxg0nj042awfyzfkhyafw1lgi4hlgs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-xfun))
    (native-inputs (list r-testit))
    (home-page "https://github.com/yihui/tinytex")
    (synopsis "Helper functions for TeX Live and compiling LaTeX documents")
    (description
     "This package provides helper functions to install and maintain the LaTeX
distribution named TinyTeX, a lightweight, cross-platform, portable, and
easy-to-maintain version of TeX Live.  This package also contains helper
functions to compile LaTeX documents, and install missing LaTeX packages
automatically.")
    (license license:expat)))

(define-public r-tinytest
  (package
    (name "r-tinytest")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tinytest" version))
       (sha256
        (base32
         "0x0w1fiqd98vmpz8yrp9ig0ry1wfr16g6bkjzd2a8sq9gn417z7n"))))
    (properties `((upstream-name . "tinytest")))
    (build-system r-build-system)
    ;; Vignettes complain about a missing file, which is in fact there.
    (arguments (list #:test-types '(list "tests")))
    (home-page "https://github.com/markvanderloo/tinytest")
    (synopsis "Lightweight unit testing framework")
    (description
     "This package provides a lightweight unit testing framework.  Main
features:

@enumerate
@item install tests with the package;
@item test results are treated as data that can be stored and manipulated;
@item test files are R scripts interspersed with test commands, that can be
  programmed over;
@item fully automated build-install-test sequence for packages;
@item skip tests when not run locally (e.g. on CRAN);
@item flexible and configurable output printing;
@item compare computed output with output stored with the package;
@item run tests in parallel;
@item extensible by other packages;
@item report side effects.
@end enumerate
")
    (license license:gpl3)))

(define-public r-n2r
  (package
    (name "r-n2r")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "N2R" version))
       (sha256
        (base32 "0bbxl0y36bmsxwi4rs4f6jwhf9bhag2rkvvzcg5669vgm2p4scjr"))))
    (properties `((upstream-name . "N2R")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix
           r-rcpp
           r-rcppeigen
           r-rcppspdlog))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/kharchenkolab/N2R")
    (synopsis "Fast and scalable approximate k-Nearest Neighbor search methods")
    (description
     "This package implements methods to perform fast approximate K-nearest
neighbor search on the input matrix.  The algorithm is based on the N2
implementation of an approximate nearest neighbor search using hierarchical
@acronym{NSW, Navigable Small World} graphs.")
    (license license:asl2.0)))

(define-public r-nestedcv
  (package
    (name "r-nestedcv")
    (version "0.7.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nestedcv" version))
       (sha256
        (base32 "1cfxw9pblrn2f0bw448sxdnj7pb04l1pkfdajzcmg9yn95k1v95b"))))
    (properties `((upstream-name . "nestedcv")))
    (build-system r-build-system)
    (propagated-inputs (list r-caret
                             r-data-table
                             r-doparallel
                             r-foreach
                             r-ggplot2
                             r-glmnet
                             r-matrixstats
                             r-matrixtests
                             r-proc
                             r-rfast
                             r-rhpcblasctl
                             r-rlang
                             r-rocr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/myles-lewis/nestedcv")
    (synopsis "Nested cross-validation with glmnet and caret")
    (description
     "This package implements nested cross-validation applied to the
@code{glmnet} and @code{caret} packages.  With glmnet this includes
cross-validation of elastic net alpha parameter.  A number of feature
selection filter functions (t-test, Wilcoxon test, ANOVA, Pearson/Spearman
correlation, random forest, ReliefF) for feature selection are provided and
can be embedded within the outer loop of the nested CV.  Nested CV can be also
be performed with the @code{caret} package giving access to the large number
of prediction methods available in @code{caret}.")
    (license license:expat)))

(define-public r-network
  (package
    (name "r-network")
    (version "1.18.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "network" version))
       (sha256
        (base32
         "0yx20v3izm7037cx5swc19966z97w7q9xw4p2p6skfyap4nqjcxz"))))
    (build-system r-build-system)
    (arguments
     (list
      ;; Vignettes require r-sna, which depends on r-network.
      #:test-types '(list "tests")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; One test requires access to the internet.
             (delete-file "tests/testthat/test-read.paj.R"))))))
    (propagated-inputs
     (list r-magrittr r-statnet-common r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://statnet.org/")
    (synopsis "Classes for relational data")
    (description
     "This package provides tools to create and modify network objects.  The
@code{network} class can represent a range of relational data types, and
supports arbitrary vertex/edge/graph attributes.")
    (license license:gpl2+)))

(define-public r-nistunits
  (package
    (name "r-nistunits")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NISTunits" version))
       (sha256
        (base32 "0km9l3k9p35sb1qrhrz4ijjsdihvsp6j7cz5kh46lgf7nn6xdk7a"))))
    (properties `((upstream-name . "NISTunits")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=NISTunits")
    (synopsis "Fundamental physical constants and unit conversions")
    (description
     "This package provides fundamental physical constants (quantity, value,
uncertainty, unit) for @acronym{SI, International System of Units} and non-SI
units, plus unit conversions based on the data from @acronym{NIST, National
Institute of Standards and Technology}, USA.")
    (license license:gpl3+)))

(define-public r-numero
  (package
    (name "r-numero")
    (version "1.9.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Numero" version))
       (sha256
        (base32 "04pf6x7qmgkfyj98c23maxcvlwwwfw6jas7l72xp0713lyndjl15"))))
    (properties `((upstream-name . "Numero")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr r-rmarkdown))
    (home-page "https://cran.r-project.org/package=Numero")
    (synopsis "Statistical framework to define subgroups in complex datasets")
    (description
     "The package includes the necessary functions to construct a
self-organizing map of data, to evaluate the statistical significance of the
observed data patterns, and to visualize the results.")
    (license license:gpl2+)))

(define-public r-stabs
  (package
    (name "r-stabs")
    (version "0.6-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stabs" version))
       (sha256
        (base32
         "1nf1yg14cgxrs4np1yghpzw1nczaslfv3rvf3918wrlzg0vp6l7q"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/hofnerb/stabs")
    (synopsis "Stability selection with error control")
    (description
     "This package provides resampling procedures to assess the stability of
selected variables with additional finite sample error control for
high-dimensional variable selection procedures such as Lasso or boosting.
Both, standard stability selection (Meinshausen & Buhlmann, 2010) and
complementary pairs stability selection with improved error bounds
(Shah & Samworth, 2013) are implemented.  The package can be combined with
arbitrary user specified variable selection approaches.")
    (license license:gpl2)))

(define-public r-rle
  (package
    (name "r-rle")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rle" version))
       (sha256
        (base32
         "0sagl0jggg40lihzy7pfq4593rfvc3b3f7g6ggi85s7n18qvwg40"))))
    (properties `((upstream-name . "rle")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rle/")
    (synopsis "Common functions for run-length encoded vectors")
    (description
     "This package provides common @code{base} and @code{stats} methods for
@code{rle} objects, aiming to make it possible to treat them transparently as
vectors.")
    (license license:gpl3)))

(define-public r-statnet-common
  (package
    (name "r-statnet-common")
    (version "4.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (cran-uri "statnet.common" version))
        (sha256
          (base32
            "1hs16lqi0flr6bnyh6ajhhs9l49aldq0j9iljr4bgxw67cyxifmp"))))
    (properties
      `((upstream-name . "statnet.common")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-coda r-matrix))
    (home-page "https://statnet.org")
    (synopsis "R scripts and utilities used by the Statnet software")
    (description "This package provides non-statistical utilities used by the
software developed by the Statnet Project.")
    (license license:gpl3)))

(define-public r-statcheck
  (package
    (name "r-statcheck")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "statcheck" version))
       (sha256
        (base32
         "0gsr068if5k8124x1cbm48720l9qvnfmdg6rmh7rwh6jvxxgknd7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-plyr r-rlang r-rmarkdown r-stringi))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/statcheck/")
    (synopsis "Extract statistics from articles and recompute p-values")
    (description "This package can automatically extract statistical
null-hypothesis significant testing (NHST) results from articles and recompute
the p-values based on the reported test statistic and degrees of freedom to
detect possible inconsistencies.")
    (license license:gpl2)))

(define-public r-sna
  (package
    (name "r-sna")
    (version "2.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sna" version))
       (sha256
        (base32
         "0k4r5a3p3ngdc8szy6xdvgaibasggcrpb5hdxplnmmawa27dn2pj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-network r-statnet-common))
    (home-page "https://statnet.org")
    (synopsis "Tools for social network analysis")
    (description
     "This package provides a range of tools for social network analysis,
including node and graph-level indices, structural distance and covariance
methods, structural equivalence detection, network regression, random graph
generation, and 2D/3D network visualization.")
    (license license:gpl2+)))

(define-public r-tfisher
  (package
    (name "r-tfisher")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TFisher" version))
       (sha256
        (base32
         "0vz74ww1lf1prfwz74hfsi3a8nzq8ss7aqjr85c1d87vss2796xx"))))
    (properties `((upstream-name . "TFisher")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-mvtnorm r-sn))
    (home-page "https://cran.r-project.org/web/packages/TFisher/")
    (synopsis "Optimal thresholding Fisher's p-value combination method")
    (description
     "This package provides the @dfn{cumulative distribution function} (CDF),
quantile, and statistical power calculator for a collection of thresholding
Fisher's p-value combination methods, including Fisher's p-value combination
method, truncated product method and, in particular, soft-thresholding
Fisher's p-value combination method which is proven to be optimal in some
context of signal detection.  The p-value calculator for the omnibus version
of these tests are also included.")
    (license license:gpl2)))

(define-public r-ttr
  (package
    (name "r-ttr")
    (version "0.24.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TTR" version))
       (sha256
        (base32
         "1102f4i776asqb281mq20ymhzhcp12gn9nr3rm0jzblv6nf2nww9"))))
    (properties `((upstream-name . "TTR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl r-xts r-zoo))
    (native-inputs (list r-runit))
    (home-page "https://github.com/joshuaulrich/TTR")
    (synopsis "Technical trading rules")
    (description
     "This package provides functions and data to construct technical trading
rules with R.")
    (license license:gpl2)))

(define-public r-leaflet-providers
  (package
    (name "r-leaflet-providers")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leaflet.providers" version))
       (sha256
        (base32 "0rl69bfx2l10x80rl8cppqch3fnd05sk9w29h8589jc8h3ffmkn5"))))
    (properties `((upstream-name . "leaflet.providers")))
    (build-system r-build-system)
    (propagated-inputs (list r-htmltools))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/rstudio/leaflet.providers")
    (synopsis "Leaflet map tile providers")
    (description
     "This package contains third-party map tile provider information from
Leaflet.js, to be used with the @code{leaflet} R package.  Additionally,
@code{leaflet.providers} enables users to retrieve up-to-date provider
information between package updates.")
    (license license:bsd-2)))

;; This package contains a lot of minified JavaScript with unclear provenance.
;; When upgrading please make sure that all minified JavaScript files are
;; removed in a snippet and that the replacement sources correspond to the
;; original minified scripts.
(define-public r-leaflet
  (package
    (name "r-leaflet")
    (version "2.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leaflet" version))
       (sha256
        (base32 "1sxq38dcjhn1bkav7fxglzk8nwi5p32jia2nhijcq5j1766pp1yj"))
       (snippet
        '(for-each
          delete-file
          (list "inst/htmlwidgets/lib/leaflet/leaflet.js"
                "inst/htmlwidgets/lib/leaflet-measure/leaflet-measure.min.js"
                "inst/htmlwidgets/lib/leaflet-omnivore/leaflet-omnivore.min.js"
                "inst/htmlwidgets/plugins/Leaflet-MiniMap/Control.MiniMap.min.js"
                "inst/htmlwidgets/plugins/Leaflet.awesome-markers/bootstrap.min.js"
                "inst/htmlwidgets/plugins/Leaflet.awesome-markers/leaflet.awesome-markers.min.js"
                "inst/htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.js"
                "inst/htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.freezable.js"
                "inst/htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.layersupport.js"
                "inst/legacy/www/leaflet.js")))))
    (properties `((upstream-name . "leaflet")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             ;; The inst directory contains some minified JavaScript files.
             ;; Regenerate them from sources.
             (invoke "unzip" "-d" "/tmp" (assoc-ref inputs "js-leaflet"))
             (with-directory-excursion "inst/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `(("/tmp/leaflet-src.js"
                         "htmlwidgets/lib/leaflet/leaflet.js")
                        (,(assoc-ref inputs "js-leaflet-measure")
                         "htmlwidgets/lib/leaflet-measure/leaflet-measure.min.js")
                        (,(assoc-ref inputs "js-leaflet-omnivore")
                         "htmlwidgets/lib/leaflet-omnivore/leaflet-omnivore.min.js")
                        ("htmlwidgets/plugins/Leaflet-MiniMap/Control.MiniMap.js"
                         "htmlwidgets/plugins/Leaflet-MiniMap/Control.MiniMap.min.js")
                        (,(assoc-ref inputs "js-bootstrap3")
                         "htmlwidgets/plugins/Leaflet.awesome-markers/bootstrap.min.js")
                        ("htmlwidgets/plugins/Leaflet.awesome-markers/leaflet.awesome-markers.js"
                         "htmlwidgets/plugins/Leaflet.awesome-markers/leaflet.awesome-markers.min.js")
                        (,(string-append (assoc-ref inputs "js-leaflet-markercluster")
                                         "/dist/leaflet.markercluster-src.js")
                         "htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.js")
                        (,(assoc-ref inputs "js-leaflet-markercluster-freezable")
                         "htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.freezable.js")
                        (,(assoc-ref inputs "js-leaflet-markercluster-layersupport")
                         "htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.layersupport.js")
                        (,(assoc-ref inputs "js-proj4leaflet")
                         "htmlwidgets/plugins/Proj4Leaflet/proj4.min.js")
                        ("legacy/www/leaflet-src.js"
                         "legacy/www/leaflet.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #true "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("unzip" ,unzip)
       ("js-bootstrap3"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/v3.3.7/dist/js/bootstrap.js")
           (sha256
            (base32
             "1j1qjagwj0m3q322z9wxxnpkd8zbk6g3kl047dsbmqad6gmqvgha"))))
       ("js-leaflet"
        ,(origin
           (method url-fetch)
           (uri "http://cdn.leafletjs.com/leaflet/v1.3.1/leaflet.zip")
           (sha256
            (base32
             "10phzd2vczy3zm1b64whp2nna69cf9hlj2bndc9yq47vf3ddqx8f"))))
       ("js-leaflet-omnivore"
        ,(origin
           (method url-fetch)
           (uri (string-append "https://api.tiles.mapbox.com/mapbox.js/plugins/"
                               "leaflet-omnivore/v0.3.1/leaflet-omnivore.js"))
           (sha256
            (base32
             "1b8zxrp6xwzpw25apn8j4qws0f6sr7qr7h2va5h1mjyfqvn29anq"))))
       ("js-leaflet-markercluster"
        ,(origin
           (method git-fetch)
           (uri (git-reference
                 (url "https://github.com/Leaflet/Leaflet.markercluster.git")
                 (commit "v1.1.0")))
           (file-name (git-file-name "js-leaflet-markercluster" "1.1.0"))
           (sha256
            (base32
             "0ds8c7picqjmc86bm5n6hm8k71fwsa2cpgib19sbdamzr9hm0rs1"))))
       ("js-leaflet-markercluster-freezable"
        ,(origin
           (method url-fetch)
           (uri (string-append
                 "https://raw.githubusercontent.com/ghybs/Leaflet.MarkerCluster.Freezable/"
                 "9db80a3fba7dff4aee940e05d3d4dceaa1fffcf9/src/freezable.js"))
           (file-name "leaflet-markercluster-freezable.js")
           (sha256
            (base32
             "1k6sn5n0z2x3an91vwvkzmqq4b8ppswgk5hi5qrr79klas1hbx1k"))))
       ("js-leaflet-markercluster-layersupport"
        ,(origin
           (method url-fetch)
           (uri (string-append
                 "https://raw.githubusercontent.com/ghybs/Leaflet.MarkerCluster.LayerSupport/"
                 "87f3848b92e0516d9c98f6d4cd175f7b8a4e3805/src/layersupport.js"))
           (file-name "leaflet-markercluster-layersupport.js")
           (sha256
            (base32
             "15qa21xif94y762c65yxxysxykz3mma6y6agw3nxpr3s7wbb75ff"))))
       ("js-leaflet-measure"
        ,(origin
           (method url-fetch)
           (uri "https://unpkg.com/leaflet-measure@1.5.2/dist/leaflet-measure.js")
           (file-name "js-leaflet-measure-1.5.2.js")
           (sha256
            (base32
             "0ggg3ffmm7pj9ry4gssrh0a17pnad3p6gwi0dg98y819pmpqa7y0"))))
       ("js-proj4leaflet"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/kartena/Proj4Leaflet/1.0.2/lib/proj4.js")
           (file-name "js-proj4leaflet-1.0.2.js")
           (sha256
            (base32
             "0vyrbf6gv2lyh4c2bzp5349ivwvvg28gpn87y52a7jdb13rlkpab"))))
       ("r-testthat" ,r-testthat)))
    (propagated-inputs
     (list r-crosstalk
           r-htmltools
           r-htmlwidgets
           r-jquerylib
           r-leaflet-providers
           r-magrittr
           r-png
           r-raster
           r-rcolorbrewer
           r-scales
           r-sp
           r-viridislite
           r-xfun))
    (home-page "https://rstudio.github.io/leaflet/")
    (synopsis "Create interactive web maps with the JavaScript Leaflet library")
    (description
     "Create and customize interactive maps using the Leaflet JavaScript
library and the @code{htmlwidgets} package.  These maps can be used directly
from the R console, from RStudio, in Shiny applications and R Markdown
documents.")
    (license license:gpl3)))

(define-public r-leaps
  (package
    (name "r-leaps")
    (version "3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leaps" version))
       (sha256
        (base32
         "1bbgm6l12gj1y28ks21awxphpmp07hb0ffiyrw7dqp3fcyxvxmm0"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/leaps/")
    (synopsis "Regression subset selection")
    (description
     "This package provides tools for regression subset selection, including
exhaustive search.")
    (license license:gpl2+)))

(define-public r-splus2r
  (package
    (name "r-splus2r")
    (version "1.3-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "splus2R" version))
       (sha256
        (base32
         "097bpzazw5ryb6izbmz2sdlghn3qvh7c7wsnn0j08j65f9bfmc77"))))
    (properties `((upstream-name . "splus2R")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/splus2R/")
    (synopsis "Supplemental S-PLUS functionality in R")
    (description
     "Currently there are many functions in S-PLUS that are missing in R.  To
facilitate the conversion of S-PLUS packages to R packages, this package
provides some missing S-PLUS functionality in R.")
    (license license:gpl2)))

(define-public r-ifultools
  (package
    (name "r-ifultools")
    (version "2.0-26")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ifultools" version))
       (sha256
        (base32
         "1lkmzrh65j6vdb8523axxk9gig5q4zxy08wiqsp16w482d2q2sl1"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      `(modify-phases %standard-phases
         (add-after 'unpack 'compatibility
           (lambda _
             ;; These definitions are no longer part of R since 4.2.0.  See
             ;; https://cran.r-project.org/doc/manuals/r-devel/NEWS.html for
             ;; details.
             (substitute* "inst/include/ut_RS.h"
               (("#include \"R.h\"" m)
                (string-append "\
#define R_PROBLEM_BUFSIZE 4096
#define PROBLEM	{char R_problem_buf[R_PROBLEM_BUFSIZE];(sprintf)(R_problem_buf,
#define MESSAGE {char R_problem_buf[R_PROBLEM_BUFSIZE];(sprintf)(R_problem_buf,
#define ERROR	),error(R_problem_buf);}
#define WARNING(x)		),warning(R_problem_buf);}
#define WARN			WARNING(NULL)
" m))))))))
    (propagated-inputs
     (list r-mass r-splus2r))
    (home-page "https://cran.r-project.org/web/packages/ifultools/")
    (synopsis "Insightful research tools")
    (description "This package provides C code used by the wmtsa, fractal, and
sapa R packages.")
    (license license:gpl2)))

(define-public r-sapa
  (package
    (name "r-sapa")
    (version "2.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sapa" version))
       (sha256
        (base32
         "0kj681rd4c2lvqr926lb6f4qwp281x5274dg6vbk8pf5y7s0qlpc"))
       (patches (search-patches "r-sapa-lapack.patch"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ifultools r-splus2r))
    (home-page "https://cran.r-project.org/web/packages/sapa/")
    (synopsis "Spectral analysis for physical applications")
    (description "This package provides software for the book Spectral
Analysis for Physical Applications, Donald B. Percival and Andrew T. Walden,
Cambridge University Press, 1993.")
    (license license:gpl2)))

(define-public r-aggregation
  (package
    (name "r-aggregation")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aggregation" version))
       (sha256
        (base32
         "0j9g604m2ccc7hcy02539yja9cf3xcbl25gvp838bp4x8w18my46"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/aggregation/")
    (synopsis "Methods for p-value aggregation")
    (description
     "This package contains functionality for performing the following methods
of p-value aggregation: Fisher's method, the Lancaster method (weighted
Fisher's method), and Sidak correction.")
    (license license:gpl3)))

(define-public r-quantmod
  (package
    (name "r-quantmod")
    (version "0.4.26")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "quantmod" version))
       (sha256
        (base32
         "165vp2ygry8ibcpxjbyfvfrjbv98syln12kkyzci2ygp84r5sv1r"))))
    (build-system r-build-system)
    (arguments
     (list
      ;; FIXME: identical(sQuote(api.key), default.key) is not TRUE
      #:tests? #false
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'build-reproducibly
           (lambda _
             (substitute* "R/buildModel.R"
               (("Sys.time\\(\\)")
                "if (\"\" != Sys.getenv(\"SOURCE_DATE_EPOCH\")) {\
 as.numeric(Sys.getenv(\"SOURCE_DATE_EPOCH\"))\
} else { Sys.time() }\n")))))))
    (propagated-inputs
     (list r-curl r-jsonlite r-ttr r-xts r-zoo))
    (home-page "https://cran.r-project.org/web/packages/quantmod/")
    (synopsis "Quantitative financial modelling framework")
    (description "This package provides a quantitative financial modelling
framework to allow users to specify, build, trade, and analyse quantitative
financial trading strategies.")
    (license license:gpl3)))

(define-public r-tseries
  (package
    (name "r-tseries")
    (version "0.10-58")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tseries" version))
       (sha256
        (base32
         "0957pi65myp6qnrk710kcbw83401v226lsxdxkas73mv84cygphf"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-jsonlite r-quadprog r-quantmod r-zoo))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/tseries/")
    (synopsis "Time series analysis and computational finance")
    (description
     "This package provides functions relating to time series analysis and
computational finance.")
    (license license:gpl2)))

(define-public r-wmtsa
  (package
    (name "r-wmtsa")
    (version "2.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wmtsa" version))
       (sha256
        (base32
         "1q436krz5p1f4a7a7sya6a9rh9x9mi8zzcgq66gbk9w9w4hcqcj6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ifultools r-mass r-splus2r))
    (home-page "https://cran.r-project.org/web/packages/wmtsa/")
    (synopsis "Wavelet methods for time series analysis")
    (description
     "This package provides software to accompany the book \"Wavelet Methods
for Time Series Analysis\", Donald B. Percival and Andrew T. Walden, Cambridge
University Press, 2000.")
    (license license:gpl2)))

(define-public r-tsa
  (package
    (name "r-tsa")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TSA" version))
       (sha256
        (base32
         "14g58s2w7wma1fgcg3b51267b3676zrv0w8v4hpypxygz023d9bx"))))
    (properties `((upstream-name . "TSA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-leaps r-locfit r-mgcv r-tseries))
    (home-page "https://homepage.divms.uiowa.edu/~kchan/TSA.htm")
    (synopsis "Time series analysis")
    (description
     "This package contains R functions and datasets detailed in the book
\"Time Series Analysis with Applications in R (second edition)\" by Jonathan
Cryer and Kung-Sik Chan.")
    (license license:gpl2+)))

(define-public r-extradistr
  (package
    (name "r-extradistr")
    (version "1.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "extraDistr" version))
       (sha256
        (base32
         "1ad3xp4axbbid9i9vd4q8iccs3g3917yic2mas37mfwm5in4l9pl"))))
    (properties `((upstream-name . "extraDistr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/twolodzko/extraDistr")
    (synopsis "Additional univariate and multivariate distributions")
    (description
     "This package implements density, distribution functions, quantile
functions and random generation functions for a large number of univariate and
multivariate distributions.")
    (license license:gpl2)))

(define-public r-fbasics
  (package
    (name "r-fbasics")
    (version "4041.97")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "fBasics" version))
              (sha256
               (base32
                "1aqm973km7z8b6r90j3dcqi7dgf8fxcjb5ps2q3f14p80rg0ahlr"))))
    (properties `((upstream-name . "fBasics")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gss
           r-mass
           r-spatial
           r-stabledist
           r-timedate
           r-timeseries))
    (native-inputs (list r-runit))
    (home-page
     "https://r-forge.r-project.org/scm/viewvc.php/pkg/fBasics/?root=rmetrics")
    (synopsis "Metrics for markets and basic statistics")
    (description
     "This package provides a collection of functions to explore and to
investigate basic properties of financial returns and related quantities.  The
covered fields include techniques of explorative data analysis and the
investigation of distributional properties, including parameter estimation and
hypothesis testing.  Even more, there are several utility functions for data
handling and management.")
    (license license:gpl2+)))

(define-public r-fractal
  (package
    (name "r-fractal")
    (version "2.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fractal" version))
       (sha256
        (base32
         "18lr9z0gslvfc3z8vyj3krqj3bfhg60zv1fzinrwwkc4cpk1w7mp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ifultools
           r-mass
           r-sapa
           r-scatterplot3d
           r-splus2r
           r-wmtsa))
    (home-page "https://cran.r-project.org/web/packages/fractal/")
    (synopsis "Fractal time series modeling and analysis")
    (description
     "This package provides tools for stochastic fractal and deterministic
chaotic time series analysis.")
    (license license:gpl2)))

(define-public r-fresh
  (package
    (name "r-fresh")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "fresh" version))
              (sha256
               (base32
                "19ki4hxlqzshdmy981gcvbn8wxqa893p5rs55l0q7iipkcmhf9jq"))))
    (properties `((upstream-name . "fresh")))
    (build-system r-build-system)
    (propagated-inputs (list r-bslib r-htmltools r-rstudioapi r-sass r-shiny))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/dreamRs/fresh")
    (synopsis "Create custom Bootstrap themes to use in Shiny")
    (description
     "Customize Bootstrap and Bootswatch themes, like colors, fonts,
grid layout, to use in Shiny applications, rmarkdown documents and
flexdashboard.")
    (license license:gpl3)))

(define-public r-urca
  (package
    (name "r-urca")
    (version "1.3-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "urca" version))
       (sha256
        (base32
         "05nb1an5a8r0w6gca6cf40nws2v4hxhznz8kyfm7q7hz0kjnqggy"))))
    (build-system r-build-system)
    (propagated-inputs (list r-nlme))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/urca/")
    (synopsis "Unit root and cointegration tests for time series data")
    (description
     "This package provides unit root and cointegration tests encountered in
applied econometric analysis.")
    (license license:gpl2+)))

(define-public r-cubature
  (package
    (name "r-cubature")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cubature" version))
       (sha256
        (base32
         "1156gv8ca3k034f34h50g0a4dg65dpv9d676i7h11rpl6gkj0wmk"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/bnaras/cubature")
    (synopsis "Adaptive multivariate integration over hypercubes")
    (description
     "This package is an R wrapper around the cubature C library for adaptive
multivariate integration over hypercubes.  This version provides both
@code{hcubature} and @code{pcubature} routines in addition to a vector
interface.")
    ;; The included cubature C library is released under GPLv2+, but the
    ;; wrapper declares the license to be GPLv3+.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-trend
  (package
    (name "r-trend")
    (version "1.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "trend" version))
       (sha256
        (base32
         "0991fp6kjk704rfg0l1m7kwbck9fj1rg27zy4llm5ikczd55w05h"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-extradistr))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/trend/")
    (synopsis "Non-parametric trend tests and change-point detection")
    (description
     "The analysis of environmental data often requires the detection of
trends and change-points.  This package includes tests for trend
detection (Cox-Stuart Trend Test, Mann-Kendall Trend Test, (correlated)
Hirsch-Slack Test, partial Mann-Kendall Trend Test, multivariate (multisite)
Mann-Kendall Trend Test, (Seasonal) Sen's slope, partial Pearson and Spearman
correlation trend test), change-point detection (Lanzante's test procedures,
Pettitt's test, Buishand Range Test, Buishand U Test, Standard Normal
Homogeinity Test), detection of non-randomness (Wallis-Moore Phase Frequency
Test, Bartels rank von Neumann's ratio test, Wald-Wolfowitz Test) and the two
sample Robust Rank-Order Distributional Test.")
    (license license:gpl3)))

(define-public r-expm
  (package
    (name "r-expm")
    (version "1.0-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "expm" version))
       (sha256
        (base32
         "0m5jm92mjn83zvh4jz7rdf04jdaad7lv2l0a44rb2mdgyvw3di82"))))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix))
    (native-inputs (list gfortran))
    (home-page "https://r-forge.r-project.org/projects/expm/")
    (synopsis "Tools for matrix exponentials and related quantities")
    (description
     "This package provides tools for the computation of the matrix
exponential, logarithm, square root, and related quantities.")
    (license license:gpl2+)))

(define-public r-exposition
  (package
    (name "r-exposition")
    (version "2.8.23")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ExPosition" version))
              (sha256
               (base32
                "0x9400ggmgrnaish0cfgnyvw549g4ibfv9aj6vzq7j68n58vq405"))))
    (properties `((upstream-name . "ExPosition")))
    (build-system r-build-system)
    (propagated-inputs (list r-prettygraphs))
    (home-page "https://cran.r-project.org/package=ExPosition")
    (synopsis "Exploratory analysis with the singular value decomposition")
    (description
     "This package provides a variety of descriptive multivariate analyses
with the singular value decomposition, such as principal components analysis,
correspondence analysis, and multidimensional scaling.  See An ExPosition of
the Singular Value Decomposition in R (Beaton et al 2014)
<doi:10.1016/j.csda.2013.11.006>.")
    (license license:gpl2)))

(define-public r-complexplus
  (package
    (name "r-complexplus")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "complexplus" version))
       (sha256
        (base32
         "16w9v7d1ckavqmr86l34frr37pkvdn0iqnb17ssb8xaggns5lgqx"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-expm r-matrix))
    (home-page "https://cran.r-project.org/web/packages/complexplus/")
    (synopsis "Functions of complex or real variables")
    (description
     "This package extends several functions to the complex domain, including
the matrix exponential and logarithm, and the determinant.")
    (license license:gpl2)))

(define-public r-complexupset
  (package
    (name "r-complexupset")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ComplexUpset" version))
       (sha256
        (base32 "1sk4v5kc2wkgfaws0hjlp30mngm907r5gz1iglf68j46lfs9jbsv"))))
    (properties `((upstream-name . "ComplexUpset")))
    (build-system r-build-system)
    (propagated-inputs (list r-colorspace r-ggplot2 r-patchwork r-scales))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/krassowski/complex-upset")
    (synopsis "Create complex UpSet plots using ggplot2 components")
    (description
     "@code{UpSet} plots are an improvement over Venn Diagram for set overlap
visualizations.  Striving to bring the best of the @code{UpSetR} and ggplot2,
this package offers a way to create complex overlap visualisations, using
simple and familiar tools.")
    (license license:expat)))

(define-public r-phontools
  (package
    (name "r-phontools")
    (version "0.2-2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "phonTools" version))
       (sha256
        (base32
         "0r5ylbxvzpa23yys4rxdlglfc5jq997ziw6yf8v9jyavy4p1ppkx"))))
    (properties `((upstream-name . "phonTools")))
    (build-system r-build-system)
    (home-page "http://www.santiagobarreda.com/rscripts.html")
    (synopsis "Tools for phonetic and acoustic analyses")
    (description
     "This package contains tools for the organization, display, and analysis
of the sorts of data frequently encountered in phonetics research and
experimentation, including the easy creation of IPA vowel plots, and the
creation and manipulation of WAVE audio files.")
    (license license:bsd-2)))

(define-public r-np
  (package
    (name "r-np")
    (version "0.60-17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "np" version))
       (sha256
        (base32
         "0dkz8aing2zdah83sjs874cxgwyzx82x60idziqfbhjf4g5mfyfr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-cubature r-quadprog r-quantreg))
    (home-page "https://github.com/JeffreyRacine/R-Package-np")
    (synopsis "Non-parametric kernel smoothing methods for mixed data types")
    (description "This package provides non-parametric (and semi-parametric)
kernel methods that seamlessly handle a mix of continuous, unordered, and
ordered factor data types.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-powerplus
  (package
    (name "r-powerplus")
    (version "3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "powerplus" version))
       (sha256
        (base32
         "0ayp6x34hkzgris4j3zbbs0r23n81bhww3wgfyy630ri4sk6brrn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-complexplus r-expm r-mass r-matrix r-phontools))
    (home-page "https://cran.r-project.org/web/packages/powerplus/")
    (synopsis "Exponentiation operations")
    (description
     "This package provides tools for the computation of matrix and scalar
exponentiation.")
    (license license:gpl2)))

(define-public r-egg
  (package
    (name "r-egg")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "egg" version))
       (sha256
        (base32
         "1fy7srpiavfn8kyrr1m84an7acgwi6ydzrg71m3b0vk7y9ybmj0m"))))
    (properties `((upstream-name . "egg")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridextra r-gtable))
    (home-page "https://cran.r-project.org/web/packages/egg")
    (synopsis "Extensions for ggplot2")
    (description
     "This package provides miscellaneous functions to help customize ggplot2
objects.  High-level functions are provided to post-process ggplot2 layouts
and allow alignment between plot panels, as well as setting panel sizes to
fixed values.  Other functions include a custom @code{geom}, and helper
functions to enforce symmetric scales or add tags to facetted plots.")
    (license license:gpl3)))

(define-public r-heatmap3
  (package
    (name "r-heatmap3")
    (version "1.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "heatmap3" version))
       (sha256
        (base32
         "0sfvizmmwfk1bjhn6zfx5a4qqfgj1ldg8x90b65crqibgfa36k2r"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastcluster))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/heatmap3/")
    (synopsis "Improved heatmap package")
    (description
     "This package provides an improved heatmap package.  It is completely
compatible with the original R function @code{heatmap}, and provides more
powerful and convenient features.")
    (license license:gpl2+)))

(define-public r-heatmaply
  (package
    (name "r-heatmaply")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "heatmaply" version))
       (sha256
        (base32
         "1crdm7avxv3zx59byz2fqbcw95728crwf9cckjb9gal1065xv95c"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-colorspace
           r-dendextend
           r-egg
           r-ggplot2
           r-htmlwidgets
           r-magrittr
           r-plotly
           r-rcolorbrewer
           r-reshape2
           r-scales
           r-seriation
           r-viridis
           r-webshot))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=heatmaply")
    (synopsis "Interactive cluster heat maps using plotly")
    (description
     "This package enables you to create interactive cluster heatmaps that can
be saved as a stand-alone HTML file, embedded in R Markdown documents or in a
Shiny app, and made available in the RStudio viewer pane.  Hover the mouse
pointer over a cell to show details or drag a rectangle to zoom.  A heatmap is
a popular graphical method for visualizing high-dimensional data, in which a
table of numbers is encoded as a grid of colored cells.  The rows and columns
of the matrix are ordered to highlight patterns and are often accompanied by
dendrograms.")
    ;; Either version of the license.
    (license (list license:gpl2 license:gpl3))))

(define-public r-h5
  (package
    (name "r-h5")
    (version "0.9.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "h5" version))
       (sha256
        (base32
         "14p7i1sj24ky87kd7qr3n9fc9l64s0bp0rwbyl6i2x69xn75gpsx"))))
    (build-system r-build-system)
    (inputs
     (list zlib hdf5))
    (native-inputs
     (list r-knitr r-testthat which))
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://github.com/mannau/h5")
    (synopsis "Interface to the HDF5 Library")
    (description
     "This package provides an S4 interface to the HDF5 library supporting
fast storage and retrieval of R-objects like vectors, matrices and arrays to
binary files in a language independent format.  The HDF5 format can therefore
be used as an alternative to R's save/load mechanism.  Since h5 is able to
access only subsets of stored data it can also handle data sets which do not
fit into memory.")
    (license license:bsd-2)))

(define-public r-cgdsr
  (package
    (name "r-cgdsr")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cgdsr" version))
       (sha256
        (base32
         "07yc819hkabpzzh0g0cbqza6bcfy67b2marrzz1lj97f9iba78ja"))))
    (build-system r-build-system)
    ;; FIXME: Tests fail with: could not find function "context"
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-httr r-r-methodss3 r-r-oo))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/cBioPortal/cgdsr")
    (synopsis "R-based API for accessing the MSKCC Cancer Genomics Data Server")
    (description
     "This package provides a basic set of R functions for querying the Cancer
Genomics Data Server (CGDS), hosted by the Computational Biology Center at
Memorial-Sloan-Kettering Cancer Center (MSKCC).")
    (license license:lgpl3)))

(define-public r-cqrreg
  (package
    (name "r-cqrreg")
    (version "1.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "cqrReg" version))
              (sha256
               (base32
                "1788hnm1qd5mv5bcizz2h170jg6954sfggjnfqcwfwg167px0df2"))))
    (properties `((upstream-name . "cqrReg")))
    (build-system r-build-system)
    (propagated-inputs (list r-quantreg r-rcpp r-rcpparmadillo))
    (home-page "https://cran.r-project.org/package=cqrReg")
    (synopsis
     "Quantile, composite quantile regression and regularized versions")
    (description
     "Estimate @dfn{quantile regression} (QR) and @dfn{composite quantile
regression} (cqr) and with adaptive lasso penalty using @dfn{interior
point} (IP), @dfn{majorize and minimize} (MM), @dfn{coordinate descent} (CD),
and @dfn{alternating direction method of multipliers algorithms} (ADMM).")
    (license license:gpl2+)))

(define-public r-imifa
  (package
    (name "r-imifa")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "IMIFA" version))
       (sha256
        (base32 "08h53w1axvmvnd4z1nf5bsps5sr6g8a77q6pvg39ss7jcfqm800v"))))
    (properties `((upstream-name . "IMIFA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrixstats
           r-mclust
           r-mvnfast
           r-rfast
           r-slam
           r-viridislite))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=IMIFA")
    (synopsis
     "Infinite mixtures of infinite factor analysers and related models")
    (description
     "This package provides flexible Bayesian estimation of @acronym{IMIFA,
infinite mixtures of infinite factor analysers} and related models, for
nonparametrically clustering high-dimensional data.  The IMIFA model conducts
Bayesian nonparametric model-based clustering with factor analytic covariance
structures without recourse to model selection criteria to choose the number of
clusters or cluster-specific latent factors, mostly via efficient Gibbs updates.
Model-specific diagnostic tools are also provided, as well as many options for
plotting results, conducting posterior inference on parameters of interest,
posterior predictive checking, and quantifying uncertainty.")
    (license license:gpl3+)))

(define-public r-import
  (package
    (name "r-import")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "import" version))
       (sha256
        (base32
         "0ngakg8jqn76c05hrglp4hmmwvm5a9ldc9s1i83a9rc8lni6nb1j"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-rmarkdown r-testthat))
    (home-page "https://github.com/smbache/import")
    (synopsis "Import mechanism for R")
    (description
     "This is an alternative mechanism for importing objects from packages.
The syntax allows for importing multiple objects from a package with a single
command in an expressive way.  The import package bridges some of the gap
between using @code{library} (or @code{require}) and direct (single-object)
imports.  Furthermore the imported objects are not placed in the current
environment.  It is also possible to import objects from stand-alone @code{.R}
files.")
    (license license:expat)))

(define-public r-shinyace
  (package
    (name "r-shinyace")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyAce" version))
       (sha256
        (base32
         "07xb4mjz9fm5zpysh6133ps0qlakbq74rcsz05kzv9mwxz8bm5sh"))))
    (properties `((upstream-name . "shinyAce")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-jsonlite r-shiny))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/shinyAce/")
    (synopsis "Ace editor bindings for Shiny")
    (description
     "This package provides Ace editor bindings to enable a rich text editing
environment within Shiny.")
    (license license:expat)))

(define-public r-raceid
  (package
    (name "r-raceid")
    (version "0.3.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RaceID" version))
       (sha256
        (base32 "0gm377g21sv4y1z1f1m2q7dbp3bpxzrsc9x6w674ixvrddqhyhhm"))))
    (properties `((upstream-name . "RaceID")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster
                             r-coop
                             r-fateid
                             r-fnn
                             r-fpc
                             r-ggplot2
                             r-harmony
                             r-ica
                             r-igraph
                             r-irlba
                             r-leiden
                             r-locfit
                             r-mass
                             r-matrix
                             r-matrixstats
                             r-pheatmap
                             r-princurve
                             r-quadprog
                             r-randomforest
                             r-rcolorbrewer
                             r-rcpp
                             r-rtsne
                             r-runner
                             r-umap
                             r-vegan))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=RaceID")
    (synopsis
     "Algorithm for inferring cell types from single-cell RNA-seq data")
    (description
     "This tool provides an algorithm to identify rare cell types in
single-cell data.  It also identifies abundant cell types.  The method is
based on transcript counts obtained with unique molecular identifies.")
    (license license:gpl3)))

(define-public r-rafalib
  (package
    (name "r-rafalib")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rafalib" version))
       (sha256
        (base32 "1dmxjl66bfdgrybhwyaa8d4i460liqcdw8b29a6w7shgksh29m0k"))))
    (properties `((upstream-name . "rafalib")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcolorbrewer))
    (home-page "https://cran.r-project.org/package=rafalib")
    (synopsis "Convenience functions for routine data exploration")
    (description
     "This package provides a series of shortcuts for routine tasks to
facilitate data exploration.")
    (license license:artistic2.0)))

(define-public r-randomizr
  (package
    (name "r-randomizr")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "randomizr" version))
       (sha256
        (base32
         "0r7yawh4dnxawinnlz09f57kgdwa08rpwxq3y35jam3x2q48qijn"))))
    (properties `((upstream-name . "randomizr")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://declaredesign.org/r/randomizr/")
    (synopsis "Tools for common forms of random assignment and sampling")
    (description
     "This package provides tools for generating random assignments for common
experimental designs and random samples for common sampling designs.")
    (license license:expat)))

(define-public r-roi
  (package
    (name "r-roi")
    (version "1.0-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ROI" version))
       (sha256
        (base32 "05hnj9fskfm2klz7zv97lb0r60akjq4a1cay8p62whpi0hri9zyl"))))
    (properties `((upstream-name . "ROI")))
    (build-system r-build-system)
    (propagated-inputs (list r-checkmate r-registry r-slam))
    (native-inputs (list r-r-rsp r-testthat))
    (home-page "https://roi.r-forge.r-project.org/")
    (synopsis "R optimization infrastructure")
    (description
     "The @acronym{ROI, R Optimization Infrastructure} is a framework for handling
optimization problems in R.")
    (license license:gpl3)))

(define-public r-roptim
  (package
    (name "r-roptim")
    (version "0.1.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "roptim" version))
              (sha256
               (base32
                "11h6qdi0rsv0bpps6nxkzzapan284q0gldzkmgx3ww5kvnic5w3y"))))
    (properties `((upstream-name . "roptim")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs (list r-rcpp r-rcpparmadillo))
    (native-inputs (list r-r-rsp r-testthat))
    (home-page "https://github.com/ypan1988/roptim/")
    (synopsis "General purpose optimization in R using C++")
    (description
     "This package performs optimization in R using C++.  A unified wrapper
interface is provided to call C functions of the five optimization algorithms
(Nelder-Mead, BFGS, CG, L-BFGS-B and SANN) underlying @code{optim()}.")
    (license license:gpl2+)))

(define-public r-base64url
  (package
    (name "r-base64url")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "base64url" version))
       (sha256
        (base32
         "0n1c2b68vza1dh7sk38v6biiwm72c4jpl79kpdg1bsb0hq9qy18x"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports))
    (native-inputs (list r-checkmate r-knitr r-testthat))
    (home-page "https://github.com/mllg/base64url")
    (synopsis "Fast and URL-safe base64 encoder and decoder")
    (description
     "This package provides a URL-safe base64 encoder and decoder.  In
contrast to RFC3548, the 62nd character (@code{+}) is replaced with @code{-},
the 63rd character (@code{/}) is replaced with @code{_}.  Furthermore, the
encoder does not fill the string with trailing @code{=}.  The resulting
encoded strings comply to the regular expression pattern @code{[A-Za-z0-9_-]}
and thus are safe to use in URLs or for file names.  The package also comes
with a simple base32 encoder/decoder suited for case insensitive file
systems.")
    (license license:gpl3)))

(define-public r-baseline
  (package
    (name "r-baseline")
    (version "1.3-5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "baseline" version))
              (sha256
               (base32
                "0l0llb3pi89ixkpvfg5vbvwwv3gzldf0g98rrd3vkm7q26rqmmd2"))))
    (properties `((upstream-name . "baseline")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gwidgets2tcltk ;for GUI
           r-limsolve
           r-sparsem))
    (home-page "https://github.com/khliland/baseline/")
    (synopsis "Baseline correction of spectra")
    (description
     "This package is a collection of baseline correction algorithms.  Beside
those it provides a framework and a Tcl/Tk enabled GUI for optimizing baseline
algorithm parameters.  Typical use is the removal of the background effects from
spectra, which are originating from various types of spectroscopy and spectrometry.
Also, there is a possibility of optimizing this with regard to regression or
classification results.  Correction methods include polynomial fitting, weighted
local smoothers and many more.")
    (license license:gpl2)))

(define-public r-radiant-data
  (package
    (name "r-radiant-data")
    (version "1.6.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "radiant.data" version))
       (sha256
        (base32
         "0p55nppclr5dzlslwrhzrg8cc4i0k3ck3076sh2fiay0qi2fh9cm"))
       (modules '((guix build utils)))
       (snippet
        '(delete-file "inst/assets/html2canvas/html2canvas.min.js"))))
    (properties `((upstream-name . "radiant.data")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'process-javascript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "inst/assets/html2canvas/"
                (minify (assoc-ref inputs "html2canvas.js")
                        #:target "html2canvas.min.js")))))))
    (propagated-inputs
     (list r-base64enc
           r-broom
           r-bslib
           r-car
           r-curl
           r-dplyr
           r-dt
           r-ggplot2
           r-glue
           r-import
           r-jsonlite
           r-knitr
           r-lubridate
           r-magrittr
           r-markdown
           r-mass
           r-patchwork
           r-plotly
           r-png
           r-psych
           r-randomizr
           r-readr
           r-readxl
           r-rlang
           r-rmarkdown
           r-rstudioapi
           r-scales
           r-shiny
           r-shinyace
           r-shinyfiles
           r-stringi
           r-tibble
           r-tidyr
           r-writexl))
    (native-inputs
     (list esbuild
           (origin
             (method url-fetch)
             (uri "https://web.archive.org/web/20230428182027id_/\
https://html2canvas.hertzen.com/dist/html2canvas.js")
             (sha256
              (base32
               "0svkfnzzsydbsrwi7ky91rjqj97x5rfic69hbr9pwhm0zxlb9i81")))
           r-testthat))
    (home-page "https://github.com/radiant-rstats/radiant.data")
    (synopsis "Data menu for Radiant: business analytics using R and Shiny")
    (description
     "The Radiant Data menu includes interfaces for loading, saving, viewing,
visualizing, summarizing, transforming, and combining data.  It also contains
functionality to generate reproducible reports of the analyses conducted in
the application.")
    (license license:agpl3)))

(define-public r-algdesign
  (package
    (name "r-algdesign")
    (version "1.2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AlgDesign" version))
       (sha256
        (base32 "0m6c09pwr536wr3qlq7x15f49hj5y750lh60c3m8xf7yhrpfzjpn"))))
    (properties `((upstream-name . "AlgDesign")))
    (build-system r-build-system)
    (home-page "https://github.com/jvbraun/AlgDesign")
    (synopsis "Algorithmic experimental design")
    (description
     "This package provides tools to calculate exact and approximate theory
experimental designs for D, A, and I criteria.  Very large designs may be
created.  Experimental designs may be blocked or blocked designs created from
a candidate list, using several criteria.  The blocking can be done when whole
and within plot factors interact.")
    (license license:gpl2+)))

(define-public r-alluvial
  (package
    (name "r-alluvial")
    (version "0.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "alluvial" version))
       (sha256
        (base32 "039frwrsxq1lb97s7vf2vbyyadimkigs628ymym06fxka53drdkp"))))
    (properties `((upstream-name . "alluvial")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/mbojan/alluvial")
    (synopsis "Create parallel sets plots (Alluvial Diagrams)")
    (description
     "This package creates alluvial diagrams (also known as parallel sets
plots) for multivariate and time series-like data.")
    (license license:expat)))

(define-public r-signal
  (package
    (name "r-signal")
    (version "1.8-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "signal" version))
       (sha256
        (base32
         "1c7fw5akdm8f44zgdafsgz2fpn6kfwifaw29yakl7zykq89vq8m3"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (native-inputs (list gfortran r-pracma))
    (home-page "https://cran.r-project.org/web/packages/signal/")
    (synopsis "Signal processing")
    (description
     "This package provides a set of signal processing functions originally
written for Matlab and GNU Octave.  It includes filter generation utilities,
filtering functions, resampling routines, and visualization of filter models.
It also includes interpolation functions.")
    (license license:gpl2)))

(define-public r-simdesign
  (package
    (name "r-simdesign")
    (version "2.17.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SimDesign" version))
       (sha256
        (base32 "0anmnzxxw7mv9kykjf2kmgv6qwxkrg48g91q32r2ia4dw8n17782"))))
    (properties `((upstream-name . "SimDesign")))
    (build-system r-build-system)
    (propagated-inputs (list r-beepr
                             r-dplyr
                             r-future
                             r-future-apply
                             r-parallelly
                             r-pbapply
                             r-progressr
                             r-r-utils
                             r-rpushbullet
                             r-sessioninfo
                             r-snow
                             r-testthat))
    (native-inputs (list r-knitr))
    (home-page "http://philchalmers.github.io/SimDesign/")
    (synopsis "Structure for organizing Monte Carlo simulation designs")
    (description
     "This package provides tools to safely and efficiently organize and
execute Monte Carlo simulation experiments in R.  The package controls the
structure and back-end of Monte Carlo simulation experiments by utilizing a
generate-analyse-summarise workflow.  The workflow safeguards against common
simulation coding issues, such as automatically re-simulating non-convergent
results, prevents inadvertently overwriting simulation files, catches error
and warning messages during execution, implicitly supports parallel processing
with high-quality random number generation, and provides tools for managing
high-performance computing (HPC) array jobs submitted to schedulers such as
SLURM. For a pedagogical introduction to the package see Sigal and Chalmers
(2016) <doi:10.1080/10691898.2016.1246953>.  For a more in-depth overview of
the package and its design philosophy see Chalmers and Adkins (2020)
<doi:10.20982/tqmp.16.4.p248>.")
    (license license:gpl2+)))

(define-public r-simplermarkdown
  (package
    (name "r-simplermarkdown")
    (version "0.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "simplermarkdown" version))
       (sha256
        (base32 "0lffwsrhsdqcqhklh24v0y0x6w4vq9jch93m330kfdv2amab1l06"))))
    (properties `((upstream-name . "simplermarkdown")))
    (build-system r-build-system)
    (propagated-inputs
     ;; We cannot patch references to pandoc because the patched files are
     ;; compiled to an opaque rdb/rdx pair.  "guix gc" would not be able to
     ;; find the patched references in those files.
     (list pandoc
           r-rjson))
    ;; For tests
    (native-inputs (list r-mass))
    (home-page "https://github.com/djvanderlaan/simplermarkdown")
    (synopsis "Simple engine for generating reports using R")
    (description
     "This package runs R-code present in a pandoc markdown file and includes
the resulting output in the resulting markdown file.  This file can then be
converted into any of the output formats supported by pandoc.  The package can
also be used as an engine for writing package vignettes.")
    (license license:gpl3+)))

(define-public r-sitar
  (package
    (name "r-sitar")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sitar" version))
       (sha256
        (base32 "14qc5qy21qyj4gml0gwfn8izbsmzwy30ddc7mazhszi487jrcrp0"))))
    (properties `((upstream-name . "sitar")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-forcats
           r-ggplot2
           r-glue
           r-magrittr
           r-nlme
           r-purrr
           r-rlang
           r-rsample
           r-tibble
           r-tidyr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/statist7/sitar")
    (synopsis "Super imposition by translation and rotation growth curve analysis")
    (description
     "This package provides functions for fitting and plotting @acronym{SITAR, Super
Imposition by Translation And Rotation} growth curve models.  SITAR is a shape-
invariant model with a regression B-spline mean curve and subject-specific random
effects on both the measurement and age scales.")
    (license license:gpl2+)))

(define-public r-gsubfn
  (package
    (name "r-gsubfn")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gsubfn" version))
       (sha256
        (base32
         "00j6b8b6xsx6v370h220x233rpk6asca78165y3d48jpwvwisdc9"))))
    (build-system r-build-system)
    (propagated-inputs (list r-proto))
    (home-page "https://code.google.com/archive/p/gsubfn/")
    (synopsis "Utilities for strings and function arguments")
    (description
     "This package provides @code{gsubfn} which is like @code{gsub} but can
take a replacement function or certain other objects instead of the
replacement string.  Matches and back references are input to the replacement
function and replaced by the function output.  @code{gsubfn} can be used to
split strings based on content rather than delimiters and for quasi-perl-style
string interpolation.  The package also has facilities for translating
formulas to functions and allowing such formulas in function calls instead of
functions.")
    (license license:gpl2+)))

(define-public r-sqldf
  (package
    (name "r-sqldf")
    (version "0.4-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sqldf" version))
       (sha256
        (base32
         "0q12vsb53p2wchgp8wfz5bk08wfnm0jxjrakclj4jyy6x3a7ksff"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-chron r-dbi r-gsubfn r-proto r-rsqlite))
    (native-inputs (list r-svunit))
    (home-page "https://github.com/ggrothendieck/sqldf")
    (synopsis "Manipulate R data frames using SQL")
    (description
     "The @code{sqldf} function is typically passed a single argument which is
an SQL select statement where the table names are ordinary R data frame names.
@code{sqldf} transparently sets up a database, imports the data frames into
that database, performs the SQL statement and returns the result using a
heuristic to determine which class to assign to each column of the returned
data frame.  The @code{sqldf} or @code{read.csv.sql} functions can also be
used to read filtered files into R even if the original files are larger than
R itself can handle.")
    (license license:gpl2)))

(define-public r-abind
  (package
    (name "r-abind")
    (version "1.4-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abind" version))
       (sha256
        (base32
         "1q934vfyvszmy6nv13dchv2mbsj9i5vffy88b9wy3siwa8dhaji6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abind/")
    (synopsis "Combine multidimensional arrays")
    (description
     "This package provides tools to combine multidimensional arrays into a
single array.  This is a generalization of @code{cbind} and @code{rbind}.  It
works with vectors, matrices, and higher-dimensional arrays.  It also provides
the functions @code{adrop}, @code{asub}, and @code{afill} for manipulating,
extracting and replacing data in arrays.")
    (license license:lgpl2.0+)))

(define-public r-prroc
  (package
    (name "r-prroc")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PRROC" version))
       (sha256
        (base32
         "1m28h8pcd78049lz2qixhkcr9h5b3jik3maqzfbvq9y58z71i4a7"))))
    (properties `((upstream-name . "PRROC")))
    (build-system r-build-system)
    (native-inputs (list r-ggplot2 r-testthat))
    (home-page "https://cran.r-project.org/web/packages/PRROC/")
    (synopsis "Precision-Recall and ROC curves for weighted and unweighted data")
    (description
     "This package computes the areas under the @dfn{precision-recall} (PR)
and ROC curve for weighted (e.g. soft-labeled) and unweighted data.  In
contrast to other implementations, the interpolation between points of the PR
curve is done by a non-linear piecewise function.  In addition to the areas
under the curves, the curves themselves can also be computed and plotted by a
specific S3-method.")
    (license license:gpl3)))

(define-public r-vim
  (package
    (name "r-vim")
    (version "6.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "VIM" version))
       (sha256
        (base32
         "1r0myxcx8y1a3fkf9ssk882f09snn2j6zilsygpld32hahn4k9xg"))))
    (properties `((upstream-name . "VIM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-colorspace
           r-data-table
           r-e1071
           r-laeken
           r-magrittr
           r-mass
           r-nnet
           r-ranger
           r-rcpp
           r-robustbase
           r-sp
           r-vcd))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/alexkowa/VIM")
    (synopsis "Visualization and imputation of missing values")
    (description
     "This package provides tools for the visualization of missing and/or
imputed values are introduced, which can be used for exploring the data and
the structure of the missing and/or imputed values.  Depending on this
structure of the missing values, the corresponding methods may help to
identify the mechanism generating the missing values and explore the
data including missing values.  In addition, the quality of imputation can be
visually explored using various univariate, bivariate, multiple and
multivariate plot methods.")
    (license license:gpl2+)))

(define-public r-fnn
  (package
    (name "r-fnn")
    (version "1.1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FNN" version))
       (sha256
        (base32
         "0m5q1jkyxynjgzakzn48aqxr5cc92sgl7z9j1zlqmb1yzn3p9nbk"))))
    (properties `((upstream-name . "FNN")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/FNN")
    (synopsis "Fast nearest neighbor search algorithms and applications")
    (description
     "This package provides cover-tree and kd-tree fast k-nearest neighbor
search algorithms.  Related applications including KNN classification,
regression and information measures are implemented.")
    ;; The DESCRIPTION file erroneously states that GPL version 2.1 or
    ;; later can be used.
    (license license:gpl2+)))

(define-public r-smoother
  (package
    (name "r-smoother")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "smoother" version))
       (sha256
        (base32
         "0xw28qv8f5i05ajx32njnql6hql5njqyc47wcq6c75cxiv44ppz8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ttr))
    (home-page "https://cran.r-project.org/web/packages/smoother")
    (synopsis "Functions relating to the smoothing of numerical data")
    (description
     "This package provides a collection of methods for smoothing numerical
data, commencing with a port of the Matlab gaussian window smoothing function.
In addition, several functions typically used in smoothing of financial data
are included.")
    (license license:gpl2)))

(define-public r-riverplot
  (package
    (name "r-riverplot")
    (version "0.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "riverplot" version))
       (sha256
        (base32
         "04ap1dsa7fx03l73jhv1ql3adaaaz2100qawdplxa9xmrllgcgbj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcolorbrewer))
    (native-inputs
     (list r-knitr))
    (home-page "https://logfc.wordpress.com")
    (synopsis "Sankey or ribbon plots")
    (description
     "Sankey plots are a type of diagram that is convenient to illustrate how
flow of information, resources etc. separates and joins, much like observing
how rivers split and merge.  For example, they can be used to compare
different clusterings.  This package provides an implementation of Sankey
plots for R.")
    (license license:gpl2+)))

(define-public r-dyn
  (package
    (name "r-dyn")
    (version "0.2-9.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dyn" version))
       (sha256
        (base32
         "16fqv9k7yxdgybwzafjkyqm16qpgqz13lcjpi6a1nc8xbzlzh0gb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-zoo))
    (native-inputs (list r-sandwich))
    (home-page "https://cran.r-project.org/web/packages/dyn")
    (synopsis "Time series regression")
    (description
     "This package provides the dyn class interfaces @code{ts}, @code{irts},
@code{zoo} and @code{zooreg} time series classes to @code{lm}, @code{glm},
@code{loess}, @code{quantreg::rq}, @code{MASS::rlm},
@code{MCMCpack::MCMCregress()}, @code{quantreg::rq()},
@code{randomForest::randomForest()} and other regression functions, allowing
those functions to be used with time series including specifications that may
contain lags, diffs and missing values.")
    ;; Any GPL version.
    (license license:gpl2+)))

(define-public r-dyngen
  (package
    (name "r-dyngen")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dyngen" version))
       (sha256
        (base32
         "095jqn1rd83qm3ayca9hmv6bhlaa2c338020l46vniq8n38kbnra"))))
    (properties `((upstream-name . "dyngen")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; For vignette builder.
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-assertthat
           r-dplyr
           r-dynutils
           r-ggplot2
           r-ggraph
           r-ggrepel
           r-gillespiessa2
           r-igraph
           r-lmds
           r-matrix
           r-patchwork
           r-pbapply
           r-purrr
           r-rlang
           r-tibble
           r-tidygraph
           r-tidyr
           r-viridis))
    (native-inputs (list r-r-rsp r-testthat))
    (home-page "https://github.com/dynverse/dyngen")
    (synopsis "Multi-Modal simulator for single-cell omics analyses")
    (description
     "This package provides a multi-modal simulation engine for studying
dynamic cellular processes at single-cell resolution.")
    (license license:expat)))

(define-public r-dynutils
  (package
    (name "r-dynutils")
    (version "1.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dynutils" version))
       (sha256
        (base32 "06an2bm1d131v28m240vii2wisbz3zs32wbamm2w7r8rl3yrxkh9"))))
    (properties `((upstream-name . "dynutils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-crayon
           r-desc
           r-dplyr
           r-magrittr
           r-matrix
           r-proxyc
           r-purrr
           r-rcpp
           r-remotes
           r-stringr
           r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/dynverse/dynutils")
    (synopsis "Common functionality for the dynverse packages")
    (description
     "This package provides common functionality for the
@url{https://dynverse.org,dynverse} packages.  dynverse is created to support
the development, execution, and benchmarking of trajectory inference
methods.")
    (license license:expat)))

(define-public r-catdap
  (package
    (name "r-catdap")
    (version "1.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "catdap" version))
       (sha256
        (base32
         "0z84bx808hy70bkzdda9l42ljh9i9pz07isxq756axi7nr0ky6p9"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcolorbrewer))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/catdap/")
    (synopsis "Tools for categorical data analysis")
    (description
     "This package provides functions for analyzing multivariate data.
Dependencies of the distribution of the specified variable (response
variable) to other variables (explanatory variables) are derived and
evaluated by the @dfn{Akaike Information Criterion} (AIC).")
    (license license:gpl2+)))

(define-public r-catdata
  (package
    (name "r-catdata")
    (version "1.2.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "catdata" version))
              (sha256
               (base32
                "1gvibnjfrjdsxx4jks29hhk3dfsm23nxnbwd5p8w67nxr4n6qn0w"))))
    (properties `((upstream-name . "catdata")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=catdata")
    (synopsis
     "Datasets and examples used in the book @emph{Regression for Categorical Data}")
    (description
     "This R package contains examples from the book @emph{Regression
for Categorical Data}, Tutz 2012, Cambridge University Press.  The
names of the examples refer to the chapter and the data set that is
used.")
    (license license:gpl2)))

(define-public r-arules
  (package
    (name "r-arules")
    (version "1.7-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "arules" version))
       (sha256
        (base32
         "1qc0hdkhsg1a7byldgarlbg36w37sdynz0cvkp3jcj9b131a43dl"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-generics r-matrix))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/mhahsler/arules")
    (synopsis "Mining association rules and frequent itemsets")
    (description
     "This package provides an infrastructure for representing, manipulating
and analyzing transaction data and patterns (frequent itemsets and association rules).
It also provides C implementations of the association mining algorithms Apriori
and Eclat.")
    (license license:gpl3)))

(define-public r-parsedate
  (package
    (name "r-parsedate")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parsedate" version))
       (sha256
        (base32
         "1cfinqlbchmkhkgmdwiy3mnxb17lp02jfk2gpw56hq9vh6wimhqz"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'install 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (native-inputs (list r-testthat tzdata-for-tests))
    (home-page "https://github.com/gaborcsardi/parsedate")
    (synopsis
     "Recognize and parse dates in various formats")
    (description
     "This package provides three functions for dealing with dates:
@code{parse_iso_8601} recognizes and parses all valid ISO 8601 date and
time formats, @code{parse_date} parses dates in unspecified formats,
and @code{format_iso_8601} formats a date in ISO 8601 format.")
    (license license:gpl2)))

(define-public r-abc-data
  (package
    (name "r-abc-data")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abc.data" version))
       (sha256
        (base32
         "0zdhrnhvgnk3lp18cxgzsxa38xr7pl55g48pk373q1d6h77qbmj8"))))
    (properties `((upstream-name . "abc.data")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abc.data/")
    (synopsis "Data for Approximate Bayesian Computation (ABC) package")
    (description
     "This package contains data which are used by functions of the abc
package which implements several @dfn{Approximate Bayesian Computation} (ABC)
algorithms for performing parameter estimation, model selection, and
goodness-of-fit.")
    (license license:gpl3+)))

(define-public r-abc
  (package
    (name "r-abc")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abc" version))
       (sha256
        (base32
         "16753lyzk2dfwgdjfyanwacqw3bvrwby52inq4709804labs6lnv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abc-data r-locfit r-mass r-nnet r-quantreg))
    (home-page "https://cran.r-project.org/web/packages/abc/")
    (synopsis "Tools for Approximate Bayesian Computation (ABC)")
    (description
     "This package implements several @dfn{Approximate Bayesian
Computation} (ABC) algorithms for performing parameter estimation, model
selection, and goodness-of-fit.  Cross-validation tools are also available for
measuring the accuracy of ABC estimates, and to calculate the
misclassification probabilities of different models.")
    (license license:gpl3+)))

(define-public r-zip
  (package
    (name "r-zip")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "zip" version))
       (sha256
        (base32
         "13y2mhy59jshw0vz7dbq0zg96j1151fqcdb5ycbmjlhwg0448xc3"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/gaborcsardi/zip")
    (synopsis "Cross-platform Zip compression")
    (description
     "This package provides a cross-platform Zip compression library for R.
It is a replacement for the @code{zip} function, that does not require any
additional external tools on any platform.")
    (license license:cc0)))

(define-public r-openai
  (package
    (name "r-openai")
    (version "0.4.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "openai" version))
              (sha256
               (base32
                "1fi1nc9c7kfnig6b5ifpb1v9r3gxszk984rwyq7i1lb6s5jv0b9z"))))
    (properties `((upstream-name . "openai")))
    (build-system r-build-system)
    (propagated-inputs (list r-assertthat
                             r-glue
                             r-httr
                             r-jsonlite
                             r-lifecycle
                             r-magrittr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/irudnyts/openai")
    (synopsis "R Wrapper for OpenAI API")
    (description
     "This package provides an R wrapper of OpenAI API endpoints (see
@url{https://platform.openai.com/docs/introduction} for details).  This
package covers Models, Completions, Chat, Edits, Images, Embeddings, Audio,
Files, Fine-tunes, Moderations, and legacy Engines endpoints.")
    (license license:expat)))

(define-public r-operator-tools
  (package
    (name "r-operator-tools")
    (version "1.6.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "operator.tools" version))
              (sha256
               (base32
                "1v4dg7xhz24dnp0zxn815x1405ig64ibii6y40la1gvmzcc41dz5"))))
    (properties `((upstream-name . "operator.tools")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/decisionpatterns/operator.tools")
    (synopsis "Utilities for working with R's operators")
    (description
     "This package provides a collection of utilities that allow programming
with R's operators.  Routines allow classifying operators, translating to and
from an operator and its underlying function, and inverting some
operators (e.g. comparison operators), etc.  All methods can be extended to
custom infix operators.")
    (license license:gpl2)))

(define-public r-openxlsx
  (package
    (name "r-openxlsx")
    (version "4.2.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "openxlsx" version))
       (sha256
        (base32
         "1wgv8144lbnfa6a2a6vj0dq3l2xv960xr7vdbkghadcnps9n4bzi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-stringi r-zip))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/awalker89/openxlsx")
    (synopsis "Read, write and edit XLSX files")
    (description
     "This package simplifies the creation of Excel @code{.xlsx} files by
providing a high level interface to writing, styling and editing worksheets.
Through the use of Rcpp, read/write times are comparable to the @code{xlsx}
and @code{XLConnect} packages with the added benefit of removing the
dependency on Java.")
    (license license:gpl3)))

(define-public r-rio
  (package
    (name "r-rio")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rio" version))
       (sha256
        (base32
         "1annh9zsfskizr2idylgvqm41cfzldn56bh9vkzxqqvznka7k123"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'find-zip
           (lambda _
             (setenv "R_ZIPCMD" (which "zip")))))))
    (propagated-inputs
     (list r-curl
           r-data-table
           r-foreign
           r-haven
           r-lifecycle
           r-r-utils
           r-readr
           r-readxl
           r-tibble
           r-writexl))
    (native-inputs
     (list r-knitr r-stringi r-testthat r-xml2 zip))
    (home-page "https://github.com/leeper/rio")
    (synopsis "Swiss-army knife for data I/O")
    (description
     "This package provides streamlined data import and export infrastructure
by making assumptions that the user is probably willing to make: @code{import}
and @code{export} determine the data structure from the file extension,
reasonable defaults are used for data import and export (e.g.,
@code{stringsAsFactors=FALSE}), web-based import is natively
supported (including from SSL/HTTPS), compressed files can be read directly
without explicit decompression, and fast import packages are used where
appropriate.  An additional convenience function, @code{convert}, provides a
simple method for converting between file types.")
    (license license:gpl2)))

(define-public r-maptools
  (package
    (name "r-maptools")
    (version "1.1-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "maptools" version))
       (sha256
        (base32
         "1xz0cqg629vz7mawwxx650mgmvh3wzn25rnxy4sij5jrypipk1ay"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreign r-lattice r-sp))
    (home-page "https://r-forge.r-project.org/projects/maptools/")
    (synopsis "Tools for reading and handling spatial objects")
    (description
     "This package provides a set of tools for manipulating and reading
geographic data, in particular ESRI Shapefiles.  It includes binary access to
GSHHG shoreline files.  The package also provides interface wrappers for
exchanging spatial objects with other R packages.")
    ;; The C source files from shapelib are released under the Expat license.
    ;; The R code is released under GPL version 2 or later.
    (license (list license:gpl2+
                   license:expat))))

(define-public r-maptree
  (package
    (name "r-maptree")
    (version "1.4-8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "maptree" version))
              (sha256
               (base32
                "1x35nk4fi2b62krcvcv187n5sbqrgvw4pbm7r19ps3jlanpi5ksm"))))
    (properties `((upstream-name . "maptree")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster r-rpart))
    (home-page "https://cran.r-project.org/package=maptree")
    (synopsis "Mapping, pruning, and graphing tree models")
    (description
     "This package provides a set of functions with example data for graphing,
pruning, and mapping models.  These models are from hierarchical clustering,
and classification and regression trees.")
    ;; Unlimited distribution; see
    ;; https://cran.r-project.org/web/packages/maptree/index.html
    (license (license:non-copyleft "file://DESCRIPTION"))))

(define-public r-later
  (package
    (name "r-later")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "later" version))
       (sha256
        (base32
         "07jn5gp4237va5pcq8lvqzyblgij7k2wj9k5wl93q3fd6cyhgxaj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rlang))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/r-lib/later")
    (synopsis "Utilities for delaying function execution")
    (description
     "This package provides tools to execute arbitrary R or C functions some
time after the current time, after the R execution stack has emptied.")
    (license license:gpl2+)))

(define-public r-promises
  (package
    (name "r-promises")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "promises" version))
       (sha256
        (base32
         "1lzs65csxaq26d1g37qjjgxzm418xv52c3ccpk0l0cxkpbrrs87q"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastmap
           r-later
           r-magrittr
           r-r6
           r-rcpp
           r-rlang))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://rstudio.github.io/promises")
    (synopsis "Abstractions for promise-based asynchronous programming")
    (description
     "This package provides fundamental abstractions for doing asynchronous
programming in R using promises.  Asynchronous programming is useful for
allowing a single R process to orchestrate multiple tasks in the background
while also attending to something else.  Semantics are similar to JavaScript
promises, but with a syntax that is idiomatic R.")
    (license license:expat)))

(define-public r-dosnow
  (package
    (name "r-dosnow")
    (version "1.0.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doSNOW" version))
       (sha256
        (base32
         "1f5v0k2w0b2478p6iqa3hn2lwd1x3rzc348n57nd38ka2vnsnz4i"))))
    (properties `((upstream-name . "doSNOW")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach r-iterators r-snow))
    (native-inputs (list r-runit))
    (home-page "https://cran.r-project.org/web/packages/doSNOW")
    (synopsis "Foreach parallel adaptor for the snow package")
    (description
     "This package provides a parallel backend for the @code{%dopar%} function
using the @code{snow} package.")
    (license license:gpl2)))

(define-public r-fsa
  (package
    (name "r-fsa")
    (version "0.9.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "FSA" version))
              (sha256
               (base32
                "0b9gf1sh7igd6i14cgl6j8ns2zqvpph3830n7b4q9vw4dfcb53g0"))))
    (properties `((upstream-name . "FSA")))
    (build-system r-build-system)
    (propagated-inputs (list r-car r-dunn-test r-lmtest r-plotrix r-withr))
    (native-inputs (list r-testthat))
    (home-page "https://fishr-core-team.github.io/FSA/")
    (synopsis "Simple fisheries stock assessment methods")
    (description
     "This package provides a variety of simple fish stock assessment
methods.")
    (license license:gpl2+)))

(define-public r-fstcore
  (package
    (name "r-fstcore")
    (version "0.9.18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fstcore" version))
       (sha256
        (base32 "00wzpr2i7s9pc3alvn4b8f1wgmfqplpwdif9rh9x8qqnylbixiqq"))))
    (properties `((upstream-name . "fstcore")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (inputs (list zlib))
    (native-inputs (list pkg-config r-lintr r-testthat))
    (home-page "https://www.fstpackage.org/fstcore/")
    (synopsis "R bindings to the fstlib library")
    (description
     "The fstlib library provides multithreaded serialization of compressed
data frames using the fst format.  The fst format allows for random access of
stored data and compression with the LZ4 and ZSTD compressors.")
    (license license:mpl2.0)))

(define-public r-fst
  (package
    (name "r-fst")
    (version "0.9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fst" version))
       (sha256
        (base32
         "0r96inwrr960m7wmc80603bw2vvvwab225bh9dq3lalwhy4yiis4"))))
    (properties `((upstream-name . "fst")))
    (build-system r-build-system)
    (propagated-inputs (list r-fstcore r-rcpp))
    (native-inputs (list r-data-table r-testthat))
    (home-page "https://www.fstpackage.org")
    (synopsis "Fast serialization of data frames")
    (description
     "The fst package for R provides a fast, easy and flexible way to
serialize data frames.  With access speeds of multiple GB/s, fst is
specifically designed to unlock the potential of high speed solid state disks.
Data frames stored in the fst format have full random access, both in column
and rows.  The fst format allows for random access of stored data and
compression with the LZ4 and ZSTD compressors.")
    (license license:agpl3)))

(define-public r-snftool
  (package
    (name "r-snftool")
    (version "2.3.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "SNFtool" version))
              (sha256
               (base32
                "05hz230aq5wbzhknxzr4iqv3nqjhbpf66n6bp1rc5h2jgz2yfbwq"))))
    (properties `((upstream-name . "SNFtool")))
    (build-system r-build-system)
    (propagated-inputs (list r-alluvial r-exposition))
    (home-page "https://cran.r-project.org/package=SNFtool")
    (synopsis "Similarity network fusion")
    (description
     "Similarity Network Fusion takes multiple views of a network and fuses
them together to construct an overall status matrix.  The input to our
algorithm can be feature vectors, pairwise distances, or pairwise
similarities.  The learned status matrix can then be used for retrieval,
clustering, and classification.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-snowfall
  (package
   (name "r-snowfall")
   (version "1.84-6.3")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "snowfall" version))
            (sha256
             (base32 "0hxip3rzv7slxvif1000avbcid2mjxj1y9mimyvk87h404mr6h96"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-snow))
   (home-page "https://cran.r-project.org/web/packages/snowfall/")
   (synopsis "Easier cluster computing")
   (description "This package is a usability wrapper around snow for easier
development of parallel R programs.  This package offers e.g. extended error
checks, and additional functions.  All functions work in sequential mode, too,
if no cluster is present or wished.  The package is also designed as connector
to the cluster management tool @code{sfCluster}, but can also used without
it.")
   (license license:gpl2+)))

(define-public r-rgexf
  (package
    (name "r-rgexf")
    (version "0.16.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rgexf" version))
       (sha256
        (base32
         "1c1rqgr7qsj61gp2frm197k396xfdspvmmwr56izwb09225cbp6d"))
       ;; Delete minified JavaScript files
       (snippet
        '(for-each delete-file
                   '("inst/gexf-js/js/jquery-2.0.2.min.js"
                     "inst/gexf-js/js/jquery-ui-1.10.3.custom.min.js"
                     "inst/gexf-js/js/jquery.mousewheel.min.js")))))
    (properties `((upstream-name . "rgexf")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1)
                  (ice-9 popen))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (invoke "unzip" "-d" "/tmp" (assoc-ref inputs "js-jquery-ui"))
             (with-directory-excursion "inst/gexf-js/js/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "js-jquery")
                         "jquery-2.0.2.min.js")
                        ("/tmp/jquery-ui-1.10.3/ui/jquery-ui.js"
                         "jquery-ui-1.10.3.custom.min.js")
                        (,(assoc-ref inputs "js-jquery-mousewheel")
                         "jquery.mousewheel.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #true "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-igraph r-servr r-xml))
    (native-inputs
     `(("r-knitr" ,r-knitr)
       ("esbuild" ,esbuild)
       ("unzip" ,unzip)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-2.0.2.js")
           (sha256
            (base32
             "0v818bxpw48gdk8i95qqqij80r9jcgisi2r4ac6xnxca20h0gvfj"))))
       ("js-jquery-ui"
        ,(origin
           (method url-fetch)
           (uri "https://jqueryui.com/resources/download/jquery-ui-1.10.3.zip")
           (sha256
            (base32
             "00xpfy0l69nj2yan4s8k65ldsrlfsjkmyw2dwcg93dc8mv454vxx"))))
       ("js-jquery-mousewheel"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/jquery/jquery-mousewheel/\
3.0.6/jquery.mousewheel.js")
           (sha256
            (base32
             "19lk5xy2s47bx8hsa7j6bg012f8yw6d770g230bcnm559kf4nc6v"))))))
    (home-page "https://gvegayon.github.io/rgexf")
    (synopsis "Build, import and export GEXF graph files")
    (description
     "Create, read and write GEXF (Graph Exchange XML Format) graph
files (used in Gephi and others).  It allows the user to easily build/read
graph files including attributes, GEXF visual attributes (such as color, size,
and position), network dynamics (for both edges and nodes) and edge weighting.
Users can build/handle graphs element-by-element or massively through
data-frames, visualize the graph on a web browser through gexf-js (a
JavaScript library) and interact with the igraph package.")
    (license license:expat)))

(define-public r-data-tree
  (package
    (name "r-data-tree")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "data.tree" version))
       (sha256
        (base32
         "0qxd1g159phc6f18iddjljdg96sh09w63xqawjwbwyhg4blm9ddh"))))
    (properties `((upstream-name . "data.tree")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-r6 r-stringi))
    (native-inputs
     (list r-knitr r-rmarkdown r-testthat))
    (home-page "https://github.com/gluc/data.tree")
    (synopsis "General purpose hierarchical data structure")
    (description
     "Create tree structures from hierarchical data, and traverse the tree in
various orders.  Aggregate, cumulate, print, plot, convert to and from
data.frame and more.  This is useful for decision trees, machine learning,
finance, conversion from and to JSON, and many other applications.")
    (license license:gpl2+)))

(define-public r-dtplyr
  (package
    (name "r-dtplyr")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dtplyr" version))
       (sha256
        (base32
         "1rfnr1f3dzzivzmw9jjaclckkany6c625bqr8lkx32qbcjd6iad5"))))
    (properties `((upstream-name . "dtplyr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-data-table
           r-dplyr
           r-glue
           r-lifecycle
           r-rlang
           r-tibble
           r-tidyselect
           r-vctrs))
    (native-inputs
     (list r-knitr r-testthat r-tidyr))
    (home-page "https://github.com/tidyverse/dtplyr")
    (synopsis "Data Table back-end for dplyr")
    (description
     "This package provides a @code{data.table} backend for @code{dplyr}.  The
goal of @code{dtplyr} is to allow you to write @code{dplyr} code that is
automatically translated to the equivalent, but usually much faster,
@code{data.table} code.")
    (license license:expat)))

(define-public r-collapsibletree
  (package
    (name "r-collapsibletree")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "collapsibleTree" version))
       (sha256
        (base32
         "1i5nmw5w7m8xdgxzim8z8n4w321f42isxbvvajl8ii59pg7drilq"))
       (snippet
        '(begin
           ;; Delete minified JavaScript file
           (delete-file "inst/htmlwidgets/lib/d3-4.10.2/d3.min.js")
           #true))))
    (properties
     `((upstream-name . "collapsibleTree")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/d3-4.10.2/"
               (let ((source (assoc-ref inputs "d3.v4.js"))
                     (target "d3.min.js"))
                 (format #t "Processing ~a --> ~a~%"
                         source target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (propagated-inputs
     (list r-data-tree r-htmlwidgets))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("d3.v4.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v4.js")
           (sha256
            (base32
             "0y7byf6kcinfz9ac59jxc4v6kppdazmnyqfav0dm4h550fzfqqlg"))))
       ("r-colorspace" ,r-colorspace)
       ("r-testthat" ,r-testthat)
       ("r-tibble" ,r-tibble)))
    (home-page "https://github.com/AdeelK93/collapsibleTree")
    (synopsis "Interactive collapsible tree diagrams using D3.js")
    (description
     "This is a package for interactive Reingold-Tilford tree diagrams created
using D3.js, where every node can be expanded and collapsed by clicking on it.
Tooltips and color gradients can be mapped to nodes using a numeric column in
the source data frame.")
    (license license:gpl3+)))

(define-public r-rapiclient
  (package
    (name "r-rapiclient")
    (version "0.1.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rapiclient" version))
              (sha256
               (base32
                "1alzkcvzaj3vr2qd8v4yw1pfg3vfvn3lvjcivsdxkwljvrv67v8w"))))
    (properties `((upstream-name . "rapiclient")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httr r-jsonlite r-yaml))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/bergant/rapiclient")
    (synopsis "Dynamic OpenAPI/Swagger client")
    (description
     "This package lets you access services specified in OpenAPI (formerly
Swagger) format.  It is not a code generator.  The client is generated
dynamically as a list of R functions.")
    (license license:expat)))

(define-public r-rappdirs
  (package
    (name "r-rappdirs")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rappdirs" version))
       (sha256
        (base32
         "1161i3jgjvzjv4p8qbz9r976fnggkcrw3mlj4yd1h2svnijrz5a9"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/rappdirs/")
    (synopsis "Determine where to save data, caches, and logs")
    (description
     "This package provides an easy way to determine which directories on the
user's computer should be used to save data, caches and logs.  It is a port of
Python's @url{https://github.com/ActiveState/appdirs,Appdirs} to R.")
    (license license:expat)))

(define-public r-rastervis
  (package
    (name "r-rastervis")
    (version "0.51.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rasterVis" version))
       (sha256
        (base32
         "12cl201gwah0bn14ji4nbygayd77w5fck9zkcikhrda5s0chvgb1"))))
    (properties `((upstream-name . "rasterVis")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-hexbin
           r-lattice
           r-latticeextra
           r-raster
           r-rcolorbrewer
           r-sp
           r-terra
           r-viridislite
           r-zoo))
    (home-page "https://oscarperpinan.github.io/rastervis/")
    (synopsis "Visualization methods for raster data")
    (description
     "This package provides methods for enhanced visualization and interaction
with raster data.  It implements visualization methods for quantitative data
and categorical data, both for univariate and multivariate rasters.  It also
provides methods to display spatiotemporal rasters, and vector fields.")
    (license license:gpl3)))

(define-public r-rentrez
  (package
    (name "r-rentrez")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rentrez" version))
       (sha256
        (base32
         "0x1g2f6hvkqqlb39z8m5qxhcvsizddic5i7rpqw0wy77xfbna9gv"))))
    (properties `((upstream-name . "rentrez")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httr r-jsonlite r-xml))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/rentrez/")
    (synopsis "Entrez in R")
    (description
     "This package provides an R interface to the NCBI's EUtils API,
allowing users to search databases like GenBank PubMed, process the results of
those searches and pull data into their R sessions.")
    (license license:expat)))

(define-public r-renv
  (package
    (name "r-renv")
    (version "1.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "renv" version))
       (sha256
        (base32
         "09dyr3bka8540k1lq1kyvvvrkj32ck2dw5ys796qjwhfz38jdwap"))))
    (properties `((upstream-name . "renv")))
    (build-system r-build-system)
    ;; Tests attempt to install packages.
    (arguments (list #:tests? #false))
    (native-inputs (list r-knitr))
    (home-page "https://rstudio.github.io/renv")
    (synopsis "Project environments")
    (description
     "This package provides a dependency management toolkit for R.  Using
renv, you can create and manage project-local R libraries, save the state of
these libraries to a lockfile, and later restore your library as required.
Together, these tools can help make your projects more isolated, portable, and
reproducible.")
    (license license:expat)))

;; TODO: esbuild
(define-public r-learnr
  (package
    (name "r-learnr")
    (version "0.11.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "learnr" version))
       (sha256
        (base32
         "01xig6ijsjnkwdjh03zdp86mqm5pjlqp9br34pn644rf98qg8k2y"))))
    (build-system r-build-system)
    ;; Tests need shinytest2.
    (arguments (list #:tests? #false))
    (native-inputs (list esbuild r-knitr r-testthat))
    (propagated-inputs
     (list r-checkmate
           r-digest
           r-ellipsis
           r-evaluate
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-knitr
           r-lifecycle
           r-markdown
           r-promises
           r-rappdirs
           r-renv
           r-rlang
           r-rmarkdown
           r-rprojroot
           r-shiny
           r-withr))
    (home-page "https://rstudio.github.io/learnr/")
    (synopsis "Interactive tutorials for R")
    (description
     "This package provides tools to create interactive tutorials using R
Markdown.  Use a combination of narrative, figures, videos, exercises, and
quizzes to create self-paced tutorials for learning about R and R packages.")
    (license license:asl2.0)))

(define-public r-analytics
  (package
    (name "r-analytics")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "analytics" version))
       (sha256
        (base32
         "0js3c8lwj3knccb55nq03cbjlf4w390p9aid2mi5x80l3ayd9in1"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-cluster
           r-fractal
           r-lmtest
           r-mass
           r-np
           r-powerplus
           r-robust
           r-trend
           r-tsa
           r-urca
           r-vim))
    (home-page "https://cran.r-project.org/web/packages/analytics/")
    (synopsis "Collection of data analysis tools")
    (description
     "This package is a collection of data analysis tools.  It includes tools
for regression outlier detection in a fitted linear model, stationary
bootstrap using a truncated geometric distribution, a comprehensive test for
weak stationarity, column means by group, weighted biplots, and a heuristic to
obtain a better initial configuration in non-metric MDS.")
    (license license:gpl2)))

(define-public r-here
  (package
    (name "r-here")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "here" version))
       (sha256
        (base32 "0srlr8h8qmr0wrmp7gs4g2ry5dni2hx8n947bik3s3a26f091v88"))))
    (properties `((upstream-name . "here")))
    (build-system r-build-system)
    (propagated-inputs (list r-rprojroot))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://here.r-lib.org/")
    (synopsis "Simpler way to find files")
    (description
     "This package lets you construct paths to your project's files.  Use the
@code{here} function as a drop-in replacement for @code{file.path}, it will
always locate the files relative to your project root.")
    (license license:expat)))

(define-public r-reticulate
  (package
    (name "r-reticulate")
    (version "1.40.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reticulate" version))
       (sha256
        (base32
         "1n1858s5091hi8b3xnvsgl8hcngj4sl73hj1f44qw040cjb7pzfd"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'build-reproducibly
           (lambda _
             (setenv "PYTHONHASHSEED" "0")
             (setenv "PYTHONDONTWRITEBYTECODE" "1"))))))
    (inputs (list python))
    (propagated-inputs
     (list r-here
           r-jsonlite
           r-matrix
           r-png
           r-rappdirs
           r-rcpp
           r-rcpptoml
           r-rlang
           r-withr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/rstudio/reticulate")
    (synopsis "R interface to Python")
    (description
     "This package provides an interface from R to Python modules, classes,
and functions.  When calling into Python, R data types are automatically
converted to their equivalent Python types.  When values are returned from
Python to R they are converted back to R types.")
    (license license:asl2.0)))

(define-public r-bibtex
  (package
    (name "r-bibtex")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bibtex" version))
       (sha256
        (base32
         "1l9y945qmpla68rx6dnaxc83vmvkw26cw4zzfgfsvi36wsja1hgk"))))
    (build-system r-build-system)
    (propagated-inputs (list r-backports))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/romainfrancois/bibtex")
    (synopsis "Bibtex parser")
    (description "This package provides a utility for R to parse a bibtex
file.")
    (license license:gpl2+)))

(define-public r-billboarder
  (package
    (name "r-billboarder")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "billboarder" version))
       (sha256
        (base32 "07piczkr5chsxrpkmqx533nxjaw0sgrqzd7xs2779jk8184vr36a"))
       (snippet
        '(delete-file "inst/htmlwidgets/lib/billboard/billboard.pkgd.min.js"))))
    (properties `((upstream-name . "billboarder")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      '(modify-phases (@ (guix build r-build-system) %standard-phases)
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/billboard/"
               (let ((source (assoc-ref inputs "js-billboard"))
                     (target "billboard.pkgd.min.js"))
                 (minify source #:target target))))))))
    (propagated-inputs
     (list r-ggplot2
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-magrittr
           r-rlang
           r-scales
           r-shiny))
    (native-inputs
     `(("r-knitr" ,r-knitr)
       ("r-testthat" ,r-testthat)
       ("esbuild" ,esbuild)
       ;; It is not ideal to use this concatenated (but not minified)
       ;; JavaScript file, as the original source is written in TypeScript.
       ;; However, this can still be considered source code as it is readable
       ;; and can be modified.
       ("js-billboard"
        ,(origin
           (method url-fetch)
           (uri "https://unpkg.com/billboard.js@3.13.0/dist/billboard.js")
           (sha256
            (base32
             "0s1lcmsgcb6yjzz1k03rz2ga3hz9i3i442q30bv4p6z8dagd1akx"))))))
    (home-page "https://github.com/dreamRs/billboarder")
    (synopsis "Create interactive charts with the JavaScript Billboard library")
    (description
     "This package provides an @code{htmlwidgets} interface to billboard.js,
a re-usable easy interface JavaScript chart library, based on D3 v4+.  Chart
types include line charts, scatterplots, bar/lollipop charts,
histogram/density plots, pie/donut charts and gauge charts.  All charts are
interactive, and a proxy method is implemented to smoothly update a chart
without rendering it again in shiny apps.")
    (license license:expat)))

(define-public r-ggseqlogo
  (package
    (name "r-ggseqlogo")
    (version "0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggseqlogo" version))
       (sha256
        (base32
         "1drncw73950dzjx3lyyfqrxm3rdbrp44n27sl4b17m9d0crdbgqw"))))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/omarwagih/ggseqlogo")
    (synopsis "ggplot2 extension for drawing genetic sequence logos")
    (description
     "The range of functions provided by this package makes it possible to
draw highly versatile genomic sequence logos.  Features include, but are not
limited to, modifying colour schemes and fonts used to draw the logo,
generating multiple logo plots, and aiding the visualisation with annotations.
Sequence logos can easily be combined with other ggplot2 plots.")
    ;; Unspecified version of the LGPL.
    (license license:lgpl3+)))

(define-public r-ggsci
  (package
    (name "r-ggsci")
    (version "3.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggsci" version))
       (sha256
        (base32
         "0jiwkk2ij1qnsaqr6354wihj057ia1arrfpjpll00x63056fvn21"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-scales))
    (native-inputs (list r-knitr))
    (home-page "https://nanx.me/ggsci/")
    (synopsis "Scientific journal and sci-fi themed color palettes for ggplot2")
    (description
     "This package provides a collection of ggplot2 color palettes inspired by
plots in scientific journals, data visualization libraries, science fiction
movies, and TV shows.")
    (license license:gpl3)))

(define-public r-ggsignif
  (package
    (name "r-ggsignif")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggsignif" version))
       (sha256
        (base32
         "02mjailzyqkdnzky60dgampw2sq6mnn7s66fk0lhy32s8apm280i"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (propagated-inputs
     (list r-ggplot2))
    (home-page "https://github.com/const-ae/ggsignif")
    (synopsis "Significance brackets for ggplot2")
    (description
     "Enrich your ggplots with group-wise comparisons.  This package provides
an easy way to indicate if two groups are significantly different.  Commonly
this is shown by a bracket on top connecting the groups of interest which
itself is annotated with the level of significance.  The package provides a
single layer that takes the groups for comparison and the test as arguments
and adds the annotation to the plot.")
    (license license:gpl3)))

(define-public r-rstatix
  (package
    (name "r-rstatix")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rstatix" version))
       (sha256
        (base32
         "1891a976k2qjrh1vkzfg8icxblxa978wbazg7mqq8pcw3nmzbip0"))))
    (properties `((upstream-name . "rstatix")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-car
           r-corrplot
           r-dplyr
           r-generics
           r-magrittr
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect))
    (native-inputs (list r-testthat))
    (home-page "https://rpkgs.datanovia.com/rstatix/")
    (synopsis "Pipe-friendly framework for basic statistical tests")
    (description
     "This package provides a simple and intuitive pipe-friendly framework,
coherent with the @code{tidyverse} design philosophy, for performing basic
statistical tests, including t-test, Wilcoxon test, ANOVA, Kruskal-Wallis and
correlation analyses.  The output of each test is automatically transformed
into a tidy data frame to facilitate visualization.  Additional functions are
available for reshaping, reordering, manipulating and visualizing correlation
matrix.")
    (license license:gpl2)))

(define-public r-ggpubr
  (package
    (name "r-ggpubr")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggpubr" version))
       (sha256
        (base32
         "0x7p3lbh0xv5qk0shsrj1fjx382zak7mj8l3z1zd348r2pccavif"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cowplot
           r-dplyr
           r-ggplot2
           r-ggrepel
           r-ggsci
           r-ggsignif
           r-glue
           r-gridextra
           r-magrittr
           r-polynom
           r-purrr
           r-rlang
           r-rstatix
           r-scales
           r-tibble
           r-tidyr))
    (native-inputs (list r-testthat))
    (home-page "http://www.sthda.com/english/rpkgs/ggpubr")
    (synopsis "ggplot2-based publication-ready plots")
    (description
     "The ggplot2 package is an excellent and flexible package for elegant
data visualization in R.  However the default generated plots require some
formatting before we can send them for publication.  The ggpubr package
provides some easy-to-use functions for creating and customizing ggplot2-based
publication-ready plots.")
    (license license:gpl2)))

(define-public r-ellipse
  (package
    (name "r-ellipse")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ellipse" version))
       (sha256
        (base32
         "1wy25kw3055zxzidzzkif6c8bmch73qkv2ri4i1w0b6ffcwmbs6d"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ellipse/")
    (synopsis "Functions for drawing ellipses and ellipse-like confidence regions")
    (description
     "This package contains various routines for drawing ellipses and
ellipse-like confidence regions, implementing the plots described in Murdoch
and Chow (1996), A graphical display of large correlation matrices, The
American Statistician 50, 178-180.  There are also routines implementing the
profile plots described in Bates and Watts (1988), Nonlinear Regression
Analysis and its Applications.")
    (license license:gpl2+)))

(define-public r-flashclust
  (package
    (name "r-flashclust")
    (version "1.01-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flashClust" version))
       (sha256
        (base32
         "0l4lpz451ll7f7lfxmb7ds24ppzhfg1c3ypvydglcc35p2dq99s8"))))
    (properties `((upstream-name . "flashClust")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/flashClust/")
    (synopsis "Implementation of optimal hierarchical clustering")
    (description
     "This package provides a fast implementation of hierarchical
clustering.")
    (license license:gpl2+)))

(define-public r-factominer
  (package
    (name "r-factominer")
    (version "2.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FactoMineR" version))
       (sha256
        (base32
         "0qzhfjcz0kahqf214g4xs7gfpqx05xbfiwa5r2ldgn2drd16phij"))))
    (properties `((upstream-name . "FactoMineR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-cluster
           r-dt
           r-ellipse
           r-emmeans
           r-flashclust
           r-ggplot2
           r-ggrepel
           r-lattice
           r-leaps
           r-mass
           r-multcompview
           r-scatterplot3d))
    (native-inputs
     (list r-knitr))
    (home-page "http://factominer.free.fr")
    (synopsis "Multivariate exploratory data analysis and data mining")
    (description
     "This package provides exploratory data analysis methods to summarize,
visualize and describe datasets.  The main principal component methods are
available, those with the largest potential in terms of applications:
principal component analysis (PCA) when variables are quantitative,
correspondence analysis (CA) and multiple correspondence analysis (MCA) when
variables are categorical, Multiple Factor Analysis when variables are
structured in groups, etc. and hierarchical cluster analysis.")
    (license license:gpl2+)))

(define-public r-factoextra
  (package
    (name "r-factoextra")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "factoextra" version))
       (sha256
        (base32
         "1allvdjhd3pq8xz30b1cymwcik5iaahghrjrlnn54cwkfhfg0kv2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-cluster
           r-dendextend
           r-factominer
           r-ggplot2
           r-ggpubr
           r-ggrepel
           r-reshape2
           r-tidyr))
    (home-page "http://www.sthda.com/english/rpkgs/factoextra")
    (synopsis "Extract and visualize the results of multivariate data analyses")
    (description
     "This package provides some easy-to-use functions to extract and
visualize the output of multivariate data analyses, including
@code{PCA} (Principal Component Analysis), @code{CA} (Correspondence
Analysis), @code{MCA} (Multiple Correspondence Analysis), @code{FAMD} (Factor
Analysis of Mixed Data), @code{MFA} (Multiple Factor Analysis) and
@code{HMFA} (Hierarchical Multiple Factor Analysis) functions from different R
packages.  It contains also functions for simplifying some clustering analysis
steps and provides ggplot2-based elegant data visualization.")
    (license license:gpl2)))

(define-public r-fancova
  (package
    (name "r-fancova")
    (version "0.6-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fANCOVA" version))
       (sha256
        (base32 "04mw0blgpwdk6wdg8llrig43psgc0vb42cbimvzbnym8v503dsn3"))))
    (properties `((upstream-name . "fANCOVA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=fANCOVA")
    (synopsis "Nonparametric analysis of covariance")
    (description
     "This package provides a collection of R functions to perform
nonparametric analysis of covariance for regression curves or surfaces.
Testing the equality or parallelism of nonparametric curves or surfaces is
equivalent to analysis of variance (ANOVA) or analysis of covariance (ANCOVA)
for one-sample functional data.  Three different testing methods are available
in the package, including one based on L-2 distance, one based on an ANOVA
statistic, and one based on variance estimators.")
    (license license:gpl3)))

(define-public r-fansi
  (package
    (name "r-fansi")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fansi" version))
       (sha256
        (base32
         "0qqq8gz6sfr5yib4qmvk458qa0ypaz0n7f2ygjnpy2p5vy8cd7ga"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr)) ; for vignettes
    (home-page "https://github.com/brodieG/fansi")
    (synopsis "ANSI control sequence aware string functions")
    (description
     "This package provides counterparts to R string manipulation functions
that account for the effects of ANSI text formatting control sequences.")
    (license license:gpl2+)))

(define-public r-nbclust
  (package
    (name "r-nbclust")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NbClust" version))
       (sha256
        (base32
         "0k5hr4zgx4gp1n62xchgz2zvyl35ba2cnczhhvj8rfbg2n4hx6qs"))))
    (properties `((upstream-name . "NbClust")))
    (build-system r-build-system)
    (home-page "https://sites.google.com/site/malikacharrad/research/nbclust-package")
    (synopsis "Determine the best number of clusters in a data set")
    (description
     "NbClust provides 30 indexes for determining the optimal number of
clusters in a data set and offers the best clustering scheme from different
results to the user.")
    (license license:gpl2)))

(define-public r-hdf5r
  (package
    (name "r-hdf5r")
    (version "1.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hdf5r" version))
       (sha256
        (base32
         "1i58andd3k7ghmlv9f2frfa823p6lhdcwghyrszgmb3jpikxd5cp"))))
    (build-system r-build-system)
    (inputs
     (list hdf5 zlib))
    (propagated-inputs
     (list r-bit64 r-r6))
    (native-inputs
     (list pkg-config r-knitr r-testthat))
    (home-page "https://hhoeflin.github.io/hdf5r")
    (synopsis "Interface to the HDF5 binary data format")
    (description
     "HDF5 is a data model, library and file format for storing and managing
large amounts of data.  This package provides a nearly feature complete,
object oriented wrapper for the HDF5 API using R6 classes.  Additionally,
functionality is added so that HDF5 objects behave very similar to their
corresponding R counterparts.")
    (license license:asl2.0)))

(define-public r-itertools
  (package
    (name "r-itertools")
    (version "0.1-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "itertools" version))
       (sha256
        (base32
         "1ls5biiva10pb1dj3ph4griykb9vam02hkrdmlr5a5wf660hg6xn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-iterators))
    (home-page "https://cran.r-project.org/web/packages/itertools/")
    (synopsis "Iterator tools")
    (description
     "This package provides various tools for creating iterators, many
patterned after functions in the Python @code{itertools} module, and others
patterned after functions in the snow package.")
    (license license:gpl2)))

(define-public r-itsadug
  (package
    (name "r-itsadug")
    (version "2.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "itsadug" version))
       (sha256
        (base32 "1sdqs279qxr3993hw08xg7b54yq03jw1597cqn6cf24sh9vpw9m1"))))
    (properties `((upstream-name . "itsadug")))
    (build-system r-build-system)
    (propagated-inputs (list r-mgcv r-plotfunctions))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=itsadug")
    (synopsis "Interpreting time series and autocorrelated data using GAMMs")
    (description
     "@dfn{Generalized Additive Mixed Modeling} (GAMM; Lin & Zhang, 1999) as
implemented in the R package @code{mgcv} is a nonlinear regression analysis
which is particularly useful for time course data such as EEG, pupil dilation,
gaze data (eye tracking), and articulography recordings, but also for
behavioral data such as reaction times and response data.  As time course
measures are sensitive to autocorrelation problems, GAMMs implements methods
to reduce the autocorrelation problems.  This package includes functions for
the evaluation of GAMM models (e.g., model comparisons, determining regions of
significance, inspection of autocorrelational structure in residuals) and
interpreting of GAMMs (e.g., visualization of complex interactions, and
contrasts).")
    (license license:gpl2+)))

(define-public r-polynom
  (package
    (name "r-polynom")
    (version "1.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "polynom" version))
       (sha256
        (base32
         "0y4j07syjwpnq5w6a1d90z6h1hjzijmm42pq0f8jk2vcn5xxn7mw"))))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/polynom/")
    (synopsis "Functions for univariate polynomial manipulations")
    (description
     "This package provides a collection of functions to implement a class for
univariate polynomial manipulations.")
    (license license:gpl2)))

(define-public r-pupillometryr
  (package
    (name "r-pupillometryr")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PupillometryR" version))
       (sha256
        (base32 "0jqpx5g0fjdxxp7wlgv4jm5vrhchm6r21qd7i825fi5552c46awv"))))
    (properties `((upstream-name . "PupillometryR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-fda
           r-ggplot2
           r-itsadug
           r-mgcv
           r-rlang
           r-signal
           r-stringr
           r-tidyr
           r-zoo))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=PupillometryR")
    (synopsis "Unified pipeline for pupillometry data")
    (description
     "This package provides a unified pipeline to clean, prepare, plot, and
run basic analyses on pupillometry experiments.")
    (license license:expat)))

(define-public r-gbrd
  (package
    (name "r-gbrd")
    (version "0.4.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gbRd" version))
       (sha256
        (base32
         "0f13hg6nckl4aflwd49g4x2adxjfgah2yga70z1m8jszhhm1vka8"))))
    (properties `((upstream-name . "gbRd")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/gbRd/")
    (synopsis "Utilities for processing Rd objects and files")
    (description
     "This package provides utilities for processing Rd objects and files.
Extract argument descriptions and other parts of the help pages of
functions.")
    (license license:gpl2+)))

(define-public r-rjags
  (package
    (name "r-rjags")
    (version "4-16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rjags" version))
       (sha256
        (base32
         "1rz7qx5prkikrvfcj3ps0sxsj44kgpqairj4zwcn5qlsa4z3k79n"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-coda))
    (inputs
     (list jags))
    (native-inputs
     (list pkg-config))
    (home-page "https://mcmc-jags.sourceforge.net")
    (synopsis "Bayesian graphical models using MCMC")
    (description
     "This package provides an R interface to the JAGS MCMC library.  JAGS is
Just Another Gibbs Sampler.  It is a program for analysis of Bayesian
hierarchical models using Markov Chain Monte Carlo (MCMC) simulation.")
    (license license:gpl2)))

(define-public r-rbibutils
  (package
    (name "r-rbibutils")
    (version "2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rbibutils" version))
       (sha256
        (base32
         "0zvpa39d6a9ibaqnz6na0nm7ybmhmshr5s4vdndsmgcv45iasd8c"))))
    (properties `((upstream-name . "rbibutils")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://geobosh.github.io/rbibutils/")
    (synopsis "Convert between bibliography formats")
    (description
     "This package converts between a number of bibliography formats,
including BibTeX, BibLaTeX and Bibentry.  It includes a port of the bibutils
utilities and supports all bibliography formats and character encodings
implemented in bibutils.")
    (license license:gpl2)))

(define-public r-rbiom
  (package
    (name "r-rbiom")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rbiom" version))
       (sha256
        (base32 "13nma1s3p4bzh8mvikrnmkqyyrx9axvxavq6fyk2w0j804w1qzcg"))))
    (properties `((upstream-name . "rbiom")))
    (build-system r-build-system)
    (propagated-inputs (list r-magrittr
                             r-openxlsx
                             r-plyr
                             r-r-utils
                             r-rcpp
                             r-rcppparallel
                             r-rjson
                             r-rlang
                             r-slam))
    (native-inputs (list r-testthat))
    (home-page "https://cmmr.github.io/rbiom/index.html")
    (synopsis "Read/write, transform, and summarize BIOM data")
    (description
     "This package provides a toolkit for working with @dfn{Biological
Observation Matrix} (BIOM) files.  Features include reading/writing all BIOM
formats, rarefaction, alpha diversity, beta diversity (including UniFrac),
summarizing counts by taxonomic level, and sample subsetting.  Standalone
functions for reading, writing, and subsetting phylogenetic trees are also
provided.")
    (license license:agpl3)))

(define-public r-rdpack
  (package
    (name "r-rdpack")
    (version "2.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rdpack" version))
       (sha256
        (base32
         "0igrmi0v17jsbfa770d6rcfnkjx6l2x3shskvjzhc5xbqjbn6qir"))))
    (properties `((upstream-name . "Rdpack")))
    (build-system r-build-system)
    ;; FIXME It's unclear why the tests fail.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-rbibutils))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/GeoBosh/Rdpack")
    (synopsis "Update and manipulate Rd documentation objects")
    (description
     "This package provides functions for manipulation of R documentation
objects, including functions @code{reprompt()} and @code{ereprompt()} for
updating Rd documentation for functions, methods and classes; it also includes
Rd macros for citations and import of references from bibtex files for use in
Rd files and roxygen2 comments, as well as many functions for manipulation of
references and Rd files.")
    (license license:gpl2+)))

(define-public r-officer
  (package
    (name "r-officer")
    (version "0.6.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "officer" version))
       (sha256
        (base32
         "1a9bv5qryivi84f56plz2xaffy2sapviwgwdgzxq9mys7bzsybzh"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-openssl
           r-r6
           r-ragg
           r-uuid
           r-xml2
           r-zip))
    (native-inputs (list r-testthat))
    (home-page "https://davidgohel.github.io/officer")
    (synopsis "Manipulation of Word and PowerPoint documents")
    (description
     "This package provides tools to access and manipulate Word and PowerPoint
documents from R.  The package focuses on tabular and graphical reporting from
R; it also provides two functions that let users get document content into
data objects.  A set of functions lets add and remove images, tables and
paragraphs of text in new or existing documents.  When working with PowerPoint
presentations, slides can be added or removed; shapes inside slides can also
be added or removed.  When working with Word documents, a cursor can be used
to help insert or delete content at a specific location in the document.")
    (license license:gpl3)))

(define-public r-profilemodel
  (package
    (name "r-profilemodel")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "profileModel" version))
       (sha256
        (base32
         "01m5nb8cmq0aq555pxk2a99182si65hhmn68yn9nal2j3zl2bp4i"))))
    (properties `((upstream-name . "profileModel")))
    (build-system r-build-system)
    (home-page "https://github.com/ikosmidis/profileModel")
    (synopsis "Profiling inference functions for various model classes")
    (description
     "This package provides tools that can be used to calculate, evaluate,
plot and use for inference the profiles of *arbitrary* inference functions for
arbitrary @code{glm}-like fitted models with linear predictors.  More information
on the methods that are implemented can be found in Kosmidis (2008)
@url{https://www.r-project.org/doc/Rnews/Rnews_2008-2.pdf}.")
    (license license:gpl2+)))

(define-public r-brglm
  (package
    (name "r-brglm")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "brglm" version))
       (sha256
        (base32
         "08shcz0j1npdn7xkhsvlzs3z4rdwq3g4rk6a4xx8wirqw8n8s2an"))))
    (properties `((upstream-name . "brglm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-profilemodel))
    (home-page "https://github.com/ikosmidis/brglm")
    (synopsis "Bias reduction in binomial-response generalized linear models")
    (description
     "Fit generalized linear models with binomial responses using either an
adjusted-score approach to bias reduction or maximum penalized likelihood
where penalization is by Jeffreys invariant prior.  These procedures return
estimates with improved frequentist properties (bias, mean squared error) that
are always finite even in cases where the maximum likelihood estimates are
infinite (data separation).  Fitting takes place by fitting generalized linear
models on iteratively updated pseudo-data.  The interface is essentially the
same as @code{glm}.  More flexibility is provided by the fact that custom
pseudo-data representations can be specified and used for model fitting.
Functions are provided for the construction of confidence intervals for the
reduced-bias estimates.")
    (license license:gpl2+)))

(define-public r-entropy
  (package
    (name "r-entropy")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "entropy" version))
       (sha256
        (base32
         "1f0j8jsn6pzf4gi5g0akixx6x5vc69ci5f4m2vnwp40frvsqjnkg"))))
    (properties `((upstream-name . "entropy")))
    (build-system r-build-system)
    (home-page "https://www.strimmerlab.org/software/entropy/")
    (synopsis "Estimation of entropy, mutual information and related quantities")
    (description
     "This package implements various estimators of entropy, such as the
shrinkage estimator by Hausser and Strimmer, the maximum likelihood and the
Millow-Madow estimator, various Bayesian estimators, and the Chao-Shen
estimator.  It also offers an R interface to the NSB estimator.  Furthermore,
it provides functions for estimating Kullback-Leibler divergence, chi-squared,
mutual information, and chi-squared statistic of independence.  In addition
there are functions for discretizing continuous random variables.")
    (license license:gpl3+)))

(define-public r-acd
  (package
    (name "r-acd")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACD" version))
       (sha256
        (base32
         "1a67bi3hklq8nlc50r0qnyr4k7m9kpvijy8sqqpm54by5hsysfd6"))))
    (properties `((upstream-name . "ACD")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ACD/")
    (synopsis "Categorical data analysis with complete or missing responses")
    (description
     "This package provides tools for categorical data analysis with complete
or missing responses.")
    (license license:gpl2+)))

(define-public r-acdm
  (package
    (name "r-acdm")
    (version "1.0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACDm" version))
       (sha256
        (base32
         "0g89827az5mnllp6l71znbvwxzygb8nvnmsv6x052w2ajhd16v7v"))))
    (properties `((upstream-name . "ACDm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-ggplot2 r-plyr r-rsolnp r-zoo))
    (home-page "https://cran.r-project.org/web/packages/ACDm/")
    (synopsis "Tools for Autoregressive Conditional Duration Models")
    (description
     "ACDm is a package for Autoregressive Conditional Duration (ACD, Engle
and Russell, 1998) models.  It creates trade, price or volume durations from
transactions (tic) data, performs diurnal adjustments, fits various ACD models
and tests them.")
    (license license:gpl2+)))

(define-public r-overlap
  (package
    (name "r-overlap")
    (version "0.3.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "overlap" version))
       (sha256
        (base32
         "0x6mmd7gya17saph4dncl9dspfwc8achwcg5s5f92flwis76r7km"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-suntools))
    (home-page "https://cran.r-project.org/web/packages/overlap/")
    (synopsis "Estimates of coefficient of overlapping for animal activity patterns")
    (description
     "This package provides functions to fit kernel density functions to data
on temporal activity patterns of animals; estimate coefficients of overlapping
of densities for two species; and calculate bootstrap estimates of confidence
intervals.")
    (license license:gpl3+)))

(define-public r-snakecase
  (package
    (name "r-snakecase")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "snakecase" version))
       (sha256
        (base32
         "0888fng8zwm2zmi7rap9hc2q2x2gnhz8gyr35wwjx93w6f8rfpra"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-stringi r-stringr))
    (native-inputs (list r-knitr r-testthat r-tibble))
    (home-page "https://github.com/Tazinho/snakecase")
    (synopsis "Convert strings into any case")
    (description
     "This package provides a consistent, flexible and easy to use tool to
parse and convert strings into cases like snake or camel among others.")
    (license license:gpl3)))

(define-public r-prediction
  (package
    (name "r-prediction")
    (version "0.3.18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prediction" version))
       (sha256
        (base32
         "194p2zbypslkd7slnvqw2z456xxwfzjxd11dirhpffjcsizkgrnh"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/leeper/prediction")
    (synopsis "Tidy, type-safe prediction methods")
    (description
     "This package provides the @code{prediction()} function, a type-safe
alternative to @code{predict()} that always returns a data frame.  The package
currently supports common model types (e.g., @code{\"lm\"}, @code{\"glm\"})
from the @code{stats} package, as well as numerous other model classes from
other add-on packages.")
    (license license:expat)))

(define-public r-prettygraphs
  (package
    (name "r-prettygraphs")
    (version "2.1.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "prettyGraphs" version))
              (sha256
               (base32
                "0yjpwxdy9mkj2k33zvd5klyv4ava46i19yls87n0bvf79y90ikpy"))))
    (properties `((upstream-name . "prettyGraphs")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=prettyGraphs")
    (synopsis "Publication-quality graphics")
    (description
     "This package provides simple and crisp publication-quality graphics for
the ExPosition family of packages.  See An ExPosition of the Singular Value
Decomposition in R (Beaton et al 2014) <doi:10.1016/j.csda.2013.11.006>.")
    (license license:gpl2)))

(define-public r-insight
  (package
    (name "r-insight")
    (version "0.20.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "insight" version))
       (sha256
        (base32
         "1zc5w7nf8mlvk55shdqyjgb7nnx17gac8nl7wqs1ws7mq5x0n7b8"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://easystats.github.io/insight/")
    (synopsis "Easy access to model information for various model objects")
    (description
     "This package provides a tool to provide an easy, intuitive and
consistent access to information contained in various R models, like model
formulas, model terms, information about random effects, data that was used to
fit the model or data from response variables.  The package mainly revolves
around two types of functions: Functions that find (the names of) information,
starting with @code{find_}, and functions that get the underlying data,
starting with @code{get_}.  The package has a consistent syntax and works with
many different model objects, where otherwise functions to access these
information are missing.")
    (license license:gpl3)))

(define-public r-sjlabelled
  (package
    (name "r-sjlabelled")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjlabelled" version))
       (sha256
        (base32
         "1va86q5wddyvqgdpy8d0an2c7v1qbb4hpn0ai6y1v5v1ff87w73k"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-datawizard r-insight))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/strengejacke/sjlabelled")
    (synopsis "Labelled data utility functions")
    (description
     "This package provides a collection of functions dealing with labelled
data, like reading and writing data between R and other statistical software
packages.  This includes easy ways to get, set or change value and variable
label attributes, to convert labelled vectors into factors or numeric (and
vice versa), or to deal with multiple declared missing values.")
    (license license:gpl3)))

(define-public r-sjmisc
  (package
    (name "r-sjmisc")
    (version "2.8.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjmisc" version))
       (sha256
        (base32
         "12y5aa820h95dbak9zd2rbg1hc0636b2dpg0mn9mkb76a4ssnr1d"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-datawizard
           r-dplyr
           r-insight
           r-magrittr
           r-purrr
           r-rlang
           r-sjlabelled
           r-tidyselect))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/strengejacke/sjmisc")
    (synopsis "Data and variable transformation functions")
    (description
     "This package is a collection of miscellaneous utility functions,
supporting data transformation tasks like recoding, dichotomizing or grouping
variables, setting and replacing missing values.  The data transformation
functions also support labelled data, and all integrate seamlessly into a
tidyverse workflow.")
    (license license:gpl3)))

(define-public r-nodbi
  (package
    (name "r-nodbi")
    (version "0.11.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "nodbi" version))
              (sha256
               (base32
                "0801jcs5kln8fpjr3vgn2mmv52ygdybynh2fwfa632j2cn0laq1i"))))
    (properties `((upstream-name . "nodbi")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dbi
           r-jqr
           r-jsonlite
           r-r-utils
           r-stringi
           r-uuid
           r-v8))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/nodbi/")
    (synopsis "NoSQL database connector")
    (description
     "This is a package for simplified document database access and
manipulation, providing a common API across supported NoSQL databases
Elasticsearch, CouchDB, MongoDB as well as SQLite/JSON1, PostgreSQL, and
DuckDB.")
    (license license:expat)))

(define-public r-nortest
  (package
    (name "r-nortest")
    (version "1.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nortest" version))
       (sha256
        (base32
         "17r0wpz72z9312c70nwi1i1kp1v9fm1h6jg7q5cx1mc1h420m1d3"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/nortest/")
    (synopsis "Tests for normality")
    (description
     "This package provides five omnibus tests for testing the composite
hypothesis of normality.")
    (license license:gpl2+)))

(define-public r-moonbook
  (package
    (name "r-moonbook")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "moonBook" version))
       (sha256
        (base32
         "1ml4vvm0mvrprpyi0l50aw38brx18bk2qny4gybmkvlbakalz9bx"))))
    (properties `((upstream-name . "moonBook")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-magrittr
           r-nortest
           r-sjmisc
           r-stringr
           r-survival))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/cardiomoon/moonBook")
    (synopsis "Functions and datasets for the book by Keon-Woong Moon")
    (description
     "This package provides several analysis-related functions for the book
entitled \"R statistics and graph for medical articles\" (written in Korean),
version 1, by Keon-Woong Moon with Korean demographic data with several plot
functions.")
    (license license:gpl2)))

(define-public r-flextable
  (package
    (name "r-flextable")
    (version "0.9.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flextable" version))
       (sha256
        (base32
         "01jz0rflzc0f4lwnmmk8s2vj281l2ch75avcbin0b4wis48xrj2q"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table
           r-gdtools
           r-htmltools
           r-knitr
           r-officer
           r-ragg
           r-rlang
           r-rmarkdown
           r-uuid
           r-xml2))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://davidgohel.github.io/flextable")
    (synopsis "Functions for tabular reporting")
    (description
     "This package provides tools to create pretty tables for HTML documents
and other formats.  Functions are provided to let users create tables, modify
and format their content.  It extends the @code{officer} package and can be
used within R markdown documents when rendering to HTML and to Word
documents.")
    (license license:gpl3)))

(define-public r-writexl
  (package
    (name "r-writexl")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "writexl" version))
       (sha256
        (base32
         "14wv9l927bh57jbdxcf8wb429mz85x5bnsm31i2j3m0db0ikf4ax"))))
    (build-system r-build-system)
    (inputs (list zlib))
    (native-inputs (list r-spelling r-testthat))
    (home-page "https://github.com/ropensci/writexl")
    (synopsis "Export data frames to xlsx format")
    (description
     "This package provides a data frame to xlsx exporter based on
libxlsxwriter.")
    (license license:bsd-2)))

(define-public r-writexls
  (package
    (name "r-writexls")
    (version "6.7.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "WriteXLS" version))
              (sha256
               (base32
                "0vr6h7jycwiic02krgz0ignzqhpi3vc9gsa5cykvg8wxdsfyyb6k"))))
    (properties `((upstream-name . "WriteXLS")))
    (build-system r-build-system)
    (inputs (list perl))
    (home-page "https://github.com/marcschwartz/WriteXLS")
    (synopsis "Create Excel 2003 (XLS) and Excel 2007 (XLSX) files")
    (description
     "This package provides a cross-platform Perl-based R function to create
Excel 2003 (XLS) and Excel 2007 (XLSX) files from one or more data frames.
Each data frame will be written to a separate named worksheet in the Excel
spreadsheet.  The worksheet name will be the name of the data frame it
contains or can be specified by the user.")
    (license license:gpl2+)))

(define-public r-wrs2
  (package
    (name "r-wrs2")
    (version "1.1-6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "WRS2" version))
              (sha256
               (base32
                "1wsnsl4gy1hbgxfzzhfybak0jqmxq9fsh3scqyxydd7ia9r2n52k"))))
    (properties `((upstream-name . "WRS2")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass r-plyr r-reshape))
    (native-inputs (list r-knitr))
    (home-page "https://r-forge.r-project.org/projects/psychor/")
    (synopsis "Collection of robust statistical methods")
    (description
     "R-wrs2 offers a range of strong stats methods from Wilcox WRS functions.
It implements robust t-tests, both independent and dependent, robust ANOVA,
including designs with between-within subjects, quantile ANOVA, robust
correlation, robust mediation, and nonparametric ANCOVA models using robust
location measures.")
    (license license:gpl3)))

(define-public r-biasedurn
  (package
    (name "r-biasedurn")
    (version "2.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BiasedUrn" version))
       (sha256
        (base32
         "14jpijms81pgl4zyqrhwwdfj0jmlmml21blspvin8lqw8fbbbcr9"))))
    (properties `((upstream-name . "BiasedUrn")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/BiasedUrn/")
    (synopsis "Biased Urn model distributions")
    (description
     "This package provides statistical models of biased sampling in the form
of univariate and multivariate noncentral hypergeometric distributions,
including Wallenius' noncentral hypergeometric distribution and Fisher's
noncentral hypergeometric distribution (also called extended hypergeometric
distribution).")
    (license license:gpl3)))

(define-public r-golem
  (package
    (name "r-golem")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "golem" version))
              (sha256
               (base32
                "079zjzqvslv8k9pj52xwdhk6a9a8sg0p9wc6s457lz0ircan9ml6"))))
    (properties `((upstream-name . "golem")))
    (build-system r-build-system)
    ;; The tests attempt to install packages and mess up the test environment.
    ;; We don't do that around here.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-attempt
           r-config
           r-here
           r-htmltools
           r-rlang
           r-shiny
           r-yaml))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/ThinkR-open/golem")
    (synopsis "Framework for robust Shiny applications")
    (description
     "This package implements an opinionated framework for building a
production- ready Shiny application.  Golem contains a series of tools like
dependency management, version management, easy installation and deployment or
documentation management.")
    (license license:expat)))

(define-public r-goplot
  (package
    (name "r-goplot")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GOplot" version))
       (sha256
        (base32
         "1y8dv0kbzpr9za91njw0x233vx5d13vqml9hmpddcyi9s6va5nix"))))
    (properties `((upstream-name . "GOplot")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggdendro r-ggplot2 r-gridextra r-rcolorbrewer))
    (home-page "https://github.com/wencke/wencke.github.io")
    (synopsis "Visualization of functional analysis data")
    (description
     "This package provides an implementation of multilayered visualizations
for enhanced graphical representation of functional analysis data.  It
combines and integrates omics data derived from expression and functional
annotation enrichment analyses.  Its plotting functions have been developed
with an hierarchical structure in mind: starting from a general overview to
identify the most enriched categories (modified bar plot, bubble plot) to a
more detailed one displaying different types of relevant information for the
molecules in a given set of categories (circle plot, chord plot, cluster plot,
Venn diagram, heatmap).")
    (license license:gpl2)))

(define-public r-getopt
  (package
    (name "r-getopt")
    (version "1.20.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "getopt" version))
       (sha256
        (base32
         "12qy48adnibfi9rpv5qd8k3hipbc4q85514dsz0xnhdsdnz6rlw7"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/trevorld/getopt")
    (synopsis "Command-line option processor for R")
    (description
     "This package is designed to be used with Rscript to write shebang
scripts that accept short and long options.  Many users will prefer to
use the packages @code{optparse} or @code{argparse} which add extra
features like automatically generated help options and usage texts,
support for default values, positional argument support, etc.")
    (license license:gpl2+)))

(define-public r-findpython
  (package
    (name "r-findpython")
    (version "1.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "findpython" version))
       (sha256
        (base32
         "1dydchid5mc79253v5b86bnbg3rm78w0hs586c1rr56lmz5r12hg"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/trevorld/findpython")
    (synopsis "Functions to find an acceptable Python binary")
    (description
     "This package was designed to find an acceptable Python binary that
matches version and feature constraints.")
    (license license:expat)))

;; This in not the same as "r-argparser"
(define-public r-argparse
  (package
    (name "r-argparse")
    (version "2.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "argparse" version))
       (sha256
        (base32
         "0x16zp6jh9asyval1kwkxzavwjhx3a47xzlc593kw1hz4bhw8355"))))
    (build-system r-build-system)
    (inputs (list python))
    (propagated-inputs
     (list r-findpython r-jsonlite r-r6))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/trevorld/argparse")
    (synopsis "Command line optional and positional argument parser")
    (description
     "This package provides a command line parser to be used with Rscript to
write shebang scripts that gracefully accept positional and optional arguments
and automatically generate usage notices.")
    (license license:gpl2+)))

(define-public r-hash
  (package
    (name "r-hash")
    (version "2.2.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hash" version))
       (sha256
        (base32
         "044ifii4gpinzi9vbv5aw0da956ccslxg34xmx24njf6x5dhn0wa"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/hash/")
    (synopsis "Implementation of hash/associated arrays/dictionaries")
    (description
     "This package implements a data structure similar to hashes in Perl and
dictionaries in Python but with a purposefully R flavor.  For objects of
appreciable size, access using hashes outperforms native named lists and
vectors.")
    (license license:gpl2+)))

(define-public r-orddom
  (package
    (name "r-orddom")
    (version "3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "orddom" version))
       (sha256
        (base32
         "165axs15fvwhrp89xd87l81q3h2qjll1vrwcsap645cwvb85nwsh"))))
    (build-system r-build-system)
    (propagated-inputs (list r-psych))
    (home-page "https://cran.r-project.org/web/packages/orddom/")
    (synopsis "Ordinal dominance statistics")
    (description
     "This package provides tools to compute ordinal, statistics and effect
sizes as an alternative to mean comparison: Cliff's delta or success rate
difference (SRD), Vargha and Delaney's A or the Area Under a Receiver
Operating Characteristic Curve (AUC), the discrete type of McGraw & Wong's
Common Language Effect Size (CLES) or Grissom & Kim's Probability of
Superiority (PS), and the Number needed to treat (NNT) effect size.  Moreover,
comparisons to Cohen's d are offered based on Huberty & Lowman's Percentage of
Group (Non-)Overlap considerations.")
    (license license:gpl2)))

(define-public r-deriv
  (package
    (name "r-deriv")
    (version "4.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Deriv" version))
       (sha256
        (base32
         "0wmslhggdhamvzfa0nvj6j5bc8jhiy3n5q0p5ha9bcsyvi92mf01"))))
    (properties `((upstream-name . "Deriv")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/Deriv")
    (synopsis "Symbolic differentiation")
    (description
     "This package provides an R-based solution for symbolic differentiation.
It admits user-defined functions as well as function substitution in arguments
of functions to be differentiated.  Some symbolic simplification is part of
the work.")
    (license license:gpl3+)))

(define-public r-doby
  (package
    (name "r-doby")
    (version "4.6.24")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doBy" version))
       (sha256
        (base32
         "1vihc2289ziakxfxfsq64axms2ppja2vgvz09grjckwiaq1widll"))))
    (properties `((upstream-name . "doBy")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot
           r-broom
           r-cowplot
           r-deriv
           r-dplyr
           r-ggplot2
           r-mass
           r-matrix
           r-microbenchmark
           r-modelr
           r-rlang
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://people.math.aau.dk/~sorenh/software/doBy/")
    (synopsis "Groupwise statistics, LSmeans, linear contrasts, and utilities")
    (description
     "This package contains:

@itemize
@item facilities for working with grouped data: @code{do}
  something to data stratified @code{by} some variables.
@item implementations of least-squares means, general linear contrasts, and
@item miscellaneous other utilities.
@end itemize\n")
    (license license:gpl2+)))

(define-public r-refgenome
  (package
    (name "r-refgenome")
    (version "1.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "refGenome" version))
       (sha256
        (base32
         "1za89bn3am1zgvm641qi1ab6kaqpll4rb9p9f1sjwvcgqq6065g5"))))
    (properties `((upstream-name . "refGenome")))
    (build-system r-build-system)
    ;; FIXME: Tests fail with: No matches between query and reference seqid's
    ;; (wrong genome?)
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-dbi r-doby r-rsqlite))
    (home-page "https://cran.r-project.org/web/packages/refGenome/")
    (synopsis
     "Gene and splice site annotation using annotation data from Ensembl and UCSC")
    (description
     "This package contains functionality for importing and managing of
downloaded genome annotation data from the Ensembl genome browser (European
Bioinformatics Institute) and from the UCSC genome browser (University of
California, Santa Cruz) and annotation routines for genomic positions and
splice site positions.")
    (license license:gpl2)))

(define-public r-reformulas
  (package
    (name "r-reformulas")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reformulas" version))
       (sha256
        (base32 "0d5zda1a355xl935kgbqzbk1mpsdfafa92pgfqhfrap8wnwxjkq4"))))
    (properties `((upstream-name . "reformulas")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-rdpack))
    (home-page "https://github.com/bbolker/reformulas")
    (synopsis "Machinery for processing random effect formulas")
    (description
     "This package lets you take formulas including random-effects
components (formatted as in @code{lme4}, @code{glmmTMB}, etc.) and process
them.  It includes various helper functions.")
    (license license:gpl3)))

(define-public r-basix
  (package
    (name "r-basix")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BASIX" version))
       (sha256
        (base32
         "18dkvv1iwskfnlpl6xridcgqpalbbpm2616mvc3hfrc0b26v01id"))))
    (properties `((upstream-name . "BASIX")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/BASIX/")
    (synopsis "Efficient C/C++ toolset for R")
    (description
     "BASIX provides some efficient C/C++ implementations of native R
procedures to speed up calculations in R.")
    (license license:gpl2)))

(define-public r-blockfest
  (package
    (name "r-blockfest")
    (version "2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BlockFeST" version))
       (sha256
        (base32
         "1fcl3yc1cf09znqbj787d3fd2kl5rp63la7pxawsgmap7nxwkp65"))))
    (properties `((upstream-name . "BlockFeST")))
    (build-system r-build-system)
    (propagated-inputs (list r-basix))
    (home-page "https://cran.r-project.org/web/packages/BlockFeST/")
    (synopsis "Bayesian calculation of region-specific fixation index")
    (description
     "This package provides an R implementation of an extension of the
BayeScan software for codominant markers, adding the option to group
individual SNPs into pre-defined blocks.  A typical application of this new
approach is the identification of genomic regions, genes, or gene sets
containing one or more SNPs that evolved under directional selection.")
    (license license:gpl2)))

(define-public r-proc
  (package
    (name "r-proc")
    (version "1.18.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pROC" version))
       (sha256
        (base32
         "129cnh3kh9sr42nc7n9f14kr9svi3501834x40njynnzlr0wi4sm"))))
    (properties `((upstream-name . "pROC")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://web.expasy.org/pROC/")
    (synopsis "Display and analyze ROC curves")
    (description
     "This package provides tools for visualizing, smoothing and comparing
receiver operating characteristic (ROC curves).  The area under the
curve (AUC) can be compared with statistical tests based on U-statistics or
bootstrap.  Confidence intervals can be computed for (p)AUC or ROC curves.")
    (license license:gpl3+)))

(define-public r-rootsolve
  (package
    (name "r-rootsolve")
    (version "1.8.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rootSolve" version))
       (sha256
        (base32
         "0p9qmn82bg0ks9hmh2dkygnzhxcnp5z8z8b8aq52w6clliz32sp1"))))
    (properties `((upstream-name . "rootSolve")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/rootSolve/")
    (synopsis "Tools for the analysis of ordinary differential equations")
    (description
     "This package provides routines to find the root of nonlinear functions,
and to perform steady-state and equilibrium analysis of @dfn{ordinary
differential equations} (ODE).  It includes routines that:

@enumerate
@item generate gradient and jacobian matrices (full and banded),
@item find roots of non-linear equations by the Newton-Raphson method,
@item estimate steady-state conditions of a system of (differential) equations
  in full, banded or sparse form, using the Newton-Raphson method, or by
  dynamically running,
@item solve the steady-state conditions for uni- and multicomponent 1-D, 2-D,
  and 3-D partial differential equations, that have been converted to ordinary
  differential equations by numerical differencing (using the method-of-lines
  approach).
@end enumerate\n")
    (license license:gpl2+)))

(define-public r-abcanalysis
  (package
    (name "r-abcanalysis")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABCanalysis" version))
       (sha256
        (base32 "0wac1ksmnxa36v99ca4hv8k0rsh3igwpcllmlv9wf7i9kgqviqwi"))))
    (properties `((upstream-name . "ABCanalysis")))
    (build-system r-build-system)
    (propagated-inputs (list r-plotrix))
    (home-page "https://www.uni-marburg.de/fb12/arbeitsgruppen/datenbionik/software-en/")
    (synopsis "Computed ABC Analysis")
    (description
     "Multivariate data sets often differ in several factors or derived statistical
parameters, which have to be selected for a valid interpretation.  Basing this
selection on traditional statistical limits leads occasionally to the perception
of losing information from a data set.  This package provides tools to calculate
these limits on the basis of the mathematical properties of the distribution of
the analyzed items.")
    (license license:gpl3)))

(define-public r-slam
  (package
    (name "r-slam")
    (version "0.1-55")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "slam" version))
       (sha256
        (base32 "00qwx6yrsqxa8kk2dn8i024a2cq1hcg9801k0rari9rb006lbf0g"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/slam/")
    (synopsis "Sparse lightweight arrays and matrices")
    (description
     "This package contains data structures and algorithms for sparse arrays and matrices,
based on index arrays and simple triplet representations, respectively.")
    (license license:gpl2)))

(define-public r-slanter
  (package
    (name "r-slanter")
    (version "0.2-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "slanter" version))
       (sha256
        (base32 "024dkman0r5qzc215gw0ds932vdaz8krrhv64fjw9pni37ixc3mf"))))
    (properties `((upstream-name . "slanter")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-pheatmap r-pracma))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=slanter")
    (synopsis "Slanted matrices and ordered clustering")
    (description
     "This is a package for slanted matrices and ordered clustering for better
visualization of similarity data.")
    (license license:expat)))

(define-public r-manipulatewidget
  (package
    (name "r-manipulatewidget")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "manipulateWidget" version))
       (sha256
        (base32 "1dpgzmiv08afm57yxr017b014lfn9h3pa4w65prk5k3dgn6p4wsv"))))
    (properties
     `((upstream-name . "manipulateWidget")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      '(modify-phases (@ (guix build r-build-system) %standard-phases)
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/lib/export"
               (for-each (match-lambda
                           ((source . target)
                            (minify source #:target target)))
                         `((,(assoc-ref inputs "js-html2canvas")
                            . "html2canvas/html2canvas.js")
                           (,(search-input-file inputs "FileSaver.js")
                            . "FileSaver/FileSaver.min.js")))))))))
    (propagated-inputs
     (list r-base64enc
           r-codetools
           r-htmltools
           r-htmlwidgets
           r-knitr
           r-miniui
           r-shiny
           r-shinyjs
           r-webshot))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("r-knitr" ,r-knitr)
       ("r-testthat" ,r-testthat)
       ;; inst/lib/export/html2canvas/html2canvas.js, version 1.0.0-rc.3
       ("js-html2canvas"
        ,(let ((version "1.0.0-rc.3"))
           (origin
             (method url-fetch)
             (uri (string-append
                   "https://github.com/niklasvh/html2canvas/"
                   "releases/download/v" version "/html2canvas.js"))
             (sha256
              (base32
               "0gxw8ihxkiwhh8hs8n7k1fsim7gq7v31h89fc9k2dw3namg7m2qp")))))
       ;; inst/lib/export/FileSaver/FileSaver.min.js
       ("js-filesaver"
        ,(let ((version "1.2.0"))
           (origin
             (method git-fetch)
             (uri (git-reference
                   (url "https://github.com/eligrey/FileSaver.js")
                   (commit version)))
             (file-name (git-file-name "js-filesaver" version))
             (sha256
              (base32
               "07mw01056fk36pganhs27y8rl5y5hrdsm945pwbbvmdjnzq4ijny")))))))
    (home-page "https://github.com/rte-antares-rpackage/manipulateWidget/")
    (synopsis "Add even more interactivity to interactive charts")
    (description
     "This package lets you create in just a few lines of R code a nice user interface to
modify the data or the graphical parameters of one or multiple interactive
charts.  It is useful to quickly explore visually some data or for package
developers to generate user interfaces easy to maintain.")
    (license license:gpl2+)))

(define-public r-a3
  (package
    (name "r-a3")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "A3" version))
       (sha256
        (base32 "017hq9pjsv1h9i7cqk5cfx27as54shlhdsdvr6jkhb8jfkpdb6cw"))))
    (properties `((upstream-name . "A3")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-pbapply r-xtable))
    (home-page "https://cran.r-project.org/web/packages/A3/")
    (synopsis "Error metrics for predictive models")
    (description
     "This package supplies tools for tabulating and analyzing the results of predictive
models.  The methods employed are applicable to virtually any predictive model
and make comparisons between different methodologies straightforward.")
    (license license:gpl2+)))

(define-public r-infotheo
  (package
    (name "r-infotheo")
    (version "1.2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "infotheo" version))
       (sha256
        (base32
         "1m1979vf8rvq3534mp1hihfadikhxrg3p6ac3hirz96kgb4qxyy0"))))
    (build-system r-build-system)
    (home-page "http://homepage.meyerp.com/software")
    (synopsis "Information-theoretic measures")
    (description
     "This package implements various measures of information theory based on
several entropy estimators.")
    (license license:gpl3+)))

(define-public r-nsprcomp
  (package
    (name "r-nsprcomp")
    (version "0.5.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nsprcomp" version))
       (sha256
        (base32
         "1zlc1ximx96f235c0l8qfs6vbp1kpnbf943wxsfahnnlnxvwi59f"))))
    (properties `((upstream-name . "nsprcomp")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://sigg-iten.ch/research/")
    (synopsis "Non-negative and sparse PCA")
    (description
     "This package implements two methods for performing a constrained
principal component analysis (PCA), where non-negativity and/or sparsity
constraints are enforced on the principal axes (PAs).  The function
@code{nsprcomp} computes one principal component (PC) after the other.  Each
PA is optimized such that the corresponding PC has maximum additional variance
not explained by the previous components.  In contrast, the function
@code{nscumcomp} jointly computes all PCs such that the cumulative variance is
maximal.  Both functions have the same interface as the @code{prcomp} function
from the @code{stats} package (plus some extra parameters).")
    (license license:gpl2+)))

(define-public r-cmplot
  (package
    (name "r-cmplot")
    (version "4.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CMplot" version))
       (sha256
        (base32
         "0ml6n1wjxrnq13042jihpjlmm6vmkaiks9n49qp7v7rg47gn2ik8"))))
    (properties `((upstream-name . "CMplot")))
    (build-system r-build-system)
    (home-page "https://github.com/YinLiLin/CMplot")
    (synopsis "Circle Manhattan plot")
    (description
     "Circle Manhattan Plot is an R package that can lay out genome-wide
association study P-value results in both traditional rectangular patterns,
QQ-plot and novel circular ones.  United in only one bull's eye style plot,
association results from multiple traits can be compared interactively,
thereby to reveal both similarities and differences between signals.
Additional functions include: highlight signals, a group of SNPs, chromosome
visualization and candidate genes around SNPs.")
    (license license:gpl2+)))

(define-public r-precrec
  (package
    (name "r-precrec")
    (version "0.14.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "precrec" version))
       (sha256
        (base32
         "03hvp5h7fz4v2aswxim0mqgj9rdrhnk5xqz212161kpcrw6m67z8"))))
    (properties `((upstream-name . "precrec")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-data-table
           r-ggplot2
           r-gridextra
           r-rcpp
           r-rlang
           r-withr))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://evalclass.github.io/precrec/")
    (synopsis "Calculate accurate precision-recall and ROC curves")
    (description
     "This package provides tools for accurate calculations and visualization
of precision-recall and ROC (Receiver Operator Characteristics) curves.")
    (license license:gpl3)))

(define-public r-netrep
  (package
    (name "r-netrep")
    (version "1.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NetRep" version))
       (sha256
        (base32
         "02ss45giv30pi31b5rysa36bn5c4fs5x58g4vb0arz9cnicznv97"))))
    (properties `((upstream-name . "NetRep")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-bh
           r-foreach
           r-rcolorbrewer
           r-rcpp
           r-rcpparmadillo
           r-rhpcblasctl
           r-statmod))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=NetRep")
    (synopsis "Permutation testing network module preservation across datasets")
    (description
     "This package provides functions for assessing the
replication/preservation of a network module's topology across datasets
through permutation testing.")
    (license license:gpl2)))

(define-public r-intergraph
  (package
    (name "r-intergraph")
    (version "2.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "intergraph" version))
       (sha256
        (base32
         "1jarzhrgm5g8z2h10h8x7jk9q2al6rx5kgnwvwi2199am6gjypsq"))))
    (properties `((upstream-name . "intergraph")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-network))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://mbojan.github.io/intergraph")
    (synopsis "Coercion routines for network data objects")
    (description
     "Functions implemented in this package allow coercing (i.e. convert)
network data between classes provided by other R packages.  Currently
supported classes are those defined in packages @code{network} and
@code{igraph}.")
    (license license:gpl3)))

(define-public r-interp
  (package
    (name "r-interp")
    (version "1.1-6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "interp" version))
              (sha256
               (base32
                "0d6ddvm94113d9bjhghjsfbhgz44q0lkjc2l809dzv1lad708x1n"))))
    (properties `((upstream-name . "interp")))
    (build-system r-build-system)
    (propagated-inputs (list r-deldir r-rcpp r-rcppeigen))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=interp")
    (synopsis "Interpolation methods")
    (description
     "Bivariate data interpolation on regular and irregular grids, either
linear or using splines are the main part of this package.  It is intended to
provide replacement functions for the ACM licensed @code{akima::interp} and
@code{tripack::tri.mesh} functions.")
    (license license:gpl2+)))

(define-public r-abcoptim
  (package
    (name "r-abcoptim")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABCoptim" version))
       (sha256
        (base32 "1ih0xk88qhsmpvnxf56041wx5sk8as2f4f2gdnpnwdym9mbr9n4b"))))
    (properties `((upstream-name . "ABCoptim")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/gvegayon/ABCoptim/")
    (synopsis "Optimization of Artificial Bee Colony algorithm")
    (description
     "Artificial Bee Colony (ABC) is one of the most recently defined algorithms by Dervis
Karaboga in 2005, motivated by the intelligent behavior of honey bees.  It is as
simple as Particle Swarm Optimization (PSO) and Differential Evolution (DE)
algorithms, and uses only common control parameters such as colony size and
maximum cycle number.  The @code{r-abcoptim} implements the Artificial bee
colony optimization algorithm @url{http://mf.erciyes.edu.tr/abc/pub/tr06_2005.pdf}.
  This version is a work-in-progress and is written in R code.")
    (license license:expat)))

(define-public r-abcp2
  (package
    (name "r-abcp2")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABCp2" version))
       (sha256
        (base32 "1s2skkxpzss7c29i8600psgrp0hl46jcrxqrmy2b4db8hc0kcnbx"))))
    (properties `((upstream-name . "ABCp2")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/ABCp2/")
    (synopsis "Approximate Bayesian Computational Model for Estimating P2")
    (description
     "This package tests the goodness of fit of a distribution of offspring to the Normal,
Poisson, and Gamma distribution and estimates the proportional paternity of the
second male (P2) based on the best fit distribution.")
    (license license:gpl2)))

(define-public r-abcrf
  (package
    (name "r-abcrf")
    (version "1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abcrf" version))
       (sha256
        (base32 "08mh1a6gxp0mfx6qnp1qzcrfx7xp64qj9kad4ziyswfx22ykdsxi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-doparallel
           r-foreach
           r-mass
           r-matrixstats
           r-ranger
           r-rcpp
           r-rcpparmadillo
           r-readr
           r-stringr))
    (home-page "https://cran.r-project.org/web/packages/abcrf/")
    (synopsis "Approximate bayesian computation via random forests")
    (description
     "This package performs approximate bayesian computation (ABC) model choice and
parameter inference via random forests.  This machine learning tool named random
forests (RF) can conduct selection among the highly complex models covered by
ABC algorithms.")
    (license license:gpl2+)))

(define-public r-abctools
  (package
    (name "r-abctools")
    (version "1.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abctools" version))
       (sha256
        (base32 "16gn5hk25glbjml7bclxqkybi90gqjijz6hl6ak8aig5wm08pgx2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abc r-abind r-hmisc r-plyr))
    (home-page "https://github.com/dennisprangle/abctools/")
    (synopsis "Tools for ABC analyses")
    (description
     "This @code{r-abctools} package provides tools for approximate Bayesian computation
including summary statistic selection and assessing coverage.  This includes
recent dimension reduction algorithms to tune the choice of summary statistics,
and coverage methods to tune the choice of threshold.")
    (license license:gpl2+)))

(define-public r-ggstance
  (package
    (name "r-ggstance")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggstance" version))
       (sha256
        (base32 "0v25si348qdp68887yx4d652rsz8w5lfabwaq1nvglrhs6s4f9js"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli r-ggplot2 r-plyr r-rlang r-withr))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/ggstance/")
    (synopsis "Horizontal and vertical versions of @code{r-ggplot2}")
    (description
     "This package is a @code{r-ggplot2} extension that provides flipped components:
@enumerate
@item horizontal versions of @code{r-ggplot2} stats and @code{r-ggplot2} geoms;
@item vertical versions of @code{r-ggplot2} positions.
@end enumerate")
    (license license:gpl3)))

(define-public r-ggnetwork
  (package
    (name "r-ggnetwork")
    (version "0.5.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggnetwork" version))
       (sha256
        (base32
         "0ipxw6j36n0hfn0nsimw8jbjszvm1d0hadwg4zirvn6v36npwabc"))))
    (properties `((upstream-name . "ggnetwork")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-ggrepel r-igraph r-network r-sna))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/briatte/ggnetwork")
    (synopsis "Geometries to plot networks with ggplot2")
    (description
     "This package provides geometries to plot network objects with the
ggplot2 package.")
    (license license:gpl3)))

(define-public r-cvauc
  (package
    (name "r-cvauc")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cvAUC" version))
       (sha256
        (base32
         "1m2y50a1yapf1c74km9a4r47ds2z2bfp4wwwkqin7swv9v1s7d28"))))
    (properties `((upstream-name . "cvAUC")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table r-rocr))
    (home-page "https://github.com/ledell/cvAUC")
    (synopsis "Cross-validated area under the ROC curve confidence intervals")
    (description
     "This package contains various tools for working with and evaluating
cross-validated area under the ROC curve (AUC) estimators.  The primary
functions of the package are @code{ci.cvAUC} and @code{ci.pooled.cvAUC}, which
report cross-validated AUC and compute confidence intervals for
cross-validated AUC estimates based on influence curves for i.i.d. and pooled
repeated measures data, respectively.")
    (license license:asl2.0)))

(define-public r-gam
  (package
    (name "r-gam")
    (version "1.22-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gam" version))
       (sha256
        (base32
         "0mg9h8hm76wz8fbppfirgmqm1x70n3q13mmy8wdpi0h9bq0a2cvx"))))
    (properties `((upstream-name . "gam")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach))
    (native-inputs
     (list gfortran r-testthat))
    (home-page "https://cran.r-project.org/package=gam")
    (synopsis "Generalized additive models")
    (description
     "This package provides functions for fitting and working with generalized
additive models, as described in chapter 7 of \"Statistical Models in
S\" (Chambers and Hastie (eds), 1991), and \"Generalized Additive
Models\" (Hastie and Tibshirani, 1990).")
    (license license:gpl2)))

(define-public r-superlearner
  (package
    (name "r-superlearner")
    (version "2.0-29")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SuperLearner" version))
       (sha256
        (base32
         "0g1baz8jakgfwdh5bd9hrg1nm4ljpnxiiy5pmf00d27ld7wh6sr3"))))
    (properties `((upstream-name . "SuperLearner")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cvauc r-gam r-nnls))
    (native-inputs
     (list r-knitr r-rmarkdown r-testthat))
    (home-page "https://github.com/ecpolley/SuperLearner")
    (synopsis "Super learner prediction")
    (description
     "This package implements the super learner prediction method and contains
a library of prediction algorithms to be used in the super learner.")
    (license license:gpl3)))

(define-public r-drtmle
  (package
    (name "r-drtmle")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "drtmle" version))
       (sha256
        (base32
         "0qvdxzvpi7a66gx61v6fj31zy4y5cid18g4qgv5lir7qc74rbbx0"))))
    (properties `((upstream-name . "drtmle")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-future-apply r-np r-superlearner))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/benkeser/drtmle")
    (synopsis "Doubly-robust nonparametric estimation and inference")
    (description
     "This package implements targeted minimum loss-based estimators of
counterfactual means and causal effects that are doubly-robust with respect
both to consistency and asymptotic normality.")
    (license license:expat)))

(define-public r-dofuture
  (package
    (name "r-dofuture")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doFuture" version))
       (sha256
        (base32
         "1avv5kv1c43gmvbh5iwxlwk7yl6prndpcgy0blkwarl3nsgcq4cm"))))
    (properties `((upstream-name . "doFuture")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-foreach r-future r-future-apply r-globals r-iterators))
    (native-inputs
     (list r-markdown                   ;check phase requires markdown package
           r-r-rsp))                    ;vignette builder
    (home-page "https://github.com/HenrikBengtsson/doFuture")
    (synopsis "Foreach parallel adapter using the future API")
    (description
     "This package provides a @code{%dopar%} adapter such that any type of
futures can be used as backends for the @code{foreach} framework.")
    (license license:lgpl2.1+)))

(define-public r-superheat
  (package
    (name "r-superheat")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "superheat" version))
       (sha256
        (base32
         "01v8s6px1k5fajlm6py3ksr1i853kwwlky1yryzhy3p1cxhwgg83"))))
    (properties `((upstream-name . "superheat")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-ggdendro
           r-ggplot2
           r-gtable
           r-magrittr
           r-plyr
           r-scales))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=superheat")
    (synopsis "Graphical tool for exploring complex datasets using heatmaps")
    (description
     "This package provides a system for generating extendable and
customizable heatmaps for exploring complex datasets, including big data and
data with multiple data types.")
    (license license:cc0)))

(define-public r-qualv
  (package
    (name "r-qualv")
    (version "0.3-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qualV" version))
       (sha256
        (base32
         "09qqfx94f46x585iipr9wii8ji6ih31xymbw4p5v3qixmfpja276"))))
    (properties `((upstream-name . "qualV")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernsmooth))
    (home-page "https://qualV.R-Forge.R-Project.org/")
    (synopsis "Qualitative Validation Methods")
    (description
     "This package provides qualitative methods for the validation of dynamic
models.  It contains

@enumerate
@item an orthogonal set of deviance measures for absolute, relative and
  ordinal scale and
@item approaches accounting for time shifts.
@end enumerate

The first approach transforms time to take time delays and speed differences
into account.  The second divides the time series into interval units
according to their main features and finds the @dfn{longest common
subsequence} (LCS) using a dynamic programming algorithm.")
    (license license:gpl2+)))

(define-public r-mosaiccore
  (package
    (name "r-mosaiccore")
    (version "0.9.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mosaicCore" version))
       (sha256
        (base32 "0v3xhv6yfk1hc6a40jjgp6vvq102qa1l4n787pfywx6jhzbhamp2"))))
    (properties `((upstream-name . "mosaicCore")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; Two tests fail with accuracy problems.
             (delete-file "tests/testthat/test-interval-calculations.R"))))))
    (propagated-inputs
     (list r-dplyr r-mass r-rlang r-tidyr))
    (native-inputs (list r-mosaicdata r-testthat))
    (home-page "https://github.com/ProjectMOSAIC/mosaicCore/")
    (synopsis "Common utilities for mosaic family packages")
    (description
     "Common utilities used in other Mosaic family packages are collected here.")
    (license license:gpl2+)))

(define-public r-labelled
  (package
    (name "r-labelled")
    (version "2.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "labelled" version))
       (sha256
        (base32
         "0dx2zwympwlys8ndyfz2qki3xywz7sqxfkbd8y52zdj34fj84bly"))))
    (properties `((upstream-name . "labelled")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-haven
           r-lifecycle
           r-rlang
           r-stringr
           r-tidyr
           r-tidyselect
           r-vctrs))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://larmarange.github.io/labelled/")
    (synopsis "Manipulating labelled data")
    (description
     "This package provides useful functions to deal with the
@code{haven_labelled} and @code{haven_labelled_spss} classes introduced by the
haven package.")
    (license license:gpl3)))

(define-public r-ggformula
  (package
    (name "r-ggformula")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggformula" version))
       (sha256
        (base32 "0vbpivyxms46px3wqkbl1wq199mqdxq94gsiplv4i7lz0lzghsfm"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; This file requires r-mosaic, which we can't add because of a
             ;; dependency cycle.
             (delete-file "tests/testthat/test-layer-factory.R"))))))
    (propagated-inputs
     (list r-ggplot2
           r-ggridges
           r-labelled
           r-mosaiccore
           r-rlang
           r-scales
           r-stringr
           r-tibble))
    (native-inputs
     (list r-knitr r-palmerpenguins r-testthat))
    (home-page "https://github.com/ProjectMOSAIC/ggformula/")
    (synopsis "Formula interface for the @code{r-ggplot2}")
    (description
     "The @code{r-ggformula} introduces a family of graphics functions, gf_point(),
gf_density(), and so on, bring the formula interface to ggplot().  This captures
and extends the excellent simplicity of the lattice-graphics formula interface,
while providing the intuitive capabilities of @code{r-ggplot2}.")
    (license license:expat)))

(define-public r-mosaicdata
  (package
    (name "r-mosaicdata")
    (version "0.20.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mosaicData" version))
       (sha256
        (base32 "0y6ii234paknak0p8cm5wcjia4s4wh7iixjbbvdgp0w17c05dckh"))))
    (properties `((upstream-name . "mosaicData")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/mosaicData/")
    (synopsis "Data sets for project Mosaic")
    (description
     "This package provides data sets from project Mosaic @url{http://mosaic-web.org}
used to teach mathematics, statistics, computation and modeling.")
    (license license:gpl2+)))

(define-public r-raster
  (package
    (name "r-raster")
    (version "3.6-30")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "raster" version))
       (sha256
        (base32
         "0w1h9a2151njdlnlg617bcfva558cac739czphwjdc6na9566zxv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-sp r-terra))
    (home-page "https://www.rspatial.org/")
    (synopsis "Geographic data analysis and modeling")
    (description
     "The package implements basic and high-level functions for reading,
writing, manipulating, analyzing and modeling of gridded spatial data.
Processing of very large files is supported.")
    (license license:gpl3+)))

(define-public r-mosaic
  (package
    (name "r-mosaic")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mosaic" version))
       (sha256
        (base32 "0l7h3zg5izr5xxqy1sngz6fzbwdffzljnjmfbshzzbl4x80f5lwl"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; This file contains tests that attempt to download data files
             ;; off the internet.
             (delete-file "tests/testthat/test-read.file.R")
             ;; Unknown failure.
             (delete-file "tests/testthat/test-ladd.R"))))))
    (propagated-inputs
     (list r-dplyr
           r-ggformula
           r-ggplot2
           r-lattice
           r-mass
           r-matrix
           r-mosaiccore
           r-mosaicdata
           r-purrr
           r-rlang
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-broom r-ggdendro r-ggrepel r-knitr r-latticeextra r-testthat))
    (home-page "https://github.com/ProjectMOSAIC/mosaic/")
    (synopsis "Mathematics, statistics, and computation teaching utilities")
    (description
     "This package contain data sets and utilities from
@url{http://mosaic-web.org, Project MOSAIC} used to teach mathematics,
statistics, computation and modeling.  Project MOSAIC is a community of
educators working to tie together aspects of quantitative work that students
in science, technology, engineering and mathematics will need in their
professional lives, but which are usually taught in isolation, if at all.")
    (license license:gpl2+)))

(define-public r-abd
  (package
    (name "r-abd")
    (version "0.2-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abd" version))
       (sha256
        (base32 "191gspqzdv573vaw624ri0f5cm6v4j524bjs74d4a1hn3kn6r9b7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice r-mosaic r-nlme))
    (home-page "https://cran.r-project.org/web/packages/abd/")
    (synopsis "Analysis of biological data")
    (description
     "The @code{r-abd} package contains data sets and sample code for the Analysis of
biological data by Michael Whitlock and Dolph Schluter.")
    (license license:gpl2)))

(define-public r-svgui
  (package
    (name "r-svgui")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svGUI" version))
       (sha256
        (base32 "0ch5gdfk834xj9w3vxpm3x4770fz3nnlyn8b0jsw9f3n2as7g979"))))
    (properties `((upstream-name . "svGUI")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/SciViews/svGUI/")
    (synopsis "Functions for managing GUI clients in R")
    (description
     "The SciViews @code{svGUI} package eases the management of Graphical User
Interfaces (GUI) in R.  It is independent from any particular GUI widgets.  It
centralizes info about GUI elements currently used, and it dispatches GUI
calls to the particular toolkits in use in function of the context.")
    (license license:gpl2)))

(define-public r-svdialogs
  (package
    (name "r-svdialogs")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svDialogs" version))
       (sha256
        (base32 "0z3a5glsi0ab43mdk2yvslxyzg12nbqqqc35jvgzj475mpkbgjif"))))
    (properties `((upstream-name . "svDialogs")))
    (build-system r-build-system)
    (inputs
     (list yad zenity))
    (propagated-inputs
     (list r-rstudioapi r-svgui))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/SciViews/svDialogs/")
    (synopsis "Portable dialog boxes")
    (description
     "This package helps to construct standard dialog boxes for your GUI, including
message boxes, input boxes, list, file or directory selection, and others.  In
case R cannot display GUI dialog boxes, a simpler command line version of these
interactive elements is also provided as a fallback solution.")
    (license license:gpl2)))

(define-public r-svunit
  (package
    (name "r-svunit")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svUnit" version))
       (sha256
        (base32 "08nmlbdrmmz04ira30721l99i74w07w2avdr4pypswf2sq1nqgi6"))))
    (properties `((upstream-name . "svUnit")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://github.com/SciViews/svUnit")
    (synopsis "Unit, integration and system testing")
    (description
     "This package provides a complete unit test system and functions to
implement its GUI part.")
    (license license:gpl2)))

(define-public r-abe
  (package
    (name "r-abe")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abe" version))
       (sha256
        (base32
         "1f19h3xzzmjhvwc1rrb8z0rai3ip03y4gdi2gg9bfr5sg2nfklk6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abe/")
    (synopsis "Augmented backward elimination")
    (description
     "This package performs augmented backward elimination and checks the
stability of the obtained model.  Augmented backward elimination combines
significance or information based criteria with the change in estimate to
either select the optimal model for prediction purposes or to serve as a tool
to obtain a practically sound, highly interpretable model.")
    (license license:gpl2+)))

(define-public r-abf2
  (package
    (name "r-abf2")
    (version "0.7-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abf2" version))
       (sha256
        (base32 "0d65mc1w4pbiv7xaqzdlw1bfsxf25587rv597hh41vs0j0zlfpxx"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abf2/")
    (synopsis "Load gap-free axon @code{r-abf2} files")
    (description
     "This package loads electrophysiology data from ABF2 files, as created by
Axon Instruments/Molecular Devices software.  Only files recorded in gap-free
mode are currently supported.")
    (license license:artistic2.0)))

(define-public r-abhgenotyper
  (package
    (name "r-abhgenotyper")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABHgenotypeR" version))
       (sha256
        (base32 "08cpmnaaxsm5c5bjifnfxdlvg5inrf13biqpcl2yq5zpqjmiki0l"))))
    (properties `((upstream-name . "ABHgenotypeR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-reshape2))
    (home-page "https://github.com/StefanReuscher/ABHgenotypeR/")
    (synopsis "Visualize and manipulate ABH genotypes")
    (description
     "The @code{r-abhgenotyper} package provides simple imputation,
error-correction and plotting capacities for genotype data.  The package is
supposed to serve as an intermediate but independent analysis tool between the
TASSEL GBS pipeline and the @code{r-qtl} package.  It provides functionalities
not found in either TASSEL or @code{r-qtl} in addition to visualization of
genotypes as \"graphical genotypes\".")
    (license license:gpl3)))

(define-public r-furrr
  (package
    (name "r-furrr")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "furrr" version))
       (sha256
        (base32
         "12z4q0fn7asxis17hisi82bvfabl5if1338lmfqmkrwv5rg7748d"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-future
           r-globals
           r-lifecycle
           r-purrr
           r-rlang
           r-vctrs))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/DavisVaughan/furrr")
    (synopsis "Apply mapping functions in parallel using futures")
    (description
     "This package provides implementations of the family of @code{map()}
functions from the @code{purrr} package that can be resolved using any
@code{future}-supported backend, e.g. parallel on the local machine or
distributed on a compute cluster.")
    (license license:lgpl2.1+)))

(define-public r-abjutils
  (package
    (name "r-abjutils")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abjutils" version))
       (sha256
        (base32 "0lmf4va8qnzwg698i2h4fcwvd6dhsgdkqsfh41aa3wg1flimhsr7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-magrittr
           r-purrr
           r-rlang
           r-rstudioapi
           r-stringi
           r-stringr
           r-tidyr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/abjur/abjutils/")
    (synopsis "Collection of tools for jurimetrical analysis")
    (description
     "This package implements general purpose tools, such as functions for
sampling and basic manipulation of Brazilian lawsuits identification number.
It also implements functions for text cleaning, such as accentuation
removal.")
    (license license:expat)))

(define-public r-abnormality
  (package
    (name "r-abnormality")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abnormality" version))
       (sha256
        (base32 "1fzfskl9akl06nliy8hkv2a0pznpj8pwcypg3gj5r2nzvr3kan9v"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-matrix))
    (home-page "https://cran.r-project.org/web/packages/abnormality/")
    (synopsis "Measure a subject's abnormality with respect to a reference population")
    (description
     "This package contains functions to implement the methodology and
considerations laid out by Marks et al. in the article \"Measuring abnormality
in high dimensional spaces: applications in biomechanical gait analysis\".
Using high-dimensional datasets to measure a subject's overall level of
abnormality as compared to a reference population is often needed in outcomes
research.")
    (license license:expat)))

(define-public r-abodoutlier
  (package
    (name "r-abodoutlier")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abodOutlier" version))
       (sha256
        (base32 "1pvhgxmh23br84r0fbmv7g53z2427birdja96a67vqgz18r3fdvj"))))
    (properties `((upstream-name . "abodOutlier")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cluster))
    (home-page "https://cran.r-project.org/web/packages/abodOutlier/")
    (synopsis "Angle-based outlier detection")
    (description
     "This package performs angle-based outlier detection on a given data
frame.  It offers three methods to process data:
@enumerate
@item full but slow implementation using all the data that has cubic
  complexity;
@item a fully randomized method;
@item a method using k-nearest neighbours.
@end enumerate
These algorithms are well suited for high dimensional data outlier
detection.")
    (license license:expat)))

(define-public r-abps
  (package
    (name "r-abps")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABPS" version))
       (sha256
        (base32 "0n3f66nmfi5v94il1mxy026mi84w01ph2aljk60vn3mrz8kwf2ll"))))
    (properties `((upstream-name . "ABPS")))
    (build-system r-build-system)
    (propagated-inputs (list r-kernlab))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/ABPS/")
    (synopsis "Abnormal blood profile score to detect blood doping")
    (description
     "This package offers an implementation of the @dfn{Abnormal blood profile score} (ABPS).
The ABPS is a part of the Athlete biological passport program of the World
anti-doping agency, which combines several blood parameters into a single
score in order to detect blood doping.  The package also contains functions to
calculate other scores used in anti-doping programs, such as the ratio of
hemoglobin to reticulocytes (OFF-score), as well as example data.")
    (license license:gpl2+)))

(define-public r-parmigene
  (package
    (name "r-parmigene")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parmigene" version))
       (sha256
        (base32
         "03n93x8qsc4cl5a3d2z3q56rm2zs7xnpn9iqli25g3plv69hp0kk"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/parmigene/")
    (synopsis "Mutual information estimation for gene network reconstruction")
    (description
     "This package provides a parallel estimation of the mutual information
based on entropy estimates from k-nearest neighbors distances and algorithms
for the reconstruction of gene regulatory networks.")
    (license license:agpl3+)))

(define-public r-partr2
  (package
    (name "r-partr2")
    (version "0.9.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "partR2" version))
              (sha256
               (base32
                "09x8ykg90y4xq0sqm6zvx41sccgdbglmhpqm9sp3m74a87j4bjly"))))
    (properties `((upstream-name . "partR2")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-ggplot2
                             r-lme4
                             r-magrittr
                             r-pbapply
                             r-purrr
                             r-rlang
                             r-tibble
                             r-tidyr))
    (native-inputs (list r-furrr r-future r-knitr r-testthat))
    (home-page "https://github.com/mastoffel/partR2")
    (synopsis "Partitioning R2 in generalized linear mixed models")
    (description
     "This package provides an R tool for estimating and partitioning R2 in
@dfn{generalized linear mixed models} (GLMMs) based on predictor variance.")
    (license license:gpl2+)))

(define-public r-pscl
  (package
    (name "r-pscl")
    (version "1.5.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pscl" version))
       (sha256
        (base32 "1zkfzrc1cr3f5dlz0mv45ym0as1yp9gicds6lhxpj13qk38zz1c0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://github.com/atahk/pscl/")
    (synopsis "Political science computational laboratory")
    (description
     "The @code{pscl} is an R package providing classes and methods for:
@enumerate
@item Bayesian analysis of roll call data (item-response models);
@item elementary Bayesian statistics;
@item maximum likelihood estimation of zero-inflated and hurdle models for count
data;
@item utility functions.
@end enumerate")
    (license license:gpl2)))

(define-public r-accelmissing
  (package
    (name "r-accelmissing")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "accelmissing" version))
       (sha256
        (base32 "1nql9inx6azdzi3z4sfm2vdml2mms6krl8wzlf1dn1c97ahn57fy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mice r-pscl))
    (home-page "https://cran.r-project.org/web/packages/accelmissing/")
    (synopsis "Missing value imputation for accelerometer data")
    (description
     "This package provides a statistical method to impute the missing values in
accelerometer data.  The methodology includes both parametric and
semi-parametric multiple imputations under the zero-inflated Poisson lognormal
model.  It also provides multiple functions to preprocess the accelerometer data
previous to the missing data imputation.  These include detecting the wearing
and the non-wearing time, selecting valid days and subjects, and creating plots.")
    (license license:gpl2+)))

(define-public r-mhsmm
  (package
    (name "r-mhsmm")
    (version "0.4.21")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mhsmm" version))
       (sha256
        (base32 "1fibgpl65bl3rwlf9dhlams3gxbjqgwcd26gb0flp4wln6pl8d99"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mvtnorm))
    (home-page "https://github.com/jaredo/mhsmm/")
    (synopsis "Inference for hidden Markov and semi-Markov models")
    (description
     "The @code{r-mhsmm} package implements estimation and prediction methods for
hidden Markov and semi-Markov models for multiple observation sequences.  Such
techniques are of interest when observed data is thought to be dependent on some
unobserved (or hidden) state.  Also, this package is suitable for equidistant
time series data, with multivariate and/or missing data.  Allows user defined
emission distributions.")
    (license license:gpl2+)))

(define-public r-nleqslv
  (package
    (name "r-nleqslv")
    (version "3.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nleqslv" version))
       (sha256
        (base32 "0fjby0qva2lp2i7x752wva0z15xqys9fgrrcfimqszg65wnig60j"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/nleqslv/")
    (synopsis "Solve systems of nonlinear equations")
    (description
     "The @code{r-nleqslv} package solves a system of nonlinear equations using a
Broyden or a Newton method with a choice of global strategies such as line
search and trust region.  There are options for using a numerical or user
supplied Jacobian, for specifying a banded numerical Jacobian and for allowing a
singular or ill-conditioned Jacobian.")
    (license license:gpl2+)))

(define-public r-phyclust
  (package
    (name "r-phyclust")
    (version "0.1-34")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "phyclust" version))
              (sha256
               (base32
                "1wzmd02ng7zphn97xdra3hgivrxqpizqcy5kpg45sk7jx4q7016j"))))
    (properties `((upstream-name . "phyclust")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape))
    (home-page "https://snoweye.github.io/phyclust/")
    (synopsis "Studying phyloclustering and exploring DNA sequence data")
    (description
     "@dfn{Phylogenetic clustering} (phyloclustering) is an evolutionary continuous
time Markov Chain model-based approach to identify population structure from
molecular data without assuming linkage equilibrium.  The package @code{phyclust}
provides a convenient implementation of phyloclustering for DNA and SNP data,
capable of clustering individuals into subpopulations and identifying molecular
sequences representative of those subpopulations.  It is designed in @code{C} for
performance and interfaced with @code{R} for visualization.")
    (license license:gpl2+)))

(define-public r-physicalactivity
  (package
    (name "r-physicalactivity")
    (version "0.2-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PhysicalActivity" version))
       (sha256
        (base32 "0b27prkv3x6v2afz0y53ccs9scibpc7nj54n0hpd9fgn1wyg4c40"))))
    (properties
     `((upstream-name . "PhysicalActivity")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/PhysicalActivity/")
    (synopsis "Processing accelerometer data for physical activity measurement")
    (description
     "This @code{r-physicalactivity} package provides a function @code{wearingMarking}
for classification of monitored wear and nonwear time intervals in accelerometer
data collected to assess physical activity.  The package also contains functions
for making plots of accelerometer data and obtaining the summary of various
information including daily monitor wear time and the mean monitor wear time
during valid days.  The revised package version 0.2-1 improved the functions
regarding speed, robustness and add better support for time zones and daylight
saving.  In addition, several functions were added:
@enumerate
@item the @code{markDelivery} can classify days for ActiGraph delivery by mail;
@item the @code{markPAI} can categorize physical activity intensity level based
on user-defined cut-points of accelerometer counts.
@end enumerate
  It also supports importing ActiGraph (AGD) files with @code{readActigraph} and
@code{queryActigraph} functions.")
    (license license:gpl3+)))

(define-public r-acc
  (package
    (name "r-acc")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acc" version))
       (sha256
        (base32 "1ii2vm47djxbixa75h690q1s2f9m9x6i8nkygik93j6dayr6kr1m"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-circlize
           r-dbi
           r-ggplot2
           r-iterators
           r-mhsmm
           r-nleqslv
           r-physicalactivity
           r-plyr
           r-r-utils
           r-rcpp
           r-rcpparmadillo
           r-rsqlite
           r-zoo))
    (home-page "https://cran.r-project.org/web/packages/acc/")
    (synopsis "Exploring accelerometer data")
    (description
     "This package processes accelerometer data from uni-axial and tri-axial devices
and generates data summaries.  Also, includes functions to plot, analyze, and
simulate accelerometer data.")
    (license license:gpl2+)))

(define-public r-rbenchmark
  (package
    (name "r-rbenchmark")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rbenchmark" version))
       (sha256
        (base32 "010fn3qwnk2k411cbqyvra1d12c3bhhl3spzm8kxffmirj4p2al9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rbenchmark/")
    (synopsis "Benchmarking routine for R")
    (description
     "This @code{r-rbenchmark} package is inspired by the Perl module Benchmark,
and is intended to facilitate benchmarking of arbitrary R code.  The library
consists of just one function, benchmark, which is a simple wrapper around
system.time.  Given a specification of the benchmarking process (counts of
replications, evaluation environment) and an arbitrary number of expressions,
benchmark evaluates each of the expressions in the specified environment,
replicating the evaluation as many times as specified, and returning the results
conveniently wrapped into a data frame.")
    (license license:gpl2+)))

(define-public r-mitools
  (package
    (name "r-mitools")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mitools" version))
       (sha256
        (base32
         "0c2x2n1p53lcw0vx4vmy5j7m2f95i7g2iwbryl89imr99rvz617j"))))
    (build-system r-build-system)
    (propagated-inputs (list r-dbi))
    (home-page "https://cran.r-project.org/web/packages/mitools/")
    (synopsis "Tools for multiple imputation of missing data")
    (description
     "This package provides tools to perform analyses and combine results from
multiple-imputation datasets.")
    (license license:gpl2)))

(define-public r-mixsqp
  (package
   (name "r-mixsqp")
   (version "0.3-54")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "mixsqp" version))
            (sha256
             (base32
              "13pv3mmz514kl4svxqwyk5b241dy1q52khwdc6rmh712ia8xxl7p"))))
   (properties `((upstream-name . "mixsqp")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-irlba r-rcpp r-rcpparmadillo))
   (native-inputs
    (list r-knitr r-testthat))
   (home-page "https://github.com/stephenslab/mixsqp")
   (synopsis
    "Sequential quadratic programming for maximum-likelihood estimation")
   (description
    "This package provides an optimization method based on sequential
quadratic programming for maximum likelihood estimation of the mixture
proportions in a finite mixture model where the component densities are
known.  The algorithm is expected to obtain solutions that are at least
as accurate as the state-of-the-art MOSEK interior-point solver, and they
are expected to arrive at solutions more quickly when the number of
samples is large and the number of mixture components is not too large.")
   (license license:expat)))

(define-public r-magick
  (package
    (name "r-magick")
    (version "2.8.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "magick" version))
       (sha256
        (base32
         "0nhwl46lvsgxhnw6cq71sx5rpa1g693fdw88hbqr8msi2qy91vga"))))
    (properties
     '((updater-extra-inputs . ("imagemagick"))))
    (build-system r-build-system)
    (inputs
     (list imagemagick pcre2 zlib))
    (propagated-inputs
     (list r-curl r-magrittr r-rcpp))
    (native-inputs
     (list pkg-config r-knitr r-spelling))
    (home-page "https://github.com/ropensci/magick")
    (synopsis "Advanced graphics and image-processing in R")
    (description
     "This package provides bindings to ImageMagick, a comprehensive image
processing library.  It supports many common formats (PNG, JPEG, TIFF, PDF,
etc.)  and manipulations (rotate, scale, crop, trim, flip, blur, etc).  All
operations are vectorized via the Magick++ STL meaning they operate either on
a single frame or a series of frames for working with layers, collages, or
animation.  In RStudio, images are automatically previewed when printed to the
console, resulting in an interactive editing environment.")
    (license license:expat)))

(define-public r-survey
  (package
    (name "r-survey")
    (version "4.4-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "survey" version))
       (sha256
        (base32
         "1ggisal5g16p3n03bch7ymawd4hig3fmm02nhxy1z5zh48qhyjla"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; This is needed for vignettes.
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-lattice
           r-matrix
           r-minqa
           r-mitools
           r-numderiv
           r-rcpp
           r-rcpparmadillo
           r-survival))
    (native-inputs (list r-aer r-mass r-r-rsp r-rsqlite))
    (home-page "https://r-survey.r-forge.r-project.org/survey/")
    (synopsis "Analysis of complex survey samples")
    (description
     "This package provides tools for the analysis of complex survey samples.
The provided features include: summary statistics, two-sample tests, rank
tests, generalised linear models, cumulative link models, Cox models,
loglinear models, and general maximum pseudolikelihood estimation for
multistage stratified, cluster-sampled, unequally weighted survey samples;
variances by Taylor series linearisation or replicate weights;
post-stratification, calibration, and raking; two-phase subsampling designs;
graphics; PPS sampling without replacement; principal components, and factor
analysis.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-gee
  (package
    (name "r-gee")
    (version "4.13-27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gee" version))
       (sha256
        (base32
         "1754173msjxhkpl95v6z8c73vhz7ivfil0xfs25smrlgslzpgd1z"))))
    (properties `((upstream-name . "gee")))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/gee/")
    (synopsis "Generalized estimation equation solver")
    (description
     "This package provides a solver for generalized estimation equations.")
    (license license:gpl2)))

(define-public r-tab
  (package
    (name "r-tab")
    (version "5.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tab" version))
       (sha256
        (base32
         "1kg8c1safi9klkx2mdkmsf5dn9piy4jljwd4ma7g4jz2rwl4jzhv"))))
    (properties `((upstream-name . "tab")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-kableextra r-knitr r-mass r-survey))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/tab/")
    (synopsis "Create summary tables for statistical reports")
    (description
     "This package contains functions for creating various types of summary
tables, e.g. comparing characteristics across levels of a categorical variable
and summarizing fitted generalized linear models, generalized estimating
equations, and Cox proportional hazards models.  Functions are available to
handle data from simple random samples as well as complex surveys.")
    (license license:gpl3+)))

(define-public r-tarchetypes
  (package
    (name "r-tarchetypes")
    (version "0.10.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "tarchetypes" version))
              (sha256
               (base32
                "0xhx2l00j1yb68a8m5b9c9ams90sp01m9kvzxjgi90zpimpmc3h1"))))
    (properties `((upstream-name . "tarchetypes")))
    (build-system r-build-system)
    ;; Many tests fail, because r-targets looks up the system's partitions,
    ;; which fails in the build environment.  Unfortunately, the error
    ;; messages are both verbose and close to useless, so I can't see how we
    ;; can work around this.
    (arguments (list #:test-types '(list "vignettes")))
    (propagated-inputs (list r-dplyr
                             r-fs
                             r-rlang
                             r-secretbase
                             r-targets
                             r-tibble
                             r-tidyselect
                             r-vctrs
                             r-withr))
    (native-inputs (list r-rmarkdown r-testthat))
    (home-page "https://docs.ropensci.org/tarchetypes/")
    (synopsis "Archetypes for Targets")
    (description
     "Function-oriented Make-like declarative pipelines for statistics and
data science are supported in the targets R package.  As an extension to
targets, the tarchetypes package provides convenient user-side functions to
make targets easier to use.  By establishing reusable archetypes for common
kinds of targets and pipelines, these functions help express complicated
reproducible pipelines concisely and compactly.  The methods in this package
were influenced by the drake R package by Will Landau (2018)
<doi:10.21105/joss.00550>.")
    (license license:expat)))

(define-public r-targets
  (package
    (name "r-targets")
    (version "1.8.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "targets" version))
              (sha256
               (base32
                "0cx70ibq38772vpx1c6dkj68np1dki94yv66hihjp4wwn18w519y"))))
    (properties `((upstream-name . "targets")))
    (build-system r-build-system)
    (propagated-inputs (list r-base64url
                             r-callr
                             r-cli
                             r-codetools
                             r-data-table
                             r-igraph
                             r-knitr
                             r-ps
                             r-r6
                             r-rlang
                             r-secretbase
                             r-tibble
                             r-tidyselect
                             r-vctrs
                             r-yaml))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/targets/")
    (synopsis "Dynamic function-oriented Make-like declarative pipelines")
    (description
     "This package provides a pipeline toolkit for statistics and data science
in R; the @code{targets} package brings function-oriented programming to
Make-like declarative pipelines.  It orchestrates a pipeline as a graph of
dependencies, skips steps that are already up to date, runs the necessary
computation with optional parallel workers, abstracts files as R objects, and
provides tangible evidence that the results are reproducible given the
underlying code and data.  The methodology in this package borrows from GNU
Make (2015, ISBN:978-9881443519) and drake (2018,
<doi:10.21105/joss.00550>).")
    (license license:expat)))

(define-public r-tidygeocoder
  (package
    (name "r-tidygeocoder")
    (version "1.0.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "tidygeocoder" version))
              (sha256
               (base32
                "1ffj8ka5miv3jnds7fdrkcqdc3m2w1ab724z9m10biky213skqka"))))
    (properties `((upstream-name . "tidygeocoder")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-httr
                             r-jsonlite
                             r-lifecycle
                             r-progress
                             r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://jessecambon.github.io/tidygeocoder/")
    (synopsis
     "Intuitive interface for getting data from geocoding services")
    (description
     "Tidygeocoder makes getting data from geocoding services easy.
A unified high-level interface is provided for a selection of supported
geocoding services and results are returned in tibble format.")
    (license license:expat)))

(define-public r-dvmisc
  (package
    (name "r-dvmisc")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dvmisc" version))
       (sha256
        (base32 "01v6sixx0f3nrn6ymfifb3pvd2msfrwm21kmdv38laxq29vc4rsi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cubature
           r-data-table
           r-dplyr
           r-ggplot2
           r-mass
           r-mvtnorm
           r-pracma
           r-rbenchmark
           r-rcpp
           r-survey
           r-tab))
    (home-page "https://cran.r-project.org/web/packages/dvmisc/")
    (synopsis "Faster computation of common statistics and miscellaneous functions")
    (description
     "This package implements faster versions of base R functions (e.g. mean, standard
deviation, covariance, weighted mean), mostly written in C++, along with
miscellaneous functions for various purposes (e.g. create the histogram with
fitted probability density function or probability mass function curve, create
the body mass index groups, assess the linearity assumption in logistic
regression).")
    (license license:gpl2)))

(define-public r-accelerometry
  (package
    (name "r-accelerometry")
    (version "3.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "accelerometry" version))
       (sha256
        (base32 "13xzrwhr4i1nj9c8vrmfdg2rmrc8n446iihcyxmy99sm99hpzyip"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dvmisc r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/accelerometry/")
    (synopsis "Functions for processing accelerometer data")
    (description
     "This package provides a collection of functions that perform operations on
time-series accelerometer data, such as identify the non-wear time, flag minutes
that are part of an activity bout, and find the maximum 10-minute average count
value.  The functions are generally very flexible, allowing for a variety of
algorithms to be implemented.")
    (license license:gpl3)))

(define-public r-absim
  (package
    (name "r-absim")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AbSim" version))
       (sha256
        (base32 "16ddjk8b6xw80ch4jis1y751i9561wdxh0gifbf15qiz3vjckq8m"))))
    (properties `((upstream-name . "AbSim")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape r-powerlaw))
    (home-page "https://cran.r-project.org/web/packages/AbSim/")
    (synopsis "Time resolved simulations of antibody repertoires")
    (description
     "This package provides simulation methods for the evolution of antibody repertoires.
  The heavy and light chain variable region of both human and C57BL/6 mice can
be simulated in a time-dependent fashion.  Both single lineages using one set of
V-, D-, and J-genes or full repertoires can be simulated.  The algorithm begins
with an initial V-D-J recombination event, starting the first phylogenetic tree.
  Upon completion, the main loop of the algorithm begins, with each iteration
representing one simulated time step.  Various mutation events are possible at
each time step, contributing to a diverse final repertoire.")
    (license license:gpl2)))

(define-public r-quic
  (package
    (name "r-quic")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "QUIC" version))
       (sha256
        (base32 "021bp9xbaih60qmss015ycblbv6d1dvb1z89y93zpqqnc2qhpv3c"))))
    (properties `((upstream-name . "QUIC")))
    (build-system r-build-system)
    (home-page "https://www.cs.utexas.edu/users/sustik/QUIC/")
    (synopsis "Regularized sparse inverse covariance matrix estimation")
    (description
     "This package implements the regularized Gaussian maximum likelihood
estimation of the inverse of a covariance matrix.  It uses Newton's method and
coordinate descent to solve the regularized inverse covariance matrix
estimation problem.")
    ;; The project home page states that the release is under GPLv3 or later.
    ;; The CRAN page only says GPL-3.
    (license license:gpl3+)))

(define-public r-quickjsr
  (package
    (name "r-quickjsr")
    (version "1.4.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "QuickJSR" version))
              (sha256
               (base32
                "1fjlgfd13zqlqilr19h00glgaqq54z9mmg2f4dkml1dxw94dlp9l"))))
    (properties `((upstream-name . "QuickJSR")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-tinytest))
    (home-page "https://cran.r-project.org/package=QuickJSR")
    (synopsis "Interface for the QuickJS lightweight JavaScript engine")
    (description
     "This package provides an R interface to the @code{QuickJS} portable
@code{JavaScript} engine.  The engine is bundled entirely within the package,
requiring no external system dependencies beyond a C compiler.")
    (license license:expat)))

(define-public r-abundant
  (package
    (name "r-abundant")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abundant" version))
       (sha256
        (base32 "15m3ngj5aipjg961yy5kvdg9xlfcpliw30dq6gchzxabhnfzcipd"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-glasso))
    (home-page "https://cran.r-project.org/web/packages/abundant/")
    (synopsis "Abundant regression and high-dimensional principal fitted components")
    (description
     "This package provides tools to fit and predict with the high-dimensional
principal fitted components model.  This model is described by Cook, Forzani,
and Rothman (2012) @url{doi:10.1214/11-AOS962}.")
    ;; The DESCRIPTION file states GPL-2, but since it directly depends on a
    ;; GPLv3+ package (QUIC) this likely means GPLv2+.
    (license license:gpl2+)))

(define-public r-ac3net
  (package
    (name "r-ac3net")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Ac3net" version))
       (sha256
        (base32 "1ns4n0xxz6p34c11bj0k7nzgmyqr9mis2b0g5nfz37dbikndyqyz"))))
    (properties `((upstream-name . "Ac3net")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table))
    (home-page "https://cran.r-project.org/web/packages/Ac3net/")
    (synopsis "Inferring directional conservative causal core gene networks")
    (description "This package infers directional Conservative causal core
(gene) networks (C3NET).  This is a version of the algorithm C3NET with
directional network.")
    (license license:gpl3+)))

(define-public r-aca
  (package
    (name "r-aca")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACA" version))
       (sha256
        (base32 "1i3hm27nvnkvc39xlh0d1blq8q0q02czmvgi3cazmjx3jvxay0vq"))))
    (properties `((upstream-name . "ACA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ACA/")
    (synopsis "Abrupt change-point or aberration detection in point series")
    (description
     "This package offers an interactive function for the detection of breakpoints in
series.")
    ;; Any version of the GPL
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-acceptancesampling
  (package
    (name "r-acceptancesampling")
    (version "1.0-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AcceptanceSampling" version))
       (sha256
        (base32 "1sbv2yrvnn0zgdmqvjlmz2vllsg6r9nlmxdgadhymhm9s51gfx65"))))
    (properties
     `((upstream-name . "AcceptanceSampling")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/AcceptanceSampling/")
    (synopsis "Creation and evaluation of acceptance sampling plans")
    (description
     "This @code{r-acceptancesampling} provides functionality for creating and evaluating
acceptance sampling plans.  Acceptance sampling is a methodology commonly used
in quality control and improvement.  International standards of acceptance
sampling provide sampling plans for specific circumstances.  The aim of this
package is to provide an easy-to-use interface to visualize single, double or
multiple sampling plans.  In addition, methods have been provided to enable the
user to assess sampling plans against pre-specified levels of performance, as
measured by the probability of acceptance for a given level of quality in the
lot.")
    (license license:gpl3+)))

(define-public r-acclma
  (package
    (name "r-acclma")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACCLMA" version))
       (sha256
        (base32 "1na27sp18fq12gp6vxgqw1ffsz2yi1d8xvrxbrzx5g1kqxrayy0v"))))
    (properties `((upstream-name . "ACCLMA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ACCLMA/")
    (synopsis "ACC & LMA graph plotting")
    (description
     "This package contains a function that imports data from a @acronym{CSV,
Comma-Separated Values} file, or uses manually entered data from the format (x,
y, weight) and plots the appropriate @acronym{ACC, Absolute Concentration
Curve} vs @acronym{LOI, Line of Independence} graph and
@acronym{LMA, @acronym{LOI} Minus @acronym{ACC}} graph.  The main
function is @code{plotLMA} (source file, header) that takes a data set and plots the
appropriate @acronym{LMA} and @acronym{ACC} graphs.  If no source file (a
string) was passed, a manual data entry window is opened.  The header parameter
indicates by TRUE/FALSE (false by default) if the source @acronym{CSV} file has
a header row or not.  The dataset should contain only one independent variable
(x) and one dependent variable (y) and can contain a weight for each
observation.")
    (license license:gpl2)))

(define-public r-aspi
  (package
    (name "r-aspi")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aspi" version))
       (sha256
        (base32 "0rhvxw243vvdv3hxa6pi343gcjc2cbxq1jzqirl9k1l4i3897l87"))))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/web/packages/aspi/")
    (synopsis "Analysis of symmetry of parasitic infections")
    (description
     "This package provides tools for the analysis and visualization of
bilateral asymmetry in parasitic infections.")
    (license license:gpl3+)))

(define-public r-sandwich
  (package
    (name "r-sandwich")
    (version "3.1-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sandwich" version))
       (sha256
        (base32
         "06cikmpgv0dla92dhp8i89wj52wjwky1g4sb9cxqpac38bx1xrgc"))
       (modules '((guix build utils)))
       (snippet
        '(with-directory-excursion "inst/doc"
           ;; These files are generated from Rnw files.
           (for-each delete-file
                     (list "sandwich-OOP.pdf"
                           "sandwich-OOP.R"
                           "sandwich-OOP.Rnw"
                           "sandwich-CL.R"
                           "sandwich-CL.Rnw"
                           "sandwich-CL.pdf"
                           "sim-CL.rda"
                           "sim-CL.R"
                           "sandwich.pdf"
                           "sandwich.R"))))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-zoo))
    (home-page "https://cran.r-project.org/web/packages/sandwich/")
    (synopsis "Robust Covariance Matrix Estimators")
    (description
     "This package provides model-robust standard error estimators for
cross-sectional, time series, clustered, panel, and longitudinal data.")
    ;; Either version of the license.
    (license (list license:gpl2 license:gpl3))))

(define-public r-th-data
  (package
    (name "r-th-data")
    (version "1.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TH.data" version))
       (sha256
        (base32
         "0wyyvm6l6yvqvfnd1c4l9ff5445zaq9lr0ihz8pg9kkggfslxya7"))))
    (properties `((upstream-name . "TH.data")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-survival))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/TH.data/")
    (synopsis "Shared data sets")
    (description
     "This package contains supporting data sets that are used in other
packages maintained by Torsten Hothorn.")
    (license license:gpl3)))

(define-public r-themis
  (package
    (name "r-themis")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "themis" version))
       (sha256
        (base32 "1qg1kxax866s84rgjlp2c153793j45lrvay8bqfjnc2cj04h2dgi"))))
    (properties `((upstream-name . "themis")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-generics
                             r-glue
                             r-gower
                             r-hardhat
                             r-lifecycle
                             r-purrr
                             r-rann
                             r-recipes
                             r-rlang
                             r-rose
                             r-tibble
                             r-vctrs
                             r-withr))
    (native-inputs (list r-modeldata r-testthat))
    (home-page "https://github.com/tidymodels/themis")
    (synopsis "Extra recipes steps for dealing with unbalanced data")
    (description
     "This package provides a dataset with an uneven number of cases in each
class is said to be unbalanced.  Many models produce a subpar performance on
unbalanced datasets.")
    (license license:expat)))

(define-public r-multcomp
  (package
    (name "r-multcomp")
    (version "1.4-26")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "multcomp" version))
       (sha256
        (base32
         "1v3979my2yzpqc5lrx7fy72765j2cw1giv4xlpwrr2zvmzgvn051"))))
    (build-system r-build-system)
    ;; Vignettes require r-coin, but r-coin depends on r-multcomp.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs
     (list r-codetools r-mvtnorm r-sandwich r-survival r-th-data))
    (native-inputs (list r-robustbase r-xtable))
    (home-page "https://cran.r-project.org/web/packages/multcomp/")
    (synopsis "Simultaneous inference in general parametric models")
    (description
     "Simultaneous tests and confidence intervals for general linear
hypotheses in parametric models, including linear, generalized linear, linear
mixed effects, and survival models.  The package includes demos reproducing
analyzes presented in the book \"Multiple Comparisons Using R\" (Bretz,
Hothorn, Westfall, 2010, CRC Press).")
    (license license:gpl2)))

(define-public r-multcompview
  (package
    (name "r-multcompview")
    (version "0.1-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "multcompView" version))
       (sha256
        (base32 "12mdk12xciq1d3zn94rixahhcah2qq41lvb5n4kzgjaq4yr4kwiq"))))
    (properties `((upstream-name . "multcompView")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=multcompView")
    (synopsis "Visualizations of paired comparisons")
    (description
     "Convert a logical vector or a vector of p-values or a correlation,
difference, or distance matrix into a display identifying the pairs for which
the differences were not significantly different.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-emmeans
  (package
    (name "r-emmeans")
    (version "1.10.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emmeans" version))
       (sha256
        (base32
         "1m49bxq38vd5kq2f6na4n09p9apwzw531pmf9xxq0whnxifk5v8j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-estimability r-mvtnorm r-numderiv))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/rvlenth/emmeans")
    (synopsis "Estimated marginal means, aka least-squares means")
    (description
     "This package provides tools to obtain @dfn{estimated marginal
means} (EMMs) for many linear, generalized linear, and mixed models.  It can
be used to compute contrasts or linear functions of EMMs, trends, and
comparisons of slopes.")
    ;; Either version of the license.
    (license (list license:gpl2 license:gpl3))))

(define-public r-pwr
  (package
    (name "r-pwr")
    (version "1.3-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pwr" version))
       (sha256
        (base32
         "1kfzy73v3z6ipc3kdfkcjrp4b4p5k54nwk796gqi36srm93hgc2v"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/heliosdrm/pwr")
    (synopsis "Basic functions for power analysis")
    (description
     "This package provides power analysis functions along the lines of
Cohen (1988).")
    (license license:gpl3+)))

(define-public r-libcoin
  (package
    (name "r-libcoin")
    (version "1.0-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "libcoin" version))
       (sha256
        (base32 "1bvysrq2s3951vr5ab1jzbz4hyx5j04yzh04vxdpd287bm4y08rh"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; This file requires r-coin, which depends on this package.
             (delete-file "tests/regtest_libcoin.R"))))))
    (propagated-inputs (list r-mvtnorm))
    (home-page "https://cran.r-project.org/web/packages/libcoin")
    (synopsis "Linear test statistics for permutation inference")
    (description
     "This package provides basic infrastructure for linear test statistics
and permutation inference in the framework of Strasser and Weber (1999).")
    (license license:gpl2)))

(define-public r-libgeos
  (package
    (name "r-libgeos")
    (version "3.11.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "libgeos" version))
       (sha256
        (base32 "0d4gfcll0z4f57sv8vax2bbc4fvs4da4510qwisd7wf5ghjhsbb0"))))
    (properties `((upstream-name . "libgeos")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://paleolimbot.github.io/libgeos/")
    (synopsis "Open Source Geometry Engine (GEOS) C API")
    (description
     "This package provides the Open Source Geometry Engine (GEOS) as a C API
that can be used to write high-performance C and C++ geometry operations using
R as an interface.  Headers are provided to make linking to and using these
functions from C++ code as easy and as safe as possible.  This package
contains an internal copy of the GEOS library to guarantee the best possible
consistency on multiple platforms.")
    (license license:lgpl2.1+)))

(define-public r-coin
  (package
    (name "r-coin")
    (version "1.4-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "coin" version))
       (sha256
        (base32
         "0x5rh002w4xgczbvnh7qfv3qv4iv7p6vdrwwyvchqmzgygdh4qwa"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-libcoin
           r-matrixstats
           r-modeltools
           r-multcomp
           r-mvtnorm
           r-survival))
    (native-inputs (list r-e1071 r-vcd r-xtable))
    (home-page "https://coin.r-forge.r-project.org")
    (synopsis "Conditional inference procedures in a permutation test framework")
    (description
     "This package provides conditional inference procedures for the general
independence problem including two-sample, K-sample (non-parametric ANOVA),
correlation, censored, ordered and multivariate problems.")
    (license license:gpl2)))

(define-public r-bayesplot
  (package
    (name "r-bayesplot")
    (version "1.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bayesplot" version))
       (sha256
        (base32
         "0c1q1znp9vd0w6l35xa208bgiwr5f2w8j2c97v6ml4z0j5rycwag"))))
    (build-system r-build-system)
    (inputs
     (list pandoc))
    (native-inputs
     (list r-gridextra r-knitr r-rstantools r-testthat))
    (propagated-inputs
     (list r-dplyr
           r-ggplot2
           r-ggridges
           r-glue
           r-posterior
           r-reshape2
           r-rlang
           r-tibble
           r-tidyselect))
    (home-page "https://mc-stan.org/bayesplot")
    (synopsis "Plotting for Bayesian models")
    (description
     "This package provides plotting functions for posterior analysis, model
checking, and MCMC diagnostics.  The package is designed not only to provide
convenient functionality for users, but also a common set of functions that
can be easily used by developers working on a variety of R packages for
Bayesian modeling.")
    (license license:gpl3+)))

(define-public r-tmb
  (package
    (name "r-tmb")
    (version "1.9.15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TMB" version))
       (sha256
        (base32
         "11ip3cpp2mzwpja0rs62zjh3nfjv1fc21641k5h1hya7lpywmam3"))))
    (properties `((upstream-name . "TMB")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-rcppeigen))
    (home-page "http://tmb-project.org")
    (synopsis "Template model builder: a general random effect tool")
    (description
     "With this tool, a user should be able to quickly implement complex
random effect models through simple C++ templates.  The package combines
@code{CppAD} (C++ automatic differentiation), @code{Eigen} (templated
matrix-vector library) and @code{CHOLMOD} (sparse matrix routines available
from R) to obtain an efficient implementation of the applied Laplace
approximation with exact derivatives.  Key features are: Automatic sparseness
detection, parallelism through BLAS and parallel user templates.")
    (license license:gpl2)))

(define-public r-sjstats
  (package
    (name "r-sjstats")
    (version "0.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjstats" version))
       (sha256
        (base32 "07qv32gnrhrl21zgj1xp1gqdqjn6ax1nf40s11nmpag8r0xgvqnk"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-datawizard r-effectsize r-insight r-parameters r-performance))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/strengejacke/sjstats")
    (synopsis "Functions for common statistical computations")
    (description
     "This package provides a collection of convenient functions for common
statistical computations, which are not directly provided by R's @code{base}
or @code{stats} packages.  This package aims at providing, first, shortcuts
for statistical measures, which otherwise could only be calculated with
additional effort.  Second, these shortcut functions are generic, and can be
applied not only to vectors, but also to other objects as well.  The focus of
most functions lies on summary statistics or fit measures for regression
models, including generalized linear models, mixed effects models and Bayesian
models.")
    (license license:gpl3)))

(define-public r-glmmtmb
  (package
    (name "r-glmmtmb")
    (version "1.1.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "glmmTMB" version))
       (sha256
        (base32
         "189awpihhy6k677swwss7zcnz6rprmiwmyicc2679p5n8f3ccr7n"))))
    (properties `((upstream-name . "glmmTMB")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lme4
           r-matrix
           r-mgcv
           r-nlme
           r-numderiv
           r-rcppeigen
           r-reformulas
           r-tmb))
    (native-inputs
     (list r-knitr r-rmarkdown r-testthat)) ; for vignettes
    (home-page "https://github.com/glmmTMB")
    (synopsis "Generalized linear mixed models")
    (description
     "Fit linear and generalized linear mixed models with various extensions,
including zero-inflation.  The models are fitted using maximum likelihood
estimation via the Template Model Builder.  Random effects are assumed to be
Gaussian on the scale of the linear predictor and are integrated out using the
Laplace approximation.  Gradients are calculated using automatic
differentiation.")
    (license license:agpl3+)))

(define-public r-bayestestr
  (package
    (name "r-bayestestr")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bayestestR" version))
       (sha256
        (base32
         "1x3r6vf414lar6z4hshf9lpindiynz2d4kb0bwr1phz5db3x77l3"))))
    (properties `((upstream-name . "bayestestR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-datawizard r-insight))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/easystats/bayestestR")
    (synopsis "Describe Bayesian models and posterior distributions")
    (description
     "This package provides utilities to understand and describe posterior
distributions and Bayesian models.  It includes point-estimates such as
@dfn{Maximum A Posteriori} (MAP), measures of dispersion such as @dfn{Highest
Density Interval} (HDI), and indices used for null-hypothesis testing (such as
ROPE percentage and pd).")
    (license license:gpl3)))

(define-public r-performance
  (package
    (name "r-performance")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "performance" version))
       (sha256
        (base32
         "0dsvgc8svl5c2zzif656m56ql198nlsjq88bcby8g26bncvhbq5y"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; These fail because of unexpected warnings.
             (delete-file "tests/testthat/test-compare_performance.R")
             ;; No idea why this fails.
             (delete-file "tests/testthat/test-rmse.R"))))))
    (propagated-inputs
     (list r-bayestestr r-datawizard r-insight))
    (native-inputs (list r-testthat))
    (home-page "https://easystats.github.io/performance/")
    (synopsis "Assessment of regression models performance")
    (description
     "This package provides utilities for computing measures to assess model
quality, which are not directly provided by R's @code{base} or @code{stats}
packages.  These include e.g. measures like r-squared, intraclass correlation
coefficient, root mean squared error or functions to check models for
overdispersion, singularity or zero-inflation and more.  Functions apply to a
large variety of regression models, including generalized linear models, mixed
effects models and Bayesian models.")
    (license license:gpl3)))

(define-public r-ggeffects
  (package
    (name "r-ggeffects")
    (version "1.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggeffects" version))
       (sha256
        (base32
         "15vrmmsbg8kjdbn6if2qgsjx8qy5jqp70cdxazj7xrqkx6c3wwic"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-insight))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/strengejacke/ggeffects")
    (synopsis "Create tidy data frames of marginal effects for ggplot")
    (description
     "This package provides tools to compute marginal effects from statistical
models and return the result as tidy data frames.  These data frames are ready
to use with the @code{ggplot2} package.  Marginal effects can be calculated
for many different models.  Interaction terms, splines and polynomial terms
are also supported.  The two main functions are @code{ggpredict()} and
@code{ggeffect()}.  There is a generic @code{plot()} method to plot the
results using @code{ggplot2}.")
    (license license:gpl3)))

(define-public r-effectsize
  (package
    (name "r-effectsize")
    (version "0.8.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "effectsize" version))
       (sha256
        (base32
         "12qzz3zl5yn28ybmmryhmi29zwzwrfgqhb6wm7aqg78id463bjz9"))))
    (properties `((upstream-name . "effectsize")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayestestr r-datawizard r-insight r-parameters r-performance))
    (native-inputs
     (list r-boot r-knitr r-testthat))
    (home-page "https://github.com/easystats/effectsize")
    (synopsis "Indices of effect size and standardized parameters")
    (description
     "This package provides utilities to work with indices of effect size and
standardized parameters for a wide variety of models, allowing computation and
conversion of indices such as Cohen's d, r, odds, etc.")
    (license license:gpl3)))

(define-public r-effsize
  (package
    (name "r-effsize")
    (version "0.8.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "effsize" version))
              (sha256
               (base32
                "1m5ch2g77f4ldbxhzp2ls1pga8hq7ggkz1xs8a90h0s09rj0gd7w"))))
    (properties `((upstream-name . "effsize")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/mtorchiano/effsize/")
    (synopsis "Efficient effect size computation")
    (description
     "This package provides a collection of functions to compute the
standardized effect sizes for experiments (Cohen d, Hedges g, Cliff delta,
Vargha-Delaney A).  The computation algorithms have been optimized to allow
efficient computation even with very large data sets.")
    (license license:gpl2)))

(define-public r-sjplot
  (package
    (name "r-sjplot")
    (version "2.8.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjPlot" version))
       (sha256
        (base32 "093nmn1gq8i4kr5nhwby883rxpdiyb959shqvfnvplwcnnv762ji"))))
    (properties `((upstream-name . "sjPlot")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayestestr
           r-datawizard
           r-dplyr
           r-ggeffects
           r-ggplot2
           r-insight
           r-knitr
           r-mass
           r-parameters
           r-performance
           r-purrr
           r-rlang
           r-scales
           r-sjlabelled
           r-sjmisc
           r-sjstats
           r-tidyr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://strengejacke.github.io/sjPlot/")
    (synopsis "Data visualization for statistics in social science")
    (description
     "This package represents a collection of plotting and table output
functions for data visualization.  Results of various statistical
analyses (that are commonly used in social sciences) can be visualized using
this package, including simple and cross tabulated frequencies, histograms,
box plots, (generalized) linear models, mixed effects models, principal
component analysis and correlation matrices, cluster analyses, scatter plots,
stacked scales, effects plots of regression models (including interaction
terms) and much more.  This package supports labelled data.")
    (license license:gpl3)))

(define-public r-ini
  (package
    (name "r-ini")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ini" version))
       (sha256
        (base32
         "04yqij344dwm0xqgara8xia42mlmij3i8711qbb5534w05a1l6bv"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/dvdscripter/ini")
    (synopsis "Read and write configuration files")
    (description
     "This package provides tools to parse simple @code{.ini} configuration
files to an structured list.  Users can manipulate this resulting list with
@code{lapply()} functions.  This same structured list can be used to write
back to file after modifications.")
    (license license:gpl3)))

(define-public r-gillespiessa2
  (package
    (name "r-gillespiessa2")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GillespieSSA2" version))
       (sha256
        (base32 "0wjz0fh9cwvaw6n7hs2lkh818jzbjl11ps5gxnjqizz8gfp9fr10"))))
    (properties `((upstream-name . "GillespieSSA2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-dplyr
           r-dynutils
           r-matrix
           r-purrr
           r-rcpp
           r-rcppxptrutils
           r-readr
           r-rlang
           r-stringr
           r-tidyr))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/rcannood/GillespieSSA2")
    (synopsis "Gillespie's stochastic simulation algorithm")
    (description
     "This package provides a fast, scalable, and versatile framework for
simulating large systems with Gillespie's @dfn{Stochastic Simulation
Algorithm} (SSA).  This package is the spiritual successor to the GillespieSSA
package.  Benefits of this package include major speed improvements (>100x),
easier to understand documentation, and many unit tests that try to ensure the
package works as intended.")
    (license license:gpl3+)))

(define-public r-gitcreds
  (package
    (name "r-gitcreds")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gitcreds" version))
       (sha256
        (base32
         "0pf70g4a2kxjcid5rc4ppmgcl3kpjhkszdgz4fqn4l33lp6apij1"))))
    (properties `((upstream-name . "gitcreds")))
    (build-system r-build-system)
    (inputs (list git-minimal))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/r-lib/gitcreds")
    (synopsis "Query git credentials from R")
    (description
     "Query, set, and delete credentials from the git credential store.
Manage GitHub tokens and other git credentials.  This package is to be used by
other packages that need to authenticate to GitHub and/or other git
repositories.")
    (license license:expat)))

(define-public r-gh
  (package
    (name "r-gh")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gh" version))
       (sha256
        (base32
         "1bwj8a2lfansyfx7fiwx2nv8yzhg1fi9ja1n6fk7dbzf64m3zgbn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-gitcreds
           r-glue
           r-httr2
           r-ini
           r-jsonlite
           r-lifecycle
           r-rlang))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/r-lib/gh#readme")
    (synopsis "Access the GitHub API via R")
    (description
     "This package provides a minimal R client to access the GitHub API.")
    (license license:expat)))

(define-public r-fs
  (package
    (name "r-fs")
    (version "1.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fs" version))
       (sha256
        (base32
         "0d0bqwi4a0kpday3kbvaawhqfh7lcx4jx2hm5nspgvjv4504sfqf"))))
    (build-system r-build-system)
    ;; Tests require r-testthat, which indirectly depends on this package.
    (arguments (list #:tests? #false))
    (native-inputs
     (list r-knitr))
    (home-page "https://fs.r-lib.org")
    (synopsis "Cross-platform file system operations based on libuv")
    (description
     "This package provides a cross-platform interface to file system
operations, built on top of the libuv C library.")
    (license license:gpl3)))

(define-public r-clisymbols
  (package
    (name "r-clisymbols")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clisymbols" version))
       (sha256
        (base32
         "1q7gi2zmykhzas9v8fdnbpdq7pzdcpbhim1yxvd2062l777g4j86"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/gaborcsardi/clisymbols")
    (synopsis "Unicode symbols at the R prompt")
    (description
     "This package provides a small subset of Unicode symbols, that are useful
when building command line applications.  They fall back to alternatives on
terminals that do not support Unicode.")
    (license license:expat)))

(define-public r-credentials
  (package
    (name "r-credentials")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "credentials" version))
       (sha256
        (base32
         "02jxbd6nwii243r88h57h9z37knl7jm1jdzg9bpd6g5r6a4dfss9"))))
    (properties `((upstream-name . "credentials")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'setenv-HOME
           (lambda _
             ;; This is necessary because git looks for $HOME/.gitconfig
             (setenv "HOME" "/tmp"))))))
    (inputs
     (list git-minimal))
    (propagated-inputs
     (list r-askpass r-curl r-jsonlite r-openssl r-sys))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/credentials/")
    (synopsis "Tools for managing SSH and Git credentials")
    (description
     "This package assists you in setting up and retrieving of HTTPS and SSH
credentials for use with git and other services.  For HTTPS remotes the
package interfaces the @command{git-credential} utility which @command{git}
uses to store HTTP usernames and passwords.  For SSH remotes this package
provides convenient functions to find or generate appropriate SSH keys.  The
package both helps the user to setup a local git installation, and also
provides a back-end for git/ssh client libraries to authenticate with existing
user credentials.")
    (license license:expat)))

(define-public r-gert
  (package
    (name "r-gert")
    (version "2.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gert" version))
       (sha256
        (base32
         "0vbpycxn5gzygbsjhdzy5f7yz49hl4rl5savl6cglf688qr2m61d"))))
    (properties `((upstream-name . "gert")))
    (build-system r-build-system)
    (inputs
     (list libgit2 openssh openssl zlib))
    (propagated-inputs
     (list r-askpass
           r-credentials
           r-openssl
           r-rstudioapi
           r-sys
           r-zip))
    (native-inputs
     (list pkg-config r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/gert/")
    (synopsis "Simple Git client for R")
    (description
     "This package provides a simple git client for R based on libgit2 with
support for SSH and HTTPS remotes.  All functions in gert use basic R data
types (such as vectors and data-frames) for their arguments and return values.
User credentials are shared with command line git through the
@code{git-credential} store and SSH keys stored on disk or ssh-agent.")
    (license license:expat)))

(define-public r-usethis
  (package
    (name "r-usethis")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "usethis" version))
       (sha256
        (base32
         "1dfcyxvw95lhm4giarsw266833sfbckk44nddjqpxqxarvwm1y4q"))))
    (build-system r-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; FIXME cran_version("usethis") return NULL
             (delete-file "tests/testthat/test-release.R")))
         ;; This is needed for tests.
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-cli
           r-clipr
           r-crayon
           r-curl
           r-desc
           r-fs
           r-gert
           r-gh
           r-glue
           r-jsonlite
           r-lifecycle
           r-purrr
           r-rappdirs
           r-rlang
           r-rprojroot
           r-rstudioapi
           r-whisker
           r-withr
           r-yaml))
    (native-inputs (list r-knitr r-rmarkdown r-roxygen2 r-testthat r-tibble))
    (home-page "https://github.com/r-lib/usethis")
    (synopsis "Automate R package and project setup")
    (description
     "This package helps you to automate R package and project setup tasks
that are otherwise performed manually.  This includes setting up unit testing,
test coverage, continuous integration, Git, GitHub integration, licenses,
Rcpp, RStudio projects, and more.")
    (license license:gpl3)))

(define-public r-sessioninfo
  (package
    (name "r-sessioninfo")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sessioninfo" version))
       (sha256
        (base32
         "1jy7n37qnrb4fgzmn8s8yf7kv29yw27x8zklwf8qdb2kgj2q6qpm"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; One test attempts to connect to a website
             (delete-file "tests/testthat/test-diff.R")
             ;; This one fails for silly reasons.
             (delete-file "tests/testthat/test-platform-info.R"))))))
    (propagated-inputs
     (list r-cli))
    (native-inputs (list r-mockery r-testthat))
    (home-page "https://github.com/r-lib/sessioninfo#readme")
    (synopsis "R session information")
    (description
     "This package provides tools to query and print information about the
current R session.  It is similar to @code{utils::sessionInfo()}, but includes
more information about packages, and where they were installed from.")
    (license license:gpl2)))

(define-public r-remotes
  (package
    (name "r-remotes")
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "remotes" version))
       (sha256
        (base32
         "0345s9q0fyv0wrxkklcy97h7bi85jfb3vwkh80px926d4qa3yrjd"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/r-lib/remotes#readme")
    (synopsis "R package installation from remote repositories")
    (description
     "Download and install R packages stored in GitHub, BitBucket, or plain
subversion or git repositories.  This package is a lightweight replacement of
the @code{install_*} functions in the @code{devtools} package.  Indeed most of
the code was copied over from @code{devtools}.")
    (license license:gpl2+)))

(define-public r-xopen
  (package
    (name "r-xopen")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xopen" version))
       (sha256
        (base32
         "1v4sna4md4cpqwi7802m4mfflgi506fxh78la0kam894qfw7icp3"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-processx))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-lib/xopen#readme")
    (synopsis "Open system files, URLs, anything")
    (description
     "This package provides a cross-platform solution to open files,
directories or URLs with their associated programs.")
    (license license:expat)))

(define-public r-rcmdcheck
  (package
    (name "r-rcmdcheck")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rcmdcheck" version))
       (sha256
        (base32
         "1l696byn3kjq2xvz4wxybzaj6ink85h4lz3a35v2132ba5yyzm5v"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr
           r-cli
           r-curl
           r-desc
           r-digest
           r-pkgbuild
           r-prettyunits
           r-r6
           r-rprojroot
           r-sessioninfo
           r-withr
           r-xopen))
    (native-inputs (list r-mockery r-testthat r-webfakes))
    (home-page "https://github.com/r-Lib/rcmdcheck#readme")
    (synopsis "Run R CMD check from R and capture results")
    (description
     "Run @code{R CMD check} from R programmatically, and capture the results
of the individual checks.")
    (license license:expat)))

(define-public r-rapportools
  (package
    (name "r-rapportools")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rapportools" version))
       (sha256
        (base32
         "0qr86idng12g6hdd764j0wmli700v7rjhw7jdjxj0ka8xm5v7ymm"))))
    (build-system r-build-system)
    ;; Tests fail: could not find function "context"
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-mass r-pander r-plyr r-reshape2))
    (home-page "https://cran.r-project.org/web/packages/rapportools/")
    (synopsis "Miscellaneous helper functions with sane defaults for reporting")
    (description
     "This package provides helper functions that act as wrappers to more
advanced statistical methods with the advantage of having sane defaults for
quick reporting.")
    (license license:agpl3+)))

(define-public r-pander
  (package
    (name "r-pander")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pander" version))
       (sha256
        (base32
         "144zkq5w7v6fpzk3x40i0baybbp0y6x2ckh4b9qljryas9mhgp9a"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; These tests fail in the C locale.
             (delete-file "inst/tests/test-helpers.R")
             (delete-file "inst/tests/test-S3.R")
             (delete-file "inst/tests/test-evals.R"))))))
    (propagated-inputs
     (list r-digest r-rcpp))
    (native-inputs
     (list pandoc r-knitr r-lattice r-testthat))
    (home-page "https://rapporter.github.io/pander")
    (synopsis "Render R objects into Pandoc's markdown")
    (description
     "The main aim of the pander R package is to provide a minimal and easy
tool for rendering R objects into Pandoc's markdown.  The package is also
capable of exporting/converting complex Pandoc documents (reports) in various
ways.")
    ;; This package is licensed under either the AGPLv3+ or the very rarely
    ;; used OSL 3.0.
    (license license:agpl3+)))

(define-public r-summarytools
  (package
    (name "r-summarytools")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "summarytools" version))
       (sha256
        (base32
         "0gr95cd1ja8di6s0xghk6w7nj3bh3z4g7j7ixdy7f88q681aixgx"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc
           r-checkmate
           r-dplyr
           r-htmltools
           r-lubridate
           r-magick
           r-matrixstats
           r-pander
           r-pryr
           r-rapportools
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/dcomtois/summarytools")
    (synopsis "Tools to quickly and neatly summarize data")
    (description
     "This package provides tools for data frame summaries, cross-tabulations,
weight-enabled frequency tables and common univariate statistics in concise
tables available in a variety of formats (plain ASCII, Markdown and HTML).  A
good point-of-entry for exploring data, both for experienced and new R
users.")
    (license license:gpl2)))

(define-public r-lsei
  (package
    (name "r-lsei")
    (version "1.3-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lsei" version))
       (sha256
        (base32
         "1dka0rigfw4vj809qma2dkiwjb3nw5635ynnba5cm299cn7hb2b2"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://www.stat.auckland.ac.nz/~yongwang")
    (synopsis "Solve regression problems under equality/inequality constraints")
    (description
     "It contains functions that solve least squares linear regression
problems under linear equality/inequality constraints.  Functions for solving
quadratic programming problems are also available, which transform such
problems into least squares ones first.")
    (license license:gpl2+)))

(define-public r-npsurv
  (package
    (name "r-npsurv")
    (version "0.5-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "npsurv" version))
       (sha256
        (base32
         "1ihxhb42cga1hssj2jv4ah0f4hlwsky899ij5261fzh1wxvdp1xw"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lsei))
    (home-page "https://www.stat.auckland.ac.nz/~yongwang")
    (synopsis "Nonparametric survival analysis")
    (description
     "This package contains functions for non-parametric survival analysis of
exact and interval-censored observations.")
    (license license:gpl2+)))

(define-public r-clustercrit
  (package
    (name "r-clustercrit")
    (version "1.3.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "clusterCrit" version))
              (sha256
               (base32
                "0raxlyvr3kr8c8bzjgs7hb9n76m314vzvfiz7c74v6cqpkmh6dkx"))))
    (properties `((upstream-name . "clusterCrit")))
    (build-system r-build-system)
    (native-inputs (list gfortran r-runit))
    (home-page "https://www.r-project.org/")
    (synopsis "Computing clustering validation indices")
    (description
     "The @code{clusterCrit} package provides an implementation of the
following indices: Czekanowski-Dice, Folkes-Mallows, Hubert Γ, Jaccard,
McNemar, Kulczynski, Phi, Rand, Rogers-Tanimoto, Russel-Rao or Sokal-Sneath.
ClusterCrit defines several functions which compute internal quality indices
or external comparison indices.  The partitions are specified as an integer
vector giving the index of the cluster each observation belongs to.")
    (license license:gpl2+)))

(define-public r-clusteval
  (package
    (name "r-clusteval")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clusteval" version))
       (sha256
        (base32
         "1ld0bdl4fy8dsfzm3k7a37cyxc6pfc9qs31x4pxd3z5rslghz7rj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mvtnorm r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/clusteval/")
    (synopsis "Evaluation of clustering algorithms")
    (description
     "This R package provides a suite of tools to evaluate clustering
algorithms, clusterings, and individual clusters.")
    (license license:expat)))

(define-public r-clustergeneration
  (package
    (name "r-clustergeneration")
    (version "1.3.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "clusterGeneration" version))
              (sha256
               (base32
                "0w1sywv9cgl78wrsamh1zrig67r3grnyl27f036ipd1ab1b2510g"))))
    (properties `((upstream-name . "clusterGeneration")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/package=clusterGeneration")
    (synopsis "Random cluster generation (with specified degree of separation)")
    (description
     "The clusterGeneration package provides functions for generating random
clusters, generating random covariance/correlation matrices, calculating a
separation index (data and population version) for pairs of clusters or
cluster distributions, and 1-D and 2-D projection plots to visualize clusters.
The package also contains a function to generate random clusters based on
factorial designs with factors such as degree of separation, number of
clusters, number of variables, number of noisy variables.")
    (license license:gpl2+)))

(define-public r-tweedie
  (package
    (name "r-tweedie")
    (version "2.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tweedie" version))
       (sha256
        (base32
         "0ghwggdx6d391m7nay9n5li2xjqh3kmw416xx130sy2sxrgp8g4q"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/tweedie/")
    (synopsis "Evaluation of Tweedie exponential family models")
    (description
     "Maximum likelihood computations for Tweedie families, including the
series expansion (Dunn and Smyth, 2005; <doi10.1007/s11222-005-4070-y>) and
the Fourier inversion (Dunn and Smyth, 2008; <doi:10.1007/s11222-007-9039-6>),
and related methods.")
    (license license:gpl2+)))

(define-public r-rcppgsl
  (package
    (name "r-rcppgsl")
    (version "0.3.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppGSL" version))
       (sha256
        (base32 "1rwkin79ppkdz1y9pghxx29vlyvs84bylvqblkhj8r4w26y76ppy"))))
    (properties `((upstream-name . "RcppGSL")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp gsl))
    (home-page "https://cran.r-project.org/web/packages/RcppGSL/")
    (synopsis "Rcpp integration for GSL vectors and matrices")
    (description
     "The GNU Scientific Library (or GSL) is a collection of numerical
routines for scientific computing.  It is particularly useful for C and C++
programs as it provides a standard C interface to a wide range of mathematical
routines.  There are over 1000 functions in total with an extensive test
suite.  The RcppGSL package provides an easy-to-use interface between GSL data
structures and R using concepts from Rcpp which is itself a package that eases
the interfaces between R and C++.")
    (license license:gpl2+)))

(define-public r-mvabund
  (package
    (name "r-mvabund")
    (version "4.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mvabund" version))
       (sha256
        (base32
         "01kss9dx4an1ir5zs46jypvhj8sdc8wcs00i1223ai09av4lcsgd"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-rcpp r-rcppgsl r-statmod r-tweedie))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/mvabund/")
    (synopsis "Statistical methods for analysing multivariate abundance data")
    (description
     "This package provides a set of tools for displaying, modeling and
analysing multivariate abundance data in community ecology.")
    (license license:lgpl2.1+)))

(define-public r-mvnfast
  (package
    (name "r-mvnfast")
    (version "0.2.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mvnfast" version))
       (sha256
        (base32 "1869xqq2wd7yw23q4ma5qawcnbdp7myafk6rdxazqymqak7f0wc8"))))
    (properties `((upstream-name . "mvnfast")))
    (build-system r-build-system)
    ;; FIXME Tests fail with: could not find function "context"
    (arguments (list #:tests? #false))
    (propagated-inputs (list r-bh r-rcpp r-rcpparmadillo))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/mfasiolo/mvnfast/")
    (synopsis "Fast multivariate normal and Student's t methods")
    (description
     "This package provides computationally efficient tools related to the
multivariate normal and Student's t distributions.  The main functionalities
are: simulating multivariate random vectors, evaluating multivariate normal or
Student's t densities and Mahalanobis distances.  These tools are developed
using C++ code and of the OpenMP API.")
    (license license:gpl2+)))

(define-public r-afex
  (package
    (name "r-afex")
    (version "1.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "afex" version))
       (sha256
        (base32
         "17i8am28l937vd2v6z17bfngslpskjx301pk050zvz3hf7ckayms"))))
    (build-system r-build-system)
    ;; This is needed for the vignette builder
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-car r-lme4 r-lmertest r-pbkrtest r-reshape2))
    (native-inputs
     (list r-knitr r-r-rsp r-testthat)) ;vignette builder
    (home-page "https://afex.singmann.science/")
    (synopsis "Analysis of factorial experiments")
    (description
     "This package provides convenience functions for analyzing factorial
experiments using ANOVA or mixed models.")
    (license license:gpl2+)))

(define-public r-lmertest
  (package
    (name "r-lmertest")
    (version "3.1-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmerTest" version))
       (sha256
        (base32
         "1zd8gqjkazhxgpnnr484xwsq30p62fq8592nzyc171zjyplpbaim"))))
    (properties `((upstream-name . "lmerTest")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-lme4 r-mass r-numderiv))
    (home-page "https://github.com/runehaubo/lmerTestR")
    (synopsis "Tests in linear mixed effects models")
    (description
     "This package provides p-values in type I, II or III anova and summary
tables for @code{lmer} model fits via Satterthwaite's degrees of freedom
method.  A Kenward-Roger method is also available via the @code{pbkrtest}
package.  Model selection methods include step, drop1 and anova-like tables
for random effects (ranova).  Methods for Least-Square means (LS-means) and
tests of linear contrasts of fixed effects are also available.")
    (license license:gpl2+)))

(define-public r-r2glmm
  (package
    (name "r-r2glmm")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "r2glmm" version))
       (sha256
        (base32
         "0iim92blpa59vgz97c2pi05yhbjjmaffdbkbmk5kplfb2vmazgiy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-afex
           r-data-table
           r-dplyr
           r-ggplot2
           r-gridextra
           r-lmertest
           r-mass
           r-matrix
           r-mgcv
           r-pbkrtest))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/bcjaeger/r2glmm")
    (synopsis "Compute R squared for mixed (multilevel) models")
    (description
     "This package computes model and semi partial R squared with confidence
limits for the linear and generalized linear mixed model (LMM and GLMM).  The
R squared measure from L. J. Edwards et al. (2008) is extended to the GLMM
using @dfn{penalized quasi-likelihood} (PQL) estimation (see Jaeger et
al. (2016)).")
    (license license:gpl2)))

(define-public r-cmdfun
  (package
    (name "r-cmdfun")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cmdfun" version))
       (sha256
        (base32
         "1pbcq7hi2lcmqnghmy3q2fsk0c9fy5m0637acyzmc096fxbx723j"))))
    (properties `((upstream-name . "cmdfun")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-magrittr
           r-purrr
           r-r-utils
           r-rlang
           r-testthat
           r-usethis))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://snystrom.github.io/cmdfun/")
    (synopsis "Framework for building interfaces to shell commands")
    (description
     "Writing interfaces to command line software is cumbersome.  The cmdfun
package provides a framework for building function calls to seamlessly
interface with shell commands by allowing lazy evaluation of command line
arguments.  It also provides methods for handling user-specific paths to tool
installs or secrets like API keys.  Its focus is to equally serve package
builders who wish to wrap command line software, and to help analysts stay
inside R when they might usually leave to execute non-R software.")
    (license license:expat)))

(define-public r-rslurm
  (package
    (name "r-rslurm")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rslurm" version))
       (sha256
        (base32
         "0z5lyrkvfh2201sc772gzbz3hc1mc04pxww611iwjf6qwzn5h0al"))))
    (properties `((upstream-name . "rslurm")))
    (build-system r-build-system)
    (propagated-inputs (list r-whisker))
    (native-inputs (list r-knitr r-testthat))
    (home-page "http://cyberhelp.sesync.org/rslurm/")
    (synopsis "Submit R calculations to a Slurm cluster")
    (description
     "This package provides functions that simplify submitting R scripts to a
Slurm workload manager, in part by automating the division of embarrassingly
parallel calculations across cluster nodes.")
    (license license:gpl3)))

(define-public r-chk
  (package
    (name "r-chk")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "chk" version))
       (sha256
        (base32
         "0f6ilq9pbb6mgvclp6ksbaw8353wf114p1xqhlmkwgsfh2bg63xg"))))
    (properties
     `((upstream-name . "chk")
       (updater-extra-native-inputs . ("tzdata-for-tests"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lifecycle r-rlang))
    (native-inputs (list r-knitr r-testthat tzdata-for-tests))
    (home-page "https://github.com/poissonconsulting/chk")
    (synopsis "Check user-supplied function arguments")
    (description
     "This is a package for developers to check user-supplied function
arguments.  It is designed to be simple, fast and customizable.  Error
messages follow the tidyverse style guide.")
    (license license:expat)))

(define-public r-weights
  (package
    (name "r-weights")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "weights" version))
       (sha256
        (base32
         "1fnchf7f0hyl514bk8sc3l884kg25kb5xm4mc2l28n6hm7l6bgpg"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gdata r-hmisc r-lme4 r-mice))
    (home-page "https://cran.r-project.org/web/packages/weights/")
    (synopsis "Weighting and weighted statistics")
    (description "This package Provides a variety of functions for producing
simple weighted statistics, such as weighted Pearson's correlations, partial
correlations, Chi-Squared statistics, histograms, and t-tests.  Also now
includes some software for quickly recoding survey data and plotting point
estimates from interaction terms in regressions (and multiply imputed
regressions).  NOTE: Weighted partial correlation calculations pulled to
address a bug.")
  (license license:gpl2+)))

(define-public r-rcppalgos
  (package
    (name "r-rcppalgos")
    (version "2.8.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RcppAlgos" version))
              (sha256
               (base32
                "0ww5p6gwhk8bsmk8fqmnypvgmfkgwf0jjasifzz3appwkiql2kyf"))))
    (properties `((upstream-name . "RcppAlgos")))
    (build-system r-build-system)
    (inputs (list gmp))
    (propagated-inputs (list r-cpp11 r-gmp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/jwood000/RcppAlgos")
    (synopsis
     "High performance tools for combinatorics and computational mathematics")
    (description
     "This package provides optimized functions and flexible combinatorial
iterators implemented in C++ for solving problems in combinatorics and
computational mathematics.  It utilizes the @code{RMatrix} class from
@code{RcppParallel} for thread safety.  There are combination/permutation
functions with constraint parameters that allow for generation of all results
of a vector meeting specific criteria.  It is capable of generating specific
combinations/permutations which sets up nicely for parallelization as well as
random sampling.  Gmp support permits exploration where the total number of
results is large.  Additionally, there are several high performance number
theoretic functions that are useful for problems common in computational
mathematics.")
    (license license:gpl2+)))

(define-public r-rcppannoy
  (package
    (name "r-rcppannoy")
    (version "0.0.22")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppAnnoy" version))
       (sha256
        (base32
         "0rcgvmlp3by57k562pbxsncirww1vv8zarfxrjzfgly4hzbj28cz"))))
    (properties `((upstream-name . "RcppAnnoy")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/RcppAnnoy/")
    (synopsis "Rcpp bindings for Annoy, a library for Approximate Nearest Neighbors")
    (description
     "Annoy is a small C++ library for Approximate Nearest Neighbors written
for efficient memory usage as well an ability to load from and save to disk.
This package provides an R interface.")
    ;; Annoy is released under ASL 2.0, but this wrapper is released under
    ;; GPLv2+.
    (license (list license:gpl2+ license:asl2.0))))

(define-public r-rcpphnsw
  (package
    (name "r-rcpphnsw")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppHNSW" version))
       (sha256
        (base32
         "03sqzz1993jsjm5vpyd1n1fpsrdfrky6dpv7m9ialhs1m00fv9m5"))))
    (properties `((upstream-name . "RcppHNSW")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/RcppHNSW/")
    (synopsis "Rcpp bindings for hnswlib, a library for approximate nearest neighbors")
    (description
     "Hnswlib is a C++ library for approximate nearest neighbors.  This
package provides a minimal R interface by relying on the Rcpp package.")
    ;; hnswlib is released under Version 2.0 of the Apache License.
    (license (list license:gpl3 license:asl2.0))))

(define-public r-rcppparallel
  (package
    (name "r-rcppparallel")
    (version "5.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppParallel" version))
       (sha256
        (base32
         "0kqivaj5swpj46gdgrccn4pawldkprsiw0lwy874xgppy3rn227x"))
       (modules '((guix build utils)))
       (snippet
        '(delete-file-recursively "src/tbb/"))))
    (properties `((upstream-name . "RcppParallel")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'use-system-tbb
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TBB_ROOT" (assoc-ref inputs "tbb")))))))
    (inputs (list tbb-2020))
    (native-inputs (list r-rcpp r-runit))
    (home-page "https://rcppcore.github.io/RcppParallel/")
    (synopsis "Parallel programming tools for Rcpp")
    (description
     "This package provides high level functions for parallel programming with
Rcpp.  For example, the @code{parallelFor()} function can be used to convert
the work of a standard serial @code{for} loop into a parallel one and the
@code{parallelReduce()} function can be used for accumulating aggregates or
other values.")
    (license license:gpl2)))

(define-public r-ncdf4
  (package
    (name "r-ncdf4")
    (version "1.23")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ncdf4" version))
       (sha256
        (base32
         "12fsjjc769hw7fc08yglr3gaxp67s8qx1mbx91g61h4xyzlzw1cb"))))
    (build-system r-build-system)
    (inputs
     (list netcdf zlib))
    (home-page "https://cran.r-project.org/web/packages/ncdf4/index.html")
    (synopsis "R interface to Unidata netCDF format data files")
    (description
     "This package provides a high-level R interface to data files written
using Unidata's netCDF library (version 4 or earlier), which are binary data
files that are portable across platforms and include metadata information in
addition to the data sets.  Using this package, netCDF files can be opened and
data sets read in easily.  It is also easy to create new netCDF dimensions,
variables, and files, in either version 3 or 4 format, and manipulate existing
netCDF files.")
    (license license:gpl3+)))

(define-public r-ncmisc
  (package
    (name "r-ncmisc")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NCmisc" version))
       (sha256
        (base32 "10wzznqa26fxyj6bl979qmq29p3dkr8yap4s70l3mwhhk33zpz16"))))
    (properties `((upstream-name . "NCmisc")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=NCmisc")
    (synopsis "Functions for creating adaptive functions and scripts")
    (description
     "This package provides a set of handy functions.  It includes a versatile
one line progress bar, one line function timer with detailed output, time delay
function, text histogram, object preview, CRAN package search, simpler package
installer, Linux command install check, a flexible Mode function, top function,
simulation of correlated data, and more.")
    (license license:gpl2+)))

(define-public r-biocmanager
  (package
    (name "r-biocmanager")
    (version "1.30.25")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BiocManager" version))
       (sha256
        (base32 "058ym2j400xj8v4k02b6r3wy3lrs1nk909f6x3hhydf7vibqpvw3"))))
    (properties `((upstream-name . "BiocManager")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/web/packages/BiocManager/")
    (synopsis "Access the Bioconductor project package repository")
    (description
     "This package provides a convenient tool to install and update
Bioconductor packages.")
    (license license:artistic2.0)))

;; TODO: one more minified JavaScript files is included that should be built
;; from the included .src.js files, but it is not entirely clear how.  The
;; file is inst/htmlwidgets/lib/rglClass/rglClass.min.js.
(define-public r-rgl
  (package
    (name "r-rgl")
    (version "1.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rgl" version))
       (sha256
        (base32
         "1bqzchjgqkfsyrymw5s14f5akagnmryc6rp762cq7glximpgm7qc"))
       (snippet
        '(delete-file "inst/htmlwidgets/lib/CanvasMatrix/CanvasMatrix.min.js"))))
    ;; For OpenGL and X11 support
    (properties
     '((updater-extra-inputs . ("glu" "libx11"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/"
               (let ((source "CanvasMatrix/CanvasMatrix.src.js")
                     (target "CanvasMatrix/CanvasMatrix.min.js"))
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (native-inputs
     (list esbuild
           pkg-config
           r-knitr
           r-rmarkdown                  ;for vignettes
           r-testthat))
    (inputs
     (list freetype
           glu
           libpng
           libx11
           zlib
           zlib))
    (propagated-inputs
     (list r-base64enc
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-knitr
           r-magrittr
           r-mime
           r-r6))
    (home-page "https://r-forge.r-project.org/projects/rgl/")
    (synopsis "3D visualization using OpenGL")
    (description
     "This package provides medium to high level functions for 3D interactive graphics,
including functions modelled on base graphics (@code{plot3d()}, etc.) as well
as functions for constructing representations of geometric
objects (@code{cube3d()}, etc.).  Output may be on screen using OpenGL, or to
various standard 3D file formats including WebGL, PLY, OBJ, STL as well as 2D
image formats, including PNG, Postscript, SVG, PGF.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-multicool
  (package
    (name "r-multicool")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "multicool" version))
       (sha256
        (base32
         "07vcyp7yd1rzlldxzpzrdgifnw88z0maq2dgsqc218vyplgxwwmx"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/multicool/")
    (synopsis "Permutations of multisets in cool-lex order")
    (description
     "This package provides a set of tools to permute multisets without loops
or hash tables and to generate integer partitions.  Cool-lex order is similar
to colexicographical order.")
    (license license:gpl2)))

(define-public r-multidplyr
  (package
    (name "r-multidplyr")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "multidplyr" version))
              (sha256
               (base32
                "18yl24s1g8wf3xi6f0k7jhs99ka4dslxf5p9ax9m5l1rbva5xdwj"))))
    (properties `((upstream-name . "multidplyr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr
           r-cli
           r-crayon
           r-dplyr
           r-magrittr
           r-qs
           r-r6
           r-rlang
           r-tibble
           r-tidyselect
           r-vctrs))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://multidplyr.tidyverse.org")
    (synopsis "Multi-process dplyr backend")
    (description
     "Partition a data frame across multiple worker processes to provide
simple multicore parallelism.")
    (license license:expat)))

(define-public r-multiplex
  (package
    (name "r-multiplex")
    (version "3.8-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "multiplex" version))
       (sha256
        (base32 "0ninfd1gf7w2b97l8r7nbgnk8v8312qymfvqbzdarynlxz6qbdlv"))))
    (properties `((upstream-name . "multiplex")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://github.com/mplex/multiplex/")
    (synopsis "Algebraic tools for the analysis of multiple social networks")
    (description
     "Algebraic procedures for analyses of multiple social networks are
delivered with this package.  @code{multiplex} makes possible, among other
things, to create and manipulate multiplex, multimode, and multilevel network
data with different formats.  Effective ways are available to treat multiple
networks with routines that combine algebraic systems like the partially
ordered semigroup with decomposition procedures or semiring structures with
the relational bundles occurring in different types of multivariate networks.
multiplex provides also an algebraic approach for affiliation networks through
Galois derivations between families of the pairs of subsets in the two domains
of the network with visualization options.")
    (license license:gpl3)))

(define-public r-misc3d
  (package
    (name "r-misc3d")
    (version "0.9-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "misc3d" version))
       (sha256
        (base32
         "0r9x57s63kx9f6dgam2nhbziq8nrs9wd8pk7g76hds2kw46vnyx0"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/misc3d/")
    (synopsis "Miscellaneous 3D Plots")
    (description
     "This package provides a collection of miscellaneous 3d plots, including
isosurfaces.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-missforest
  (package
    (name "r-missforest")
    (version "1.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "missForest" version))
              (sha256
               (base32
                "13c38hpl60ca1kwyv61cxsla6ccmsj4qzp0vrxcq7b827fh5aw21"))))
    (properties `((upstream-name . "missForest")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dorng
           r-foreach
           r-iterators
           r-itertools
           r-randomforest))
    (home-page "https://github.com/stekhoven/missForest")
    (synopsis "Nonparametric missing value imputation using Random Forest")
    (description
     "The function @code{missForest} in this package is used to impute missing
values, particularly in the case of mixed-type data.  It uses a random forest
trained on the observed values of a data matrix to predict the missing values.
It can be used to impute continuous and/or categorical data, including complex
interactions and non-linear relations.  It yields an @acronym{OOB, out-of-bag}
imputation error estimate without the need of a test set or elaborate cross-
validation.  It can be run in parallel to save computation time.")
    (license license:gpl2+)))

(define-public r-ks
  (package
    (name "r-ks")
    (version "1.14.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ks" version))
       (sha256
        (base32 "0dj0nig3pqxi5mwxwzajq938abq48jazpzmw20mwzcs7jrlwn22i"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fnn
           r-kernlab
           r-kernsmooth
           r-matrix
           r-mclust
           r-mgcv
           r-multicool
           r-mvtnorm
           r-pracma))
    (home-page "https://www.mvstat.net/tduong/")
    (synopsis "Kernel smoothing")
    (description
     "This package provides kernel smoothers for univariate and multivariate
data, including density functions, density derivatives, cumulative
distributions, modal clustering, discriminant analysis, and two-sample
hypothesis testing.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-feature
  (package
    (name "r-feature")
    (version "1.2.15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "feature" version))
       (sha256
        (base32
         "0yzn1w1sasilcp8v0pcjnxjv9l6lspkskqi412i6h040gqmjjf6y"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ks r-plot3d))
    (native-inputs
     (list r-knitr))
    (home-page "https://www.mvstat.net/tduong/")
    (synopsis "Inferential feature significance for kernel density estimation")
    (description
     "The feature package contains functions to display and compute kernel
density estimates, significant gradient and significant curvature regions.
Significant gradient and/or curvature regions often correspond to significant
features (e.g. local modes).")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-arm
  (package
    (name "r-arm")
    (version "1.14-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "arm" version))
       (sha256
        (base32
         "1g8732naydqyv5pq1fkyb1i6qddv62jdmn2ys5lbdvx2zq5cnns2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-coda
           r-lme4
           r-mass
           r-matrix
           r-nlme))
    (home-page "https://cran.r-project.org/web/packages/arm/")
    (synopsis "Data analysis using regression and multilevel/hierarchical models")
    (description
     "This package provides functions to accompany A. Gelman and J. Hill,
Data Analysis Using Regression and Multilevel/Hierarchical Models, Cambridge
University Press, 2007.")
    (license license:gpl3+)))

(define-public r-circular
  (package
    (name "r-circular")
    (version "0.5-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "circular" version))
       (sha256
        (base32
         "1ngkhdvdzxdm8amc4s9jmiqc916fmf1xnm70gz3znxyp368zqngv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-mvtnorm))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/circular/")
    (synopsis "Circular statistics")
    (description
     "This package provides tools for circular statistics, from \"Topics in
circular Statistics\" (2001) S. Rao Jammalamadaka and A. SenGupta, World
Scientific.")
    (license license:gpl2+)))

(define-public r-activity
  (package
    (name "r-activity")
    (version "1.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "activity" version))
       (sha256
        (base32
         "10gp2yvqxz5ysmh5z8qvrpli8kc2kn2z3nd2llfabpyh21476in2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-pbapply))
    (home-page "https://cran.r-project.org/web/packages/activity/")
    (synopsis "Animal activity statistics")
    (description
     "This package provides functions to fit kernel density functions to
animal activity time data; plot activity distributions; quantify overall
levels of activity; statistically compare activity metrics through
bootstrapping; and evaluate variation in linear variables with time (or other
circular variables).")
    (license license:gpl3)))

(define-public r-ouch
  (package
    (name "r-ouch")
    (version "2.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ouch" version))
       (sha256
        (base32
         "1r1nj4m2hw4gdaw596q14d6majcz15ppa0mfhfl8f791phcyarka"))))
    (build-system r-build-system)
    (propagated-inputs (list r-subplex))
    (home-page "https://kingaa.github.io/ouch/")
    (synopsis "Ornstein-Uhlenbeck models for phylogenetic comparative hypotheses")
    (description
     "This package provides tools to fit and compare Ornstein-Uhlenbeck models
for evolution along a phylogenetic tree.")
    (license license:gpl2+)))

(define-public r-fmesher
  (package
    (name "r-fmesher")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fmesher" version))
       (sha256
        (base32 "17cpq6yxpa4jwwq8s4s5nd1lvh4jqyxnnqz7bay63vq53g0b4c12"))))
    (properties `((upstream-name . "fmesher")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-lifecycle
                             r-matrix
                             r-rcpp
                             r-rlang
                             r-sf
                             r-tibble
                             r-withr))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://inlabru-org.github.io/fmesher/")
    (synopsis "Triangle meshes and related geometry tools")
    (description
     "This package lets you generate planar and spherical triangle meshes,
compute finite element calculations for 1- and 2-dimensional flat and curved
manifolds with associated basis function spaces, methods for lines and
polygons, and transparent handling of coordinate reference systems and
coordinate transformation, including @code{sf} and @code{sp} geometries.  The
core @code{fmesher} library code was originally part of the INLA package, and
implements parts of \"Triangulations and Applications\" by Hjelle and
Daehlen (2006) <doi:10.1007/3-540-33261-8>.")
    (license license:mpl2.0)))

(define-public r-fmri
  (package
    (name "r-fmri")
    (version "1.9.12.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "fmri" version))
              (sha256
               (base32
                "0fyvnc39la5wgd9232nw6lp6yi1v3nkjwzn0sbhm4rckknibb5s4"))))
    (properties `((upstream-name . "fmri")))
    (build-system r-build-system)
    (propagated-inputs (list r-aws r-metafor r-nlme r-oro-nifti))
    (native-inputs (list gfortran))
    (home-page "http://www.wias-berlin.de/software/imaging/")
    (synopsis "Analysis of fMRI experiments")
    (description
     "This package contains R-functions to perform an fMRI analysis as
described in Polzehl and Tabelow (2019) <DOI:10.1007/978-3-030-29184-6>,
Tabelow et al. (2006) <DOI:10.1016/j.neuroimage.2006.06.029>, Polzehl et
al. (2010) <DOI:10.1016/j.neuroimage.2010.04.241>, Tabelow and Polzehl (2011)
<DOI:10.18637/jss.v044.i11>.")
    (license license:gpl2+)))

(define-public r-fmsb
  (package
    (name "r-fmsb")
    (version "0.7.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fmsb" version))
       (sha256
        (base32
         "1cnkg4njb432p05j8hdwfa2swiynwm864yixgfbyr26r8jfz4zg5"))))
    (build-system r-build-system)
    (home-page "https://minato.sip21c.org/msb/")
    (synopsis "Functions for medical statistics book with demographic data")
    (description
     "This package provides several utility functions for the book entitled
\"Practices of Medical and Health Data Analysis using R\" (Pearson Education
Japan, 2007) with Japanese demographic data and some demographic analysis
related functions.")
    (license license:gpl2+)))

(define-public r-stabledist
  (package
    (name "r-stabledist")
    (version "0.7-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stabledist" version))
       (sha256
        (base32
         "1mbgl6an18dzry55pvy08zdhj1gar5mlyvkfnlawiqyqq081frr6"))))
    (build-system r-build-system)
    ;; Tests require r-fbasics, which depends on this package
    (arguments (list #:tests? #false))
    (home-page "https://www.rmetrics.org")
    (synopsis "Stable distribution functions")
    (description
     "This package provides density, probability and quantile functions, and
random number generation for (skew) stable distributions, using the
parametrizations of Nolan.")
    (license license:gpl2+)))

(define-public r-gsl
  (package
    (name "r-gsl")
    (version "2.1-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gsl" version))
       (sha256
        (base32
         "159d782nz7fqhgcj3fa79hlmkdrqnkd0ypgzcl71kgas92zhjdpk"))))
    (build-system r-build-system)
    (inputs
     (list gsl))
    (home-page "https://cran.r-project.org/web/packages/gsl")
    (synopsis "Wrapper for the GNU Scientific Library")
    (description
     "This package provides an R wrapper for the special functions and quasi
random number generators of the GNU Scientific Library.")
    (license license:gpl2+)))

(define-public r-adgoftest
  (package
    (name "r-adgoftest")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ADGofTest" version))
       (sha256
        (base32
         "0ik817qzqp6kfbckjp1z7srlma0w6z2zcwykh0jdiv7nahwk3ncw"))))
    (properties `((upstream-name . "ADGofTest")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ADGofTest")
    (synopsis "Anderson-Darling GoF test")
    (description
     "This package provides an implementation of the Anderson-Darling GoF test
with p-value calculation based on Marsaglia's 2004 paper \"Evaluating the
Anderson-Darling Distribution\".")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-adimpro
  (package
    (name "r-adimpro")
    (version "0.9.7.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "adimpro" version))
              (sha256
               (base32
                "0b7dncf1w4yvm9i67q19fj95p3sc57lqv9wb2n9kvjddqk0vk4iv"))))
    (properties `((upstream-name . "adimpro")
                  (updater-extra-propagated-inputs . ("imagemagick"))))
    (build-system r-build-system)
    (propagated-inputs
     (list imagemagick r-awsmethods))
    (native-inputs (list gfortran))
    (home-page "https://www.wias-berlin.de/software/imaging/")
    (synopsis "Adaptive smoothing of digital images")
    (description
     "This package implements tools for manipulation of digital images and the
Propagation Separation approach by Polzehl and Spokoiny (2006)
<DOI:10.1007/s00440-005-0464-1> for smoothing digital images, see Polzehl and
Tabelow (2007) <DOI:10.18637/jss.v019.i01>.")
    (license license:gpl2+)))

(define-public r-admisc
  (package
    (name "r-admisc")
    (version "0.36")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "admisc" version))
       (sha256
        (base32 "0skgx1bsf7nrcz86y6nj0b8yjjr1bah2w8xz8psrsjv7q424inlg"))))
    (properties `((upstream-name . "admisc")))
    (build-system r-build-system)
    (home-page "https://github.com/dusadrian/admisc")
    (synopsis "Adrian Dusa's miscellaneous")
    (description
     "This package contains miscellaneous functions used to interpret and
translate, factorize and negate Sum of Products expressions, for both binary
and multi-value crisp sets, and to extract information (set names, set values)
from those expressions.  Other functions perform various other checks if
possibly numeric (even if all numbers reside in a character vector) and coerce
to numeric, or check if the numbers are whole.  It also offers, among many
others, a highly flexible recoding routine and a more flexible alternative to
the base function @code{with()}.")
    (license license:gpl3+)))

(define-public r-oro-nifti
  (package
    (name "r-oro-nifti")
    (version "0.11.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "oro.nifti" version))
              (sha256
               (base32
                "01mn90qxb7i15zr83xrl2cn4akayfzpm83r5x71zczz3qb9gbr7g"))))
    (properties `((upstream-name . "oro.nifti")))
    (build-system r-build-system)
    (propagated-inputs (list r-abind r-bitops r-rnifti))
    (native-inputs (list r-testthat))
    (home-page "https://rigorousanalytics.blogspot.com")
    (synopsis "Visualization of medical imaging data")
    (description
     "This package provides functions for the input/output and visualization
of medical imaging data that follow either the ANALYZE, NIfTI or AFNI formats.
This package is part of the Rigorous Analytics bundle.")
    (license license:bsd-3)))

(define-public r-mritc
  (package
    (name "r-mritc")
    (version "0.5-3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mritc" version))
              (sha256
               (base32
                "1bpnm2qzq67dgjxsa4wxn51f4a4cxal5r6abgs3m7p5a9a16jmjp"))))
    (properties `((upstream-name . "mritc")))
    (build-system r-build-system)
    (propagated-inputs (list r-lattice r-misc3d r-oro-nifti))
    (home-page "https://cran.r-project.org/package=mritc")
    (synopsis "MRI tissue classification")
    (description "This package provides various methods for MRI tissue
classification.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-sodium
  (package
    (name "r-sodium")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sodium" version))
       (sha256
        (base32
         "15wbzz355sgind6n8k3ahkp5w0ai9mffw0l2fxrzazm0i9wcj6vp"))))
    (properties `((upstream-name . "sodium")))
    (build-system r-build-system)
    (inputs
     (list libsodium))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://github.com/jeroen/sodium")
    (synopsis "R bindings to the libsodium crypto library")
    (description
     "This package provides bindings to libsodium: a library for encryption,
decryption, signatures, password hashing and more.  Sodium uses curve25519, a
Diffie-Hellman function by Daniel Bernstein, which has become very popular
after it was discovered that the NSA had backdoored Dual EC DRBG.")
    (license license:expat)))

(define-public r-softimpute
  (package
    (name "r-softimpute")
    (version "1.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "softImpute" version))
       (sha256
        (base32
         "1v2a4d688ij5zcvkzpra9yx40xckdfnllnfnyq2450zf3n1kjk7a"))))
    (properties `((upstream-name . "softImpute")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix))
    (native-inputs
     (list gfortran r-knitr))
    (home-page "https://cran.r-project.org/web/packages/softImpute")
    (synopsis "Matrix completion via iterative soft-thresholded SVD")
    (description
     "This package provides iterative methods for matrix completion that use
nuclear-norm regularization.  The package includes procedures for centering
and scaling rows, columns or both, and for computing low-rank @dfn{single
value decompositions} (SVDs) on large sparse centered matrices (i.e. principal
components).")
    (license license:gpl2)))

(define-public r-som
  (package
    (name "r-som")
    (version "0.3-5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "som" version))
       (sha256
        (base32 "0ibhcadjfgi93p5jvs8hni7a92k3x1k74m93w6h2xl6c2q2vpavn"))))
    (properties `((upstream-name . "som")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=som")
    (synopsis "Self-organizing map")
    (description
     "This package implements a self-organizing map which has application in
gene clustering.  It provides functions like:

@itemize
@item filtering data by certain floor, ceiling, max/min ratio, and max - min
  difference;
@item normalization of the data;
@item get the average distortion measure;
@item train a self-organizing map;
@item summarize a som object;
@item yeast cell cycle.
@end itemize")
    (license license:gpl3+)))

(define-public r-fftwtools
  (package
    (name "r-fftwtools")
    (version "0.9-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fftwtools" version))
       (sha256
        (base32
         "0zrchp4l0jdbir2gibjf00x225y9giqk80zvqmr2yyvc12lwkw7i"))))
    (build-system r-build-system)
    (inputs (list fftw))
    (native-inputs
     (list pkg-config))
    (home-page "https://github.com/krahim/fftwtools")
    (synopsis "Wrapper for FFTW3")
    (description
     "This package provides a wrapper for several FFTW functions.  It provides
access to the two-dimensional FFT, the multivariate FFT, and the
one-dimensional real to complex FFT using the FFTW3 library.  The package
includes the functions @code{fftw()} and @code{mvfftw()} which are designed to
mimic the functionality of the R functions @code{fft()} and @code{mvfft()}.
The FFT functions have a parameter that allows them to not return the
redundant complex conjugate when the input is real data.")
    (license license:gpl2+)))

(define-public r-tiff
  (package
    (name "r-tiff")
    (version "0.1-12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tiff" version))
       (sha256
        (base32
         "0p41irri0nxg9mm06g8jp5zqssv80g5zg0iifrr7ancjkxqww46z"))))
    (build-system r-build-system)
    (inputs
     (list libtiff libjpeg-turbo zlib))
    (native-inputs
     (list pkg-config))
    (home-page "https://www.rforge.net/tiff/")
    (synopsis "Read and write TIFF images")
    (description
     "This package provides an easy and simple way to read, write and display
bitmap images stored in the TIFF format.  It can read and write both files and
in-memory raw vectors.")
    ;; Either of these two license versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-nlp
  (package
    (name "r-nlp")
    (version "0.3-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NLP" version))
       (sha256
        (base32
         "1x64j49lfrj2yklwpcwsbzkadcjsbkwiximgvzlqqdpl7ldbp80q"))))
    (properties `((upstream-name . "NLP")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/NLP/")
    (synopsis "Natural language processing infrastructure")
    (description
     "This package provides basic classes and methods for Natural Language
Processing.")
    (license license:gpl3)))

(define-public r-tm
  (package
    (name "r-tm")
    (version "0.7-14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tm" version))
       (sha256
        (base32
         "103n9m9vh1s1fn2wlab5qm4i1dx4wq0ffl7v69mwa6mvdklfw7ks"))))
    (properties `((upstream-name . "tm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh r-nlp r-rcpp r-slam r-xml2))
    (native-inputs (list r-snowballc r-testthat))
    (home-page "https://tm.r-forge.r-project.org/")
    (synopsis "Text mining package")
    (description
     "This package provides a framework for text mining applications within R.")
    (license license:gpl3)))

(define-public r-waffle
  (package
    (name "r-waffle")
    (version "1.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "waffle" version))
              (sha256
               (base32
                "17z05mlnp2k9dywr0bbqz633sq1xs8q9879bl2na1in39qxq0l76"))))
    (properties `((upstream-name . "waffle")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl
           r-dt
           r-extrafont
           r-ggplot2
           r-gridextra
           r-gtable
           r-htmlwidgets
           r-plyr
           r-rcolorbrewer
           r-rlang
           r-stringr))
    (home-page "https://github.com/hrbrmstr/waffle/tree/cran")
    (synopsis "Creating waffle chart visualizations in R")
    (description
     "This package creates square pie charts also known as waffle charts.
These can be used to communicate parts of a whole for categorical quantities.
To emulate the percentage view of a pie chart, a 10x10 grid should be used.
In this way each square is representing 1% of the total.  Waffle provides
tools to create charts as well as stitch them together.  Isotype pictograms
can be made by using glyphs.")
    (license license:gpl2+)))

(define-public r-waveslim
  (package
    (name "r-waveslim")
    (version "1.8.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "waveslim" version))
       (sha256
        (base32
         "0xd7006skrsvkwj4pkxqbfsbs58rfcpfcfk1lf0gsd2y0wisi60y"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-multitaper))
    (home-page "http://waveslim.blogspot.com")
    (synopsis "Basic wavelet routines for signal processing")
    (description
     "This package provides basic wavelet routines for time series (1D),
image (2D) and array (3D) analysis.  The code provided here is based on
wavelet methodology developed in Percival and Walden (2000); Gencay, Selcuk
and Whitcher (2001); the dual-tree complex wavelet transform (DTCWT) from
Kingsbury (1999, 2001) as implemented by Selesnick; and Hilbert wavelet
pairs (Selesnick 2001, 2002).")
    (license license:bsd-3)))

(define-public r-word2vec
  (package
    (name "r-word2vec")
    (version "0.4.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "word2vec" version))
              (sha256
               (base32
                "14ba0cj430d02bd6fay3nl4ldwqyj77iwjm4gzgdc0f6sx597iiq"))))
    (properties `((upstream-name . "word2vec")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcppprogress))
    (home-page "https://github.com/bnosac/word2vec")
    (synopsis "Distributed representations of words")
    (description
     "Learn vector representations of words by continuous bag of words and
skip-gram implementations of the word2vec algorithm.  The techniques are
detailed in the paper \"Distributed Representations of Words and Phrases and
their Compositionality\" by Mikolov et al. (2013), available at
<arXiv:1310.4546>.")
    (license license:asl2.0)))

(define-public r-wordcloud
  (package
    (name "r-wordcloud")
    (version "2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wordcloud" version))
       (sha256
        (base32
         "0j96yyvm6bcrrpbdx4w26piqx44a0vbsr3px9cb4zk8a8da6jwak"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcolorbrewer r-rcpp
           ;; The "tm" package is only "suggested" according to CRAN, but the
           ;; wordcloud package cannot be loaded without it.
           r-tm))
    (home-page "https://cran.r-project.org/web/packages/wordcloud")
    (synopsis "Word clouds")
    (description
     "This package provides functionality to create pretty word clouds,
visualize differences and similarity between documents, and avoid
over-plotting in scatter plots with text.")
    (license license:lgpl2.1)))

(define-public r-colorramps
  (package
    (name "r-colorramps")
    (version "2.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "colorRamps" version))
       (sha256
        (base32
         "1y4gn6v8wmwq3wcfgdnx1ah2qa53gayvbfa62kp286ga4c8k3prw"))))
    (properties `((upstream-name . "colorRamps")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/colorRamps")
    (synopsis "Build color tables")
    (description "This package provides features to build gradient color
maps.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-tidytree
  (package
    (name "r-tidytree")
    (version "0.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tidytree" version))
       (sha256
        (base32 "14i2v6ryqw4cd74n8kz4qwwx730wzx4f0rssg5vgm0vjfsx0kafv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape
           r-cli
           r-dplyr
           r-lazyeval
           r-magrittr
           r-pillar
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect
           r-yulab-utils))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/GuangchuangYu/tidytree")
    (synopsis "Tidy tool for phylogenetic tree data manipulation")
    (description
     "Phylogenetic trees generally contain multiple components including nodes,
edges, branches and associated data.  This package provides an approach to
convert tree objects to tidy data frames.  It also provides tidy interfaces to
manipulate tree data.")
    (license license:artistic2.0)))

(define-public r-rvcheck
  (package
    (name "r-rvcheck")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rvcheck" version))
       (sha256
        (base32 "09khjklvzbafd7r55496by01a9g3y291d87hpy43w44dmz9fzn9a"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-biocmanager r-yulab-utils))
    (home-page "https://cran.r-project.org/web/packages/rvcheck")
    (synopsis "R package version check")
    (description
     "This package provides tools to check the latest release version of R and
R packages (on CRAN, Bioconductor or Github).")
    (license license:artistic2.0)))

(define-public r-doc2vec
  (package
    (name "r-doc2vec")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "doc2vec" version))
              (sha256
               (base32
                "0249hm0103kxxsi4gks4h20wf6p00gbrk9jf8c148mbja1l56f6v"))))
    (properties `((upstream-name . "doc2vec")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/bnosac/doc2vec")
    (synopsis "Distributed representations of sentences, documents and topics")
    (description
     "Learn vector representations of sentences, paragraphs or documents by
using the Paragraph Vector algorithms, namely the distributed bag of
words (PV-DBOW) and the distributed memory (PV-DM) model.  Top2vec finds
clusters in text documents by combining techniques to embed documents and
words and density-based clustering.  It does this by embedding documents in
the semantic space as defined by the doc2vec algorithm.  Next it maps these
document embeddings to a lower-dimensional space using the Uniform Manifold
Approximation and Projection (UMAP) clustering algorithm and finds dense areas
in that space using a Hierarchical Density-Based Clustering
technique (HDBSCAN).  These dense areas are the topic clusters which can be
represented by the corresponding topic vector which is an aggregate of the
document embeddings of the documents which are part of that topic cluster.  In
the same semantic space similar words can be found which are representative of
the topic.")
    (license license:expat)))

(define-public r-docopt
  (package
    (name "r-docopt")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "docopt" version))
       (sha256
        (base32
         "1zxhwizs916qm5by7nfslqnarl2q5202xc2azlhrnzk0wj3khiwz"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/docopt/docopt.R")
    (synopsis "Command-line interface specification language")
    (description
     "This package enables you to define a command-line interface by just
giving it a description in the specific format.")
    (license license:expat)))

(define-public r-sparsesvd
  (package
    (name "r-sparsesvd")
    (version "0.2-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sparsesvd" version))
       (sha256
        (base32
         "0dnqjqypjwac8aqdqsqdgcd70lyrfv6idz8q2kzjiv1sxrlwqh5v"))))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix))
    (home-page "http://tedlab.mit.edu/~dr/SVDLIBC/")
    (synopsis "Sparse truncated singular value decomposition")
    (description
     "This package provides a Wrapper around the SVDLIBC library
for (truncated) singular value decomposition of a sparse matrix.  Currently,
only sparse real matrices in Matrix package format are supported.")
    ;; SVDLIBC is released under BSD-2.  The R interface is released under
    ;; BSD-3.
    (license (list license:bsd-3 license:bsd-2))))

(define-public r-spatialreg
  (package
    (name "r-spatialreg")
    (version "1.3-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spatialreg" version))
       (sha256
        (base32 "1i00gclgkkkvkhnhrnvc8r7666glch9zi3qcqcijlrfk48psmzpf"))))
    (properties `((upstream-name . "spatialreg")))
    (build-system r-build-system)
    (propagated-inputs (list r-boot
                             r-coda
                             r-learnbayes
                             r-mass
                             r-matrix
                             r-multcomp
                             r-nlme
                             r-sf
                             r-spdata
                             r-spdep))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/r-spatial/spatialreg/")
    (synopsis "Spatial regression analysis")
    (description
     "This package provides a collection of all the estimation functions for
spatial cross-sectional models (on lattice/areal data using spatial weights
matrices) contained up to now in @code{spdep}.")
    (license license:gpl2)))

(define-public r-speedglm
  (package
    (name "r-speedglm")
    (version "0.3-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "speedglm" version))
       (sha256
        (base32
         "0jxvh9gbhip1hj7hzjs5fj8iw6ibvl6hc0llcg2j9wqgq5vkcrpq"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-biglm r-mass r-matrix))
    (home-page "https://cran.r-project.org/web/packages/speedglm")
    (synopsis "Fit linear and generalized linear models to large data sets")
    (description
     "This package provides tools for fitting linear models and generalized
linear models to large data sets by updating algorithms.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-densityclust
  (package
    (name "r-densityclust")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "densityClust" version))
       (sha256
        (base32
         "0iiq2zal792741z1a23h7cy9jp4hsc7513dxain132526f1yrzsl"))))
    (properties `((upstream-name . "densityClust")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cpp11
           r-fnn
           r-ggplot2
           r-ggrepel
           r-gridextra
           r-rcolorbrewer
           r-rtsne))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/densityClust")
    (synopsis "Clustering by fast search and find of density peaks")
    (description
     "This package provides an improved implementation (based on k-nearest
neighbors) of the density peak clustering algorithm, originally described by
Alex Rodriguez and Alessandro Laio (Science, 2014 vol. 344).  It can handle
large datasets (> 100,000 samples) very efficiently.")
    (license license:gpl2+)))

(define-public r-combinat
  (package
    (name "r-combinat")
    (version "0.0-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "combinat" version))
       (sha256
        (base32
         "1h9hr88gigihc4na7lb5i7rn4az1xa7sb34zvnznaj6pdrmwy4qm"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/combinat")
    (synopsis "Combinatorics utilities")
    (description "This package provides assorted routines for combinatorics.")
    (license license:gpl2)))

(define-public r-qlcmatrix
  (package
    (name "r-qlcmatrix")
    (version "0.9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qlcMatrix" version))
       (sha256
        (base32
         "0d38jb653787s05g8syc9wgaljaifmkviijwz5rzcd881glgs8sv"))))
    (properties `((upstream-name . "qlcMatrix")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-docopt r-matrix r-slam r-sparsesvd))
    (native-inputs (list r-knitr r-rmarkdown))
    (home-page "https://cran.r-project.org/web/packages/qlcMatrix")
    (synopsis "Sparse matrix functions for quantitative language comparison")
    (description
     "This package provides an extension of the functionality of the Matrix
package for using sparse matrices.  Some of the functions are very general,
while other are highly specific for the special data format used for
@dfn{quantitative language comparison} (QLC).")
    (license license:gpl3)))

(define-public r-qmri
  (package
    (name "r-qmri")
    (version "1.2.7.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "qMRI" version))
              (sha256
               (base32
                "0mbxgg80p159vkz05hbzvvip7h5y5rpvjrjnq1vivz855dk0053g"))))
    (properties `((upstream-name . "qMRI")))
    (build-system r-build-system)
    (propagated-inputs (list r-adimpro r-aws r-awsmethods r-oro-nifti
                             r-stringr))
    (native-inputs (list gfortran r-knitr r-testthat))
    (home-page "http://www.wias-berlin.de/research/ats/imaging/")
    (synopsis "Methods for quantitative magnetic resonance imaging (qMRI)")
    (description
     "This package provides implementation of methods for estimation of
quantitative maps from @dfn{Multi-Parameter Mapping} (MPM) acquisitions
including adaptive smoothing methods in the framework of the ESTATICS model.
The smoothing method is described in Mohammadi et
al. (2017). <doi:10.20347/WIAS.PREPRINT.2432>.  Usage of the package is also
described in Polzehl and Tabelow (2019), Magnetic Resonance Brain Imaging,
Chapter 6, Springer, Use R! Series. <doi:10.1007/978-3-030-29184-6_6>.")
    (license license:gpl2+)))

(define-public r-ddrtree
  (package
    (name "r-ddrtree")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DDRTree" version))
       (sha256
        (base32
         "16s5fjw7kwlxhrkzdny62sx32fvmg3rxjc3wrh6krd31jh1fqlfk"))))
    (properties `((upstream-name . "DDRTree")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh r-irlba r-rcpp r-rcppeigen))
    (home-page "https://cran.r-project.org/web/packages/DDRTree")
    (synopsis "Learning principal graphs with DDRTree")
    (description
     "This package provides an implementation of the framework of
@dfn{reversed graph embedding} (RGE) which projects data into a reduced
dimensional space while constructs a principal tree which passes through the
middle of the data simultaneously.  DDRTree shows superiority to
alternatives (Wishbone, DPT) for inferring the ordering as well as the
intrinsic structure of single cell genomics data.  In general, it could be
used to reconstruct the temporal progression as well as the bifurcation
structure of any data type.")
    (license license:asl2.0)))

(define-public r-corpcor
  (package
    (name "r-corpcor")
    (version "1.6.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "corpcor" version))
       (sha256
        (base32
         "028fw61n61i79fhnaqx7gmdifdpbvp3yiaq9vvfrbv4k7i84r83i"))))
    (build-system r-build-system)
    (home-page "https://strimmerlab.org/software/corpcor/")
    (synopsis "Efficient estimation of covariance and (partial) correlation")
    (description
     "This package implements a James-Stein-type shrinkage estimator for the
covariance matrix, with separate shrinkage for variances and correlations.
Furthermore, functions are available for fast singular value decomposition,
for computing the pseudoinverse, and for checking the rank and positive
definiteness of a matrix.")
    (license license:gpl3+)))

(define-public r-rspectra
  (package
    (name "r-rspectra")
    (version "0.16-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RSpectra" version))
       (sha256
        (base32
         "0zma49ah0sycjdx95m8mac21daa7p3gp9cg1mffygzhrjpblkwd2"))))
    (properties `((upstream-name . "RSpectra")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-rcpp r-rcppeigen))
    (native-inputs
     (list r-knitr r-rmarkdown))
    (home-page "https://github.com/yixuan/RSpectra")
    (synopsis "Solvers for large-scale Eigenvalue and SVD problems")
    (description
     "This package provides an R interface to the Spectra library for
large-scale eigenvalue and SVD problems.  It is typically used to compute a
few eigenvalues/vectors of an n by n matrix, e.g., the k largest eigenvalues,
which is usually more efficient than @code{eigen()} if k << n.")
    ;; MPL 2 or later.
    (license license:mpl2.0)))

(define-public r-vbsr
  (package
    (name "r-vbsr")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vbsr" version))
       (sha256
        (base32
         "1avskbxxyinjjdga4rnghcfvd4sypv4m39ysfaij5avvmi89bx3b"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/vbsr")
    (synopsis "Variational Bayes spike regression regularized linear models")
    (description
     "This package provides an efficient algorithm for solving ultra-sparse
regularized regression models using a variational Bayes algorithm with a spike
prior.  The algorithm is solved on a path, with coordinate updates, and is
capable of generating very sparse models.  Very general model
diagnostics for controlling type-1 errors are also provided.")
    (license license:gpl2)))

(define-public r-flare
  (package
    (name "r-flare")
    (version "1.7.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flare" version))
       (sha256
        (base32
         "1i3nyvi8av74v1jy85gqai73vf0hzlkk5rdpfnmvi8d7q4fa7xvg"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-lattice r-mass r-matrix))
    (home-page "https://cran.r-project.org/web/packages/flare")
    (synopsis "Family of Lasso regression implementations")
    (description
     "This package provides implementations of a family of Lasso variants
including Dantzig Selector, LAD Lasso, SQRT Lasso, Lq Lasso for estimating
high dimensional sparse linear models.")
    (license license:gpl2)))

(define-public r-lassopv
  (package
    (name "r-lassopv")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lassopv" version))
       (sha256
        (base32
         "0yawnjw063jypk3riy9xab9cmliv6c9dnabi18670khd3gzb2r9z"))))
    (build-system r-build-system)
    (propagated-inputs (list r-lars))
    (home-page "https://github.com/lingfeiwang/lassopv")
    (synopsis "Non-parametric p-value estimation for predictors in Lasso")
    (description
     "This package enables you to estimate the p-values for predictors x
against target variable y in Lasso regression, using the regularization
strength when each predictor enters the active set of regularization path for
the first time as the statistic.")
    (license license:gpl3)))

(define-public r-splitstackshape
  (package
    (name "r-splitstackshape")
    (version "1.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "splitstackshape" version))
       (sha256
        (base32
         "0mpyf2kkfdl69pdc6brl1r6101vyc6pgr7z17s55ppg3y71k4q35"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/mrdwab/splitstackshape")
    (synopsis "Stack and reshape datasets after splitting concatenated values")
    (description
     "Online data collection tools like Google Forms often export
multiple-response questions with data concatenated in cells.  The
@code{concat.split} (cSplit) family of functions provided by this package
splits such data into separate cells.  This package also includes functions to
stack groups of columns and to reshape wide data, even when the data are
\"unbalanced\"---something which @code{reshape} (from base R) does not handle,
and which @code{melt} and @code{dcast} from @code{reshape2} do not easily
handle.")
    (license license:gpl3)))

(define-public r-tfmpvalue
  (package
    (name "r-tfmpvalue")
    (version "0.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TFMPvalue" version))
       (sha256
        (base32
         "1rsxqvq1nkyhwmhm7mf7rd02rvh7xinnhqbqic6q9vicbvkmdnxr"))))
    (properties `((upstream-name . "TFMPvalue")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/ge11232002/TFMPvalue")
    (synopsis "P-value computation for position weight matrices")
    (description
     "In putative @dfn{Transcription Factor Binding Sites} (TFBSs)
identification from sequence/alignments, we are interested in the significance
of certain match scores.  TFMPvalue provides the accurate calculation of a
p-value with a score threshold for position weight matrices, or the score with
a given p-value.  It is an interface to code originally made available by
Helene Touzet and Jean-Stephane Varre, 2007, Algorithms Mol Biol:2, 15.
Touzet and Varre (2007).")
    (license license:gpl2)))

(define-public r-rnaturalearth
  (package
    (name "r-rnaturalearth")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rnaturalearth" version))
              (sha256
               (base32
                "1vfkn4bf77mr2n7dhmnl55ma4cvwy2nazhizmdqd98w2ydl13z3p"))))
    (properties `((upstream-name . "rnaturalearth")))
    (build-system r-build-system)
    (propagated-inputs (list r-httr r-jsonlite r-sf r-terra))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=rnaturalearth")
    (synopsis "World map data from Natural Earth")
    (description
     "This package facilitates mapping by making natural earth map data from
@url{https://www.naturalearthdata.com/} more easily available to R users.")
    (license license:expat)))

(define-public r-rnaturalearthdata
  (package
    (name "r-rnaturalearthdata")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rnaturalearthdata" version))
              (sha256
               (base32
                "0k8yzgpbf8d2jxxy9vzqfa3z3w4h3i9kp4rc811f4pspxbqzmzp1"))))
    (properties `((upstream-name . "rnaturalearthdata")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/ropenscilabs/rnaturalearthdata")
    (synopsis "World vector map data from Natural Earth")
    (description
     "This package provides vector map data from
@url{https://www.naturalearthdata.com/}.  Access functions are provided in the
accompanying package @code{rnaturalearth}.")
    (license license:cc0)))

(define-public r-rncl
  (package
    (name "r-rncl")
    (version "0.8.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rncl" version))
              (sha256
               (base32
                "0flrqz7pansy11ds23qv06bcmh6vxqljq0517v6292ibbx7nx1qx"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-progress r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/fmichonneau/rncl")
    (synopsis "Interface to the Nexus class library")
    (description "This package provides an interface to the Nexus class
library which allows parsing of NEXUS, Newick and other phylogenetic tree
 file formats.  It provides elements of the file that can be used to build
 phylogenetic objects such as @code{ape}'s @code{phylo} or @code{phylobase}'s
@code{phylo4(d)}.  This functionality is demonstrated with
@code{read_newick_phylo()} and @code{read_nexus_phylo()}.")
    (license license:bsd-2)))

(define-public r-phylobase
  (package
    (name "r-phylobase")
    (version "0.8.12")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "phylobase" version))
              (sha256
               (base32
                "084gfzq51acmvzbsfpkqv3kgghdbncnwr008f95yf5b2vihcm0cv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ade4 r-ape r-rcpp r-rncl r-rnexml))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/fmichonneau/phylobase")
    (synopsis "Base package for phylogenetic structures and comparative data")
    (description "This package provides a base @code{S4} class for comparative
methods, incorporating one or more trees and trait data.")
    (license license:gpl2+)))

(define-public r-phylotools
  (package
    (name "r-phylotools")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "phylotools" version))
              (sha256
               (base32
                "1dhk1ncp5zi4zl1xfnjz64v983dm7bq7iimfjin80j0bdcpps44w"))))
    (properties `((upstream-name . "phylotools")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape))
    (home-page "https://github.com/helixcn/phylotools")
    (synopsis "Phylogenetic tools for eco-phylogenetics")
    (description
     "This package provides a collection of tools for building RAxML
supermatrix using PHYLIP or aligned FASTA files.  These functions will be
useful for building large phylogenies using multiple markers.")
    (license license:gpl2)))

(define-public r-rnexml
  (package
    (name "r-rnexml")
    (version "2.4.11")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RNeXML" version))
              (sha256
               (base32
                "0ipxdhfzccpqmnfrqdy8bizm80k2chhdlzg3p0dl05p8n35i6s94"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape
           r-dplyr
           r-httr
           r-plyr
           r-reshape2
           r-rlang
           r-stringi
           r-stringr
           r-tidyr
           r-uuid
           r-xml
           r-xml2))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/RNeXML/")
    (synopsis "Semantically rich I/O for the NeXML Format")
    (description "This package provides access to phyloinformatic data in
NeXML format.  The package should add new functionality to R such as the
possibility to manipulate NeXML objects in more various and refined way
and compatibility with @code{ape} objects.")
    (license license:bsd-3)))

(define-public r-rnifti
  (package
    (name "r-rnifti")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RNifti" version))
       (sha256
        (base32
         "1s0q1vs6hzg1xadk43rxqxi55swkl7pgsnw45im5vgsz1wxgg375"))))
    (properties `((upstream-name . "RNifti")))
    (build-system r-build-system)
    (inputs (list zlib))
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/jonclayden/RNifti")
    (synopsis "Fast R and C++ access to NIfTI images")
    (description
     "This package provides very fast read and write access to images stored
in the NIfTI-1 and ANALYZE-7.5 formats, with seamless synchronisation between
compiled C and interpreted R code.  It also provides a C/C++ API that can be
used by other packages.")
    (license license:gpl2)))

(define-public r-shades
  (package
    (name "r-shades")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shades" version))
       (sha256
        (base32
         "1zg95sjhrfvbdlfc387g9p0vnb8nb6agdk1mb3wq3kwkm2da0bqj"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jonclayden/shades")
    (synopsis "Simple color manipulation")
    (description
     "This package provides functions for easily manipulating colors,
creating color scales and calculating color distances.")
    (license license:bsd-3)))

(define-public r-ore
  (package
    (name "r-ore")
    (version "1.7.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ore" version))
       (sha256
        (base32 "01ayvjyjbarmi7l2jwp7bp4m0k42zy8bvf9rbwynfwmm8mv6vx0j"))))
    (build-system r-build-system)
    (home-page "https://github.com/jonclayden/ore")
    (synopsis "R interface to the Onigmo regular expression library")
    (description
     "This package provides an alternative to R's built-in functionality for
handling regular expressions, based on the Onigmo library.  It offers
first-class compiled regex objects, partial matching and function-based
substitutions, amongst other features.")
    (license license:bsd-3)))

(define-public r-reportr
  (package
    (name "r-reportr")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reportr" version))
       (sha256
        (base32
         "0zynplxqvbmf23cm2rsz3wz2jx6mv55z94mn1k44ny3lx625cnpw"))))
    (build-system r-build-system)
    (propagated-inputs (list r-ore))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jonclayden/reportr")
    (synopsis "General message and error reporting system")
    (description
     "This package provides a system for reporting messages, which offers
certain useful features over the standard R system, such as the incorporation
of output consolidation, message filtering, assertions, expression
substitution, automatic generation of stack traces for debugging, and
conditional reporting based on the current \"output level\".")
    (license license:gpl2)))

(define-public r-tractor-base
  (package
    (name "r-tractor-base")
    (version "3.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tractor.base" version))
       (sha256
        (base32
         "12mp5x6c7c82a4z7p39cb478kwwf6lkrgbis6ak00yibsd3n6na3"))))
    (properties `((upstream-name . "tractor.base")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ore r-reportr r-rnifti r-shades))
    (home-page "https://www.tractor-mri.org.uk")
    (synopsis "Read, manipulate and visualize magnetic resonance images")
    (description
     "This package provides functions for working with magnetic resonance
images.  It supports reading and writing of popular file formats (DICOM,
Analyze, NIfTI-1, NIfTI-2, MGH); interactive and non-interactive
visualization; flexible image manipulation; metadata and sparse image
handling.")
    (license license:gpl2)))

(define-public r-gridpattern
  (package
    (name "r-gridpattern")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gridpattern" version))
       (sha256
        (base32 "1fa787m4ns3s7xnai1kqplz32nhy4pa1v6w7kzyjv9qlyfhvrw92"))))
    (properties `((upstream-name . "gridpattern")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-glue
           r-memoise
           r-png
           r-rlang
           r-sf))
    (native-inputs (list r-knitr r-rmarkdown r-testthat))
    (home-page "https://trevorldavis.com/R/gridpattern/")
    (synopsis "Grid pattern grobs")
    (description
     "This package provides grid grobs that fill in a user-defined area with
various patterns.  It includes enhanced versions of the geometric and
image-based patterns originally contained in the ggpattern package as well as
original @code{pch}, @code{polygon_tiling}, @code{regular_polygon},
@code{rose}, @code{text}, @code{wave}, and @code{weave} patterns plus support
for custom user-defined patterns.")
    (license license:expat)))

(define-public r-gridsvg
  (package
    (name "r-gridsvg")
    (version "1.7-5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gridSVG" version))
              (sha256
               (base32
                "1p8qnx9q96bni39x44l40rgcdi9r440zbipdfvkbs2paysx6mkr5"))))
    (properties `((upstream-name . "gridSVG")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-jsonlite r-xml))
    (native-inputs (list r-lattice))
    (home-page "https://cran.r-project.org/package=gridSVG")
    (synopsis "Export grid gaphics as SVG")
    (description
     "This package provides functions to export graphics drawn with package
grid to SVG format.  Extra functions provide access to SVG features that are
not available in standard R graphics, such as hyperlinks, animation, filters,
masks, clipping paths, and gradient and pattern fills.")
    ;; Any version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-grimport
  (package
    (name "r-grimport")
    (version "0.9-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "grImport" version))
       (sha256
        (base32
         "196h7i4y1gzkwlybml9iz78p5xsx7y22nk5pmzibryn5amdbdy05"))))
    (properties `((upstream-name . "grImport")))
    (build-system r-build-system)
    ;; Vignettes fail to find chessmod.txt
    (arguments (list #:test-types '(list "tests")))
    (inputs
     (list ghostscript))
    (propagated-inputs
     (list r-xml))
    (native-inputs (list r-lattice))
    (home-page "https://cran.r-project.org/web/packages/grImport")
    (synopsis "Convert, import, and draw PostScript pictures")
    (description
     "This package provides functions for converting, importing, and drawing
PostScript pictures in R plots.")
    (license license:gpl2+)))

(define-public r-grimport2
  (package
    (name "r-grimport2")
    (version "0.3-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "grImport2" version))
       (sha256
        (base32
         "11glz1yi76235x3di9r7nny0nfcisk12acc4xsm4m2d9ingjh4pn"))))
    (properties `((upstream-name . "grImport2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc r-jpeg r-png r-xml))
    (native-inputs (list r-gridsvg))
    (home-page "https://cran.r-project.org/web/packages/grImport2/")
    (synopsis "Import SVG graphics")
    (description
     "This package provides functions for importing external vector images and
drawing them as part of R plots.  This package is different from the
@code{grImport} package because, where that package imports PostScript format
images, this package imports SVG format images.  Furthermore, this package
imports a specific subset of SVG, so external images must be preprocessed
using a package like @code{rsvg} to produce SVG that this package can import.
SVG features that are not supported by R graphics, such as gradient fills, can
be imported and then exported via the @code{gridSVG} package.")
    (license license:gpl2+)))

(define-public r-kohonen
  (package
    (name "r-kohonen")
    (version "3.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kohonen" version))
       (sha256
        (base32
         "188cxw2fvpfr3dyi8g52igcyc8d5jffyn6rhc84dja52da8lp520"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/kohonen")
    (synopsis "Supervised and unsupervised self-organising maps")
    (description
     "This package provides functions to train @dfn{self-organising
maps} (SOMs).  Also interrogation of the maps and prediction using trained
maps are supported.  The name of the package refers to Teuvo Kohonen, the
inventor of the SOM.")
    (license license:gpl2+)))

(define-public r-nnls
  (package
    (name "r-nnls")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nnls" version))
       (sha256
        (base32
         "1nkz25rld4ia9l5zwf4dn9imd15mdi8lmi3ydx449dxsrxs62br7"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/nnls")
    (synopsis "Lawson-Hanson algorithm for non-negative least squares")
    (description
     "This package provides an R interface to the Lawson-Hanson implementation
of an algorithm for @dfn{non-negative least squares} (NNLS).  It also allows
the combination of non-negative and non-positive constraints.")
    (license license:gpl2+)))

(define-public r-iso
  (package
    (name "r-iso")
    (version "0.0-21")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Iso" version))
       (sha256
        (base32
         "19lgwbfbca30mh3hhnarzab5cvnrwnr0pxam6fvfnadnqzhjm15n"))))
    (properties `((upstream-name . "Iso")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://www.stat.auckland.ac.nz/~rolf/")
    (synopsis "Functions to perform isotonic regression")
    (description
     "This package provides support for linear order and unimodal
order (univariate) isotonic regression and bivariate isotonic regression with
linear order on both variables.")
    (license license:gpl2+)))

(define-public r-chemometrics
  (package
    (name "r-chemometrics")
    (version "1.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "chemometrics" version))
       (sha256
        (base32 "10d8g8sgck6v2cgkv988yiawv9vrziyqsrhagmkzf7rjpqgdn3px"))))
    (properties `((upstream-name . "chemometrics")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class
           r-e1071
           r-lars
           r-mass
           r-mclust
           r-nnet
           r-pcapp
           r-pls
           r-robustbase
           r-rpart
           r-som))
    (home-page "http://www.statistik.tuwien.ac.at/public/filz/")
    (synopsis "Multivariate statistical analysis in Chemometrics")
    (description
     "Multivariate data analysis is the simultaneous observation of more than
one characteristic.  In contrast to the analysis of univariate data, in this
approach not only a single variable or the relation between two variables can
be investigated, but the relations between many attributes can be considered.
For the statistical analysis of chemical data one has to take into account the
special structure of this type of data.  This package contains about 30
functions, mostly for regression, classification and model evaluation and
includes some data sets used in the R help examples.  It was designed as a R
companion to the book \"Introduction to Multivariate Statistical Analysis in
Chemometrics\" written by K. Varmuza and P. Filzmoser (2009).")
    (license license:gpl3+)))

(define-public r-chemometricswithr
  (package
    (name "r-chemometricswithr")
    (version "0.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ChemometricsWithR" version))
       (sha256
        (base32
         "166va1g3m1wv21qkmw4wpz0bsrclh3jih8smxphdc13l9pqgclpq"))))
    (properties
     `((upstream-name . "ChemometricsWithR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-devtools r-kohonen r-mass r-pls))
    (home-page "https://github.com/rwehrens/CWR")
    (synopsis "Chemometrics with R")
    (description
     "This package provides functions and scripts used in the book
\"Chemometrics with R - Multivariate Data Analysis in the Natural Sciences and
Life Sciences\" by Ron Wehrens, Springer (2011).")
    (license license:gpl2+)))

(define-public r-als
  (package
    (name "r-als")
    (version "0.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ALS" version))
       (sha256
        (base32
         "184d6xr4mgs78jvi7xa4njrq6p625i9sx69wak6mdn53qpl9b8ap"))))
    (properties `((upstream-name . "ALS")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-iso r-nnls))
    (home-page "https://cran.r-project.org/web/packages/ALS")
    (synopsis "Multivariate curve resolution alternating least squares")
    (description
     "Alternating least squares is often used to resolve components
contributing to data with a bilinear structure; the basic technique may be
extended to alternating constrained least squares.  This package provides an
implementation of @dfn{multivariate curve resolution alternating least
squares} (MCR-ALS).

Commonly applied constraints include unimodality, non-negativity, and
normalization of components.  Several data matrices may be decomposed
simultaneously by assuming that one of the two matrices in the bilinear
decomposition is shared between datasets.")
    (license license:gpl2+)))

(define-public r-strucchange
  (package
    (name "r-strucchange")
    (version "1.5-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "strucchange" version))
       (sha256
        (base32
         "066pbldj1a0hdhrzszqp8ad71krj7w5dbqxmgp8kk5d76r6wd6vq"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-sandwich r-zoo))
    (home-page "https://cran.r-project.org/web/packages/strucchange")
    (synopsis "Testing, monitoring, and dating structural changes")
    (description
     "This package provides tools for testing, monitoring and dating
structural changes in (linear) regression models.  It features tests/methods
from the generalized fluctuation test framework as well as from the F
test (Chow test) framework.  This includes methods to fit, plot and test
fluctuation processes (e.g., CUSUM, MOSUM, recursive/moving estimates) and F
statistics, respectively.  It is possible to monitor incoming data online
using fluctuation processes.  Finally, the breakpoints in regression models
with structural changes can be estimated together with confidence intervals.
Emphasis is always given to methods for visualizing the data.")
    ;; Either of these two GPL versions
    (license (list license:gpl2 license:gpl3))))

(define-public r-pixmap
  (package
    (name "r-pixmap")
    (version "0.4-13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pixmap" version))
       (sha256
        (base32
         "04g74v8g9r0f3czzk4r3n0wxyg7ldgfdlh21bas7axa9l10wdnz3"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/pixmap")
    (synopsis "Tools for bitmap images")
    (description
     "This package provides functions for importing, exporting, plotting and
other manipulations of bitmapped images.")
    (license license:gpl2)))

(define-public r-rapidjsonr
  (package
    (name "r-rapidjsonr")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rapidjsonr" version))
       (sha256
        (base32
         "07zdirhbzmvq3cp4xn8ngk1lgxbbabzays315zxbs3sxrz6lzjb2"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rapidjsonr")
    (synopsis "JSON parser")
    (description
     "This package provides JSON parsing capability through the Rapidjson
library.")
    (license license:expat)))

(define-public r-ontologyindex
  (package
    (name "r-ontologyindex")
    (version "2.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ontologyIndex" version))
       (sha256
        (base32
         "0gf0z0vgc1f4f70f2zpwz9bka0gbgbj4w3fcxncv1b7lbrxddrd8"))))
    (properties `((upstream-name . "ontologyIndex")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/ontologyIndex")
    (synopsis "Functions for processing ontologies in R")
    (description
     "This package provides functions for reading ontologies into R as lists
and manipulating sets of ontological terms.")
    (license license:gpl2+)))

(define-public r-gargle
  (package
    (name "r-gargle")
    (version "1.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gargle" version))
       (sha256
        (base32
         "00ch0ddysva3dbs6wsybgy76j3f2ib6iypdg9f5ic2mmdq2fnnsa"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-fs
           r-glue
           r-httr
           r-jsonlite
           r-lifecycle
           r-openssl
           r-rappdirs
           r-rlang
           r-withr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://gargle.r-lib.org")
    (synopsis "Utilities for working with Google APIs")
    (description
     "This package provides utilities for working with Google APIs.  This
includes functions and classes for handling common credential types and for
preparing, executing, and processing HTTP requests.")
    (license license:expat)))

(define-public r-bigrquery
  (package
    (name "r-bigrquery")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bigrquery" version))
       (sha256
        (base32
         "0wkm9xka83skq1cnv830q4jnqvwm8rlmns2mj8n692h2y5qxlmna"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bit64
           r-brio
           r-cli
           r-clock
           r-cpp11
           r-curl
           r-dbi
           r-gargle
           r-httr
           r-jsonlite
           r-lifecycle
           r-prettyunits
           r-rapidjsonr
           r-rlang
           r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-dbi/bigrquery")
    (synopsis "R interface to Google's BigQuery API")
    (description
     "This package provides an R interface to Google's BigQuery database.")
    (license license:gpl3)))

(define-public r-gmisc
  (package
    (name "r-gmisc")
    (version "3.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Gmisc" version))
       (sha256
        (base32 "1s8gkqg54622xhsmhl7n5pff2b6xfij111m7h3i4inzfjfmziq43"))))
    (properties `((upstream-name . "Gmisc")))
    (build-system r-build-system)
    (propagated-inputs (list r-abind
                             r-checkmate
                             r-forestplot
                             r-glue
                             r-hmisc
                             r-htmltable
                             r-knitr
                             r-lattice
                             r-lubridate
                             r-magrittr
                             r-rcpp
                             r-rlang
                             r-rmarkdown
                             r-stringr
                             r-xml
                             r-yaml))
    (native-inputs (list r-dplyr r-knitr r-testthat))
    (home-page "https://gforge.se")
    (synopsis "Descriptive statistics, transition plots, and more")
    (description
     "This package provides tools for making the descriptive \"Table 1\" used
in medical articles, a transition plot for showing changes between
categories (also known as a Sankey diagram), flow charts by extending the grid
package, a method for variable selection based on the SVD, Bezier lines with
arrows complementing the ones in the grid package, and more.")
    (license license:gpl3+)))

(define-public r-gmp
  (package
    (name "r-gmp")
    (version "0.7-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gmp" version))
       (sha256
        (base32
         "0y6f2fdpydjcf1iz75xnjln3gzwpc1njls0n9y923naczfdazkgm"))))
    (properties
     '((updater-extra-inputs . ("gmp"))))
    (build-system r-build-system)
    (inputs (list gmp))
    (home-page "https://cran.r-project.org/web/packages/gmp")
    (synopsis "Multiple precision arithmetic")
    (description
     "This package supports multiple precision arithmetic (big integers and
rationals, prime number tests, matrix computation), \"arithmetic without
limitations\" using the GNU Multiple Precision library.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-rmpfr
  (package
    (name "r-rmpfr")
    (version "0.9-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rmpfr" version))
       (sha256
        (base32
         "06zkllbdaddq3jq03k926gfjcijvcysfrqhh76hjklzwkrra5sdw"))))
    (properties `((upstream-name . "Rmpfr")))
    (build-system r-build-system)
    (inputs
     (list gmp mpfr))
    (propagated-inputs
     (list r-gmp))
    (native-inputs
     (list pkg-config r-mass r-sfsmisc))
    (home-page "https://rmpfr.r-forge.r-project.org/")
    (synopsis "R bindings to the MPFR library")
    (description
     "This package supports arithmetic (via S4 classes and methods) for
arbitrary precision floating point numbers, including transcendental
functions.  To this end, the package interfaces with the @dfn{Multiple
Precision Floating-Point Reliable} (MPFR) library.")
    (license license:gpl2+)))

(define-public r-rmutil
  (package
    (name "r-rmutil")
    (version "1.1.10")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rmutil" version))
              (sha256
               (base32
                "1yd5gkg4jg3rvqrfl8c5r07lcr37n1p9h1a7b6s45iswd77dg7w1"))))
    (properties `((upstream-name . "rmutil")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://www.commanster.eu/rcode.html")
    (synopsis
     "Utilities for nonlinear regression and repeated measurements models")
    (description
     "This package provides a toolkit of functions for nonlinear regression
and repeated measurements.  It was designated to be imported by other packages
such as @code{gnlm}, @code{stable}, @code{growth}, @code{repeated}, and
@code{event}.")
    (license license:gpl2+)))

(define-public r-assertive-base
  (package
    (name "r-assertive-base")
    (version "0.0-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.base" version))
       (sha256
        (base32
         "07m0ddz092bgbl2fn1yk932h0iajdcqkri632477wl5a1q5r3w2b"))))
    (properties
     `((upstream-name . "assertive.base")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.base")
    (synopsis "Core of the assertive package")
    (description
     "This package provides a minimal set of predicates and assertions used by
the assertive package.  This is mainly for use by other package developers who
want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-properties
  (package
    (name "r-assertive-properties")
    (version "0.0-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.properties" version))
       (sha256
        (base32
         "1pgljbwwbvbl4kc5c8mcv0qbzq3k6fzi29k88811yml263sm92dn"))))
    (properties
     `((upstream-name . "assertive.properties")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; One test fails
             (delete-file
              "tests/testthat/test-is-atomic-recursive-vector.R"))))))
    (propagated-inputs
     (list r-assertive-base))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.properties")
    (synopsis "Assertions to check properties of variables")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of variables, such as length, names and attributes.  This is
mainly for use by other package developers who want to include run-time
testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-numbers
  (package
    (name "r-assertive-numbers")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.numbers" version))
       (sha256
        (base32
         "0jc3ss64j4m7bjydhagwwmka5n7c72vpw4kfcch0m5jvkq5qrqds"))))
    (properties
     `((upstream-name . "assertive.numbers")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.numbers")
    (synopsis "Assertions to check properties of numbers")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of numbers.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-sets
  (package
    (name "r-assertive-sets")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.sets" version))
       (sha256
        (base32
         "1cqvh2syvh5b6d85h601zjmsdbbf3h8q98ids4dfl4frdshpasc7"))))
    (properties
     `((upstream-name . "assertive.sets")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.sets")
    (synopsis "Assertions to check properties of sets")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of sets.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-matrices
  (package
    (name "r-assertive-matrices")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.matrices" version))
       (sha256
        (base32
         "16sykzcndv6y2d43x6v9n7m95kv76364h39kh10w4z0xw6ksfqil"))))
    (properties
     `((upstream-name . "assertive.matrices")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.matrices")
    (synopsis "Assertions to check properties of matrices")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of matrices.  This is mainly for use by other package
developers who want to include run-time testing features in their own
packages.")
    (license license:gpl3+)))

(define-public r-assertive-models
  (package
    (name "r-assertive-models")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.models" version))
       (sha256
        (base32
         "0bn4j4v5qvb2d672cgri61p8d9v258pmz35y3lvm6b9mdxwdi9mr"))))
    (properties
     `((upstream-name . "assertive.models")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.models")
    (synopsis "Assertions to check properties of models")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of models.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-reflection
  (package
    (name "r-assertive-reflection")
    (version "0.0-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.reflection" version))
       (sha256
        (base32
         "1g9lpwzy6r2xmyi2mlbcccnfgyzhzbmx5bsicf3vkffxrlkrpjn2"))))
    (properties
     `((upstream-name . "assertive.reflection")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.reflection")
    (synopsis "Assertions for checking the state of R")
    (description
     "This package provides a set of predicates and assertions for checking
the state and capabilities of R, the operating system it is running on, and
the IDE being used.  This is mainly for use by other package developers who
want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-types
  (package
    (name "r-assertive-types")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.types" version))
       (sha256
        (base32
         "0zxq1jfrzgw95ll7alvm0xnk7aihjdksngq4ya2whyvfjbmv4vdb"))))
    (properties
     `((upstream-name . "assertive.types")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-properties r-codetools))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.types")
    (synopsis "Assertions to check types of variables")
    (description
     "This package provides a set of predicates and assertions for checking
the types of variables.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-files
  (package
    (name "r-assertive-files")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.files" version))
       (sha256
        (base32
         "02pfz8j5vwcj5kl6zca46894li7lxwnlrr29j922f14ay6kdssmy"))))
    (properties
     `((upstream-name . "assertive.files")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Needed for one test.
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-assertive-base r-assertive-numbers))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.files")
    (synopsis "Assertions to check properties of files")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of files and connections.  This is mainly for use by other
package developers who want to include run-time testing features in their own
packages.")
    (license license:gpl3+)))

(define-public r-assertive-code
  (package
    (name "r-assertive-code")
    (version "0.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.code" version))
       (sha256
        (base32
         "11qkhbjyxw0njzhcszyc2452518yrn3jr5l4n9jnzq10xms090ig"))))
    (properties
     `((upstream-name . "assertive.code")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-properties r-assertive-types))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.code")
    (synopsis "Assertions to check properties of code")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of code.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-datetimes
  (package
    (name "r-assertive-datetimes")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.datetimes" version))
       (sha256
        (base32
         "151d05z8n6dpl44pqsa1jfi0ijbigr3zfc43xlw53nd8ymi22kh1"))))
    (properties
     `((upstream-name . "assertive.datetimes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-types))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.datetimes")
    (synopsis "Assertions to check properties of dates and times")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of dates and times.  This is mainly for use by other package
developers who want to include run-time testing features in their own
packages.")
    (license license:gpl3+)))

(define-public r-assertive-strings
  (package
    (name "r-assertive-strings")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.strings" version))
       (sha256
        (base32
         "0n6jrk88670g4ym0r8ii40a08a90z1xadj8wcryk8h0nl04dchfm"))))
    (properties
     `((upstream-name . "assertive.strings")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-types r-stringi))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.strings")
    (synopsis "Assertions to check properties of strings")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of strings.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-data-us
  (package
    (name "r-assertive-data-us")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.data.us" version))
       (sha256
        (base32
         "1bgspn0sccmp9z7s7djvdvprgxlyc5vrxznp4zfjb79kwvgn83hq"))))
    (properties
     `((upstream-name . "assertive.data.us")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-strings))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.data.us")
    (synopsis "Assertions to check properties of strings")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of US-specific complex data types.  This is mainly for use by
other package developers who want to include run-time testing features in
their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-data-uk
  (package
    (name "r-assertive-data-uk")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.data.uk" version))
       (sha256
        (base32
         "1fzjvhwp7mwkqqix29khvs6zcrc82n6j4czvzzb473vyjyvdlj5b"))))
    (properties
     `((upstream-name . "assertive.data.uk")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-strings))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.data.uk")
    (synopsis "Assertions to check properties of strings")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of UK-specific complex data types.  This is mainly for use by
other package developers who want to include run-time testing features in
their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-data
  (package
    (name "r-assertive-data")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.data" version))
       (sha256
        (base32
         "00cvg2g36mdl8plrzx40m63qd55742mddqrchwy9n3c7mm4gn02s"))))
    (properties
     `((upstream-name . "assertive.data")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-strings))
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive.data")
    (synopsis "Assertions to check properties of data")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of (country independent) complex data types.  This is mainly
for use by other package developers who want to include run-time testing
features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive
  (package
    (name "r-assertive")
    (version "0.3-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive" version))
       (sha256
        (base32
         "02palil82idqhhshcdjsfsja9qkqnd0dczqzj5gbccy4hfg1c0y4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base
           r-assertive-code
           r-assertive-data
           r-assertive-data-uk
           r-assertive-data-us
           r-assertive-datetimes
           r-assertive-files
           r-assertive-matrices
           r-assertive-models
           r-assertive-numbers
           r-assertive-properties
           r-assertive-reflection
           r-assertive-sets
           r-assertive-strings
           r-assertive-types
           r-knitr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://bitbucket.org/richierocks/assertive")
    (synopsis "Readable check functions to ensure code integrity")
    (description
     "This package provides lots of predicates (@code{is_*} functions) to
check the state of your variables, and assertions (@code{assert_*} functions)
to throw errors if they aren't in the right form.")
    (license license:gpl3+)))

(define-public r-dotcall64
  (package
    (name "r-dotcall64")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dotCall64" version))
       (sha256
        (base32
         "1ah88h77lc9zb68b3xyk97xpid2pilkywk25m68x3m1h3xbspmma"))))
    (properties `((upstream-name . "dotCall64")))
    (build-system r-build-system)
    (native-inputs (list gfortran r-rhpcblasctl r-testthat))
    (home-page "https://git.math.uzh.ch/reinhard.furrer/dotCall64")
    (synopsis "Enhanced foreign function interface supporting long vectors")
    (description
     "This package provides @code{.C64()}, an enhanced version of @code{.C()}
and @code{.Fortran()} from the R foreign function interface.  @code{.C64()}
supports long vectors, arguments of type 64-bit integer, and provides a
mechanism to avoid unnecessary copies of read-only and write-only arguments.
This makes it a convenient and fast interface to C/C++ and Fortran code.")
    (license license:gpl2+)))

(define-public r-spam
  (package
    (name "r-spam")
    (version "2.11-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spam" version))
       (sha256
        (base32 "02ax6fnzymdkn868w341xznbgb3fmrvb9pqqfpcrh5fldp0acjfq"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; One test fails with: could not find function "quilt.plot"
             (delete-file "tests/testthat/test-rmvnorm.R")))
         (add-before 'check 'set-HOME
           (lambda _
             ;; Needed for building vignettes.
             (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-dotcall64 r-rcpp))
    (native-inputs
     (list gfortran r-knitr r-r-rsp r-testthat r-truncdist))
    (home-page "https://www.math.uzh.ch/pages/spam/")
    (synopsis "Sparse matrix algebra")
    (description
     "This package provides a set of functions for sparse matrix algebra.
Differences with other sparse matrix packages are:

@enumerate
@item it only supports (essentially) one sparse matrix format;
@item it is based on transparent and simple structure(s);
@item it is tailored for MCMC calculations within G(M)RF;
@item and it is fast and scalable (with the extension package @code{spam64}).
@end enumerate\n")
    ;; Either of these licenses
    (license (list license:bsd-3 license:lgpl2.0))))

(define-public r-fields
  (package
    (name "r-fields")
    (version "16.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fields" version))
       (sha256
        (base32 "14kbl97fmiqm2q8wfyizmpl5zlbj7yakkpmsl8zgckxrzg0a1dyb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-maps r-spam r-viridislite))
    (native-inputs
     (list gfortran))
    (home-page "https://www.image.ucar.edu/fields")
    (synopsis "Tools for spatial data")
    (description
     "This is a package for curve, surface and function fitting with an
emphasis on splines, spatial data and spatial statistics.  The major methods
include cubic, and thin plate splines, Kriging, and compactly supported
covariance functions for large data sets.")
    (license license:gpl2+)))

(define-public r-spatialextremes
  (package
    (name "r-spatialextremes")
    (version "2.1-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SpatialExtremes" version))
       (sha256
        (base32
         "0z1swxp1syz8hdskarjxx4sdd7wx835kcnb783bwqm235yh991j3"))))
    (properties
     `((upstream-name . "SpatialExtremes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fields r-maps))
    (home-page "https://spatialextremes.r-forge.r-project.org/")
    (synopsis "Modelling spatial extremes")
    (description
     "This package provides tools for the statistical modelling of spatial
extremes using max-stable processes, copula or Bayesian hierarchical models.
More precisely, this package allows (conditional) simulations from various
parametric max-stable models, analysis of the extremal spatial dependence, the
fitting of such processes using composite likelihoods or least square (simple
max-stable processes only), model checking and selection and prediction.")
    (license license:gpl2+)))

(define-public r-drc
  (package
    (name "r-drc")
    (version "3.0-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "drc" version))
       (sha256
        (base32
         "0c8xn8ripzq270hy8d16fcnx02l02alddznd7fqwk3jyi6113h1y"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-gtools
           r-mass
           r-multcomp
           r-plotrix
           r-scales))
    (home-page "https://cran.r-project.org/web/packages/drc")
    (synopsis "Analysis of dose-response curves")
    (description
     "This package provides a suite of flexible and versatile model fitting
and after-fitting functions for the analysis of dose-response data.")
    (license license:gpl2+)))

(define-public r-rmeta
  (package
    (name "r-rmeta")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmeta" version))
       (sha256
        (base32
         "0vkbnxp579v8zmcv1isdbzj5swpr6fq17zwparxcvzswjc2x9ydr"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rmeta")
    (synopsis "Tools for meta-analysis")
    (description
     "This package provides functions for simple fixed and random effects
meta-analysis for two-sample comparisons and cumulative meta-analyses.  It
draws standard summary plots, funnel plots, and computes summaries and tests
for association and heterogeneity.")
    (license license:gpl2)))

(define-public r-bootstrap
  (package
    (name "r-bootstrap")
    (version "2019.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bootstrap" version))
       (sha256
        (base32
         "1546jqhhw5h177ii8jkdikyd26rv6gwkav816np1zks4p7zgsljj"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/bootstrap")
    (synopsis "Functions for the book \"An Introduction to the Bootstrap\"")
    (description
     "This package provides software and data for the book \"An Introduction
to the Bootstrap\" by B. Efron and R. Tibshirani, 1993, Chapman and Hall.
This package is primarily provided for projects already based on it, and for
support of the book.  New projects should preferentially use the recommended
package \"boot\".")
    (license license:bsd-3)))

(define-public r-survivalroc
  (package
    (name "r-survivalroc")
    (version "1.0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "survivalROC" version))
       (sha256
        (base32
         "0p6irjs8a9xxgxwax0y9fzapcib237if3iy8g6lzv793mzmsyx41"))))
    (properties `((upstream-name . "survivalROC")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/survivalROC")
    (synopsis "Time-dependent ROC curve estimation from censored survival data")
    (description
     "Compute time-dependent ROC curve from censored survival data using
Kaplan-Meier (KM) or Nearest Neighbor Estimation (NNE) method of Heagerty,
Lumley & Pepe (Biometrics, Vol 56 No 2, 2000, PP 337-344)")
    (license license:gpl2+)))

(define-public r-locfdr
  (package
    (name "r-locfdr")
    (version "1.1-8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "locfdr" version))
              (sha256
               (base32
                "1falkbp2xz07am8jlhwlvyqvxnli4nwl188kd0g58vdfjcjy3mj2"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/locfdr/")
    (synopsis "Computes local false discovery rates")
    (description "This package can be used to compute local false
discovery rates.")
    (license license:gpl2)))

(define-public r-logging
  (package
    (name "r-logging")
    (version "0.10-108")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "logging" version))
              (sha256
               (base32
                "13gd40ygx586vs6xcp6clg69a92aj8zxlk1rn3xzkx8klfjimjc5"))))
    (properties `((upstream-name . "logging")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/WLOGSolutions/r-logging")
    (synopsis "R logging implementation of log4j")
    (description
     "This package implements the R version of the @code{log4j} package.  It offers
hierarchic loggers, multiple handlers per logger, level based filtering, space
handling in messages and custom formatting.")
    (license license:gpl3)))

(define-public r-logistf
  (package
    (name "r-logistf")
    (version "1.26.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "logistf" version))
              (sha256
               (base32
                "02qrh07c13khlpz3z3f6qq827h37j91i88n7jn3c8ky6r1lfa5pr"))))
    (properties `((upstream-name . "logistf")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula-tools r-matrix r-mgcv r-mice))
    (home-page
     "https://cemsiis.meduniwien.ac.at/en/kb/science-research\
/software/statistical-software/firth-correction/")
    (synopsis "Firth's bias-reduced logistic regression")
    (description
     "Fit a logistic regression model using Firth's bias reduction method,
equivalent to penalization of the log-likelihood by the Jeffreys prior.
Confidence intervals for regression coefficients can be computed by penalized
profile likelihood.  Firth's method was proposed as ideal solution to the
problem of separation in logistic regression, see Heinze and Schemper (2002)
<doi:10.1002/sim.1047>.  If needed, the bias reduction can be turned off such
that ordinary maximum likelihood logistic regression is obtained.  Two new
modifications of Firth's method, FLIC and FLAC, lead to unbiased predictions
and are now available in the package as well, see Puhr et al (2017)
<doi:10.1002/sim.7273>.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-longdat
  (package
    (name "r-longdat")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "LongDat" version))
              (sha256
               (base32
                "1rzkb7byd32jqvhf75zyvy0dlkq79aicz8j0x7lk821qiq4dfv6l"))))
    (properties `((upstream-name . "LongDat")))
    (build-system r-build-system)
    (propagated-inputs (list r-bestnormalize
                             r-car
                             r-dplyr
                             r-effsize
                             r-emmeans
                             r-ggplot2
                             r-glmmtmb
                             r-lme4
                             r-magrittr
                             r-mass
                             r-patchwork
                             r-reshape2
                             r-rlang
                             r-rstatix
                             r-stringr
                             r-tibble
                             r-tidyr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/CCY-dev/LongDat")
    (synopsis
     "Tool for covariate-sensitive longitudinal analysis on omics data")
    (description
     "This tool takes longitudinal dataset as input and analyzes if there is
significant change of the features over time (a proxy for treatments), while
detects and controls for covariates simultaneously.  LongDat is able to take
in several data types as input, including count, proportion, binary, ordinal
and continuous data.  The output table contains p values, effect sizes and
covariates of each feature, making the downstream analysis easy.")
    (license license:gpl2)))

(define-public r-longitudinal
  (package
    (name "r-longitudinal")
    (version "1.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "longitudinal" version))
       (sha256
        (base32
         "046w3xbr535c5jyd68adv42a7limxp1mv57b5w6w673w707lmw2p"))))
    (build-system r-build-system)
    (propagated-inputs (list r-corpcor))
    (home-page "https://strimmerlab.org/software/longitudinal/")
    (synopsis "Analysis of multiple time course data")
    (description
     "This package contains general data structures and functions for
longitudinal data with multiple variables, repeated measurements, and
irregularly spaced time points.  It also implements a shrinkage estimator of
dynamical correlation and dynamical covariance.")
    (license license:gpl3+)))

(define-public r-genenet
  (package
    (name "r-genenet")
    (version "1.2.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GeneNet" version))
       (sha256
        (base32
         "1r1khga3nxxjghs4vnbymzp0cwb1q17zw2v3a94qz8fsrirq1sf1"))))
    (properties `((upstream-name . "GeneNet")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-corpcor r-fdrtool r-longitudinal))
    (home-page "https://strimmerlab.org/software/genenet/")
    (synopsis "Modeling and inferring gene networks")
    (description
     "This package analyzes gene expression (time series) data with focus on
the inference of gene networks.  In particular, GeneNet implements the methods
of Schaefer and Strimmer (2005a,b,c) and Opgen-Rhein and Strimmer (2006, 2007)
for learning large-scale gene association networks (including assignment of
putative directions).")
    (license license:gpl3+)))

(define-public r-rbamtools
  (package
    (name "r-rbamtools")
    (version "2.16.17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rbamtools" version))
       (sha256
        (base32
         "0qj37ljdva3v29s01dkrbg31mcfzy3bl145cp40d54v4h9xhcghc"))))
    (build-system r-build-system)
    ;; FIXME: Error in genomePartition(reader, ref) : pCoords: begin must be
    ;; <= end!
    (arguments (list #:tests? #false))
    (inputs (list zlib))
    (propagated-inputs
     (list r-refgenome))
    (home-page "https://cran.r-project.org/web/packages/rbamtools")
    (synopsis "Read and write BAM (binary alignment) files")
    (description
     "This package provides an R interface to functions of the SAMtools
library.")
    (license license:artistic2.0)))

(define-public r-profvis
  (package
    (name "r-profvis")
    (version "0.4.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "profvis" version))
              (sha256
               (base32
                "1x2cpykcmq5a30c0mf22h2pnnanqij0yqjv3q33xzx11c07fpzfj"))
              (modules '((guix build utils)))
              (snippet
               '(with-directory-excursion "inst/htmlwidgets/lib"
                  (for-each delete-file
                            (list "highlight/highlight.min.js" ;version 11.10.0
                                  "jquery/jquery.min.js"       ;version 3.7.1
                                  "d3/d3.min.js"))))))         ;version 3.5.6
    (properties `((upstream-name . "profvis")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      '(modify-phases (@ (guix build r-build-system) %standard-phases)
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/"
               (copy-file
                (search-input-file
                 inputs "/site-library/rmarkdown/rmd/h/highlightjs/highlight.js")
                "highlight/highlight.min.js")
               (for-each (match-lambda
                           ((source . target)
                            (minify source #:target target)))
                         `((,(assoc-ref inputs "js-jquery")
                            . "jquery/jquery.min.js")
                           (,(assoc-ref inputs "js-d3")
                            . "d3/d3.min.js")))))))))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("r-knitr" ,r-knitr)
       ("r-rmarkdown" ,r-rmarkdown)
       ("r-testthat" ,r-testthat)
       ("js-d3"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/d3/d3/v3.5.6/d3.js")
           (sha256
            (base32
             "17qlbwn7vgx335gciq6zp2ib6zg1r9lfa6p1bd9g0ds0xbcsbvgd"))))
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-3.7.1.js")
           (sha256
            (base32
             "1zicjv44sx6n83vrkd2lwnlbf7qakzh3gcfjw0lhq48b5z55ma3q"))))))
    (propagated-inputs
     (list r-htmlwidgets r-rlang r-vctrs))
    (home-page "https://rstudio.github.io/profvis/")
    (synopsis "Interactive visualizations for profiling R code")
    (description "This package provides interactive visualizations for
profiling R code.")
    (license license:gpl3)))

(define-public r-prospectr
  (package
    (name "r-prospectr")
    (version "0.2.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "prospectr" version))
              (sha256
               (base32
                "0hg2afw5aixx0xdwwr6g0wi8sksn7r21hz8diyqxg2345rwnzbg4"))))
    (properties `((upstream-name . "prospectr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach
           r-iterators
           r-lifecycle
           r-mathjaxr
           r-rcpp
           r-rcpparmadillo))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/l-ramirez-lopez/prospectr")
    (synopsis "Functions for processing and sample selection of spectroscopic data")
    (description
     "@code{prospectr} provides miscellaneous functions to preprocess
spectroscopic data and conduct representative sample selection, or calibration
sampling.")
    (license license:expat)))

(define-public r-protviz
  (package
    (name "r-protviz")
    (version "0.7.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "protViz" version))
       (sha256
        (base32
         "1wsjr4asjsknv8fkfv15xqnl67zfv8d2xmvw1i2l0wflxbps3af7"))))
    (properties `((upstream-name . "protViz")))
    (build-system r-build-system)
    ;; One vignette file fails with: parameter "i" in "mfg" is out of range
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-lattice r-testthat r-xtable))
    (home-page "https://github.com/protViz/protViz/")
    (synopsis "Visualizing and analyzing mass spectrometry data in proteomics")
    (description
     "This package helps with quality checks, visualizations and analysis of
mass spectrometry data, coming from proteomics experiments.  The package is
developed, tested and used at the Functional Genomics Center Zurich, where it
is used mainly for prototyping, teaching, and having fun with proteomics data.
But it can also be used to do data analysis for small scale data sets.")
    (license license:gpl3)))

(define-public r-cmprsk
  (package
    (name "r-cmprsk")
    (version "2.2-12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cmprsk" version))
       (sha256
        (base32 "1p5c0i8prz88pgzb5dwpajlrxa0d72019sp9vysppb0fps9wngkp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-survival))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/cmprsk")
    (synopsis "Subdistribution analysis of competing risks")
    (description
     "This package provides tool for estimation, testing and regression
modeling of subdistribution functions in competing risks, as described in
Gray (1988), A class of K-sample tests for comparing the cumulative incidence
of a competing risk, Ann. Stat. 16:1141-1154, and Fine JP and Gray RJ (1999),
A proportional hazards model for the subdistribution of a competing risk,
JASA, 94:496-509.")
    (license license:gpl2+)))

(define-public r-etm
  (package
    (name "r-etm")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "etm" version))
       (sha256
        (base32
         "1hvrplmdpjjpjji663rw0vjbbrzj2nvr04d1nkc8bf46p4ixyxgy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table r-lattice r-rcpp r-rcpparmadillo r-survival))
    (home-page "https://cran.r-project.org/web/packages/etm")
    (synopsis "Empirical transition matrix")
    (description
     "The @dfn{empirical transition matrix} (etm) package estimates
the matrix of transition probabilities for any time-inhomogeneous multistate
model with finite state space using the Aalen-Johansen estimator.")
    (license license:expat)))

(define-public r-epi
  (package
    (name "r-epi")
    (version "2.56")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Epi" version))
       (sha256
        (base32
         "0s5wskp7f18zn5f7w3s89adkrpl8mgn2dw8v5c000gim31i3qk7l"))))
    (properties `((upstream-name . "Epi")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cmprsk
           r-data-table
           r-dplyr
           r-etm
           r-magrittr
           r-mass
           r-matrix
           r-mgcv
           r-numderiv
           r-plyr
           r-survival
           r-zoo))
    (home-page "https://BendixCarstensen.com/Epi/")
    (synopsis "Statistical analysis in epidemiology")
    (description
     "This package provides functions for demographic and epidemiological
analysis in the Lexis diagram, i.e. register and cohort follow-up data, in
particular representation, manipulation and simulation of multistate data -
the Lexis suite of functions, which includes interfaces to the @code{mstate},
@code{etm} and @code{cmprsk} packages.  It also contains functions for
Age-Period-Cohort and Lee-Carter modeling and a function for interval censored
data and some useful functions for tabulation and plotting, as well as a
number of epidemiological data sets.")
    (license license:gpl2)))

(define-public r-ppls
  (package
    (name "r-ppls")
    (version "1.6-1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ppls" version))
       (sha256
        (base32
         "1zyrisy3c4cz896j1bjh61sf57wdl9p8ywdq268cl819szfq78mx"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/ppls")
    (synopsis "Penalized partial least squares")
    (description
     "This package contains linear and nonlinear regression methods based on
partial least squares and penalization techniques.  Model parameters are
selected via cross-validation, and confidence intervals ans tests for the
regression coefficients can be conducted via jackknifing.")
    (license license:gpl2+)))

(define-public r-huge
  (package
    (name "r-huge")
    (version "1.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "huge" version))
       (sha256
        (base32 "1sl457a1lndrx98y2j9a2smanawx2iqlhl82iand0g3p5xp8ch4j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-mass r-matrix r-rcpp r-rcppeigen))
    (home-page "https://cran.r-project.org/web/packages/huge")
    (synopsis "High-dimensional undirected graph estimation")
    (description
     "This package provides a general framework for high-dimensional
undirected graph estimation.  It integrates data preprocessing, neighborhood
screening, graph estimation, and model selection techniques into a pipeline.")
    (license license:gpl2)))

(define-public r-parcor
  (package
    (name "r-parcor")
    (version "0.2-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parcor" version))
       (sha256
        (base32
         "0vgs6k92vdr0cmb8cwbv2ff6qavw30agskfd8bfh17hsskrisvx0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-epi r-genenet r-glmnet r-mass r-ppls))
    (home-page "https://cran.r-project.org/web/packages/parcor")
    (synopsis "Regularized estimation of partial correlation matrices")
    (description
     "This package estimates the matrix of partial correlations based on
different regularized regression methods: lasso, adaptive lasso, PLS, and
Ridge Regression.  In addition, the package provides model selection for
lasso, adaptive lasso and Ridge regression based on cross-validation.")
    (license license:gpl2+)))

(define-public r-mcmc
  (package
    (name "r-mcmc")
    (version "0.9-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mcmc" version))
       (sha256
        (base32
         "19vfh868lr4a491gc2x2b2xs83gldw294zbl4bqsgs2q9c6l81ka"))))
    (build-system r-build-system)
    ;; XXX On the build farm the vignettes time out.
    (arguments (list #:test-types '(list "tests")))
    (native-inputs (list r-iso r-xtable))
    (home-page "https://www.stat.umn.edu/geyer/mcmc/")
    (synopsis "Markov chain Monte Carlo")
    (description
     "This package simulates continuous distributions of random vectors using
@dfn{Markov chain Monte Carlo} (MCMC).  Users specify the distribution by an R
function that evaluates the log unnormalized density.  Algorithms are random
walk Metropolis algorithm (function @code{metrop}), simulated
tempering (function @code{temper}), and morphometric random walk
Metropolis (function @code{morph.metrop}), which achieves geometric ergodicity
by change of variable.")
    (license license:expat)))

(define-public r-listenv
  (package
    (name "r-listenv")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "listenv" version))
       (sha256
        (base32
         "0fqwikd3z6n5mia55s3fn5wxnmf2vbw3cmf0hcmm3iligd4ayaj2"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list r-r-rsp)) ; vignette builder
    (home-page "https://github.com/HenrikBengtsson/listenv")
    (synopsis "Environments behaving (almost) as lists")
    (description
     "This package implements list environments.  List environments are
environments that have list-like properties.  For instance, the elements of a
list environment are ordered and can be accessed and iterated over using index
subsetting.")
    (license license:lgpl2.1+)))

(define-public r-globals
  (package
    (name "r-globals")
    (version "0.16.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "globals" version))
       (sha256
        (base32
         "0nwcl40sbmmf812di9c3lryls9wn2k2dyjvpkp9832wd4jafsg6p"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-codetools))
    (home-page "https://github.com/HenrikBengtsson/globals")
    (synopsis "Identify global objects in R expressions")
    (description
     "This package provides tools to identify global (\"unknown\" or \"free\")
objects in R expressions by code inspection using various strategies, e.g.
conservative or liberal.  The objective of this package is to make it as
simple as possible to identify global objects for the purpose of exporting
them in distributed compute environments.")
    (license license:lgpl2.1+)))

(define-public r-parallelly
  (package
    (name "r-parallelly")
    (version "1.39.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parallelly" version))
       (sha256
        (base32
         "0caql3iyzcx5ihxqbnvar6p75miwh8r97kzwbrrqyv5wzr56cmvq"))))
    (properties `((upstream-name . "parallelly")))
    (build-system r-build-system)
    (home-page "https://github.com/HenrikBengtsson/parallelly")
    (synopsis "Enhancements of the parallel package")
    (description
     "This package provides utility functions that enhance the @code{parallel}
package and support the built-in parallel backends of the @code{future}
package.  For example, @code{availableCores} gives the number of CPU cores
available to your R process as given by R options and environment variables,
including those set by job schedulers on high-performance compute clusters.
If none is set, it will fall back to @code{parallel::detectCores}.  Another
example is @code{makeClusterPSOCK}, which is backward compatible with
@code{parallel::makePSOCKcluster} while doing a better job in setting up
remote cluster workers without the need for configuring the firewall to do
port-forwarding to your local computer.")
    (license license:lgpl2.1+)))

(define-public r-future
  (package
    (name "r-future")
    (version "1.34.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "future" version))
       (sha256
        (base32
         "0pgs5n5pqqr3jg71nswjrl5did9bxg0m0z3sn8c1pswb3zyx8faq"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-digest r-globals r-listenv r-parallelly))
    (native-inputs
     (list r-r-rsp)) ; vignette builder
    (home-page "https://github.com/HenrikBengtsson/future")
    (synopsis "Unified parallel and distributed processing in R")
    (description
     "The purpose of this package is to provide a lightweight and unified
Future API for sequential and parallel processing of R expression via futures.
This package implements sequential, multicore, multisession, and cluster
futures.  With these, R expressions can be evaluated on the local machine, in
parallel a set of local machines, or distributed on a mix of local and remote
machines.  Extensions to this package implement additional backends for
processing futures via compute cluster schedulers etc.  Because of its unified
API, there is no need to modify any code in order to switch from sequential on
the local machine to, say, distributed processing on a remote compute cluster.")
    (license license:lgpl2.1+)))

(define-public r-future-apply
  (package
    (name "r-future-apply")
    (version "1.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "future.apply" version))
       (sha256
        (base32
         "1l45vc30fn4kr5v49nnh5bkixa9ff006cp9sh9qiss76162qbs76"))))
    (properties `((upstream-name . "future.apply")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-future r-globals))
    (native-inputs
     (list r-r-rsp)) ; vignette builder
    (home-page "https://github.com/HenrikBengtsson/future.apply")
    (synopsis "Apply function to elements in parallel using futures")
    (description
     "This package provides implementations of @code{apply()},
@code{eapply()}, @code{lapply()}, @code{Map()}, @code{mapply()},
@code{replicate()}, @code{sapply()}, @code{tapply()}, and @code{vapply()} that
can be resolved using any future-supported backend, e.g. parallel on the local
machine or distributed on a compute cluster.")
    (license license:gpl2+)))

(define-public r-future-callr
  (package
    (name "r-future-callr")
    (version "0.8.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "future.callr" version))
              (sha256
               (base32
                "14hq53cam65ff25l6y17zv37448ls90sa0w51f13199m1kffaaqb"))))
    (properties
     '((upstream-name . "future.callr")
       (updater-extra-native-inputs . ("r-markdown"))))
    (build-system r-build-system)
    ;; This is needed for the vignette builder R.rsp.
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-HOME
            (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs (list r-callr r-future))
    (native-inputs (list r-markdown r-r-rsp))
    (home-page "https://future.callr.futureverse.org")
    (synopsis "Future API for Parallel Processing using 'callr'")
    (description
     "This is an implementation of the Future API on top of the callr package.
This allows you to process futures, as defined by the future package, in
parallel out of the box, on your local machine.  Contrary to backends relying
on the parallel package (e.g. @code{future::multisession}) and socket
connections, the callr backend provided here can run more than 125 parallel R
processes.")
    (license license:lgpl2.1+)))

(define-public r-rsvd
  (package
    (name "r-rsvd")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rsvd" version))
       (sha256
        (base32
         "07p2hjmpcwcsang8z9sjkpy94rydcin7m3hyvcgzgm5cd6w8c1p4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/erichson/rSVD")
    (synopsis "Randomized singular value decomposition")
    (description
     "Low-rank matrix decompositions are fundamental tools and widely used for
data analysis, dimension reduction, and data compression.  Classically, highly
accurate deterministic matrix algorithms are used for this task.  However, the
emergence of large-scale data has severely challenged our computational
ability to analyze big data.  The concept of randomness has been demonstrated
as an effective strategy to quickly produce approximate answers to familiar
problems such as the @dfn{singular value decomposition} (SVD).  This package
provides several randomized matrix algorithms such as the randomized singular
value decomposition (@code{rsvd}), randomized principal component
analysis (@code{rpca}), randomized robust principal component
analysis (@code{rrpca}), randomized interpolative decomposition (@code{rid}),
and the randomized CUR decomposition (@code{rcur}).  In addition several plot
functions are provided.")
    (license license:gpl3+)))

(define-public r-sloop
  (package
    (name "r-sloop")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sloop" version))
       (sha256
        (base32
         "00fk5fr5zsk2qxc1kfhmshhjxgnamm3401089sx8m2l529zd6r8j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-codetools r-crayon r-purrr r-rlang r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-lib/sloop")
    (synopsis "Helpers for object-oriented programming in R")
    (description
     "This package provides a collection of helper functions designed to
help you to better understand object oriented programming in R, particularly
using @code{S3}.")
    (license license:gpl3)))

(define-public r-capushe
  (package
    (name "r-capushe")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "capushe" version))
       (sha256
        (base32
         "1mazsfdiqmhy0ywahqw49qql899ph0l6jllriz2spyp1bs98q9b7"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/capushe/index.html")
    (synopsis "Calibrating penalties using slope heuristics")
    (description
     "This package provides tools for the calibration of penalized criteria
for model selection.  The calibration methods available are based on the slope
heuristics.")
    (license license:gpl2+)))

(define-public r-dorng
  (package
    (name "r-dorng")
    (version "1.8.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doRNG" version))
       (sha256
        (base32
         "1qkxa3jxpnn5anhqycqcbk18kw87m9pl5m78q8d89ygihghascjh"))))
    (properties `((upstream-name . "doRNG")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach r-iterators r-rngtools))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://renozao.github.io/doRNG/")
    (synopsis "Generic reproducible parallel backend for foreach loops")
    (description
     "This package provides functions to perform reproducible parallel
@code{foreach} loops, using independent random streams as generated by
L'Ecuyer's combined multiple-recursive generator.  It enables to easily
convert standard @code{%dopar%} loops into fully reproducible loops,
independently of the number of workers, the task scheduling strategy, or the
chosen parallel environment and associated foreach backend.")
    (license license:gpl2+)))

(define-public r-blockmodeling
  (package
    (name "r-blockmodeling")
    (version "1.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "blockmodeling" version))
       (sha256
        (base32
         "00qmpf0jdc8vl76rzfg12z2mdr215q8qd9p3a4b816y2g0092vrv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/blockmodeling")
    (synopsis "Generalized and classical blockmodeling of valued networks")
    (description
     "This package is primarily meant as an implementation of generalized
blockmodeling for valued networks.  In addition, measures of similarity or
dissimilarity based on structural equivalence and regular equivalence (REGE
algorithms) can be computed and partitioned matrices can be plotted.")
    (license license:gpl2+)))

(define-public r-upsetr
  (package
    (name "r-upsetr")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "UpSetR" version))
       (sha256
        (base32
         "007i0njnjjy7vbrxabwav7a1kk2n0hn2mkvqsdzzfk10ckp5y7im"))))
    (properties `((upstream-name . "UpSetR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridextra r-plyr r-scales))
    (home-page "https://github.com/hms-dbmi/UpSetR")
    (synopsis "Visualize intersecting sets")
    (description
     "This package provides a more scalable alternative to Venn and Euler
diagrams for visualizing intersecting sets.  Create visualizations of
intersecting sets using a novel matrix design, along with visualizations of
several common set, element and attribute related tasks.")
    (license license:expat)))

(define-public r-shinycustomloader
  (package
    (name "r-shinycustomloader")
    (version "0.9.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "shinycustomloader" version))
              (sha256
               (base32
                "1klx71vr26g0gjf6hbiia1qidqii5d467i1sdjvlrg1hxdcggqff"))))
    (properties `((upstream-name . "shinycustomloader")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-glue
           r-shiny))
    (home-page "https://cran.r-project.org/package=shinycustomloader")
    (synopsis "Custom loader for Shiny outputs")
    (description
     "This package provides a custom @code{CSS/HTML} or @code{GIF/image} file
for the loading screen in R @code{Shiny}.  It also can use the marquee to have
a custom text loading screen.")
    (license license:gpl3)))

;; This package includes a JavaScript file, which is not minified.  When
;; upgrading please check that there are no new minified JavaScript files.
(define-public r-shinybs
  (package
    (name "r-shinybs")
    (version "0.61.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyBS" version))
       (sha256
        (base32
         "0h51685a9qll4agayldjyryi60ih969219ibg071slv0613p5v8a"))))
    (properties `((upstream-name . "shinyBS")))
    (build-system r-build-system)
    ;; The tests spawn Shiny browser apps.  They cannot be run
    ;; non-interactively.
    (arguments '(#:tests? #f))
    (propagated-inputs
     (list r-htmltools r-shiny))
    (home-page "https://ebailey78.github.io/shinyBS/")
    (synopsis "Twitter Bootstrap components for Shiny")
    (description
     "This package adds additional Twitter Bootstrap components to Shiny.")
    (license license:gpl3)))

(define-public r-shinyjqui
  (package
    (name "r-shinyjqui")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyjqui" version))
       (sha256
        (base32
         "135gwz7syyb6pbn0lkvmq0v1c6r1zivavnqhi1rnzbbzlysi27v1"))
       (snippet
        '(for-each delete-file
                   (list "inst/www/shinyjqui.min.js"
                         "inst/www/jquery.ui.touch-punch.min.js")))))
    (properties `((upstream-name . "shinyjqui")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/www"
               (let ((mapping
                      `((,(string-append (assoc-ref inputs "js-jquery.ui.touch-punch")
                                         "/jquery.ui.touch-punch.js")
                         . "jquery.ui.touch-punch.min.js")
                        ("shinyjqui.js"
                         . "shinyjqui.min.js"))))
                 (for-each (lambda (source target)
                             (format #true "Processing ~a --> ~a~%"
                                     source target)
                             (invoke "esbuild" source "--minify"
                                     (string-append "--outfile=" target)))
                           (map car mapping)
                           (map cdr mapping)))))))))
    (propagated-inputs
     (list r-htmltools r-htmlwidgets r-jsonlite r-rlang r-shiny))
    (native-inputs
     `(("r-knitr" ,r-knitr)
       ("esbuild" ,esbuild)
       ("js-jquery.ui.touch-punch"
        ,(origin
           (method git-fetch)
           (uri (git-reference
                 (url "https://github.com/furf/jquery-ui-touch-punch")
                 (commit "8f7559b6e65cdc3ee3648d5fe76d38c653f87ff5")))
           (sha256
            (base32
             "1lzywp2q9hwx6d5fqjla95vp7ra2lahr5dam7lsqjmch9d98r48q"))))))
    (home-page "https://github.com/yang-tang/shinyjqui")
    (synopsis "jQuery UI interactions and effects for Shiny")
    (description
     "This is an extension to Shiny that brings interactions and animation
effects from the jQuery UI library.")
    (license license:expat)))

(define-public r-shinymanager
  (package
    (name "r-shinymanager")
    (version "1.0.410")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinymanager" version))
       (sha256
        (base32 "0nl672dgwj34wm4i3pxk28lv6qw9xsgg3hm0h78q3zdgk8a33kdn"))))
    (properties `((upstream-name . "shinymanager")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-billboarder
           r-dbi
           r-dt
           r-htmltools
           r-openssl
           r-r-utils
           r-r6
           r-rsqlite
           r-scrypt
           r-shiny))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/datastorm-open/shinymanager")
    (synopsis "Authentication management for Shiny applications")
    (description
     "This package provides simple and secure authentication mechanism for
single Shiny applications.  Credentials are stored in an encrypted SQLite
database.")
    (license license:gpl3)))

(define-public r-outliers
  (package
    (name "r-outliers")
    (version "0.15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "outliers" version))
       (sha256
        (base32
         "1yrmwvjjb0a6sbx940k9svf23cykcxz8rrwcgyic7lpgzbrdfcfc"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/outliers/index.html")
    (synopsis "Tests for outliers")
    (description
     "This package provides a collection of some tests commonly used for
identifying outliers.")
    (license license:gpl2+)))

(define-public r-bayesm
  (package
    (name "r-bayesm")
    (version "3.1-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bayesm" version))
       (sha256
        (base32 "1d9wp7yr5hadyv48f51xqa5yzfnhh01n813sivwla209vjf2pmqp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo))
    (native-inputs (list r-knitr))
    (home-page "https://www.perossi.org/home/bsm-1")
    (synopsis "Bayesian inference for marketing/micro-econometrics")
    (description
     "This package covers many important models used in marketing and
micro-econometrics applications, including Bayes Regression (univariate or
multivariate dep var), Bayes Seemingly Unrelated Regression (SUR), Binary and
Ordinal Probit, Multinomial Logit (MNL) and Multinomial Probit (MNP),
Multivariate Probit, Negative Binomial (Poisson) Regression, Multivariate
Mixtures of Normals (including clustering), Dirichlet Process Prior Density
Estimation with normal base, Hierarchical Linear Models with normal prior and
covariates, Hierarchical Linear Models with a mixture of normals prior and
covariates, Hierarchical Multinomial Logits with a mixture of normals prior
and covariates, Hierarchical Multinomial Logits with a Dirichlet Process prior
and covariates, Hierarchical Negative Binomial Regression Models, Bayesian
analysis of choice-based conjoint data, Bayesian treatment of linear
instrumental variables models, Analysis of Multivariate Ordinal survey data
with scale usage heterogeneity, and Bayesian Analysis of Aggregate Random
Coefficient Logit Models.")
    (license license:gpl2+)))

(define-public r-tensora
  (package
    (name "r-tensora")
    (version "0.36.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tensorA" version))
       (sha256
        (base32
         "1dvxc4d5c8k3mqkx6bjgfmnb98rrdd1rsazyva76mzvxzrhq4n06"))))
    (properties `((upstream-name . "tensorA")))
    (build-system r-build-system)
    (home-page "http://www.stat.boogaart.de/tensorA")
    (synopsis "Advanced tensor arithmetic with named indices")
    (description
     "This package provides convenience functions for advanced linear algebra
with tensors and computation with datasets of tensors on a higher level
abstraction.  It includes Einstein and Riemann summing conventions, dragging,
co- and contravariate indices, and parallel computations on sequences of
tensors.")
    (license license:gpl2+)))

(define-public r-tester
  (package
    (name "r-tester")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tester" version))
       (sha256
        (base32 "02q2l0c38ddzlh2jwbzkcyhh2k5a4gnfm8khl8cqvjkjhldi9j5y"))))
    (properties `((upstream-name . "tester")))
    (build-system r-build-system)
    ;; FIXME Tests fail with: could not find function "context"
    (arguments (list #:tests? #false))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://fbertran.github.io/tester/")
    (synopsis "Tests and checks characteristics of R objects")
    (description "This package allows users to test characteristics of common
R objects.")
    (license license:gpl3)))

(define-public r-testit
  (package
    (name "r-testit")
    (version "0.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "testit" version))
       (sha256
        (base32 "104dcxdmzgj340mwk4lpw1y6j1xc4rv4a2v09ckx3nvbmdl73m4h"))))
    (properties `((upstream-name . "testit")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Tests need it.
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (home-page "https://github.com/yihui/testit")
    (synopsis "Simple package for testing R packages")
    (description
     "This package provides two convenience functions @code{assert()} and
@code{test_pkg()} to facilitate testing R packages.")
    (license license:gpl3)))

(define-public r-rarpack
  (package
    (name "r-rarpack")
    (version "0.11-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rARPACK" version))
       (sha256
        (base32
         "12h2y46xcfldhjdmm960swgn9b23zvkj5vg2bi42s9qxwgi02d63"))))
    (properties `((upstream-name . "rARPACK")))
    (build-system r-build-system)
    (propagated-inputs (list r-rspectra))
    (home-page "https://github.com/yixuan/rARPACK")
    (synopsis "Solvers for large scale eigenvalue and SVD problems")
    (description
     "This package was previously an R wrapper of the ARPACK library, and now
a shell of the R package RSpectra, an R interface to the Spectra library for
solving large scale eigenvalue/vector problems.  The current version of
rARPACK simply imports and exports the functions provided by RSpectra.  New
users of rARPACK are advised to switch to the RSpectra package.")
    (license license:bsd-3)))

(define-public r-compositions
  (package
    (name "r-compositions")
    (version "2.0-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "compositions" version))
       (sha256
        (base32
         "147j3sbqcy3hfja1zs8s8p9zzp9a68vk52s545c2p6anyj4381n5"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayesm r-mass r-robustbase r-tensora))
    (native-inputs
     (list r-knitr))
    (home-page "http://www.stat.boogaart.de/compositions")
    (synopsis "Compositional data analysis")
    (description
     "This package provides functions for the consistent analysis of
compositional data (e.g. portions of substances) and positive
numbers (e.g. concentrations).")
    (license license:gpl2+)))

(define-public r-cobs
  (package
    (name "r-cobs")
    (version "1.3-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cobs" version))
       (sha256
        (base32
         "08cqpiylbfy5j5xxajpngqaycmmciwhyf3sk3972x2l6rg3lj81c"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-quantreg r-sparsem))
    (home-page "https://cran.r-project.org/web/packages/cobs")
    (synopsis "Constrained B-Splines (sparse matrix based)")
    (description
     "This package provides qualitatively constrained (regression) smoothing
splines via linear programming and sparse matrices.")
    (license license:gpl2+)))

(define-public r-drimpute
  (package
    (name "r-drimpute")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DrImpute" version))
       (sha256
        (base32
         "1adzarrwqb282pqgx2yqswp9rpwd1naxsmar54kddr6qyd6b923b"))))
    (properties `((upstream-name . "DrImpute")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo))
    (home-page "https://github.com/ikwak2/DrImpute")
    (synopsis "Imputing dropout events in single-cell RNA-Seq data")
    (description
     "This is an R package for imputing dropout events.  Many statistical
methods in cell type identification, visualization and lineage reconstruction
do not account for dropout events.  DrImpute can improve the performance of
such software by imputing dropout events.")
    (license license:gpl3)))

(define-public r-gamlss-dist
  (package
    (name "r-gamlss-dist")
    (version "6.1-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gamlss.dist" version))
       (sha256
        (base32 "0sch2bh1mchl7kfdy4wcmwzzgx7cldswn65a2br2x73rb1v3mnyj"))))
    (properties `((upstream-name . "gamlss.dist")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "http://www.gamlss.org/")
    (synopsis "Distributions for Generalized Additive Models for location scale and shape")
    (description
     "This package provides a set of distributions which can be used for
modelling the response variables in Generalized Additive Models for Location
Scale and Shape.  The distributions can be continuous, discrete or mixed
distributions.  Extra distributions can be created, by transforming, any
continuous distribution defined on the real line, to a distribution defined on
ranges 0 to infinity or 0 to 1, by using a @code{log} or a @code{logit}
transformation, respectively.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

;; This package includes JavaScript files, which are not minified.  When
;; upgrading please check that there are no new minified JavaScript files.
(define-public r-shinyjs
  (package
    (name "r-shinyjs")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyjs" version))
       (sha256
        (base32
         "1id9gsrkr28xl80a8794in17rxmmz06zqvd5hlns7mqz3fzhrhky"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest r-jsonlite r-shiny))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://deanattali.com/shinyjs")
    (synopsis "Improve the user experience of your Shiny apps")
    (description
     "Perform common useful JavaScript operations in Shiny apps that will
greatly improve your apps without having to know any JavaScript.  Examples
include: hiding an element, disabling an input, resetting an input back to its
original value, delaying code execution by a few seconds, and many more useful
functions for both the end user and the developer.  Shinyjs can also be used
to easily call your own custom JavaScript functions from R.")
    (license license:agpl3+)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-colourpicker
  (package
    (name "r-colourpicker")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "colourpicker" version))
       (sha256
        (base32
         "0415238r7a8xrp3kvq8lczzxz534irj2q1zfbb0pl7xfs6663wn7"))
       (snippet
        '(for-each delete-file
                   (list "inst/examples/colourInput/www/salvattore.min.js"
                         "inst/htmlwidgets/lib/jquery/jquery.min.js"
                         "inst/www/shared/colourpicker/js/colourpicker.min.js")))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst"
               (let ((mapping
                      `((,(assoc-ref inputs "js-salvattore")
                         . "examples/colourInput/www/salvattore.min.js")
                        (,(assoc-ref inputs "js-jquery")
                         . "htmlwidgets/lib/jquery/jquery.min.js")
                        ("www/shared/colourpicker/js/colourpicker.js"
                         . "www/shared/colourpicker/js/colourpicker.min.js"))))
                 (for-each (lambda (source target)
                             (format #true "Processing ~a --> ~a~%"
                                     source target)
                             (invoke "esbuild" source "--minify"
                                     (string-append "--outfile=" target)))
                           (map car mapping)
                           (map cdr mapping)))))))))
    (propagated-inputs
     (list r-ggplot2
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-miniui
           r-shiny
           r-shinyjs))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-3.6.1.js")
           (sha256
            (base32
             "1lm4zcpvqdi7qi2s7bgci2z74wazq0z0bdvjmlrqbhmfrpk42ffz"))))
       ("js-salvattore"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/rnmp/salvattore/v1.0.9/dist/salvattore.js")
           (sha256
            (base32
             "0lfrbx7l9w5x89jpc6njmd0pk7h8fpvg537vklai2vf7b1r2nnk5"))))))
    (home-page "https://github.com/daattali/colourpicker")
    (synopsis "Color picker tool for Shiny and for selecting colors in plots")
    (description
     "This package provides a color picker that can be used as an input in
Shiny apps or Rmarkdown documents.  The color picker supports alpha opacity,
custom color palettes, and many more options.  A plot color helper tool is
available as an RStudio Addin, which helps you pick colors to use in your
plots.  A more generic color picker RStudio Addin is also provided to let you
select colors to use in your R code.")
    (license license:expat)))

(define-public r-ggextra
  (package
    (name "r-ggextra")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggExtra" version))
       (sha256
        (base32
         "0b78bnkhjlfa2h3f5iib0hqas8r289vqglfbk71a419rivzfsyb8"))))
    (properties `((upstream-name . "ggExtra")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colourpicker
           r-ggplot2
           r-gtable
           r-miniui
           r-r6
           r-scales
           r-shiny
           r-shinyjs))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/daattali/ggExtra")
    (synopsis "Marginal histograms for ggplot2 and other enhancements")
    (description
     "This package is a collection of functions and layers to enhance ggplot2.
The flagship function is @code{ggMarginal()}, which can be used to add
marginal histograms/boxplots/density plots to ggplot2 scatterplots.")
    (license license:expat)))

(define-public r-ggpattern
  (package
    (name "r-ggpattern")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggpattern" version))
       (sha256
        (base32 "1xlh1y6q10iqk1mbwdrr1vqmgmim3z27znbb5sbwgmm9yfxzj37s"))))
    (properties `((upstream-name . "ggpattern")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-ggplot2
           r-glue
           r-gridpattern
           r-lifecycle
           r-rlang
           r-scales
           r-vctrs))
    (native-inputs (list r-knitr r-ragg r-rmarkdown r-testthat))
    (home-page "https://github.com/coolbutuseless/ggpattern")
    (synopsis "Ggplot2 pattern geoms")
    (description
     "This package provides ggplot2 geoms filled with various patterns.
It includes a patterned version of every ggplot2 geom that has a region that
can be filled with a pattern.  It provides a suite of ggplot2 aesthetics and
scales for controlling pattern appearances.  It supports over a dozen builtin
patterns (every pattern implemented by gridpattern) as well as allowing custom
user-defined patterns.")
    (license license:expat)))

(define-public r-minpack-lm
  (package
    (name "r-minpack-lm")
    (version "1.2-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "minpack.lm" version))
       (sha256
        (base32
         "0cg7arnmb7x6v5x487gkc2k4i5gchgdwblrrd0k0vw1w6pza83z3"))))
    (properties `((upstream-name . "minpack.lm")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/minpack.lm")
    (synopsis "Levenberg-Marquardt Nonlinear Least-Squares algorithm")
    (description
     "The @code{nls.lm} function provides an R interface to @code{lmder} and
@code{lmdif} from the MINPACK library, for solving nonlinear least-squares
problems by a modification of the Levenberg-Marquardt algorithm, with support
for lower and upper parameter bounds.  The implementation can be used via
@code{nls}-like calls using the @code{nlsLM} function.")
    (license license:gpl3)))

(define-public r-moments
  (package
    (name "r-moments")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "moments" version))
       (sha256
        (base32
         "0r6qf3i1rzh2822bx1p0h8mh91gsbgg6asl2rzh2l4ys094bilif"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/moments")
    (synopsis "Moments, cumulants, skewness, kurtosis and related tests")
    (description
     "This package provides functions to calculate: moments, Pearson's
kurtosis, Geary's kurtosis and skewness; it also includes tests related to
them (Anscombe-Glynn, D'Agostino, Bonett-Seier).")
    (license license:gpl2+)))

(define-public r-msir
  (package
    (name "r-msir")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "msir" version))
       (sha256
        (base32
         "1wm83m3cqd6llxb9p2jwim0wb81v84pgdmgcznygzaaq6kbn3n84"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mclust))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/msir")
    (synopsis "Model-based sliced inverse regression")
    (description
     "This is an R package for dimension reduction based on finite Gaussian
mixture modeling of inverse regression.")
    (license license:gpl2+)))

(define-public r-pbivnorm
  (package
    (name "r-pbivnorm")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pbivnorm" version))
       (sha256
        (base32
         "05jzrjqxzbcf6z245hlk7sjxiszv9paadaaimvcx5y5qgi87vhq7"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://github.com/brentonk/pbivnorm")
    (synopsis "Vectorized bivariate normal CDF")
    (description
     "This package provides a vectorized R function for calculating
probabilities from a standard bivariate normal CDF.")
    (license license:gpl2+)))

(define-public r-lavaan
  (package
    (name "r-lavaan")
    (version "0.6-19")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lavaan" version))
       (sha256
        (base32
         "11dpx1bmlx5120fp214bzadqvk2p46l5vgcq6r1kmlv4q7ikgca7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-mnormt r-numderiv r-pbivnorm r-quadprog))
    (home-page "https://lavaan.ugent.be")
    (synopsis "Latent variable analysis")
    (description
     "This package provides tools to fit a variety of latent variable models,
including confirmatory factor analysis, structural equation modeling and
latent growth curve models.")
    (license license:gpl2+)))

(define-public r-nonnest2
  (package
    (name "r-nonnest2")
    (version "0.5-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nonnest2" version))
       (sha256
        (base32
         "10nw8b0qcppbwc4lvvpyxpxvg583bl3fy916yx74xcm563aar98r"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-compquadform r-lavaan r-mvtnorm r-sandwich))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/web/packages/nonnest2/")
    (synopsis "Tests of non-nested models")
    (description
     "This package allows for testing of non-nested models.  It includes tests
of model distinguishability and of model fit that can be applied to both
nested and non-nested models.  The package also includes functionality to
obtain confidence intervals associated with AIC and BIC.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-penalized
  (package
    (name "r-penalized")
    (version "0.9-52")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "penalized" version))
       (sha256
        (base32
         "08badmgygppbqzay20qijyww028yw6s8dyd8ijcp8g4r9rn8xqyq"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo r-survival))
    (home-page "https://cran.r-project.org/web/packages/penalized/")
    (synopsis "Penalized estimation in GLMs and in the Cox model")
    (description
     "This package provides tools for fitting possibly high dimensional
penalized regression models.  The penalty structure can be any combination of
an L1 penalty (lasso and fused lasso), an L2 penalty (ridge) and a positivity
constraint on the regression coefficients.  The supported regression models
are linear, logistic and Poisson regression and the Cox Proportional Hazards
model.  Cross-validation routines allow optimization of the tuning
parameters.")
    (license license:gpl2+)))

(define-public r-zim
  (package
    (name "r-zim")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ZIM" version))
       (sha256
        (base32
         "0scyfjn4ilsvha3x41c3b8bcfi31hlhwm77wn2a8hj5dsvnnmzig"))))
    (properties `((upstream-name . "ZIM")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://github.com/biostatstudio/ZIM")
    (synopsis "Zero-inflated models (ZIM) for count time series with excess zeros")
    (description
     "Analyze count time series with excess zeros.  Two types of statistical
models are supported: Markov regression and state-space models.  They are also
known as observation-driven and parameter-driven models respectively in the
time series literature.  The functions used for Markov regression or
observation-driven models can also be used to fit ordinary regression models
with independent data under the zero-inflated Poisson (ZIP) or zero-inflated
negative binomial (ZINB) assumption.  The package also contains miscellaneous
functions to compute density, distribution, quantile, and generate random
numbers from ZIP and ZINB distributions.")
    (license license:gpl3)))

(define-public r-nor1mix
  (package
    (name "r-nor1mix")
    (version "1.3-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nor1mix" version))
       (sha256
        (base32
         "0vh7vlvijska09rm0cb2lakwhjm38mc4daksc2zniyj7r3wd1gwp"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/nor1mix/")
    (synopsis "Normal (1-d) mixture models")
    (description
     "This package provides S3 classes and methods for one-dimensional normal
mixture models, for, e.g., density estimation or clustering algorithms
research and teaching; it provides the widely used Marron-Wand densities.  It
also provides tools for efficient random number generation and graphics.")
    (license license:gpl2+)))

(define-public r-beanplot
  (package
    (name "r-beanplot")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "beanplot" version))
       (sha256
        (base32
         "1b8mvlcsv5l9g08ag92hndsvk8jmgxvznhzgazc8y4296kp8l5a9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/beanplot/")
    (synopsis "Visualization via beanplots")
    (description
     "This package provides beanplots, an alternative to
boxplot/stripchart/violin plots.  It can be used to plot univariate comparison
graphs.")
    (license license:gpl2)))

(define-public r-pbdzmq
  (package
    (name "r-pbdzmq")
    (version "0.3-13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pbdZMQ" version))
       (sha256
        (base32
         "16l3g7syiwx5lfjr9rw9jckyzy2h8nikxmx8hd576av44f1shfa1"))))
    (properties
     `((upstream-name . "pbdZMQ")
       (updater-extra-inputs . ("zeromq"))))
    (build-system r-build-system)
    (inputs
     (list zeromq zlib))
    (native-inputs
     (list pkg-config))
    (home-page "https://pbdr.org/")
    (synopsis "R interface to ZeroMQ")
    (description
     "ZeroMQ is a well-known library for high-performance asynchronous
messaging in scalable, distributed applications.  This package provides high
level R wrapper functions to easily utilize ZeroMQ.  The main focus is on
interactive client/server programming frameworks.  A few wrapper functions
compatible with @code{rzmq} are also provided.")
    (license license:gpl3)))

(define-public r-repr
  (package
    (name "r-repr")
    (version "1.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "repr" version))
       (sha256
        (base32
         "06q2xmg27w1hhapcf320zz92f5arwrf2sf0y1mp0j4a29mmnkgbk"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc r-htmltools r-jsonlite r-pillar))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/repr/")
    (synopsis "Serializable representations")
    (description
     "This package provides string and binary representations of objects for
several formats and MIME types.")
    (license license:gpl3)))

(define-public r-irdisplay
  (package
    (name "r-irdisplay")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "IRdisplay" version))
       (sha256
        (base32
         "0awdiv4rr93y8jb1d64sm1iy37ywyniqm7w98yv6qm0zz47h7sw3"))))
    (properties `((upstream-name . "IRdisplay")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-repr))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/IRdisplay/")
    (synopsis "Jupyter display machinery")
    (description
     "This package provides an interface to the rich display capabilities of
Jupyter front-ends (e.g. Jupyter Notebook).  It is designed to be used from a
running IRkernel session.")
    (license license:expat)))

(define-public r-irkernel
  (package
    (name "r-irkernel")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "IRkernel" version))
       (sha256
        (base32
         "19i4wj5cb62n6j83nxgv500dcdzrf6rzwdy5v6fh7r93vjyxiip1"))))
    (properties `((upstream-name . "IRkernel")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'install 'install-kernelspec
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((out (assoc-ref outputs "out")))
               (setenv "HOME" "/tmp")
               (invoke "jupyter" "kernelspec" "install"
                       "--name" "ir"
                       "--prefix" out
                       (string-append out "/site-library/IRkernel/kernelspec"))
               ;; Record the absolute file name of the 'R' executable in
               ;; 'kernel.json'.
               (substitute* (string-append out "/share/jupyter"
                                           "/kernels/ir/kernel.json")
                 (("\\[\"R\",")
                  (string-append "[\"" (which "R") "\",")))
               #t))))))
    (inputs
     (list jupyter))
    (propagated-inputs
     (list r-crayon
           r-digest
           r-evaluate
           r-irdisplay
           r-jsonlite
           ;; sets R_LIBS_SITE, so R can actually find this package (IRkernel)
           r-minimal
           r-pbdzmq
           r-repr
           r-uuid))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/IRkernel/")
    (synopsis "Native R kernel for Jupyter")
    (description
     "The R kernel for the Jupyter environment executes R code which the
front-end (Jupyter Notebook or other front-ends) submits to the kernel via the
network.")
    (license license:expat)))

(define-public r-gmodels
  (package
    (name "r-gmodels")
    (version "2.19.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gmodels" version))
       (sha256
        (base32
         "13c8x7iwyz36qir3ikbvjb5dl6gdh4fh82qdxcpcdinwfhrbhmxv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gdata r-mass))
    (home-page "https://cran.r-project.org/web/packages/gmodels/")
    (synopsis "Various R programming tools for model fitting")
    (description
     "This package provides various R programming tools for model fitting.")
    (license license:gpl2)))

(define-public r-apcluster
  (package
    (name "r-apcluster")
    (version "1.4.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "apcluster" version))
       (sha256
        (base32
         "19x1sma5pli5jl0v92c6x7jbqkigz7waaghaxi29kvvx8am5p5sy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-rcpp))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/apcluster/")
    (synopsis "Affinity propagation clustering")
    (description
     "This package implements affinity propagation clustering introduced by
Frey and Dueck (2007).  The package further provides leveraged affinity
propagation and an algorithm for exemplar-based agglomerative clustering that
can also be used to join clusters obtained from affinity propagation.  Various
plotting functions are available for analyzing clustering results.")
    (license license:gpl2+)))

(define-public r-remacor
  (package
    (name "r-remacor")
    (version "0.0.18")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "remaCor" version))
              (sha256
               (base32
                "0c8n2zj84m2z0vznx81qrspnyyj38imb73di4l2k0brr8jxgzr2p"))))
    (properties `((upstream-name . "remaCor")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-envstats
           r-ggplot2
           r-mvtnorm
           r-rcpp
           r-rcpparmadillo
           r-rdpack
           r-reshape2))
    (native-inputs (list r-knitr r-runit))
    (home-page "https://diseaseneurogenomics.github.io/remaCor/")
    (synopsis "Random effects meta-analysis for correlated test statistics")
    (description
     "Meta-analysis is widely used to summarize estimated effects sizes across
multiple statistical tests.  Standard fixed and random effect meta-analysis
methods assume that the estimated of the effect sizes are statistically
independent.  Here we relax this assumption and enable meta-analysis when the
correlation matrix between effect size estimates is known.")
    (license license:artistic2.0)))

(define-public r-rematch2
  (package
    (name "r-rematch2")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rematch2" version))
       (sha256
        (base32
         "1fzpz8vhghw8ygwg6rsvfy3783pqk7ch029i5851lwypkplvz77y"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-lib/rematch2")
    (synopsis "Tidy output from regular expression matching")
    (description
     "This package provides wrappers on @code{regexpr} and @code{gregexpr} to
return the match results in tidy data frames.")
    (license license:expat)))

(define-public r-picante
  (package
    (name "r-picante")
    (version "1.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "picante" version))
       (sha256
        (base32
         "19savjzj44b7ifdxcp02ynj22z4n4ikq2aipc74ljzy3yykmqmjn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape r-nlme r-vegan))
    (home-page "https://cran.r-project.org/web/packages/picante/")
    (synopsis "Integrating phylogenies and ecology")
    (description
     "This package provides functions for phylocom integration, community
analyses, null-models, traits and evolution.  It implements numerous
ecophylogenetic approaches including measures of community phylogenetic and
trait diversity, phylogenetic signal, estimation of trait values for
unobserved taxa, null models for community and phylogeny randomizations, and
utility functions for data input/output and phylogeny plotting.  A full
description of package functionality and methods are provided by Kembel et
al. (2010).")
    (license license:gpl2)))

(define-public r-reinforcelearn
  (package
    (name "r-reinforcelearn")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reinforcelearn" version))
       (sha256
        (base32
         "176z2q69p24i29a8sh19xxn2zl3h1z2ixdssr5i6m4yvkvdrvv3b"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-checkmate r-nnet r-purrr r-r6))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://markusdumke.github.io/reinforcelearn")
    (synopsis "Reinforcement learning")
    (description
     "This package implements reinforcement learning environments and
algorithms as described in Sutton & Barto (1998).  The Q-Learning algorithm
can be used with function approximation, eligibility traces (Singh & Sutton,
1996) and experience replay (Mnih et al., 2013).")
    (license license:expat)))

(define-public r-lemon
  (package
    (name "r-lemon")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lemon" version))
       (sha256
        (base32
         "0d0x9mds241hm6armdb32zg4wkkvyy23q2cwk550lmxx2x6bb71w"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2
           r-gridextra
           r-gtable
           r-knitr
           r-lattice
           r-plyr
           r-scales))
    (native-inputs
     (list r-knitr r-testthat r-vdiffr))
    (home-page "https://github.com/stefanedwards/lemon")
    (synopsis "Freshen up your ggplot2 plots")
    (description
     "This package provides functions for working with legends and axis lines
of ggplot2, facets that repeat axis lines on all panels, and some knitr
extensions.")
    (license license:gpl3)))

(define-public r-wgaim
  (package
    (name "r-wgaim")
    (version "2.0-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wgaim" version))
       (sha256
        (base32 "0i13ngp0z0l72jbzdpydp3pigggmp4bn9jfyzjkbzj2fhfixsqf0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-qtl))
    (home-page "https://cran.r-project.org/web/packages/wgaim")
    (synopsis "Whole genome average interval mapping for QTL detection")
    (description
     "This package integrates sophisticated mixed modelling methods with a
whole genome approach to detecting significant QTL in linkage maps.")
    (license license:gpl2+)))

(define-public r-bedr
  (package
    (name "r-bedr")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bedr" version))
       (sha256
        (base32
         "0zpqvyjgwyqawxm8qrhcv8zq2b3yxgcqkkc87br29yrl7sjb8h6j"))))
    (build-system r-build-system)
    ;; FIXME Tests fail with: could not find function "context"
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-data-table
           r-r-utils
           r-testthat
           r-venndiagram
           r-yaml
           bedops
           bedtools
           htslib)) ; for tabix
    (native-inputs
     (list r-knitr r-testthat)) ; for vignettes
    (home-page "https://cran.r-project.org/web/packages/bedr")
    (synopsis "Genomic region processing")
    (description
     "This package is for genomic regions processing using command line tools
such as BEDTools, BEDOPS and Tabix.  These tools offer scalable and efficient
utilities to perform genome arithmetic e.g indexing, formatting and merging.
The bedr package's API enhances access to these tools as well as offers
additional utilities for genomic regions processing.")
    (license license:gpl2)))

(define-public r-setrng
  (package
    (name "r-setrng")
    (version "2024.2-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "setRNG" version))
              (sha256
               (base32
                "0h2wbpsi07c48h72zjglvp9b58hq3j77289sah32qg6vnw41pcp3"))))
    (properties `((upstream-name . "setRNG")))
    (build-system r-build-system)
    (home-page "https://distr.r-forge.r-project.org/")
    (synopsis "Set (normal) random number generator and seed")
    (description
     "This package provides utilities to help set and record the setting of
the seed and the uniform and normal generators used when a random experiment
is run.  The utilities can be used in other functions that do random
experiments to simplify recording and/or setting all the necessary information
for reproducibility.  See the vignette and reference manual for examples.")
    (license license:gpl2)))

(define-public r-sets
  (package
    (name "r-sets")
    (version "1.0-25")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sets" version))
       (sha256
        (base32
         "1x14q29jjmrs5ldbjc7pxp5pr52j3dw6zr9k5qvz4ycniwhnk92w"))))
    (properties `((upstream-name . "sets")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/sets")
    (synopsis "Sets, generalized sets, customizable sets and intervals")
    (description
     "This package provides data structures and basic operations for ordinary
sets, generalizations such as fuzzy sets, multisets, and fuzzy multisets,
customizable sets, and intervals.")
    (license license:gpl2)))

(define-public r-partitions
  (package
    (name "r-partitions")
    (version "1.10-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "partitions" version))
       (sha256
        (base32
         "1kxiy1wl7dr39kyfg2y9hd67s32knd83r2jsb7j9p3vg8iqq7yqb"))))
    (build-system r-build-system)
    ;; Vignettes fail because of a missing file.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs
     (list r-gmp r-mathjaxr r-polynom r-rdpack r-sets))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/partitions")
    (synopsis "Additive partitions of integers")
    (description
     "This package provides tools to enumerates the partitions, unequal
partitions, and restricted partitions of an integer; the three corresponding
partition functions are also given.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-brobdingnag
  (package
    (name "r-brobdingnag")
    (version "1.2-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Brobdingnag" version))
       (sha256
        (base32
         "07p9416rdzfyiigbglxjpbcg7pfly9nw19yn2mwg98621cjjs0gr"))))
    (properties `((upstream-name . "Brobdingnag")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/RobinHankin/Brobdingnag.git")
    (synopsis "Very large numbers in R")
    (description
     "This package handles very large numbers in R.  Real numbers are held
using their natural logarithms, plus a logical flag indicating sign.  The
package includes a vignette that gives a step-by-step introduction to using S4
methods.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-unglue
  (package
    (name "r-unglue")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "unglue" version))
       (sha256
        (base32 "0w8ld4xllx0lj1jz8i2sj92f8136hlwri1d8ldpg1ymxj7aw93vg"))))
    (properties `((upstream-name . "unglue")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=unglue")
    (synopsis "Extract matched substrings using a pattern")
    (description
     "This package lets you use syntax inspired by the package @code{glue} to
extract matched substrings in a more intuitive and compact way than by using
standard regular expressions.")
    (license license:gpl3)))

(define-public r-untb
  (package
    (name "r-untb")
    (version "1.7-7-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "untb" version))
       (sha256
        (base32
         "1v0c43shqn7nmzzrf3yx740xjwrn4djll438p5gf31ny0q0hlgzb"))))
    (build-system r-build-system)
    ;; Disable vignettes because of missing files.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs
     (list r-brobdingnag r-partitions r-polynom))
    (native-inputs (list r-testthat r-vdiffr))
    (home-page "https://github.com/RobinHankin/untb.git")
    (synopsis "Ecological drift under the UNTB")
    (description
     "This package provides numerical simulations, and visualizations, of
Hubbell's @dfn{Unified Neutral Theory of Biodiversity} (UNTB).")
    (license license:gpl2+)))

(define-public r-stepwise
  (package
    (name "r-stepwise")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stepwise" version))
       (sha256
        (base32
         "1lbx1bxwkf9dw6q46w40pp7h5nkxgghmx8rkpaymm6iybc7gyir2"))))
    (build-system r-build-system)
    (home-page "https://stat.sfu.ca/statgen/research/stepwise.html")
    (synopsis "Stepwise detection of recombination breakpoints")
    (description
     "This package provides a stepwise approach to identifying recombination
breakpoints in a genomic sequence alignment.")
    (license license:gpl2+)))

(define-public r-snpmaxsel
  (package
    (name "r-snpmaxsel")
    (version "1.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SNPmaxsel" version))
       (sha256
        (base32
         "0pjvixwqzjd3jwccc8yqq9c76afvbmfq0z1w0cwyj8bblrjpx13z"))))
    (properties `((upstream-name . "SNPmaxsel")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-combinat r-mvtnorm))
    (home-page "https://cran.r-project.org/web/packages/SNPmaxsel/index.html")
    (synopsis "Maximally selected statistics for SNP data")
    (description
     "This package implements asymptotic methods related to maximally selected
statistics, with applications to @dfn{single-nucleotide polymorphism} (SNP)
data.")
    (license license:gpl2+)))

(define-public r-acsnminer
  (package
    (name "r-acsnminer")
    (version "0.16.8.25")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ACSNMineR" version))
              (sha256
               (base32
                "0gh604s8qall6zfjlwcg2ilxjvz08dplf9k5g47idhv43scm748l"))))
    (properties `((upstream-name . "ACSNMineR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridextra))
    (home-page "https://cran.r-project.org/web/packages/ACSNMineR")
    (synopsis "Gene enrichment analysis")
    (description
     "This package provides tools to compute and represent gene set enrichment
or depletion from your data based on pre-saved maps from the @dfn{Atlas of
Cancer Signalling Networks} (ACSN) or user imported maps.  The gene set
enrichment can be run with hypergeometric test or Fisher exact test, and can
use multiple corrections.  Visualization of data can be done either by
barplots or heatmaps.")
    (license license:gpl2+)))

(define-public r-seqinr
  (package
    (name "r-seqinr")
    (version "4.2-36")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "seqinr" version))
       (sha256
        (base32
         "09dj2k5mi6xylsihnwbmdd8f4qg855gyh7yvz9gamam7j6h646lk"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ade4 r-segmented))
    (inputs
     (list zlib))
    (home-page "https://seqinr.r-forge.r-project.org/")
    (synopsis "Biological sequences retrieval and analysis")
    (description
     "This package provides tools for exploratory data analysis and data
visualization of biological sequence (DNA and protein) data.  It also includes
utilities for sequence data management under the ACNUC system.")
    (license license:gpl2+)))

(define-public r-unigd
  (package
    (name "r-unigd")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "unigd" version))
       (sha256
        (base32 "0iykjsfi8rjayrb4nhnm8ifdlsaxr7918bk6ackgfj1qz5g33wr7"))))
    (properties `((upstream-name . "unigd")))
    (build-system r-build-system)
    (inputs (list cairo fontconfig freetype libpng zlib))
    (propagated-inputs (list r-cpp11 r-systemfonts))
    (native-inputs (list pkg-config r-knitr r-testthat r-xml2))
    (home-page "https://github.com/nx10/unigd")
    (synopsis "Universal graphics device")
    (description
     "This package provides a unified R graphics backend.  Render R graphics
fast and easy to many common file formats.  It provides a thread safe C
interface for asynchronous rendering of R graphics.")
    (license license:gpl2+)))

(define-public r-units
  (package
    (name "r-units")
    (version "0.8-5")
    (source
      (origin
        (method url-fetch)
        (uri (cran-uri "units" version))
        (sha256
          (base32
            "1c836qazrs8z9p1xkcfl9gl882i8q7qf2g73l483w18bfspq0pnr"))))
    (build-system r-build-system)
    (inputs
     (list udunits))
    (propagated-inputs
     (list r-rcpp))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/r-quantities/units/")
    (synopsis "Measurement Units for R Vectors")
    (description
      "This package provides support for measurement units in R vectors,
matrices and arrays: automatic propagation, conversion, derivation and
simplification of units; raising errors in case of unit incompatibility.  It
is compatible with the @code{POSIXct}, @code{Date} and @code{difftime}
classes.")
    (license license:gpl2)))

(define-public r-udunits2
  (package
    (name "r-udunits2")
    (version "0.13.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "udunits2" version))
       (sha256
        (base32
         "00prsy8m41v1camcsz94d7gm8qab2mdnwl3x0dyhz4r49b02jm4z"))))
    (properties `((upstream-name . "udunits2")))
    (build-system r-build-system)
    (inputs
     (list udunits))
    (home-page "https://cran.r-project.org/package=udunits2")
    (synopsis "Udunits-2 bindings for R")
    (description
     "This package provides simple bindings to Unidata's udunits library.")
    (license license:gpl2)))

(define-public r-clarabel
  (package
    (name "r-clarabel")
    (version "0.9.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clarabel" version))
       (sha256
        (base32 "1qfchpxd0hnw4vcs6vbkkrf0rqrrjr85j1hvpka466aqpdsl2qsa"))))
    (properties `((upstream-name . "clarabel")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-variables-for-rust
            (lambda _
              (setenv "CC" #$(cc-for-target)))))))
    (native-inputs (list r-knitr rust `(,rust "cargo")))
    (home-page "https://oxfordcontrol.github.io/clarabel-r/")
    (synopsis "Interior point conic optimization solver")
    (description
     "This package provides a versatile interior point solver that solves
@dfn{linear programs} (LPs), @dfn{quadratic programs} (QPs), @dfn{second-order
cone programs} (SOCPs), @dfn{semidefinite programs} (SDPs), and problems with
exponential and power cone constraints (@url{https://clarabel.org/stable/}).
For quadratic objectives, unlike interior point solvers based on the standard
@dfn{homogeneous self-dual embedding} (HSDE) model, Clarabel handles quadratic
objective without requiring any epigraphical reformulation of its objective
function.  It can therefore be significantly faster than other HSDE-based
solvers for problems with quadratic objective functions.  Infeasible problems
are detected using using a homogeneous embedding technique.")
    (license license:asl2.0)))

(define-public r-classint
  (package
    (name "r-classint")
    (version "0.4-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "classInt" version))
       (sha256
        (base32
         "12rbwh7g0a6abvy423xjiv53gx1f9lg4y78r80lc0fj9pjpiwmn3"))))
    (properties `((upstream-name . "classInt")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class r-e1071 r-kernsmooth))
    (native-inputs
     (list gfortran r-knitr))
    (home-page "https://github.com/r-spatial/classInt/")
    (synopsis "Choose univariate class intervals")
    (description
     "This package provides selected commonly used methods for choosing
univariate class intervals for mapping or other graphics purposes.")
    (license license:gpl2+)))

(define-public r-spdata
  (package
    (name "r-spdata")
    (version "2.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spData" version))
       (sha256
        (base32
         "1q1rkq03hn4hl03n7l7ravhsh6qp3q26hqpr9984v59iqvmvk4y0"))))
    (properties `((upstream-name . "spData")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-sp))
    (home-page "https://github.com/Nowosad/spData")
    (synopsis "Datasets for spatial analysis")
    (description
     "This a package containing diverse spatial datasets for demonstrating,
benchmarking and teaching spatial data analysis.  It includes R data of class
@code{sf}, @code{Spatial}, and @code{nb}.  It also contains data stored in a
range of file formats including GeoJSON, ESRI Shapefile and GeoPackage.  Some
of the datasets are designed to illustrate specific analysis techniques.
@code{cycle_hire()} and @code{cycle_hire_osm()}, for example, are designed to
illustrate point pattern analysis techniques.")
    (license license:cc0)))

(define-public r-learnbayes
  (package
    (name "r-learnbayes")
    (version "2.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "LearnBayes" version))
       (sha256
        (base32
         "0ch54v2zz2yyyk0lvn5rfikdmyz1qh9j1wk3585wl8v58mc0h4cv"))))
    (properties `((upstream-name . "LearnBayes")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/LearnBayes")
    (synopsis "Functions for learning Bayesian inference")
    (description
     "This package provides a collection of functions helpful in learning the
basic tenets of Bayesian statistical inference.  It contains functions for
summarizing basic one and two parameter posterior distributions and predictive
distributions.  It contains MCMC algorithms for summarizing posterior
distributions defined by the user.  It also contains functions for regression
models, hierarchical models, Bayesian tests, and illustrations of Gibbs
sampling.")
    (license license:gpl2+)))

(define-public r-deldir
  (package
    (name "r-deldir")
    (version "2.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "deldir" version))
       (sha256
        (base32
         "0ls69b9yynvsiy6madvzafcb0jdvxw66sin7cinpnw63israq66l"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/deldir")
    (synopsis "Delaunay triangulation and Dirichlet (Voronoi) tessellation")
    (description
     "This package provides tools for calculating the Delaunay triangulation
and the Dirichlet or Voronoi tessellation (with respect to the entire plane)
of a planar point set.  It plots triangulations and tessellations in various
ways, clips tessellations to sub-windows, calculates perimeters of
tessellations, and summarizes information about the tiles of the
tessellation.")
    (license license:gpl2+)))

(define-public r-wk
  (package
    (name "r-wk")
    (version "0.9.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wk" version))
       (sha256
        (base32
         "12rlkspg0zavda6jfwcah7gm9fh4x13720m4gvy4xndfm5gxswxr"))))
    (properties `((upstream-name . "wk")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://paleolimbot.github.io/wk/")
    (synopsis "Lightweight well-known geometry parsing")
    (description
     "This package provides a minimal R and C++ API for parsing well-known
binary and well-known text representation of geometries to and from R-native
formats.  Well-known binary is compact and fast to parse; well-known text is
human-readable and is useful for writing tests.  These formats are only useful
in R if the information they contain can be accessed in R, for which
high-performance functions are provided here.")
    (license license:expat)))

(define-public r-s2
  (package
    (name "r-s2")
    (version "1.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "s2" version))
       (sha256
        (base32
         "0y38g1zy19m7xsipns3m6avmjb9vnyw683nmlgsf4wnxa1qjqxih"))))
    (properties `((upstream-name . "s2")))
    (build-system r-build-system)
    (argume