/*
    SPDX-FileCopyrightText: 2012 Olivier de Gaalon <olivier.jg@gmail.com>

    SPDX-License-Identifier: LGPL-2.0-only
*/

#ifndef KDEVPLATFORM_DELAYEDOUTPUT_H
#define KDEVPLATFORM_DELAYEDOUTPUT_H

#include <tests/testsexport.h>

#include <QScopedPointer>

namespace KDevelop {
class DelayedOutputPrivate;

///Used to invert and visually nest error output generated by nested/recursive functions
///Used in TestSuite.h, use only at your own, singleton educated risk
class KDEVPLATFORMTESTS_EXPORT DelayedOutput
{
public:
    class KDEVPLATFORMTESTS_EXPORT Delay
    {
public:
        explicit Delay(DelayedOutput* output);
        ~Delay();

private:
        DelayedOutput* m_output;
    };
    ~DelayedOutput();
    static DelayedOutput& self();
    void push(const QString& output);

private:
    DelayedOutput();
    Q_DISABLE_COPY(DelayedOutput)
    const QScopedPointer<class DelayedOutputPrivate> d_ptr;
    Q_DECLARE_PRIVATE(DelayedOutput)
};
}

#endif //KDEVPLATFORM_DELAYEDOUTPUT_H
