
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileXYListAttributes.h
    \brief Definition of XYList Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef XYListAttributes_H
#define XYListAttributes_H

#include "magics.h"
namespace magics {

class XmlNode;
class XYListAttributes 
{
public:
//  --  constructor
    XYListAttributes();
    
//  --  destructor
    virtual ~XYListAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const XYListAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	doublearray x_;
	doublearray y_;
	stringarray x_date_;
	string x_base_;
	string x_offset_;
	string y_base_;
	string y_offset_;
	stringarray y_date_;
	double x_missing_;
	double y_missing_;
	doublearray x2_;
	doublearray y2_;
	string x2_base_;
	string x2_offset_;
	stringarray x2_date_;
	string y2_base_;
	string y2_offset_;
	stringarray y2_date_;
	doublearray x_lower_;
	doublearray y_lower_;
	stringarray x_lower_date_;
	stringarray y_lower_date_;
	doublearray x_upper_;
	doublearray y_upper_;
	stringarray x_upper_date_;
	stringarray y_upper_date_;
	 

private:
	friend ostream& operator<<(ostream& s,const XYListAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

