/* NVTV Philips chip data header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: data_ph.h,v 1.15 2003/02/05 22:39:08 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Data tables and setup routines for the Philips chip.
 */

#ifndef _DATA_PH_H
#define _DATA_PH_H

#include "tv_chip.h"
#include "data.h"

void data_init_ph1 (TVSystem system, TVPh1Regs *r);
void data_init_ph2 (TVSystem system, TVPh2Regs *r);
void data_default_ph (TVSettings *s);
void data_clamp_ph (TVSettings *s, TVRegs *r);
void data_setup_ph (TVSettings *s, TVRegs *r);

extern TVPh1Regs ph_ntsc_small_a;  /* PH 620x204 Small,  FFl, OC 12.67x16.05 */
extern TVPh1Regs ph_ntsc_medium_a; /* PH 640x216 +0 Reg, FFl, OC 09.86x11.11 */
extern TVPh1Regs ph_ntsc_small_b;  /* PH 620x204 Small,  FFl, OC 12.67x16.05 */
extern TVPh1Regs ph_ntsc_medium_b; /* PH 640x216 +0 Reg, FFl, OC 09.86x11.11 */
extern TVPh1Regs ph_ntsc_huge_b;   /* PH 710x241 Full,   FFl, OC 0.00x00.82 */

extern TVPh1Regs ph_pal_small_a;   /* PH 620x250 Small,  FFl, OC 11.68x13.19 */
extern TVPh1Regs ph_pal_medium_a;  /* PH 640x259 +0 Reg, FFl, OC 08.83x10.07 */
extern TVPh1Regs ph_pal_small_b;   /* PH 620x250 Small,  FFl, OC 11.68x13.19 */
extern TVPh1Regs ph_pal_medium_b;  /* PH 640x259 +0 Reg, FFl, OC 08.83x10.07 */
extern TVPh1Regs ph_pal_huge_b;    /* PH 702x288 Full,   FFl, OC 00.00x00.00 */

extern TVPh2Regs ph_ntsc_test_a;   /* 640x480 NV */
extern TVPh2Regs ph_ntsc_test_b;   /* 800x600 NV */
extern TVPh2Regs ph_ntsc_test_c;   /* 1024x768 NV double freq? */

extern TVPh2Regs ph_pal_test_a;    /* 640x480 NV */
extern TVPh2Regs ph_pal_test_b;    /* 800x600 NV */
extern TVPh2Regs ph_pal_test_c;    /* 1024x768 NV double freq? */

extern TVPh2Regs ph_ntsc_slave_a;  /* 640x480 Slave */
extern TVPh2Regs ph_ntsc_slave_b;  /* 800x600 Slave */

extern TVPh2Regs ph_pal_slave_a;   /* 640x480 Slave, from dump */
extern TVPh2Regs ph_pal_slave_b;   /* 800x600 Slave */

#endif /* _DATA_PH_H */
