/***

  Olive - Non-Linear Video Editor
  Copyright (C) 2022 Olive Team

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

***/

#ifndef COLORPROCESSOR_H
#define COLORPROCESSOR_H

#include "codec/frame.h"
#include "common/ocioutils.h"
#include "render/colortransform.h"

namespace olive {

class ColorManager;

class ColorProcessor;
using ColorProcessorPtr = std::shared_ptr<ColorProcessor>;

class ColorProcessor
{
public:
  enum Direction {
    kNormal,
    kInverse
  };

  ColorProcessor(ColorManager* config, const QString& input, const ColorTransform& dest_space, Direction direction = kNormal);
  ColorProcessor(OCIO::ConstProcessorRcPtr processor);

  DISABLE_COPY_MOVE(ColorProcessor)

  static ColorProcessorPtr Create(ColorManager* config, const QString& input, const ColorTransform& dest_space, Direction direction = kNormal);
  static ColorProcessorPtr Create(OCIO::ConstProcessorRcPtr processor);

  OCIO::ConstProcessorRcPtr GetProcessor();

  void ConvertFrame(FramePtr f);
  void ConvertFrame(Frame* f);

  Color ConvertColor(const Color &in);

  const char *id() const
  {
    return processor_->getCacheID();
  }

private:
  OCIO::ConstProcessorRcPtr processor_;

  OCIO::ConstCPUProcessorRcPtr cpu_processor_;

};

using ColorProcessorChain = QVector<ColorProcessorPtr>;

}

Q_DECLARE_METATYPE(olive::ColorProcessorPtr)

#endif // COLORPROCESSOR_H
