% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDensityClust.R
\name{plotDensityClust}
\alias{plotDensityClust}
\title{Plot densityCluster results}
\usage{
plotDensityClust(x, type = "all", n = 20, mds = NULL, dim.x = 1,
  dim.y = 2, col = NULL, alpha = 0.8)
}
\arguments{
\item{x}{A densityCluster object as produced by \code{\link{densityClust}}}

\item{type}{A character vector designating which figures to produce. Valid
options include \code{"dg"} for a decision graph of \eqn{\delta} vs.
\eqn{\rho}, \code{"gg"} for a gamma graph depicting the decrease of
\eqn{\gamma} (= \eqn{\delta} * \eqn{\rho}) across samples, and \code{"mds"},
for a Multi-Dimensional Scaling (MDS) plot of observations. Any combination
of these three can be included in the vector, or to produce all plots,
specify \code{type = "all"}.}

\item{n}{Number of observations to plot in the gamma graph.}

\item{mds}{A matrix of scores for observations from a Principal Components
Analysis or MDS. If omitted, and a MDS plot has been requested, one will
be calculated.}

\item{dim.x, dim.y}{The numbers of the dimensions to plot on the x and y
axes of the MDS plot.}

\item{col}{Vector of colors for clusters.}

\item{alpha}{Value in \code{0:1} controlling transparency of points in the
decision graph and MDS plot.}
}
\value{
A panel of the figures specified in \code{type} are produced.
If designated, clusters are color-coded and labelled. If present in
\code{x}, the rho and delta thresholds are designated in the
decision graph by a set of solid black lines.
}
\description{
Generate a single panel of up to three diagnostic plots for a
\code{densityClust} object.
}
\examples{
data(iris)
data.dist <- dist(iris[, 1:4])
pca <- princomp(iris[, 1:4])

# Run initial density clustering
dens.clust <- densityClust(data.dist)
op <- par(ask = TRUE)

# Show the decision graph
plotDensityClust(dens.clust, type = "dg")

# Show the decision graph and the gamma graph
plotDensityClust(dens.clust, type = c("dg", "gg"))

# Cluster based on rho and delta
new.clust <- findClusters(dens.clust, rho = 4, delta = 2)

# Show all graphs with clustering
plotDensityClust(new.clust, mds = pca$scores)

par(op)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
