% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{border_remove}
\alias{border_remove}
\title{remove borders}
\usage{
border_remove(x)
}
\arguments{
\item{x}{a flextable object}
}
\description{
The function is deleting all borders of the flextable object.
}
\section{Illustrations}{


\if{html}{\figure{fig_border_remove_1.png}{options: width="400"}}

\if{html}{\figure{fig_border_remove_2.png}{options: width="400"}}
}

\examples{
dat <- iris[c(1:5, 51:55, 101:105),]
ft_1 <- flextable(dat)
ft_1 <- theme_box(ft_1)
ft_1

# remove all borders
ft_2 <- border_remove(x = ft_1)
ft_2
}
\seealso{
Other borders management: 
\code{\link{border_inner_h}()},
\code{\link{border_inner_v}()},
\code{\link{border_inner}()},
\code{\link{border_outer}()},
\code{\link{hline_bottom}()},
\code{\link{hline_top}()},
\code{\link{hline}()},
\code{\link{surround}()},
\code{\link{vline_left}()},
\code{\link{vline_right}()},
\code{\link{vline}()}
}
\concept{borders management}
