% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_breaks.R
\name{get_breaks}
\alias{get_breaks}
\title{Easy Break Creation for Numeric Axes}
\usage{
get_breaks(n = NULL, by = NULL, from = NULL, to = NULL)
}
\arguments{
\item{n}{number of breaks.}

\item{by}{number: the step between breaks.}

\item{from}{the starting value of breaks. By default, 0 is used for positive
variables}

\item{to}{the end values of breaks. This corresponds generally to the maximum
limit of the axis.}
}
\value{
a break function
}
\description{
Creates breaks for numeric axes to be used in the functions
  \code{\link[ggplot2:scale_continuous]{scale_x_continuous}()} and
  \code{\link[ggplot2:scale_continuous]{scale_y_continuous}()}. Can be used to increase the
  number of x and y ticks by specifying the option \code{n}. It's also
  possible to control axis breaks by specifying a step between ticks.  For
  example, if \code{by = 5}, a tick mark is shown on every 5.
}
\examples{

# Generate 5 breaks for a variable x
get_breaks(n = 5)(x = 1:100)

# Generate breaks using an increasing step
get_breaks(by = 10)(x = 1:100)

# Combine with ggplot scale_xx functions
library(ggplot2)

# Create a basic plot
p <- ggscatter(mtcars, x = "wt", y = "mpg")
p

# Increase the number of ticks
p +
 scale_x_continuous(breaks = get_breaks(n = 10)) +
 scale_y_continuous(breaks = get_breaks(n = 10))

# Set ticks according to a specific step, starting from 0
p + scale_x_continuous(
  breaks = get_breaks(by = 1.5, from = 0),
  limits =  c(0, 6)
) +
 scale_y_continuous(
  breaks = get_breaks(by = 10, from = 0),
  limits = c(0, 40)
  )

}
