% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_set.R
\name{pr_set_404}
\alias{pr_set_404}
\title{Set the handler that is called when the incoming request can't be served}
\usage{
pr_set_404(pr, fun)
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{fun}{A handler function}
}
\value{
The Plumber router with a modified 404 handler
}
\description{
This function allows a custom error message to be returned when a request
cannot be served by an existing endpoint or filter.
}
\examples{
\dontrun{
handler_404 <- function(req, res) {
  res$status <- 404
  res$body <- "Oops"
}

pr() \%>\%
  pr_get("/hi", function() "Hello") \%>\%
  pr_set_404(handler_404) \%>\%
  pr_run()
}

}
