% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep.R
\name{keep}
\alias{keep}
\alias{discard}
\alias{compact}
\title{Keep or discard elements using a predicate function.}
\usage{
keep(.x, .p, ...)

discard(.x, .p, ...)

compact(.x, .p = identity)
}
\arguments{
\item{.x}{A list or vector.}

\item{.p}{For \code{keep()} and \code{discard()}, a predicate function. Only
those elements where \code{.p} evaluates to \code{TRUE} will be kept or
discarded.

For \code{compact()}, a function that is applied to each element of
\code{.x}. Only those elements where \code{.p} evaluates to an empty vector
will be discarded.}

\item{...}{Additional arguments passed on to \code{.p}.}
}
\description{
\code{keep()} and \code{discard()} are opposites. \code{compact()} is a handy
wrapper that removes all empty elements.
}
\details{
These are usually called \code{select} or \code{filter} and \code{reject} or
\code{drop}, but those names are already taken. \code{keep()} is similar to
\code{\link[=Filter]{Filter()}}, but the argument order is more convenient, and the
evaluation of the predicate function \code{.p} is stricter.
}
\examples{
rep(10, 10) \%>\%
  map(sample, 5) \%>\%
  keep(function(x) mean(x) > 6)

# Or use a formula
rep(10, 10) \%>\%
  map(sample, 5) \%>\%
  keep(~ mean(.x) > 6)

# Using a string instead of a function will select all list elements
# where that subelement is TRUE
x <- rerun(5, a = rbernoulli(1), b = sample(10))
x
x \%>\% keep("a")
x \%>\% discard("a")

# compact() discards elements that are NULL or that have length zero
list(a = "a", b = NULL, c = integer(0), d = NA, e = list()) \%>\%
  compact()
}
