% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate.R
\name{rate_sleep}
\alias{rate_sleep}
\alias{rate_reset}
\title{Wait for a given time}
\usage{
rate_sleep(rate, quiet = TRUE)

rate_reset(rate)
}
\arguments{
\item{rate}{A \link[=rate_backoff]{rate} object determining the waiting time.}

\item{quiet}{If \code{FALSE}, prints a message displaying how long until
the next request.}
}
\description{
If the rate's internal counter exceeds the maximum number of times
it is allowed to sleep, \code{rate_sleep()} throws an error of class
\code{purrr_error_rate_excess}.
}
\details{
Call \code{rate_reset()} to reset the internal rate counter to 0.
}
\seealso{
\code{\link[=rate_backoff]{rate_backoff()}}, \code{\link[=insistently]{insistently()}}
}
