% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{xml_parse_data}
\alias{xml_parse_data}
\title{Convert R parse data to XML}
\usage{
xml_parse_data(x, includeText = NA, pretty = FALSE)
}
\arguments{
\item{x}{
    an expression returned from \code{\link{parse}}, or a function or other
    object with source reference information
  }

\item{includeText}{
    logical; whether to include the text of parsed items in the result
  }

\item{pretty}{Whether to pretty-indent the XML output. It has a small
overhead which probably only matters for very large source files.}
}
\value{
An XML string representing the parse data. See details below.
}
\description{
In recent R versions the parser can attach source code location
information to the parsed expressions. This information is often
useful for static analysis, e.g. code linting. It can be accessed
via the \code{\link[utils]{getParseData}} function.
}
\details{
\code{xml_parse_data} converts this information to an XML tree.
The R parser's token names are preserved in the XML as much as
possible, but some of them are not valid XML tag names, so they are
renamed, see the \code{\link{xml_parse_token_map}} vector for the
mapping.

The top XML tag is \code{<exprlist>}, which is a list of
expressions, each expression is an \code{<expr>} tag. Each tag
has attributes that define the location: \code{line1}, \code{col1},
\code{line2}, \code{col2}. These are from the \code{\link{getParseData}}
data frame column names.

See an example below. See also the README at
\url{https://github.com/r-lib/xmlparsedata#readme}
for examples on how to search the XML tree with the \code{xml2} package
and XPath expressions.

Note that `xml_parse_data()` silently drops all control characters
(0x01-0x1f) from the input, except horizontal tab (0x09) and newline
(0x0a), because they are invalid in XML 1.0.
}
\examples{
code <- "function(a = 1, b = 2) {\\n  a + b\\n}\\n"
expr <- parse(text = code, keep.source = TRUE)

# The base R way:
getParseData(expr)

cat(xml_parse_data(expr, pretty = TRUE))
}
\seealso{
\code{\link{xml_parse_token_map}} for the token names.
\url{https://github.com/r-lib/xmlparsedata#readme} for more
information and use cases.
}
