#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

TMP_TEST_DB=samples.db
TMP_DB_FILE=${TMP_DB_DIR}/samples.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_FILE} <<EOF
create table sample (
   id integer primary key autoincrement,
   uuid char(36) unique,
   SolsaID char(12) unique,
   name text
);

create table experiment_xrd (
   id integer primary key autoincrement,
   uuid char(36) unique,
   sample_id int(11),
   title varchar(255),
   sample_preparation text,
   diffraction_file longblob,
   format varchar(255),
   mimetype varchar(255)
);

create table xrd_img (
   id integer primary key autoincrement,
   uuid char(36) unique,
   experiment_id int(11),
   caption varchar(255),
   image mediumblob,
   format varchar(4),
   -- enum('png','pnm','gif','jpeg')
   mimetype varchar(255),
   cssclass varchar(255),
   filename varchar(255)
);

insert into sample (id,uuid,SolsaID,name) values
    (1,"3129df14-4ec4-11e8-950f-cfc135e92040","VU-TEST-0001","Calcite"),
    (2,"45cb6e74-4ec4-11e8-ac0e-73a678ca22dc","VU-TEST-0002","Stromatolite")
;

insert into experiment_xrd
   (id,uuid,sample_id,title,sample_preparation,diffraction_file,format,mimetype)
values
   (1,"30d6b260-4ec6-11e8-a9a6-c3ad29f17976",1,
    "The first experiment","Synthering",
"_FILEVERSION = 3
_SAMPLE = ER-MT00-0007
_+SAMPLE
_USER = Lab Manager
_GONIOMETER_CODE = 21
_STAGE_CODE = 7
...
74.9248902616.000000
74.9547662728.000000
74.9846412635.000000
75.0145172614.000000",
    "TXT","text/plain")
;

insert into xrd_img
   (id,uuid,experiment_id,caption,image,format,mimetype,cssclass)
values
   (1,"a0c6dca4-4eca-11e8-9220-cbe0049450bd",1,
    "Fig. 1. A simple diamond",
    X'50320A3520350A310A3120312030203120310A3120302031203020310A3020312031203120300A3120302031203020310A312031203020312031',
    "PNM","image/png","smallimage"
)
;

EOF

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} <<EOF
insert into description 
    (id,dbname, dbtable, dbcolumn, coltype, fk_target, relation, visualisation)
values
    (1,"${TMP_DB_FILE_ABS}", "sample", "id", "id", NULL, NULL, NULL),

    (2,"${TMP_DB_FILE_ABS}", "experiment_xrd", "id", "id", NULL, NULL, NULL),
    (3,"${TMP_DB_FILE_ABS}", "experiment_xrd", "sample_id", "fk", 1, "N", NULL),

    (4,"${TMP_DB_FILE_ABS}", "experiment_xrd", "diffraction_file", "file", NULL, NULL, NULL),
    (5,"${TMP_DB_FILE_ABS}", "experiment_xrd", "mimetype", "mimetype", 4, NULL, NULL),
    (6,"${TMP_DB_FILE_ABS}", "experiment_xrd", "format", "format", 4, NULL, NULL),

    (7,"${TMP_DB_FILE_ABS}", "xrd_img", "experiment_id", "fk", 2, "N", NULL),
    (8,"${TMP_DB_FILE_ABS}", "xrd_img", "image", "", NULL, NULL, NULL),
    (9,"${TMP_DB_FILE_ABS}", "xrd_img", "format", "format", 8, 1, NULL),
    (10,"${TMP_DB_FILE_ABS}", "xrd_img", "mimetype", "mimetype", 8, 1, NULL),
    (11,"${TMP_DB_FILE_ABS}", "xrd_img", "cssclass", "cssclass", 8, 1, NULL),
    (12,"${TMP_DB_FILE_ABS}", "xrd_img", "filename", "filename", 8, 1, NULL)
;
EOF

## sqlite3 ${TMP_DB_FILE} 'select diffraction_file from experiment_xrd'
## sqlite3 ${TMP_DB_FILE} 'select image from xrd_img'

export REQUEST_URI='/~saulius/restful/website/samples.db/xrd_img'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=get
export QUERY_STRING=""
export REMOTE_USER=tester

${INPUT_SCRIPT} action=template

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
