#define XERR
#include "survival.ih"

void Survival::loadS3()
{
    auto lines = Parser::any({ "Tumor:", "S3:", "prob:" });

    bool push = true;
    while (true)
    {
        LineInfo const *line = lines.get();

        if (line == 0)                          // no (more) lines
            break;

        ProbGroup group;

        if (not Parser::extract(*line, group))
            push = false;
        
        if (not push)
            continue;                           // continue for syntax-check
                                                // purposes

        if (group.group().nextRange(d_s3))      // add the next range
        {
            d_s3.push_back(move(group));
            continue;
        }

        push = false;
    }
}
