## TFSA-2022-055: Heap OOB access in `RunForwardTypeInference`

### CVE Number
CVE-2022-23592

### Impact
TensorFlow's [type inference](https://github.com/tensorflow/tensorflow/blob/274df9b02330b790aa8de1cee164b70f72b9b244/tensorflow/core/graph/graph.cc#L223-L229) can cause a heap OOB read as the bounds checking is done in a `DCHECK` (which is a no-op during production):

```cc
if (node_t.type_id() != TFT_UNSET) {
  int ix = input_idx[i];
  DCHECK(ix < node_t.args_size())
      << "input " << i << " should have an output " << ix
      << " but instead only has " << node_t.args_size()
      << " outputs: " << node_t.DebugString();
  input_types.emplace_back(node_t.args(ix));
  // ...
}
```

An attacker can control `input_idx` such that `ix` would be larger than the number of values in `node_t.args`.

### Patches
We have patched the issue in GitHub commit [c99d98cd189839dcf51aee94e7437b54b31f8abd](https://github.com/tensorflow/tensorflow/commit/c99d98cd189839dcf51aee94e7437b54b31f8abd).

The fix will be included in TensorFlow 2.8.0. This is the only affected version.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
