/*
 * $Id: regex.h,v 1.1 2000/08/07 23:15:04 emmerson Exp $
 *
 * This file supports the POSIX.2 (yes, that's numeral two) regular 
 * expression API.  It does this via the LDM's regular expression API
 * unless we're on an AIX platform, in which case we use the native POSIX.2
 * API.
 */


#ifndef UD_REGEX_H
#define UD_REGEX_H


#include "udposix.h"


#if defined(_AIX)

#   include "///usr/include/regex.h"

#else

#   include "stddef.h"
#   include "regexp.h"		/* LDM's regular expression API */

    typedef struct regex {
	regexp		*regexp;
	size_t		re_nsub;
	int		cflags;
    } regex_t;

    typedef ptrdiff_t	regoff_t;

    typedef struct regmatch {
	regoff_t	rm_so;
	regoff_t	rm_eo;
    } regmatch_t;


    UD_EXTERN_FUNC(int ldm_regcomp, (
	regex_t		*preg,
	const char	*pattern,
	int		cflags		/* REG_NOSUB | REG_ICASE */
    ));
#   define REG_EXTENDED	1		/* use extended regular expressions */
#   define REG_ICASE	2		/* ignore case */
#   define REG_NOSUB	4		/* ignore subexpressions */
    UD_EXTERN_FUNC(int ldm_regexec, (
	const regex_t	*preg,
	const char	*string,
	size_t		nmatch,
	regmatch_t	pmatch[],
	int		eflags
    ));
    UD_EXTERN_FUNC(size_t ldm_regerror, (
	int		errcode,
	const regex_t	*preg,
	char		*errbuf,
	size_t		errbuf_size
    ));
    UD_EXTERN_FUNC(void ldm_regfree, (
	regex_t		*preg
    ));

    /*
     * Error codes for regcomp() and regexec():
     */
#   define REG_SUCCESS	0
#   define REG_NOMATCH	1
#   define REG_BADPAT	3
#   define REG_ESPACE	4
#   define REG_EINVAL	5

    /*
     * Define the POSIX.2 functions to our functions.
     */
#   define regcomp	ldm_regcomp
#   define regexec	ldm_regexec
#   define regerror	ldm_regerror
#   define regfree	ldm_regfree

#endif	/* not AIX */


#endif	/* header-file lockout */
