# 国际化
这个文档用于记录, 如何在 deepin 内部处理软件的国际化问题.
deepin 内部使用 transifex 来实现语言的国际化过程.

## 详细步骤
以 demo 作为示例项目.
* 在项目的根目录下创建.tx/config 文件, 目前支持 desktop 文件, gettext/po 以及 Qt/ts 这
 三种类型. 可以参考下面的模板.
```ini
[main]
host = https://www.transifex.com
minimum_perc = 80
mode = developer

[demo.demo]
file_filter = i18n/demo-<lang>.ts
source_file = i18n/demo.ts
source_lang = en
type = QT

[demo.demo-desktop]
source_file = resources/demo.desktop
source_lang = en
type = DESKTOP

[demo.demo-timezones]
file_filter = timezones/<lang>/timezones.po
source_file = timezones/system-config-date-timezones.pot
source_lang = en
type = PO

```

* 将代码 上传到 cr 上, 并完成 review 的过程.
* 在 transifex.com 网站上, 新建名称为 `demo` 的项目, 并根据说明, 填写好配置.
* 登录 https://ci.deepin.io, 在 https://ci.deepin.io/job/sync-transifex/configure
 设置页面, 将 `demo` 加入到构建过程的参数列表中, 并保存.
* 然后打开 ci 页面左侧的 "Build with Parameters", 在 ACTION 区域, 选择 "Upload Pot";
 然后在 PROJECT 区域, 选择 `demo@master`; 最后点击"开始构建"按钮.
* 成功完成以上过程之后, demo 项目的语言模板已经上传到了 transifex 网站上, 之后可以在这网站上
 手动翻译了.
* 翻译完成之后, 需要将翻译好的语言内容从 transifex 网站拉取下来, 打开
 https://ci.deepin.io/job/sync-transifex/build, 在 ACTION 区域, 选择 "Download Po";
 然后在 PROJECT 区域, 选择 `demo@master`; 最后点击"开始构建"按钮.
* 上一步的操作成功完成之后, 就可以将代码从cr上拉取到本地了.