# 系統監視器|deepin-system-monitor|

## 概述

系統監視器是一個對硬體負載、程式執行和系統服務，進行監測查看和管理的系統工具。系統監視器可以即時監控處理器狀態、記憶體占用率、網路上傳下載速度、還可以管理系統進程和應用進程，也支援搜尋進程和強制結束進程。


## 操作介紹

### 搜尋進程

1. 在系統監視器搜尋框中單擊 ![search](../common/search.svg)。
2. 輸入關鍵字，即時展示搜尋結果。   

### 硬體監控

在系統監視器中，單擊 ![icon_menu](../common/icon_menu.svg) > **檢視**， 選擇「舒展」或「簡潔」模式展示電腦的處理器、記憶體、網路和磁碟的的詳細訊息。

| 名稱   | 說明                                                     |
| ------ | -------------------------------------------------------- |
| 處理器 | 顯示處理器最近一段時間的執行負載情況。                   |
| 記憶體 | 顯示記憶體總量和目前占用量，交換空間大小和目前占用量。   |
| 網路   | 即時顯示目前網路上傳下載速度。                           |
| 磁碟   | 僅在「簡潔」檢視下顯示；即時顯示目前磁碟讀取與寫入速度。 |

![1|monitor](fig/expand.png)

![1|compact](fig/compact.png)

#### 查看硬體詳細訊息

您可以透過以下方法之一查看硬體的詳細訊息：

- 在系統監視器程式進程頁簽中，單擊左側處理器、記憶體、網路或磁碟區域，右側展示對應項的詳細訊息。
- 在系統監視器程式進程頁簽中，單擊左側 **詳細訊息**，右側預設展開處理器的詳細訊息，單擊圖示 ![down](../common/nextdown.svg) 展開下拉選單選項，選擇查看記憶體、網路或磁碟的詳細訊息。
- 進入 **控制中心 > 個性化 > 任務欄** 介面，在外掛程式區域選單中勾選 **系統監視器**，任務欄外掛程式區會顯示圖示 ![icon](../common/system_monitor.svg)，將遊標置於該圖示上，顯示處理器、記憶體及網路上傳、下載訊息；單擊該圖示，在彈出的縮略視窗中顯示處理器、網路、記憶體、磁碟和進程訊息，雙擊視窗中的某個區域（如網路區域），彈出系統監視器介面並顯示對應的詳細訊息。

>![notes](../common/notes.svg) 說明：在處理器詳細訊息頁面，單擊按鈕 ![icon](../common/change.svg) 查看處理器的總體利用率和個體利用率狀態。單擊 **隱藏詳情** 收起詳情頁。

![monitor](fig/detail.png)



### 程式進程管理

#### 切換進程標籤

您可以單擊介面右上角的圖示切換進程標籤，分別可以查看應用程式、我的進程和所有進程。

- 單擊圖示 ![monitor](fig/app_process.png) 切換到 **應用程式** 頁面。
- 單擊圖示 ![monitor](fig/my_process.png) 切換到 **我的進程** 頁面。
- 單擊圖示 ![monitor](fig/all_process.png) 切換到 **所有進程** 頁面。

![1|monitor](fig/tab_switch.png)

#### 調整進程排序

程式列表可以根據名稱、處理器、使用者、記憶體、共享記憶體、虛擬記憶體、上傳、下載、磁碟讀取、磁碟寫入、進程號、Nice、優先度等進行排列。

- 在系統監視器介面單擊程式列表頂部的標籤，程式會按照對應的標籤排序，多次單擊可以切換升序和降序。
- 在系統監視器介面右鍵單擊程式列表頂部的標籤欄，可以取消勾選標籤隱藏對應的標籤列，再次勾選可以復原顯示。

![1|sort](fig/sort.png)


#### 結束進程

您可以使用系統監視器結束應用程式。
1. 在系統監視器介面，右鍵單擊需要結束的進程。
2. 選擇 **結束進程**。
3. 在彈出視窗單擊 **結束進程**，確認結束該進程。

>![notes](../common/notes.svg) 說明：您也可以在右鍵選單中選擇 **強制結束進程**，強制結束進程可能會導致資料遺失，請謹慎操作。

![1|kill](fig/kill.png)



#### 結束圖形化應用程式

您可以使用系統監視器關閉桌面上圖形化的進程。

1. 在系統監視器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 選擇 **強制結束應用程式**。   
3. 根據螢幕提示在桌面上單擊想要關閉的應用視窗。
4. 在彈出的對話框中單擊 **強制結束**，確認結束該應用。

>![notes](../common/notes.svg) 說明：若要中止上述操作，可按下鍵盤上 **Esc** 鍵返回至系統監視器介面。


#### 暫停和繼續進程

您可以使用系統監視器暫停和繼續進程。

1. 在系統監視器介面，右鍵單擊一個進程。
2. 選擇 **暫停進程**，被暫停的進程會帶有暫停標籤。
3. 再次右鍵單擊被暫停的進程，選擇 **繼續進程** 可以繼續該進程。

![1|pause](fig/pause.png)

#### 改變進程優先度

1. 在系統監視器介面，右鍵單擊一個進程。
2. 選擇 **改變優先度** 進行設定。您還可以自訂程式的優先度。

![1|priority](fig/priority.png)

#### 開啟程式位置

1. 在系統監視器介面，右鍵單擊一個進程。
2. 選擇 **開啟程式位置**，打開該進程所在的資料夾位置。


#### 查看進程屬性

1. 在系統監視器介面，右鍵單擊一個進程。
2. 選擇 **屬性**，可以查看進程的名稱、命令列、啟動時間。

### 系統服務管理

您可以啟動、停止、重新啟動、設定啟動方式、重新整理系統服務進程。
在系統服務列表，禁止強制結束應用程式。

>![attention](../common/attention.svg) 注意：為系統更好的執行，請勿結束系統服務自身的進程以及根進程。

#### 啟動系統服務

1. 在系統監視器介面，選擇 **系統服務** 頁簽。
2. 選中某個未啟動的系統進程，右鍵單擊 **啟動**。
3. 彈出授權對話框，請輸入密碼授權。該系統服務的「啟動狀態」會置為「已啟動」。
4. 右鍵單擊已選中的系統進程，選擇 **設定啟動方式**，將啟動方式設定為自動或者手動。
5. 右鍵單擊 **重新整理**，重新整理服務列表。


#### 停止系統服務

1. 在系統監視器介面，選擇 **系統服務** 頁簽。
2. 選中某個已啟動的系統進程，右鍵單擊 **停止**。
3. 彈出授權對話框，請輸入密碼授權。該系統服務的「啟動狀態」會置為「未啟動」。
4. 右鍵單擊 **重新整理**，重新整理服務列表。

您也可以右鍵單擊 **重新啟動**，重新啟動系統服務。

## 主選單

在主選單中，您可以強制結束應用程式、切換檢視、切換視窗主題、查看說明手冊、了解系統監視器的更多訊息。

### 檢視

系統監視器提供了舒展模式和簡潔模式，您可以根據需要選擇展現監控訊息的模式。

1. 在系統監視器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **檢視**，選擇一種檢視模式。

>![notes](../common/notes.svg) 說明：舒展模式和簡潔模式僅在程式進程頁簽中展示。

### 設定

在系統監視器介面，單擊 ![icon_menu](../common/icon_menu.svg)，選擇 **設定**，您可以對系統防護和消息通知進行設定。

- **系統防護**：預設關閉，開啟系統防護後，可以對 **CPU占用**、**記憶體占用**、**預警間隔** 項各設定一個閾值，當系統檢測到監視項中的數值高於閾值時，會發出警告通知。

  >![notes](../common/notes.svg) 說明：如果 **安全中心 > 安全工具 > 系統安全等級** 設定為「高」時，系統防護功能會自動開啟；如果安全等級設定為「中」或者「低」，系統防護功能則自動關閉。

- **消息通知**：預設開啟，您可以單擊 **設定**，在控制中心選擇是否開啟或關閉消息通知。

![pic](fig/settings.png)

### 主題

視窗主題包含亮色主題、暗色主題和系統主題。

1. 在系統監視器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **主題**，選擇一個主題顏色。

### 說明

查看說明手冊，進一步了解和使用系統監視器。

1. 在系統監視器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **說明**。
3. 查看系統監視器的說明手冊。

### 關於

1. 在系統監視器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **關於**。
3. 查看關於系統監視器的版本和介紹。

### 退出

1. 在系統監視器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **退出**。

