/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;
import org.cojen.util.KeyFactory;
import org.cojen.util.SoftValuedHashMap;

public abstract class PatternMatcher {
    private static final int[] NO_POSITIONS = new int[0];
    private static Map cPatternMatcherClasses = new SoftValuedHashMap();
    protected final Object[] mValues;
    static /* synthetic */ Class class$org$cojen$util$PatternMatcher;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$util$List;

    public static synchronized PatternMatcher forPatterns(Map patternMap) {
        Maker maker = new Maker(patternMap);
        Class clazz = (Class)cPatternMatcherClasses.get(maker.getKey());
        if (clazz == null) {
            Class patternMatcherClass = class$org$cojen$util$PatternMatcher == null ? (class$org$cojen$util$PatternMatcher = PatternMatcher.class$("org.cojen.util.PatternMatcher")) : class$org$cojen$util$PatternMatcher;
            ClassInjector ci = ClassInjector.create(patternMatcherClass.getName(), patternMatcherClass.getClassLoader());
            ClassFile cf = maker.createClassFile(ci.getClassName());
            clazz = ci.defineClass(cf);
            cPatternMatcherClasses.put(maker.getKey(), clazz);
        }
        try {
            Constructor ctor = clazz.getConstructor(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = PatternMatcher.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            return (PatternMatcher)ctor.newInstance(maker.getMappedValues());
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
        catch (InstantiationException e) {
            throw new InternalError(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    protected PatternMatcher(Object[] values) {
        this.mValues = values;
    }

    public Result getMatch(String lookup) {
        int strLen = lookup.length();
        char[] chars = new char[strLen + 1];
        lookup.getChars(0, strLen, chars, 0);
        chars[strLen] = 65535;
        TinyList resultList = new TinyList();
        this.fillMatchResults(chars, 1, resultList);
        return (Result)resultList.mElement;
    }

    public Result[] getMatches(String lookup, int limit) {
        int strLen = lookup.length();
        char[] chars = new char[strLen + 1];
        lookup.getChars(0, strLen, chars, 0);
        chars[strLen] = 65535;
        ArrayList resultList = new ArrayList();
        this.fillMatchResults(chars, limit, resultList);
        return resultList.toArray(new Result[resultList.size()]);
    }

    protected abstract void fillMatchResults(char[] var1, int var2, List var3);

    protected static boolean addMatchResult(int limit, List results, String pattern, Object value, int[] positions, int len) {
        int size = results.size();
        if (size < limit) {
            if (positions == null || len == 0) {
                positions = NO_POSITIONS;
            } else {
                int[] original = positions;
                positions = new int[len];
                for (int i = 0; i < len; ++i) {
                    positions[i] = original[i];
                }
            }
            results.add(new Result(pattern, value, positions));
            return size + 1 < limit;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TinyList
    extends AbstractList {
        public Object mElement;

        private TinyList() {
        }

        public int size() {
            return this.mElement == null ? 0 : 1;
        }

        public boolean add(Object obj) {
            if (this.mElement == null) {
                this.mElement = obj;
                return true;
            }
            throw new UnsupportedOperationException();
        }

        public Object get(int index) {
            if (index == 0 && this.mElement != null) {
                return this.mElement;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    private static class PatternComparator
    implements Comparator {
        private PatternComparator() {
        }

        public int compare(Object a, Object b) {
            String sa = (String)a;
            String sb = (String)b;
            int alen = sa.length();
            int blen = sb.length();
            int mlen = Math.min(alen, blen);
            for (int i = 0; i < mlen; ++i) {
                char ca = sa.charAt(i);
                char cb = sb.charAt(i);
                if (ca == '*') {
                    if (cb == '*') continue;
                    return 1;
                }
                if (cb == '*') {
                    return -1;
                }
                if (ca < cb) {
                    return -1;
                }
                if (ca <= cb) continue;
                return 1;
            }
            if (alen < blen) {
                return 1;
            }
            if (alen > blen) {
                return -1;
            }
            return 0;
        }
    }

    private static class PatternNode {
        public final int mChar;
        public String mPattern;
        public int mOrder;
        public List mSubNodes;

        public PatternNode() {
            this.mChar = -1;
        }

        public PatternNode(char c) {
            this.mChar = c;
        }

        public void buildPathTo(String pattern, int order) {
            this.buildPathTo(pattern, order, 0);
        }

        public int getHeight() {
            int height = 1;
            if (this.mSubNodes != null) {
                int size = this.mSubNodes.size();
                for (int i = 0; i < size; ++i) {
                    int subH = ((PatternNode)this.mSubNodes.get(i)).getHeight();
                    if (subH <= height) continue;
                    height = subH;
                }
            }
            return height;
        }

        public int getWildcardCount() {
            int wildCount = 0;
            String pattern = this.mPattern;
            if (pattern != null) {
                int len = pattern.length();
                for (int i = 0; i < len; ++i) {
                    if (pattern.charAt(i) != '*') continue;
                    ++wildCount;
                }
            }
            return wildCount;
        }

        public int getMaxWildcardCount() {
            int wildCount = this.getWildcardCount();
            if (this.mSubNodes != null) {
                for (int i = 0; i < this.mSubNodes.size(); ++i) {
                    int count = ((PatternNode)this.mSubNodes.get(i)).getMaxWildcardCount();
                    if (count <= wildCount) continue;
                    wildCount = count;
                }
            }
            return wildCount;
        }

        private void buildPathTo(String pattern, int order, int index) {
            if (index >= pattern.length()) {
                if (pattern.endsWith("\uffff")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                this.mPattern = pattern;
                this.mOrder = order;
                return;
            }
            char c = pattern.charAt(index);
            if (this.mSubNodes == null) {
                this.mSubNodes = new ArrayList(10);
            }
            int size = this.mSubNodes.size();
            for (int i = 0; i < size; ++i) {
                PatternNode node = (PatternNode)this.mSubNodes.get(i);
                if (node.mChar != c) continue;
                node.buildPathTo(pattern, order, index + 1);
                return;
            }
            PatternNode node = new PatternNode(c);
            this.mSubNodes.add(node);
            node.buildPathTo(pattern, order, index + 1);
        }

        public void dump(PrintStream out, String indent) {
            if (this.mSubNodes != null) {
                String subIndent = indent.concat(" ");
                for (int i = 0; i < this.mSubNodes.size(); ++i) {
                    ((PatternNode)this.mSubNodes.get(i)).dump(out, subIndent);
                }
            }
            out.print(indent);
            out.print('\'');
            out.print((char)this.mChar);
            out.print('\'');
            if (this.mPattern != null) {
                out.print(" -> ");
                out.print(this.mPattern);
            }
            out.println();
        }
    }

    private static class Maker {
        private PatternNode mPatternRoot;
        private Object mKey;
        private Object[] mMappedValues;
        private int mMaxWildPerKey;
        private TypeDesc mIntType;
        private TypeDesc mBooleanType;
        private TypeDesc mListType;
        private TypeDesc mStringType;
        private TypeDesc mObjectType;
        private TypeDesc mIntArrayType;
        private CodeBuilder mBuilder;
        private LocalVariable mLookupLocal;
        private LocalVariable mLimitLocal;
        private LocalVariable mResultsLocal;
        private LocalVariable mPositionsLocal;
        private LocalVariable mIndexLocal;
        private Stack mTempLocals;
        private Label mReturnLabel;
        private int mReferenceLine;

        Maker(Map patternMap) {
            String key;
            int i;
            Object[] keys = patternMap.keySet().toArray(new String[0]);
            for (i = 0; i < keys.length; ++i) {
                key = keys[i];
                if (key.endsWith("*")) continue;
                keys[i] = key.concat("\uffff");
            }
            Arrays.sort(keys, new PatternComparator());
            this.mMappedValues = new Object[keys.length];
            for (i = 0; i < keys.length; ++i) {
                key = keys[i];
                if (key.endsWith("\uffff")) {
                    key = key.substring(0, key.length() - 1);
                }
                this.mMappedValues[i] = patternMap.get(key);
            }
            this.mPatternRoot = new PatternNode();
            for (i = 0; i < keys.length; ++i) {
                key = keys[i];
                this.mPatternRoot.buildPathTo(key, i);
            }
            this.mMaxWildPerKey = this.mPatternRoot.getMaxWildcardCount();
            this.mKey = KeyFactory.createKey(keys);
        }

        public Object getKey() {
            return this.mKey;
        }

        public Object getMappedValues() {
            return this.mMappedValues;
        }

        public ClassFile createClassFile(String className) {
            ClassFile cf = new ClassFile(className, class$org$cojen$util$PatternMatcher == null ? (class$org$cojen$util$PatternMatcher = PatternMatcher.class$("org.cojen.util.PatternMatcher")) : class$org$cojen$util$PatternMatcher);
            cf.markSynthetic();
            cf.setSourceFile((class$org$cojen$util$PatternMatcher == null ? (class$org$cojen$util$PatternMatcher = PatternMatcher.class$("org.cojen.util.PatternMatcher")) : class$org$cojen$util$PatternMatcher).getName());
            TypeDesc objectArrayType = TypeDesc.OBJECT.toArrayType();
            TypeDesc[] params = new TypeDesc[]{objectArrayType};
            MethodInfo mi = cf.addConstructor(Modifiers.PUBLIC, params);
            this.mBuilder = new CodeBuilder(mi);
            this.mBuilder.loadThis();
            this.mBuilder.loadLocal(this.mBuilder.getParameter(0));
            this.mBuilder.invokeSuperConstructor(params);
            this.mBuilder.returnVoid();
            this.mIntType = TypeDesc.INT;
            this.mBooleanType = TypeDesc.BOOLEAN;
            this.mListType = TypeDesc.forClass(class$java$util$List == null ? (class$java$util$List = PatternMatcher.class$("java.util.List")) : class$java$util$List);
            this.mStringType = TypeDesc.STRING;
            this.mObjectType = TypeDesc.OBJECT;
            this.mIntArrayType = TypeDesc.INT.toArrayType();
            TypeDesc charArrayType = TypeDesc.CHAR.toArrayType();
            params = new TypeDesc[]{charArrayType, this.mIntType, this.mListType};
            mi = cf.addMethod(Modifiers.PUBLIC, "fillMatchResults", null, params);
            this.mBuilder = new CodeBuilder(mi);
            this.mLookupLocal = this.mBuilder.getParameter(0);
            this.mLimitLocal = this.mBuilder.getParameter(1);
            this.mResultsLocal = this.mBuilder.getParameter(2);
            this.mPositionsLocal = this.mBuilder.createLocalVariable("positions", this.mIntArrayType);
            this.mIndexLocal = this.mBuilder.createLocalVariable("index", this.mIntType);
            this.mBuilder.mapLineNumber(++this.mReferenceLine);
            this.mBuilder.loadConstant(this.mMaxWildPerKey * 2);
            this.mBuilder.newObject(this.mIntArrayType);
            this.mBuilder.storeLocal(this.mPositionsLocal);
            this.mBuilder.loadConstant(0);
            this.mBuilder.storeLocal(this.mIndexLocal);
            this.mTempLocals = new Stack();
            this.mReturnLabel = this.mBuilder.createLabel();
            this.generateBranches(this.mPatternRoot, -1, 0);
            this.mReturnLabel.setLocation();
            this.mBuilder.returnVoid();
            return cf;
        }

        private void generateBranches(PatternNode node, int depth, int posIndex) {
            this.generateBranches(node, depth, posIndex, null);
        }

        private void generateBranches(PatternNode node, int depth, int posIndex, LocalVariable tempChar) {
            int c = node.mChar;
            List subNodes = node.mSubNodes;
            this.mBuilder.mapLineNumber(++this.mReferenceLine);
            if (c == 42) {
                LocalVariable savedIndex = this.mTempLocals.isEmpty() ? this.mBuilder.createLocalVariable("temp", this.mIntType) : (LocalVariable)this.mTempLocals.pop();
                this.mBuilder.loadLocal(this.mIndexLocal);
                this.mBuilder.storeLocal(savedIndex);
                this.mBuilder.loadLocal(this.mPositionsLocal);
                this.mBuilder.loadConstant(posIndex);
                this.mBuilder.loadLocal(this.mIndexLocal);
                if (depth > 0) {
                    this.mBuilder.loadConstant(depth);
                    this.mBuilder.math((byte)96);
                }
                this.mBuilder.storeToArray(TypeDesc.INT);
                if (subNodes == null) {
                    this.generateWildcard(null, depth, posIndex + 2);
                } else {
                    int size = subNodes.size();
                    for (int i = 0; i < size; ++i) {
                        this.generateWildcard((PatternNode)subNodes.get(i), depth, posIndex + 2);
                        this.mBuilder.loadLocal(savedIndex);
                        this.mBuilder.storeLocal(this.mIndexLocal);
                    }
                }
                this.mTempLocals.push(savedIndex);
                if (node.mPattern != null) {
                    this.generateAddMatchResult(node);
                }
                return;
            }
            Label noMatch = this.mBuilder.createLabel();
            if (c >= 0) {
                if (tempChar != null) {
                    this.mBuilder.loadLocal(tempChar);
                    this.mTempLocals.push(tempChar);
                } else {
                    this.mBuilder.loadLocal(this.mLookupLocal);
                    this.mBuilder.loadLocal(this.mIndexLocal);
                    if (depth > 0) {
                        this.mBuilder.loadConstant(depth);
                        this.mBuilder.math((byte)96);
                    }
                    this.mBuilder.loadFromArray(TypeDesc.CHAR);
                }
                this.mBuilder.loadConstant((char)c);
                this.mBuilder.ifComparisonBranch(noMatch, "!=");
            }
            if (subNodes != null) {
                int size = subNodes.size();
                for (int i = 0; i < size; ++i) {
                    this.generateBranches((PatternNode)subNodes.get(i), depth + 1, posIndex);
                }
            }
            if (node.mPattern != null) {
                this.generateAddMatchResult(node);
            }
            noMatch.setLocation();
        }

        private void generateWildcard(PatternNode node, int depth, int posIndex) {
            Label loopStart = this.mBuilder.createLabel().setLocation();
            Label loopEnd = this.mBuilder.createLabel();
            Label loopContinue = this.mBuilder.createLabel();
            this.mBuilder.loadLocal(this.mPositionsLocal);
            this.mBuilder.loadConstant(posIndex - 1);
            this.mBuilder.loadLocal(this.mIndexLocal);
            if (depth > 0) {
                this.mBuilder.loadConstant(depth);
                this.mBuilder.math((byte)96);
            }
            this.mBuilder.storeToArray(TypeDesc.INT);
            this.mBuilder.loadLocal(this.mLookupLocal);
            this.mBuilder.loadLocal(this.mIndexLocal);
            if (depth > 0) {
                this.mBuilder.loadConstant(depth);
                this.mBuilder.math((byte)96);
            }
            this.mBuilder.loadFromArray(TypeDesc.CHAR);
            if (node == null) {
                this.mBuilder.loadConstant(65535);
                this.mBuilder.ifComparisonBranch(loopEnd, "==");
            } else {
                LocalVariable tempChar = this.mTempLocals.isEmpty() ? this.mBuilder.createLocalVariable("temp", this.mIntType) : (LocalVariable)this.mTempLocals.pop();
                this.mBuilder.storeLocal(tempChar);
                this.mBuilder.loadLocal(tempChar);
                this.mBuilder.loadConstant(65535);
                this.mBuilder.ifComparisonBranch(loopEnd, "==");
                this.generateBranches(node, depth, posIndex, tempChar);
            }
            loopContinue.setLocation();
            this.mBuilder.integerIncrement(this.mIndexLocal, 1);
            this.mBuilder.branch(loopStart);
            loopEnd.setLocation();
        }

        private void generateAddMatchResult(PatternNode node) {
            this.mBuilder.mapLineNumber(++this.mReferenceLine);
            this.mBuilder.loadLocal(this.mLimitLocal);
            this.mBuilder.loadLocal(this.mResultsLocal);
            this.mBuilder.loadConstant(node.mPattern);
            this.mBuilder.loadThis();
            this.mBuilder.loadField("mValues", TypeDesc.OBJECT.toArrayType());
            this.mBuilder.loadConstant(node.mOrder);
            this.mBuilder.loadFromArray(TypeDesc.OBJECT);
            this.mBuilder.loadLocal(this.mPositionsLocal);
            this.mBuilder.loadConstant(node.getWildcardCount() * 2);
            TypeDesc[] params = new TypeDesc[]{this.mIntType, this.mListType, this.mStringType, this.mObjectType, this.mIntArrayType, this.mIntType};
            this.mBuilder.invokeStatic((class$org$cojen$util$PatternMatcher == null ? (class$org$cojen$util$PatternMatcher = PatternMatcher.class$("org.cojen.util.PatternMatcher")) : class$org$cojen$util$PatternMatcher).getName(), "addMatchResult", this.mBooleanType, params);
            this.mBuilder.ifZeroComparisonBranch(this.mReturnLabel, "==");
        }
    }

    public static class Result {
        private final String mPattern;
        private final Object mValue;
        private final int[] mPositions;

        Result(String pattern, Object value, int[] positions) {
            this.mPattern = pattern;
            this.mValue = value;
            this.mPositions = positions;
        }

        public String getPattern() {
            return this.mPattern;
        }

        public Object getValue() {
            return this.mValue;
        }

        public int[] getWildcardPositions() {
            return this.mPositions;
        }
    }
}

