/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QColor>
#include <QBrush>
#include <QDebug>
#include <QLinearGradient>
#include <QPainter>

#include "MvKeyProfile.h"

#include "MvQStepModel.h"
#include "MgQPlotScene.h"
#include "MgQSceneItem.h"


MvQStepDelegate::MvQStepDelegate(QWidget *parent) : QStyledItemDelegate(parent)
{
}

void MvQStepDelegate::paint(QPainter *painter,const QStyleOptionViewItem &option,
		           const QModelIndex& index) const
{
	QStyledItemDelegate::paint(painter,option,index);
	QRect rect = option.rect;
	QLine line(rect.x(),rect.y(),rect.x()+rect.width(),rect.y());

	painter->setPen(QPen("#BBBBBB"));
	painter->drawLine(line); 
}


MvQStepModel::MvQStepModel(QObject* parent) : MvQKeyProfileModel(parent)
{
	stepData_=0;
}

void MvQStepModel::stepDataIsAboutToChange()
{
	beginResetModel();
}

void MvQStepModel::setStepData(MgQSceneItem *data)
{
	stepData_=data;
    //endResetModel();
}

QVariant MvQStepModel::data( const QModelIndex& index, int role ) const
{
 	if ( !index.isValid())
	{
		return QVariant();
	}
	else if(role == Qt::UserRole )
	{
		if(messageFilterStatus_[index.row()] == true)
			return QString("1");
		else
			return QString("0");	
	
	}
	else if(role == Qt::BackgroundRole)
	{
        if(stepData_ && stepData_->stepCached(index.row()))
		{
			if(index.row() % 2 == 0)
				//return QBrush(QColor(70,180,40));
				//return QBrush(QColor(92,206,113)); 
				return QColor("#FFE6BF");
			else
				//return QBrush(QColor(187,238,202));
				return QColor("#FFF2DE");
		}	
		else
		{
			return QBrush(Qt::white); 
		}
	}
	else if(role == Qt::TextAlignmentRole)
	{
		if(profile_->at(index.column())->name() == "MV_Value")
			return Qt::AlignRight;
    		else
			return QVariant();
	}
	else if(role != Qt::DisplayRole )
        {	
		return QVariant();
	}

	//vector<magics::MagicsAnimationStepData> animation_;	

   	//QObject* obj = children(_widget)[index.row()];
 
	//return QString("1");
	return label(index.row(),index.column());
}
